#pragma once

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include <string>
#include <vector>

namespace registry
{
    enum class RegistryView
    {
        kRegistryViewDefault = 0,
        kRegistryView32 = 1,
        kRegistryView64 = 2,
    };

    std::string getString(const std::string& path, const std::string& key, const std::string& def, RegistryView view = RegistryView::kRegistryViewDefault);
    std::wstring getStringW(LPCWSTR path, LPCWSTR key, LPCWSTR def, RegistryView view = RegistryView::kRegistryViewDefault);
	void getKeyValues(const std::string& key, std::vector<std::string>& outKeys, std::vector<std::string>& outValues);
	bool getKeyValuesW(const std::string key, std::vector<std::string>& outKeys, std::vector<std::string>& outValues);
	unsigned int getUInt32(const std::string& path, const std::string& key, unsigned int def, RegistryView view);
	unsigned int getUInt32W(LPCWSTR path, LPCWSTR key, unsigned int def, RegistryView view);
	bool setUInt32(const std::string& path, const std::string& key, unsigned int val, RegistryView view);
	bool setUInt32W(LPCWSTR path, LPCWSTR key, DWORD val, RegistryView view);
	bool setString(const std::string& path, const std::string& key, const std::string& val, RegistryView view);
	bool setStringW(LPCWSTR path, LPCWSTR key, LPCWSTR val, RegistryView view);
    unsigned int getUInt32(LPCWSTR path, LPCWSTR key, unsigned int def, RegistryView view = RegistryView::kRegistryViewDefault);

    HKEY internalGetRoot(LPCWSTR& path);
    bool internalSetBinaryValue(HKEY root, LPCWSTR path, LPCWSTR key, LPCSTR val, RegistryView view);
    bool internalDeleteKey(HKEY root, LPCWSTR path, LPCWSTR key, RegistryView view);
}
