/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail.name;

import com.sourcetrail.name.DeclName;
import com.sourcetrail.name.NameElement;
import com.sourcetrail.name.NameHierarchy;
import com.sourcetrail.name.SymbolName;
import java.util.List;

public class TypeName
implements SymbolName {
    private DeclName m_parent = null;
    private String m_name = "";
    private List<String> m_typeParameterNames = null;
    private List<TypeName> m_typeArguments = null;
    private boolean m_isUnsolved = false;

    public static TypeName unsolved() {
        TypeName typeName = new TypeName("unsolved-type", null);
        typeName.m_isUnsolved = true;
        return typeName;
    }

    public static TypeName fromDotSeparatedString(String s) {
        TypeName typeName = null;
        int separatorIndex = s.lastIndexOf(46);
        typeName = separatorIndex != -1 ? new TypeName(s.substring(separatorIndex + 1), DeclName.fromDotSeparatedString(s.substring(0, separatorIndex))) : new TypeName(s, null);
        return typeName;
    }

    public TypeName(String name, DeclName parent) {
        this.m_parent = parent;
        this.m_name = name;
    }

    public TypeName(String name, List<String> typeParameterNames, List<TypeName> typeArguments, DeclName parent) {
        this.m_parent = parent;
        this.m_name = name;
        this.m_typeParameterNames = typeParameterNames;
        this.m_typeArguments = typeArguments;
    }

    public DeclName getParent() {
        return this.m_parent;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean getIsUnsolved() {
        return this.m_isUnsolved;
    }

    public DeclName toDeclName() {
        DeclName declName = new DeclName(this.m_name, this.m_typeParameterNames);
        declName.setParent(this.m_parent);
        return declName;
    }

    @Override
    public NameHierarchy toNameHierarchy() {
        NameHierarchy nameHierarchy = this.m_parent != null ? this.m_parent.toNameHierarchy() : new NameHierarchy();
        nameHierarchy.push(new NameElement(this.m_name + this.getTypeArgumentString()));
        return nameHierarchy;
    }

    public String toString() {
        Object string = "";
        if (this.m_parent != null) {
            string = this.m_parent.toString();
            string = (String)string + ".";
        }
        string = (String)string + this.m_name;
        string = (String)string + this.getTypeArgumentString();
        return string;
    }

    private String getTypeArgumentString() {
        Object string = "";
        if (this.m_typeArguments != null && !this.m_typeArguments.isEmpty()) {
            string = (String)string + "<";
            for (int i = 0; i < this.m_typeArguments.size(); ++i) {
                if (i != 0) {
                    string = (String)string + ", ";
                }
                string = (String)string + this.m_typeArguments.get(i).toString();
            }
            string = (String)string + ">";
        }
        return string;
    }
}

