/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail.gradle;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;

public class InfoRetriever {
    public static String getMainSrcDirs(String projectRootPath, String initScriptPath) {
        try {
            Object ret = "";
            List<String> srcDirs = InfoRetriever.getSrcDirs("printMainSrcDirs", projectRootPath, initScriptPath);
            for (int i = 0; i < srcDirs.size(); ++i) {
                if (i != 0) {
                    ret = (String)ret + ";";
                }
                ret = (String)ret + srcDirs.get(i);
            }
            return ret;
        }
        catch (GradleException e) {
            return "[ERROR] " + e.getMessage();
        }
    }

    public static String getTestSrcDirs(String projectRootPath, String initScriptPath) {
        try {
            Object ret = "";
            List<String> srcDirs = InfoRetriever.getSrcDirs("printTestSrcDirs", projectRootPath, initScriptPath);
            for (int i = 0; i < srcDirs.size(); ++i) {
                if (i != 0) {
                    ret = (String)ret + ";";
                }
                ret = (String)ret + srcDirs.get(i);
            }
            return ret;
        }
        catch (GradleException e) {
            return "[ERROR] " + e.getMessage();
        }
    }

    public static void copyCompileLibs(String projectRootPath, String initScriptPath, String targetPath) {
        InfoRetriever.executeTask("copyCompileLibs", projectRootPath, initScriptPath, Arrays.asList("-Psourcetrail_lib_path=" + targetPath));
    }

    public static void copyTestCompileLibs(String projectRootPath, String initScriptPath, String targetPath) {
        InfoRetriever.executeTask("copyTestCompileLibs", projectRootPath, initScriptPath, Arrays.asList("-Psourcetrail_lib_path=" + targetPath));
    }

    private static List<String> getSrcDirs(String taskName, String projectRootPath, String initScriptPath) {
        String output = InfoRetriever.executeTask(taskName, projectRootPath, initScriptPath, null);
        ArrayList<String> paths = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(output));){
            String line;
            while ((line = reader.readLine()) != null) {
                paths.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return paths;
    }

    private static String executeTask(String taskName, String projectRootPath, String initScriptPath, List<String> additionalArguments) throws GradleException {
        try (ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(new File(projectRootPath)).connect();){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            try {
                ArrayList<String> arguments = new ArrayList<String>();
                arguments.add("--init-script");
                arguments.add(initScriptPath);
                arguments.add("-q");
                if (additionalArguments != null) {
                    arguments.addAll(additionalArguments);
                }
                BuildLauncher Launcher = (BuildLauncher)((BuildLauncher)((BuildLauncher)connection.newBuild().forTasks(taskName).withArguments(arguments)).setStandardOutput(new PrintStream(outputStream))).setStandardError(new PrintStream(errorStream));
                Launcher.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!errorStream.toString().isEmpty()) {
                throw new GradleException(errorStream.toString());
            }
            String string = outputStream.toString();
            return string;
        }
    }
}

