/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail;

import com.sourcetrail.AccessKind;
import com.sourcetrail.AstVisitorClient;
import com.sourcetrail.DefinitionKind;
import com.sourcetrail.FileContent;
import com.sourcetrail.Range;
import com.sourcetrail.SymbolKind;
import com.sourcetrail.Utility;
import com.sourcetrail.name.DeclName;
import com.sourcetrail.name.NameHierarchy;
import com.sourcetrail.name.TypeName;
import com.sourcetrail.name.resolver.BindingNameResolver;
import java.io.File;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeMethodReference;

public class QualifierVisitor {
    protected AstVisitorClient m_client = null;
    private File m_filePath;
    private CompilationUnit m_compilationUnit;
    private boolean m_recordSymbolKinds = false;

    public QualifierVisitor(AstVisitorClient client, File filePath, CompilationUnit compilationUnit, boolean recordSymbolKinds) {
        this.m_client = client;
        this.m_filePath = filePath;
        this.m_compilationUnit = compilationUnit;
        this.m_recordSymbolKinds = recordSymbolKinds;
    }

    public void recordQualifierOfNode(ImportDeclaration node) {
        if (node != null && node.getName() instanceof QualifiedName) {
            this.recordNodeAsQualifier(((QualifiedName)node.getName()).getQualifier());
        }
    }

    public void recordQualifierOfNode(SimpleType node) {
        if (node != null && node.getName() instanceof QualifiedName) {
            this.recordNodeAsQualifier(((QualifiedName)node.getName()).getQualifier());
        }
    }

    public void recordQualifierOfNode(QualifiedType node) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getQualifier());
        }
    }

    public void recordQualifierOfNode(NameQualifiedType node) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getQualifier());
        }
    }

    public void recordQualifierOfNode(QualifiedName node) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getQualifier());
        }
    }

    public void recordQualifierOfNode(FieldAccess node, FileContent fileContent) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getExpression(), fileContent);
        }
    }

    public void recordQualifierOfNode(SuperFieldAccess node, FileContent fileContent) {
        if (node != null) {
            this.recordNodeAsQualifier((Expression)node, fileContent);
        }
    }

    public void recordQualifierOfNode(ThisExpression node, FileContent fileContent) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getQualifier());
        }
    }

    public void recordQualifierOfNode(MethodInvocation node, FileContent fileContent) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getExpression(), fileContent);
        }
    }

    public void recordQualifierOfNode(SuperMethodInvocation node, FileContent fileContent) {
        if (node != null) {
            ITypeBinding typeBinding;
            IMethodBinding methodBinding = node.resolveMethodBinding();
            if (methodBinding != null && (typeBinding = methodBinding.getDeclaringClass()) != null) {
                this.m_client.recordQualifierLocation(BindingNameResolver.getQualifiedName(typeBinding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), fileContent.findRange("super", this.getRange((ASTNode)node).begin));
            }
            this.recordNodeAsQualifier(node.getQualifier());
        }
    }

    public void recordQualifierOfNode(CreationReference node) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getType());
        }
    }

    public void recordQualifierOfNode(ExpressionMethodReference node, FileContent fileContent) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getExpression(), fileContent);
        }
    }

    public void recordQualifierOfNode(SuperMethodReference node, FileContent fileContent) {
        if (node != null) {
            ITypeBinding typeBinding;
            IMethodBinding methodBinding = node.resolveMethodBinding();
            if (methodBinding != null && (typeBinding = methodBinding.getDeclaringClass()) != null) {
                this.m_client.recordQualifierLocation(BindingNameResolver.getQualifiedName(typeBinding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), fileContent.findRange("super", this.getRange((ASTNode)node).begin));
            }
            this.recordNodeAsQualifier(node.getQualifier());
        }
    }

    public void recordQualifierOfNode(TypeMethodReference node) {
        if (node != null) {
            this.recordNodeAsQualifier(node.getType());
        }
    }

    private void recordNodeAsQualifier(Expression node, FileContent fileContent) {
        if (node != null) {
            if (node instanceof Name) {
                this.recordNodeAsQualifier((Name)node);
            } else if (node instanceof SuperFieldAccess) {
                SuperFieldAccess expression = (SuperFieldAccess)node;
                IVariableBinding fieldBinding = expression.resolveFieldBinding();
                if (fieldBinding != null) {
                    this.m_client.recordQualifierLocation(BindingNameResolver.getQualifiedName(fieldBinding.getDeclaringClass(), this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), fileContent.findRange("super", expression.getQualifier() != null ? this.getRange((ASTNode)expression.getQualifier()).end : this.getRange((ASTNode)expression).begin));
                }
                this.recordNodeAsQualifier(expression.getQualifier());
            } else if (node instanceof ThisExpression) {
                ThisExpression expression = (ThisExpression)node;
                this.m_client.recordQualifierLocation(BindingNameResolver.getQualifiedName(expression.resolveTypeBinding(), this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), fileContent.findRange("this", expression.getQualifier() != null ? this.getRange((ASTNode)expression.getQualifier()).end : this.getRange((ASTNode)expression).begin));
                this.recordNodeAsQualifier(expression.getQualifier());
            }
        }
    }

    private void recordNodeAsQualifier(Type node) {
        if (node != null) {
            if (node instanceof SimpleType) {
                this.recordNodeAsQualifier(((SimpleType)node).getName());
            } else if (node instanceof QualifiedType) {
                this.recordNodeAsQualifier((Name)((QualifiedType)node).getName());
                this.recordNodeAsQualifier(((QualifiedType)node).getQualifier());
            } else if (node instanceof NameQualifiedType) {
                this.recordNodeAsQualifier((Name)((NameQualifiedType)node).getName());
                this.recordNodeAsQualifier(((NameQualifiedType)node).getQualifier());
            }
        }
    }

    private void recordNodeAsQualifier(Name node) {
        if (node != null) {
            IBinding binding = node.resolveBinding();
            if (binding instanceof ITypeBinding) {
                Range range = this.getRange((ASTNode)node);
                if (node instanceof QualifiedName) {
                    range = this.getRange((ASTNode)((QualifiedName)node).getName());
                }
                this.m_client.recordQualifierLocation(BindingNameResolver.getQualifiedName((ITypeBinding)binding, this.m_filePath, this.m_compilationUnit).orElse(TypeName.unsolved()).toDeclName().toNameHierarchy(), range);
            } else if (binding instanceof IPackageBinding) {
                Range range = this.getRange((ASTNode)node);
                if (node instanceof QualifiedName) {
                    range = this.getRange((ASTNode)((QualifiedName)node).getName());
                }
                NameHierarchy symbolName = BindingNameResolver.getQualifiedName((IPackageBinding)binding, this.m_filePath, this.m_compilationUnit).orElse(DeclName.unsolved()).toNameHierarchy();
                if (this.m_recordSymbolKinds) {
                    this.m_client.recordSymbol(symbolName, SymbolKind.PACKAGE, AccessKind.NONE, DefinitionKind.NONE);
                }
                this.m_client.recordQualifierLocation(symbolName, range);
            }
            if (node instanceof QualifiedName) {
                this.recordNodeAsQualifier(((QualifiedName)node).getQualifier());
            }
        }
    }

    private Range getRange(ASTNode node) {
        return Utility.getRange(node, this.m_compilationUnit);
    }
}

