/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail;

import com.sourcetrail.AstVisitorClient;
import com.sourcetrail.ContextAwareAstVisitor;
import com.sourcetrail.JavaIndexerAstVisitorClient;
import com.sourcetrail.Range;
import com.sourcetrail.Utility;
import com.sourcetrail.VerboseContextAwareAstVisitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.PackageDeclaration;

public class JavaIndexer {
    public static void processFile(int address, String filePath, String fileContent, String languageStandard, String classPath, int verbose) {
        JavaIndexer.processFile(new JavaIndexerAstVisitorClient(address), filePath, fileContent, languageStandard, classPath, verbose);
    }

    public static void processFile(AstVisitorClient astVisitorClient, String filePath, String fileContent, String languageStandard, String classPath, int verbose) {
        try {
            astVisitorClient.logInfo("indexing source file: " + filePath);
            ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
            parser.setResolveBindings(true);
            parser.setKind(8);
            parser.setBindingsRecovery(true);
            parser.setStatementsRecovery(true);
            astVisitorClient.logInfo("using language standard " + languageStandard);
            Hashtable options = JavaCore.getOptions();
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
            options.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
            options.put("org.eclipse.jdt.core.compiler.source", languageStandard);
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", languageStandard);
            options.put("org.eclipse.jdt.core.compiler.compliance", languageStandard);
            parser.setCompilerOptions((Map)options);
            Path path = Paths.get(filePath, new String[0]);
            parser.setUnitName(path.getFileName().toString());
            ArrayList<String> classpath = new ArrayList<String>();
            ArrayList<String> sources = new ArrayList<String>();
            for (String classPathEntry : classPath.split("\\;")) {
                if (classPathEntry.endsWith(".jar")) {
                    classpath.add(classPathEntry);
                    continue;
                }
                if (classPathEntry.endsWith(".aar")) {
                    File extractedJarFile = JavaIndexer.extractClassesJarFileFromAarFile(Paths.get(classPathEntry, new String[0]), astVisitorClient);
                    if (extractedJarFile == null) continue;
                    classpath.add(extractedJarFile.getAbsolutePath());
                    continue;
                }
                if (classPathEntry.isEmpty()) continue;
                sources.add(classPathEntry);
            }
            parser.setEnvironment(classpath.toArray(new String[0]), sources.toArray(new String[0]), null, true);
            parser.setSource(fileContent.toCharArray());
            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
            ContextAwareAstVisitor visitor = verbose != 0 ? new VerboseContextAwareAstVisitor(astVisitorClient, path.toFile(), fileContent, compilationUnit) : new ContextAwareAstVisitor(astVisitorClient, path.toFile(), fileContent, compilationUnit);
            astVisitorClient.logInfo("starting AST traversal");
            compilationUnit.accept((ASTVisitor)visitor);
            for (IProblem problem : compilationUnit.getProblems()) {
                if (!problem.isError()) continue;
                Range range = new Range(compilationUnit.getLineNumber(problem.getSourceStart()), compilationUnit.getColumnNumber(problem.getSourceStart() + 1), compilationUnit.getLineNumber(problem.getSourceEnd()), compilationUnit.getColumnNumber(problem.getSourceEnd()) + 1);
                astVisitorClient.recordError(problem.getMessage(), false, true, range);
            }
            for (Object commentObject : compilationUnit.getCommentList()) {
                if (!(commentObject instanceof LineComment) && !(commentObject instanceof BlockComment)) continue;
                ((Comment)commentObject).accept((ASTVisitor)visitor);
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            astVisitorClient.logError(sw.toString());
        }
    }

    public static String getPackageName(String fileContent) {
        String packageName = "";
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setKind(8);
        parser.setSource(fileContent.toCharArray());
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        PackageDeclaration packageDeclaration = cu.getPackage();
        if (packageDeclaration != null) {
            packageName = packageDeclaration.getName().getFullyQualifiedName();
        }
        return packageName;
    }

    public static void clearCaches() {
        Runtime.getRuntime().gc();
    }

    private static File extractClassesJarFileFromAarFile(Path aarFilePath, AstVisitorClient astVisitorClient) throws IOException {
        JarFile jarFile = new JarFile(aarFilePath.toString());
        ZipEntry classesJarEntry = jarFile.getEntry("classes.jar");
        if (classesJarEntry != null) {
            try (InputStream inputStream = jarFile.getInputStream(classesJarEntry);){
                File tempFile = File.createTempFile("jar_file_from_" + Utility.getFilenameWithoutExtension(aarFilePath) + "_", ".jar");
                tempFile.deleteOnExit();
                byte[] buffer = new byte[8192];
                try (FileOutputStream output = new FileOutputStream(tempFile);){
                    int bytesRead;
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        ((OutputStream)output).write(buffer, 0, bytesRead);
                    }
                }
                astVisitorClient.logInfo("Extracted classes.jar file from \"" + aarFilePath.toString() + "\" to \"" + tempFile.getAbsolutePath() + "\". This file will be automatically deleted when the session ends.");
                File file = tempFile;
                return file;
            }
        }
        astVisitorClient.logError("Classpath entry \"" + String.valueOf(aarFilePath) + "\" is malformed. No internal \"classes.jar\" entry could be found.");
        jarFile.close();
        File file = null;
        return file;
        finally {
            jarFile.close();
        }
    }

    public static native boolean getInterrupted(int var0);

    public static native void logInfo(int var0, String var1);

    public static native void logWarning(int var0, String var1);

    public static native void logError(int var0, String var1);

    public static native void recordSymbol(int var0, String var1, int var2, int var3, int var4);

    public static native void recordSymbolWithLocation(int var0, String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static native void recordSymbolWithLocationAndScope(int var0, String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    public static native void recordSymbolWithLocationAndScopeAndSignature(int var0, String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static native void recordReference(int var0, int var1, String var2, String var3, int var4, int var5, int var6, int var7);

    public static native void recordQualifierLocation(int var0, String var1, int var2, int var3, int var4, int var5);

    public static native void recordLocalSymbol(int var0, String var1, int var2, int var3, int var4, int var5);

    public static native void recordComment(int var0, int var1, int var2, int var3, int var4);

    public static native void recordError(int var0, String var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

