"""
MAVLink protocol implementation (auto-generated by mavgen.py)

Generated from: ('AVSSUAS.xml,common.xml,standard.xml,minimal.xml',)

Note: this file has been auto-generated. DO NOT EDIT
"""
import hashlib
import json
import logging
import os
import struct
import sys
import time
from builtins import object, range
from typing import Any, Callable, Dict, Iterable, List, Mapping, Optional, Sequence, Tuple, Type, Union

WIRE_PROTOCOL_VERSION = "2.0"
DIALECT = "AVSSUAS"

PROTOCOL_MARKER_V1 = 0xFE
PROTOCOL_MARKER_V2 = 0xFD
HEADER_LEN_V1 = 6
HEADER_LEN_V2 = 10

MAVLINK_SIGNATURE_BLOCK_LEN = 13

MAVLINK_IFLAG_SIGNED = 0x01

logger = logging.getLogger(__name__)

# allow MAV_IGNORE_CRC=1 to ignore CRC, allowing some
# corrupted msgs to be seen
MAVLINK_IGNORE_CRC = os.environ.get("MAV_IGNORE_CRC", 0)

# some base types from mavlink_types.h
MAVLINK_TYPE_CHAR = 0
MAVLINK_TYPE_UINT8_T = 1
MAVLINK_TYPE_INT8_T = 2
MAVLINK_TYPE_UINT16_T = 3
MAVLINK_TYPE_INT16_T = 4
MAVLINK_TYPE_UINT32_T = 5
MAVLINK_TYPE_INT32_T = 6
MAVLINK_TYPE_UINT64_T = 7
MAVLINK_TYPE_INT64_T = 8
MAVLINK_TYPE_FLOAT = 9
MAVLINK_TYPE_DOUBLE = 10

# CRC calculation using fastcrc, falling back to a pure Python implementation
# if fastcrc is not available
try:
    import fastcrc
    mcrf4xx = fastcrc.crc16.mcrf4xx
except Exception:
    mcrf4xx = None  # type: ignore


BytesLike = Union[List[int], Tuple[int], bytes, bytearray, str]


class _x25crc_slow(object):
    """CRC-16/MCRF4XX - based on checksum.h from mavlink library"""

    crc: int

    def __init__(self, buf: Optional[BytesLike] = None):
        self.crc = 0xFFFF
        if buf is not None:
            self.accumulate(buf)

    def accumulate(self, buf: BytesLike) -> None:
        """add in some more bytes (it also accepts strings)"""
        if isinstance(buf, str):
            buf = buf.encode()

        accum = self.crc
        for b in buf:
            tmp = b ^ (accum & 0xFF)
            tmp = (tmp ^ (tmp << 4)) & 0xFF
            accum = (accum >> 8) ^ (tmp << 8) ^ (tmp << 3) ^ (tmp >> 4)
        self.crc = accum


class _x25crc_fast(object):
    """CRC-16/MCRF4XX - based on checksum.h from mavlink library"""

    def __init__(self, buf: Optional[BytesLike] = None):
        self.crc = 0xFFFF
        if buf is not None:
            self.accumulate(buf)

    def accumulate(self, buf: BytesLike) -> None:
        """add in some more bytes (it also accepts strings)"""
        if isinstance(buf, str):
            buf_as_bytes = bytes(buf.encode())
        elif isinstance(buf, (list, tuple, bytearray)):
            buf_as_bytes = bytes(buf)
        else:
            buf_as_bytes = buf
        self.crc = mcrf4xx(buf_as_bytes, self.crc)


x25crc = _x25crc_fast if mcrf4xx is not None else _x25crc_slow


class MAVLink_header(object):
    """MAVLink message header"""

    def __init__(self, msgId: int, incompat_flags: int = 0, compat_flags: int = 0, mlen: int = 0, seq: int = 0, srcSystem: int = 0, srcComponent: int = 0) -> None:
        self.mlen = mlen
        self.seq = seq
        self.srcSystem = srcSystem
        self.srcComponent = srcComponent
        self.msgId = msgId
        self.incompat_flags = incompat_flags
        self.compat_flags = compat_flags

    def pack(self, force_mavlink1: bool = False) -> bytes:
        if float(WIRE_PROTOCOL_VERSION) == 2.0 and not force_mavlink1:
            return struct.pack(
                "<BBBBBBBHB",
                253,
                self.mlen,
                self.incompat_flags,
                self.compat_flags,
                self.seq,
                self.srcSystem,
                self.srcComponent,
                self.msgId & 0xFFFF,
                self.msgId >> 16,
            )
        return struct.pack(
            "<BBBBBB",
            PROTOCOL_MARKER_V1,
            self.mlen,
            self.seq,
            self.srcSystem,
            self.srcComponent,
            self.msgId,
        )


class MAVLink_message(object):
    """base MAVLink message class"""

    id = 0
    msgname = ""
    fieldnames: List[str] = []
    ordered_fieldnames: List[str] = []
    fieldtypes: List[str] = []
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"")
    orders: List[int] = []
    lengths: List[int] = []
    array_lengths: List[int] = []
    crc_extra = 0
    unpacker = struct.Struct("")
    instance_field: Optional[str] = None
    instance_offset = -1

    def __init__(self, msgId: int, name: str) -> None:
        self._header = MAVLink_header(msgId)
        self._payload: Optional[bytes] = None
        self._msgbuf = bytearray(b"")
        self._crc: Optional[int] = None
        self._fieldnames: List[str] = []
        self._type = name
        self._signed = False
        self._link_id: Optional[int] = None
        self._instances: Optional[Dict[str, str]] = None
        self._instance_field: Optional[str] = None

    def format_attr(self, field: str) -> Union[str, float, int]:
        """override field getter"""
        raw_attr: Union[bytes, float, int] = getattr(self, field)
        if isinstance(raw_attr, bytes):
            return raw_attr.decode(errors="backslashreplace").rstrip("\x00")
        return raw_attr

    def get_msgbuf(self) -> bytearray:
        return self._msgbuf

    def get_header(self) -> MAVLink_header:
        return self._header

    def get_payload(self) -> Optional[bytes]:
        return self._payload

    def get_crc(self) -> Optional[int]:
        return self._crc

    def get_fieldnames(self) -> List[str]:
        return self._fieldnames

    def get_type(self) -> str:
        return self._type

    def get_msgId(self) -> int:
        return self._header.msgId

    def get_srcSystem(self) -> int:
        return self._header.srcSystem

    def get_srcComponent(self) -> int:
        return self._header.srcComponent

    def get_seq(self) -> int:
        return self._header.seq

    def get_signed(self) -> bool:
        return self._signed

    def get_link_id(self) -> Optional[int]:
        return self._link_id

    def __str__(self) -> str:
        ret = "%s {" % self._type
        for a in self._fieldnames:
            v = self.format_attr(a)
            ret += "%s : %s, " % (a, v)
        ret = ret[0:-2] + "}"
        return ret

    def __ne__(self, other: object) -> bool:
        return not self.__eq__(other)

    def __eq__(self, other: object) -> bool:
        if other is None:
            return False

        if not isinstance(other, MAVLink_message):
            return False

        if self.get_type() != other.get_type():
            return False

        if self.get_crc() != other.get_crc():
            return False

        if self.get_seq() != other.get_seq():
            return False

        if self.get_srcSystem() != other.get_srcSystem():
            return False

        if self.get_srcComponent() != other.get_srcComponent():
            return False

        for a in self._fieldnames:
            if self.format_attr(a) != other.format_attr(a):
                return False

        return True

    def to_dict(self) -> Dict[str, Union[str, float, int]]:
        d: Dict[str, Union[str, float, int]] = {}
        d["mavpackettype"] = self._type
        for a in self._fieldnames:
            d[a] = self.format_attr(a)
        return d

    def to_json(self) -> str:
        return json.dumps(self.to_dict())

    def sign_packet(self, mav: "MAVLink") -> None:
        assert mav.signing.secret_key is not None

        h = hashlib.new("sha256")
        self._msgbuf += struct.pack("<BQ", mav.signing.link_id, mav.signing.timestamp)[:7]
        h.update(mav.signing.secret_key)
        h.update(self._msgbuf)
        sig = h.digest()[:6]
        self._msgbuf += sig
        mav.signing.timestamp += 1

    def _pack(self, mav: "MAVLink", crc_extra: int, payload: bytes, force_mavlink1: bool = False) -> bytes:
        plen = len(payload)
        if float(WIRE_PROTOCOL_VERSION) == 2.0 and not force_mavlink1:
            # in MAVLink2 we can strip trailing zeros off payloads. This allows for simple
            # variable length arrays and smaller packets
            nullbyte = 0
            while plen > 1 and payload[plen - 1] == nullbyte:
                plen -= 1
        self._payload = payload[:plen]
        incompat_flags = 0
        if mav.signing.sign_outgoing:
            incompat_flags |= MAVLINK_IFLAG_SIGNED
        self._header = MAVLink_header(
            self._header.msgId,
            incompat_flags=incompat_flags,
            compat_flags=0,
            mlen=len(self._payload),
            seq=mav.seq,
            srcSystem=mav.srcSystem,
            srcComponent=mav.srcComponent,
        )
        self._msgbuf = bytearray(self._header.pack(force_mavlink1=force_mavlink1))
        self._msgbuf += self._payload
        crc = x25crc(self._msgbuf[1:])
        if True:
            # we are using CRC extra
            crc.accumulate(struct.pack("B", crc_extra))
        self._crc = crc.crc
        self._msgbuf += struct.pack("<H", self._crc)
        if mav.signing.sign_outgoing and not force_mavlink1:
            self.sign_packet(mav)
        return bytes(self._msgbuf)

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        raise NotImplementedError("MAVLink_message cannot be serialized directly")

    def __getitem__(self, key: str) -> str:
        """support indexing, allowing for multi-instance sensors in one message"""
        if self._instances is None:
            raise IndexError()
        if key not in self._instances:
            raise IndexError()
        return self._instances[key]


class mavlink_msg_deprecated_name_property(object):
    """
    This handles the class variable name change from name to msgname for
    subclasses of MAVLink_message during a transition period.

    This is used by setting the class variable to
    `mavlink_msg_deprecated_name_property()`.
    """

    def __get__(self, instance: Optional[MAVLink_message], owner: Type[MAVLink_message]) -> str:
        if instance is not None:
            logger.error("Using .name on a MAVLink_message is not supported, use .get_type() instead.")
            raise AttributeError("Class {} has no attribute 'name'".format(owner.__name__))
        logger.warning(
            """Using .name on a MAVLink_message class is deprecated, consider using .msgname instead.
Note that if compatibility with pymavlink 2.4.30 and earlier is desired, use something like this:

msg_name =  msg.msgname if hasattr(msg, "msgname") else msg.name"""
        )
        return owner.msgname


# enums


class EnumEntry(object):
    def __init__(self, name: str, description: str) -> None:
        self.name = name
        self.description = description
        self.param: Dict[int, str] = {}
        self.has_location = False

class Enum(Dict[int, EnumEntry]):
    def __init__(self) -> None:
        self.bitmask = False

enums: Dict[str, Enum] = {}

# MAV_CMD
enums["MAV_CMD"] = Enum()
enums["MAV_CMD"].bitmask = False
MAV_CMD_NAV_WAYPOINT = 16
enums["MAV_CMD"][16] = EnumEntry("MAV_CMD_NAV_WAYPOINT", """Navigate to waypoint. This is intended for use in missions (for guided commands outside of missions use MAV_CMD_DO_REPOSITION).""")
enums["MAV_CMD"][16].has_location = True
enums["MAV_CMD"][16].param[1] = """Hold time. (ignored by fixed wing, time to stay at waypoint for rotary wing)"""
enums["MAV_CMD"][16].param[2] = """Acceptance radius (if the sphere with this radius is hit, the waypoint counts as reached)"""
enums["MAV_CMD"][16].param[3] = """0 to pass through the WP, if > 0 radius to pass by WP. Positive value for clockwise orbit, negative value for counter-clockwise orbit. Allows trajectory control."""
enums["MAV_CMD"][16].param[4] = """Desired yaw angle at waypoint (rotary wing). NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.)."""
enums["MAV_CMD"][16].param[5] = """Latitude"""
enums["MAV_CMD"][16].param[6] = """Longitude"""
enums["MAV_CMD"][16].param[7] = """Altitude"""
MAV_CMD_NAV_LOITER_UNLIM = 17
enums["MAV_CMD"][17] = EnumEntry("MAV_CMD_NAV_LOITER_UNLIM", """Loiter around this waypoint an unlimited amount of time""")
enums["MAV_CMD"][17].has_location = True
enums["MAV_CMD"][17].param[1] = """Empty"""
enums["MAV_CMD"][17].param[2] = """Empty"""
enums["MAV_CMD"][17].param[3] = """Loiter radius around waypoint for forward-only moving vehicles (not multicopters). If positive loiter clockwise, else counter-clockwise"""
enums["MAV_CMD"][17].param[4] = """Desired yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.)."""
enums["MAV_CMD"][17].param[5] = """Latitude"""
enums["MAV_CMD"][17].param[6] = """Longitude"""
enums["MAV_CMD"][17].param[7] = """Altitude"""
MAV_CMD_NAV_LOITER_TURNS = 18
enums["MAV_CMD"][18] = EnumEntry("MAV_CMD_NAV_LOITER_TURNS", """Loiter around this waypoint for X turns""")
enums["MAV_CMD"][18].has_location = True
enums["MAV_CMD"][18].param[1] = """Number of turns."""
enums["MAV_CMD"][18].param[2] = """Empty"""
enums["MAV_CMD"][18].param[3] = """Radius around waypoint. If positive loiter clockwise, else counter-clockwise"""
enums["MAV_CMD"][18].param[4] = """Forward moving aircraft this sets exit xtrack location: 0 for center of loiter wp, 1 for exit location. Else, this is desired yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.)."""
enums["MAV_CMD"][18].param[5] = """Latitude"""
enums["MAV_CMD"][18].param[6] = """Longitude"""
enums["MAV_CMD"][18].param[7] = """Altitude"""
MAV_CMD_NAV_LOITER_TIME = 19
enums["MAV_CMD"][19] = EnumEntry("MAV_CMD_NAV_LOITER_TIME", """Loiter around this waypoint for X seconds""")
enums["MAV_CMD"][19].has_location = True
enums["MAV_CMD"][19].param[1] = """Loiter time."""
enums["MAV_CMD"][19].param[2] = """Empty"""
enums["MAV_CMD"][19].param[3] = """Radius around waypoint. If positive loiter clockwise, else counter-clockwise."""
enums["MAV_CMD"][19].param[4] = """Forward moving aircraft this sets exit xtrack location: 0 for center of loiter wp, 1 for exit location. Else, this is desired yaw angle.  NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.)."""
enums["MAV_CMD"][19].param[5] = """Latitude"""
enums["MAV_CMD"][19].param[6] = """Longitude"""
enums["MAV_CMD"][19].param[7] = """Altitude"""
MAV_CMD_NAV_RETURN_TO_LAUNCH = 20
enums["MAV_CMD"][20] = EnumEntry("MAV_CMD_NAV_RETURN_TO_LAUNCH", """Return to launch location""")
enums["MAV_CMD"][20].param[1] = """Empty"""
enums["MAV_CMD"][20].param[2] = """Empty"""
enums["MAV_CMD"][20].param[3] = """Empty"""
enums["MAV_CMD"][20].param[4] = """Empty"""
enums["MAV_CMD"][20].param[5] = """Empty"""
enums["MAV_CMD"][20].param[6] = """Empty"""
enums["MAV_CMD"][20].param[7] = """Empty"""
MAV_CMD_NAV_LAND = 21
enums["MAV_CMD"][21] = EnumEntry("MAV_CMD_NAV_LAND", """Land at location.""")
enums["MAV_CMD"][21].has_location = True
enums["MAV_CMD"][21].param[1] = """Minimum target altitude if landing is aborted (0 = undefined/use system default)."""
enums["MAV_CMD"][21].param[2] = """Precision land mode."""
enums["MAV_CMD"][21].param[3] = """Empty."""
enums["MAV_CMD"][21].param[4] = """Desired yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.)."""
enums["MAV_CMD"][21].param[5] = """Latitude."""
enums["MAV_CMD"][21].param[6] = """Longitude."""
enums["MAV_CMD"][21].param[7] = """Landing altitude (ground level in current frame)."""
MAV_CMD_NAV_TAKEOFF = 22
enums["MAV_CMD"][22] = EnumEntry("MAV_CMD_NAV_TAKEOFF", """Takeoff from ground / hand. Vehicles that support multiple takeoff modes (e.g. VTOL quadplane) should take off using the currently configured mode.""")
enums["MAV_CMD"][22].has_location = True
enums["MAV_CMD"][22].param[1] = """Minimum pitch (if airspeed sensor present), desired pitch without sensor"""
enums["MAV_CMD"][22].param[2] = """Empty"""
enums["MAV_CMD"][22].param[3] = """Empty"""
enums["MAV_CMD"][22].param[4] = """Yaw angle (if magnetometer present), ignored without magnetometer. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.)."""
enums["MAV_CMD"][22].param[5] = """Latitude"""
enums["MAV_CMD"][22].param[6] = """Longitude"""
enums["MAV_CMD"][22].param[7] = """Altitude"""
MAV_CMD_NAV_LAND_LOCAL = 23
enums["MAV_CMD"][23] = EnumEntry("MAV_CMD_NAV_LAND_LOCAL", """Land at local position (local frame only)""")
enums["MAV_CMD"][23].has_location = True
enums["MAV_CMD"][23].param[1] = """Landing target number (if available)"""
enums["MAV_CMD"][23].param[2] = """Maximum accepted offset from desired landing position - computed magnitude from spherical coordinates: d = sqrt(x^2 + y^2 + z^2), which gives the maximum accepted distance between the desired landing position and the position where the vehicle is about to land"""
enums["MAV_CMD"][23].param[3] = """Landing descend rate"""
enums["MAV_CMD"][23].param[4] = """Desired yaw angle"""
enums["MAV_CMD"][23].param[5] = """Y-axis position"""
enums["MAV_CMD"][23].param[6] = """X-axis position"""
enums["MAV_CMD"][23].param[7] = """Z-axis / ground level position"""
MAV_CMD_NAV_TAKEOFF_LOCAL = 24
enums["MAV_CMD"][24] = EnumEntry("MAV_CMD_NAV_TAKEOFF_LOCAL", """Takeoff from local position (local frame only)""")
enums["MAV_CMD"][24].has_location = True
enums["MAV_CMD"][24].param[1] = """Minimum pitch (if airspeed sensor present), desired pitch without sensor"""
enums["MAV_CMD"][24].param[2] = """Empty"""
enums["MAV_CMD"][24].param[3] = """Takeoff ascend rate"""
enums["MAV_CMD"][24].param[4] = """Yaw angle (if magnetometer or another yaw estimation source present), ignored without one of these"""
enums["MAV_CMD"][24].param[5] = """Y-axis position"""
enums["MAV_CMD"][24].param[6] = """X-axis position"""
enums["MAV_CMD"][24].param[7] = """Z-axis position"""
MAV_CMD_NAV_FOLLOW = 25
enums["MAV_CMD"][25] = EnumEntry("MAV_CMD_NAV_FOLLOW", """Vehicle following, i.e. this waypoint represents the position of a moving vehicle""")
enums["MAV_CMD"][25].has_location = True
enums["MAV_CMD"][25].param[1] = """Following logic to use (e.g. loitering or sinusoidal following) - depends on specific autopilot implementation"""
enums["MAV_CMD"][25].param[2] = """Ground speed of vehicle to be followed"""
enums["MAV_CMD"][25].param[3] = """Radius around waypoint. If positive loiter clockwise, else counter-clockwise"""
enums["MAV_CMD"][25].param[4] = """Desired yaw angle."""
enums["MAV_CMD"][25].param[5] = """Latitude"""
enums["MAV_CMD"][25].param[6] = """Longitude"""
enums["MAV_CMD"][25].param[7] = """Altitude"""
MAV_CMD_NAV_CONTINUE_AND_CHANGE_ALT = 30
enums["MAV_CMD"][30] = EnumEntry("MAV_CMD_NAV_CONTINUE_AND_CHANGE_ALT", """Continue on the current course and climb/descend to specified altitude.  When the altitude is reached continue to the next command (i.e., don't proceed to the next command until the desired altitude is reached.""")
enums["MAV_CMD"][30].param[1] = """Climb or Descend (0 = Neutral, command completes when within 5m of this command's altitude, 1 = Climbing, command completes when at or above this command's altitude, 2 = Descending, command completes when at or below this command's altitude."""
enums["MAV_CMD"][30].param[2] = """Empty"""
enums["MAV_CMD"][30].param[3] = """Empty"""
enums["MAV_CMD"][30].param[4] = """Empty"""
enums["MAV_CMD"][30].param[5] = """Empty"""
enums["MAV_CMD"][30].param[6] = """Empty"""
enums["MAV_CMD"][30].param[7] = """Desired altitude"""
MAV_CMD_NAV_LOITER_TO_ALT = 31
enums["MAV_CMD"][31] = EnumEntry("MAV_CMD_NAV_LOITER_TO_ALT", """Begin loiter at the specified Latitude and Longitude.  If Lat=Lon=0, then loiter at the current position.  Don't consider the navigation command complete (don't leave loiter) until the altitude has been reached. Additionally, if the Heading Required parameter is non-zero the aircraft will not leave the loiter until heading toward the next waypoint.""")
enums["MAV_CMD"][31].has_location = True
enums["MAV_CMD"][31].param[1] = """Leave loiter circle only when track heading towards the next waypoint (MAV_BOOL_FALSE: Leave when altitude reached). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][31].param[2] = """Loiter radius around waypoint for forward-only moving vehicles (not multicopters). If positive loiter clockwise, negative counter-clockwise, 0 means no change to standard loiter."""
enums["MAV_CMD"][31].param[3] = """Empty"""
enums["MAV_CMD"][31].param[4] = """Forward moving aircraft this sets exit xtrack location: 0 for center of loiter wp, 1 for exit location"""
enums["MAV_CMD"][31].param[5] = """Latitude"""
enums["MAV_CMD"][31].param[6] = """Longitude"""
enums["MAV_CMD"][31].param[7] = """Altitude"""
MAV_CMD_DO_FOLLOW = 32
enums["MAV_CMD"][32] = EnumEntry("MAV_CMD_DO_FOLLOW", """Begin following a target""")
enums["MAV_CMD"][32].param[1] = """System ID (of the FOLLOW_TARGET beacon). Send 0 to disable follow-me and return to the default position hold mode."""
enums["MAV_CMD"][32].param[2] = """Reserved"""
enums["MAV_CMD"][32].param[3] = """Reserved"""
enums["MAV_CMD"][32].param[4] = """Altitude mode: 0: Keep current altitude, 1: keep altitude difference to target, 2: go to a fixed altitude above home."""
enums["MAV_CMD"][32].param[5] = """Altitude above home. (used if mode=2)"""
enums["MAV_CMD"][32].param[6] = """Reserved"""
enums["MAV_CMD"][32].param[7] = """Time to land in which the MAV should go to the default position hold mode after a message RX timeout."""
MAV_CMD_DO_FOLLOW_REPOSITION = 33
enums["MAV_CMD"][33] = EnumEntry("MAV_CMD_DO_FOLLOW_REPOSITION", """Reposition the MAV after a follow target command has been sent""")
enums["MAV_CMD"][33].param[1] = """Camera q1 (where 0 is on the ray from the camera to the tracking device)"""
enums["MAV_CMD"][33].param[2] = """Camera q2"""
enums["MAV_CMD"][33].param[3] = """Camera q3"""
enums["MAV_CMD"][33].param[4] = """Camera q4"""
enums["MAV_CMD"][33].param[5] = """altitude offset from target"""
enums["MAV_CMD"][33].param[6] = """X offset from target"""
enums["MAV_CMD"][33].param[7] = """Y offset from target"""
MAV_CMD_NAV_ROI = 80
enums["MAV_CMD"][80] = EnumEntry("MAV_CMD_NAV_ROI", """Sets the region of interest (ROI) for a sensor set or the vehicle itself. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.""")
enums["MAV_CMD"][80].has_location = True
enums["MAV_CMD"][80].param[1] = """Region of interest mode."""
enums["MAV_CMD"][80].param[2] = """Waypoint index/ target ID. (see MAV_ROI enum)"""
enums["MAV_CMD"][80].param[3] = """ROI index (allows a vehicle to manage multiple ROI's)"""
enums["MAV_CMD"][80].param[4] = """Empty"""
enums["MAV_CMD"][80].param[5] = """x the location of the fixed ROI (see MAV_FRAME)"""
enums["MAV_CMD"][80].param[6] = """y"""
enums["MAV_CMD"][80].param[7] = """z"""
MAV_CMD_NAV_PATHPLANNING = 81
enums["MAV_CMD"][81] = EnumEntry("MAV_CMD_NAV_PATHPLANNING", """Control autonomous path planning on the MAV.""")
enums["MAV_CMD"][81].has_location = True
enums["MAV_CMD"][81].param[1] = """0: Disable local obstacle avoidance / local path planning (without resetting map), 1: Enable local path planning, 2: Enable and reset local path planning"""
enums["MAV_CMD"][81].param[2] = """0: Disable full path planning (without resetting map), 1: Enable, 2: Enable and reset map/occupancy grid, 3: Enable and reset planned route, but not occupancy grid"""
enums["MAV_CMD"][81].param[3] = """Empty"""
enums["MAV_CMD"][81].param[4] = """Yaw angle at goal"""
enums["MAV_CMD"][81].param[5] = """Latitude/X of goal"""
enums["MAV_CMD"][81].param[6] = """Longitude/Y of goal"""
enums["MAV_CMD"][81].param[7] = """Altitude/Z of goal"""
MAV_CMD_NAV_SPLINE_WAYPOINT = 82
enums["MAV_CMD"][82] = EnumEntry("MAV_CMD_NAV_SPLINE_WAYPOINT", """Navigate to waypoint using a spline path.""")
enums["MAV_CMD"][82].has_location = True
enums["MAV_CMD"][82].param[1] = """Hold time. (ignored by fixed wing, time to stay at waypoint for rotary wing)"""
enums["MAV_CMD"][82].param[2] = """Empty"""
enums["MAV_CMD"][82].param[3] = """Empty"""
enums["MAV_CMD"][82].param[4] = """Empty"""
enums["MAV_CMD"][82].param[5] = """Latitude/X of goal"""
enums["MAV_CMD"][82].param[6] = """Longitude/Y of goal"""
enums["MAV_CMD"][82].param[7] = """Altitude/Z of goal"""
MAV_CMD_NAV_VTOL_TAKEOFF = 84
enums["MAV_CMD"][84] = EnumEntry("MAV_CMD_NAV_VTOL_TAKEOFF", """Takeoff from ground using VTOL mode, and transition to forward flight with specified heading. The command should be ignored by vehicles that dont support both VTOL and fixed-wing flight (multicopters, boats,etc.).""")
enums["MAV_CMD"][84].has_location = True
enums["MAV_CMD"][84].param[1] = """Empty"""
enums["MAV_CMD"][84].param[2] = """Front transition heading."""
enums["MAV_CMD"][84].param[3] = """Empty"""
enums["MAV_CMD"][84].param[4] = """Yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.)."""
enums["MAV_CMD"][84].param[5] = """Latitude"""
enums["MAV_CMD"][84].param[6] = """Longitude"""
enums["MAV_CMD"][84].param[7] = """Altitude"""
MAV_CMD_NAV_VTOL_LAND = 85
enums["MAV_CMD"][85] = EnumEntry("MAV_CMD_NAV_VTOL_LAND", """Land using VTOL mode""")
enums["MAV_CMD"][85].has_location = True
enums["MAV_CMD"][85].param[1] = """See NAV_VTOL_LAND_OPTIONS enum"""
enums["MAV_CMD"][85].param[2] = """Empty"""
enums["MAV_CMD"][85].param[3] = """Approach altitude (with the same reference as the Altitude field). NaN if unspecified."""
enums["MAV_CMD"][85].param[4] = """Yaw angle. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.)."""
enums["MAV_CMD"][85].param[5] = """Latitude"""
enums["MAV_CMD"][85].param[6] = """Longitude"""
enums["MAV_CMD"][85].param[7] = """Altitude (ground level)"""
MAV_CMD_NAV_GUIDED_ENABLE = 92
enums["MAV_CMD"][92] = EnumEntry("MAV_CMD_NAV_GUIDED_ENABLE", """Hand control over to an external controller""")
enums["MAV_CMD"][92].param[1] = """Guided mode on (MAV_BOOL_FALSE: Off). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][92].param[2] = """Empty"""
enums["MAV_CMD"][92].param[3] = """Empty"""
enums["MAV_CMD"][92].param[4] = """Empty"""
enums["MAV_CMD"][92].param[5] = """Empty"""
enums["MAV_CMD"][92].param[6] = """Empty"""
enums["MAV_CMD"][92].param[7] = """Empty"""
MAV_CMD_NAV_DELAY = 93
enums["MAV_CMD"][93] = EnumEntry("MAV_CMD_NAV_DELAY", """Delay the next navigation command a number of seconds or until a specified time""")
enums["MAV_CMD"][93].param[1] = """Delay (-1 to enable time-of-day fields)"""
enums["MAV_CMD"][93].param[2] = """hour (24h format, UTC, -1 to ignore)"""
enums["MAV_CMD"][93].param[3] = """minute (24h format, UTC, -1 to ignore)"""
enums["MAV_CMD"][93].param[4] = """second (24h format, UTC, -1 to ignore)"""
enums["MAV_CMD"][93].param[5] = """Empty"""
enums["MAV_CMD"][93].param[6] = """Empty"""
enums["MAV_CMD"][93].param[7] = """Empty"""
MAV_CMD_NAV_PAYLOAD_PLACE = 94
enums["MAV_CMD"][94] = EnumEntry("MAV_CMD_NAV_PAYLOAD_PLACE", """Descend and place payload. Vehicle moves to specified location, descends until it detects a hanging payload has reached the ground, and then releases the payload. If ground is not detected before the reaching the maximum descent value (param1), the command will complete without releasing the payload.""")
enums["MAV_CMD"][94].has_location = True
enums["MAV_CMD"][94].param[1] = """Maximum distance to descend."""
enums["MAV_CMD"][94].param[2] = """Empty"""
enums["MAV_CMD"][94].param[3] = """Empty"""
enums["MAV_CMD"][94].param[4] = """Empty"""
enums["MAV_CMD"][94].param[5] = """Latitude"""
enums["MAV_CMD"][94].param[6] = """Longitude"""
enums["MAV_CMD"][94].param[7] = """Altitude"""
MAV_CMD_NAV_LAST = 95
enums["MAV_CMD"][95] = EnumEntry("MAV_CMD_NAV_LAST", """NOP - This command is only used to mark the upper limit of the NAV/ACTION commands in the enumeration""")
enums["MAV_CMD"][95].param[1] = """Empty"""
enums["MAV_CMD"][95].param[2] = """Empty"""
enums["MAV_CMD"][95].param[3] = """Empty"""
enums["MAV_CMD"][95].param[4] = """Empty"""
enums["MAV_CMD"][95].param[5] = """Empty"""
enums["MAV_CMD"][95].param[6] = """Empty"""
enums["MAV_CMD"][95].param[7] = """Empty"""
MAV_CMD_CONDITION_DELAY = 112
enums["MAV_CMD"][112] = EnumEntry("MAV_CMD_CONDITION_DELAY", """Delay mission state machine.""")
enums["MAV_CMD"][112].param[1] = """Delay"""
enums["MAV_CMD"][112].param[2] = """Empty"""
enums["MAV_CMD"][112].param[3] = """Empty"""
enums["MAV_CMD"][112].param[4] = """Empty"""
enums["MAV_CMD"][112].param[5] = """Empty"""
enums["MAV_CMD"][112].param[6] = """Empty"""
enums["MAV_CMD"][112].param[7] = """Empty"""
MAV_CMD_CONDITION_CHANGE_ALT = 113
enums["MAV_CMD"][113] = EnumEntry("MAV_CMD_CONDITION_CHANGE_ALT", """Ascend/descend to target altitude at specified rate. Delay mission state machine until desired altitude reached.""")
enums["MAV_CMD"][113].param[1] = """Descent / Ascend rate."""
enums["MAV_CMD"][113].param[2] = """Empty"""
enums["MAV_CMD"][113].param[3] = """Empty"""
enums["MAV_CMD"][113].param[4] = """Empty"""
enums["MAV_CMD"][113].param[5] = """Empty"""
enums["MAV_CMD"][113].param[6] = """Empty"""
enums["MAV_CMD"][113].param[7] = """Target Altitude"""
MAV_CMD_CONDITION_DISTANCE = 114
enums["MAV_CMD"][114] = EnumEntry("MAV_CMD_CONDITION_DISTANCE", """Delay mission state machine until within desired distance of next NAV point.""")
enums["MAV_CMD"][114].param[1] = """Distance."""
enums["MAV_CMD"][114].param[2] = """Empty"""
enums["MAV_CMD"][114].param[3] = """Empty"""
enums["MAV_CMD"][114].param[4] = """Empty"""
enums["MAV_CMD"][114].param[5] = """Empty"""
enums["MAV_CMD"][114].param[6] = """Empty"""
enums["MAV_CMD"][114].param[7] = """Empty"""
MAV_CMD_CONDITION_YAW = 115
enums["MAV_CMD"][115] = EnumEntry("MAV_CMD_CONDITION_YAW", """Reach a certain target angle.""")
enums["MAV_CMD"][115].param[1] = """target angle [0-360]. Absolute angles: 0 is north. Relative angle: 0 is initial yaw. Direction set by param3."""
enums["MAV_CMD"][115].param[2] = """angular speed"""
enums["MAV_CMD"][115].param[3] = """direction: -1: counter clockwise, 0: shortest direction, 1: clockwise"""
enums["MAV_CMD"][115].param[4] = """Relative offset (MAV_BOOL_FALSE: absolute angle). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][115].param[5] = """Empty"""
enums["MAV_CMD"][115].param[6] = """Empty"""
enums["MAV_CMD"][115].param[7] = """Empty"""
MAV_CMD_CONDITION_LAST = 159
enums["MAV_CMD"][159] = EnumEntry("MAV_CMD_CONDITION_LAST", """NOP - This command is only used to mark the upper limit of the CONDITION commands in the enumeration""")
enums["MAV_CMD"][159].param[1] = """Empty"""
enums["MAV_CMD"][159].param[2] = """Empty"""
enums["MAV_CMD"][159].param[3] = """Empty"""
enums["MAV_CMD"][159].param[4] = """Empty"""
enums["MAV_CMD"][159].param[5] = """Empty"""
enums["MAV_CMD"][159].param[6] = """Empty"""
enums["MAV_CMD"][159].param[7] = """Empty"""
MAV_CMD_DO_SET_MODE = 176
enums["MAV_CMD"][176] = EnumEntry("MAV_CMD_DO_SET_MODE", """Set system mode.""")
enums["MAV_CMD"][176].param[1] = """Mode"""
enums["MAV_CMD"][176].param[2] = """Custom mode - this is system specific, please refer to the individual autopilot specifications for details."""
enums["MAV_CMD"][176].param[3] = """Custom sub mode - this is system specific, please refer to the individual autopilot specifications for details."""
enums["MAV_CMD"][176].param[4] = """Empty"""
enums["MAV_CMD"][176].param[5] = """Empty"""
enums["MAV_CMD"][176].param[6] = """Empty"""
enums["MAV_CMD"][176].param[7] = """Empty"""
MAV_CMD_DO_JUMP = 177
enums["MAV_CMD"][177] = EnumEntry("MAV_CMD_DO_JUMP", """Jump to the desired command in the mission list.  Repeat this action only the specified number of times""")
enums["MAV_CMD"][177].param[1] = """Sequence number"""
enums["MAV_CMD"][177].param[2] = """Repeat count"""
enums["MAV_CMD"][177].param[3] = """Empty"""
enums["MAV_CMD"][177].param[4] = """Empty"""
enums["MAV_CMD"][177].param[5] = """Empty"""
enums["MAV_CMD"][177].param[6] = """Empty"""
enums["MAV_CMD"][177].param[7] = """Empty"""
MAV_CMD_DO_CHANGE_SPEED = 178
enums["MAV_CMD"][178] = EnumEntry("MAV_CMD_DO_CHANGE_SPEED", """Change speed and/or throttle set points. The value persists until it is overridden or there is a mode change""")
enums["MAV_CMD"][178].param[1] = """Speed type of value set in param2 (such as airspeed, ground speed, and so on)"""
enums["MAV_CMD"][178].param[2] = """Speed (-1 indicates no change, -2 indicates return to default vehicle speed)"""
enums["MAV_CMD"][178].param[3] = """Throttle (-1 indicates no change, -2 indicates return to default vehicle throttle value)"""
enums["MAV_CMD"][178].param[4] = """0: absolute, 1: relative"""
enums["MAV_CMD"][178].param[5] = """Empty"""
enums["MAV_CMD"][178].param[6] = """Empty"""
enums["MAV_CMD"][178].param[7] = """Empty"""
MAV_CMD_DO_SET_HOME = 179
enums["MAV_CMD"][179] = EnumEntry("MAV_CMD_DO_SET_HOME", """Changes the home location either to the current location or a specified location.""")
enums["MAV_CMD"][179].has_location = True
enums["MAV_CMD"][179].param[1] = """Use current location (MAV_BOOL_FALSE: use specified location). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][179].param[2] = """Empty"""
enums["MAV_CMD"][179].param[3] = """Empty"""
enums["MAV_CMD"][179].param[4] = """Empty"""
enums["MAV_CMD"][179].param[5] = """Latitude"""
enums["MAV_CMD"][179].param[6] = """Longitude"""
enums["MAV_CMD"][179].param[7] = """Altitude"""
MAV_CMD_DO_SET_PARAMETER = 180
enums["MAV_CMD"][180] = EnumEntry("MAV_CMD_DO_SET_PARAMETER", """Set a system parameter.  Caution!  Use of this command requires knowledge of the numeric enumeration value of the parameter.""")
enums["MAV_CMD"][180].param[1] = """Parameter number"""
enums["MAV_CMD"][180].param[2] = """Parameter value"""
enums["MAV_CMD"][180].param[3] = """Empty"""
enums["MAV_CMD"][180].param[4] = """Empty"""
enums["MAV_CMD"][180].param[5] = """Empty"""
enums["MAV_CMD"][180].param[6] = """Empty"""
enums["MAV_CMD"][180].param[7] = """Empty"""
MAV_CMD_DO_SET_RELAY = 181
enums["MAV_CMD"][181] = EnumEntry("MAV_CMD_DO_SET_RELAY", """Set a relay to a condition.""")
enums["MAV_CMD"][181].param[1] = """Relay instance number."""
enums["MAV_CMD"][181].param[2] = """Setting. (1=on, 0=off, others possible depending on system hardware)"""
enums["MAV_CMD"][181].param[3] = """Empty"""
enums["MAV_CMD"][181].param[4] = """Empty"""
enums["MAV_CMD"][181].param[5] = """Empty"""
enums["MAV_CMD"][181].param[6] = """Empty"""
enums["MAV_CMD"][181].param[7] = """Empty"""
MAV_CMD_DO_REPEAT_RELAY = 182
enums["MAV_CMD"][182] = EnumEntry("MAV_CMD_DO_REPEAT_RELAY", """Cycle a relay on and off for a desired number of cycles with a desired period.""")
enums["MAV_CMD"][182].param[1] = """Relay instance number."""
enums["MAV_CMD"][182].param[2] = """Cycle count."""
enums["MAV_CMD"][182].param[3] = """Cycle time."""
enums["MAV_CMD"][182].param[4] = """Empty"""
enums["MAV_CMD"][182].param[5] = """Empty"""
enums["MAV_CMD"][182].param[6] = """Empty"""
enums["MAV_CMD"][182].param[7] = """Empty"""
MAV_CMD_DO_SET_SERVO = 183
enums["MAV_CMD"][183] = EnumEntry("MAV_CMD_DO_SET_SERVO", """Set a servo to a desired PWM value.""")
enums["MAV_CMD"][183].param[1] = """Servo instance number."""
enums["MAV_CMD"][183].param[2] = """Pulse Width Modulation."""
enums["MAV_CMD"][183].param[3] = """Empty"""
enums["MAV_CMD"][183].param[4] = """Empty"""
enums["MAV_CMD"][183].param[5] = """Empty"""
enums["MAV_CMD"][183].param[6] = """Empty"""
enums["MAV_CMD"][183].param[7] = """Empty"""
MAV_CMD_DO_REPEAT_SERVO = 184
enums["MAV_CMD"][184] = EnumEntry("MAV_CMD_DO_REPEAT_SERVO", """Cycle a between its nominal setting and a desired PWM for a desired number of cycles with a desired period.""")
enums["MAV_CMD"][184].param[1] = """Servo instance number."""
enums["MAV_CMD"][184].param[2] = """Pulse Width Modulation."""
enums["MAV_CMD"][184].param[3] = """Cycle count."""
enums["MAV_CMD"][184].param[4] = """Cycle time."""
enums["MAV_CMD"][184].param[5] = """Empty"""
enums["MAV_CMD"][184].param[6] = """Empty"""
enums["MAV_CMD"][184].param[7] = """Empty"""
MAV_CMD_DO_FLIGHTTERMINATION = 185
enums["MAV_CMD"][185] = EnumEntry("MAV_CMD_DO_FLIGHTTERMINATION", """Terminate flight immediately""")
enums["MAV_CMD"][185].param[1] = """Flight termination activated if > 0.5"""
enums["MAV_CMD"][185].param[2] = """Empty"""
enums["MAV_CMD"][185].param[3] = """Empty"""
enums["MAV_CMD"][185].param[4] = """Empty"""
enums["MAV_CMD"][185].param[5] = """Empty"""
enums["MAV_CMD"][185].param[6] = """Empty"""
enums["MAV_CMD"][185].param[7] = """Empty"""
MAV_CMD_DO_CHANGE_ALTITUDE = 186
enums["MAV_CMD"][186] = EnumEntry("MAV_CMD_DO_CHANGE_ALTITUDE", """Change altitude set point.""")
enums["MAV_CMD"][186].param[1] = """Altitude."""
enums["MAV_CMD"][186].param[2] = """Frame of new altitude."""
enums["MAV_CMD"][186].param[3] = """Empty"""
enums["MAV_CMD"][186].param[4] = """Empty"""
enums["MAV_CMD"][186].param[5] = """Empty"""
enums["MAV_CMD"][186].param[6] = """Empty"""
enums["MAV_CMD"][186].param[7] = """Empty"""
MAV_CMD_DO_RETURN_PATH_START = 188
enums["MAV_CMD"][188] = EnumEntry(
    "MAV_CMD_DO_RETURN_PATH_START",
    """Mission item to specify the start of a failsafe/landing return-path segment (the end of the segment is the next MAV_CMD_DO_LAND_START item).
          A vehicle that is using missions for landing (e.g. in a return mode) will join the mission on the closest path of the return-path segment (instead of MAV_CMD_DO_LAND_START or the nearest waypoint).
          The main use case is to minimize the failsafe flight path in corridor missions, where the inbound/outbound paths are constrained (by geofences) to the same particular path.
          The MAV_CMD_NAV_RETURN_PATH_START would be placed at the start of the return path.
          If a failsafe occurs on the outbound path the vehicle will move to the nearest point on the return path (which is parallel for this kind of mission), effectively turning round and following the shortest path to landing.
          If a failsafe occurs on the inbound path the vehicle is already on the return segment and will continue to landing.
          The Latitude/Longitude/Altitude are optional, and may be set to 0 if not needed.
          If specified, the item defines the waypoint at which the return segment starts.
          If sent using as a command, the vehicle will perform a mission landing (using the land segment if defined) or reject the command if mission landings are not supported, or no mission landing is defined. When used as a command any position information in the command is ignored.
        """,
)
enums["MAV_CMD"][188].has_location = True
enums["MAV_CMD"][188].param[1] = """Empty"""
enums["MAV_CMD"][188].param[2] = """Empty"""
enums["MAV_CMD"][188].param[3] = """Empty"""
enums["MAV_CMD"][188].param[4] = """Empty"""
enums["MAV_CMD"][188].param[5] = """Latitudee. 0: not used."""
enums["MAV_CMD"][188].param[6] = """Longitudee. 0: not used."""
enums["MAV_CMD"][188].param[7] = """Altitudee. 0: not used."""
MAV_CMD_DO_LAND_START = 189
enums["MAV_CMD"][189] = EnumEntry(
    "MAV_CMD_DO_LAND_START",
    """Mission command to perform a landing. This is used as a marker in a mission to tell the autopilot where a sequence of mission items that represents a landing starts.
      It may also be sent via a COMMAND_LONG to trigger a landing, in which case the nearest (geographically) landing sequence in the mission will be used.
      The Latitude/Longitude/Altitude is optional, and may be set to 0 if not needed. If specified then it will be used to help find the closest landing sequence.
    """,
)
enums["MAV_CMD"][189].has_location = True
enums["MAV_CMD"][189].param[1] = """Empty"""
enums["MAV_CMD"][189].param[2] = """Empty"""
enums["MAV_CMD"][189].param[3] = """Empty"""
enums["MAV_CMD"][189].param[4] = """Empty"""
enums["MAV_CMD"][189].param[5] = """Latitude"""
enums["MAV_CMD"][189].param[6] = """Longitude"""
enums["MAV_CMD"][189].param[7] = """Altitude"""
MAV_CMD_DO_RALLY_LAND = 190
enums["MAV_CMD"][190] = EnumEntry("MAV_CMD_DO_RALLY_LAND", """Mission command to perform a landing from a rally point.""")
enums["MAV_CMD"][190].param[1] = """Break altitude"""
enums["MAV_CMD"][190].param[2] = """Landing speed"""
enums["MAV_CMD"][190].param[3] = """Empty"""
enums["MAV_CMD"][190].param[4] = """Empty"""
enums["MAV_CMD"][190].param[5] = """Empty"""
enums["MAV_CMD"][190].param[6] = """Empty"""
enums["MAV_CMD"][190].param[7] = """Empty"""
MAV_CMD_DO_GO_AROUND = 191
enums["MAV_CMD"][191] = EnumEntry("MAV_CMD_DO_GO_AROUND", """Mission command to safely abort an autonomous landing.""")
enums["MAV_CMD"][191].param[1] = """Altitude"""
enums["MAV_CMD"][191].param[2] = """Empty"""
enums["MAV_CMD"][191].param[3] = """Empty"""
enums["MAV_CMD"][191].param[4] = """Empty"""
enums["MAV_CMD"][191].param[5] = """Empty"""
enums["MAV_CMD"][191].param[6] = """Empty"""
enums["MAV_CMD"][191].param[7] = """Empty"""
MAV_CMD_DO_REPOSITION = 192
enums["MAV_CMD"][192] = EnumEntry("MAV_CMD_DO_REPOSITION", """Reposition the vehicle to a specific WGS84 global position. This command is intended for guided commands (for missions use MAV_CMD_NAV_WAYPOINT instead).""")
enums["MAV_CMD"][192].has_location = True
enums["MAV_CMD"][192].param[1] = """Ground speed, less than 0 (-1) for default"""
enums["MAV_CMD"][192].param[2] = """Bitmask of option flags."""
enums["MAV_CMD"][192].param[3] = """Loiter radius for planes. Positive values only, direction is controlled by Yaw value. A value of zero or NaN is ignored. """
enums["MAV_CMD"][192].param[4] = """Yaw heading. NaN to use the current system yaw heading mode (e.g. yaw towards next waypoint, yaw to home, etc.). For planes indicates loiter direction (0: clockwise, 1: counter clockwise)"""
enums["MAV_CMD"][192].param[5] = """Latitude"""
enums["MAV_CMD"][192].param[6] = """Longitude"""
enums["MAV_CMD"][192].param[7] = """Altitude"""
MAV_CMD_DO_PAUSE_CONTINUE = 193
enums["MAV_CMD"][193] = EnumEntry("MAV_CMD_DO_PAUSE_CONTINUE", """If in a GPS controlled position mode, hold the current position or continue.""")
enums["MAV_CMD"][193].param[1] = """Continue mission (MAV_BOOL_TRUE), Pause current mission or reposition command, hold current position (MAV_BOOL_FALSE). Values not equal to 0 or 1 are invalid. A VTOL capable vehicle should enter hover mode (multicopter and VTOL planes). A plane should loiter with the default loiter radius."""
enums["MAV_CMD"][193].param[2] = """Reserved"""
enums["MAV_CMD"][193].param[3] = """Reserved"""
enums["MAV_CMD"][193].param[4] = """Reserved"""
enums["MAV_CMD"][193].param[5] = """Reserved"""
enums["MAV_CMD"][193].param[6] = """Reserved"""
enums["MAV_CMD"][193].param[7] = """Reserved"""
MAV_CMD_DO_SET_REVERSE = 194
enums["MAV_CMD"][194] = EnumEntry("MAV_CMD_DO_SET_REVERSE", """Set moving direction to forward or reverse.""")
enums["MAV_CMD"][194].param[1] = """Reverse direction (MAV_BOOL_FALSE: Forward direction). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][194].param[2] = """Empty"""
enums["MAV_CMD"][194].param[3] = """Empty"""
enums["MAV_CMD"][194].param[4] = """Empty"""
enums["MAV_CMD"][194].param[5] = """Empty"""
enums["MAV_CMD"][194].param[6] = """Empty"""
enums["MAV_CMD"][194].param[7] = """Empty"""
MAV_CMD_DO_SET_ROI_LOCATION = 195
enums["MAV_CMD"][195] = EnumEntry("MAV_CMD_DO_SET_ROI_LOCATION", """Sets the region of interest (ROI) to a location. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.""")
enums["MAV_CMD"][195].has_location = True
enums["MAV_CMD"][195].param[1] = """Empty"""
enums["MAV_CMD"][195].param[2] = """Empty"""
enums["MAV_CMD"][195].param[3] = """Empty"""
enums["MAV_CMD"][195].param[4] = """Empty"""
enums["MAV_CMD"][195].param[5] = """Latitude of ROI location"""
enums["MAV_CMD"][195].param[6] = """Longitude of ROI location"""
enums["MAV_CMD"][195].param[7] = """Altitude of ROI location"""
MAV_CMD_DO_SET_ROI_WPNEXT_OFFSET = 196
enums["MAV_CMD"][196] = EnumEntry("MAV_CMD_DO_SET_ROI_WPNEXT_OFFSET", """Sets the region of interest (ROI) to be toward next waypoint, with optional pitch/roll/yaw offset. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.""")
enums["MAV_CMD"][196].param[1] = """Empty"""
enums["MAV_CMD"][196].param[2] = """Empty"""
enums["MAV_CMD"][196].param[3] = """Empty"""
enums["MAV_CMD"][196].param[4] = """Empty"""
enums["MAV_CMD"][196].param[5] = """Pitch offset from next waypoint, positive pitching up"""
enums["MAV_CMD"][196].param[6] = """Roll offset from next waypoint, positive rolling to the right"""
enums["MAV_CMD"][196].param[7] = """Yaw offset from next waypoint, positive yawing to the right"""
MAV_CMD_DO_SET_ROI_NONE = 197
enums["MAV_CMD"][197] = EnumEntry("MAV_CMD_DO_SET_ROI_NONE", """Cancels any previous ROI command returning the vehicle/sensors to default flight characteristics. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.""")
enums["MAV_CMD"][197].param[1] = """Empty"""
enums["MAV_CMD"][197].param[2] = """Empty"""
enums["MAV_CMD"][197].param[3] = """Empty"""
enums["MAV_CMD"][197].param[4] = """Empty"""
enums["MAV_CMD"][197].param[5] = """Empty"""
enums["MAV_CMD"][197].param[6] = """Empty"""
enums["MAV_CMD"][197].param[7] = """Empty"""
MAV_CMD_DO_SET_ROI_SYSID = 198
enums["MAV_CMD"][198] = EnumEntry("MAV_CMD_DO_SET_ROI_SYSID", """Mount tracks system with specified system ID. Determination of target vehicle position may be done with GLOBAL_POSITION_INT or any other means.""")
enums["MAV_CMD"][198].param[1] = """System ID"""
enums["MAV_CMD"][198].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][198].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][198].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][198].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][198].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][198].param[7] = """Reserved (default:0)"""
MAV_CMD_DO_CONTROL_VIDEO = 200
enums["MAV_CMD"][200] = EnumEntry("MAV_CMD_DO_CONTROL_VIDEO", """Control onboard camera system.""")
enums["MAV_CMD"][200].param[1] = """Camera ID (-1 for all)"""
enums["MAV_CMD"][200].param[2] = """Transmission: 0: disabled, 1: enabled compressed, 2: enabled raw"""
enums["MAV_CMD"][200].param[3] = """Transmission mode: 0: video stream, >0: single images every n seconds"""
enums["MAV_CMD"][200].param[4] = """Recording: 0: disabled, 1: enabled compressed, 2: enabled raw"""
enums["MAV_CMD"][200].param[5] = """Empty"""
enums["MAV_CMD"][200].param[6] = """Empty"""
enums["MAV_CMD"][200].param[7] = """Empty"""
MAV_CMD_DO_SET_ROI = 201
enums["MAV_CMD"][201] = EnumEntry("MAV_CMD_DO_SET_ROI", """Sets the region of interest (ROI) for a sensor set or the vehicle itself. This can then be used by the vehicle's control system to control the vehicle attitude and the attitude of various sensors such as cameras.""")
enums["MAV_CMD"][201].has_location = True
enums["MAV_CMD"][201].param[1] = """Region of interest mode."""
enums["MAV_CMD"][201].param[2] = """Waypoint index/ target ID (depends on param 1)."""
enums["MAV_CMD"][201].param[3] = """Region of interest index. (allows a vehicle to manage multiple ROI's)"""
enums["MAV_CMD"][201].param[4] = """Empty"""
enums["MAV_CMD"][201].param[5] = """x the location of the fixed ROI (see MAV_FRAME)"""
enums["MAV_CMD"][201].param[6] = """y"""
enums["MAV_CMD"][201].param[7] = """z"""
MAV_CMD_DO_DIGICAM_CONFIGURE = 202
enums["MAV_CMD"][202] = EnumEntry("MAV_CMD_DO_DIGICAM_CONFIGURE", """Configure digital camera. This is a fallback message for systems that have not yet implemented PARAM_EXT_XXX messages and camera definition files (see https://mavlink.io/en/services/camera_def.html ).""")
enums["MAV_CMD"][202].param[1] = """Modes: P, TV, AV, M, Etc."""
enums["MAV_CMD"][202].param[2] = """Shutter speed: Divisor number for one second."""
enums["MAV_CMD"][202].param[3] = """Aperture: F stop number."""
enums["MAV_CMD"][202].param[4] = """ISO number e.g. 80, 100, 200, Etc."""
enums["MAV_CMD"][202].param[5] = """Exposure type enumerator."""
enums["MAV_CMD"][202].param[6] = """Command Identity."""
enums["MAV_CMD"][202].param[7] = """Main engine cut-off time before camera trigger. (0 means no cut-off)"""
MAV_CMD_DO_DIGICAM_CONTROL = 203
enums["MAV_CMD"][203] = EnumEntry("MAV_CMD_DO_DIGICAM_CONTROL", """Control digital camera. This is a fallback message for systems that have not yet implemented PARAM_EXT_XXX messages and camera definition files (see https://mavlink.io/en/services/camera_def.html ).""")
enums["MAV_CMD"][203].param[1] = """Session control e.g. show/hide lens"""
enums["MAV_CMD"][203].param[2] = """Zoom's absolute position"""
enums["MAV_CMD"][203].param[3] = """Zooming step value to offset zoom from the current position"""
enums["MAV_CMD"][203].param[4] = """Focus Locking, Unlocking or Re-locking"""
enums["MAV_CMD"][203].param[5] = """Shooting Command"""
enums["MAV_CMD"][203].param[6] = """Command Identity"""
enums["MAV_CMD"][203].param[7] = """Test shot identifier. If set to 1, image will only be captured, but not counted towards internal frame count."""
MAV_CMD_DO_MOUNT_CONFIGURE = 204
enums["MAV_CMD"][204] = EnumEntry("MAV_CMD_DO_MOUNT_CONFIGURE", """Mission command to configure a camera or antenna mount""")
enums["MAV_CMD"][204].param[1] = """Mount operation mode"""
enums["MAV_CMD"][204].param[2] = """Stabilize roll (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][204].param[3] = """Stabilize pitch (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][204].param[4] = """Stabilize yaw (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][204].param[5] = """Empty"""
enums["MAV_CMD"][204].param[6] = """Empty"""
enums["MAV_CMD"][204].param[7] = """Empty"""
MAV_CMD_DO_MOUNT_CONTROL = 205
enums["MAV_CMD"][205] = EnumEntry("MAV_CMD_DO_MOUNT_CONTROL", """Mission command to control a camera or antenna mount""")
enums["MAV_CMD"][205].param[1] = """pitch (WIP: DEPRECATED: or lat in degrees) depending on mount mode."""
enums["MAV_CMD"][205].param[2] = """roll (WIP: DEPRECATED: or lon in degrees) depending on mount mode."""
enums["MAV_CMD"][205].param[3] = """yaw (WIP: DEPRECATED: or alt in meters) depending on mount mode."""
enums["MAV_CMD"][205].param[4] = """WIP: alt in meters depending on mount mode."""
enums["MAV_CMD"][205].param[5] = """WIP: latitude in degrees * 1E7, set if appropriate mount mode."""
enums["MAV_CMD"][205].param[6] = """WIP: longitude in degrees * 1E7, set if appropriate mount mode."""
enums["MAV_CMD"][205].param[7] = """Mount mode."""
MAV_CMD_DO_SET_CAM_TRIGG_DIST = 206
enums["MAV_CMD"][206] = EnumEntry("MAV_CMD_DO_SET_CAM_TRIGG_DIST", """Mission command to set camera trigger distance for this flight. The camera is triggered each time this distance is exceeded. This command can also be used to set the shutter integration time for the camera.""")
enums["MAV_CMD"][206].param[1] = """Camera trigger distance. 0 to stop triggering."""
enums["MAV_CMD"][206].param[2] = """Camera shutter integration time. -1 or 0 to ignore"""
enums["MAV_CMD"][206].param[3] = """Trigger camera once, immediately (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][206].param[4] = """Empty"""
enums["MAV_CMD"][206].param[5] = """Empty"""
enums["MAV_CMD"][206].param[6] = """Empty"""
enums["MAV_CMD"][206].param[7] = """Empty"""
MAV_CMD_DO_FENCE_ENABLE = 207
enums["MAV_CMD"][207] = EnumEntry(
    "MAV_CMD_DO_FENCE_ENABLE",
    """
          Enable the geofence.
          This can be used in a mission or via the command protocol.
          The persistence/lifetime of the setting is undefined.
          Depending on flight stack implementation it may persist until superseded, or it may revert to a system default at the end of a mission.
          Flight stacks typically reset the setting to system defaults on reboot.
    """,
)
enums["MAV_CMD"][207].param[1] = """enable? (0=disable, 1=enable, 2=disable_floor_only)"""
enums["MAV_CMD"][207].param[2] = """Fence types to enable or disable as a bitmask. 0: all fences should be enabled or disabled (parameter is ignored, for compatibility reasons).Parameter is ignored if param1=2"""
enums["MAV_CMD"][207].param[3] = """Empty"""
enums["MAV_CMD"][207].param[4] = """Empty"""
enums["MAV_CMD"][207].param[5] = """Empty"""
enums["MAV_CMD"][207].param[6] = """Empty"""
enums["MAV_CMD"][207].param[7] = """Empty"""
MAV_CMD_DO_PARACHUTE = 208
enums["MAV_CMD"][208] = EnumEntry("MAV_CMD_DO_PARACHUTE", """Mission item/command to release a parachute or enable/disable auto release.""")
enums["MAV_CMD"][208].param[1] = """Action"""
enums["MAV_CMD"][208].param[2] = """Empty"""
enums["MAV_CMD"][208].param[3] = """Empty"""
enums["MAV_CMD"][208].param[4] = """Empty"""
enums["MAV_CMD"][208].param[5] = """Empty"""
enums["MAV_CMD"][208].param[6] = """Empty"""
enums["MAV_CMD"][208].param[7] = """Empty"""
MAV_CMD_DO_MOTOR_TEST = 209
enums["MAV_CMD"][209] = EnumEntry("MAV_CMD_DO_MOTOR_TEST", """Mission command to perform motor test.""")
enums["MAV_CMD"][209].param[1] = """Motor instance number. (from 1 to max number of motors on the vehicle)"""
enums["MAV_CMD"][209].param[2] = """Throttle type."""
enums["MAV_CMD"][209].param[3] = """Throttle."""
enums["MAV_CMD"][209].param[4] = """Timeout."""
enums["MAV_CMD"][209].param[5] = """Motor count. (number of motors to test to test in sequence, waiting for the timeout above between them; 0=1 motor, 1=1 motor, 2=2 motors...)"""
enums["MAV_CMD"][209].param[6] = """Motor test order."""
enums["MAV_CMD"][209].param[7] = """Empty"""
MAV_CMD_DO_INVERTED_FLIGHT = 210
enums["MAV_CMD"][210] = EnumEntry("MAV_CMD_DO_INVERTED_FLIGHT", """Change to/from inverted flight.""")
enums["MAV_CMD"][210].param[1] = """Inverted flight (MAV_BOOL_False: normal flight). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][210].param[2] = """Empty"""
enums["MAV_CMD"][210].param[3] = """Empty"""
enums["MAV_CMD"][210].param[4] = """Empty"""
enums["MAV_CMD"][210].param[5] = """Empty"""
enums["MAV_CMD"][210].param[6] = """Empty"""
enums["MAV_CMD"][210].param[7] = """Empty"""
MAV_CMD_DO_GRIPPER = 211
enums["MAV_CMD"][211] = EnumEntry("MAV_CMD_DO_GRIPPER", """Mission command to operate a gripper.""")
enums["MAV_CMD"][211].param[1] = """Gripper instance number."""
enums["MAV_CMD"][211].param[2] = """Gripper action to perform."""
enums["MAV_CMD"][211].param[3] = """Empty"""
enums["MAV_CMD"][211].param[4] = """Empty"""
enums["MAV_CMD"][211].param[5] = """Empty"""
enums["MAV_CMD"][211].param[6] = """Empty"""
enums["MAV_CMD"][211].param[7] = """Empty"""
MAV_CMD_DO_AUTOTUNE_ENABLE = 212
enums["MAV_CMD"][212] = EnumEntry("MAV_CMD_DO_AUTOTUNE_ENABLE", """Enable/disable autotune.""")
enums["MAV_CMD"][212].param[1] = """Enable autotune (MAV_BOOL_FALSE: disable autotune). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][212].param[2] = """Specify axes for which autotuning is enabled/disabled. 0 indicates the field is unused (for compatibility reasons). If 0 the autopilot will follow its default behaviour, which is usually to tune all axes."""
enums["MAV_CMD"][212].param[3] = """Empty."""
enums["MAV_CMD"][212].param[4] = """Empty."""
enums["MAV_CMD"][212].param[5] = """Empty."""
enums["MAV_CMD"][212].param[6] = """Empty."""
enums["MAV_CMD"][212].param[7] = """Empty."""
MAV_CMD_NAV_SET_YAW_SPEED = 213
enums["MAV_CMD"][213] = EnumEntry("MAV_CMD_NAV_SET_YAW_SPEED", """Sets a desired vehicle turn angle and speed change.""")
enums["MAV_CMD"][213].param[1] = """Yaw angle to adjust steering by."""
enums["MAV_CMD"][213].param[2] = """Speed."""
enums["MAV_CMD"][213].param[3] = """Relative final angle (MAV_BOOL_FALSE: Absolute angle). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][213].param[4] = """Empty"""
enums["MAV_CMD"][213].param[5] = """Empty"""
enums["MAV_CMD"][213].param[6] = """Empty"""
enums["MAV_CMD"][213].param[7] = """Empty"""
MAV_CMD_DO_SET_CAM_TRIGG_INTERVAL = 214
enums["MAV_CMD"][214] = EnumEntry("MAV_CMD_DO_SET_CAM_TRIGG_INTERVAL", """Mission command to set camera trigger interval for this flight. If triggering is enabled, the camera is triggered each time this interval expires. This command can also be used to set the shutter integration time for the camera.""")
enums["MAV_CMD"][214].param[1] = """Camera trigger cycle time. -1 or 0 to ignore."""
enums["MAV_CMD"][214].param[2] = """Camera shutter integration time. Should be less than trigger cycle time. -1 or 0 to ignore."""
enums["MAV_CMD"][214].param[3] = """Empty"""
enums["MAV_CMD"][214].param[4] = """Empty"""
enums["MAV_CMD"][214].param[5] = """Empty"""
enums["MAV_CMD"][214].param[6] = """Empty"""
enums["MAV_CMD"][214].param[7] = """Empty"""
MAV_CMD_DO_MOUNT_CONTROL_QUAT = 220
enums["MAV_CMD"][220] = EnumEntry("MAV_CMD_DO_MOUNT_CONTROL_QUAT", """Mission command to control a camera or antenna mount, using a quaternion as reference.""")
enums["MAV_CMD"][220].param[1] = """quaternion param q1, w (1 in null-rotation)"""
enums["MAV_CMD"][220].param[2] = """quaternion param q2, x (0 in null-rotation)"""
enums["MAV_CMD"][220].param[3] = """quaternion param q3, y (0 in null-rotation)"""
enums["MAV_CMD"][220].param[4] = """quaternion param q4, z (0 in null-rotation)"""
enums["MAV_CMD"][220].param[5] = """Empty"""
enums["MAV_CMD"][220].param[6] = """Empty"""
enums["MAV_CMD"][220].param[7] = """Empty"""
MAV_CMD_DO_GUIDED_MASTER = 221
enums["MAV_CMD"][221] = EnumEntry("MAV_CMD_DO_GUIDED_MASTER", """set id of master controller""")
enums["MAV_CMD"][221].param[1] = """System ID"""
enums["MAV_CMD"][221].param[2] = """Component ID"""
enums["MAV_CMD"][221].param[3] = """Empty"""
enums["MAV_CMD"][221].param[4] = """Empty"""
enums["MAV_CMD"][221].param[5] = """Empty"""
enums["MAV_CMD"][221].param[6] = """Empty"""
enums["MAV_CMD"][221].param[7] = """Empty"""
MAV_CMD_DO_GUIDED_LIMITS = 222
enums["MAV_CMD"][222] = EnumEntry("MAV_CMD_DO_GUIDED_LIMITS", """Set limits for external control""")
enums["MAV_CMD"][222].param[1] = """Timeout - maximum time that external controller will be allowed to control vehicle. 0 means no timeout."""
enums["MAV_CMD"][222].param[2] = """Altitude (MSL) min - if vehicle moves below this alt, the command will be aborted and the mission will continue. 0 means no lower altitude limit."""
enums["MAV_CMD"][222].param[3] = """Altitude (MSL) max - if vehicle moves above this alt, the command will be aborted and the mission will continue. 0 means no upper altitude limit."""
enums["MAV_CMD"][222].param[4] = """Horizontal move limit - if vehicle moves more than this distance from its location at the moment the command was executed, the command will be aborted and the mission will continue. 0 means no horizontal move limit."""
enums["MAV_CMD"][222].param[5] = """Empty"""
enums["MAV_CMD"][222].param[6] = """Empty"""
enums["MAV_CMD"][222].param[7] = """Empty"""
MAV_CMD_DO_ENGINE_CONTROL = 223
enums["MAV_CMD"][223] = EnumEntry("MAV_CMD_DO_ENGINE_CONTROL", """Control vehicle engine. This is interpreted by the vehicles engine controller to change the target engine state. It is intended for vehicles with internal combustion engines""")
enums["MAV_CMD"][223].param[1] = """Start engine (MAV_BOOL_False: Stop engine). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][223].param[2] = """Cold start engine (MAV_BOOL_FALSE: Warm start). Values not equal to 0 or 1 are invalid. Controls use of choke where applicable"""
enums["MAV_CMD"][223].param[3] = """Height delay. This is for commanding engine start only after the vehicle has gained the specified height. Used in VTOL vehicles during takeoff to start engine after the aircraft is off the ground. Zero for no delay."""
enums["MAV_CMD"][223].param[4] = """A bitmask of options for engine control"""
enums["MAV_CMD"][223].param[5] = """Empty"""
enums["MAV_CMD"][223].param[6] = """Empty"""
enums["MAV_CMD"][223].param[7] = """Empty"""
MAV_CMD_DO_SET_MISSION_CURRENT = 224
enums["MAV_CMD"][224] = EnumEntry("MAV_CMD_DO_SET_MISSION_CURRENT", """Set the mission item with sequence number seq as current item. This means that the MAV will continue to this mission item on the shortest path (not following the mission items in-between).""")
enums["MAV_CMD"][224].param[1] = """Mission sequence value to set"""
enums["MAV_CMD"][224].param[2] = """Empty"""
enums["MAV_CMD"][224].param[3] = """Empty"""
enums["MAV_CMD"][224].param[4] = """Empty"""
enums["MAV_CMD"][224].param[5] = """Empty"""
enums["MAV_CMD"][224].param[6] = """Empty"""
enums["MAV_CMD"][224].param[7] = """Empty"""
MAV_CMD_DO_LAST = 240
enums["MAV_CMD"][240] = EnumEntry("MAV_CMD_DO_LAST", """NOP - This command is only used to mark the upper limit of the DO commands in the enumeration""")
enums["MAV_CMD"][240].param[1] = """Empty"""
enums["MAV_CMD"][240].param[2] = """Empty"""
enums["MAV_CMD"][240].param[3] = """Empty"""
enums["MAV_CMD"][240].param[4] = """Empty"""
enums["MAV_CMD"][240].param[5] = """Empty"""
enums["MAV_CMD"][240].param[6] = """Empty"""
enums["MAV_CMD"][240].param[7] = """Empty"""
MAV_CMD_PREFLIGHT_CALIBRATION = 241
enums["MAV_CMD"][241] = EnumEntry("MAV_CMD_PREFLIGHT_CALIBRATION", """Trigger calibration. This command will be only accepted if in pre-flight mode. Except for Temperature Calibration, only one sensor should be set in a single message and all others should be zero.""")
enums["MAV_CMD"][241].param[1] = """1: gyro calibration, 3: gyro temperature calibration"""
enums["MAV_CMD"][241].param[2] = """Magnetometer calibration. Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][241].param[3] = """Ground pressure calibration. Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][241].param[4] = """1: radio RC calibration, 2: RC trim calibration"""
enums["MAV_CMD"][241].param[5] = """1: accelerometer calibration, 2: board level calibration, 3: accelerometer temperature calibration, 4: simple accelerometer calibration"""
enums["MAV_CMD"][241].param[6] = """1: APM: compass/motor interference calibration (PX4: airspeed calibration, deprecated), 2: airspeed calibration"""
enums["MAV_CMD"][241].param[7] = """1: ESC calibration, 3: barometer temperature calibration"""
MAV_CMD_PREFLIGHT_SET_SENSOR_OFFSETS = 242
enums["MAV_CMD"][242] = EnumEntry("MAV_CMD_PREFLIGHT_SET_SENSOR_OFFSETS", """Set sensor offsets. This command will be only accepted if in pre-flight mode.""")
enums["MAV_CMD"][242].param[1] = """Sensor to adjust the offsets for: 0: gyros, 1: accelerometer, 2: magnetometer, 3: barometer, 4: optical flow, 5: second magnetometer, 6: third magnetometer"""
enums["MAV_CMD"][242].param[2] = """X axis offset (or generic dimension 1), in the sensor's raw units"""
enums["MAV_CMD"][242].param[3] = """Y axis offset (or generic dimension 2), in the sensor's raw units"""
enums["MAV_CMD"][242].param[4] = """Z axis offset (or generic dimension 3), in the sensor's raw units"""
enums["MAV_CMD"][242].param[5] = """Generic dimension 4, in the sensor's raw units"""
enums["MAV_CMD"][242].param[6] = """Generic dimension 5, in the sensor's raw units"""
enums["MAV_CMD"][242].param[7] = """Generic dimension 6, in the sensor's raw units"""
MAV_CMD_PREFLIGHT_UAVCAN = 243
enums["MAV_CMD"][243] = EnumEntry("MAV_CMD_PREFLIGHT_UAVCAN", """Trigger UAVCAN configuration (actuator ID assignment and direction mapping). Note that this maps to the legacy UAVCAN v0 function UAVCAN_ENUMERATE, which is intended to be executed just once during initial vehicle configuration (it is not a normal pre-flight command and has been poorly named).""")
enums["MAV_CMD"][243].param[1] = """1: Trigger actuator ID assignment and direction mapping. 0: Cancel command."""
enums["MAV_CMD"][243].param[2] = """Reserved"""
enums["MAV_CMD"][243].param[3] = """Reserved"""
enums["MAV_CMD"][243].param[4] = """Reserved"""
enums["MAV_CMD"][243].param[5] = """Reserved"""
enums["MAV_CMD"][243].param[6] = """Reserved"""
enums["MAV_CMD"][243].param[7] = """Reserved"""
MAV_CMD_PREFLIGHT_STORAGE = 245
enums["MAV_CMD"][245] = EnumEntry("MAV_CMD_PREFLIGHT_STORAGE", """Request storage of different parameter values and logs. This command will be only accepted if in pre-flight mode.""")
enums["MAV_CMD"][245].param[1] = """Parameter storage: 0: READ FROM FLASH/EEPROM, 1: WRITE CURRENT TO FLASH/EEPROM, 2: Reset to defaults"""
enums["MAV_CMD"][245].param[2] = """Mission storage: 0: READ FROM FLASH/EEPROM, 1: WRITE CURRENT TO FLASH/EEPROM, 2: Reset to defaults"""
enums["MAV_CMD"][245].param[3] = """Onboard logging: 0: Ignore, 1: Start default rate logging, -1: Stop logging, > 1: logging rate (e.g. set to 1000 for 1000 Hz logging)"""
enums["MAV_CMD"][245].param[4] = """Reserved"""
enums["MAV_CMD"][245].param[5] = """Empty"""
enums["MAV_CMD"][245].param[6] = """Empty"""
enums["MAV_CMD"][245].param[7] = """Empty"""
MAV_CMD_PREFLIGHT_REBOOT_SHUTDOWN = 246
enums["MAV_CMD"][246] = EnumEntry("MAV_CMD_PREFLIGHT_REBOOT_SHUTDOWN", """Request the reboot or shutdown of system components.""")
enums["MAV_CMD"][246].param[1] = """0: Do nothing for autopilot, 1: Reboot autopilot, 2: Shutdown autopilot, 3: Reboot autopilot and keep it in the bootloader until upgraded."""
enums["MAV_CMD"][246].param[2] = """0: Do nothing for onboard computer, 1: Reboot onboard computer, 2: Shutdown onboard computer, 3: Reboot onboard computer and keep it in the bootloader until upgraded."""
enums["MAV_CMD"][246].param[3] = """WIP: 0: Do nothing for camera, 1: Reboot onboard camera, 2: Shutdown onboard camera, 3: Reboot onboard camera and keep it in the bootloader until upgraded"""
enums["MAV_CMD"][246].param[4] = """WIP: 0: Do nothing for mount (e.g. gimbal), 1: Reboot mount, 2: Shutdown mount, 3: Reboot mount and keep it in the bootloader until upgraded"""
enums["MAV_CMD"][246].param[5] = """Reserved (set to 0)"""
enums["MAV_CMD"][246].param[6] = """Reserved (set to 0)"""
enums["MAV_CMD"][246].param[7] = """WIP: ID (e.g. camera ID -1 for all IDs)"""
MAV_CMD_OVERRIDE_GOTO = 252
enums["MAV_CMD"][252] = EnumEntry("MAV_CMD_OVERRIDE_GOTO", """Override current mission with command to pause mission, pause mission and move to position, continue/resume mission. When param 1 indicates that the mission is paused (MAV_GOTO_DO_HOLD), param 2 defines whether it holds in place or moves to another position.""")
enums["MAV_CMD"][252].has_location = True
enums["MAV_CMD"][252].param[1] = """MAV_GOTO_DO_HOLD: pause mission and either hold or move to specified position (depending on param2), MAV_GOTO_DO_CONTINUE: resume mission."""
enums["MAV_CMD"][252].param[2] = """MAV_GOTO_HOLD_AT_CURRENT_POSITION: hold at current position, MAV_GOTO_HOLD_AT_SPECIFIED_POSITION: hold at specified position."""
enums["MAV_CMD"][252].param[3] = """Coordinate frame of hold point."""
enums["MAV_CMD"][252].param[4] = """Desired yaw angle."""
enums["MAV_CMD"][252].param[5] = """Latitude/X position."""
enums["MAV_CMD"][252].param[6] = """Longitude/Y position."""
enums["MAV_CMD"][252].param[7] = """Altitude/Z position."""
MAV_CMD_OBLIQUE_SURVEY = 260
enums["MAV_CMD"][260] = EnumEntry("MAV_CMD_OBLIQUE_SURVEY", """Mission command to set a Camera Auto Mount Pivoting Oblique Survey (Replaces CAM_TRIGG_DIST for this purpose). The camera is triggered each time this distance is exceeded, then the mount moves to the next position. Params 4~6 set-up the angle limits and number of positions for oblique survey, where mount-enabled vehicles automatically roll the camera between shots to emulate an oblique camera setup (providing an increased HFOV). This command can also be used to set the shutter integration time for the camera.""")
enums["MAV_CMD"][260].param[1] = """Camera trigger distance. 0 to stop triggering."""
enums["MAV_CMD"][260].param[2] = """Camera shutter integration time. 0 to ignore"""
enums["MAV_CMD"][260].param[3] = """The minimum interval in which the camera is capable of taking subsequent pictures repeatedly. 0 to ignore."""
enums["MAV_CMD"][260].param[4] = """Total number of roll positions at which the camera will capture photos (images captures spread evenly across the limits defined by param5)."""
enums["MAV_CMD"][260].param[5] = """Angle limits that the camera can be rolled to left and right of center."""
enums["MAV_CMD"][260].param[6] = """Fixed pitch angle that the camera will hold in oblique mode if the mount is actuated in the pitch axis."""
enums["MAV_CMD"][260].param[7] = """Empty"""
MAV_CMD_MISSION_START = 300
enums["MAV_CMD"][300] = EnumEntry("MAV_CMD_MISSION_START", """start running a mission""")
enums["MAV_CMD"][300].param[1] = """first_item: the first mission item to run"""
enums["MAV_CMD"][300].param[2] = """last_item:  the last mission item to run (after this item is run, the mission ends)"""
enums["MAV_CMD"][300].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][300].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][300].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][300].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][300].param[7] = """Reserved (default:0)"""
MAV_CMD_COMPONENT_ARM_DISARM = 400
enums["MAV_CMD"][400] = EnumEntry("MAV_CMD_COMPONENT_ARM_DISARM", """Arms / Disarms a component""")
enums["MAV_CMD"][400].param[1] = """Arm (MAV_BOOL_FALSE: disarm). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][400].param[2] = """0: arm-disarm unless prevented by safety checks (i.e. when landed), 21196: force arming/disarming (e.g. allow arming to override preflight checks and disarming in flight)"""
enums["MAV_CMD"][400].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][400].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][400].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][400].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][400].param[7] = """Reserved (default:0)"""
MAV_CMD_RUN_PREARM_CHECKS = 401
enums["MAV_CMD"][401] = EnumEntry("MAV_CMD_RUN_PREARM_CHECKS", """Instructs system to run pre-arm checks.  This command should return MAV_RESULT_TEMPORARILY_REJECTED in the case the system is armed, otherwise MAV_RESULT_ACCEPTED.  Note that the return value from executing this command does not indicate whether the vehicle is armable or not, just whether the system has successfully run/is currently running the checks.  The result of the checks is reflected in the SYS_STATUS message.""")
enums["MAV_CMD"][401].param[1] = """Reserved (default:0)"""
enums["MAV_CMD"][401].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][401].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][401].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][401].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][401].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][401].param[7] = """Reserved (default:0)"""
MAV_CMD_GET_HOME_POSITION = 410
enums["MAV_CMD"][410] = EnumEntry("MAV_CMD_GET_HOME_POSITION", """Request the home position from the vehicle.""")
enums["MAV_CMD"][410].param[1] = """Reserved"""
enums["MAV_CMD"][410].param[2] = """Reserved"""
enums["MAV_CMD"][410].param[3] = """Reserved"""
enums["MAV_CMD"][410].param[4] = """Reserved"""
enums["MAV_CMD"][410].param[5] = """Reserved"""
enums["MAV_CMD"][410].param[6] = """Reserved"""
enums["MAV_CMD"][410].param[7] = """Reserved"""
MAV_CMD_START_RX_PAIR = 500
enums["MAV_CMD"][500] = EnumEntry("MAV_CMD_START_RX_PAIR", """Starts receiver pairing.""")
enums["MAV_CMD"][500].param[1] = """0:Spektrum."""
enums["MAV_CMD"][500].param[2] = """RC type."""
enums["MAV_CMD"][500].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][500].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][500].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][500].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][500].param[7] = """Reserved (default:0)"""
MAV_CMD_GET_MESSAGE_INTERVAL = 510
enums["MAV_CMD"][510] = EnumEntry("MAV_CMD_GET_MESSAGE_INTERVAL", """Request the interval between messages for a particular MAVLink message ID. The receiver should ACK the command and then emit its response in a MESSAGE_INTERVAL message.""")
enums["MAV_CMD"][510].param[1] = """The MAVLink message ID"""
enums["MAV_CMD"][510].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][510].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][510].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][510].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][510].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][510].param[7] = """Reserved (default:0)"""
MAV_CMD_SET_MESSAGE_INTERVAL = 511
enums["MAV_CMD"][511] = EnumEntry("MAV_CMD_SET_MESSAGE_INTERVAL", """Set the interval between messages for a particular MAVLink message ID. This interface replaces REQUEST_DATA_STREAM.""")
enums["MAV_CMD"][511].param[1] = """The MAVLink message ID"""
enums["MAV_CMD"][511].param[2] = """The interval between two messages. Set to -1 to disable and 0 to request default rate."""
enums["MAV_CMD"][511].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][511].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][511].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][511].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][511].param[7] = """Target address of message stream (if message has target address fields). 0: Flight-stack default (recommended), 1: address of requester, 2: broadcast."""
MAV_CMD_REQUEST_MESSAGE = 512
enums["MAV_CMD"][512] = EnumEntry("MAV_CMD_REQUEST_MESSAGE", """Request the target system(s) emit a single instance of a specified message (i.e. a "one-shot" version of MAV_CMD_SET_MESSAGE_INTERVAL).""")
enums["MAV_CMD"][512].param[1] = """The MAVLink message ID of the requested message."""
enums["MAV_CMD"][512].param[2] = """Use for index ID, if required. Otherwise, the use of this parameter (if any) must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[3] = """The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[4] = """The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[5] = """The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[6] = """The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[7] = """Target address for requested message (if message has target address fields). 0: Flight-stack default, 1: address of requester, 2: broadcast."""
MAV_CMD_REQUEST_PROTOCOL_VERSION = 519
enums["MAV_CMD"][519] = EnumEntry("MAV_CMD_REQUEST_PROTOCOL_VERSION", """Request MAVLink protocol version compatibility. All receivers should ACK the command and then emit their capabilities in an PROTOCOL_VERSION message""")
enums["MAV_CMD"][519].param[1] = """Request supported protocol versions by all nodes on the network (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][519].param[2] = """Reserved (all remaining params)"""
enums["MAV_CMD"][519].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][519].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][519].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][519].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][519].param[7] = """Reserved (default:0)"""
MAV_CMD_REQUEST_AUTOPILOT_CAPABILITIES = 520
enums["MAV_CMD"][520] = EnumEntry("MAV_CMD_REQUEST_AUTOPILOT_CAPABILITIES", """Request autopilot capabilities. The receiver should ACK the command and then emit its capabilities in an AUTOPILOT_VERSION message""")
enums["MAV_CMD"][520].param[1] = """Request autopilot version (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][520].param[2] = """Reserved (all remaining params)"""
enums["MAV_CMD"][520].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][520].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][520].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][520].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][520].param[7] = """Reserved (default:0)"""
MAV_CMD_REQUEST_CAMERA_INFORMATION = 521
enums["MAV_CMD"][521] = EnumEntry("MAV_CMD_REQUEST_CAMERA_INFORMATION", """Request camera information (CAMERA_INFORMATION).""")
enums["MAV_CMD"][521].param[1] = """Request camera capabilities (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][521].param[2] = """Reserved (all remaining params)"""
enums["MAV_CMD"][521].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][521].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][521].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][521].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][521].param[7] = """Reserved (default:0)"""
MAV_CMD_REQUEST_CAMERA_SETTINGS = 522
enums["MAV_CMD"][522] = EnumEntry("MAV_CMD_REQUEST_CAMERA_SETTINGS", """Request camera settings (CAMERA_SETTINGS).""")
enums["MAV_CMD"][522].param[1] = """Request camera settings (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][522].param[2] = """Reserved (all remaining params)"""
enums["MAV_CMD"][522].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][522].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][522].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][522].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][522].param[7] = """Reserved (default:0)"""
MAV_CMD_REQUEST_STORAGE_INFORMATION = 525
enums["MAV_CMD"][525] = EnumEntry("MAV_CMD_REQUEST_STORAGE_INFORMATION", """Request storage information (STORAGE_INFORMATION). Use the command's target_component to target a specific component's storage.""")
enums["MAV_CMD"][525].param[1] = """Storage ID (0 for all, 1 for first, 2 for second, etc.)"""
enums["MAV_CMD"][525].param[2] = """Request storage information (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][525].param[3] = """Reserved (all remaining params)"""
enums["MAV_CMD"][525].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][525].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][525].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][525].param[7] = """Reserved (default:0)"""
MAV_CMD_STORAGE_FORMAT = 526
enums["MAV_CMD"][526] = EnumEntry("MAV_CMD_STORAGE_FORMAT", """Format a storage medium. Once format is complete, a STORAGE_INFORMATION message is sent. Use the command's target_component to target a specific component's storage.""")
enums["MAV_CMD"][526].param[1] = """Storage ID (1 for first, 2 for second, etc.)"""
enums["MAV_CMD"][526].param[2] = """Format storage (and reset image log). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][526].param[3] = """Reserved (all remaining params)"""
enums["MAV_CMD"][526].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][526].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][526].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][526].param[7] = """Reserved (default:0)"""
MAV_CMD_REQUEST_CAMERA_CAPTURE_STATUS = 527
enums["MAV_CMD"][527] = EnumEntry("MAV_CMD_REQUEST_CAMERA_CAPTURE_STATUS", """Request camera capture status (CAMERA_CAPTURE_STATUS)""")
enums["MAV_CMD"][527].param[1] = """Request camera capture status (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][527].param[2] = """Reserved (all remaining params)"""
enums["MAV_CMD"][527].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][527].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][527].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][527].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][527].param[7] = """Reserved (default:0)"""
MAV_CMD_REQUEST_FLIGHT_INFORMATION = 528
enums["MAV_CMD"][528] = EnumEntry("MAV_CMD_REQUEST_FLIGHT_INFORMATION", """Request flight information (FLIGHT_INFORMATION)""")
enums["MAV_CMD"][528].param[1] = """Request flight information (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][528].param[2] = """Reserved (all remaining params)"""
enums["MAV_CMD"][528].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][528].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][528].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][528].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][528].param[7] = """Reserved (default:0)"""
MAV_CMD_RESET_CAMERA_SETTINGS = 529
enums["MAV_CMD"][529] = EnumEntry("MAV_CMD_RESET_CAMERA_SETTINGS", """Reset all camera settings to Factory Default""")
enums["MAV_CMD"][529].param[1] = """Reset all settings (MAV_BOOL_TRUE). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][529].param[2] = """Reserved (all remaining params)"""
enums["MAV_CMD"][529].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][529].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][529].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][529].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][529].param[7] = """Reserved (default:0)"""
MAV_CMD_SET_CAMERA_MODE = 530
enums["MAV_CMD"][530] = EnumEntry("MAV_CMD_SET_CAMERA_MODE", """Set camera running mode. Use NaN for reserved values. GCS will send a MAV_CMD_REQUEST_VIDEO_STREAM_STATUS command after a mode change if the camera supports video streaming.""")
enums["MAV_CMD"][530].param[1] = """Reserved (Set to 0)"""
enums["MAV_CMD"][530].param[2] = """Camera mode"""
enums["MAV_CMD"][530].param[3] = """Reserved (default:NaN)"""
enums["MAV_CMD"][530].param[4] = """Reserved (default:NaN)"""
enums["MAV_CMD"][530].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][530].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][530].param[7] = """Reserved (default:NaN)"""
MAV_CMD_SET_CAMERA_ZOOM = 531
enums["MAV_CMD"][531] = EnumEntry("MAV_CMD_SET_CAMERA_ZOOM", """Set camera zoom. Camera must respond with a CAMERA_SETTINGS message (on success).""")
enums["MAV_CMD"][531].param[1] = """Zoom type"""
enums["MAV_CMD"][531].param[2] = """Zoom value. The range of valid values depend on the zoom type."""
enums["MAV_CMD"][531].param[3] = """Reserved (default:NaN)"""
enums["MAV_CMD"][531].param[4] = """Reserved (default:NaN)"""
enums["MAV_CMD"][531].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][531].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][531].param[7] = """Reserved (default:NaN)"""
MAV_CMD_SET_CAMERA_FOCUS = 532
enums["MAV_CMD"][532] = EnumEntry("MAV_CMD_SET_CAMERA_FOCUS", """Set camera focus. Camera must respond with a CAMERA_SETTINGS message (on success).""")
enums["MAV_CMD"][532].param[1] = """Focus type"""
enums["MAV_CMD"][532].param[2] = """Focus value"""
enums["MAV_CMD"][532].param[3] = """Reserved (default:NaN)"""
enums["MAV_CMD"][532].param[4] = """Reserved (default:NaN)"""
enums["MAV_CMD"][532].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][532].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][532].param[7] = """Reserved (default:NaN)"""
MAV_CMD_SET_STORAGE_USAGE = 533
enums["MAV_CMD"][533] = EnumEntry(
    "MAV_CMD_SET_STORAGE_USAGE",
    """Set that a particular storage is the preferred location for saving photos, videos, and/or other media (e.g. to set that an SD card is used for storing videos).
          There can only be one preferred save location for each particular media type: setting a media usage flag will clear/reset that same flag if set on any other storage.
          If no flag is set the system should use its default storage.
          A target system can choose to always use default storage, in which case it should ACK the command with MAV_RESULT_UNSUPPORTED.
          A target system can choose to not allow a particular storage to be set as preferred storage, in which case it should ACK the command with MAV_RESULT_DENIED.""",
)
enums["MAV_CMD"][533].param[1] = """Storage ID (1 for first, 2 for second, etc.)"""
enums["MAV_CMD"][533].param[2] = """Usage flags"""
enums["MAV_CMD"][533].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][533].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][533].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][533].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][533].param[7] = """Reserved (default:0)"""
MAV_CMD_SET_CAMERA_SOURCE = 534
enums["MAV_CMD"][534] = EnumEntry("MAV_CMD_SET_CAMERA_SOURCE", """Set camera source. Changes the camera's active sources on cameras with multiple image sensors.""")
enums["MAV_CMD"][534].param[1] = """Component Id of camera to address or 1-6 for non-MAVLink cameras, 0 for all cameras."""
enums["MAV_CMD"][534].param[2] = """Primary Source"""
enums["MAV_CMD"][534].param[3] = """Secondary Source. If non-zero the second source will be displayed as picture-in-picture."""
enums["MAV_CMD"][534].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][534].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][534].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][534].param[7] = """Reserved (default:0)"""
MAV_CMD_JUMP_TAG = 600
enums["MAV_CMD"][600] = EnumEntry("MAV_CMD_JUMP_TAG", """Tagged jump target. Can be jumped to with MAV_CMD_DO_JUMP_TAG.""")
enums["MAV_CMD"][600].param[1] = """Tag."""
enums["MAV_CMD"][600].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][600].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][600].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][600].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][600].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][600].param[7] = """Reserved (default:0)"""
MAV_CMD_DO_JUMP_TAG = 601
enums["MAV_CMD"][601] = EnumEntry("MAV_CMD_DO_JUMP_TAG", """Jump to the matching tag in the mission list. Repeat this action for the specified number of times. A mission should contain a single matching tag for each jump. If this is not the case then a jump to a missing tag should complete the mission, and a jump where there are multiple matching tags should always select the one with the lowest mission sequence number.""")
enums["MAV_CMD"][601].param[1] = """Target tag to jump to."""
enums["MAV_CMD"][601].param[2] = """Repeat count."""
enums["MAV_CMD"][601].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][601].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][601].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][601].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][601].param[7] = """Reserved (default:0)"""
MAV_CMD_DO_GIMBAL_MANAGER_PITCHYAW = 1000
enums["MAV_CMD"][1000] = EnumEntry("MAV_CMD_DO_GIMBAL_MANAGER_PITCHYAW", """Set gimbal manager pitch/yaw setpoints (low rate command). It is possible to set combinations of the values below. E.g. an angle as well as a desired angular rate can be used to get to this angle at a certain angular rate, or an angular rate only will result in continuous turning. NaN is to be used to signal unset. Note: only the gimbal manager will react to this command - it will be ignored by a gimbal device. Use GIMBAL_MANAGER_SET_PITCHYAW if you need to stream pitch/yaw setpoints at higher rate. """)
enums["MAV_CMD"][1000].param[1] = """Pitch angle (positive to pitch up, relative to vehicle for FOLLOW mode, relative to world horizon for LOCK mode)."""
enums["MAV_CMD"][1000].param[2] = """Yaw angle (positive to yaw to the right, relative to vehicle for FOLLOW mode, absolute to North for LOCK mode)."""
enums["MAV_CMD"][1000].param[3] = """Pitch rate (positive to pitch up)."""
enums["MAV_CMD"][1000].param[4] = """Yaw rate (positive to yaw to the right)."""
enums["MAV_CMD"][1000].param[5] = """Gimbal manager flags to use."""
enums["MAV_CMD"][1000].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][1000].param[7] = """Component ID of gimbal device to address (or 1-6 for non-MAVLink gimbal), 0 for all gimbal device components. Send command multiple times for more than one gimbal (but not all gimbals)."""
MAV_CMD_DO_GIMBAL_MANAGER_CONFIGURE = 1001
enums["MAV_CMD"][1001] = EnumEntry("MAV_CMD_DO_GIMBAL_MANAGER_CONFIGURE", """Gimbal configuration to set which sysid/compid is in primary and secondary control.""")
enums["MAV_CMD"][1001].param[1] = """Sysid for primary control (0: no one in control, -1: leave unchanged, -2: set itself in control (for missions where the own sysid is still unknown), -3: remove control if currently in control)."""
enums["MAV_CMD"][1001].param[2] = """Compid for primary control (0: no one in control, -1: leave unchanged, -2: set itself in control (for missions where the own sysid is still unknown), -3: remove control if currently in control)."""
enums["MAV_CMD"][1001].param[3] = """Sysid for secondary control (0: no one in control, -1: leave unchanged, -2: set itself in control (for missions where the own sysid is still unknown), -3: remove control if currently in control)."""
enums["MAV_CMD"][1001].param[4] = """Compid for secondary control (0: no one in control, -1: leave unchanged, -2: set itself in control (for missions where the own sysid is still unknown), -3: remove control if currently in control)."""
enums["MAV_CMD"][1001].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][1001].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][1001].param[7] = """Component ID of gimbal device to address (or 1-6 for non-MAVLink gimbal), 0 for all gimbal device components. Send command multiple times for more than one gimbal (but not all gimbals)."""
MAV_CMD_IMAGE_START_CAPTURE = 2000
enums["MAV_CMD"][2000] = EnumEntry(
    "MAV_CMD_IMAGE_START_CAPTURE",
    """Start image capture sequence. CAMERA_IMAGE_CAPTURED must be emitted after each capture.

          Param1 (id) may be used to specify the target camera: 0: all cameras, 1 to 6: autopilot-connected cameras, 7-255: MAVLink camera component ID.
          It is needed in order to target specific cameras connected to the autopilot, or specific sensors in a multi-sensor camera (neither of which have a distinct MAVLink component ID).
          It is also needed to specify the target camera in missions.

          When used in a mission, an autopilot should execute the MAV_CMD for a specified local camera (param1 = 1-6), or resend it as a command if it is intended for a MAVLink camera (param1 = 7 - 255), setting the command's target_component as the param1 value (and setting param1 in the command to zero).
          If the param1 is 0 the autopilot should do both.

          When sent in a command the target MAVLink address is set using target_component.
          If addressed specifically to an autopilot: param1 should be used in the same way as it is for missions (though command should NACK with MAV_RESULT_DENIED if a specified local camera does not exist).
          If addressed to a MAVLink camera, param 1 can be used to address all cameras (0), or to separately address 1 to 7 individual sensors. Other values should be NACKed with MAV_RESULT_DENIED.
          If the command is broadcast (target_component is 0) then param 1 should be set to 0 (any other value should be NACKED with MAV_RESULT_DENIED). An autopilot would trigger any local cameras and forward the command to all channels.
        """,
)
enums["MAV_CMD"][2000].param[1] = """Target camera ID. 7 to 255: MAVLink camera component id. 1 to 6 for cameras that don't have a distinct component id (such as autopilot-attached cameras). 0: all cameras. This is used to specifically target autopilot-connected cameras or individual sensors in a multi-sensor MAVLink camera. It is also used to target specific cameras when the MAV_CMD is used in a mission"""
enums["MAV_CMD"][2000].param[2] = """Desired elapsed time between two consecutive pictures (in seconds). Minimum values depend on hardware (typically greater than 2 seconds)."""
enums["MAV_CMD"][2000].param[3] = """Total number of images to capture. 0 to capture forever/until MAV_CMD_IMAGE_STOP_CAPTURE."""
enums["MAV_CMD"][2000].param[4] = """Capture sequence number starting from 1. This is only valid for single-capture (param3 == 1), otherwise set to 0. Increment the capture ID for each capture command to prevent double captures when a command is re-transmitted."""
enums["MAV_CMD"][2000].param[5] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2000].param[6] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2000].param[7] = """Reserved (default:NaN)"""
MAV_CMD_IMAGE_STOP_CAPTURE = 2001
enums["MAV_CMD"][2001] = EnumEntry(
    "MAV_CMD_IMAGE_STOP_CAPTURE",
    """Stop image capture sequence.

          Param1 (id) may be used to specify the target camera: 0: all cameras, 1 to 6: autopilot-connected cameras, 7-255: MAVLink camera component ID.
          It is needed in order to target specific cameras connected to the autopilot, or specific sensors in a multi-sensor camera (neither of which have a distinct MAVLink component ID).
          It is also needed to specify the target camera in missions.

          When used in a mission, an autopilot should execute the MAV_CMD for a specified local camera (param1 = 1-6), or resend it as a command if it is intended for a MAVLink camera (param1 = 7 - 255), setting the command's target_component as the param1 value (and setting param1 in the command to zero).
          If the param1 is 0 the autopilot should do both.

          When sent in a command the target MAVLink address is set using target_component.
          If addressed specifically to an autopilot: param1 should be used in the same way as it is for missions (though command should NACK with MAV_RESULT_DENIED if a specified local camera does not exist).
          If addressed to a MAVLink camera, param1 can be used to address all cameras (0), or to separately address 1 to 7 individual sensors. Other values should be NACKed with MAV_RESULT_DENIED.
          If the command is broadcast (target_component is 0) then param 1 should be set to 0 (any other value should be NACKED with MAV_RESULT_DENIED). An autopilot would trigger any local cameras and forward the command to all channels.
        """,
)
enums["MAV_CMD"][2001].param[1] = """Target camera ID. 7 to 255: MAVLink camera component id. 1 to 6 for cameras that don't have a distinct component id (such as autopilot-attached cameras). 0: all cameras. This is used to specifically target autopilot-connected cameras or individual sensors in a multi-sensor MAVLink camera. It is also used to target specific cameras when the MAV_CMD is used in a mission"""
enums["MAV_CMD"][2001].param[2] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2001].param[3] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2001].param[4] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2001].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2001].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2001].param[7] = """Reserved (default:NaN)"""
MAV_CMD_DO_TRIGGER_CONTROL = 2003
enums["MAV_CMD"][2003] = EnumEntry("MAV_CMD_DO_TRIGGER_CONTROL", """Enable or disable on-board camera triggering system.""")
enums["MAV_CMD"][2003].param[1] = """Trigger enable/disable (0 for disable, 1 for start), -1 to ignore"""
enums["MAV_CMD"][2003].param[2] = """1 to reset the trigger sequence, -1 or 0 to ignore"""
enums["MAV_CMD"][2003].param[3] = """1 to pause triggering, but without switching the camera off or retracting it. -1 to ignore"""
enums["MAV_CMD"][2003].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][2003].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2003].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2003].param[7] = """Reserved (default:0)"""
MAV_CMD_CAMERA_TRACK_POINT = 2004
enums["MAV_CMD"][2004] = EnumEntry("MAV_CMD_CAMERA_TRACK_POINT", """If the camera supports point visual tracking (CAMERA_CAP_FLAGS_HAS_TRACKING_POINT is set), this command allows to initiate the tracking.""")
enums["MAV_CMD"][2004].param[1] = """Point to track x value (normalized 0..1, 0 is left, 1 is right)."""
enums["MAV_CMD"][2004].param[2] = """Point to track y value (normalized 0..1, 0 is top, 1 is bottom)."""
enums["MAV_CMD"][2004].param[3] = """Point radius (normalized 0..1, 0 is image left, 1 is image right)."""
enums["MAV_CMD"][2004].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][2004].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2004].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2004].param[7] = """Reserved (default:0)"""
MAV_CMD_CAMERA_TRACK_RECTANGLE = 2005
enums["MAV_CMD"][2005] = EnumEntry("MAV_CMD_CAMERA_TRACK_RECTANGLE", """If the camera supports rectangle visual tracking (CAMERA_CAP_FLAGS_HAS_TRACKING_RECTANGLE is set), this command allows to initiate the tracking.""")
enums["MAV_CMD"][2005].param[1] = """Top left corner of rectangle x value (normalized 0..1, 0 is left, 1 is right)."""
enums["MAV_CMD"][2005].param[2] = """Top left corner of rectangle y value (normalized 0..1, 0 is top, 1 is bottom)."""
enums["MAV_CMD"][2005].param[3] = """Bottom right corner of rectangle x value (normalized 0..1, 0 is left, 1 is right)."""
enums["MAV_CMD"][2005].param[4] = """Bottom right corner of rectangle y value (normalized 0..1, 0 is top, 1 is bottom)."""
enums["MAV_CMD"][2005].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2005].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2005].param[7] = """Reserved (default:0)"""
MAV_CMD_CAMERA_STOP_TRACKING = 2010
enums["MAV_CMD"][2010] = EnumEntry("MAV_CMD_CAMERA_STOP_TRACKING", """Stops ongoing tracking.""")
enums["MAV_CMD"][2010].param[1] = """Reserved (default:0)"""
enums["MAV_CMD"][2010].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][2010].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][2010].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][2010].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2010].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2010].param[7] = """Reserved (default:0)"""
MAV_CMD_VIDEO_START_CAPTURE = 2500
enums["MAV_CMD"][2500] = EnumEntry("MAV_CMD_VIDEO_START_CAPTURE", """Starts video capture (recording).""")
enums["MAV_CMD"][2500].param[1] = """Video Stream ID (0 for all streams)"""
enums["MAV_CMD"][2500].param[2] = """Frequency CAMERA_CAPTURE_STATUS messages should be sent while recording (0 for no messages, otherwise frequency)"""
enums["MAV_CMD"][2500].param[3] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2500].param[4] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2500].param[5] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2500].param[6] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2500].param[7] = """Reserved (default:NaN)"""
MAV_CMD_VIDEO_STOP_CAPTURE = 2501
enums["MAV_CMD"][2501] = EnumEntry("MAV_CMD_VIDEO_STOP_CAPTURE", """Stop the current video capture (recording).""")
enums["MAV_CMD"][2501].param[1] = """Video Stream ID (0 for all streams)"""
enums["MAV_CMD"][2501].param[2] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2501].param[3] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2501].param[4] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2501].param[5] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2501].param[6] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2501].param[7] = """Reserved (default:NaN)"""
MAV_CMD_VIDEO_START_STREAMING = 2502
enums["MAV_CMD"][2502] = EnumEntry("MAV_CMD_VIDEO_START_STREAMING", """Start video streaming""")
enums["MAV_CMD"][2502].param[1] = """Video Stream ID (0 for all streams, 1 for first, 2 for second, etc.)"""
enums["MAV_CMD"][2502].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][2502].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][2502].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][2502].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2502].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2502].param[7] = """Reserved (default:0)"""
MAV_CMD_VIDEO_STOP_STREAMING = 2503
enums["MAV_CMD"][2503] = EnumEntry("MAV_CMD_VIDEO_STOP_STREAMING", """Stop the given video stream""")
enums["MAV_CMD"][2503].param[1] = """Video Stream ID (0 for all streams, 1 for first, 2 for second, etc.)"""
enums["MAV_CMD"][2503].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][2503].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][2503].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][2503].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2503].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2503].param[7] = """Reserved (default:0)"""
MAV_CMD_REQUEST_VIDEO_STREAM_INFORMATION = 2504
enums["MAV_CMD"][2504] = EnumEntry("MAV_CMD_REQUEST_VIDEO_STREAM_INFORMATION", """Request video stream information (VIDEO_STREAM_INFORMATION)""")
enums["MAV_CMD"][2504].param[1] = """Video Stream ID (0 for all streams, 1 for first, 2 for second, etc.)"""
enums["MAV_CMD"][2504].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][2504].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][2504].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][2504].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2504].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2504].param[7] = """Reserved (default:0)"""
MAV_CMD_REQUEST_VIDEO_STREAM_STATUS = 2505
enums["MAV_CMD"][2505] = EnumEntry("MAV_CMD_REQUEST_VIDEO_STREAM_STATUS", """Request video stream status (VIDEO_STREAM_STATUS)""")
enums["MAV_CMD"][2505].param[1] = """Video Stream ID (0 for all streams, 1 for first, 2 for second, etc.)"""
enums["MAV_CMD"][2505].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][2505].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][2505].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][2505].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2505].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2505].param[7] = """Reserved (default:0)"""
MAV_CMD_LOGGING_START = 2510
enums["MAV_CMD"][2510] = EnumEntry("MAV_CMD_LOGGING_START", """Request to start streaming logging data over MAVLink (see also LOGGING_DATA message)""")
enums["MAV_CMD"][2510].param[1] = """Format: 0: ULog"""
enums["MAV_CMD"][2510].param[2] = """Reserved (set to 0)"""
enums["MAV_CMD"][2510].param[3] = """Reserved (set to 0)"""
enums["MAV_CMD"][2510].param[4] = """Reserved (set to 0)"""
enums["MAV_CMD"][2510].param[5] = """Reserved (set to 0)"""
enums["MAV_CMD"][2510].param[6] = """Reserved (set to 0)"""
enums["MAV_CMD"][2510].param[7] = """Reserved (set to 0)"""
MAV_CMD_LOGGING_STOP = 2511
enums["MAV_CMD"][2511] = EnumEntry("MAV_CMD_LOGGING_STOP", """Request to stop streaming log data over MAVLink""")
enums["MAV_CMD"][2511].param[1] = """Reserved (set to 0)"""
enums["MAV_CMD"][2511].param[2] = """Reserved (set to 0)"""
enums["MAV_CMD"][2511].param[3] = """Reserved (set to 0)"""
enums["MAV_CMD"][2511].param[4] = """Reserved (set to 0)"""
enums["MAV_CMD"][2511].param[5] = """Reserved (set to 0)"""
enums["MAV_CMD"][2511].param[6] = """Reserved (set to 0)"""
enums["MAV_CMD"][2511].param[7] = """Reserved (set to 0)"""
MAV_CMD_AIRFRAME_CONFIGURATION = 2520
enums["MAV_CMD"][2520] = EnumEntry("MAV_CMD_AIRFRAME_CONFIGURATION", """""")
enums["MAV_CMD"][2520].param[1] = """Landing gear ID (default: 0, -1 for all)"""
enums["MAV_CMD"][2520].param[2] = """Landing gear position (Down: 0, Up: 1, NaN for no change)"""
enums["MAV_CMD"][2520].param[3] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2520].param[4] = """Reserved (default:NaN)"""
enums["MAV_CMD"][2520].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2520].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2520].param[7] = """Reserved (default:NaN)"""
MAV_CMD_CONTROL_HIGH_LATENCY = 2600
enums["MAV_CMD"][2600] = EnumEntry("MAV_CMD_CONTROL_HIGH_LATENCY", """Request to start/stop transmitting over the high latency telemetry""")
enums["MAV_CMD"][2600].param[1] = """Start transmission over high latency telemetry (MAV_BOOL_FALSE: stop transmission). Values not equal to 0 or 1 are invalid."""
enums["MAV_CMD"][2600].param[2] = """Empty"""
enums["MAV_CMD"][2600].param[3] = """Empty"""
enums["MAV_CMD"][2600].param[4] = """Empty"""
enums["MAV_CMD"][2600].param[5] = """Empty"""
enums["MAV_CMD"][2600].param[6] = """Empty"""
enums["MAV_CMD"][2600].param[7] = """Empty"""
MAV_CMD_PANORAMA_CREATE = 2800
enums["MAV_CMD"][2800] = EnumEntry("MAV_CMD_PANORAMA_CREATE", """Create a panorama at the current position""")
enums["MAV_CMD"][2800].param[1] = """Viewing angle horizontal of the panorama (+- 0.5 the total angle)"""
enums["MAV_CMD"][2800].param[2] = """Viewing angle vertical of panorama."""
enums["MAV_CMD"][2800].param[3] = """Speed of the horizontal rotation."""
enums["MAV_CMD"][2800].param[4] = """Speed of the vertical rotation."""
enums["MAV_CMD"][2800].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][2800].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][2800].param[7] = """Reserved (default:0)"""
MAV_CMD_DO_VTOL_TRANSITION = 3000
enums["MAV_CMD"][3000] = EnumEntry("MAV_CMD_DO_VTOL_TRANSITION", """Request VTOL transition""")
enums["MAV_CMD"][3000].param[1] = """The target VTOL state. Only MAV_VTOL_STATE_MC and MAV_VTOL_STATE_FW can be used."""
enums["MAV_CMD"][3000].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][3000].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][3000].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][3000].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][3000].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][3000].param[7] = """Reserved (default:0)"""
MAV_CMD_ARM_AUTHORIZATION_REQUEST = 3001
enums["MAV_CMD"][3001] = EnumEntry(
    "MAV_CMD_ARM_AUTHORIZATION_REQUEST",
    """Request authorization to arm the vehicle to a external entity, the arm authorizer is responsible to request all data that is needs from the vehicle before authorize or deny the request. If approved the progress of command_ack message should be set with period of time that this authorization is valid in seconds or in case it was denied it should be set with one of the reasons in ARM_AUTH_DENIED_REASON.
        """,
)
enums["MAV_CMD"][3001].param[1] = """Vehicle system id, this way ground station can request arm authorization on behalf of any vehicle"""
enums["MAV_CMD"][3001].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][3001].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][3001].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][3001].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][3001].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][3001].param[7] = """Reserved (default:0)"""
MAV_CMD_SET_GUIDED_SUBMODE_STANDARD = 4000
enums["MAV_CMD"][4000] = EnumEntry(
    "MAV_CMD_SET_GUIDED_SUBMODE_STANDARD",
    """This command sets the submode to standard guided when vehicle is in guided mode. The vehicle holds position and altitude and the user can input the desired velocities along all three axes.
                  """,
)
enums["MAV_CMD"][4000].param[1] = """Reserved (default:0)"""
enums["MAV_CMD"][4000].param[2] = """Reserved (default:0)"""
enums["MAV_CMD"][4000].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][4000].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][4000].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][4000].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][4000].param[7] = """Reserved (default:0)"""
MAV_CMD_SET_GUIDED_SUBMODE_CIRCLE = 4001
enums["MAV_CMD"][4001] = EnumEntry(
    "MAV_CMD_SET_GUIDED_SUBMODE_CIRCLE",
    """This command sets submode circle when vehicle is in guided mode. Vehicle flies along a circle facing the center of the circle. The user can input the velocity along the circle and change the radius. If no input is given the vehicle will hold position.
                  """,
)
enums["MAV_CMD"][4001].has_location = True
enums["MAV_CMD"][4001].param[1] = """Radius of desired circle in CIRCLE_MODE"""
enums["MAV_CMD"][4001].param[2] = """User defined"""
enums["MAV_CMD"][4001].param[3] = """User defined"""
enums["MAV_CMD"][4001].param[4] = """User defined"""
enums["MAV_CMD"][4001].param[5] = """Target latitude of center of circle in CIRCLE_MODE"""
enums["MAV_CMD"][4001].param[6] = """Target longitude of center of circle in CIRCLE_MODE"""
enums["MAV_CMD"][4001].param[7] = """Reserved (default:0)"""
MAV_CMD_NAV_FENCE_RETURN_POINT = 5000
enums["MAV_CMD"][5000] = EnumEntry("MAV_CMD_NAV_FENCE_RETURN_POINT", """Fence return point (there can only be one such point in a geofence definition). If rally points are supported they should be used instead.""")
enums["MAV_CMD"][5000].has_location = True
enums["MAV_CMD"][5000].param[1] = """Reserved"""
enums["MAV_CMD"][5000].param[2] = """Reserved"""
enums["MAV_CMD"][5000].param[3] = """Reserved"""
enums["MAV_CMD"][5000].param[4] = """Reserved"""
enums["MAV_CMD"][5000].param[5] = """Latitude"""
enums["MAV_CMD"][5000].param[6] = """Longitude"""
enums["MAV_CMD"][5000].param[7] = """Altitude"""
MAV_CMD_NAV_FENCE_POLYGON_VERTEX_INCLUSION = 5001
enums["MAV_CMD"][5001] = EnumEntry(
    "MAV_CMD_NAV_FENCE_POLYGON_VERTEX_INCLUSION",
    """Fence vertex for an inclusion polygon (the polygon must not be self-intersecting). The vehicle must stay within this area. Minimum of 3 vertices required.
        """,
)
enums["MAV_CMD"][5001].has_location = True
enums["MAV_CMD"][5001].param[1] = """Polygon vertex count"""
enums["MAV_CMD"][5001].param[2] = """Vehicle must be inside ALL inclusion zones in a single group, vehicle must be inside at least one group, must be the same for all points in each polygon"""
enums["MAV_CMD"][5001].param[3] = """Reserved"""
enums["MAV_CMD"][5001].param[4] = """Reserved"""
enums["MAV_CMD"][5001].param[5] = """Latitude"""
enums["MAV_CMD"][5001].param[6] = """Longitude"""
enums["MAV_CMD"][5001].param[7] = """Reserved"""
MAV_CMD_NAV_FENCE_POLYGON_VERTEX_EXCLUSION = 5002
enums["MAV_CMD"][5002] = EnumEntry(
    "MAV_CMD_NAV_FENCE_POLYGON_VERTEX_EXCLUSION",
    """Fence vertex for an exclusion polygon (the polygon must not be self-intersecting). The vehicle must stay outside this area. Minimum of 3 vertices required.
        """,
)
enums["MAV_CMD"][5002].has_location = True
enums["MAV_CMD"][5002].param[1] = """Polygon vertex count"""
enums["MAV_CMD"][5002].param[2] = """Reserved"""
enums["MAV_CMD"][5002].param[3] = """Reserved"""
enums["MAV_CMD"][5002].param[4] = """Reserved"""
enums["MAV_CMD"][5002].param[5] = """Latitude"""
enums["MAV_CMD"][5002].param[6] = """Longitude"""
enums["MAV_CMD"][5002].param[7] = """Reserved"""
MAV_CMD_NAV_FENCE_CIRCLE_INCLUSION = 5003
enums["MAV_CMD"][5003] = EnumEntry(
    "MAV_CMD_NAV_FENCE_CIRCLE_INCLUSION",
    """Circular fence area. The vehicle must stay inside this area.
        """,
)
enums["MAV_CMD"][5003].has_location = True
enums["MAV_CMD"][5003].param[1] = """Radius."""
enums["MAV_CMD"][5003].param[2] = """Vehicle must be inside ALL inclusion zones in a single group, vehicle must be inside at least one group"""
enums["MAV_CMD"][5003].param[3] = """Reserved"""
enums["MAV_CMD"][5003].param[4] = """Reserved"""
enums["MAV_CMD"][5003].param[5] = """Latitude"""
enums["MAV_CMD"][5003].param[6] = """Longitude"""
enums["MAV_CMD"][5003].param[7] = """Reserved"""
MAV_CMD_NAV_FENCE_CIRCLE_EXCLUSION = 5004
enums["MAV_CMD"][5004] = EnumEntry(
    "MAV_CMD_NAV_FENCE_CIRCLE_EXCLUSION",
    """Circular fence area. The vehicle must stay outside this area.
        """,
)
enums["MAV_CMD"][5004].has_location = True
enums["MAV_CMD"][5004].param[1] = """Radius."""
enums["MAV_CMD"][5004].param[2] = """Reserved"""
enums["MAV_CMD"][5004].param[3] = """Reserved"""
enums["MAV_CMD"][5004].param[4] = """Reserved"""
enums["MAV_CMD"][5004].param[5] = """Latitude"""
enums["MAV_CMD"][5004].param[6] = """Longitude"""
enums["MAV_CMD"][5004].param[7] = """Reserved"""
MAV_CMD_NAV_RALLY_POINT = 5100
enums["MAV_CMD"][5100] = EnumEntry(
    "MAV_CMD_NAV_RALLY_POINT",
    """Rally point. You can have multiple rally points defined.
        """,
)
enums["MAV_CMD"][5100].has_location = True
enums["MAV_CMD"][5100].param[1] = """Reserved"""
enums["MAV_CMD"][5100].param[2] = """Reserved"""
enums["MAV_CMD"][5100].param[3] = """Reserved"""
enums["MAV_CMD"][5100].param[4] = """Reserved"""
enums["MAV_CMD"][5100].param[5] = """Latitude"""
enums["MAV_CMD"][5100].param[6] = """Longitude"""
enums["MAV_CMD"][5100].param[7] = """Altitude"""
MAV_CMD_UAVCAN_GET_NODE_INFO = 5200
enums["MAV_CMD"][5200] = EnumEntry("MAV_CMD_UAVCAN_GET_NODE_INFO", """Commands the vehicle to respond with a sequence of messages UAVCAN_NODE_INFO, one message per every UAVCAN node that is online. Note that some of the response messages can be lost, which the receiver can detect easily by checking whether every received UAVCAN_NODE_STATUS has a matching message UAVCAN_NODE_INFO received earlier; if not, this command should be sent again in order to request re-transmission of the node information messages.""")
enums["MAV_CMD"][5200].param[1] = """Reserved (set to 0)"""
enums["MAV_CMD"][5200].param[2] = """Reserved (set to 0)"""
enums["MAV_CMD"][5200].param[3] = """Reserved (set to 0)"""
enums["MAV_CMD"][5200].param[4] = """Reserved (set to 0)"""
enums["MAV_CMD"][5200].param[5] = """Reserved (set to 0)"""
enums["MAV_CMD"][5200].param[6] = """Reserved (set to 0)"""
enums["MAV_CMD"][5200].param[7] = """Reserved (set to 0)"""
MAV_CMD_DO_SET_SAFETY_SWITCH_STATE = 5300
enums["MAV_CMD"][5300] = EnumEntry("MAV_CMD_DO_SET_SAFETY_SWITCH_STATE", """Change state of safety switch.""")
enums["MAV_CMD"][5300].param[1] = """New safety switch state."""
enums["MAV_CMD"][5300].param[2] = """Empty."""
enums["MAV_CMD"][5300].param[3] = """Empty."""
enums["MAV_CMD"][5300].param[4] = """Empty"""
enums["MAV_CMD"][5300].param[5] = """Empty."""
enums["MAV_CMD"][5300].param[6] = """Empty."""
enums["MAV_CMD"][5300].param[7] = """Empty."""
MAV_CMD_DO_ADSB_OUT_IDENT = 10001
enums["MAV_CMD"][10001] = EnumEntry("MAV_CMD_DO_ADSB_OUT_IDENT", """Trigger the start of an ADSB-out IDENT. This should only be used when requested to do so by an Air Traffic Controller in controlled airspace. This starts the IDENT which is then typically held for 18 seconds by the hardware per the Mode A, C, and S transponder spec.""")
enums["MAV_CMD"][10001].param[1] = """Reserved (set to 0)"""
enums["MAV_CMD"][10001].param[2] = """Reserved (set to 0)"""
enums["MAV_CMD"][10001].param[3] = """Reserved (set to 0)"""
enums["MAV_CMD"][10001].param[4] = """Reserved (set to 0)"""
enums["MAV_CMD"][10001].param[5] = """Reserved (set to 0)"""
enums["MAV_CMD"][10001].param[6] = """Reserved (set to 0)"""
enums["MAV_CMD"][10001].param[7] = """Reserved (set to 0)"""
MAV_CMD_PAYLOAD_PREPARE_DEPLOY = 30001
enums["MAV_CMD"][30001] = EnumEntry("MAV_CMD_PAYLOAD_PREPARE_DEPLOY", """Deploy payload on a Lat / Lon / Alt position. This includes the navigation to reach the required release position and velocity.""")
enums["MAV_CMD"][30001].has_location = True
enums["MAV_CMD"][30001].param[1] = """Operation mode. 0: prepare single payload deploy (overwriting previous requests), but do not execute it. 1: execute payload deploy immediately (rejecting further deploy commands during execution, but allowing abort). 2: add payload deploy to existing deployment list."""
enums["MAV_CMD"][30001].param[2] = """Desired approach vector in compass heading. A negative value indicates the system can define the approach vector at will."""
enums["MAV_CMD"][30001].param[3] = """Desired ground speed at release time. This can be overridden by the airframe in case it needs to meet minimum airspeed. A negative value indicates the system can define the ground speed at will."""
enums["MAV_CMD"][30001].param[4] = """Minimum altitude clearance to the release position. A negative value indicates the system can define the clearance at will."""
enums["MAV_CMD"][30001].param[5] = """Latitude. Note, if used in MISSION_ITEM (deprecated) the units are degrees (unscaled)"""
enums["MAV_CMD"][30001].param[6] = """Longitude. Note, if used in MISSION_ITEM (deprecated) the units are degrees (unscaled)"""
enums["MAV_CMD"][30001].param[7] = """Altitude (MSL)"""
MAV_CMD_PAYLOAD_CONTROL_DEPLOY = 30002
enums["MAV_CMD"][30002] = EnumEntry("MAV_CMD_PAYLOAD_CONTROL_DEPLOY", """Control the payload deployment.""")
enums["MAV_CMD"][30002].param[1] = """Operation mode. 0: Abort deployment, continue normal mission. 1: switch to payload deployment mode. 100: delete first payload deployment request. 101: delete all payload deployment requests."""
enums["MAV_CMD"][30002].param[2] = """Reserved"""
enums["MAV_CMD"][30002].param[3] = """Reserved"""
enums["MAV_CMD"][30002].param[4] = """Reserved"""
enums["MAV_CMD"][30002].param[5] = """Reserved"""
enums["MAV_CMD"][30002].param[6] = """Reserved"""
enums["MAV_CMD"][30002].param[7] = """Reserved"""
MAV_CMD_WAYPOINT_USER_1 = 31000
enums["MAV_CMD"][31000] = EnumEntry("MAV_CMD_WAYPOINT_USER_1", """User defined waypoint item. Ground Station will show the Vehicle as flying through this item.""")
enums["MAV_CMD"][31000].has_location = True
enums["MAV_CMD"][31000].param[1] = """User defined"""
enums["MAV_CMD"][31000].param[2] = """User defined"""
enums["MAV_CMD"][31000].param[3] = """User defined"""
enums["MAV_CMD"][31000].param[4] = """User defined"""
enums["MAV_CMD"][31000].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31000].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31000].param[7] = """Altitude (MSL)"""
MAV_CMD_WAYPOINT_USER_2 = 31001
enums["MAV_CMD"][31001] = EnumEntry("MAV_CMD_WAYPOINT_USER_2", """User defined waypoint item. Ground Station will show the Vehicle as flying through this item.""")
enums["MAV_CMD"][31001].has_location = True
enums["MAV_CMD"][31001].param[1] = """User defined"""
enums["MAV_CMD"][31001].param[2] = """User defined"""
enums["MAV_CMD"][31001].param[3] = """User defined"""
enums["MAV_CMD"][31001].param[4] = """User defined"""
enums["MAV_CMD"][31001].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31001].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31001].param[7] = """Altitude (MSL)"""
MAV_CMD_WAYPOINT_USER_3 = 31002
enums["MAV_CMD"][31002] = EnumEntry("MAV_CMD_WAYPOINT_USER_3", """User defined waypoint item. Ground Station will show the Vehicle as flying through this item.""")
enums["MAV_CMD"][31002].has_location = True
enums["MAV_CMD"][31002].param[1] = """User defined"""
enums["MAV_CMD"][31002].param[2] = """User defined"""
enums["MAV_CMD"][31002].param[3] = """User defined"""
enums["MAV_CMD"][31002].param[4] = """User defined"""
enums["MAV_CMD"][31002].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31002].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31002].param[7] = """Altitude (MSL)"""
MAV_CMD_WAYPOINT_USER_4 = 31003
enums["MAV_CMD"][31003] = EnumEntry("MAV_CMD_WAYPOINT_USER_4", """User defined waypoint item. Ground Station will show the Vehicle as flying through this item.""")
enums["MAV_CMD"][31003].has_location = True
enums["MAV_CMD"][31003].param[1] = """User defined"""
enums["MAV_CMD"][31003].param[2] = """User defined"""
enums["MAV_CMD"][31003].param[3] = """User defined"""
enums["MAV_CMD"][31003].param[4] = """User defined"""
enums["MAV_CMD"][31003].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31003].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31003].param[7] = """Altitude (MSL)"""
MAV_CMD_WAYPOINT_USER_5 = 31004
enums["MAV_CMD"][31004] = EnumEntry("MAV_CMD_WAYPOINT_USER_5", """User defined waypoint item. Ground Station will show the Vehicle as flying through this item.""")
enums["MAV_CMD"][31004].has_location = True
enums["MAV_CMD"][31004].param[1] = """User defined"""
enums["MAV_CMD"][31004].param[2] = """User defined"""
enums["MAV_CMD"][31004].param[3] = """User defined"""
enums["MAV_CMD"][31004].param[4] = """User defined"""
enums["MAV_CMD"][31004].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31004].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31004].param[7] = """Altitude (MSL)"""
MAV_CMD_SPATIAL_USER_1 = 31005
enums["MAV_CMD"][31005] = EnumEntry("MAV_CMD_SPATIAL_USER_1", """User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.""")
enums["MAV_CMD"][31005].has_location = True
enums["MAV_CMD"][31005].param[1] = """User defined"""
enums["MAV_CMD"][31005].param[2] = """User defined"""
enums["MAV_CMD"][31005].param[3] = """User defined"""
enums["MAV_CMD"][31005].param[4] = """User defined"""
enums["MAV_CMD"][31005].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31005].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31005].param[7] = """Altitude (MSL)"""
MAV_CMD_SPATIAL_USER_2 = 31006
enums["MAV_CMD"][31006] = EnumEntry("MAV_CMD_SPATIAL_USER_2", """User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.""")
enums["MAV_CMD"][31006].has_location = True
enums["MAV_CMD"][31006].param[1] = """User defined"""
enums["MAV_CMD"][31006].param[2] = """User defined"""
enums["MAV_CMD"][31006].param[3] = """User defined"""
enums["MAV_CMD"][31006].param[4] = """User defined"""
enums["MAV_CMD"][31006].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31006].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31006].param[7] = """Altitude (MSL)"""
MAV_CMD_SPATIAL_USER_3 = 31007
enums["MAV_CMD"][31007] = EnumEntry("MAV_CMD_SPATIAL_USER_3", """User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.""")
enums["MAV_CMD"][31007].has_location = True
enums["MAV_CMD"][31007].param[1] = """User defined"""
enums["MAV_CMD"][31007].param[2] = """User defined"""
enums["MAV_CMD"][31007].param[3] = """User defined"""
enums["MAV_CMD"][31007].param[4] = """User defined"""
enums["MAV_CMD"][31007].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31007].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31007].param[7] = """Altitude (MSL)"""
MAV_CMD_SPATIAL_USER_4 = 31008
enums["MAV_CMD"][31008] = EnumEntry("MAV_CMD_SPATIAL_USER_4", """User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.""")
enums["MAV_CMD"][31008].has_location = True
enums["MAV_CMD"][31008].param[1] = """User defined"""
enums["MAV_CMD"][31008].param[2] = """User defined"""
enums["MAV_CMD"][31008].param[3] = """User defined"""
enums["MAV_CMD"][31008].param[4] = """User defined"""
enums["MAV_CMD"][31008].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31008].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31008].param[7] = """Altitude (MSL)"""
MAV_CMD_SPATIAL_USER_5 = 31009
enums["MAV_CMD"][31009] = EnumEntry("MAV_CMD_SPATIAL_USER_5", """User defined spatial item. Ground Station will not show the Vehicle as flying through this item. Example: ROI item.""")
enums["MAV_CMD"][31009].has_location = True
enums["MAV_CMD"][31009].param[1] = """User defined"""
enums["MAV_CMD"][31009].param[2] = """User defined"""
enums["MAV_CMD"][31009].param[3] = """User defined"""
enums["MAV_CMD"][31009].param[4] = """User defined"""
enums["MAV_CMD"][31009].param[5] = """Latitude unscaled"""
enums["MAV_CMD"][31009].param[6] = """Longitude unscaled"""
enums["MAV_CMD"][31009].param[7] = """Altitude (MSL)"""
MAV_CMD_USER_1 = 31010
enums["MAV_CMD"][31010] = EnumEntry("MAV_CMD_USER_1", """User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.""")
enums["MAV_CMD"][31010].param[1] = """User defined"""
enums["MAV_CMD"][31010].param[2] = """User defined"""
enums["MAV_CMD"][31010].param[3] = """User defined"""
enums["MAV_CMD"][31010].param[4] = """User defined"""
enums["MAV_CMD"][31010].param[5] = """User defined"""
enums["MAV_CMD"][31010].param[6] = """User defined"""
enums["MAV_CMD"][31010].param[7] = """User defined"""
MAV_CMD_USER_2 = 31011
enums["MAV_CMD"][31011] = EnumEntry("MAV_CMD_USER_2", """User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.""")
enums["MAV_CMD"][31011].param[1] = """User defined"""
enums["MAV_CMD"][31011].param[2] = """User defined"""
enums["MAV_CMD"][31011].param[3] = """User defined"""
enums["MAV_CMD"][31011].param[4] = """User defined"""
enums["MAV_CMD"][31011].param[5] = """User defined"""
enums["MAV_CMD"][31011].param[6] = """User defined"""
enums["MAV_CMD"][31011].param[7] = """User defined"""
MAV_CMD_USER_3 = 31012
enums["MAV_CMD"][31012] = EnumEntry("MAV_CMD_USER_3", """User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.""")
enums["MAV_CMD"][31012].param[1] = """User defined"""
enums["MAV_CMD"][31012].param[2] = """User defined"""
enums["MAV_CMD"][31012].param[3] = """User defined"""
enums["MAV_CMD"][31012].param[4] = """User defined"""
enums["MAV_CMD"][31012].param[5] = """User defined"""
enums["MAV_CMD"][31012].param[6] = """User defined"""
enums["MAV_CMD"][31012].param[7] = """User defined"""
MAV_CMD_USER_4 = 31013
enums["MAV_CMD"][31013] = EnumEntry("MAV_CMD_USER_4", """User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.""")
enums["MAV_CMD"][31013].param[1] = """User defined"""
enums["MAV_CMD"][31013].param[2] = """User defined"""
enums["MAV_CMD"][31013].param[3] = """User defined"""
enums["MAV_CMD"][31013].param[4] = """User defined"""
enums["MAV_CMD"][31013].param[5] = """User defined"""
enums["MAV_CMD"][31013].param[6] = """User defined"""
enums["MAV_CMD"][31013].param[7] = """User defined"""
MAV_CMD_USER_5 = 31014
enums["MAV_CMD"][31014] = EnumEntry("MAV_CMD_USER_5", """User defined command. Ground Station will not show the Vehicle as flying through this item. Example: MAV_CMD_DO_SET_PARAMETER item.""")
enums["MAV_CMD"][31014].param[1] = """User defined"""
enums["MAV_CMD"][31014].param[2] = """User defined"""
enums["MAV_CMD"][31014].param[3] = """User defined"""
enums["MAV_CMD"][31014].param[4] = """User defined"""
enums["MAV_CMD"][31014].param[5] = """User defined"""
enums["MAV_CMD"][31014].param[6] = """User defined"""
enums["MAV_CMD"][31014].param[7] = """User defined"""
MAV_CMD_CAN_FORWARD = 32000
enums["MAV_CMD"][32000] = EnumEntry("MAV_CMD_CAN_FORWARD", """Request forwarding of CAN packets from the given CAN bus to this interface. CAN Frames are sent using CAN_FRAME and CANFD_FRAME messages""")
enums["MAV_CMD"][32000].param[1] = """Bus number (0 to disable forwarding, 1 for first bus, 2 for 2nd bus, 3 for 3rd bus)."""
enums["MAV_CMD"][32000].param[2] = """Empty."""
enums["MAV_CMD"][32000].param[3] = """Empty."""
enums["MAV_CMD"][32000].param[4] = """Empty."""
enums["MAV_CMD"][32000].param[5] = """Empty."""
enums["MAV_CMD"][32000].param[6] = """Empty."""
enums["MAV_CMD"][32000].param[7] = """Empty."""
MAV_CMD_FIXED_MAG_CAL_YAW = 42006
enums["MAV_CMD"][42006] = EnumEntry("MAV_CMD_FIXED_MAG_CAL_YAW", """Magnetometer calibration based on provided known yaw. This allows for fast calibration using WMM field tables in the vehicle, given only the known yaw of the vehicle. If Latitude and longitude are both zero then use the current vehicle location.""")
enums["MAV_CMD"][42006].has_location = True
enums["MAV_CMD"][42006].param[1] = """Yaw of vehicle in earth frame."""
enums["MAV_CMD"][42006].param[2] = """CompassMask, 0 for all."""
enums["MAV_CMD"][42006].param[3] = """Latitude."""
enums["MAV_CMD"][42006].param[4] = """Longitude."""
enums["MAV_CMD"][42006].param[5] = """Empty."""
enums["MAV_CMD"][42006].param[6] = """Empty."""
enums["MAV_CMD"][42006].param[7] = """Empty."""
MAV_CMD_DO_WINCH = 42600
enums["MAV_CMD"][42600] = EnumEntry("MAV_CMD_DO_WINCH", """Command to operate winch.""")
enums["MAV_CMD"][42600].param[1] = """Winch instance number."""
enums["MAV_CMD"][42600].param[2] = """Action to perform."""
enums["MAV_CMD"][42600].param[3] = """Length of line to release (negative to wind)."""
enums["MAV_CMD"][42600].param[4] = """Release rate (negative to wind)."""
enums["MAV_CMD"][42600].param[5] = """Empty."""
enums["MAV_CMD"][42600].param[6] = """Empty."""
enums["MAV_CMD"][42600].param[7] = """Empty."""
MAV_CMD_EXTERNAL_POSITION_ESTIMATE = 43003
enums["MAV_CMD"][43003] = EnumEntry("MAV_CMD_EXTERNAL_POSITION_ESTIMATE", """Provide an external position estimate for use when dead-reckoning. This is meant to be used for occasional position resets that may be provided by a external system such as a remote pilot using landmarks over a video link.""")
enums["MAV_CMD"][43003].has_location = True
enums["MAV_CMD"][43003].param[1] = """Timestamp that this message was sent as a time in the transmitters time domain. The sender should wrap this time back to zero based on required timing accuracy for the application and the limitations of a 32 bit float. For example, wrapping at 10 hours would give approximately 1ms accuracy. Recipient must handle time wrap in any timing jitter correction applied to this field. Wrap rollover time should not be at not more than 250 seconds, which would give approximately 10 microsecond accuracy."""
enums["MAV_CMD"][43003].param[2] = """The time spent in processing the sensor data that is the basis for this position. The recipient can use this to improve time alignment of the data. Set to zero if not known."""
enums["MAV_CMD"][43003].param[3] = """estimated one standard deviation accuracy of the measurement. Set to NaN if not known."""
enums["MAV_CMD"][43003].param[4] = """Empty"""
enums["MAV_CMD"][43003].param[5] = """Latitude"""
enums["MAV_CMD"][43003].param[6] = """Longitude"""
enums["MAV_CMD"][43003].param[7] = """Altitude, not used. Should be sent as NaN. May be supported in a future version of this message."""
MAV_CMD_PRS_SET_ARM = 60050
enums["MAV_CMD"][60050] = EnumEntry("MAV_CMD_PRS_SET_ARM", """AVSS defined command. Set PRS arm statuses.""")
enums["MAV_CMD"][60050].param[1] = """PRS arm statuses"""
enums["MAV_CMD"][60050].param[2] = """User defined"""
enums["MAV_CMD"][60050].param[3] = """User defined"""
enums["MAV_CMD"][60050].param[4] = """User defined"""
enums["MAV_CMD"][60050].param[5] = """User defined"""
enums["MAV_CMD"][60050].param[6] = """User defined"""
enums["MAV_CMD"][60050].param[7] = """User defined"""
MAV_CMD_PRS_GET_ARM = 60051
enums["MAV_CMD"][60051] = EnumEntry("MAV_CMD_PRS_GET_ARM", """AVSS defined command. Gets PRS arm statuses""")
enums["MAV_CMD"][60051].param[1] = """User defined"""
enums["MAV_CMD"][60051].param[2] = """User defined"""
enums["MAV_CMD"][60051].param[3] = """User defined"""
enums["MAV_CMD"][60051].param[4] = """User defined"""
enums["MAV_CMD"][60051].param[5] = """User defined"""
enums["MAV_CMD"][60051].param[6] = """User defined"""
enums["MAV_CMD"][60051].param[7] = """User defined"""
MAV_CMD_PRS_GET_BATTERY = 60052
enums["MAV_CMD"][60052] = EnumEntry("MAV_CMD_PRS_GET_BATTERY", """AVSS defined command.  Get the PRS battery voltage in millivolts""")
enums["MAV_CMD"][60052].param[1] = """User defined"""
enums["MAV_CMD"][60052].param[2] = """User defined"""
enums["MAV_CMD"][60052].param[3] = """User defined"""
enums["MAV_CMD"][60052].param[4] = """User defined"""
enums["MAV_CMD"][60052].param[5] = """User defined"""
enums["MAV_CMD"][60052].param[6] = """User defined"""
enums["MAV_CMD"][60052].param[7] = """User defined"""
MAV_CMD_PRS_GET_ERR = 60053
enums["MAV_CMD"][60053] = EnumEntry("MAV_CMD_PRS_GET_ERR", """AVSS defined command. Get the PRS error statuses.""")
enums["MAV_CMD"][60053].param[1] = """User defined"""
enums["MAV_CMD"][60053].param[2] = """User defined"""
enums["MAV_CMD"][60053].param[3] = """User defined"""
enums["MAV_CMD"][60053].param[4] = """User defined"""
enums["MAV_CMD"][60053].param[5] = """User defined"""
enums["MAV_CMD"][60053].param[6] = """User defined"""
enums["MAV_CMD"][60053].param[7] = """User defined"""
MAV_CMD_PRS_SET_ARM_ALTI = 60070
enums["MAV_CMD"][60070] = EnumEntry("MAV_CMD_PRS_SET_ARM_ALTI", """AVSS defined command. Set the ATS arming altitude in meters.""")
enums["MAV_CMD"][60070].param[1] = """ATS arming altitude"""
enums["MAV_CMD"][60070].param[2] = """User defined"""
enums["MAV_CMD"][60070].param[3] = """User defined"""
enums["MAV_CMD"][60070].param[4] = """User defined"""
enums["MAV_CMD"][60070].param[5] = """User defined"""
enums["MAV_CMD"][60070].param[6] = """User defined"""
enums["MAV_CMD"][60070].param[7] = """User defined"""
MAV_CMD_PRS_GET_ARM_ALTI = 60071
enums["MAV_CMD"][60071] = EnumEntry("MAV_CMD_PRS_GET_ARM_ALTI", """AVSS defined command. Get the ATS arming altitude in meters.""")
enums["MAV_CMD"][60071].param[1] = """User defined"""
enums["MAV_CMD"][60071].param[2] = """User defined"""
enums["MAV_CMD"][60071].param[3] = """User defined"""
enums["MAV_CMD"][60071].param[4] = """User defined"""
enums["MAV_CMD"][60071].param[5] = """User defined"""
enums["MAV_CMD"][60071].param[6] = """User defined"""
enums["MAV_CMD"][60071].param[7] = """User defined"""
MAV_CMD_PRS_SHUTDOWN = 60072
enums["MAV_CMD"][60072] = EnumEntry("MAV_CMD_PRS_SHUTDOWN", """AVSS defined command. Shuts down the PRS system.""")
enums["MAV_CMD"][60072].param[1] = """User defined"""
enums["MAV_CMD"][60072].param[2] = """User defined"""
enums["MAV_CMD"][60072].param[3] = """User defined"""
enums["MAV_CMD"][60072].param[4] = """User defined"""
enums["MAV_CMD"][60072].param[5] = """User defined"""
enums["MAV_CMD"][60072].param[6] = """User defined"""
enums["MAV_CMD"][60072].param[7] = """User defined"""
MAV_CMD_ENUM_END = 60073
enums["MAV_CMD"][60073] = EnumEntry("MAV_CMD_ENUM_END", """""")

# MAV_AVSS_COMMAND_FAILURE_REASON
enums["MAV_AVSS_COMMAND_FAILURE_REASON"] = Enum()
enums["MAV_AVSS_COMMAND_FAILURE_REASON"].bitmask = False
PRS_NOT_STEADY = 1
enums["MAV_AVSS_COMMAND_FAILURE_REASON"][1] = EnumEntry("PRS_NOT_STEADY", """AVSS defined command failure reason. PRS not steady.""")
PRS_DTM_NOT_ARMED = 2
enums["MAV_AVSS_COMMAND_FAILURE_REASON"][2] = EnumEntry("PRS_DTM_NOT_ARMED", """AVSS defined command failure reason. PRS DTM not armed.""")
PRS_OTM_NOT_ARMED = 3
enums["MAV_AVSS_COMMAND_FAILURE_REASON"][3] = EnumEntry("PRS_OTM_NOT_ARMED", """AVSS defined command failure reason. PRS OTM not armed.""")
MAV_AVSS_COMMAND_FAILURE_REASON_ENUM_END = 4
enums["MAV_AVSS_COMMAND_FAILURE_REASON"][4] = EnumEntry("MAV_AVSS_COMMAND_FAILURE_REASON_ENUM_END", """""")

# AVSS_M300_OPERATION_MODE
enums["AVSS_M300_OPERATION_MODE"] = Enum()
enums["AVSS_M300_OPERATION_MODE"].bitmask = False
MODE_M300_MANUAL_CTRL = 0
enums["AVSS_M300_OPERATION_MODE"][0] = EnumEntry("MODE_M300_MANUAL_CTRL", """In manual control mode""")
MODE_M300_ATTITUDE = 1
enums["AVSS_M300_OPERATION_MODE"][1] = EnumEntry("MODE_M300_ATTITUDE", """In attitude mode """)
MODE_M300_P_GPS = 6
enums["AVSS_M300_OPERATION_MODE"][6] = EnumEntry("MODE_M300_P_GPS", """In GPS mode""")
MODE_M300_HOTPOINT_MODE = 9
enums["AVSS_M300_OPERATION_MODE"][9] = EnumEntry("MODE_M300_HOTPOINT_MODE", """In hotpoint mode """)
MODE_M300_ASSISTED_TAKEOFF = 10
enums["AVSS_M300_OPERATION_MODE"][10] = EnumEntry("MODE_M300_ASSISTED_TAKEOFF", """In assisted takeoff mode""")
MODE_M300_AUTO_TAKEOFF = 11
enums["AVSS_M300_OPERATION_MODE"][11] = EnumEntry("MODE_M300_AUTO_TAKEOFF", """In auto takeoff mode""")
MODE_M300_AUTO_LANDING = 12
enums["AVSS_M300_OPERATION_MODE"][12] = EnumEntry("MODE_M300_AUTO_LANDING", """In auto landing mode""")
MODE_M300_NAVI_GO_HOME = 15
enums["AVSS_M300_OPERATION_MODE"][15] = EnumEntry("MODE_M300_NAVI_GO_HOME", """In go home mode""")
MODE_M300_NAVI_SDK_CTRL = 17
enums["AVSS_M300_OPERATION_MODE"][17] = EnumEntry("MODE_M300_NAVI_SDK_CTRL", """In sdk control mode""")
MODE_M300_S_SPORT = 31
enums["AVSS_M300_OPERATION_MODE"][31] = EnumEntry("MODE_M300_S_SPORT", """In sport mode""")
MODE_M300_FORCE_AUTO_LANDING = 33
enums["AVSS_M300_OPERATION_MODE"][33] = EnumEntry("MODE_M300_FORCE_AUTO_LANDING", """In force auto landing mode""")
MODE_M300_T_TRIPOD = 38
enums["AVSS_M300_OPERATION_MODE"][38] = EnumEntry("MODE_M300_T_TRIPOD", """In tripod mode""")
MODE_M300_SEARCH_MODE = 40
enums["AVSS_M300_OPERATION_MODE"][40] = EnumEntry("MODE_M300_SEARCH_MODE", """In search mode""")
MODE_M300_ENGINE_START = 41
enums["AVSS_M300_OPERATION_MODE"][41] = EnumEntry("MODE_M300_ENGINE_START", """In engine mode""")
AVSS_M300_OPERATION_MODE_ENUM_END = 42
enums["AVSS_M300_OPERATION_MODE"][42] = EnumEntry("AVSS_M300_OPERATION_MODE_ENUM_END", """""")

# AVSS_HORSEFLY_OPERATION_MODE
enums["AVSS_HORSEFLY_OPERATION_MODE"] = Enum()
enums["AVSS_HORSEFLY_OPERATION_MODE"].bitmask = False
MODE_HORSEFLY_MANUAL_CTRL = 0
enums["AVSS_HORSEFLY_OPERATION_MODE"][0] = EnumEntry("MODE_HORSEFLY_MANUAL_CTRL", """In manual control mode""")
MODE_HORSEFLY_AUTO_TAKEOFF = 1
enums["AVSS_HORSEFLY_OPERATION_MODE"][1] = EnumEntry("MODE_HORSEFLY_AUTO_TAKEOFF", """In auto takeoff mode""")
MODE_HORSEFLY_AUTO_LANDING = 2
enums["AVSS_HORSEFLY_OPERATION_MODE"][2] = EnumEntry("MODE_HORSEFLY_AUTO_LANDING", """In auto landing mode""")
MODE_HORSEFLY_NAVI_GO_HOME = 3
enums["AVSS_HORSEFLY_OPERATION_MODE"][3] = EnumEntry("MODE_HORSEFLY_NAVI_GO_HOME", """In go home mode""")
MODE_HORSEFLY_DROP = 4
enums["AVSS_HORSEFLY_OPERATION_MODE"][4] = EnumEntry("MODE_HORSEFLY_DROP", """In drop mode""")
AVSS_HORSEFLY_OPERATION_MODE_ENUM_END = 5
enums["AVSS_HORSEFLY_OPERATION_MODE"][5] = EnumEntry("AVSS_HORSEFLY_OPERATION_MODE_ENUM_END", """""")

# FIRMWARE_VERSION_TYPE
enums["FIRMWARE_VERSION_TYPE"] = Enum()
enums["FIRMWARE_VERSION_TYPE"].bitmask = False
FIRMWARE_VERSION_TYPE_DEV = 0
enums["FIRMWARE_VERSION_TYPE"][0] = EnumEntry("FIRMWARE_VERSION_TYPE_DEV", """development release""")
FIRMWARE_VERSION_TYPE_ALPHA = 64
enums["FIRMWARE_VERSION_TYPE"][64] = EnumEntry("FIRMWARE_VERSION_TYPE_ALPHA", """alpha release""")
FIRMWARE_VERSION_TYPE_BETA = 128
enums["FIRMWARE_VERSION_TYPE"][128] = EnumEntry("FIRMWARE_VERSION_TYPE_BETA", """beta release""")
FIRMWARE_VERSION_TYPE_RC = 192
enums["FIRMWARE_VERSION_TYPE"][192] = EnumEntry("FIRMWARE_VERSION_TYPE_RC", """release candidate""")
FIRMWARE_VERSION_TYPE_OFFICIAL = 255
enums["FIRMWARE_VERSION_TYPE"][255] = EnumEntry("FIRMWARE_VERSION_TYPE_OFFICIAL", """official stable release""")
FIRMWARE_VERSION_TYPE_ENUM_END = 256
enums["FIRMWARE_VERSION_TYPE"][256] = EnumEntry("FIRMWARE_VERSION_TYPE_ENUM_END", """""")

# HL_FAILURE_FLAG
enums["HL_FAILURE_FLAG"] = Enum()
enums["HL_FAILURE_FLAG"].bitmask = True
HL_FAILURE_FLAG_GPS = 1
enums["HL_FAILURE_FLAG"][1] = EnumEntry("HL_FAILURE_FLAG_GPS", """GPS failure.""")
HL_FAILURE_FLAG_DIFFERENTIAL_PRESSURE = 2
enums["HL_FAILURE_FLAG"][2] = EnumEntry("HL_FAILURE_FLAG_DIFFERENTIAL_PRESSURE", """Differential pressure sensor failure.""")
HL_FAILURE_FLAG_ABSOLUTE_PRESSURE = 4
enums["HL_FAILURE_FLAG"][4] = EnumEntry("HL_FAILURE_FLAG_ABSOLUTE_PRESSURE", """Absolute pressure sensor failure.""")
HL_FAILURE_FLAG_3D_ACCEL = 8
enums["HL_FAILURE_FLAG"][8] = EnumEntry("HL_FAILURE_FLAG_3D_ACCEL", """Accelerometer sensor failure.""")
HL_FAILURE_FLAG_3D_GYRO = 16
enums["HL_FAILURE_FLAG"][16] = EnumEntry("HL_FAILURE_FLAG_3D_GYRO", """Gyroscope sensor failure.""")
HL_FAILURE_FLAG_3D_MAG = 32
enums["HL_FAILURE_FLAG"][32] = EnumEntry("HL_FAILURE_FLAG_3D_MAG", """Magnetometer sensor failure.""")
HL_FAILURE_FLAG_TERRAIN = 64
enums["HL_FAILURE_FLAG"][64] = EnumEntry("HL_FAILURE_FLAG_TERRAIN", """Terrain subsystem failure.""")
HL_FAILURE_FLAG_BATTERY = 128
enums["HL_FAILURE_FLAG"][128] = EnumEntry("HL_FAILURE_FLAG_BATTERY", """Battery failure/critical low battery.""")
HL_FAILURE_FLAG_RC_RECEIVER = 256
enums["HL_FAILURE_FLAG"][256] = EnumEntry("HL_FAILURE_FLAG_RC_RECEIVER", """RC receiver failure/no RC connection.""")
HL_FAILURE_FLAG_OFFBOARD_LINK = 512
enums["HL_FAILURE_FLAG"][512] = EnumEntry("HL_FAILURE_FLAG_OFFBOARD_LINK", """Offboard link failure.""")
HL_FAILURE_FLAG_ENGINE = 1024
enums["HL_FAILURE_FLAG"][1024] = EnumEntry("HL_FAILURE_FLAG_ENGINE", """Engine failure.""")
HL_FAILURE_FLAG_GEOFENCE = 2048
enums["HL_FAILURE_FLAG"][2048] = EnumEntry("HL_FAILURE_FLAG_GEOFENCE", """Geofence violation.""")
HL_FAILURE_FLAG_ESTIMATOR = 4096
enums["HL_FAILURE_FLAG"][4096] = EnumEntry("HL_FAILURE_FLAG_ESTIMATOR", """Estimator failure, for example measurement rejection or large variances.""")
HL_FAILURE_FLAG_MISSION = 8192
enums["HL_FAILURE_FLAG"][8192] = EnumEntry("HL_FAILURE_FLAG_MISSION", """Mission failure.""")
HL_FAILURE_FLAG_ENUM_END = 8193
enums["HL_FAILURE_FLAG"][8193] = EnumEntry("HL_FAILURE_FLAG_ENUM_END", """""")

# MAV_GOTO
enums["MAV_GOTO"] = Enum()
enums["MAV_GOTO"].bitmask = False
MAV_GOTO_DO_HOLD = 0
enums["MAV_GOTO"][0] = EnumEntry("MAV_GOTO_DO_HOLD", """Hold at the current position.""")
MAV_GOTO_DO_CONTINUE = 1
enums["MAV_GOTO"][1] = EnumEntry("MAV_GOTO_DO_CONTINUE", """Continue with the next item in mission execution.""")
MAV_GOTO_HOLD_AT_CURRENT_POSITION = 2
enums["MAV_GOTO"][2] = EnumEntry("MAV_GOTO_HOLD_AT_CURRENT_POSITION", """Hold at the current position of the system""")
MAV_GOTO_HOLD_AT_SPECIFIED_POSITION = 3
enums["MAV_GOTO"][3] = EnumEntry("MAV_GOTO_HOLD_AT_SPECIFIED_POSITION", """Hold at the position specified in the parameters of the DO_HOLD action""")
MAV_GOTO_ENUM_END = 4
enums["MAV_GOTO"][4] = EnumEntry("MAV_GOTO_ENUM_END", """""")

# MAV_MODE
enums["MAV_MODE"] = Enum()
enums["MAV_MODE"].bitmask = False
MAV_MODE_PREFLIGHT = 0
enums["MAV_MODE"][0] = EnumEntry("MAV_MODE_PREFLIGHT", """System is not ready to fly, booting, calibrating, etc. No flag is set.""")
MAV_MODE_MANUAL_DISARMED = 64
enums["MAV_MODE"][64] = EnumEntry("MAV_MODE_MANUAL_DISARMED", """System is allowed to be active, under manual (RC) control, no stabilization""")
MAV_MODE_TEST_DISARMED = 66
enums["MAV_MODE"][66] = EnumEntry("MAV_MODE_TEST_DISARMED", """UNDEFINED mode. This solely depends on the autopilot - use with caution, intended for developers only.""")
MAV_MODE_STABILIZE_DISARMED = 80
enums["MAV_MODE"][80] = EnumEntry("MAV_MODE_STABILIZE_DISARMED", """System is allowed to be active, under assisted RC control.""")
MAV_MODE_GUIDED_DISARMED = 88
enums["MAV_MODE"][88] = EnumEntry("MAV_MODE_GUIDED_DISARMED", """System is allowed to be active, under autonomous control, manual setpoint""")
MAV_MODE_AUTO_DISARMED = 92
enums["MAV_MODE"][92] = EnumEntry("MAV_MODE_AUTO_DISARMED", """System is allowed to be active, under autonomous control and navigation (the trajectory is decided onboard and not pre-programmed by waypoints)""")
MAV_MODE_MANUAL_ARMED = 192
enums["MAV_MODE"][192] = EnumEntry("MAV_MODE_MANUAL_ARMED", """System is allowed to be active, under manual (RC) control, no stabilization""")
MAV_MODE_TEST_ARMED = 194
enums["MAV_MODE"][194] = EnumEntry("MAV_MODE_TEST_ARMED", """UNDEFINED mode. This solely depends on the autopilot - use with caution, intended for developers only.""")
MAV_MODE_STABILIZE_ARMED = 208
enums["MAV_MODE"][208] = EnumEntry("MAV_MODE_STABILIZE_ARMED", """System is allowed to be active, under assisted RC control.""")
MAV_MODE_GUIDED_ARMED = 216
enums["MAV_MODE"][216] = EnumEntry("MAV_MODE_GUIDED_ARMED", """System is allowed to be active, under autonomous control, manual setpoint""")
MAV_MODE_AUTO_ARMED = 220
enums["MAV_MODE"][220] = EnumEntry("MAV_MODE_AUTO_ARMED", """System is allowed to be active, under autonomous control and navigation (the trajectory is decided onboard and not pre-programmed by waypoints)""")
MAV_MODE_ENUM_END = 221
enums["MAV_MODE"][221] = EnumEntry("MAV_MODE_ENUM_END", """""")

# MAV_SYS_STATUS_SENSOR
enums["MAV_SYS_STATUS_SENSOR"] = Enum()
enums["MAV_SYS_STATUS_SENSOR"].bitmask = True
MAV_SYS_STATUS_SENSOR_3D_GYRO = 1
enums["MAV_SYS_STATUS_SENSOR"][1] = EnumEntry("MAV_SYS_STATUS_SENSOR_3D_GYRO", """0x01 3D gyro""")
MAV_SYS_STATUS_SENSOR_3D_ACCEL = 2
enums["MAV_SYS_STATUS_SENSOR"][2] = EnumEntry("MAV_SYS_STATUS_SENSOR_3D_ACCEL", """0x02 3D accelerometer""")
MAV_SYS_STATUS_SENSOR_3D_MAG = 4
enums["MAV_SYS_STATUS_SENSOR"][4] = EnumEntry("MAV_SYS_STATUS_SENSOR_3D_MAG", """0x04 3D magnetometer""")
MAV_SYS_STATUS_SENSOR_ABSOLUTE_PRESSURE = 8
enums["MAV_SYS_STATUS_SENSOR"][8] = EnumEntry("MAV_SYS_STATUS_SENSOR_ABSOLUTE_PRESSURE", """0x08 absolute pressure""")
MAV_SYS_STATUS_SENSOR_DIFFERENTIAL_PRESSURE = 16
enums["MAV_SYS_STATUS_SENSOR"][16] = EnumEntry("MAV_SYS_STATUS_SENSOR_DIFFERENTIAL_PRESSURE", """0x10 differential pressure""")
MAV_SYS_STATUS_SENSOR_GPS = 32
enums["MAV_SYS_STATUS_SENSOR"][32] = EnumEntry("MAV_SYS_STATUS_SENSOR_GPS", """0x20 GPS""")
MAV_SYS_STATUS_SENSOR_OPTICAL_FLOW = 64
enums["MAV_SYS_STATUS_SENSOR"][64] = EnumEntry("MAV_SYS_STATUS_SENSOR_OPTICAL_FLOW", """0x40 optical flow""")
MAV_SYS_STATUS_SENSOR_VISION_POSITION = 128
enums["MAV_SYS_STATUS_SENSOR"][128] = EnumEntry("MAV_SYS_STATUS_SENSOR_VISION_POSITION", """0x80 computer vision position""")
MAV_SYS_STATUS_SENSOR_LASER_POSITION = 256
enums["MAV_SYS_STATUS_SENSOR"][256] = EnumEntry("MAV_SYS_STATUS_SENSOR_LASER_POSITION", """0x100 laser based position""")
MAV_SYS_STATUS_SENSOR_EXTERNAL_GROUND_TRUTH = 512
enums["MAV_SYS_STATUS_SENSOR"][512] = EnumEntry("MAV_SYS_STATUS_SENSOR_EXTERNAL_GROUND_TRUTH", """0x200 external ground truth (Vicon or Leica)""")
MAV_SYS_STATUS_SENSOR_ANGULAR_RATE_CONTROL = 1024
enums["MAV_SYS_STATUS_SENSOR"][1024] = EnumEntry("MAV_SYS_STATUS_SENSOR_ANGULAR_RATE_CONTROL", """0x400 3D angular rate control""")
MAV_SYS_STATUS_SENSOR_ATTITUDE_STABILIZATION = 2048
enums["MAV_SYS_STATUS_SENSOR"][2048] = EnumEntry("MAV_SYS_STATUS_SENSOR_ATTITUDE_STABILIZATION", """0x800 attitude stabilization""")
MAV_SYS_STATUS_SENSOR_YAW_POSITION = 4096
enums["MAV_SYS_STATUS_SENSOR"][4096] = EnumEntry("MAV_SYS_STATUS_SENSOR_YAW_POSITION", """0x1000 yaw position""")
MAV_SYS_STATUS_SENSOR_Z_ALTITUDE_CONTROL = 8192
enums["MAV_SYS_STATUS_SENSOR"][8192] = EnumEntry("MAV_SYS_STATUS_SENSOR_Z_ALTITUDE_CONTROL", """0x2000 z/altitude control""")
MAV_SYS_STATUS_SENSOR_XY_POSITION_CONTROL = 16384
enums["MAV_SYS_STATUS_SENSOR"][16384] = EnumEntry("MAV_SYS_STATUS_SENSOR_XY_POSITION_CONTROL", """0x4000 x/y position control""")
MAV_SYS_STATUS_SENSOR_MOTOR_OUTPUTS = 32768
enums["MAV_SYS_STATUS_SENSOR"][32768] = EnumEntry("MAV_SYS_STATUS_SENSOR_MOTOR_OUTPUTS", """0x8000 motor outputs / control""")
MAV_SYS_STATUS_SENSOR_RC_RECEIVER = 65536
enums["MAV_SYS_STATUS_SENSOR"][65536] = EnumEntry("MAV_SYS_STATUS_SENSOR_RC_RECEIVER", """0x10000 RC receiver""")
MAV_SYS_STATUS_SENSOR_3D_GYRO2 = 131072
enums["MAV_SYS_STATUS_SENSOR"][131072] = EnumEntry("MAV_SYS_STATUS_SENSOR_3D_GYRO2", """0x20000 2nd 3D gyro""")
MAV_SYS_STATUS_SENSOR_3D_ACCEL2 = 262144
enums["MAV_SYS_STATUS_SENSOR"][262144] = EnumEntry("MAV_SYS_STATUS_SENSOR_3D_ACCEL2", """0x40000 2nd 3D accelerometer""")
MAV_SYS_STATUS_SENSOR_3D_MAG2 = 524288
enums["MAV_SYS_STATUS_SENSOR"][524288] = EnumEntry("MAV_SYS_STATUS_SENSOR_3D_MAG2", """0x80000 2nd 3D magnetometer""")
MAV_SYS_STATUS_GEOFENCE = 1048576
enums["MAV_SYS_STATUS_SENSOR"][1048576] = EnumEntry("MAV_SYS_STATUS_GEOFENCE", """0x100000 geofence""")
MAV_SYS_STATUS_AHRS = 2097152
enums["MAV_SYS_STATUS_SENSOR"][2097152] = EnumEntry("MAV_SYS_STATUS_AHRS", """0x200000 AHRS subsystem health""")
MAV_SYS_STATUS_TERRAIN = 4194304
enums["MAV_SYS_STATUS_SENSOR"][4194304] = EnumEntry("MAV_SYS_STATUS_TERRAIN", """0x400000 Terrain subsystem health""")
MAV_SYS_STATUS_REVERSE_MOTOR = 8388608
enums["MAV_SYS_STATUS_SENSOR"][8388608] = EnumEntry("MAV_SYS_STATUS_REVERSE_MOTOR", """0x800000 Motors are reversed""")
MAV_SYS_STATUS_LOGGING = 16777216
enums["MAV_SYS_STATUS_SENSOR"][16777216] = EnumEntry("MAV_SYS_STATUS_LOGGING", """0x1000000 Logging""")
MAV_SYS_STATUS_SENSOR_BATTERY = 33554432
enums["MAV_SYS_STATUS_SENSOR"][33554432] = EnumEntry("MAV_SYS_STATUS_SENSOR_BATTERY", """0x2000000 Battery""")
MAV_SYS_STATUS_SENSOR_PROXIMITY = 67108864
enums["MAV_SYS_STATUS_SENSOR"][67108864] = EnumEntry("MAV_SYS_STATUS_SENSOR_PROXIMITY", """0x4000000 Proximity""")
MAV_SYS_STATUS_SENSOR_SATCOM = 134217728
enums["MAV_SYS_STATUS_SENSOR"][134217728] = EnumEntry("MAV_SYS_STATUS_SENSOR_SATCOM", """0x8000000 Satellite Communication """)
MAV_SYS_STATUS_PREARM_CHECK = 268435456
enums["MAV_SYS_STATUS_SENSOR"][268435456] = EnumEntry("MAV_SYS_STATUS_PREARM_CHECK", """0x10000000 pre-arm check status. Always healthy when armed""")
MAV_SYS_STATUS_OBSTACLE_AVOIDANCE = 536870912
enums["MAV_SYS_STATUS_SENSOR"][536870912] = EnumEntry("MAV_SYS_STATUS_OBSTACLE_AVOIDANCE", """0x20000000 Avoidance/collision prevention""")
MAV_SYS_STATUS_SENSOR_PROPULSION = 1073741824
enums["MAV_SYS_STATUS_SENSOR"][1073741824] = EnumEntry("MAV_SYS_STATUS_SENSOR_PROPULSION", """0x40000000 propulsion (actuator, esc, motor or propellor)""")
MAV_SYS_STATUS_SENSOR_ENUM_END = 1073741825
enums["MAV_SYS_STATUS_SENSOR"][1073741825] = EnumEntry("MAV_SYS_STATUS_SENSOR_ENUM_END", """""")

# MAV_FRAME
enums["MAV_FRAME"] = Enum()
enums["MAV_FRAME"].bitmask = False
MAV_FRAME_GLOBAL = 0
enums["MAV_FRAME"][0] = EnumEntry("MAV_FRAME_GLOBAL", """Global (WGS84) coordinate frame + altitude relative to mean sea level (MSL).""")
MAV_FRAME_LOCAL_NED = 1
enums["MAV_FRAME"][1] = EnumEntry("MAV_FRAME_LOCAL_NED", """NED local tangent frame (x: North, y: East, z: Down) with origin fixed relative to earth.""")
MAV_FRAME_MISSION = 2
enums["MAV_FRAME"][2] = EnumEntry("MAV_FRAME_MISSION", """NOT a coordinate frame, indicates a mission command.""")
MAV_FRAME_GLOBAL_RELATIVE_ALT = 3
enums["MAV_FRAME"][3] = EnumEntry(
    "MAV_FRAME_GLOBAL_RELATIVE_ALT",
    """
          Global (WGS84) coordinate frame + altitude relative to the home position.
        """,
)
MAV_FRAME_LOCAL_ENU = 4
enums["MAV_FRAME"][4] = EnumEntry("MAV_FRAME_LOCAL_ENU", """ENU local tangent frame (x: East, y: North, z: Up) with origin fixed relative to earth.""")
MAV_FRAME_GLOBAL_INT = 5
enums["MAV_FRAME"][5] = EnumEntry("MAV_FRAME_GLOBAL_INT", """Global (WGS84) coordinate frame (scaled) + altitude relative to mean sea level (MSL).""")
MAV_FRAME_GLOBAL_RELATIVE_ALT_INT = 6
enums["MAV_FRAME"][6] = EnumEntry("MAV_FRAME_GLOBAL_RELATIVE_ALT_INT", """Global (WGS84) coordinate frame (scaled) + altitude relative to the home position. """)
MAV_FRAME_LOCAL_OFFSET_NED = 7
enums["MAV_FRAME"][7] = EnumEntry("MAV_FRAME_LOCAL_OFFSET_NED", """NED local tangent frame (x: North, y: East, z: Down) with origin that travels with the vehicle.""")
MAV_FRAME_BODY_NED = 8
enums["MAV_FRAME"][8] = EnumEntry("MAV_FRAME_BODY_NED", """Same as MAV_FRAME_LOCAL_NED when used to represent position values. Same as MAV_FRAME_BODY_FRD when used with velocity/acceleration values.""")
MAV_FRAME_BODY_OFFSET_NED = 9
enums["MAV_FRAME"][9] = EnumEntry("MAV_FRAME_BODY_OFFSET_NED", """This is the same as MAV_FRAME_BODY_FRD.""")
MAV_FRAME_GLOBAL_TERRAIN_ALT = 10
enums["MAV_FRAME"][10] = EnumEntry("MAV_FRAME_GLOBAL_TERRAIN_ALT", """Global (WGS84) coordinate frame with AGL altitude (altitude at ground level).""")
MAV_FRAME_GLOBAL_TERRAIN_ALT_INT = 11
enums["MAV_FRAME"][11] = EnumEntry("MAV_FRAME_GLOBAL_TERRAIN_ALT_INT", """Global (WGS84) coordinate frame (scaled) with AGL altitude (altitude at ground level).""")
MAV_FRAME_BODY_FRD = 12
enums["MAV_FRAME"][12] = EnumEntry("MAV_FRAME_BODY_FRD", """FRD local frame aligned to the vehicle's attitude (x: Forward, y: Right, z: Down) with an origin that travels with vehicle.""")
MAV_FRAME_RESERVED_13 = 13
enums["MAV_FRAME"][13] = EnumEntry("MAV_FRAME_RESERVED_13", """MAV_FRAME_BODY_FLU - Body fixed frame of reference, Z-up (x: Forward, y: Left, z: Up).""")
MAV_FRAME_RESERVED_14 = 14
enums["MAV_FRAME"][14] = EnumEntry("MAV_FRAME_RESERVED_14", """MAV_FRAME_MOCAP_NED - Odometry local coordinate frame of data given by a motion capture system, Z-down (x: North, y: East, z: Down).""")
MAV_FRAME_RESERVED_15 = 15
enums["MAV_FRAME"][15] = EnumEntry("MAV_FRAME_RESERVED_15", """MAV_FRAME_MOCAP_ENU - Odometry local coordinate frame of data given by a motion capture system, Z-up (x: East, y: North, z: Up).""")
MAV_FRAME_RESERVED_16 = 16
enums["MAV_FRAME"][16] = EnumEntry("MAV_FRAME_RESERVED_16", """MAV_FRAME_VISION_NED - Odometry local coordinate frame of data given by a vision estimation system, Z-down (x: North, y: East, z: Down).""")
MAV_FRAME_RESERVED_17 = 17
enums["MAV_FRAME"][17] = EnumEntry("MAV_FRAME_RESERVED_17", """MAV_FRAME_VISION_ENU - Odometry local coordinate frame of data given by a vision estimation system, Z-up (x: East, y: North, z: Up).""")
MAV_FRAME_RESERVED_18 = 18
enums["MAV_FRAME"][18] = EnumEntry("MAV_FRAME_RESERVED_18", """MAV_FRAME_ESTIM_NED - Odometry local coordinate frame of data given by an estimator running onboard the vehicle, Z-down (x: North, y: East, z: Down).""")
MAV_FRAME_RESERVED_19 = 19
enums["MAV_FRAME"][19] = EnumEntry("MAV_FRAME_RESERVED_19", """MAV_FRAME_ESTIM_ENU - Odometry local coordinate frame of data given by an estimator running onboard the vehicle, Z-up (x: East, y: North, z: Up).""")
MAV_FRAME_LOCAL_FRD = 20
enums["MAV_FRAME"][20] = EnumEntry("MAV_FRAME_LOCAL_FRD", """FRD local tangent frame (x: Forward, y: Right, z: Down) with origin fixed relative to earth. The forward axis is aligned to the front of the vehicle in the horizontal plane.""")
MAV_FRAME_LOCAL_FLU = 21
enums["MAV_FRAME"][21] = EnumEntry("MAV_FRAME_LOCAL_FLU", """FLU local tangent frame (x: Forward, y: Left, z: Up) with origin fixed relative to earth. The forward axis is aligned to the front of the vehicle in the horizontal plane.""")
MAV_FRAME_ENUM_END = 22
enums["MAV_FRAME"][22] = EnumEntry("MAV_FRAME_ENUM_END", """""")

# MAVLINK_DATA_STREAM_TYPE
enums["MAVLINK_DATA_STREAM_TYPE"] = Enum()
enums["MAVLINK_DATA_STREAM_TYPE"].bitmask = False
MAVLINK_DATA_STREAM_IMG_JPEG = 0
enums["MAVLINK_DATA_STREAM_TYPE"][0] = EnumEntry("MAVLINK_DATA_STREAM_IMG_JPEG", """""")
MAVLINK_DATA_STREAM_IMG_BMP = 1
enums["MAVLINK_DATA_STREAM_TYPE"][1] = EnumEntry("MAVLINK_DATA_STREAM_IMG_BMP", """""")
MAVLINK_DATA_STREAM_IMG_RAW8U = 2
enums["MAVLINK_DATA_STREAM_TYPE"][2] = EnumEntry("MAVLINK_DATA_STREAM_IMG_RAW8U", """""")
MAVLINK_DATA_STREAM_IMG_RAW32U = 3
enums["MAVLINK_DATA_STREAM_TYPE"][3] = EnumEntry("MAVLINK_DATA_STREAM_IMG_RAW32U", """""")
MAVLINK_DATA_STREAM_IMG_PGM = 4
enums["MAVLINK_DATA_STREAM_TYPE"][4] = EnumEntry("MAVLINK_DATA_STREAM_IMG_PGM", """""")
MAVLINK_DATA_STREAM_IMG_PNG = 5
enums["MAVLINK_DATA_STREAM_TYPE"][5] = EnumEntry("MAVLINK_DATA_STREAM_IMG_PNG", """""")
MAVLINK_DATA_STREAM_TYPE_ENUM_END = 6
enums["MAVLINK_DATA_STREAM_TYPE"][6] = EnumEntry("MAVLINK_DATA_STREAM_TYPE_ENUM_END", """""")

# FENCE_BREACH
enums["FENCE_BREACH"] = Enum()
enums["FENCE_BREACH"].bitmask = False
FENCE_BREACH_NONE = 0
enums["FENCE_BREACH"][0] = EnumEntry("FENCE_BREACH_NONE", """No last fence breach""")
FENCE_BREACH_MINALT = 1
enums["FENCE_BREACH"][1] = EnumEntry("FENCE_BREACH_MINALT", """Breached minimum altitude""")
FENCE_BREACH_MAXALT = 2
enums["FENCE_BREACH"][2] = EnumEntry("FENCE_BREACH_MAXALT", """Breached maximum altitude""")
FENCE_BREACH_BOUNDARY = 3
enums["FENCE_BREACH"][3] = EnumEntry("FENCE_BREACH_BOUNDARY", """Breached fence boundary""")
FENCE_BREACH_ENUM_END = 4
enums["FENCE_BREACH"][4] = EnumEntry("FENCE_BREACH_ENUM_END", """""")

# FENCE_MITIGATE
enums["FENCE_MITIGATE"] = Enum()
enums["FENCE_MITIGATE"].bitmask = False
FENCE_MITIGATE_UNKNOWN = 0
enums["FENCE_MITIGATE"][0] = EnumEntry("FENCE_MITIGATE_UNKNOWN", """Unknown""")
FENCE_MITIGATE_NONE = 1
enums["FENCE_MITIGATE"][1] = EnumEntry("FENCE_MITIGATE_NONE", """No actions being taken""")
FENCE_MITIGATE_VEL_LIMIT = 2
enums["FENCE_MITIGATE"][2] = EnumEntry("FENCE_MITIGATE_VEL_LIMIT", """Velocity limiting active to prevent breach""")
FENCE_MITIGATE_ENUM_END = 3
enums["FENCE_MITIGATE"][3] = EnumEntry("FENCE_MITIGATE_ENUM_END", """""")

# FENCE_TYPE
enums["FENCE_TYPE"] = Enum()
enums["FENCE_TYPE"].bitmask = True
FENCE_TYPE_ALT_MAX = 1
enums["FENCE_TYPE"][1] = EnumEntry("FENCE_TYPE_ALT_MAX", """Maximum altitude fence""")
FENCE_TYPE_CIRCLE = 2
enums["FENCE_TYPE"][2] = EnumEntry("FENCE_TYPE_CIRCLE", """Circle fence""")
FENCE_TYPE_POLYGON = 4
enums["FENCE_TYPE"][4] = EnumEntry("FENCE_TYPE_POLYGON", """Polygon fence""")
FENCE_TYPE_ALT_MIN = 8
enums["FENCE_TYPE"][8] = EnumEntry("FENCE_TYPE_ALT_MIN", """Minimum altitude fence""")
FENCE_TYPE_ENUM_END = 9
enums["FENCE_TYPE"][9] = EnumEntry("FENCE_TYPE_ENUM_END", """""")

# MAV_MOUNT_MODE
enums["MAV_MOUNT_MODE"] = Enum()
enums["MAV_MOUNT_MODE"].bitmask = False
MAV_MOUNT_MODE_RETRACT = 0
enums["MAV_MOUNT_MODE"][0] = EnumEntry("MAV_MOUNT_MODE_RETRACT", """Load and keep safe position (Roll,Pitch,Yaw) from permanent memory and stop stabilization""")
MAV_MOUNT_MODE_NEUTRAL = 1
enums["MAV_MOUNT_MODE"][1] = EnumEntry("MAV_MOUNT_MODE_NEUTRAL", """Load and keep neutral position (Roll,Pitch,Yaw) from permanent memory.""")
MAV_MOUNT_MODE_MAVLINK_TARGETING = 2
enums["MAV_MOUNT_MODE"][2] = EnumEntry("MAV_MOUNT_MODE_MAVLINK_TARGETING", """Load neutral position and start MAVLink Roll,Pitch,Yaw control with stabilization""")
MAV_MOUNT_MODE_RC_TARGETING = 3
enums["MAV_MOUNT_MODE"][3] = EnumEntry("MAV_MOUNT_MODE_RC_TARGETING", """Load neutral position and start RC Roll,Pitch,Yaw control with stabilization""")
MAV_MOUNT_MODE_GPS_POINT = 4
enums["MAV_MOUNT_MODE"][4] = EnumEntry("MAV_MOUNT_MODE_GPS_POINT", """Load neutral position and start to point to Lat,Lon,Alt""")
MAV_MOUNT_MODE_SYSID_TARGET = 5
enums["MAV_MOUNT_MODE"][5] = EnumEntry("MAV_MOUNT_MODE_SYSID_TARGET", """Gimbal tracks system with specified system ID""")
MAV_MOUNT_MODE_HOME_LOCATION = 6
enums["MAV_MOUNT_MODE"][6] = EnumEntry("MAV_MOUNT_MODE_HOME_LOCATION", """Gimbal tracks home position""")
MAV_MOUNT_MODE_ENUM_END = 7
enums["MAV_MOUNT_MODE"][7] = EnumEntry("MAV_MOUNT_MODE_ENUM_END", """""")

# GIMBAL_DEVICE_CAP_FLAGS
enums["GIMBAL_DEVICE_CAP_FLAGS"] = Enum()
enums["GIMBAL_DEVICE_CAP_FLAGS"].bitmask = True
GIMBAL_DEVICE_CAP_FLAGS_HAS_RETRACT = 1
enums["GIMBAL_DEVICE_CAP_FLAGS"][1] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_RETRACT", """Gimbal device supports a retracted position.""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_NEUTRAL = 2
enums["GIMBAL_DEVICE_CAP_FLAGS"][2] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_NEUTRAL", """Gimbal device supports a horizontal, forward looking position, stabilized.""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_AXIS = 4
enums["GIMBAL_DEVICE_CAP_FLAGS"][4] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_AXIS", """Gimbal device supports rotating around roll axis.""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_FOLLOW = 8
enums["GIMBAL_DEVICE_CAP_FLAGS"][8] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_FOLLOW", """Gimbal device supports to follow a roll angle relative to the vehicle.""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_LOCK = 16
enums["GIMBAL_DEVICE_CAP_FLAGS"][16] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_LOCK", """Gimbal device supports locking to a roll angle (generally that's the default with roll stabilized).""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_AXIS = 32
enums["GIMBAL_DEVICE_CAP_FLAGS"][32] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_AXIS", """Gimbal device supports rotating around pitch axis.""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_FOLLOW = 64
enums["GIMBAL_DEVICE_CAP_FLAGS"][64] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_FOLLOW", """Gimbal device supports to follow a pitch angle relative to the vehicle.""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_LOCK = 128
enums["GIMBAL_DEVICE_CAP_FLAGS"][128] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_LOCK", """Gimbal device supports locking to a pitch angle (generally that's the default with pitch stabilized).""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_AXIS = 256
enums["GIMBAL_DEVICE_CAP_FLAGS"][256] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_AXIS", """Gimbal device supports rotating around yaw axis.""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_FOLLOW = 512
enums["GIMBAL_DEVICE_CAP_FLAGS"][512] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_FOLLOW", """Gimbal device supports to follow a yaw angle relative to the vehicle (generally that's the default).""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_LOCK = 1024
enums["GIMBAL_DEVICE_CAP_FLAGS"][1024] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_LOCK", """Gimbal device supports locking to an absolute heading, i.e., yaw angle relative to North (earth frame, often this is an option available).""")
GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_INFINITE_YAW = 2048
enums["GIMBAL_DEVICE_CAP_FLAGS"][2048] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_INFINITE_YAW", """Gimbal device supports yawing/panning infinitely (e.g. using slip disk).""")
GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME = 4096
enums["GIMBAL_DEVICE_CAP_FLAGS"][4096] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME", """Gimbal device supports yaw angles and angular velocities relative to North (earth frame). This usually requires support by an autopilot via AUTOPILOT_STATE_FOR_GIMBAL_DEVICE. Support can go on and off during runtime, which is reported by the flag GIMBAL_DEVICE_FLAGS_CAN_ACCEPT_YAW_IN_EARTH_FRAME.""")
GIMBAL_DEVICE_CAP_FLAGS_HAS_RC_INPUTS = 8192
enums["GIMBAL_DEVICE_CAP_FLAGS"][8192] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_HAS_RC_INPUTS", """Gimbal device supports radio control inputs as an alternative input for controlling the gimbal orientation.""")
GIMBAL_DEVICE_CAP_FLAGS_ENUM_END = 8193
enums["GIMBAL_DEVICE_CAP_FLAGS"][8193] = EnumEntry("GIMBAL_DEVICE_CAP_FLAGS_ENUM_END", """""")

# GIMBAL_MANAGER_CAP_FLAGS
enums["GIMBAL_MANAGER_CAP_FLAGS"] = Enum()
enums["GIMBAL_MANAGER_CAP_FLAGS"].bitmask = True
GIMBAL_MANAGER_CAP_FLAGS_HAS_RETRACT = 1
enums["GIMBAL_MANAGER_CAP_FLAGS"][1] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_RETRACT", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_RETRACT.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_NEUTRAL = 2
enums["GIMBAL_MANAGER_CAP_FLAGS"][2] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_NEUTRAL", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_NEUTRAL.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_AXIS = 4
enums["GIMBAL_MANAGER_CAP_FLAGS"][4] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_AXIS", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_AXIS.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_FOLLOW = 8
enums["GIMBAL_MANAGER_CAP_FLAGS"][8] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_FOLLOW", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_FOLLOW.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_LOCK = 16
enums["GIMBAL_MANAGER_CAP_FLAGS"][16] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_ROLL_LOCK", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_ROLL_LOCK.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_AXIS = 32
enums["GIMBAL_MANAGER_CAP_FLAGS"][32] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_AXIS", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_AXIS.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_FOLLOW = 64
enums["GIMBAL_MANAGER_CAP_FLAGS"][64] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_FOLLOW", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_FOLLOW.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_LOCK = 128
enums["GIMBAL_MANAGER_CAP_FLAGS"][128] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_PITCH_LOCK", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_PITCH_LOCK.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_AXIS = 256
enums["GIMBAL_MANAGER_CAP_FLAGS"][256] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_AXIS", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_AXIS.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_FOLLOW = 512
enums["GIMBAL_MANAGER_CAP_FLAGS"][512] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_FOLLOW", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_FOLLOW.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_LOCK = 1024
enums["GIMBAL_MANAGER_CAP_FLAGS"][1024] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_YAW_LOCK", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_YAW_LOCK.""")
GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_INFINITE_YAW = 2048
enums["GIMBAL_MANAGER_CAP_FLAGS"][2048] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_INFINITE_YAW", """Based on GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_INFINITE_YAW.""")
GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME = 4096
enums["GIMBAL_MANAGER_CAP_FLAGS"][4096] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME", """Based on GIMBAL_DEVICE_CAP_FLAGS_SUPPORTS_YAW_IN_EARTH_FRAME.""")
GIMBAL_MANAGER_CAP_FLAGS_HAS_RC_INPUTS = 8192
enums["GIMBAL_MANAGER_CAP_FLAGS"][8192] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_HAS_RC_INPUTS", """Based on GIMBAL_DEVICE_CAP_FLAGS_HAS_RC_INPUTS.""")
GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_LOCAL = 65536
enums["GIMBAL_MANAGER_CAP_FLAGS"][65536] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_LOCAL", """Gimbal manager supports to point to a local position.""")
GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_GLOBAL = 131072
enums["GIMBAL_MANAGER_CAP_FLAGS"][131072] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_CAN_POINT_LOCATION_GLOBAL", """Gimbal manager supports to point to a global latitude, longitude, altitude position.""")
GIMBAL_MANAGER_CAP_FLAGS_ENUM_END = 131073
enums["GIMBAL_MANAGER_CAP_FLAGS"][131073] = EnumEntry("GIMBAL_MANAGER_CAP_FLAGS_ENUM_END", """""")

# GIMBAL_DEVICE_FLAGS
enums["GIMBAL_DEVICE_FLAGS"] = Enum()
enums["GIMBAL_DEVICE_FLAGS"].bitmask = True
GIMBAL_DEVICE_FLAGS_RETRACT = 1
enums["GIMBAL_DEVICE_FLAGS"][1] = EnumEntry("GIMBAL_DEVICE_FLAGS_RETRACT", """Set to retracted safe position (no stabilization), takes precedence over all other flags.""")
GIMBAL_DEVICE_FLAGS_NEUTRAL = 2
enums["GIMBAL_DEVICE_FLAGS"][2] = EnumEntry("GIMBAL_DEVICE_FLAGS_NEUTRAL", """Set to neutral/default position, taking precedence over all other flags except RETRACT. Neutral is commonly forward-facing and horizontal (roll=pitch=yaw=0) but may be any orientation.""")
GIMBAL_DEVICE_FLAGS_ROLL_LOCK = 4
enums["GIMBAL_DEVICE_FLAGS"][4] = EnumEntry("GIMBAL_DEVICE_FLAGS_ROLL_LOCK", """Lock roll angle to absolute angle relative to horizon (not relative to vehicle). This is generally the default with a stabilizing gimbal.""")
GIMBAL_DEVICE_FLAGS_PITCH_LOCK = 8
enums["GIMBAL_DEVICE_FLAGS"][8] = EnumEntry("GIMBAL_DEVICE_FLAGS_PITCH_LOCK", """Lock pitch angle to absolute angle relative to horizon (not relative to vehicle). This is generally the default with a stabilizing gimbal.""")
GIMBAL_DEVICE_FLAGS_YAW_LOCK = 16
enums["GIMBAL_DEVICE_FLAGS"][16] = EnumEntry("GIMBAL_DEVICE_FLAGS_YAW_LOCK", """Lock yaw angle to absolute angle relative to North (not relative to vehicle). If this flag is set, the yaw angle and z component of angular velocity are relative to North (earth frame, x-axis pointing North), else they are relative to the vehicle heading (vehicle frame, earth frame rotated so that the x-axis is pointing forward).""")
GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME = 32
enums["GIMBAL_DEVICE_FLAGS"][32] = EnumEntry("GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME", """Yaw angle and z component of angular velocity are relative to the vehicle heading (vehicle frame, earth frame rotated such that the x-axis is pointing forward).""")
GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME = 64
enums["GIMBAL_DEVICE_FLAGS"][64] = EnumEntry("GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME", """Yaw angle and z component of angular velocity are relative to North (earth frame, x-axis is pointing North).""")
GIMBAL_DEVICE_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME = 128
enums["GIMBAL_DEVICE_FLAGS"][128] = EnumEntry("GIMBAL_DEVICE_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME", """Gimbal device can accept yaw angle inputs relative to North (earth frame). This flag is only for reporting (attempts to set this flag are ignored).""")
GIMBAL_DEVICE_FLAGS_RC_EXCLUSIVE = 256
enums["GIMBAL_DEVICE_FLAGS"][256] = EnumEntry("GIMBAL_DEVICE_FLAGS_RC_EXCLUSIVE", """The gimbal orientation is set exclusively by the RC signals feed to the gimbal's radio control inputs. MAVLink messages for setting the gimbal orientation (GIMBAL_DEVICE_SET_ATTITUDE) are ignored.""")
GIMBAL_DEVICE_FLAGS_RC_MIXED = 512
enums["GIMBAL_DEVICE_FLAGS"][512] = EnumEntry("GIMBAL_DEVICE_FLAGS_RC_MIXED", """The gimbal orientation is determined by combining/mixing the RC signals feed to the gimbal's radio control inputs and the MAVLink messages for setting the gimbal orientation (GIMBAL_DEVICE_SET_ATTITUDE). How these two controls are combined or mixed is not defined by the protocol but is up to the implementation.""")
GIMBAL_DEVICE_FLAGS_ENUM_END = 513
enums["GIMBAL_DEVICE_FLAGS"][513] = EnumEntry("GIMBAL_DEVICE_FLAGS_ENUM_END", """""")

# GIMBAL_MANAGER_FLAGS
enums["GIMBAL_MANAGER_FLAGS"] = Enum()
enums["GIMBAL_MANAGER_FLAGS"].bitmask = True
GIMBAL_MANAGER_FLAGS_RETRACT = 1
enums["GIMBAL_MANAGER_FLAGS"][1] = EnumEntry("GIMBAL_MANAGER_FLAGS_RETRACT", """Based on GIMBAL_DEVICE_FLAGS_RETRACT.""")
GIMBAL_MANAGER_FLAGS_NEUTRAL = 2
enums["GIMBAL_MANAGER_FLAGS"][2] = EnumEntry("GIMBAL_MANAGER_FLAGS_NEUTRAL", """Based on GIMBAL_DEVICE_FLAGS_NEUTRAL.""")
GIMBAL_MANAGER_FLAGS_ROLL_LOCK = 4
enums["GIMBAL_MANAGER_FLAGS"][4] = EnumEntry("GIMBAL_MANAGER_FLAGS_ROLL_LOCK", """Based on GIMBAL_DEVICE_FLAGS_ROLL_LOCK.""")
GIMBAL_MANAGER_FLAGS_PITCH_LOCK = 8
enums["GIMBAL_MANAGER_FLAGS"][8] = EnumEntry("GIMBAL_MANAGER_FLAGS_PITCH_LOCK", """Based on GIMBAL_DEVICE_FLAGS_PITCH_LOCK.""")
GIMBAL_MANAGER_FLAGS_YAW_LOCK = 16
enums["GIMBAL_MANAGER_FLAGS"][16] = EnumEntry("GIMBAL_MANAGER_FLAGS_YAW_LOCK", """Based on GIMBAL_DEVICE_FLAGS_YAW_LOCK.""")
GIMBAL_MANAGER_FLAGS_YAW_IN_VEHICLE_FRAME = 32
enums["GIMBAL_MANAGER_FLAGS"][32] = EnumEntry("GIMBAL_MANAGER_FLAGS_YAW_IN_VEHICLE_FRAME", """Based on GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME.""")
GIMBAL_MANAGER_FLAGS_YAW_IN_EARTH_FRAME = 64
enums["GIMBAL_MANAGER_FLAGS"][64] = EnumEntry("GIMBAL_MANAGER_FLAGS_YAW_IN_EARTH_FRAME", """Based on GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME.""")
GIMBAL_MANAGER_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME = 128
enums["GIMBAL_MANAGER_FLAGS"][128] = EnumEntry("GIMBAL_MANAGER_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME", """Based on GIMBAL_DEVICE_FLAGS_ACCEPTS_YAW_IN_EARTH_FRAME.""")
GIMBAL_MANAGER_FLAGS_RC_EXCLUSIVE = 256
enums["GIMBAL_MANAGER_FLAGS"][256] = EnumEntry("GIMBAL_MANAGER_FLAGS_RC_EXCLUSIVE", """Based on GIMBAL_DEVICE_FLAGS_RC_EXCLUSIVE.""")
GIMBAL_MANAGER_FLAGS_RC_MIXED = 512
enums["GIMBAL_MANAGER_FLAGS"][512] = EnumEntry("GIMBAL_MANAGER_FLAGS_RC_MIXED", """Based on GIMBAL_DEVICE_FLAGS_RC_MIXED.""")
GIMBAL_MANAGER_FLAGS_ENUM_END = 513
enums["GIMBAL_MANAGER_FLAGS"][513] = EnumEntry("GIMBAL_MANAGER_FLAGS_ENUM_END", """""")

# GIMBAL_DEVICE_ERROR_FLAGS
enums["GIMBAL_DEVICE_ERROR_FLAGS"] = Enum()
enums["GIMBAL_DEVICE_ERROR_FLAGS"].bitmask = True
GIMBAL_DEVICE_ERROR_FLAGS_AT_ROLL_LIMIT = 1
enums["GIMBAL_DEVICE_ERROR_FLAGS"][1] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_AT_ROLL_LIMIT", """Gimbal device is limited by hardware roll limit.""")
GIMBAL_DEVICE_ERROR_FLAGS_AT_PITCH_LIMIT = 2
enums["GIMBAL_DEVICE_ERROR_FLAGS"][2] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_AT_PITCH_LIMIT", """Gimbal device is limited by hardware pitch limit.""")
GIMBAL_DEVICE_ERROR_FLAGS_AT_YAW_LIMIT = 4
enums["GIMBAL_DEVICE_ERROR_FLAGS"][4] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_AT_YAW_LIMIT", """Gimbal device is limited by hardware yaw limit.""")
GIMBAL_DEVICE_ERROR_FLAGS_ENCODER_ERROR = 8
enums["GIMBAL_DEVICE_ERROR_FLAGS"][8] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_ENCODER_ERROR", """There is an error with the gimbal encoders.""")
GIMBAL_DEVICE_ERROR_FLAGS_POWER_ERROR = 16
enums["GIMBAL_DEVICE_ERROR_FLAGS"][16] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_POWER_ERROR", """There is an error with the gimbal power source.""")
GIMBAL_DEVICE_ERROR_FLAGS_MOTOR_ERROR = 32
enums["GIMBAL_DEVICE_ERROR_FLAGS"][32] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_MOTOR_ERROR", """There is an error with the gimbal motors.""")
GIMBAL_DEVICE_ERROR_FLAGS_SOFTWARE_ERROR = 64
enums["GIMBAL_DEVICE_ERROR_FLAGS"][64] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_SOFTWARE_ERROR", """There is an error with the gimbal's software.""")
GIMBAL_DEVICE_ERROR_FLAGS_COMMS_ERROR = 128
enums["GIMBAL_DEVICE_ERROR_FLAGS"][128] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_COMMS_ERROR", """There is an error with the gimbal's communication.""")
GIMBAL_DEVICE_ERROR_FLAGS_CALIBRATION_RUNNING = 256
enums["GIMBAL_DEVICE_ERROR_FLAGS"][256] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_CALIBRATION_RUNNING", """Gimbal device is currently calibrating.""")
GIMBAL_DEVICE_ERROR_FLAGS_NO_MANAGER = 512
enums["GIMBAL_DEVICE_ERROR_FLAGS"][512] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_NO_MANAGER", """Gimbal device is not assigned to a gimbal manager.""")
GIMBAL_DEVICE_ERROR_FLAGS_ENUM_END = 513
enums["GIMBAL_DEVICE_ERROR_FLAGS"][513] = EnumEntry("GIMBAL_DEVICE_ERROR_FLAGS_ENUM_END", """""")

# GRIPPER_ACTIONS
enums["GRIPPER_ACTIONS"] = Enum()
enums["GRIPPER_ACTIONS"].bitmask = False
GRIPPER_ACTION_RELEASE = 0
enums["GRIPPER_ACTIONS"][0] = EnumEntry("GRIPPER_ACTION_RELEASE", """Gripper release cargo.""")
GRIPPER_ACTION_GRAB = 1
enums["GRIPPER_ACTIONS"][1] = EnumEntry("GRIPPER_ACTION_GRAB", """Gripper grab onto cargo.""")
GRIPPER_ACTIONS_ENUM_END = 2
enums["GRIPPER_ACTIONS"][2] = EnumEntry("GRIPPER_ACTIONS_ENUM_END", """""")

# WINCH_ACTIONS
enums["WINCH_ACTIONS"] = Enum()
enums["WINCH_ACTIONS"].bitmask = False
WINCH_RELAXED = 0
enums["WINCH_ACTIONS"][0] = EnumEntry("WINCH_RELAXED", """Allow motor to freewheel.""")
WINCH_RELATIVE_LENGTH_CONTROL = 1
enums["WINCH_ACTIONS"][1] = EnumEntry("WINCH_RELATIVE_LENGTH_CONTROL", """Wind or unwind specified length of line, optionally using specified rate.""")
WINCH_RATE_CONTROL = 2
enums["WINCH_ACTIONS"][2] = EnumEntry("WINCH_RATE_CONTROL", """Wind or unwind line at specified rate.""")
WINCH_LOCK = 3
enums["WINCH_ACTIONS"][3] = EnumEntry("WINCH_LOCK", """Perform the locking sequence to relieve motor while in the fully retracted position. Only action and instance command parameters are used, others are ignored.""")
WINCH_DELIVER = 4
enums["WINCH_ACTIONS"][4] = EnumEntry("WINCH_DELIVER", """Sequence of drop, slow down, touch down, reel up, lock. Only action and instance command parameters are used, others are ignored.""")
WINCH_HOLD = 5
enums["WINCH_ACTIONS"][5] = EnumEntry("WINCH_HOLD", """Engage motor and hold current position. Only action and instance command parameters are used, others are ignored.""")
WINCH_RETRACT = 6
enums["WINCH_ACTIONS"][6] = EnumEntry("WINCH_RETRACT", """Return the reel to the fully retracted position. Only action and instance command parameters are used, others are ignored.""")
WINCH_LOAD_LINE = 7
enums["WINCH_ACTIONS"][7] = EnumEntry("WINCH_LOAD_LINE", """Load the reel with line. The winch will calculate the total loaded length and stop when the tension exceeds a threshold. Only action and instance command parameters are used, others are ignored.""")
WINCH_ABANDON_LINE = 8
enums["WINCH_ACTIONS"][8] = EnumEntry("WINCH_ABANDON_LINE", """Spool out the entire length of the line. Only action and instance command parameters are used, others are ignored.""")
WINCH_ACTIONS_ENUM_END = 9
enums["WINCH_ACTIONS"][9] = EnumEntry("WINCH_ACTIONS_ENUM_END", """""")

# UAVCAN_NODE_HEALTH
enums["UAVCAN_NODE_HEALTH"] = Enum()
enums["UAVCAN_NODE_HEALTH"].bitmask = False
UAVCAN_NODE_HEALTH_OK = 0
enums["UAVCAN_NODE_HEALTH"][0] = EnumEntry("UAVCAN_NODE_HEALTH_OK", """The node is functioning properly.""")
UAVCAN_NODE_HEALTH_WARNING = 1
enums["UAVCAN_NODE_HEALTH"][1] = EnumEntry("UAVCAN_NODE_HEALTH_WARNING", """A critical parameter went out of range or the node has encountered a minor failure.""")
UAVCAN_NODE_HEALTH_ERROR = 2
enums["UAVCAN_NODE_HEALTH"][2] = EnumEntry("UAVCAN_NODE_HEALTH_ERROR", """The node has encountered a major failure.""")
UAVCAN_NODE_HEALTH_CRITICAL = 3
enums["UAVCAN_NODE_HEALTH"][3] = EnumEntry("UAVCAN_NODE_HEALTH_CRITICAL", """The node has suffered a fatal malfunction.""")
UAVCAN_NODE_HEALTH_ENUM_END = 4
enums["UAVCAN_NODE_HEALTH"][4] = EnumEntry("UAVCAN_NODE_HEALTH_ENUM_END", """""")

# UAVCAN_NODE_MODE
enums["UAVCAN_NODE_MODE"] = Enum()
enums["UAVCAN_NODE_MODE"].bitmask = False
UAVCAN_NODE_MODE_OPERATIONAL = 0
enums["UAVCAN_NODE_MODE"][0] = EnumEntry("UAVCAN_NODE_MODE_OPERATIONAL", """The node is performing its primary functions.""")
UAVCAN_NODE_MODE_INITIALIZATION = 1
enums["UAVCAN_NODE_MODE"][1] = EnumEntry("UAVCAN_NODE_MODE_INITIALIZATION", """The node is initializing; this mode is entered immediately after startup.""")
UAVCAN_NODE_MODE_MAINTENANCE = 2
enums["UAVCAN_NODE_MODE"][2] = EnumEntry("UAVCAN_NODE_MODE_MAINTENANCE", """The node is under maintenance.""")
UAVCAN_NODE_MODE_SOFTWARE_UPDATE = 3
enums["UAVCAN_NODE_MODE"][3] = EnumEntry("UAVCAN_NODE_MODE_SOFTWARE_UPDATE", """The node is in the process of updating its software.""")
UAVCAN_NODE_MODE_OFFLINE = 7
enums["UAVCAN_NODE_MODE"][7] = EnumEntry("UAVCAN_NODE_MODE_OFFLINE", """The node is no longer available online.""")
UAVCAN_NODE_MODE_ENUM_END = 8
enums["UAVCAN_NODE_MODE"][8] = EnumEntry("UAVCAN_NODE_MODE_ENUM_END", """""")

# STORAGE_STATUS
enums["STORAGE_STATUS"] = Enum()
enums["STORAGE_STATUS"].bitmask = False
STORAGE_STATUS_EMPTY = 0
enums["STORAGE_STATUS"][0] = EnumEntry("STORAGE_STATUS_EMPTY", """Storage is missing (no microSD card loaded for example.)""")
STORAGE_STATUS_UNFORMATTED = 1
enums["STORAGE_STATUS"][1] = EnumEntry("STORAGE_STATUS_UNFORMATTED", """Storage present but unformatted.""")
STORAGE_STATUS_READY = 2
enums["STORAGE_STATUS"][2] = EnumEntry("STORAGE_STATUS_READY", """Storage present and ready.""")
STORAGE_STATUS_NOT_SUPPORTED = 3
enums["STORAGE_STATUS"][3] = EnumEntry("STORAGE_STATUS_NOT_SUPPORTED", """Camera does not supply storage status information. Capacity information in STORAGE_INFORMATION fields will be ignored.""")
STORAGE_STATUS_ENUM_END = 4
enums["STORAGE_STATUS"][4] = EnumEntry("STORAGE_STATUS_ENUM_END", """""")

# STORAGE_TYPE
enums["STORAGE_TYPE"] = Enum()
enums["STORAGE_TYPE"].bitmask = False
STORAGE_TYPE_UNKNOWN = 0
enums["STORAGE_TYPE"][0] = EnumEntry("STORAGE_TYPE_UNKNOWN", """Storage type is not known.""")
STORAGE_TYPE_USB_STICK = 1
enums["STORAGE_TYPE"][1] = EnumEntry("STORAGE_TYPE_USB_STICK", """Storage type is USB device.""")
STORAGE_TYPE_SD = 2
enums["STORAGE_TYPE"][2] = EnumEntry("STORAGE_TYPE_SD", """Storage type is SD card.""")
STORAGE_TYPE_MICROSD = 3
enums["STORAGE_TYPE"][3] = EnumEntry("STORAGE_TYPE_MICROSD", """Storage type is microSD card.""")
STORAGE_TYPE_CF = 4
enums["STORAGE_TYPE"][4] = EnumEntry("STORAGE_TYPE_CF", """Storage type is CFast.""")
STORAGE_TYPE_CFE = 5
enums["STORAGE_TYPE"][5] = EnumEntry("STORAGE_TYPE_CFE", """Storage type is CFexpress.""")
STORAGE_TYPE_XQD = 6
enums["STORAGE_TYPE"][6] = EnumEntry("STORAGE_TYPE_XQD", """Storage type is XQD.""")
STORAGE_TYPE_HD = 7
enums["STORAGE_TYPE"][7] = EnumEntry("STORAGE_TYPE_HD", """Storage type is HD mass storage type.""")
STORAGE_TYPE_OTHER = 254
enums["STORAGE_TYPE"][254] = EnumEntry("STORAGE_TYPE_OTHER", """Storage type is other, not listed type.""")
STORAGE_TYPE_ENUM_END = 255
enums["STORAGE_TYPE"][255] = EnumEntry("STORAGE_TYPE_ENUM_END", """""")

# STORAGE_USAGE_FLAG
enums["STORAGE_USAGE_FLAG"] = Enum()
enums["STORAGE_USAGE_FLAG"].bitmask = False
STORAGE_USAGE_FLAG_SET = 1
enums["STORAGE_USAGE_FLAG"][1] = EnumEntry("STORAGE_USAGE_FLAG_SET", """Always set to 1 (indicates STORAGE_INFORMATION.storage_usage is supported).""")
STORAGE_USAGE_FLAG_PHOTO = 2
enums["STORAGE_USAGE_FLAG"][2] = EnumEntry("STORAGE_USAGE_FLAG_PHOTO", """Storage for saving photos.""")
STORAGE_USAGE_FLAG_VIDEO = 4
enums["STORAGE_USAGE_FLAG"][4] = EnumEntry("STORAGE_USAGE_FLAG_VIDEO", """Storage for saving videos.""")
STORAGE_USAGE_FLAG_LOGS = 8
enums["STORAGE_USAGE_FLAG"][8] = EnumEntry("STORAGE_USAGE_FLAG_LOGS", """Storage for saving logs.""")
STORAGE_USAGE_FLAG_ENUM_END = 9
enums["STORAGE_USAGE_FLAG"][9] = EnumEntry("STORAGE_USAGE_FLAG_ENUM_END", """""")

# AUTOTUNE_AXIS
enums["AUTOTUNE_AXIS"] = Enum()
enums["AUTOTUNE_AXIS"].bitmask = True
AUTOTUNE_AXIS_ROLL = 1
enums["AUTOTUNE_AXIS"][1] = EnumEntry("AUTOTUNE_AXIS_ROLL", """Autotune roll axis.""")
AUTOTUNE_AXIS_PITCH = 2
enums["AUTOTUNE_AXIS"][2] = EnumEntry("AUTOTUNE_AXIS_PITCH", """Autotune pitch axis.""")
AUTOTUNE_AXIS_YAW = 4
enums["AUTOTUNE_AXIS"][4] = EnumEntry("AUTOTUNE_AXIS_YAW", """Autotune yaw axis.""")
AUTOTUNE_AXIS_ENUM_END = 5
enums["AUTOTUNE_AXIS"][5] = EnumEntry("AUTOTUNE_AXIS_ENUM_END", """""")

# MAV_DATA_STREAM
enums["MAV_DATA_STREAM"] = Enum()
enums["MAV_DATA_STREAM"].bitmask = False
MAV_DATA_STREAM_ALL = 0
enums["MAV_DATA_STREAM"][0] = EnumEntry("MAV_DATA_STREAM_ALL", """Enable all data streams""")
MAV_DATA_STREAM_RAW_SENSORS = 1
enums["MAV_DATA_STREAM"][1] = EnumEntry("MAV_DATA_STREAM_RAW_SENSORS", """Enable IMU_RAW, GPS_RAW, GPS_STATUS packets.""")
MAV_DATA_STREAM_EXTENDED_STATUS = 2
enums["MAV_DATA_STREAM"][2] = EnumEntry("MAV_DATA_STREAM_EXTENDED_STATUS", """Enable GPS_STATUS, CONTROL_STATUS, AUX_STATUS""")
MAV_DATA_STREAM_RC_CHANNELS = 3
enums["MAV_DATA_STREAM"][3] = EnumEntry("MAV_DATA_STREAM_RC_CHANNELS", """Enable RC_CHANNELS_SCALED, RC_CHANNELS_RAW, SERVO_OUTPUT_RAW""")
MAV_DATA_STREAM_RAW_CONTROLLER = 4
enums["MAV_DATA_STREAM"][4] = EnumEntry("MAV_DATA_STREAM_RAW_CONTROLLER", """Enable ATTITUDE_CONTROLLER_OUTPUT, POSITION_CONTROLLER_OUTPUT, NAV_CONTROLLER_OUTPUT.""")
MAV_DATA_STREAM_POSITION = 6
enums["MAV_DATA_STREAM"][6] = EnumEntry("MAV_DATA_STREAM_POSITION", """Enable LOCAL_POSITION, GLOBAL_POSITION_INT messages.""")
MAV_DATA_STREAM_EXTRA1 = 10
enums["MAV_DATA_STREAM"][10] = EnumEntry("MAV_DATA_STREAM_EXTRA1", """Dependent on the autopilot""")
MAV_DATA_STREAM_EXTRA2 = 11
enums["MAV_DATA_STREAM"][11] = EnumEntry("MAV_DATA_STREAM_EXTRA2", """Dependent on the autopilot""")
MAV_DATA_STREAM_EXTRA3 = 12
enums["MAV_DATA_STREAM"][12] = EnumEntry("MAV_DATA_STREAM_EXTRA3", """Dependent on the autopilot""")
MAV_DATA_STREAM_ENUM_END = 13
enums["MAV_DATA_STREAM"][13] = EnumEntry("MAV_DATA_STREAM_ENUM_END", """""")

# MAV_ROI
enums["MAV_ROI"] = Enum()
enums["MAV_ROI"].bitmask = False
MAV_ROI_NONE = 0
enums["MAV_ROI"][0] = EnumEntry("MAV_ROI_NONE", """No region of interest.""")
MAV_ROI_WPNEXT = 1
enums["MAV_ROI"][1] = EnumEntry("MAV_ROI_WPNEXT", """Point toward next waypoint, with optional pitch/roll/yaw offset.""")
MAV_ROI_WPINDEX = 2
enums["MAV_ROI"][2] = EnumEntry("MAV_ROI_WPINDEX", """Point toward given waypoint.""")
MAV_ROI_LOCATION = 3
enums["MAV_ROI"][3] = EnumEntry("MAV_ROI_LOCATION", """Point toward fixed location.""")
MAV_ROI_TARGET = 4
enums["MAV_ROI"][4] = EnumEntry("MAV_ROI_TARGET", """Point toward of given id.""")
MAV_ROI_ENUM_END = 5
enums["MAV_ROI"][5] = EnumEntry("MAV_ROI_ENUM_END", """""")

# MAV_PARAM_TYPE
enums["MAV_PARAM_TYPE"] = Enum()
enums["MAV_PARAM_TYPE"].bitmask = False
MAV_PARAM_TYPE_UINT8 = 1
enums["MAV_PARAM_TYPE"][1] = EnumEntry("MAV_PARAM_TYPE_UINT8", """8-bit unsigned integer""")
MAV_PARAM_TYPE_INT8 = 2
enums["MAV_PARAM_TYPE"][2] = EnumEntry("MAV_PARAM_TYPE_INT8", """8-bit signed integer""")
MAV_PARAM_TYPE_UINT16 = 3
enums["MAV_PARAM_TYPE"][3] = EnumEntry("MAV_PARAM_TYPE_UINT16", """16-bit unsigned integer""")
MAV_PARAM_TYPE_INT16 = 4
enums["MAV_PARAM_TYPE"][4] = EnumEntry("MAV_PARAM_TYPE_INT16", """16-bit signed integer""")
MAV_PARAM_TYPE_UINT32 = 5
enums["MAV_PARAM_TYPE"][5] = EnumEntry("MAV_PARAM_TYPE_UINT32", """32-bit unsigned integer""")
MAV_PARAM_TYPE_INT32 = 6
enums["MAV_PARAM_TYPE"][6] = EnumEntry("MAV_PARAM_TYPE_INT32", """32-bit signed integer""")
MAV_PARAM_TYPE_UINT64 = 7
enums["MAV_PARAM_TYPE"][7] = EnumEntry("MAV_PARAM_TYPE_UINT64", """64-bit unsigned integer""")
MAV_PARAM_TYPE_INT64 = 8
enums["MAV_PARAM_TYPE"][8] = EnumEntry("MAV_PARAM_TYPE_INT64", """64-bit signed integer""")
MAV_PARAM_TYPE_REAL32 = 9
enums["MAV_PARAM_TYPE"][9] = EnumEntry("MAV_PARAM_TYPE_REAL32", """32-bit floating-point""")
MAV_PARAM_TYPE_REAL64 = 10
enums["MAV_PARAM_TYPE"][10] = EnumEntry("MAV_PARAM_TYPE_REAL64", """64-bit floating-point""")
MAV_PARAM_TYPE_ENUM_END = 11
enums["MAV_PARAM_TYPE"][11] = EnumEntry("MAV_PARAM_TYPE_ENUM_END", """""")

# MAV_PARAM_EXT_TYPE
enums["MAV_PARAM_EXT_TYPE"] = Enum()
enums["MAV_PARAM_EXT_TYPE"].bitmask = False
MAV_PARAM_EXT_TYPE_UINT8 = 1
enums["MAV_PARAM_EXT_TYPE"][1] = EnumEntry("MAV_PARAM_EXT_TYPE_UINT8", """8-bit unsigned integer""")
MAV_PARAM_EXT_TYPE_INT8 = 2
enums["MAV_PARAM_EXT_TYPE"][2] = EnumEntry("MAV_PARAM_EXT_TYPE_INT8", """8-bit signed integer""")
MAV_PARAM_EXT_TYPE_UINT16 = 3
enums["MAV_PARAM_EXT_TYPE"][3] = EnumEntry("MAV_PARAM_EXT_TYPE_UINT16", """16-bit unsigned integer""")
MAV_PARAM_EXT_TYPE_INT16 = 4
enums["MAV_PARAM_EXT_TYPE"][4] = EnumEntry("MAV_PARAM_EXT_TYPE_INT16", """16-bit signed integer""")
MAV_PARAM_EXT_TYPE_UINT32 = 5
enums["MAV_PARAM_EXT_TYPE"][5] = EnumEntry("MAV_PARAM_EXT_TYPE_UINT32", """32-bit unsigned integer""")
MAV_PARAM_EXT_TYPE_INT32 = 6
enums["MAV_PARAM_EXT_TYPE"][6] = EnumEntry("MAV_PARAM_EXT_TYPE_INT32", """32-bit signed integer""")
MAV_PARAM_EXT_TYPE_UINT64 = 7
enums["MAV_PARAM_EXT_TYPE"][7] = EnumEntry("MAV_PARAM_EXT_TYPE_UINT64", """64-bit unsigned integer""")
MAV_PARAM_EXT_TYPE_INT64 = 8
enums["MAV_PARAM_EXT_TYPE"][8] = EnumEntry("MAV_PARAM_EXT_TYPE_INT64", """64-bit signed integer""")
MAV_PARAM_EXT_TYPE_REAL32 = 9
enums["MAV_PARAM_EXT_TYPE"][9] = EnumEntry("MAV_PARAM_EXT_TYPE_REAL32", """32-bit floating-point""")
MAV_PARAM_EXT_TYPE_REAL64 = 10
enums["MAV_PARAM_EXT_TYPE"][10] = EnumEntry("MAV_PARAM_EXT_TYPE_REAL64", """64-bit floating-point""")
MAV_PARAM_EXT_TYPE_CUSTOM = 11
enums["MAV_PARAM_EXT_TYPE"][11] = EnumEntry("MAV_PARAM_EXT_TYPE_CUSTOM", """Custom Type""")
MAV_PARAM_EXT_TYPE_ENUM_END = 12
enums["MAV_PARAM_EXT_TYPE"][12] = EnumEntry("MAV_PARAM_EXT_TYPE_ENUM_END", """""")

# MAV_RESULT
enums["MAV_RESULT"] = Enum()
enums["MAV_RESULT"].bitmask = False
MAV_RESULT_ACCEPTED = 0
enums["MAV_RESULT"][0] = EnumEntry("MAV_RESULT_ACCEPTED", """Command is valid (is supported and has valid parameters), and was executed.""")
MAV_RESULT_TEMPORARILY_REJECTED = 1
enums["MAV_RESULT"][1] = EnumEntry("MAV_RESULT_TEMPORARILY_REJECTED", """Command is valid, but cannot be executed at this time. This is used to indicate a problem that should be fixed just by waiting (e.g. a state machine is busy, can't arm because have not got GPS lock, etc.). Retrying later should work.""")
MAV_RESULT_DENIED = 2
enums["MAV_RESULT"][2] = EnumEntry("MAV_RESULT_DENIED", """Command is invalid (is supported but has invalid parameters). Retrying same command and parameters will not work.""")
MAV_RESULT_UNSUPPORTED = 3
enums["MAV_RESULT"][3] = EnumEntry("MAV_RESULT_UNSUPPORTED", """Command is not supported (unknown).""")
MAV_RESULT_FAILED = 4
enums["MAV_RESULT"][4] = EnumEntry("MAV_RESULT_FAILED", """Command is valid, but execution has failed. This is used to indicate any non-temporary or unexpected problem, i.e. any problem that must be fixed before the command can succeed/be retried. For example, attempting to write a file when out of memory, attempting to arm when sensors are not calibrated, etc.""")
MAV_RESULT_IN_PROGRESS = 5
enums["MAV_RESULT"][5] = EnumEntry("MAV_RESULT_IN_PROGRESS", """Command is valid and is being executed. This will be followed by further progress updates, i.e. the component may send further COMMAND_ACK messages with result MAV_RESULT_IN_PROGRESS (at a rate decided by the implementation), and must terminate by sending a COMMAND_ACK message with final result of the operation. The COMMAND_ACK.progress field can be used to indicate the progress of the operation. There is no need for the sender to retry the command, but if done during execution, the component will return MAV_RESULT_IN_PROGRESS with an updated progress.""")
MAV_RESULT_COMMAND_LONG_ONLY = 7
enums["MAV_RESULT"][7] = EnumEntry("MAV_RESULT_COMMAND_LONG_ONLY", """Command is only accepted when sent as a COMMAND_LONG.""")
MAV_RESULT_COMMAND_INT_ONLY = 8
enums["MAV_RESULT"][8] = EnumEntry("MAV_RESULT_COMMAND_INT_ONLY", """Command is only accepted when sent as a COMMAND_INT.""")
MAV_RESULT_ENUM_END = 9
enums["MAV_RESULT"][9] = EnumEntry("MAV_RESULT_ENUM_END", """""")

# MAV_MISSION_RESULT
enums["MAV_MISSION_RESULT"] = Enum()
enums["MAV_MISSION_RESULT"].bitmask = False
MAV_MISSION_ACCEPTED = 0
enums["MAV_MISSION_RESULT"][0] = EnumEntry("MAV_MISSION_ACCEPTED", """mission accepted OK""")
MAV_MISSION_ERROR = 1
enums["MAV_MISSION_RESULT"][1] = EnumEntry("MAV_MISSION_ERROR", """Generic error / not accepting mission commands at all right now.""")
MAV_MISSION_UNSUPPORTED_FRAME = 2
enums["MAV_MISSION_RESULT"][2] = EnumEntry("MAV_MISSION_UNSUPPORTED_FRAME", """Coordinate frame is not supported.""")
MAV_MISSION_UNSUPPORTED = 3
enums["MAV_MISSION_RESULT"][3] = EnumEntry("MAV_MISSION_UNSUPPORTED", """Command is not supported.""")
MAV_MISSION_NO_SPACE = 4
enums["MAV_MISSION_RESULT"][4] = EnumEntry("MAV_MISSION_NO_SPACE", """Mission items exceed storage space.""")
MAV_MISSION_INVALID = 5
enums["MAV_MISSION_RESULT"][5] = EnumEntry("MAV_MISSION_INVALID", """One of the parameters has an invalid value.""")
MAV_MISSION_INVALID_PARAM1 = 6
enums["MAV_MISSION_RESULT"][6] = EnumEntry("MAV_MISSION_INVALID_PARAM1", """param1 has an invalid value.""")
MAV_MISSION_INVALID_PARAM2 = 7
enums["MAV_MISSION_RESULT"][7] = EnumEntry("MAV_MISSION_INVALID_PARAM2", """param2 has an invalid value.""")
MAV_MISSION_INVALID_PARAM3 = 8
enums["MAV_MISSION_RESULT"][8] = EnumEntry("MAV_MISSION_INVALID_PARAM3", """param3 has an invalid value.""")
MAV_MISSION_INVALID_PARAM4 = 9
enums["MAV_MISSION_RESULT"][9] = EnumEntry("MAV_MISSION_INVALID_PARAM4", """param4 has an invalid value.""")
MAV_MISSION_INVALID_PARAM5_X = 10
enums["MAV_MISSION_RESULT"][10] = EnumEntry("MAV_MISSION_INVALID_PARAM5_X", """x / param5 has an invalid value.""")
MAV_MISSION_INVALID_PARAM6_Y = 11
enums["MAV_MISSION_RESULT"][11] = EnumEntry("MAV_MISSION_INVALID_PARAM6_Y", """y / param6 has an invalid value.""")
MAV_MISSION_INVALID_PARAM7 = 12
enums["MAV_MISSION_RESULT"][12] = EnumEntry("MAV_MISSION_INVALID_PARAM7", """z / param7 has an invalid value.""")
MAV_MISSION_INVALID_SEQUENCE = 13
enums["MAV_MISSION_RESULT"][13] = EnumEntry("MAV_MISSION_INVALID_SEQUENCE", """Mission item received out of sequence""")
MAV_MISSION_DENIED = 14
enums["MAV_MISSION_RESULT"][14] = EnumEntry("MAV_MISSION_DENIED", """Not accepting any mission commands from this communication partner.""")
MAV_MISSION_OPERATION_CANCELLED = 15
enums["MAV_MISSION_RESULT"][15] = EnumEntry("MAV_MISSION_OPERATION_CANCELLED", """Current mission operation cancelled (e.g. mission upload, mission download).""")
MAV_MISSION_RESULT_ENUM_END = 16
enums["MAV_MISSION_RESULT"][16] = EnumEntry("MAV_MISSION_RESULT_ENUM_END", """""")

# MAV_SEVERITY
enums["MAV_SEVERITY"] = Enum()
enums["MAV_SEVERITY"].bitmask = False
MAV_SEVERITY_EMERGENCY = 0
enums["MAV_SEVERITY"][0] = EnumEntry("MAV_SEVERITY_EMERGENCY", """System is unusable. This is a "panic" condition.""")
MAV_SEVERITY_ALERT = 1
enums["MAV_SEVERITY"][1] = EnumEntry("MAV_SEVERITY_ALERT", """Action should be taken immediately. Indicates error in non-critical systems.""")
MAV_SEVERITY_CRITICAL = 2
enums["MAV_SEVERITY"][2] = EnumEntry("MAV_SEVERITY_CRITICAL", """Action must be taken immediately. Indicates failure in a primary system.""")
MAV_SEVERITY_ERROR = 3
enums["MAV_SEVERITY"][3] = EnumEntry("MAV_SEVERITY_ERROR", """Indicates an error in secondary/redundant systems.""")
MAV_SEVERITY_WARNING = 4
enums["MAV_SEVERITY"][4] = EnumEntry("MAV_SEVERITY_WARNING", """Indicates about a possible future error if this is not resolved within a given timeframe. Example would be a low battery warning.""")
MAV_SEVERITY_NOTICE = 5
enums["MAV_SEVERITY"][5] = EnumEntry("MAV_SEVERITY_NOTICE", """An unusual event has occurred, though not an error condition. This should be investigated for the root cause.""")
MAV_SEVERITY_INFO = 6
enums["MAV_SEVERITY"][6] = EnumEntry("MAV_SEVERITY_INFO", """Normal operational messages. Useful for logging. No action is required for these messages.""")
MAV_SEVERITY_DEBUG = 7
enums["MAV_SEVERITY"][7] = EnumEntry("MAV_SEVERITY_DEBUG", """Useful non-operational messages that can assist in debugging. These should not occur during normal operation.""")
MAV_SEVERITY_ENUM_END = 8
enums["MAV_SEVERITY"][8] = EnumEntry("MAV_SEVERITY_ENUM_END", """""")

# MAV_POWER_STATUS
enums["MAV_POWER_STATUS"] = Enum()
enums["MAV_POWER_STATUS"].bitmask = True
MAV_POWER_STATUS_BRICK_VALID = 1
enums["MAV_POWER_STATUS"][1] = EnumEntry("MAV_POWER_STATUS_BRICK_VALID", """main brick power supply valid""")
MAV_POWER_STATUS_SERVO_VALID = 2
enums["MAV_POWER_STATUS"][2] = EnumEntry("MAV_POWER_STATUS_SERVO_VALID", """main servo power supply valid for FMU""")
MAV_POWER_STATUS_USB_CONNECTED = 4
enums["MAV_POWER_STATUS"][4] = EnumEntry("MAV_POWER_STATUS_USB_CONNECTED", """USB power is connected""")
MAV_POWER_STATUS_PERIPH_OVERCURRENT = 8
enums["MAV_POWER_STATUS"][8] = EnumEntry("MAV_POWER_STATUS_PERIPH_OVERCURRENT", """peripheral supply is in over-current state""")
MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT = 16
enums["MAV_POWER_STATUS"][16] = EnumEntry("MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT", """hi-power peripheral supply is in over-current state""")
MAV_POWER_STATUS_CHANGED = 32
enums["MAV_POWER_STATUS"][32] = EnumEntry("MAV_POWER_STATUS_CHANGED", """Power status has changed since boot""")
MAV_POWER_STATUS_ENUM_END = 33
enums["MAV_POWER_STATUS"][33] = EnumEntry("MAV_POWER_STATUS_ENUM_END", """""")

# SERIAL_CONTROL_DEV
enums["SERIAL_CONTROL_DEV"] = Enum()
enums["SERIAL_CONTROL_DEV"].bitmask = False
SERIAL_CONTROL_DEV_TELEM1 = 0
enums["SERIAL_CONTROL_DEV"][0] = EnumEntry("SERIAL_CONTROL_DEV_TELEM1", """First telemetry port""")
SERIAL_CONTROL_DEV_TELEM2 = 1
enums["SERIAL_CONTROL_DEV"][1] = EnumEntry("SERIAL_CONTROL_DEV_TELEM2", """Second telemetry port""")
SERIAL_CONTROL_DEV_GPS1 = 2
enums["SERIAL_CONTROL_DEV"][2] = EnumEntry("SERIAL_CONTROL_DEV_GPS1", """First GPS port""")
SERIAL_CONTROL_DEV_GPS2 = 3
enums["SERIAL_CONTROL_DEV"][3] = EnumEntry("SERIAL_CONTROL_DEV_GPS2", """Second GPS port""")
SERIAL_CONTROL_DEV_SHELL = 10
enums["SERIAL_CONTROL_DEV"][10] = EnumEntry("SERIAL_CONTROL_DEV_SHELL", """system shell""")
SERIAL_CONTROL_SERIAL0 = 100
enums["SERIAL_CONTROL_DEV"][100] = EnumEntry("SERIAL_CONTROL_SERIAL0", """SERIAL0""")
SERIAL_CONTROL_SERIAL1 = 101
enums["SERIAL_CONTROL_DEV"][101] = EnumEntry("SERIAL_CONTROL_SERIAL1", """SERIAL1""")
SERIAL_CONTROL_SERIAL2 = 102
enums["SERIAL_CONTROL_DEV"][102] = EnumEntry("SERIAL_CONTROL_SERIAL2", """SERIAL2""")
SERIAL_CONTROL_SERIAL3 = 103
enums["SERIAL_CONTROL_DEV"][103] = EnumEntry("SERIAL_CONTROL_SERIAL3", """SERIAL3""")
SERIAL_CONTROL_SERIAL4 = 104
enums["SERIAL_CONTROL_DEV"][104] = EnumEntry("SERIAL_CONTROL_SERIAL4", """SERIAL4""")
SERIAL_CONTROL_SERIAL5 = 105
enums["SERIAL_CONTROL_DEV"][105] = EnumEntry("SERIAL_CONTROL_SERIAL5", """SERIAL5""")
SERIAL_CONTROL_SERIAL6 = 106
enums["SERIAL_CONTROL_DEV"][106] = EnumEntry("SERIAL_CONTROL_SERIAL6", """SERIAL6""")
SERIAL_CONTROL_SERIAL7 = 107
enums["SERIAL_CONTROL_DEV"][107] = EnumEntry("SERIAL_CONTROL_SERIAL7", """SERIAL7""")
SERIAL_CONTROL_SERIAL8 = 108
enums["SERIAL_CONTROL_DEV"][108] = EnumEntry("SERIAL_CONTROL_SERIAL8", """SERIAL8""")
SERIAL_CONTROL_SERIAL9 = 109
enums["SERIAL_CONTROL_DEV"][109] = EnumEntry("SERIAL_CONTROL_SERIAL9", """SERIAL9""")
SERIAL_CONTROL_DEV_ENUM_END = 110
enums["SERIAL_CONTROL_DEV"][110] = EnumEntry("SERIAL_CONTROL_DEV_ENUM_END", """""")

# SERIAL_CONTROL_FLAG
enums["SERIAL_CONTROL_FLAG"] = Enum()
enums["SERIAL_CONTROL_FLAG"].bitmask = True
SERIAL_CONTROL_FLAG_REPLY = 1
enums["SERIAL_CONTROL_FLAG"][1] = EnumEntry("SERIAL_CONTROL_FLAG_REPLY", """Set if this is a reply""")
SERIAL_CONTROL_FLAG_RESPOND = 2
enums["SERIAL_CONTROL_FLAG"][2] = EnumEntry("SERIAL_CONTROL_FLAG_RESPOND", """Set if the sender wants the receiver to send a response as another SERIAL_CONTROL message""")
SERIAL_CONTROL_FLAG_EXCLUSIVE = 4
enums["SERIAL_CONTROL_FLAG"][4] = EnumEntry("SERIAL_CONTROL_FLAG_EXCLUSIVE", """Set if access to the serial port should be removed from whatever driver is currently using it, giving exclusive access to the SERIAL_CONTROL protocol. The port can be handed back by sending a request without this flag set""")
SERIAL_CONTROL_FLAG_BLOCKING = 8
enums["SERIAL_CONTROL_FLAG"][8] = EnumEntry("SERIAL_CONTROL_FLAG_BLOCKING", """Block on writes to the serial port""")
SERIAL_CONTROL_FLAG_MULTI = 16
enums["SERIAL_CONTROL_FLAG"][16] = EnumEntry("SERIAL_CONTROL_FLAG_MULTI", """Send multiple replies until port is drained""")
SERIAL_CONTROL_FLAG_ENUM_END = 17
enums["SERIAL_CONTROL_FLAG"][17] = EnumEntry("SERIAL_CONTROL_FLAG_ENUM_END", """""")

# MAV_DISTANCE_SENSOR
enums["MAV_DISTANCE_SENSOR"] = Enum()
enums["MAV_DISTANCE_SENSOR"].bitmask = False
MAV_DISTANCE_SENSOR_LASER = 0
enums["MAV_DISTANCE_SENSOR"][0] = EnumEntry("MAV_DISTANCE_SENSOR_LASER", """Laser rangefinder, e.g. LightWare SF02/F or PulsedLight units""")
MAV_DISTANCE_SENSOR_ULTRASOUND = 1
enums["MAV_DISTANCE_SENSOR"][1] = EnumEntry("MAV_DISTANCE_SENSOR_ULTRASOUND", """Ultrasound rangefinder, e.g. MaxBotix units""")
MAV_DISTANCE_SENSOR_INFRARED = 2
enums["MAV_DISTANCE_SENSOR"][2] = EnumEntry("MAV_DISTANCE_SENSOR_INFRARED", """Infrared rangefinder, e.g. Sharp units""")
MAV_DISTANCE_SENSOR_RADAR = 3
enums["MAV_DISTANCE_SENSOR"][3] = EnumEntry("MAV_DISTANCE_SENSOR_RADAR", """Radar type, e.g. uLanding units""")
MAV_DISTANCE_SENSOR_UNKNOWN = 4
enums["MAV_DISTANCE_SENSOR"][4] = EnumEntry("MAV_DISTANCE_SENSOR_UNKNOWN", """Broken or unknown type, e.g. analog units""")
MAV_DISTANCE_SENSOR_ENUM_END = 5
enums["MAV_DISTANCE_SENSOR"][5] = EnumEntry("MAV_DISTANCE_SENSOR_ENUM_END", """""")

# MAV_SENSOR_ORIENTATION
enums["MAV_SENSOR_ORIENTATION"] = Enum()
enums["MAV_SENSOR_ORIENTATION"].bitmask = False
MAV_SENSOR_ROTATION_NONE = 0
enums["MAV_SENSOR_ORIENTATION"][0] = EnumEntry("MAV_SENSOR_ROTATION_NONE", """Roll: 0, Pitch: 0, Yaw: 0""")
MAV_SENSOR_ROTATION_YAW_45 = 1
enums["MAV_SENSOR_ORIENTATION"][1] = EnumEntry("MAV_SENSOR_ROTATION_YAW_45", """Roll: 0, Pitch: 0, Yaw: 45""")
MAV_SENSOR_ROTATION_YAW_90 = 2
enums["MAV_SENSOR_ORIENTATION"][2] = EnumEntry("MAV_SENSOR_ROTATION_YAW_90", """Roll: 0, Pitch: 0, Yaw: 90""")
MAV_SENSOR_ROTATION_YAW_135 = 3
enums["MAV_SENSOR_ORIENTATION"][3] = EnumEntry("MAV_SENSOR_ROTATION_YAW_135", """Roll: 0, Pitch: 0, Yaw: 135""")
MAV_SENSOR_ROTATION_YAW_180 = 4
enums["MAV_SENSOR_ORIENTATION"][4] = EnumEntry("MAV_SENSOR_ROTATION_YAW_180", """Roll: 0, Pitch: 0, Yaw: 180""")
MAV_SENSOR_ROTATION_YAW_225 = 5
enums["MAV_SENSOR_ORIENTATION"][5] = EnumEntry("MAV_SENSOR_ROTATION_YAW_225", """Roll: 0, Pitch: 0, Yaw: 225""")
MAV_SENSOR_ROTATION_YAW_270 = 6
enums["MAV_SENSOR_ORIENTATION"][6] = EnumEntry("MAV_SENSOR_ROTATION_YAW_270", """Roll: 0, Pitch: 0, Yaw: 270""")
MAV_SENSOR_ROTATION_YAW_315 = 7
enums["MAV_SENSOR_ORIENTATION"][7] = EnumEntry("MAV_SENSOR_ROTATION_YAW_315", """Roll: 0, Pitch: 0, Yaw: 315""")
MAV_SENSOR_ROTATION_ROLL_180 = 8
enums["MAV_SENSOR_ORIENTATION"][8] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180", """Roll: 180, Pitch: 0, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_180_YAW_45 = 9
enums["MAV_SENSOR_ORIENTATION"][9] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180_YAW_45", """Roll: 180, Pitch: 0, Yaw: 45""")
MAV_SENSOR_ROTATION_ROLL_180_YAW_90 = 10
enums["MAV_SENSOR_ORIENTATION"][10] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180_YAW_90", """Roll: 180, Pitch: 0, Yaw: 90""")
MAV_SENSOR_ROTATION_ROLL_180_YAW_135 = 11
enums["MAV_SENSOR_ORIENTATION"][11] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180_YAW_135", """Roll: 180, Pitch: 0, Yaw: 135""")
MAV_SENSOR_ROTATION_PITCH_180 = 12
enums["MAV_SENSOR_ORIENTATION"][12] = EnumEntry("MAV_SENSOR_ROTATION_PITCH_180", """Roll: 0, Pitch: 180, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_180_YAW_225 = 13
enums["MAV_SENSOR_ORIENTATION"][13] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180_YAW_225", """Roll: 180, Pitch: 0, Yaw: 225""")
MAV_SENSOR_ROTATION_ROLL_180_YAW_270 = 14
enums["MAV_SENSOR_ORIENTATION"][14] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180_YAW_270", """Roll: 180, Pitch: 0, Yaw: 270""")
MAV_SENSOR_ROTATION_ROLL_180_YAW_315 = 15
enums["MAV_SENSOR_ORIENTATION"][15] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180_YAW_315", """Roll: 180, Pitch: 0, Yaw: 315""")
MAV_SENSOR_ROTATION_ROLL_90 = 16
enums["MAV_SENSOR_ORIENTATION"][16] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90", """Roll: 90, Pitch: 0, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_90_YAW_45 = 17
enums["MAV_SENSOR_ORIENTATION"][17] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_YAW_45", """Roll: 90, Pitch: 0, Yaw: 45""")
MAV_SENSOR_ROTATION_ROLL_90_YAW_90 = 18
enums["MAV_SENSOR_ORIENTATION"][18] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_YAW_90", """Roll: 90, Pitch: 0, Yaw: 90""")
MAV_SENSOR_ROTATION_ROLL_90_YAW_135 = 19
enums["MAV_SENSOR_ORIENTATION"][19] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_YAW_135", """Roll: 90, Pitch: 0, Yaw: 135""")
MAV_SENSOR_ROTATION_ROLL_270 = 20
enums["MAV_SENSOR_ORIENTATION"][20] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_270", """Roll: 270, Pitch: 0, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_270_YAW_45 = 21
enums["MAV_SENSOR_ORIENTATION"][21] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_270_YAW_45", """Roll: 270, Pitch: 0, Yaw: 45""")
MAV_SENSOR_ROTATION_ROLL_270_YAW_90 = 22
enums["MAV_SENSOR_ORIENTATION"][22] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_270_YAW_90", """Roll: 270, Pitch: 0, Yaw: 90""")
MAV_SENSOR_ROTATION_ROLL_270_YAW_135 = 23
enums["MAV_SENSOR_ORIENTATION"][23] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_270_YAW_135", """Roll: 270, Pitch: 0, Yaw: 135""")
MAV_SENSOR_ROTATION_PITCH_90 = 24
enums["MAV_SENSOR_ORIENTATION"][24] = EnumEntry("MAV_SENSOR_ROTATION_PITCH_90", """Roll: 0, Pitch: 90, Yaw: 0""")
MAV_SENSOR_ROTATION_PITCH_270 = 25
enums["MAV_SENSOR_ORIENTATION"][25] = EnumEntry("MAV_SENSOR_ROTATION_PITCH_270", """Roll: 0, Pitch: 270, Yaw: 0""")
MAV_SENSOR_ROTATION_PITCH_180_YAW_90 = 26
enums["MAV_SENSOR_ORIENTATION"][26] = EnumEntry("MAV_SENSOR_ROTATION_PITCH_180_YAW_90", """Roll: 0, Pitch: 180, Yaw: 90""")
MAV_SENSOR_ROTATION_PITCH_180_YAW_270 = 27
enums["MAV_SENSOR_ORIENTATION"][27] = EnumEntry("MAV_SENSOR_ROTATION_PITCH_180_YAW_270", """Roll: 0, Pitch: 180, Yaw: 270""")
MAV_SENSOR_ROTATION_ROLL_90_PITCH_90 = 28
enums["MAV_SENSOR_ORIENTATION"][28] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_PITCH_90", """Roll: 90, Pitch: 90, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_180_PITCH_90 = 29
enums["MAV_SENSOR_ORIENTATION"][29] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180_PITCH_90", """Roll: 180, Pitch: 90, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_270_PITCH_90 = 30
enums["MAV_SENSOR_ORIENTATION"][30] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_270_PITCH_90", """Roll: 270, Pitch: 90, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_90_PITCH_180 = 31
enums["MAV_SENSOR_ORIENTATION"][31] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_PITCH_180", """Roll: 90, Pitch: 180, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_270_PITCH_180 = 32
enums["MAV_SENSOR_ORIENTATION"][32] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_270_PITCH_180", """Roll: 270, Pitch: 180, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_90_PITCH_270 = 33
enums["MAV_SENSOR_ORIENTATION"][33] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_PITCH_270", """Roll: 90, Pitch: 270, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_180_PITCH_270 = 34
enums["MAV_SENSOR_ORIENTATION"][34] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_180_PITCH_270", """Roll: 180, Pitch: 270, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_270_PITCH_270 = 35
enums["MAV_SENSOR_ORIENTATION"][35] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_270_PITCH_270", """Roll: 270, Pitch: 270, Yaw: 0""")
MAV_SENSOR_ROTATION_ROLL_90_PITCH_180_YAW_90 = 36
enums["MAV_SENSOR_ORIENTATION"][36] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_PITCH_180_YAW_90", """Roll: 90, Pitch: 180, Yaw: 90""")
MAV_SENSOR_ROTATION_ROLL_90_YAW_270 = 37
enums["MAV_SENSOR_ORIENTATION"][37] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_YAW_270", """Roll: 90, Pitch: 0, Yaw: 270""")
MAV_SENSOR_ROTATION_ROLL_90_PITCH_68_YAW_293 = 38
enums["MAV_SENSOR_ORIENTATION"][38] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_PITCH_68_YAW_293", """Roll: 90, Pitch: 68, Yaw: 293""")
MAV_SENSOR_ROTATION_PITCH_315 = 39
enums["MAV_SENSOR_ORIENTATION"][39] = EnumEntry("MAV_SENSOR_ROTATION_PITCH_315", """Pitch: 315""")
MAV_SENSOR_ROTATION_ROLL_90_PITCH_315 = 40
enums["MAV_SENSOR_ORIENTATION"][40] = EnumEntry("MAV_SENSOR_ROTATION_ROLL_90_PITCH_315", """Roll: 90, Pitch: 315""")
MAV_SENSOR_ROTATION_CUSTOM = 100
enums["MAV_SENSOR_ORIENTATION"][100] = EnumEntry("MAV_SENSOR_ROTATION_CUSTOM", """Custom orientation""")
MAV_SENSOR_ORIENTATION_ENUM_END = 101
enums["MAV_SENSOR_ORIENTATION"][101] = EnumEntry("MAV_SENSOR_ORIENTATION_ENUM_END", """""")

# MAV_PROTOCOL_CAPABILITY
enums["MAV_PROTOCOL_CAPABILITY"] = Enum()
enums["MAV_PROTOCOL_CAPABILITY"].bitmask = True
MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT = 1
enums["MAV_PROTOCOL_CAPABILITY"][1] = EnumEntry(
    "MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT",
    """Autopilot supports the MISSION_ITEM float message type.
          Note that MISSION_ITEM is deprecated, and autopilots should use MISSION_INT instead.
        """,
)
MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT = 2
enums["MAV_PROTOCOL_CAPABILITY"][2] = EnumEntry("MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT", """Autopilot supports the new param float message type.""")
MAV_PROTOCOL_CAPABILITY_MISSION_INT = 4
enums["MAV_PROTOCOL_CAPABILITY"][4] = EnumEntry(
    "MAV_PROTOCOL_CAPABILITY_MISSION_INT",
    """Autopilot supports MISSION_ITEM_INT scaled integer message type.
          Note that this flag must always be set if missions are supported, because missions must always use MISSION_ITEM_INT (rather than MISSION_ITEM, which is deprecated).
        """,
)
MAV_PROTOCOL_CAPABILITY_COMMAND_INT = 8
enums["MAV_PROTOCOL_CAPABILITY"][8] = EnumEntry("MAV_PROTOCOL_CAPABILITY_COMMAND_INT", """Autopilot supports COMMAND_INT scaled integer message type.""")
MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE = 16
enums["MAV_PROTOCOL_CAPABILITY"][16] = EnumEntry(
    "MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE",
    """Parameter protocol uses byte-wise encoding of parameter values into param_value (float) fields: https://mavlink.io/en/services/parameter.html#parameter-encoding.
          Note that either this flag or MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST should be set if the parameter protocol is supported.
        """,
)
MAV_PROTOCOL_CAPABILITY_FTP = 32
enums["MAV_PROTOCOL_CAPABILITY"][32] = EnumEntry("MAV_PROTOCOL_CAPABILITY_FTP", """Autopilot supports the File Transfer Protocol v1: https://mavlink.io/en/services/ftp.html.""")
MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET = 64
enums["MAV_PROTOCOL_CAPABILITY"][64] = EnumEntry("MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET", """Autopilot supports commanding attitude offboard.""")
MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED = 128
enums["MAV_PROTOCOL_CAPABILITY"][128] = EnumEntry("MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED", """Autopilot supports commanding position and velocity targets in local NED frame.""")
MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT = 256
enums["MAV_PROTOCOL_CAPABILITY"][256] = EnumEntry("MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT", """Autopilot supports commanding position and velocity targets in global scaled integers.""")
MAV_PROTOCOL_CAPABILITY_TERRAIN = 512
enums["MAV_PROTOCOL_CAPABILITY"][512] = EnumEntry("MAV_PROTOCOL_CAPABILITY_TERRAIN", """Autopilot supports terrain protocol / data handling.""")
MAV_PROTOCOL_CAPABILITY_RESERVED3 = 1024
enums["MAV_PROTOCOL_CAPABILITY"][1024] = EnumEntry("MAV_PROTOCOL_CAPABILITY_RESERVED3", """Reserved for future use.""")
MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION = 2048
enums["MAV_PROTOCOL_CAPABILITY"][2048] = EnumEntry("MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION", """Autopilot supports the MAV_CMD_DO_FLIGHTTERMINATION command (flight termination).""")
MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION = 4096
enums["MAV_PROTOCOL_CAPABILITY"][4096] = EnumEntry("MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION", """Autopilot supports onboard compass calibration.""")
MAV_PROTOCOL_CAPABILITY_MAVLINK2 = 8192
enums["MAV_PROTOCOL_CAPABILITY"][8192] = EnumEntry("MAV_PROTOCOL_CAPABILITY_MAVLINK2", """Autopilot supports MAVLink version 2.""")
MAV_PROTOCOL_CAPABILITY_MISSION_FENCE = 16384
enums["MAV_PROTOCOL_CAPABILITY"][16384] = EnumEntry("MAV_PROTOCOL_CAPABILITY_MISSION_FENCE", """Autopilot supports mission fence protocol.""")
MAV_PROTOCOL_CAPABILITY_MISSION_RALLY = 32768
enums["MAV_PROTOCOL_CAPABILITY"][32768] = EnumEntry("MAV_PROTOCOL_CAPABILITY_MISSION_RALLY", """Autopilot supports mission rally point protocol.""")
MAV_PROTOCOL_CAPABILITY_RESERVED2 = 65536
enums["MAV_PROTOCOL_CAPABILITY"][65536] = EnumEntry("MAV_PROTOCOL_CAPABILITY_RESERVED2", """Reserved for future use.""")
MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST = 131072
enums["MAV_PROTOCOL_CAPABILITY"][131072] = EnumEntry(
    "MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST",
    """Parameter protocol uses C-cast of parameter values to set the param_value (float) fields: https://mavlink.io/en/services/parameter.html#parameter-encoding.
          Note that either this flag or MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE should be set if the parameter protocol is supported.
        """,
)
MAV_PROTOCOL_CAPABILITY_COMPONENT_IMPLEMENTS_GIMBAL_MANAGER = 262144
enums["MAV_PROTOCOL_CAPABILITY"][262144] = EnumEntry(
    "MAV_PROTOCOL_CAPABILITY_COMPONENT_IMPLEMENTS_GIMBAL_MANAGER",
    """This component implements/is a gimbal manager. This means the GIMBAL_MANAGER_INFORMATION, and other messages can be requested.
        """,
)
MAV_PROTOCOL_CAPABILITY_COMPONENT_ACCEPTS_GCS_CONTROL = 524288
enums["MAV_PROTOCOL_CAPABILITY"][524288] = EnumEntry("MAV_PROTOCOL_CAPABILITY_COMPONENT_ACCEPTS_GCS_CONTROL", """Component supports locking control to a particular GCS independent of its system (via MAV_CMD_REQUEST_OPERATOR_CONTROL).""")
MAV_PROTOCOL_CAPABILITY_GRIPPER = 1048576
enums["MAV_PROTOCOL_CAPABILITY"][1048576] = EnumEntry("MAV_PROTOCOL_CAPABILITY_GRIPPER", """Autopilot has a connected gripper. MAVLink Grippers would set MAV_TYPE_GRIPPER instead.""")
MAV_PROTOCOL_CAPABILITY_ENUM_END = 1048577
enums["MAV_PROTOCOL_CAPABILITY"][1048577] = EnumEntry("MAV_PROTOCOL_CAPABILITY_ENUM_END", """""")

# MAV_MISSION_TYPE
enums["MAV_MISSION_TYPE"] = Enum()
enums["MAV_MISSION_TYPE"].bitmask = False
MAV_MISSION_TYPE_MISSION = 0
enums["MAV_MISSION_TYPE"][0] = EnumEntry("MAV_MISSION_TYPE_MISSION", """Items are mission commands for main mission.""")
MAV_MISSION_TYPE_FENCE = 1
enums["MAV_MISSION_TYPE"][1] = EnumEntry("MAV_MISSION_TYPE_FENCE", """Specifies GeoFence area(s). Items are MAV_CMD_NAV_FENCE_ GeoFence items.""")
MAV_MISSION_TYPE_RALLY = 2
enums["MAV_MISSION_TYPE"][2] = EnumEntry("MAV_MISSION_TYPE_RALLY", """Specifies the rally points for the vehicle. Rally points are alternative RTL points. Items are MAV_CMD_NAV_RALLY_POINT rally point items.""")
MAV_MISSION_TYPE_ALL = 255
enums["MAV_MISSION_TYPE"][255] = EnumEntry("MAV_MISSION_TYPE_ALL", """Only used in MISSION_CLEAR_ALL to clear all mission types.""")
MAV_MISSION_TYPE_ENUM_END = 256
enums["MAV_MISSION_TYPE"][256] = EnumEntry("MAV_MISSION_TYPE_ENUM_END", """""")

# MAV_ESTIMATOR_TYPE
enums["MAV_ESTIMATOR_TYPE"] = Enum()
enums["MAV_ESTIMATOR_TYPE"].bitmask = False
MAV_ESTIMATOR_TYPE_UNKNOWN = 0
enums["MAV_ESTIMATOR_TYPE"][0] = EnumEntry("MAV_ESTIMATOR_TYPE_UNKNOWN", """Unknown type of the estimator.""")
MAV_ESTIMATOR_TYPE_NAIVE = 1
enums["MAV_ESTIMATOR_TYPE"][1] = EnumEntry("MAV_ESTIMATOR_TYPE_NAIVE", """This is a naive estimator without any real covariance feedback.""")
MAV_ESTIMATOR_TYPE_VISION = 2
enums["MAV_ESTIMATOR_TYPE"][2] = EnumEntry("MAV_ESTIMATOR_TYPE_VISION", """Computer vision based estimate. Might be up to scale.""")
MAV_ESTIMATOR_TYPE_VIO = 3
enums["MAV_ESTIMATOR_TYPE"][3] = EnumEntry("MAV_ESTIMATOR_TYPE_VIO", """Visual-inertial estimate.""")
MAV_ESTIMATOR_TYPE_GPS = 4
enums["MAV_ESTIMATOR_TYPE"][4] = EnumEntry("MAV_ESTIMATOR_TYPE_GPS", """Plain GPS estimate.""")
MAV_ESTIMATOR_TYPE_GPS_INS = 5
enums["MAV_ESTIMATOR_TYPE"][5] = EnumEntry("MAV_ESTIMATOR_TYPE_GPS_INS", """Estimator integrating GPS and inertial sensing.""")
MAV_ESTIMATOR_TYPE_MOCAP = 6
enums["MAV_ESTIMATOR_TYPE"][6] = EnumEntry("MAV_ESTIMATOR_TYPE_MOCAP", """Estimate from external motion capturing system.""")
MAV_ESTIMATOR_TYPE_LIDAR = 7
enums["MAV_ESTIMATOR_TYPE"][7] = EnumEntry("MAV_ESTIMATOR_TYPE_LIDAR", """Estimator based on lidar sensor input.""")
MAV_ESTIMATOR_TYPE_AUTOPILOT = 8
enums["MAV_ESTIMATOR_TYPE"][8] = EnumEntry("MAV_ESTIMATOR_TYPE_AUTOPILOT", """Estimator on autopilot.""")
MAV_ESTIMATOR_TYPE_ENUM_END = 9
enums["MAV_ESTIMATOR_TYPE"][9] = EnumEntry("MAV_ESTIMATOR_TYPE_ENUM_END", """""")

# MAV_BATTERY_TYPE
enums["MAV_BATTERY_TYPE"] = Enum()
enums["MAV_BATTERY_TYPE"].bitmask = False
MAV_BATTERY_TYPE_UNKNOWN = 0
enums["MAV_BATTERY_TYPE"][0] = EnumEntry("MAV_BATTERY_TYPE_UNKNOWN", """Not specified.""")
MAV_BATTERY_TYPE_LIPO = 1
enums["MAV_BATTERY_TYPE"][1] = EnumEntry("MAV_BATTERY_TYPE_LIPO", """Lithium polymer battery""")
MAV_BATTERY_TYPE_LIFE = 2
enums["MAV_BATTERY_TYPE"][2] = EnumEntry("MAV_BATTERY_TYPE_LIFE", """Lithium-iron-phosphate battery""")
MAV_BATTERY_TYPE_LION = 3
enums["MAV_BATTERY_TYPE"][3] = EnumEntry("MAV_BATTERY_TYPE_LION", """Lithium-ION battery""")
MAV_BATTERY_TYPE_NIMH = 4
enums["MAV_BATTERY_TYPE"][4] = EnumEntry("MAV_BATTERY_TYPE_NIMH", """Nickel metal hydride battery""")
MAV_BATTERY_TYPE_ENUM_END = 5
enums["MAV_BATTERY_TYPE"][5] = EnumEntry("MAV_BATTERY_TYPE_ENUM_END", """""")

# MAV_BATTERY_FUNCTION
enums["MAV_BATTERY_FUNCTION"] = Enum()
enums["MAV_BATTERY_FUNCTION"].bitmask = False
MAV_BATTERY_FUNCTION_UNKNOWN = 0
enums["MAV_BATTERY_FUNCTION"][0] = EnumEntry("MAV_BATTERY_FUNCTION_UNKNOWN", """Battery function is unknown""")
MAV_BATTERY_FUNCTION_ALL = 1
enums["MAV_BATTERY_FUNCTION"][1] = EnumEntry("MAV_BATTERY_FUNCTION_ALL", """Battery supports all flight systems""")
MAV_BATTERY_FUNCTION_PROPULSION = 2
enums["MAV_BATTERY_FUNCTION"][2] = EnumEntry("MAV_BATTERY_FUNCTION_PROPULSION", """Battery for the propulsion system""")
MAV_BATTERY_FUNCTION_AVIONICS = 3
enums["MAV_BATTERY_FUNCTION"][3] = EnumEntry("MAV_BATTERY_FUNCTION_AVIONICS", """Avionics battery""")
MAV_BATTERY_TYPE_PAYLOAD = 4
enums["MAV_BATTERY_FUNCTION"][4] = EnumEntry("MAV_BATTERY_TYPE_PAYLOAD", """Payload battery""")
MAV_BATTERY_FUNCTION_ENUM_END = 5
enums["MAV_BATTERY_FUNCTION"][5] = EnumEntry("MAV_BATTERY_FUNCTION_ENUM_END", """""")

# MAV_BATTERY_CHARGE_STATE
enums["MAV_BATTERY_CHARGE_STATE"] = Enum()
enums["MAV_BATTERY_CHARGE_STATE"].bitmask = False
MAV_BATTERY_CHARGE_STATE_UNDEFINED = 0
enums["MAV_BATTERY_CHARGE_STATE"][0] = EnumEntry("MAV_BATTERY_CHARGE_STATE_UNDEFINED", """Low battery state is not provided""")
MAV_BATTERY_CHARGE_STATE_OK = 1
enums["MAV_BATTERY_CHARGE_STATE"][1] = EnumEntry("MAV_BATTERY_CHARGE_STATE_OK", """Battery is not in low state. Normal operation.""")
MAV_BATTERY_CHARGE_STATE_LOW = 2
enums["MAV_BATTERY_CHARGE_STATE"][2] = EnumEntry("MAV_BATTERY_CHARGE_STATE_LOW", """Battery state is low, warn and monitor close.""")
MAV_BATTERY_CHARGE_STATE_CRITICAL = 3
enums["MAV_BATTERY_CHARGE_STATE"][3] = EnumEntry("MAV_BATTERY_CHARGE_STATE_CRITICAL", """Battery state is critical, return or abort immediately.""")
MAV_BATTERY_CHARGE_STATE_EMERGENCY = 4
enums["MAV_BATTERY_CHARGE_STATE"][4] = EnumEntry("MAV_BATTERY_CHARGE_STATE_EMERGENCY", """Battery state is too low for ordinary abort sequence. Perform fastest possible emergency stop to prevent damage.""")
MAV_BATTERY_CHARGE_STATE_FAILED = 5
enums["MAV_BATTERY_CHARGE_STATE"][5] = EnumEntry("MAV_BATTERY_CHARGE_STATE_FAILED", """Battery failed, damage unavoidable. Possible causes (faults) are listed in MAV_BATTERY_FAULT.""")
MAV_BATTERY_CHARGE_STATE_UNHEALTHY = 6
enums["MAV_BATTERY_CHARGE_STATE"][6] = EnumEntry("MAV_BATTERY_CHARGE_STATE_UNHEALTHY", """Battery is diagnosed to be defective or an error occurred, usage is discouraged / prohibited. Possible causes (faults) are listed in MAV_BATTERY_FAULT.""")
MAV_BATTERY_CHARGE_STATE_CHARGING = 7
enums["MAV_BATTERY_CHARGE_STATE"][7] = EnumEntry("MAV_BATTERY_CHARGE_STATE_CHARGING", """Battery is charging.""")
MAV_BATTERY_CHARGE_STATE_ENUM_END = 8
enums["MAV_BATTERY_CHARGE_STATE"][8] = EnumEntry("MAV_BATTERY_CHARGE_STATE_ENUM_END", """""")

# MAV_BATTERY_MODE
enums["MAV_BATTERY_MODE"] = Enum()
enums["MAV_BATTERY_MODE"].bitmask = False
MAV_BATTERY_MODE_UNKNOWN = 0
enums["MAV_BATTERY_MODE"][0] = EnumEntry("MAV_BATTERY_MODE_UNKNOWN", """Battery mode not supported/unknown battery mode/normal operation.""")
MAV_BATTERY_MODE_AUTO_DISCHARGING = 1
enums["MAV_BATTERY_MODE"][1] = EnumEntry("MAV_BATTERY_MODE_AUTO_DISCHARGING", """Battery is auto discharging (towards storage level).""")
MAV_BATTERY_MODE_HOT_SWAP = 2
enums["MAV_BATTERY_MODE"][2] = EnumEntry("MAV_BATTERY_MODE_HOT_SWAP", """Battery in hot-swap mode (current limited to prevent spikes that might damage sensitive electrical circuits).""")
MAV_BATTERY_MODE_ENUM_END = 3
enums["MAV_BATTERY_MODE"][3] = EnumEntry("MAV_BATTERY_MODE_ENUM_END", """""")

# MAV_BATTERY_FAULT
enums["MAV_BATTERY_FAULT"] = Enum()
enums["MAV_BATTERY_FAULT"].bitmask = True
MAV_BATTERY_FAULT_DEEP_DISCHARGE = 1
enums["MAV_BATTERY_FAULT"][1] = EnumEntry("MAV_BATTERY_FAULT_DEEP_DISCHARGE", """Battery has deep discharged.""")
MAV_BATTERY_FAULT_SPIKES = 2
enums["MAV_BATTERY_FAULT"][2] = EnumEntry("MAV_BATTERY_FAULT_SPIKES", """Voltage spikes.""")
MAV_BATTERY_FAULT_CELL_FAIL = 4
enums["MAV_BATTERY_FAULT"][4] = EnumEntry("MAV_BATTERY_FAULT_CELL_FAIL", """One or more cells have failed. Battery should also report MAV_BATTERY_CHARGE_STATE_FAILE (and should not be used).""")
MAV_BATTERY_FAULT_OVER_CURRENT = 8
enums["MAV_BATTERY_FAULT"][8] = EnumEntry("MAV_BATTERY_FAULT_OVER_CURRENT", """Over-current fault.""")
MAV_BATTERY_FAULT_OVER_TEMPERATURE = 16
enums["MAV_BATTERY_FAULT"][16] = EnumEntry("MAV_BATTERY_FAULT_OVER_TEMPERATURE", """Over-temperature fault.""")
MAV_BATTERY_FAULT_UNDER_TEMPERATURE = 32
enums["MAV_BATTERY_FAULT"][32] = EnumEntry("MAV_BATTERY_FAULT_UNDER_TEMPERATURE", """Under-temperature fault.""")
MAV_BATTERY_FAULT_INCOMPATIBLE_VOLTAGE = 64
enums["MAV_BATTERY_FAULT"][64] = EnumEntry("MAV_BATTERY_FAULT_INCOMPATIBLE_VOLTAGE", """Vehicle voltage is not compatible with this battery (batteries on same power rail should have similar voltage).""")
MAV_BATTERY_FAULT_INCOMPATIBLE_FIRMWARE = 128
enums["MAV_BATTERY_FAULT"][128] = EnumEntry("MAV_BATTERY_FAULT_INCOMPATIBLE_FIRMWARE", """Battery firmware is not compatible with current autopilot firmware.""")
BATTERY_FAULT_INCOMPATIBLE_CELLS_CONFIGURATION = 256
enums["MAV_BATTERY_FAULT"][256] = EnumEntry("BATTERY_FAULT_INCOMPATIBLE_CELLS_CONFIGURATION", """Battery is not compatible due to cell configuration (e.g. 5s1p when vehicle requires 6s).""")
MAV_BATTERY_FAULT_ENUM_END = 257
enums["MAV_BATTERY_FAULT"][257] = EnumEntry("MAV_BATTERY_FAULT_ENUM_END", """""")

# MAV_GENERATOR_STATUS_FLAG
enums["MAV_GENERATOR_STATUS_FLAG"] = Enum()
enums["MAV_GENERATOR_STATUS_FLAG"].bitmask = True
MAV_GENERATOR_STATUS_FLAG_OFF = 1
enums["MAV_GENERATOR_STATUS_FLAG"][1] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_OFF", """Generator is off.""")
MAV_GENERATOR_STATUS_FLAG_READY = 2
enums["MAV_GENERATOR_STATUS_FLAG"][2] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_READY", """Generator is ready to start generating power.""")
MAV_GENERATOR_STATUS_FLAG_GENERATING = 4
enums["MAV_GENERATOR_STATUS_FLAG"][4] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_GENERATING", """Generator is generating power.""")
MAV_GENERATOR_STATUS_FLAG_CHARGING = 8
enums["MAV_GENERATOR_STATUS_FLAG"][8] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_CHARGING", """Generator is charging the batteries (generating enough power to charge and provide the load).""")
MAV_GENERATOR_STATUS_FLAG_REDUCED_POWER = 16
enums["MAV_GENERATOR_STATUS_FLAG"][16] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_REDUCED_POWER", """Generator is operating at a reduced maximum power.""")
MAV_GENERATOR_STATUS_FLAG_MAXPOWER = 32
enums["MAV_GENERATOR_STATUS_FLAG"][32] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_MAXPOWER", """Generator is providing the maximum output.""")
MAV_GENERATOR_STATUS_FLAG_OVERTEMP_WARNING = 64
enums["MAV_GENERATOR_STATUS_FLAG"][64] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_OVERTEMP_WARNING", """Generator is near the maximum operating temperature, cooling is insufficient.""")
MAV_GENERATOR_STATUS_FLAG_OVERTEMP_FAULT = 128
enums["MAV_GENERATOR_STATUS_FLAG"][128] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_OVERTEMP_FAULT", """Generator hit the maximum operating temperature and shutdown.""")
MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_OVERTEMP_WARNING = 256
enums["MAV_GENERATOR_STATUS_FLAG"][256] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_OVERTEMP_WARNING", """Power electronics are near the maximum operating temperature, cooling is insufficient.""")
MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_OVERTEMP_FAULT = 512
enums["MAV_GENERATOR_STATUS_FLAG"][512] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_OVERTEMP_FAULT", """Power electronics hit the maximum operating temperature and shutdown.""")
MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_FAULT = 1024
enums["MAV_GENERATOR_STATUS_FLAG"][1024] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_ELECTRONICS_FAULT", """Power electronics experienced a fault and shutdown.""")
MAV_GENERATOR_STATUS_FLAG_POWERSOURCE_FAULT = 2048
enums["MAV_GENERATOR_STATUS_FLAG"][2048] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_POWERSOURCE_FAULT", """The power source supplying the generator failed e.g. mechanical generator stopped, tether is no longer providing power, solar cell is in shade, hydrogen reaction no longer happening.""")
MAV_GENERATOR_STATUS_FLAG_COMMUNICATION_WARNING = 4096
enums["MAV_GENERATOR_STATUS_FLAG"][4096] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_COMMUNICATION_WARNING", """Generator controller having communication problems.""")
MAV_GENERATOR_STATUS_FLAG_COOLING_WARNING = 8192
enums["MAV_GENERATOR_STATUS_FLAG"][8192] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_COOLING_WARNING", """Power electronic or generator cooling system error.""")
MAV_GENERATOR_STATUS_FLAG_POWER_RAIL_FAULT = 16384
enums["MAV_GENERATOR_STATUS_FLAG"][16384] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_POWER_RAIL_FAULT", """Generator controller power rail experienced a fault.""")
MAV_GENERATOR_STATUS_FLAG_OVERCURRENT_FAULT = 32768
enums["MAV_GENERATOR_STATUS_FLAG"][32768] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_OVERCURRENT_FAULT", """Generator controller exceeded the overcurrent threshold and shutdown to prevent damage.""")
MAV_GENERATOR_STATUS_FLAG_BATTERY_OVERCHARGE_CURRENT_FAULT = 65536
enums["MAV_GENERATOR_STATUS_FLAG"][65536] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_BATTERY_OVERCHARGE_CURRENT_FAULT", """Generator controller detected a high current going into the batteries and shutdown to prevent battery damage.""")
MAV_GENERATOR_STATUS_FLAG_OVERVOLTAGE_FAULT = 131072
enums["MAV_GENERATOR_STATUS_FLAG"][131072] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_OVERVOLTAGE_FAULT", """Generator controller exceeded it's overvoltage threshold and shutdown to prevent it exceeding the voltage rating.""")
MAV_GENERATOR_STATUS_FLAG_BATTERY_UNDERVOLT_FAULT = 262144
enums["MAV_GENERATOR_STATUS_FLAG"][262144] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_BATTERY_UNDERVOLT_FAULT", """Batteries are under voltage (generator will not start).""")
MAV_GENERATOR_STATUS_FLAG_START_INHIBITED = 524288
enums["MAV_GENERATOR_STATUS_FLAG"][524288] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_START_INHIBITED", """Generator start is inhibited by e.g. a safety switch.""")
MAV_GENERATOR_STATUS_FLAG_MAINTENANCE_REQUIRED = 1048576
enums["MAV_GENERATOR_STATUS_FLAG"][1048576] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_MAINTENANCE_REQUIRED", """Generator requires maintenance.""")
MAV_GENERATOR_STATUS_FLAG_WARMING_UP = 2097152
enums["MAV_GENERATOR_STATUS_FLAG"][2097152] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_WARMING_UP", """Generator is not ready to generate yet.""")
MAV_GENERATOR_STATUS_FLAG_IDLE = 4194304
enums["MAV_GENERATOR_STATUS_FLAG"][4194304] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_IDLE", """Generator is idle.""")
MAV_GENERATOR_STATUS_FLAG_ENUM_END = 4194305
enums["MAV_GENERATOR_STATUS_FLAG"][4194305] = EnumEntry("MAV_GENERATOR_STATUS_FLAG_ENUM_END", """""")

# MAV_VTOL_STATE
enums["MAV_VTOL_STATE"] = Enum()
enums["MAV_VTOL_STATE"].bitmask = False
MAV_VTOL_STATE_UNDEFINED = 0
enums["MAV_VTOL_STATE"][0] = EnumEntry("MAV_VTOL_STATE_UNDEFINED", """MAV is not configured as VTOL""")
MAV_VTOL_STATE_TRANSITION_TO_FW = 1
enums["MAV_VTOL_STATE"][1] = EnumEntry("MAV_VTOL_STATE_TRANSITION_TO_FW", """VTOL is in transition from multicopter to fixed-wing""")
MAV_VTOL_STATE_TRANSITION_TO_MC = 2
enums["MAV_VTOL_STATE"][2] = EnumEntry("MAV_VTOL_STATE_TRANSITION_TO_MC", """VTOL is in transition from fixed-wing to multicopter""")
MAV_VTOL_STATE_MC = 3
enums["MAV_VTOL_STATE"][3] = EnumEntry("MAV_VTOL_STATE_MC", """VTOL is in multicopter state""")
MAV_VTOL_STATE_FW = 4
enums["MAV_VTOL_STATE"][4] = EnumEntry("MAV_VTOL_STATE_FW", """VTOL is in fixed-wing state""")
MAV_VTOL_STATE_ENUM_END = 5
enums["MAV_VTOL_STATE"][5] = EnumEntry("MAV_VTOL_STATE_ENUM_END", """""")

# MAV_LANDED_STATE
enums["MAV_LANDED_STATE"] = Enum()
enums["MAV_LANDED_STATE"].bitmask = False
MAV_LANDED_STATE_UNDEFINED = 0
enums["MAV_LANDED_STATE"][0] = EnumEntry("MAV_LANDED_STATE_UNDEFINED", """MAV landed state is unknown""")
MAV_LANDED_STATE_ON_GROUND = 1
enums["MAV_LANDED_STATE"][1] = EnumEntry("MAV_LANDED_STATE_ON_GROUND", """MAV is landed (on ground)""")
MAV_LANDED_STATE_IN_AIR = 2
enums["MAV_LANDED_STATE"][2] = EnumEntry("MAV_LANDED_STATE_IN_AIR", """MAV is in air""")
MAV_LANDED_STATE_TAKEOFF = 3
enums["MAV_LANDED_STATE"][3] = EnumEntry("MAV_LANDED_STATE_TAKEOFF", """MAV currently taking off""")
MAV_LANDED_STATE_LANDING = 4
enums["MAV_LANDED_STATE"][4] = EnumEntry("MAV_LANDED_STATE_LANDING", """MAV currently landing""")
MAV_LANDED_STATE_ENUM_END = 5
enums["MAV_LANDED_STATE"][5] = EnumEntry("MAV_LANDED_STATE_ENUM_END", """""")

# ADSB_ALTITUDE_TYPE
enums["ADSB_ALTITUDE_TYPE"] = Enum()
enums["ADSB_ALTITUDE_TYPE"].bitmask = False
ADSB_ALTITUDE_TYPE_PRESSURE_QNH = 0
enums["ADSB_ALTITUDE_TYPE"][0] = EnumEntry("ADSB_ALTITUDE_TYPE_PRESSURE_QNH", """Altitude reported from a Baro source using QNH reference""")
ADSB_ALTITUDE_TYPE_GEOMETRIC = 1
enums["ADSB_ALTITUDE_TYPE"][1] = EnumEntry("ADSB_ALTITUDE_TYPE_GEOMETRIC", """Altitude reported from a GNSS source""")
ADSB_ALTITUDE_TYPE_ENUM_END = 2
enums["ADSB_ALTITUDE_TYPE"][2] = EnumEntry("ADSB_ALTITUDE_TYPE_ENUM_END", """""")

# ADSB_EMITTER_TYPE
enums["ADSB_EMITTER_TYPE"] = Enum()
enums["ADSB_EMITTER_TYPE"].bitmask = False
ADSB_EMITTER_TYPE_NO_INFO = 0
enums["ADSB_EMITTER_TYPE"][0] = EnumEntry("ADSB_EMITTER_TYPE_NO_INFO", """""")
ADSB_EMITTER_TYPE_LIGHT = 1
enums["ADSB_EMITTER_TYPE"][1] = EnumEntry("ADSB_EMITTER_TYPE_LIGHT", """""")
ADSB_EMITTER_TYPE_SMALL = 2
enums["ADSB_EMITTER_TYPE"][2] = EnumEntry("ADSB_EMITTER_TYPE_SMALL", """""")
ADSB_EMITTER_TYPE_LARGE = 3
enums["ADSB_EMITTER_TYPE"][3] = EnumEntry("ADSB_EMITTER_TYPE_LARGE", """""")
ADSB_EMITTER_TYPE_HIGH_VORTEX_LARGE = 4
enums["ADSB_EMITTER_TYPE"][4] = EnumEntry("ADSB_EMITTER_TYPE_HIGH_VORTEX_LARGE", """""")
ADSB_EMITTER_TYPE_HEAVY = 5
enums["ADSB_EMITTER_TYPE"][5] = EnumEntry("ADSB_EMITTER_TYPE_HEAVY", """""")
ADSB_EMITTER_TYPE_HIGHLY_MANUV = 6
enums["ADSB_EMITTER_TYPE"][6] = EnumEntry("ADSB_EMITTER_TYPE_HIGHLY_MANUV", """""")
ADSB_EMITTER_TYPE_ROTOCRAFT = 7
enums["ADSB_EMITTER_TYPE"][7] = EnumEntry("ADSB_EMITTER_TYPE_ROTOCRAFT", """""")
ADSB_EMITTER_TYPE_UNASSIGNED = 8
enums["ADSB_EMITTER_TYPE"][8] = EnumEntry("ADSB_EMITTER_TYPE_UNASSIGNED", """""")
ADSB_EMITTER_TYPE_GLIDER = 9
enums["ADSB_EMITTER_TYPE"][9] = EnumEntry("ADSB_EMITTER_TYPE_GLIDER", """""")
ADSB_EMITTER_TYPE_LIGHTER_AIR = 10
enums["ADSB_EMITTER_TYPE"][10] = EnumEntry("ADSB_EMITTER_TYPE_LIGHTER_AIR", """""")
ADSB_EMITTER_TYPE_PARACHUTE = 11
enums["ADSB_EMITTER_TYPE"][11] = EnumEntry("ADSB_EMITTER_TYPE_PARACHUTE", """""")
ADSB_EMITTER_TYPE_ULTRA_LIGHT = 12
enums["ADSB_EMITTER_TYPE"][12] = EnumEntry("ADSB_EMITTER_TYPE_ULTRA_LIGHT", """""")
ADSB_EMITTER_TYPE_UNASSIGNED2 = 13
enums["ADSB_EMITTER_TYPE"][13] = EnumEntry("ADSB_EMITTER_TYPE_UNASSIGNED2", """""")
ADSB_EMITTER_TYPE_UAV = 14
enums["ADSB_EMITTER_TYPE"][14] = EnumEntry("ADSB_EMITTER_TYPE_UAV", """""")
ADSB_EMITTER_TYPE_SPACE = 15
enums["ADSB_EMITTER_TYPE"][15] = EnumEntry("ADSB_EMITTER_TYPE_SPACE", """""")
ADSB_EMITTER_TYPE_UNASSGINED3 = 16
enums["ADSB_EMITTER_TYPE"][16] = EnumEntry("ADSB_EMITTER_TYPE_UNASSGINED3", """""")
ADSB_EMITTER_TYPE_EMERGENCY_SURFACE = 17
enums["ADSB_EMITTER_TYPE"][17] = EnumEntry("ADSB_EMITTER_TYPE_EMERGENCY_SURFACE", """""")
ADSB_EMITTER_TYPE_SERVICE_SURFACE = 18
enums["ADSB_EMITTER_TYPE"][18] = EnumEntry("ADSB_EMITTER_TYPE_SERVICE_SURFACE", """""")
ADSB_EMITTER_TYPE_POINT_OBSTACLE = 19
enums["ADSB_EMITTER_TYPE"][19] = EnumEntry("ADSB_EMITTER_TYPE_POINT_OBSTACLE", """""")
ADSB_EMITTER_TYPE_ENUM_END = 20
enums["ADSB_EMITTER_TYPE"][20] = EnumEntry("ADSB_EMITTER_TYPE_ENUM_END", """""")

# ADSB_FLAGS
enums["ADSB_FLAGS"] = Enum()
enums["ADSB_FLAGS"].bitmask = True
ADSB_FLAGS_VALID_COORDS = 1
enums["ADSB_FLAGS"][1] = EnumEntry("ADSB_FLAGS_VALID_COORDS", """""")
ADSB_FLAGS_VALID_ALTITUDE = 2
enums["ADSB_FLAGS"][2] = EnumEntry("ADSB_FLAGS_VALID_ALTITUDE", """""")
ADSB_FLAGS_VALID_HEADING = 4
enums["ADSB_FLAGS"][4] = EnumEntry("ADSB_FLAGS_VALID_HEADING", """""")
ADSB_FLAGS_VALID_VELOCITY = 8
enums["ADSB_FLAGS"][8] = EnumEntry("ADSB_FLAGS_VALID_VELOCITY", """""")
ADSB_FLAGS_VALID_CALLSIGN = 16
enums["ADSB_FLAGS"][16] = EnumEntry("ADSB_FLAGS_VALID_CALLSIGN", """""")
ADSB_FLAGS_VALID_SQUAWK = 32
enums["ADSB_FLAGS"][32] = EnumEntry("ADSB_FLAGS_VALID_SQUAWK", """""")
ADSB_FLAGS_SIMULATED = 64
enums["ADSB_FLAGS"][64] = EnumEntry("ADSB_FLAGS_SIMULATED", """""")
ADSB_FLAGS_VERTICAL_VELOCITY_VALID = 128
enums["ADSB_FLAGS"][128] = EnumEntry("ADSB_FLAGS_VERTICAL_VELOCITY_VALID", """""")
ADSB_FLAGS_BARO_VALID = 256
enums["ADSB_FLAGS"][256] = EnumEntry("ADSB_FLAGS_BARO_VALID", """""")
ADSB_FLAGS_SOURCE_UAT = 32768
enums["ADSB_FLAGS"][32768] = EnumEntry("ADSB_FLAGS_SOURCE_UAT", """""")
ADSB_FLAGS_ENUM_END = 32769
enums["ADSB_FLAGS"][32769] = EnumEntry("ADSB_FLAGS_ENUM_END", """""")

# MAV_DO_REPOSITION_FLAGS
enums["MAV_DO_REPOSITION_FLAGS"] = Enum()
enums["MAV_DO_REPOSITION_FLAGS"].bitmask = True
MAV_DO_REPOSITION_FLAGS_CHANGE_MODE = 1
enums["MAV_DO_REPOSITION_FLAGS"][1] = EnumEntry("MAV_DO_REPOSITION_FLAGS_CHANGE_MODE", """The aircraft should immediately transition into guided. This should not be set for follow me applications""")
MAV_DO_REPOSITION_FLAGS_ENUM_END = 2
enums["MAV_DO_REPOSITION_FLAGS"][2] = EnumEntry("MAV_DO_REPOSITION_FLAGS_ENUM_END", """""")

# SPEED_TYPE
enums["SPEED_TYPE"] = Enum()
enums["SPEED_TYPE"].bitmask = False
SPEED_TYPE_AIRSPEED = 0
enums["SPEED_TYPE"][0] = EnumEntry("SPEED_TYPE_AIRSPEED", """Airspeed""")
SPEED_TYPE_GROUNDSPEED = 1
enums["SPEED_TYPE"][1] = EnumEntry("SPEED_TYPE_GROUNDSPEED", """Groundspeed""")
SPEED_TYPE_CLIMB_SPEED = 2
enums["SPEED_TYPE"][2] = EnumEntry("SPEED_TYPE_CLIMB_SPEED", """Climb speed""")
SPEED_TYPE_DESCENT_SPEED = 3
enums["SPEED_TYPE"][3] = EnumEntry("SPEED_TYPE_DESCENT_SPEED", """Descent speed""")
SPEED_TYPE_ENUM_END = 4
enums["SPEED_TYPE"][4] = EnumEntry("SPEED_TYPE_ENUM_END", """""")

# ESTIMATOR_STATUS_FLAGS
enums["ESTIMATOR_STATUS_FLAGS"] = Enum()
enums["ESTIMATOR_STATUS_FLAGS"].bitmask = True
ESTIMATOR_ATTITUDE = 1
enums["ESTIMATOR_STATUS_FLAGS"][1] = EnumEntry("ESTIMATOR_ATTITUDE", """True if the attitude estimate is good""")
ESTIMATOR_VELOCITY_HORIZ = 2
enums["ESTIMATOR_STATUS_FLAGS"][2] = EnumEntry("ESTIMATOR_VELOCITY_HORIZ", """True if the horizontal velocity estimate is good""")
ESTIMATOR_VELOCITY_VERT = 4
enums["ESTIMATOR_STATUS_FLAGS"][4] = EnumEntry("ESTIMATOR_VELOCITY_VERT", """True if the  vertical velocity estimate is good""")
ESTIMATOR_POS_HORIZ_REL = 8
enums["ESTIMATOR_STATUS_FLAGS"][8] = EnumEntry("ESTIMATOR_POS_HORIZ_REL", """True if the horizontal position (relative) estimate is good""")
ESTIMATOR_POS_HORIZ_ABS = 16
enums["ESTIMATOR_STATUS_FLAGS"][16] = EnumEntry("ESTIMATOR_POS_HORIZ_ABS", """True if the horizontal position (absolute) estimate is good""")
ESTIMATOR_POS_VERT_ABS = 32
enums["ESTIMATOR_STATUS_FLAGS"][32] = EnumEntry("ESTIMATOR_POS_VERT_ABS", """True if the vertical position (absolute) estimate is good""")
ESTIMATOR_POS_VERT_AGL = 64
enums["ESTIMATOR_STATUS_FLAGS"][64] = EnumEntry("ESTIMATOR_POS_VERT_AGL", """True if the vertical position (above ground) estimate is good""")
ESTIMATOR_CONST_POS_MODE = 128
enums["ESTIMATOR_STATUS_FLAGS"][128] = EnumEntry("ESTIMATOR_CONST_POS_MODE", """True if the EKF is in a constant position mode and is not using external measurements (eg GPS or optical flow)""")
ESTIMATOR_PRED_POS_HORIZ_REL = 256
enums["ESTIMATOR_STATUS_FLAGS"][256] = EnumEntry("ESTIMATOR_PRED_POS_HORIZ_REL", """True if the EKF has sufficient data to enter a mode that will provide a (relative) position estimate""")
ESTIMATOR_PRED_POS_HORIZ_ABS = 512
enums["ESTIMATOR_STATUS_FLAGS"][512] = EnumEntry("ESTIMATOR_PRED_POS_HORIZ_ABS", """True if the EKF has sufficient data to enter a mode that will provide a (absolute) position estimate""")
ESTIMATOR_GPS_GLITCH = 1024
enums["ESTIMATOR_STATUS_FLAGS"][1024] = EnumEntry("ESTIMATOR_GPS_GLITCH", """True if the EKF has detected a GPS glitch""")
ESTIMATOR_ACCEL_ERROR = 2048
enums["ESTIMATOR_STATUS_FLAGS"][2048] = EnumEntry("ESTIMATOR_ACCEL_ERROR", """True if the EKF has detected bad accelerometer data""")
ESTIMATOR_STATUS_FLAGS_ENUM_END = 2049
enums["ESTIMATOR_STATUS_FLAGS"][2049] = EnumEntry("ESTIMATOR_STATUS_FLAGS_ENUM_END", """""")

# MOTOR_TEST_ORDER
enums["MOTOR_TEST_ORDER"] = Enum()
enums["MOTOR_TEST_ORDER"].bitmask = False
MOTOR_TEST_ORDER_DEFAULT = 0
enums["MOTOR_TEST_ORDER"][0] = EnumEntry("MOTOR_TEST_ORDER_DEFAULT", """Default autopilot motor test method.""")
MOTOR_TEST_ORDER_SEQUENCE = 1
enums["MOTOR_TEST_ORDER"][1] = EnumEntry("MOTOR_TEST_ORDER_SEQUENCE", """Motor numbers are specified as their index in a predefined vehicle-specific sequence.""")
MOTOR_TEST_ORDER_BOARD = 2
enums["MOTOR_TEST_ORDER"][2] = EnumEntry("MOTOR_TEST_ORDER_BOARD", """Motor numbers are specified as the output as labeled on the board.""")
MOTOR_TEST_ORDER_ENUM_END = 3
enums["MOTOR_TEST_ORDER"][3] = EnumEntry("MOTOR_TEST_ORDER_ENUM_END", """""")

# MOTOR_TEST_THROTTLE_TYPE
enums["MOTOR_TEST_THROTTLE_TYPE"] = Enum()
enums["MOTOR_TEST_THROTTLE_TYPE"].bitmask = False
MOTOR_TEST_THROTTLE_PERCENT = 0
enums["MOTOR_TEST_THROTTLE_TYPE"][0] = EnumEntry("MOTOR_TEST_THROTTLE_PERCENT", """Throttle as a percentage (0 ~ 100)""")
MOTOR_TEST_THROTTLE_PWM = 1
enums["MOTOR_TEST_THROTTLE_TYPE"][1] = EnumEntry("MOTOR_TEST_THROTTLE_PWM", """Throttle as an absolute PWM value (normally in range of 1000~2000).""")
MOTOR_TEST_THROTTLE_PILOT = 2
enums["MOTOR_TEST_THROTTLE_TYPE"][2] = EnumEntry("MOTOR_TEST_THROTTLE_PILOT", """Throttle pass-through from pilot's transmitter.""")
MOTOR_TEST_COMPASS_CAL = 3
enums["MOTOR_TEST_THROTTLE_TYPE"][3] = EnumEntry("MOTOR_TEST_COMPASS_CAL", """Per-motor compass calibration test.""")
MOTOR_TEST_THROTTLE_TYPE_ENUM_END = 4
enums["MOTOR_TEST_THROTTLE_TYPE"][4] = EnumEntry("MOTOR_TEST_THROTTLE_TYPE_ENUM_END", """""")

# GPS_INPUT_IGNORE_FLAGS
enums["GPS_INPUT_IGNORE_FLAGS"] = Enum()
enums["GPS_INPUT_IGNORE_FLAGS"].bitmask = True
GPS_INPUT_IGNORE_FLAG_ALT = 1
enums["GPS_INPUT_IGNORE_FLAGS"][1] = EnumEntry("GPS_INPUT_IGNORE_FLAG_ALT", """ignore altitude field""")
GPS_INPUT_IGNORE_FLAG_HDOP = 2
enums["GPS_INPUT_IGNORE_FLAGS"][2] = EnumEntry("GPS_INPUT_IGNORE_FLAG_HDOP", """ignore hdop field""")
GPS_INPUT_IGNORE_FLAG_VDOP = 4
enums["GPS_INPUT_IGNORE_FLAGS"][4] = EnumEntry("GPS_INPUT_IGNORE_FLAG_VDOP", """ignore vdop field""")
GPS_INPUT_IGNORE_FLAG_VEL_HORIZ = 8
enums["GPS_INPUT_IGNORE_FLAGS"][8] = EnumEntry("GPS_INPUT_IGNORE_FLAG_VEL_HORIZ", """ignore horizontal velocity field (vn and ve)""")
GPS_INPUT_IGNORE_FLAG_VEL_VERT = 16
enums["GPS_INPUT_IGNORE_FLAGS"][16] = EnumEntry("GPS_INPUT_IGNORE_FLAG_VEL_VERT", """ignore vertical velocity field (vd)""")
GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY = 32
enums["GPS_INPUT_IGNORE_FLAGS"][32] = EnumEntry("GPS_INPUT_IGNORE_FLAG_SPEED_ACCURACY", """ignore speed accuracy field""")
GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY = 64
enums["GPS_INPUT_IGNORE_FLAGS"][64] = EnumEntry("GPS_INPUT_IGNORE_FLAG_HORIZONTAL_ACCURACY", """ignore horizontal accuracy field""")
GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY = 128
enums["GPS_INPUT_IGNORE_FLAGS"][128] = EnumEntry("GPS_INPUT_IGNORE_FLAG_VERTICAL_ACCURACY", """ignore vertical accuracy field""")
GPS_INPUT_IGNORE_FLAGS_ENUM_END = 129
enums["GPS_INPUT_IGNORE_FLAGS"][129] = EnumEntry("GPS_INPUT_IGNORE_FLAGS_ENUM_END", """""")

# MAV_COLLISION_ACTION
enums["MAV_COLLISION_ACTION"] = Enum()
enums["MAV_COLLISION_ACTION"].bitmask = False
MAV_COLLISION_ACTION_NONE = 0
enums["MAV_COLLISION_ACTION"][0] = EnumEntry("MAV_COLLISION_ACTION_NONE", """Ignore any potential collisions""")
MAV_COLLISION_ACTION_REPORT = 1
enums["MAV_COLLISION_ACTION"][1] = EnumEntry("MAV_COLLISION_ACTION_REPORT", """Report potential collision""")
MAV_COLLISION_ACTION_ASCEND_OR_DESCEND = 2
enums["MAV_COLLISION_ACTION"][2] = EnumEntry("MAV_COLLISION_ACTION_ASCEND_OR_DESCEND", """Ascend or Descend to avoid threat""")
MAV_COLLISION_ACTION_MOVE_HORIZONTALLY = 3
enums["MAV_COLLISION_ACTION"][3] = EnumEntry("MAV_COLLISION_ACTION_MOVE_HORIZONTALLY", """Move horizontally to avoid threat""")
MAV_COLLISION_ACTION_MOVE_PERPENDICULAR = 4
enums["MAV_COLLISION_ACTION"][4] = EnumEntry("MAV_COLLISION_ACTION_MOVE_PERPENDICULAR", """Aircraft to move perpendicular to the collision's velocity vector""")
MAV_COLLISION_ACTION_RTL = 5
enums["MAV_COLLISION_ACTION"][5] = EnumEntry("MAV_COLLISION_ACTION_RTL", """Aircraft to fly directly back to its launch point""")
MAV_COLLISION_ACTION_HOVER = 6
enums["MAV_COLLISION_ACTION"][6] = EnumEntry("MAV_COLLISION_ACTION_HOVER", """Aircraft to stop in place""")
MAV_COLLISION_ACTION_ENUM_END = 7
enums["MAV_COLLISION_ACTION"][7] = EnumEntry("MAV_COLLISION_ACTION_ENUM_END", """""")

# MAV_COLLISION_THREAT_LEVEL
enums["MAV_COLLISION_THREAT_LEVEL"] = Enum()
enums["MAV_COLLISION_THREAT_LEVEL"].bitmask = False
MAV_COLLISION_THREAT_LEVEL_NONE = 0
enums["MAV_COLLISION_THREAT_LEVEL"][0] = EnumEntry("MAV_COLLISION_THREAT_LEVEL_NONE", """Not a threat""")
MAV_COLLISION_THREAT_LEVEL_LOW = 1
enums["MAV_COLLISION_THREAT_LEVEL"][1] = EnumEntry("MAV_COLLISION_THREAT_LEVEL_LOW", """Craft is mildly concerned about this threat""")
MAV_COLLISION_THREAT_LEVEL_HIGH = 2
enums["MAV_COLLISION_THREAT_LEVEL"][2] = EnumEntry("MAV_COLLISION_THREAT_LEVEL_HIGH", """Craft is panicking, and may take actions to avoid threat""")
MAV_COLLISION_THREAT_LEVEL_ENUM_END = 3
enums["MAV_COLLISION_THREAT_LEVEL"][3] = EnumEntry("MAV_COLLISION_THREAT_LEVEL_ENUM_END", """""")

# MAV_COLLISION_SRC
enums["MAV_COLLISION_SRC"] = Enum()
enums["MAV_COLLISION_SRC"].bitmask = False
MAV_COLLISION_SRC_ADSB = 0
enums["MAV_COLLISION_SRC"][0] = EnumEntry("MAV_COLLISION_SRC_ADSB", """ID field references ADSB_VEHICLE packets""")
MAV_COLLISION_SRC_MAVLINK_GPS_GLOBAL_INT = 1
enums["MAV_COLLISION_SRC"][1] = EnumEntry("MAV_COLLISION_SRC_MAVLINK_GPS_GLOBAL_INT", """ID field references MAVLink SRC ID""")
MAV_COLLISION_SRC_ENUM_END = 2
enums["MAV_COLLISION_SRC"][2] = EnumEntry("MAV_COLLISION_SRC_ENUM_END", """""")

# GPS_FIX_TYPE
enums["GPS_FIX_TYPE"] = Enum()
enums["GPS_FIX_TYPE"].bitmask = False
GPS_FIX_TYPE_NO_GPS = 0
enums["GPS_FIX_TYPE"][0] = EnumEntry("GPS_FIX_TYPE_NO_GPS", """No GPS connected""")
GPS_FIX_TYPE_NO_FIX = 1
enums["GPS_FIX_TYPE"][1] = EnumEntry("GPS_FIX_TYPE_NO_FIX", """No position information, GPS is connected""")
GPS_FIX_TYPE_2D_FIX = 2
enums["GPS_FIX_TYPE"][2] = EnumEntry("GPS_FIX_TYPE_2D_FIX", """2D position""")
GPS_FIX_TYPE_3D_FIX = 3
enums["GPS_FIX_TYPE"][3] = EnumEntry("GPS_FIX_TYPE_3D_FIX", """3D position""")
GPS_FIX_TYPE_DGPS = 4
enums["GPS_FIX_TYPE"][4] = EnumEntry("GPS_FIX_TYPE_DGPS", """DGPS/SBAS aided 3D position""")
GPS_FIX_TYPE_RTK_FLOAT = 5
enums["GPS_FIX_TYPE"][5] = EnumEntry("GPS_FIX_TYPE_RTK_FLOAT", """RTK float, 3D position""")
GPS_FIX_TYPE_RTK_FIXED = 6
enums["GPS_FIX_TYPE"][6] = EnumEntry("GPS_FIX_TYPE_RTK_FIXED", """RTK Fixed, 3D position""")
GPS_FIX_TYPE_STATIC = 7
enums["GPS_FIX_TYPE"][7] = EnumEntry("GPS_FIX_TYPE_STATIC", """Static fixed, typically used for base stations""")
GPS_FIX_TYPE_PPP = 8
enums["GPS_FIX_TYPE"][8] = EnumEntry("GPS_FIX_TYPE_PPP", """PPP, 3D position.""")
GPS_FIX_TYPE_ENUM_END = 9
enums["GPS_FIX_TYPE"][9] = EnumEntry("GPS_FIX_TYPE_ENUM_END", """""")

# RTK_BASELINE_COORDINATE_SYSTEM
enums["RTK_BASELINE_COORDINATE_SYSTEM"] = Enum()
enums["RTK_BASELINE_COORDINATE_SYSTEM"].bitmask = False
RTK_BASELINE_COORDINATE_SYSTEM_ECEF = 0
enums["RTK_BASELINE_COORDINATE_SYSTEM"][0] = EnumEntry("RTK_BASELINE_COORDINATE_SYSTEM_ECEF", """Earth-centered, Earth-fixed""")
RTK_BASELINE_COORDINATE_SYSTEM_NED = 1
enums["RTK_BASELINE_COORDINATE_SYSTEM"][1] = EnumEntry("RTK_BASELINE_COORDINATE_SYSTEM_NED", """RTK basestation centered, north, east, down""")
RTK_BASELINE_COORDINATE_SYSTEM_ENUM_END = 2
enums["RTK_BASELINE_COORDINATE_SYSTEM"][2] = EnumEntry("RTK_BASELINE_COORDINATE_SYSTEM_ENUM_END", """""")

# LANDING_TARGET_TYPE
enums["LANDING_TARGET_TYPE"] = Enum()
enums["LANDING_TARGET_TYPE"].bitmask = False
LANDING_TARGET_TYPE_LIGHT_BEACON = 0
enums["LANDING_TARGET_TYPE"][0] = EnumEntry("LANDING_TARGET_TYPE_LIGHT_BEACON", """Landing target signaled by light beacon (ex: IR-LOCK)""")
LANDING_TARGET_TYPE_RADIO_BEACON = 1
enums["LANDING_TARGET_TYPE"][1] = EnumEntry("LANDING_TARGET_TYPE_RADIO_BEACON", """Landing target signaled by radio beacon (ex: ILS, NDB)""")
LANDING_TARGET_TYPE_VISION_FIDUCIAL = 2
enums["LANDING_TARGET_TYPE"][2] = EnumEntry("LANDING_TARGET_TYPE_VISION_FIDUCIAL", """Landing target represented by a fiducial marker (ex: ARTag)""")
LANDING_TARGET_TYPE_VISION_OTHER = 3
enums["LANDING_TARGET_TYPE"][3] = EnumEntry("LANDING_TARGET_TYPE_VISION_OTHER", """Landing target represented by a pre-defined visual shape/feature (ex: X-marker, H-marker, square)""")
LANDING_TARGET_TYPE_ENUM_END = 4
enums["LANDING_TARGET_TYPE"][4] = EnumEntry("LANDING_TARGET_TYPE_ENUM_END", """""")

# VTOL_TRANSITION_HEADING
enums["VTOL_TRANSITION_HEADING"] = Enum()
enums["VTOL_TRANSITION_HEADING"].bitmask = False
VTOL_TRANSITION_HEADING_VEHICLE_DEFAULT = 0
enums["VTOL_TRANSITION_HEADING"][0] = EnumEntry("VTOL_TRANSITION_HEADING_VEHICLE_DEFAULT", """Respect the heading configuration of the vehicle.""")
VTOL_TRANSITION_HEADING_NEXT_WAYPOINT = 1
enums["VTOL_TRANSITION_HEADING"][1] = EnumEntry("VTOL_TRANSITION_HEADING_NEXT_WAYPOINT", """Use the heading pointing towards the next waypoint.""")
VTOL_TRANSITION_HEADING_TAKEOFF = 2
enums["VTOL_TRANSITION_HEADING"][2] = EnumEntry("VTOL_TRANSITION_HEADING_TAKEOFF", """Use the heading on takeoff (while sitting on the ground).""")
VTOL_TRANSITION_HEADING_SPECIFIED = 3
enums["VTOL_TRANSITION_HEADING"][3] = EnumEntry("VTOL_TRANSITION_HEADING_SPECIFIED", """Use the specified heading in parameter 4.""")
VTOL_TRANSITION_HEADING_ANY = 4
enums["VTOL_TRANSITION_HEADING"][4] = EnumEntry("VTOL_TRANSITION_HEADING_ANY", """Use the current heading when reaching takeoff altitude (potentially facing the wind when weather-vaning is active).""")
VTOL_TRANSITION_HEADING_ENUM_END = 5
enums["VTOL_TRANSITION_HEADING"][5] = EnumEntry("VTOL_TRANSITION_HEADING_ENUM_END", """""")

# CAMERA_CAP_FLAGS
enums["CAMERA_CAP_FLAGS"] = Enum()
enums["CAMERA_CAP_FLAGS"].bitmask = True
CAMERA_CAP_FLAGS_CAPTURE_VIDEO = 1
enums["CAMERA_CAP_FLAGS"][1] = EnumEntry("CAMERA_CAP_FLAGS_CAPTURE_VIDEO", """Camera is able to record video""")
CAMERA_CAP_FLAGS_CAPTURE_IMAGE = 2
enums["CAMERA_CAP_FLAGS"][2] = EnumEntry("CAMERA_CAP_FLAGS_CAPTURE_IMAGE", """Camera is able to capture images""")
CAMERA_CAP_FLAGS_HAS_MODES = 4
enums["CAMERA_CAP_FLAGS"][4] = EnumEntry("CAMERA_CAP_FLAGS_HAS_MODES", """Camera has separate Video and Image/Photo modes (MAV_CMD_SET_CAMERA_MODE)""")
CAMERA_CAP_FLAGS_CAN_CAPTURE_IMAGE_IN_VIDEO_MODE = 8
enums["CAMERA_CAP_FLAGS"][8] = EnumEntry("CAMERA_CAP_FLAGS_CAN_CAPTURE_IMAGE_IN_VIDEO_MODE", """Camera can capture images while in video mode""")
CAMERA_CAP_FLAGS_CAN_CAPTURE_VIDEO_IN_IMAGE_MODE = 16
enums["CAMERA_CAP_FLAGS"][16] = EnumEntry("CAMERA_CAP_FLAGS_CAN_CAPTURE_VIDEO_IN_IMAGE_MODE", """Camera can capture videos while in Photo/Image mode""")
CAMERA_CAP_FLAGS_HAS_IMAGE_SURVEY_MODE = 32
enums["CAMERA_CAP_FLAGS"][32] = EnumEntry("CAMERA_CAP_FLAGS_HAS_IMAGE_SURVEY_MODE", """Camera has image survey mode (MAV_CMD_SET_CAMERA_MODE)""")
CAMERA_CAP_FLAGS_HAS_BASIC_ZOOM = 64
enums["CAMERA_CAP_FLAGS"][64] = EnumEntry("CAMERA_CAP_FLAGS_HAS_BASIC_ZOOM", """Camera has basic zoom control (MAV_CMD_SET_CAMERA_ZOOM)""")
CAMERA_CAP_FLAGS_HAS_BASIC_FOCUS = 128
enums["CAMERA_CAP_FLAGS"][128] = EnumEntry("CAMERA_CAP_FLAGS_HAS_BASIC_FOCUS", """Camera has basic focus control (MAV_CMD_SET_CAMERA_FOCUS)""")
CAMERA_CAP_FLAGS_HAS_VIDEO_STREAM = 256
enums["CAMERA_CAP_FLAGS"][256] = EnumEntry("CAMERA_CAP_FLAGS_HAS_VIDEO_STREAM", """Camera has video streaming capabilities (request VIDEO_STREAM_INFORMATION with MAV_CMD_REQUEST_MESSAGE for video streaming info)""")
CAMERA_CAP_FLAGS_HAS_TRACKING_POINT = 512
enums["CAMERA_CAP_FLAGS"][512] = EnumEntry("CAMERA_CAP_FLAGS_HAS_TRACKING_POINT", """Camera supports tracking of a point on the camera view.""")
CAMERA_CAP_FLAGS_HAS_TRACKING_RECTANGLE = 1024
enums["CAMERA_CAP_FLAGS"][1024] = EnumEntry("CAMERA_CAP_FLAGS_HAS_TRACKING_RECTANGLE", """Camera supports tracking of a selection rectangle on the camera view.""")
CAMERA_CAP_FLAGS_HAS_TRACKING_GEO_STATUS = 2048
enums["CAMERA_CAP_FLAGS"][2048] = EnumEntry("CAMERA_CAP_FLAGS_HAS_TRACKING_GEO_STATUS", """Camera supports tracking geo status (CAMERA_TRACKING_GEO_STATUS).""")
CAMERA_CAP_FLAGS_HAS_THERMAL_RANGE = 4096
enums["CAMERA_CAP_FLAGS"][4096] = EnumEntry("CAMERA_CAP_FLAGS_HAS_THERMAL_RANGE", """Camera supports absolute thermal range (request CAMERA_THERMAL_RANGE with MAV_CMD_REQUEST_MESSAGE).""")
CAMERA_CAP_FLAGS_ENUM_END = 4097
enums["CAMERA_CAP_FLAGS"][4097] = EnumEntry("CAMERA_CAP_FLAGS_ENUM_END", """""")

# VIDEO_STREAM_STATUS_FLAGS
enums["VIDEO_STREAM_STATUS_FLAGS"] = Enum()
enums["VIDEO_STREAM_STATUS_FLAGS"].bitmask = True
VIDEO_STREAM_STATUS_FLAGS_RUNNING = 1
enums["VIDEO_STREAM_STATUS_FLAGS"][1] = EnumEntry("VIDEO_STREAM_STATUS_FLAGS_RUNNING", """Stream is active (running)""")
VIDEO_STREAM_STATUS_FLAGS_THERMAL = 2
enums["VIDEO_STREAM_STATUS_FLAGS"][2] = EnumEntry("VIDEO_STREAM_STATUS_FLAGS_THERMAL", """Stream is thermal imaging""")
VIDEO_STREAM_STATUS_FLAGS_THERMAL_RANGE_ENABLED = 4
enums["VIDEO_STREAM_STATUS_FLAGS"][4] = EnumEntry("VIDEO_STREAM_STATUS_FLAGS_THERMAL_RANGE_ENABLED", """Stream can report absolute thermal range (see CAMERA_THERMAL_RANGE).""")
VIDEO_STREAM_STATUS_FLAGS_ENUM_END = 5
enums["VIDEO_STREAM_STATUS_FLAGS"][5] = EnumEntry("VIDEO_STREAM_STATUS_FLAGS_ENUM_END", """""")

# VIDEO_STREAM_TYPE
enums["VIDEO_STREAM_TYPE"] = Enum()
enums["VIDEO_STREAM_TYPE"].bitmask = False
VIDEO_STREAM_TYPE_RTSP = 0
enums["VIDEO_STREAM_TYPE"][0] = EnumEntry("VIDEO_STREAM_TYPE_RTSP", """Stream is RTSP""")
VIDEO_STREAM_TYPE_RTPUDP = 1
enums["VIDEO_STREAM_TYPE"][1] = EnumEntry("VIDEO_STREAM_TYPE_RTPUDP", """Stream is RTP UDP (URI gives the port number)""")
VIDEO_STREAM_TYPE_TCP_MPEG = 2
enums["VIDEO_STREAM_TYPE"][2] = EnumEntry("VIDEO_STREAM_TYPE_TCP_MPEG", """Stream is MPEG on TCP""")
VIDEO_STREAM_TYPE_MPEG_TS = 3
enums["VIDEO_STREAM_TYPE"][3] = EnumEntry("VIDEO_STREAM_TYPE_MPEG_TS", """Stream is MPEG TS (URI gives the port number)""")
VIDEO_STREAM_TYPE_ENUM_END = 4
enums["VIDEO_STREAM_TYPE"][4] = EnumEntry("VIDEO_STREAM_TYPE_ENUM_END", """""")

# VIDEO_STREAM_ENCODING
enums["VIDEO_STREAM_ENCODING"] = Enum()
enums["VIDEO_STREAM_ENCODING"].bitmask = False
VIDEO_STREAM_ENCODING_UNKNOWN = 0
enums["VIDEO_STREAM_ENCODING"][0] = EnumEntry("VIDEO_STREAM_ENCODING_UNKNOWN", """Stream encoding is unknown""")
VIDEO_STREAM_ENCODING_H264 = 1
enums["VIDEO_STREAM_ENCODING"][1] = EnumEntry("VIDEO_STREAM_ENCODING_H264", """Stream encoding is H.264""")
VIDEO_STREAM_ENCODING_H265 = 2
enums["VIDEO_STREAM_ENCODING"][2] = EnumEntry("VIDEO_STREAM_ENCODING_H265", """Stream encoding is H.265""")
VIDEO_STREAM_ENCODING_ENUM_END = 3
enums["VIDEO_STREAM_ENCODING"][3] = EnumEntry("VIDEO_STREAM_ENCODING_ENUM_END", """""")

# CAMERA_TRACKING_STATUS_FLAGS
enums["CAMERA_TRACKING_STATUS_FLAGS"] = Enum()
enums["CAMERA_TRACKING_STATUS_FLAGS"].bitmask = False
CAMERA_TRACKING_STATUS_FLAGS_IDLE = 0
enums["CAMERA_TRACKING_STATUS_FLAGS"][0] = EnumEntry("CAMERA_TRACKING_STATUS_FLAGS_IDLE", """Camera is not tracking""")
CAMERA_TRACKING_STATUS_FLAGS_ACTIVE = 1
enums["CAMERA_TRACKING_STATUS_FLAGS"][1] = EnumEntry("CAMERA_TRACKING_STATUS_FLAGS_ACTIVE", """Camera is tracking""")
CAMERA_TRACKING_STATUS_FLAGS_ERROR = 2
enums["CAMERA_TRACKING_STATUS_FLAGS"][2] = EnumEntry("CAMERA_TRACKING_STATUS_FLAGS_ERROR", """Camera tracking in error state""")
CAMERA_TRACKING_STATUS_FLAGS_ENUM_END = 3
enums["CAMERA_TRACKING_STATUS_FLAGS"][3] = EnumEntry("CAMERA_TRACKING_STATUS_FLAGS_ENUM_END", """""")

# CAMERA_TRACKING_MODE
enums["CAMERA_TRACKING_MODE"] = Enum()
enums["CAMERA_TRACKING_MODE"].bitmask = False
CAMERA_TRACKING_MODE_NONE = 0
enums["CAMERA_TRACKING_MODE"][0] = EnumEntry("CAMERA_TRACKING_MODE_NONE", """Not tracking""")
CAMERA_TRACKING_MODE_POINT = 1
enums["CAMERA_TRACKING_MODE"][1] = EnumEntry("CAMERA_TRACKING_MODE_POINT", """Target is a point""")
CAMERA_TRACKING_MODE_RECTANGLE = 2
enums["CAMERA_TRACKING_MODE"][2] = EnumEntry("CAMERA_TRACKING_MODE_RECTANGLE", """Target is a rectangle""")
CAMERA_TRACKING_MODE_ENUM_END = 3
enums["CAMERA_TRACKING_MODE"][3] = EnumEntry("CAMERA_TRACKING_MODE_ENUM_END", """""")

# CAMERA_TRACKING_TARGET_DATA
enums["CAMERA_TRACKING_TARGET_DATA"] = Enum()
enums["CAMERA_TRACKING_TARGET_DATA"].bitmask = True
CAMERA_TRACKING_TARGET_DATA_EMBEDDED = 1
enums["CAMERA_TRACKING_TARGET_DATA"][1] = EnumEntry("CAMERA_TRACKING_TARGET_DATA_EMBEDDED", """Target data embedded in image data (proprietary)""")
CAMERA_TRACKING_TARGET_DATA_RENDERED = 2
enums["CAMERA_TRACKING_TARGET_DATA"][2] = EnumEntry("CAMERA_TRACKING_TARGET_DATA_RENDERED", """Target data rendered in image""")
CAMERA_TRACKING_TARGET_DATA_IN_STATUS = 4
enums["CAMERA_TRACKING_TARGET_DATA"][4] = EnumEntry("CAMERA_TRACKING_TARGET_DATA_IN_STATUS", """Target data within status message (Point or Rectangle)""")
CAMERA_TRACKING_TARGET_DATA_ENUM_END = 5
enums["CAMERA_TRACKING_TARGET_DATA"][5] = EnumEntry("CAMERA_TRACKING_TARGET_DATA_ENUM_END", """""")

# CAMERA_ZOOM_TYPE
enums["CAMERA_ZOOM_TYPE"] = Enum()
enums["CAMERA_ZOOM_TYPE"].bitmask = False
ZOOM_TYPE_STEP = 0
enums["CAMERA_ZOOM_TYPE"][0] = EnumEntry("ZOOM_TYPE_STEP", """Zoom one step increment (-1 for wide, 1 for tele)""")
ZOOM_TYPE_CONTINUOUS = 1
enums["CAMERA_ZOOM_TYPE"][1] = EnumEntry("ZOOM_TYPE_CONTINUOUS", """Continuous zoom up/down until stopped (-1 for wide, 1 for tele, 0 to stop zooming)""")
ZOOM_TYPE_RANGE = 2
enums["CAMERA_ZOOM_TYPE"][2] = EnumEntry("ZOOM_TYPE_RANGE", """Zoom value as proportion of full camera range (a percentage value between 0.0 and 100.0)""")
ZOOM_TYPE_FOCAL_LENGTH = 3
enums["CAMERA_ZOOM_TYPE"][3] = EnumEntry("ZOOM_TYPE_FOCAL_LENGTH", """Zoom value/variable focal length in millimetres. Note that there is no message to get the valid zoom range of the camera, so this can type can only be used for cameras where the zoom range is known (implying that this cannot reliably be used in a GCS for an arbitrary camera)""")
CAMERA_ZOOM_TYPE_ENUM_END = 4
enums["CAMERA_ZOOM_TYPE"][4] = EnumEntry("CAMERA_ZOOM_TYPE_ENUM_END", """""")

# SET_FOCUS_TYPE
enums["SET_FOCUS_TYPE"] = Enum()
enums["SET_FOCUS_TYPE"].bitmask = False
FOCUS_TYPE_STEP = 0
enums["SET_FOCUS_TYPE"][0] = EnumEntry("FOCUS_TYPE_STEP", """Focus one step increment (-1 for focusing in, 1 for focusing out towards infinity).""")
FOCUS_TYPE_CONTINUOUS = 1
enums["SET_FOCUS_TYPE"][1] = EnumEntry("FOCUS_TYPE_CONTINUOUS", """Continuous focus up/down until stopped (-1 for focusing in, 1 for focusing out towards infinity, 0 to stop focusing)""")
FOCUS_TYPE_RANGE = 2
enums["SET_FOCUS_TYPE"][2] = EnumEntry("FOCUS_TYPE_RANGE", """Focus value as proportion of full camera focus range (a value between 0.0 and 100.0)""")
FOCUS_TYPE_METERS = 3
enums["SET_FOCUS_TYPE"][3] = EnumEntry("FOCUS_TYPE_METERS", """Focus value in metres. Note that there is no message to get the valid focus range of the camera, so this can type can only be used for cameras where the range is known (implying that this cannot reliably be used in a GCS for an arbitrary camera).""")
FOCUS_TYPE_AUTO = 4
enums["SET_FOCUS_TYPE"][4] = EnumEntry("FOCUS_TYPE_AUTO", """Focus automatically.""")
FOCUS_TYPE_AUTO_SINGLE = 5
enums["SET_FOCUS_TYPE"][5] = EnumEntry("FOCUS_TYPE_AUTO_SINGLE", """Single auto focus. Mainly used for still pictures. Usually abbreviated as AF-S.""")
FOCUS_TYPE_AUTO_CONTINUOUS = 6
enums["SET_FOCUS_TYPE"][6] = EnumEntry("FOCUS_TYPE_AUTO_CONTINUOUS", """Continuous auto focus. Mainly used for dynamic scenes. Abbreviated as AF-C.""")
SET_FOCUS_TYPE_ENUM_END = 7
enums["SET_FOCUS_TYPE"][7] = EnumEntry("SET_FOCUS_TYPE_ENUM_END", """""")

# CAMERA_SOURCE
enums["CAMERA_SOURCE"] = Enum()
enums["CAMERA_SOURCE"].bitmask = False
CAMERA_SOURCE_DEFAULT = 0
enums["CAMERA_SOURCE"][0] = EnumEntry("CAMERA_SOURCE_DEFAULT", """Default camera source.""")
CAMERA_SOURCE_RGB = 1
enums["CAMERA_SOURCE"][1] = EnumEntry("CAMERA_SOURCE_RGB", """RGB camera source.""")
CAMERA_SOURCE_IR = 2
enums["CAMERA_SOURCE"][2] = EnumEntry("CAMERA_SOURCE_IR", """IR camera source.""")
CAMERA_SOURCE_NDVI = 3
enums["CAMERA_SOURCE"][3] = EnumEntry("CAMERA_SOURCE_NDVI", """NDVI camera source.""")
CAMERA_SOURCE_ENUM_END = 4
enums["CAMERA_SOURCE"][4] = EnumEntry("CAMERA_SOURCE_ENUM_END", """""")

# PARAM_ACK
enums["PARAM_ACK"] = Enum()
enums["PARAM_ACK"].bitmask = False
PARAM_ACK_ACCEPTED = 0
enums["PARAM_ACK"][0] = EnumEntry("PARAM_ACK_ACCEPTED", """Parameter value ACCEPTED and SET""")
PARAM_ACK_VALUE_UNSUPPORTED = 1
enums["PARAM_ACK"][1] = EnumEntry("PARAM_ACK_VALUE_UNSUPPORTED", """Parameter value UNKNOWN/UNSUPPORTED""")
PARAM_ACK_FAILED = 2
enums["PARAM_ACK"][2] = EnumEntry("PARAM_ACK_FAILED", """Parameter failed to set""")
PARAM_ACK_IN_PROGRESS = 3
enums["PARAM_ACK"][3] = EnumEntry("PARAM_ACK_IN_PROGRESS", """Parameter value received but not yet set/accepted. A subsequent PARAM_EXT_ACK with the final result will follow once operation is completed. This is returned immediately for parameters that take longer to set, indicating that the the parameter was received and does not need to be resent.""")
PARAM_ACK_ENUM_END = 4
enums["PARAM_ACK"][4] = EnumEntry("PARAM_ACK_ENUM_END", """""")

# CAMERA_MODE
enums["CAMERA_MODE"] = Enum()
enums["CAMERA_MODE"].bitmask = False
CAMERA_MODE_IMAGE = 0
enums["CAMERA_MODE"][0] = EnumEntry("CAMERA_MODE_IMAGE", """Camera is in image/photo capture mode.""")
CAMERA_MODE_VIDEO = 1
enums["CAMERA_MODE"][1] = EnumEntry("CAMERA_MODE_VIDEO", """Camera is in video capture mode.""")
CAMERA_MODE_IMAGE_SURVEY = 2
enums["CAMERA_MODE"][2] = EnumEntry("CAMERA_MODE_IMAGE_SURVEY", """Camera is in image survey capture mode. It allows for camera controller to do specific settings for surveys.""")
CAMERA_MODE_ENUM_END = 3
enums["CAMERA_MODE"][3] = EnumEntry("CAMERA_MODE_ENUM_END", """""")

# MAV_ARM_AUTH_DENIED_REASON
enums["MAV_ARM_AUTH_DENIED_REASON"] = Enum()
enums["MAV_ARM_AUTH_DENIED_REASON"].bitmask = False
MAV_ARM_AUTH_DENIED_REASON_GENERIC = 0
enums["MAV_ARM_AUTH_DENIED_REASON"][0] = EnumEntry("MAV_ARM_AUTH_DENIED_REASON_GENERIC", """Not a specific reason""")
MAV_ARM_AUTH_DENIED_REASON_NONE = 1
enums["MAV_ARM_AUTH_DENIED_REASON"][1] = EnumEntry("MAV_ARM_AUTH_DENIED_REASON_NONE", """Authorizer will send the error as string to GCS""")
MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT = 2
enums["MAV_ARM_AUTH_DENIED_REASON"][2] = EnumEntry("MAV_ARM_AUTH_DENIED_REASON_INVALID_WAYPOINT", """At least one waypoint have a invalid value""")
MAV_ARM_AUTH_DENIED_REASON_TIMEOUT = 3
enums["MAV_ARM_AUTH_DENIED_REASON"][3] = EnumEntry("MAV_ARM_AUTH_DENIED_REASON_TIMEOUT", """Timeout in the authorizer process(in case it depends on network)""")
MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE = 4
enums["MAV_ARM_AUTH_DENIED_REASON"][4] = EnumEntry("MAV_ARM_AUTH_DENIED_REASON_AIRSPACE_IN_USE", """Airspace of the mission in use by another vehicle, second result parameter can have the waypoint id that caused it to be denied.""")
MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER = 5
enums["MAV_ARM_AUTH_DENIED_REASON"][5] = EnumEntry("MAV_ARM_AUTH_DENIED_REASON_BAD_WEATHER", """Weather is not good to fly""")
MAV_ARM_AUTH_DENIED_REASON_ENUM_END = 6
enums["MAV_ARM_AUTH_DENIED_REASON"][6] = EnumEntry("MAV_ARM_AUTH_DENIED_REASON_ENUM_END", """""")

# RC_TYPE
enums["RC_TYPE"] = Enum()
enums["RC_TYPE"].bitmask = False
RC_TYPE_SPEKTRUM_DSM2 = 0
enums["RC_TYPE"][0] = EnumEntry("RC_TYPE_SPEKTRUM_DSM2", """Spektrum DSM2""")
RC_TYPE_SPEKTRUM_DSMX = 1
enums["RC_TYPE"][1] = EnumEntry("RC_TYPE_SPEKTRUM_DSMX", """Spektrum DSMX""")
RC_TYPE_ENUM_END = 2
enums["RC_TYPE"][2] = EnumEntry("RC_TYPE_ENUM_END", """""")

# ENGINE_CONTROL_OPTIONS
enums["ENGINE_CONTROL_OPTIONS"] = Enum()
enums["ENGINE_CONTROL_OPTIONS"].bitmask = False
ENGINE_CONTROL_OPTIONS_ALLOW_START_WHILE_DISARMED = 1
enums["ENGINE_CONTROL_OPTIONS"][1] = EnumEntry("ENGINE_CONTROL_OPTIONS_ALLOW_START_WHILE_DISARMED", """Allow starting the engine once while disarmed""")
ENGINE_CONTROL_OPTIONS_ENUM_END = 2
enums["ENGINE_CONTROL_OPTIONS"][2] = EnumEntry("ENGINE_CONTROL_OPTIONS_ENUM_END", """""")

# POSITION_TARGET_TYPEMASK
enums["POSITION_TARGET_TYPEMASK"] = Enum()
enums["POSITION_TARGET_TYPEMASK"].bitmask = True
POSITION_TARGET_TYPEMASK_X_IGNORE = 1
enums["POSITION_TARGET_TYPEMASK"][1] = EnumEntry("POSITION_TARGET_TYPEMASK_X_IGNORE", """Ignore position x""")
POSITION_TARGET_TYPEMASK_Y_IGNORE = 2
enums["POSITION_TARGET_TYPEMASK"][2] = EnumEntry("POSITION_TARGET_TYPEMASK_Y_IGNORE", """Ignore position y""")
POSITION_TARGET_TYPEMASK_Z_IGNORE = 4
enums["POSITION_TARGET_TYPEMASK"][4] = EnumEntry("POSITION_TARGET_TYPEMASK_Z_IGNORE", """Ignore position z""")
POSITION_TARGET_TYPEMASK_VX_IGNORE = 8
enums["POSITION_TARGET_TYPEMASK"][8] = EnumEntry("POSITION_TARGET_TYPEMASK_VX_IGNORE", """Ignore velocity x""")
POSITION_TARGET_TYPEMASK_VY_IGNORE = 16
enums["POSITION_TARGET_TYPEMASK"][16] = EnumEntry("POSITION_TARGET_TYPEMASK_VY_IGNORE", """Ignore velocity y""")
POSITION_TARGET_TYPEMASK_VZ_IGNORE = 32
enums["POSITION_TARGET_TYPEMASK"][32] = EnumEntry("POSITION_TARGET_TYPEMASK_VZ_IGNORE", """Ignore velocity z""")
POSITION_TARGET_TYPEMASK_AX_IGNORE = 64
enums["POSITION_TARGET_TYPEMASK"][64] = EnumEntry("POSITION_TARGET_TYPEMASK_AX_IGNORE", """Ignore acceleration x""")
POSITION_TARGET_TYPEMASK_AY_IGNORE = 128
enums["POSITION_TARGET_TYPEMASK"][128] = EnumEntry("POSITION_TARGET_TYPEMASK_AY_IGNORE", """Ignore acceleration y""")
POSITION_TARGET_TYPEMASK_AZ_IGNORE = 256
enums["POSITION_TARGET_TYPEMASK"][256] = EnumEntry("POSITION_TARGET_TYPEMASK_AZ_IGNORE", """Ignore acceleration z""")
POSITION_TARGET_TYPEMASK_FORCE_SET = 512
enums["POSITION_TARGET_TYPEMASK"][512] = EnumEntry("POSITION_TARGET_TYPEMASK_FORCE_SET", """Use force instead of acceleration""")
POSITION_TARGET_TYPEMASK_YAW_IGNORE = 1024
enums["POSITION_TARGET_TYPEMASK"][1024] = EnumEntry("POSITION_TARGET_TYPEMASK_YAW_IGNORE", """Ignore yaw""")
POSITION_TARGET_TYPEMASK_YAW_RATE_IGNORE = 2048
enums["POSITION_TARGET_TYPEMASK"][2048] = EnumEntry("POSITION_TARGET_TYPEMASK_YAW_RATE_IGNORE", """Ignore yaw rate""")
POSITION_TARGET_TYPEMASK_ENUM_END = 2049
enums["POSITION_TARGET_TYPEMASK"][2049] = EnumEntry("POSITION_TARGET_TYPEMASK_ENUM_END", """""")

# ATTITUDE_TARGET_TYPEMASK
enums["ATTITUDE_TARGET_TYPEMASK"] = Enum()
enums["ATTITUDE_TARGET_TYPEMASK"].bitmask = True
ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE = 1
enums["ATTITUDE_TARGET_TYPEMASK"][1] = EnumEntry("ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE", """Ignore body roll rate""")
ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE = 2
enums["ATTITUDE_TARGET_TYPEMASK"][2] = EnumEntry("ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE", """Ignore body pitch rate""")
ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE = 4
enums["ATTITUDE_TARGET_TYPEMASK"][4] = EnumEntry("ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE", """Ignore body yaw rate""")
ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE = 64
enums["ATTITUDE_TARGET_TYPEMASK"][64] = EnumEntry("ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE", """Ignore throttle""")
ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE = 128
enums["ATTITUDE_TARGET_TYPEMASK"][128] = EnumEntry("ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE", """Ignore attitude""")
ATTITUDE_TARGET_TYPEMASK_ENUM_END = 129
enums["ATTITUDE_TARGET_TYPEMASK"][129] = EnumEntry("ATTITUDE_TARGET_TYPEMASK_ENUM_END", """""")

# UTM_FLIGHT_STATE
enums["UTM_FLIGHT_STATE"] = Enum()
enums["UTM_FLIGHT_STATE"].bitmask = False
UTM_FLIGHT_STATE_UNKNOWN = 1
enums["UTM_FLIGHT_STATE"][1] = EnumEntry("UTM_FLIGHT_STATE_UNKNOWN", """The flight state can't be determined.""")
UTM_FLIGHT_STATE_GROUND = 2
enums["UTM_FLIGHT_STATE"][2] = EnumEntry("UTM_FLIGHT_STATE_GROUND", """UAS on ground.""")
UTM_FLIGHT_STATE_AIRBORNE = 3
enums["UTM_FLIGHT_STATE"][3] = EnumEntry("UTM_FLIGHT_STATE_AIRBORNE", """UAS airborne.""")
UTM_FLIGHT_STATE_EMERGENCY = 16
enums["UTM_FLIGHT_STATE"][16] = EnumEntry("UTM_FLIGHT_STATE_EMERGENCY", """UAS is in an emergency flight state.""")
UTM_FLIGHT_STATE_NOCTRL = 32
enums["UTM_FLIGHT_STATE"][32] = EnumEntry("UTM_FLIGHT_STATE_NOCTRL", """UAS has no active controls.""")
UTM_FLIGHT_STATE_ENUM_END = 33
enums["UTM_FLIGHT_STATE"][33] = EnumEntry("UTM_FLIGHT_STATE_ENUM_END", """""")

# UTM_DATA_AVAIL_FLAGS
enums["UTM_DATA_AVAIL_FLAGS"] = Enum()
enums["UTM_DATA_AVAIL_FLAGS"].bitmask = True
UTM_DATA_AVAIL_FLAGS_TIME_VALID = 1
enums["UTM_DATA_AVAIL_FLAGS"][1] = EnumEntry("UTM_DATA_AVAIL_FLAGS_TIME_VALID", """The field time contains valid data.""")
UTM_DATA_AVAIL_FLAGS_UAS_ID_AVAILABLE = 2
enums["UTM_DATA_AVAIL_FLAGS"][2] = EnumEntry("UTM_DATA_AVAIL_FLAGS_UAS_ID_AVAILABLE", """The field uas_id contains valid data.""")
UTM_DATA_AVAIL_FLAGS_POSITION_AVAILABLE = 4
enums["UTM_DATA_AVAIL_FLAGS"][4] = EnumEntry("UTM_DATA_AVAIL_FLAGS_POSITION_AVAILABLE", """The fields lat, lon and h_acc contain valid data.""")
UTM_DATA_AVAIL_FLAGS_ALTITUDE_AVAILABLE = 8
enums["UTM_DATA_AVAIL_FLAGS"][8] = EnumEntry("UTM_DATA_AVAIL_FLAGS_ALTITUDE_AVAILABLE", """The fields alt and v_acc contain valid data.""")
UTM_DATA_AVAIL_FLAGS_RELATIVE_ALTITUDE_AVAILABLE = 16
enums["UTM_DATA_AVAIL_FLAGS"][16] = EnumEntry("UTM_DATA_AVAIL_FLAGS_RELATIVE_ALTITUDE_AVAILABLE", """The field relative_alt contains valid data.""")
UTM_DATA_AVAIL_FLAGS_HORIZONTAL_VELO_AVAILABLE = 32
enums["UTM_DATA_AVAIL_FLAGS"][32] = EnumEntry("UTM_DATA_AVAIL_FLAGS_HORIZONTAL_VELO_AVAILABLE", """The fields vx and vy contain valid data.""")
UTM_DATA_AVAIL_FLAGS_VERTICAL_VELO_AVAILABLE = 64
enums["UTM_DATA_AVAIL_FLAGS"][64] = EnumEntry("UTM_DATA_AVAIL_FLAGS_VERTICAL_VELO_AVAILABLE", """The field vz contains valid data.""")
UTM_DATA_AVAIL_FLAGS_NEXT_WAYPOINT_AVAILABLE = 128
enums["UTM_DATA_AVAIL_FLAGS"][128] = EnumEntry("UTM_DATA_AVAIL_FLAGS_NEXT_WAYPOINT_AVAILABLE", """The fields next_lat, next_lon and next_alt contain valid data.""")
UTM_DATA_AVAIL_FLAGS_ENUM_END = 129
enums["UTM_DATA_AVAIL_FLAGS"][129] = EnumEntry("UTM_DATA_AVAIL_FLAGS_ENUM_END", """""")

# PRECISION_LAND_MODE
enums["PRECISION_LAND_MODE"] = Enum()
enums["PRECISION_LAND_MODE"].bitmask = False
PRECISION_LAND_MODE_DISABLED = 0
enums["PRECISION_LAND_MODE"][0] = EnumEntry("PRECISION_LAND_MODE_DISABLED", """Normal (non-precision) landing.""")
PRECISION_LAND_MODE_OPPORTUNISTIC = 1
enums["PRECISION_LAND_MODE"][1] = EnumEntry("PRECISION_LAND_MODE_OPPORTUNISTIC", """Use precision landing if beacon detected when land command accepted, otherwise land normally.""")
PRECISION_LAND_MODE_REQUIRED = 2
enums["PRECISION_LAND_MODE"][2] = EnumEntry("PRECISION_LAND_MODE_REQUIRED", """Use precision landing, searching for beacon if not found when land command accepted (land normally if beacon cannot be found).""")
PRECISION_LAND_MODE_ENUM_END = 3
enums["PRECISION_LAND_MODE"][3] = EnumEntry("PRECISION_LAND_MODE_ENUM_END", """""")

# PARACHUTE_ACTION
enums["PARACHUTE_ACTION"] = Enum()
enums["PARACHUTE_ACTION"].bitmask = False
PARACHUTE_DISABLE = 0
enums["PARACHUTE_ACTION"][0] = EnumEntry("PARACHUTE_DISABLE", """Disable auto-release of parachute (i.e. release triggered by crash detectors).""")
PARACHUTE_ENABLE = 1
enums["PARACHUTE_ACTION"][1] = EnumEntry("PARACHUTE_ENABLE", """Enable auto-release of parachute.""")
PARACHUTE_RELEASE = 2
enums["PARACHUTE_ACTION"][2] = EnumEntry("PARACHUTE_RELEASE", """Release parachute and kill motors.""")
PARACHUTE_ACTION_ENUM_END = 3
enums["PARACHUTE_ACTION"][3] = EnumEntry("PARACHUTE_ACTION_ENUM_END", """""")

# MAV_TUNNEL_PAYLOAD_TYPE
enums["MAV_TUNNEL_PAYLOAD_TYPE"] = Enum()
enums["MAV_TUNNEL_PAYLOAD_TYPE"].bitmask = False
MAV_TUNNEL_PAYLOAD_TYPE_UNKNOWN = 0
enums["MAV_TUNNEL_PAYLOAD_TYPE"][0] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_UNKNOWN", """Encoding of payload unknown.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED0 = 200
enums["MAV_TUNNEL_PAYLOAD_TYPE"][200] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED0", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED1 = 201
enums["MAV_TUNNEL_PAYLOAD_TYPE"][201] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED1", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED2 = 202
enums["MAV_TUNNEL_PAYLOAD_TYPE"][202] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED2", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED3 = 203
enums["MAV_TUNNEL_PAYLOAD_TYPE"][203] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED3", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED4 = 204
enums["MAV_TUNNEL_PAYLOAD_TYPE"][204] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED4", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED5 = 205
enums["MAV_TUNNEL_PAYLOAD_TYPE"][205] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED5", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED6 = 206
enums["MAV_TUNNEL_PAYLOAD_TYPE"][206] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED6", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED7 = 207
enums["MAV_TUNNEL_PAYLOAD_TYPE"][207] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED7", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED8 = 208
enums["MAV_TUNNEL_PAYLOAD_TYPE"][208] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED8", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED9 = 209
enums["MAV_TUNNEL_PAYLOAD_TYPE"][209] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_STORM32_RESERVED9", """Registered for STorM32 gimbal controller.""")
MAV_TUNNEL_PAYLOAD_TYPE_ENUM_END = 210
enums["MAV_TUNNEL_PAYLOAD_TYPE"][210] = EnumEntry("MAV_TUNNEL_PAYLOAD_TYPE_ENUM_END", """""")

# MAV_ODID_ID_TYPE
enums["MAV_ODID_ID_TYPE"] = Enum()
enums["MAV_ODID_ID_TYPE"].bitmask = False
MAV_ODID_ID_TYPE_NONE = 0
enums["MAV_ODID_ID_TYPE"][0] = EnumEntry("MAV_ODID_ID_TYPE_NONE", """No type defined.""")
MAV_ODID_ID_TYPE_SERIAL_NUMBER = 1
enums["MAV_ODID_ID_TYPE"][1] = EnumEntry("MAV_ODID_ID_TYPE_SERIAL_NUMBER", """Manufacturer Serial Number (ANSI/CTA-2063 format).""")
MAV_ODID_ID_TYPE_CAA_REGISTRATION_ID = 2
enums["MAV_ODID_ID_TYPE"][2] = EnumEntry("MAV_ODID_ID_TYPE_CAA_REGISTRATION_ID", """CAA (Civil Aviation Authority) registered ID. Format: [ICAO Country Code].[CAA Assigned ID].""")
MAV_ODID_ID_TYPE_UTM_ASSIGNED_UUID = 3
enums["MAV_ODID_ID_TYPE"][3] = EnumEntry("MAV_ODID_ID_TYPE_UTM_ASSIGNED_UUID", """UTM (Unmanned Traffic Management) assigned UUID (RFC4122).""")
MAV_ODID_ID_TYPE_SPECIFIC_SESSION_ID = 4
enums["MAV_ODID_ID_TYPE"][4] = EnumEntry("MAV_ODID_ID_TYPE_SPECIFIC_SESSION_ID", """A 20 byte ID for a specific flight/session. The exact ID type is indicated by the first byte of uas_id and these type values are managed by ICAO.""")
MAV_ODID_ID_TYPE_ENUM_END = 5
enums["MAV_ODID_ID_TYPE"][5] = EnumEntry("MAV_ODID_ID_TYPE_ENUM_END", """""")

# MAV_ODID_UA_TYPE
enums["MAV_ODID_UA_TYPE"] = Enum()
enums["MAV_ODID_UA_TYPE"].bitmask = False
MAV_ODID_UA_TYPE_NONE = 0
enums["MAV_ODID_UA_TYPE"][0] = EnumEntry("MAV_ODID_UA_TYPE_NONE", """No UA (Unmanned Aircraft) type defined.""")
MAV_ODID_UA_TYPE_AEROPLANE = 1
enums["MAV_ODID_UA_TYPE"][1] = EnumEntry("MAV_ODID_UA_TYPE_AEROPLANE", """Aeroplane/Airplane. Fixed wing.""")
MAV_ODID_UA_TYPE_HELICOPTER_OR_MULTIROTOR = 2
enums["MAV_ODID_UA_TYPE"][2] = EnumEntry("MAV_ODID_UA_TYPE_HELICOPTER_OR_MULTIROTOR", """Helicopter or multirotor.""")
MAV_ODID_UA_TYPE_GYROPLANE = 3
enums["MAV_ODID_UA_TYPE"][3] = EnumEntry("MAV_ODID_UA_TYPE_GYROPLANE", """Gyroplane.""")
MAV_ODID_UA_TYPE_HYBRID_LIFT = 4
enums["MAV_ODID_UA_TYPE"][4] = EnumEntry("MAV_ODID_UA_TYPE_HYBRID_LIFT", """VTOL (Vertical Take-Off and Landing). Fixed wing aircraft that can take off vertically.""")
MAV_ODID_UA_TYPE_ORNITHOPTER = 5
enums["MAV_ODID_UA_TYPE"][5] = EnumEntry("MAV_ODID_UA_TYPE_ORNITHOPTER", """Ornithopter.""")
MAV_ODID_UA_TYPE_GLIDER = 6
enums["MAV_ODID_UA_TYPE"][6] = EnumEntry("MAV_ODID_UA_TYPE_GLIDER", """Glider.""")
MAV_ODID_UA_TYPE_KITE = 7
enums["MAV_ODID_UA_TYPE"][7] = EnumEntry("MAV_ODID_UA_TYPE_KITE", """Kite.""")
MAV_ODID_UA_TYPE_FREE_BALLOON = 8
enums["MAV_ODID_UA_TYPE"][8] = EnumEntry("MAV_ODID_UA_TYPE_FREE_BALLOON", """Free Balloon.""")
MAV_ODID_UA_TYPE_CAPTIVE_BALLOON = 9
enums["MAV_ODID_UA_TYPE"][9] = EnumEntry("MAV_ODID_UA_TYPE_CAPTIVE_BALLOON", """Captive Balloon.""")
MAV_ODID_UA_TYPE_AIRSHIP = 10
enums["MAV_ODID_UA_TYPE"][10] = EnumEntry("MAV_ODID_UA_TYPE_AIRSHIP", """Airship. E.g. a blimp.""")
MAV_ODID_UA_TYPE_FREE_FALL_PARACHUTE = 11
enums["MAV_ODID_UA_TYPE"][11] = EnumEntry("MAV_ODID_UA_TYPE_FREE_FALL_PARACHUTE", """Free Fall/Parachute (unpowered).""")
MAV_ODID_UA_TYPE_ROCKET = 12
enums["MAV_ODID_UA_TYPE"][12] = EnumEntry("MAV_ODID_UA_TYPE_ROCKET", """Rocket.""")
MAV_ODID_UA_TYPE_TETHERED_POWERED_AIRCRAFT = 13
enums["MAV_ODID_UA_TYPE"][13] = EnumEntry("MAV_ODID_UA_TYPE_TETHERED_POWERED_AIRCRAFT", """Tethered powered aircraft.""")
MAV_ODID_UA_TYPE_GROUND_OBSTACLE = 14
enums["MAV_ODID_UA_TYPE"][14] = EnumEntry("MAV_ODID_UA_TYPE_GROUND_OBSTACLE", """Ground Obstacle.""")
MAV_ODID_UA_TYPE_OTHER = 15
enums["MAV_ODID_UA_TYPE"][15] = EnumEntry("MAV_ODID_UA_TYPE_OTHER", """Other type of aircraft not listed earlier.""")
MAV_ODID_UA_TYPE_ENUM_END = 16
enums["MAV_ODID_UA_TYPE"][16] = EnumEntry("MAV_ODID_UA_TYPE_ENUM_END", """""")

# MAV_ODID_STATUS
enums["MAV_ODID_STATUS"] = Enum()
enums["MAV_ODID_STATUS"].bitmask = False
MAV_ODID_STATUS_UNDECLARED = 0
enums["MAV_ODID_STATUS"][0] = EnumEntry("MAV_ODID_STATUS_UNDECLARED", """The status of the (UA) Unmanned Aircraft is undefined.""")
MAV_ODID_STATUS_GROUND = 1
enums["MAV_ODID_STATUS"][1] = EnumEntry("MAV_ODID_STATUS_GROUND", """The UA is on the ground.""")
MAV_ODID_STATUS_AIRBORNE = 2
enums["MAV_ODID_STATUS"][2] = EnumEntry("MAV_ODID_STATUS_AIRBORNE", """The UA is in the air.""")
MAV_ODID_STATUS_EMERGENCY = 3
enums["MAV_ODID_STATUS"][3] = EnumEntry("MAV_ODID_STATUS_EMERGENCY", """The UA is having an emergency.""")
MAV_ODID_STATUS_REMOTE_ID_SYSTEM_FAILURE = 4
enums["MAV_ODID_STATUS"][4] = EnumEntry("MAV_ODID_STATUS_REMOTE_ID_SYSTEM_FAILURE", """The remote ID system is failing or unreliable in some way.""")
MAV_ODID_STATUS_ENUM_END = 5
enums["MAV_ODID_STATUS"][5] = EnumEntry("MAV_ODID_STATUS_ENUM_END", """""")

# MAV_ODID_HEIGHT_REF
enums["MAV_ODID_HEIGHT_REF"] = Enum()
enums["MAV_ODID_HEIGHT_REF"].bitmask = False
MAV_ODID_HEIGHT_REF_OVER_TAKEOFF = 0
enums["MAV_ODID_HEIGHT_REF"][0] = EnumEntry("MAV_ODID_HEIGHT_REF_OVER_TAKEOFF", """The height field is relative to the take-off location.""")
MAV_ODID_HEIGHT_REF_OVER_GROUND = 1
enums["MAV_ODID_HEIGHT_REF"][1] = EnumEntry("MAV_ODID_HEIGHT_REF_OVER_GROUND", """The height field is relative to ground.""")
MAV_ODID_HEIGHT_REF_ENUM_END = 2
enums["MAV_ODID_HEIGHT_REF"][2] = EnumEntry("MAV_ODID_HEIGHT_REF_ENUM_END", """""")

# MAV_ODID_HOR_ACC
enums["MAV_ODID_HOR_ACC"] = Enum()
enums["MAV_ODID_HOR_ACC"].bitmask = False
MAV_ODID_HOR_ACC_UNKNOWN = 0
enums["MAV_ODID_HOR_ACC"][0] = EnumEntry("MAV_ODID_HOR_ACC_UNKNOWN", """The horizontal accuracy is unknown.""")
MAV_ODID_HOR_ACC_10NM = 1
enums["MAV_ODID_HOR_ACC"][1] = EnumEntry("MAV_ODID_HOR_ACC_10NM", """The horizontal accuracy is smaller than 10 Nautical Miles. 18.52 km.""")
MAV_ODID_HOR_ACC_4NM = 2
enums["MAV_ODID_HOR_ACC"][2] = EnumEntry("MAV_ODID_HOR_ACC_4NM", """The horizontal accuracy is smaller than 4 Nautical Miles. 7.408 km.""")
MAV_ODID_HOR_ACC_2NM = 3
enums["MAV_ODID_HOR_ACC"][3] = EnumEntry("MAV_ODID_HOR_ACC_2NM", """The horizontal accuracy is smaller than 2 Nautical Miles. 3.704 km.""")
MAV_ODID_HOR_ACC_1NM = 4
enums["MAV_ODID_HOR_ACC"][4] = EnumEntry("MAV_ODID_HOR_ACC_1NM", """The horizontal accuracy is smaller than 1 Nautical Miles. 1.852 km.""")
MAV_ODID_HOR_ACC_0_5NM = 5
enums["MAV_ODID_HOR_ACC"][5] = EnumEntry("MAV_ODID_HOR_ACC_0_5NM", """The horizontal accuracy is smaller than 0.5 Nautical Miles. 926 m.""")
MAV_ODID_HOR_ACC_0_3NM = 6
enums["MAV_ODID_HOR_ACC"][6] = EnumEntry("MAV_ODID_HOR_ACC_0_3NM", """The horizontal accuracy is smaller than 0.3 Nautical Miles. 555.6 m.""")
MAV_ODID_HOR_ACC_0_1NM = 7
enums["MAV_ODID_HOR_ACC"][7] = EnumEntry("MAV_ODID_HOR_ACC_0_1NM", """The horizontal accuracy is smaller than 0.1 Nautical Miles. 185.2 m.""")
MAV_ODID_HOR_ACC_0_05NM = 8
enums["MAV_ODID_HOR_ACC"][8] = EnumEntry("MAV_ODID_HOR_ACC_0_05NM", """The horizontal accuracy is smaller than 0.05 Nautical Miles. 92.6 m.""")
MAV_ODID_HOR_ACC_30_METER = 9
enums["MAV_ODID_HOR_ACC"][9] = EnumEntry("MAV_ODID_HOR_ACC_30_METER", """The horizontal accuracy is smaller than 30 meter.""")
MAV_ODID_HOR_ACC_10_METER = 10
enums["MAV_ODID_HOR_ACC"][10] = EnumEntry("MAV_ODID_HOR_ACC_10_METER", """The horizontal accuracy is smaller than 10 meter.""")
MAV_ODID_HOR_ACC_3_METER = 11
enums["MAV_ODID_HOR_ACC"][11] = EnumEntry("MAV_ODID_HOR_ACC_3_METER", """The horizontal accuracy is smaller than 3 meter.""")
MAV_ODID_HOR_ACC_1_METER = 12
enums["MAV_ODID_HOR_ACC"][12] = EnumEntry("MAV_ODID_HOR_ACC_1_METER", """The horizontal accuracy is smaller than 1 meter.""")
MAV_ODID_HOR_ACC_ENUM_END = 13
enums["MAV_ODID_HOR_ACC"][13] = EnumEntry("MAV_ODID_HOR_ACC_ENUM_END", """""")

# MAV_ODID_VER_ACC
enums["MAV_ODID_VER_ACC"] = Enum()
enums["MAV_ODID_VER_ACC"].bitmask = False
MAV_ODID_VER_ACC_UNKNOWN = 0
enums["MAV_ODID_VER_ACC"][0] = EnumEntry("MAV_ODID_VER_ACC_UNKNOWN", """The vertical accuracy is unknown.""")
MAV_ODID_VER_ACC_150_METER = 1
enums["MAV_ODID_VER_ACC"][1] = EnumEntry("MAV_ODID_VER_ACC_150_METER", """The vertical accuracy is smaller than 150 meter.""")
MAV_ODID_VER_ACC_45_METER = 2
enums["MAV_ODID_VER_ACC"][2] = EnumEntry("MAV_ODID_VER_ACC_45_METER", """The vertical accuracy is smaller than 45 meter.""")
MAV_ODID_VER_ACC_25_METER = 3
enums["MAV_ODID_VER_ACC"][3] = EnumEntry("MAV_ODID_VER_ACC_25_METER", """The vertical accuracy is smaller than 25 meter.""")
MAV_ODID_VER_ACC_10_METER = 4
enums["MAV_ODID_VER_ACC"][4] = EnumEntry("MAV_ODID_VER_ACC_10_METER", """The vertical accuracy is smaller than 10 meter.""")
MAV_ODID_VER_ACC_3_METER = 5
enums["MAV_ODID_VER_ACC"][5] = EnumEntry("MAV_ODID_VER_ACC_3_METER", """The vertical accuracy is smaller than 3 meter.""")
MAV_ODID_VER_ACC_1_METER = 6
enums["MAV_ODID_VER_ACC"][6] = EnumEntry("MAV_ODID_VER_ACC_1_METER", """The vertical accuracy is smaller than 1 meter.""")
MAV_ODID_VER_ACC_ENUM_END = 7
enums["MAV_ODID_VER_ACC"][7] = EnumEntry("MAV_ODID_VER_ACC_ENUM_END", """""")

# MAV_ODID_SPEED_ACC
enums["MAV_ODID_SPEED_ACC"] = Enum()
enums["MAV_ODID_SPEED_ACC"].bitmask = False
MAV_ODID_SPEED_ACC_UNKNOWN = 0
enums["MAV_ODID_SPEED_ACC"][0] = EnumEntry("MAV_ODID_SPEED_ACC_UNKNOWN", """The speed accuracy is unknown.""")
MAV_ODID_SPEED_ACC_10_METERS_PER_SECOND = 1
enums["MAV_ODID_SPEED_ACC"][1] = EnumEntry("MAV_ODID_SPEED_ACC_10_METERS_PER_SECOND", """The speed accuracy is smaller than 10 meters per second.""")
MAV_ODID_SPEED_ACC_3_METERS_PER_SECOND = 2
enums["MAV_ODID_SPEED_ACC"][2] = EnumEntry("MAV_ODID_SPEED_ACC_3_METERS_PER_SECOND", """The speed accuracy is smaller than 3 meters per second.""")
MAV_ODID_SPEED_ACC_1_METERS_PER_SECOND = 3
enums["MAV_ODID_SPEED_ACC"][3] = EnumEntry("MAV_ODID_SPEED_ACC_1_METERS_PER_SECOND", """The speed accuracy is smaller than 1 meters per second.""")
MAV_ODID_SPEED_ACC_0_3_METERS_PER_SECOND = 4
enums["MAV_ODID_SPEED_ACC"][4] = EnumEntry("MAV_ODID_SPEED_ACC_0_3_METERS_PER_SECOND", """The speed accuracy is smaller than 0.3 meters per second.""")
MAV_ODID_SPEED_ACC_ENUM_END = 5
enums["MAV_ODID_SPEED_ACC"][5] = EnumEntry("MAV_ODID_SPEED_ACC_ENUM_END", """""")

# MAV_ODID_TIME_ACC
enums["MAV_ODID_TIME_ACC"] = Enum()
enums["MAV_ODID_TIME_ACC"].bitmask = False
MAV_ODID_TIME_ACC_UNKNOWN = 0
enums["MAV_ODID_TIME_ACC"][0] = EnumEntry("MAV_ODID_TIME_ACC_UNKNOWN", """The timestamp accuracy is unknown.""")
MAV_ODID_TIME_ACC_0_1_SECOND = 1
enums["MAV_ODID_TIME_ACC"][1] = EnumEntry("MAV_ODID_TIME_ACC_0_1_SECOND", """The timestamp accuracy is smaller than or equal to 0.1 second.""")
MAV_ODID_TIME_ACC_0_2_SECOND = 2
enums["MAV_ODID_TIME_ACC"][2] = EnumEntry("MAV_ODID_TIME_ACC_0_2_SECOND", """The timestamp accuracy is smaller than or equal to 0.2 second.""")
MAV_ODID_TIME_ACC_0_3_SECOND = 3
enums["MAV_ODID_TIME_ACC"][3] = EnumEntry("MAV_ODID_TIME_ACC_0_3_SECOND", """The timestamp accuracy is smaller than or equal to 0.3 second.""")
MAV_ODID_TIME_ACC_0_4_SECOND = 4
enums["MAV_ODID_TIME_ACC"][4] = EnumEntry("MAV_ODID_TIME_ACC_0_4_SECOND", """The timestamp accuracy is smaller than or equal to 0.4 second.""")
MAV_ODID_TIME_ACC_0_5_SECOND = 5
enums["MAV_ODID_TIME_ACC"][5] = EnumEntry("MAV_ODID_TIME_ACC_0_5_SECOND", """The timestamp accuracy is smaller than or equal to 0.5 second.""")
MAV_ODID_TIME_ACC_0_6_SECOND = 6
enums["MAV_ODID_TIME_ACC"][6] = EnumEntry("MAV_ODID_TIME_ACC_0_6_SECOND", """The timestamp accuracy is smaller than or equal to 0.6 second.""")
MAV_ODID_TIME_ACC_0_7_SECOND = 7
enums["MAV_ODID_TIME_ACC"][7] = EnumEntry("MAV_ODID_TIME_ACC_0_7_SECOND", """The timestamp accuracy is smaller than or equal to 0.7 second.""")
MAV_ODID_TIME_ACC_0_8_SECOND = 8
enums["MAV_ODID_TIME_ACC"][8] = EnumEntry("MAV_ODID_TIME_ACC_0_8_SECOND", """The timestamp accuracy is smaller than or equal to 0.8 second.""")
MAV_ODID_TIME_ACC_0_9_SECOND = 9
enums["MAV_ODID_TIME_ACC"][9] = EnumEntry("MAV_ODID_TIME_ACC_0_9_SECOND", """The timestamp accuracy is smaller than or equal to 0.9 second.""")
MAV_ODID_TIME_ACC_1_0_SECOND = 10
enums["MAV_ODID_TIME_ACC"][10] = EnumEntry("MAV_ODID_TIME_ACC_1_0_SECOND", """The timestamp accuracy is smaller than or equal to 1.0 second.""")
MAV_ODID_TIME_ACC_1_1_SECOND = 11
enums["MAV_ODID_TIME_ACC"][11] = EnumEntry("MAV_ODID_TIME_ACC_1_1_SECOND", """The timestamp accuracy is smaller than or equal to 1.1 second.""")
MAV_ODID_TIME_ACC_1_2_SECOND = 12
enums["MAV_ODID_TIME_ACC"][12] = EnumEntry("MAV_ODID_TIME_ACC_1_2_SECOND", """The timestamp accuracy is smaller than or equal to 1.2 second.""")
MAV_ODID_TIME_ACC_1_3_SECOND = 13
enums["MAV_ODID_TIME_ACC"][13] = EnumEntry("MAV_ODID_TIME_ACC_1_3_SECOND", """The timestamp accuracy is smaller than or equal to 1.3 second.""")
MAV_ODID_TIME_ACC_1_4_SECOND = 14
enums["MAV_ODID_TIME_ACC"][14] = EnumEntry("MAV_ODID_TIME_ACC_1_4_SECOND", """The timestamp accuracy is smaller than or equal to 1.4 second.""")
MAV_ODID_TIME_ACC_1_5_SECOND = 15
enums["MAV_ODID_TIME_ACC"][15] = EnumEntry("MAV_ODID_TIME_ACC_1_5_SECOND", """The timestamp accuracy is smaller than or equal to 1.5 second.""")
MAV_ODID_TIME_ACC_ENUM_END = 16
enums["MAV_ODID_TIME_ACC"][16] = EnumEntry("MAV_ODID_TIME_ACC_ENUM_END", """""")

# MAV_ODID_AUTH_TYPE
enums["MAV_ODID_AUTH_TYPE"] = Enum()
enums["MAV_ODID_AUTH_TYPE"].bitmask = False
MAV_ODID_AUTH_TYPE_NONE = 0
enums["MAV_ODID_AUTH_TYPE"][0] = EnumEntry("MAV_ODID_AUTH_TYPE_NONE", """No authentication type is specified.""")
MAV_ODID_AUTH_TYPE_UAS_ID_SIGNATURE = 1
enums["MAV_ODID_AUTH_TYPE"][1] = EnumEntry("MAV_ODID_AUTH_TYPE_UAS_ID_SIGNATURE", """Signature for the UAS (Unmanned Aircraft System) ID.""")
MAV_ODID_AUTH_TYPE_OPERATOR_ID_SIGNATURE = 2
enums["MAV_ODID_AUTH_TYPE"][2] = EnumEntry("MAV_ODID_AUTH_TYPE_OPERATOR_ID_SIGNATURE", """Signature for the Operator ID.""")
MAV_ODID_AUTH_TYPE_MESSAGE_SET_SIGNATURE = 3
enums["MAV_ODID_AUTH_TYPE"][3] = EnumEntry("MAV_ODID_AUTH_TYPE_MESSAGE_SET_SIGNATURE", """Signature for the entire message set.""")
MAV_ODID_AUTH_TYPE_NETWORK_REMOTE_ID = 4
enums["MAV_ODID_AUTH_TYPE"][4] = EnumEntry("MAV_ODID_AUTH_TYPE_NETWORK_REMOTE_ID", """Authentication is provided by Network Remote ID.""")
MAV_ODID_AUTH_TYPE_SPECIFIC_AUTHENTICATION = 5
enums["MAV_ODID_AUTH_TYPE"][5] = EnumEntry("MAV_ODID_AUTH_TYPE_SPECIFIC_AUTHENTICATION", """The exact authentication type is indicated by the first byte of authentication_data and these type values are managed by ICAO.""")
MAV_ODID_AUTH_TYPE_ENUM_END = 6
enums["MAV_ODID_AUTH_TYPE"][6] = EnumEntry("MAV_ODID_AUTH_TYPE_ENUM_END", """""")

# MAV_ODID_DESC_TYPE
enums["MAV_ODID_DESC_TYPE"] = Enum()
enums["MAV_ODID_DESC_TYPE"].bitmask = False
MAV_ODID_DESC_TYPE_TEXT = 0
enums["MAV_ODID_DESC_TYPE"][0] = EnumEntry("MAV_ODID_DESC_TYPE_TEXT", """Free-form text description of the purpose of the flight.""")
MAV_ODID_DESC_TYPE_EMERGENCY = 1
enums["MAV_ODID_DESC_TYPE"][1] = EnumEntry("MAV_ODID_DESC_TYPE_EMERGENCY", """Optional additional clarification when status == MAV_ODID_STATUS_EMERGENCY.""")
MAV_ODID_DESC_TYPE_EXTENDED_STATUS = 2
enums["MAV_ODID_DESC_TYPE"][2] = EnumEntry("MAV_ODID_DESC_TYPE_EXTENDED_STATUS", """Optional additional clarification when status != MAV_ODID_STATUS_EMERGENCY.""")
MAV_ODID_DESC_TYPE_ENUM_END = 3
enums["MAV_ODID_DESC_TYPE"][3] = EnumEntry("MAV_ODID_DESC_TYPE_ENUM_END", """""")

# MAV_ODID_OPERATOR_LOCATION_TYPE
enums["MAV_ODID_OPERATOR_LOCATION_TYPE"] = Enum()
enums["MAV_ODID_OPERATOR_LOCATION_TYPE"].bitmask = False
MAV_ODID_OPERATOR_LOCATION_TYPE_TAKEOFF = 0
enums["MAV_ODID_OPERATOR_LOCATION_TYPE"][0] = EnumEntry("MAV_ODID_OPERATOR_LOCATION_TYPE_TAKEOFF", """The location of the operator is the same as the take-off location.""")
MAV_ODID_OPERATOR_LOCATION_TYPE_LIVE_GNSS = 1
enums["MAV_ODID_OPERATOR_LOCATION_TYPE"][1] = EnumEntry("MAV_ODID_OPERATOR_LOCATION_TYPE_LIVE_GNSS", """The location of the operator is based on live GNSS data.""")
MAV_ODID_OPERATOR_LOCATION_TYPE_FIXED = 2
enums["MAV_ODID_OPERATOR_LOCATION_TYPE"][2] = EnumEntry("MAV_ODID_OPERATOR_LOCATION_TYPE_FIXED", """The location of the operator is a fixed location.""")
MAV_ODID_OPERATOR_LOCATION_TYPE_ENUM_END = 3
enums["MAV_ODID_OPERATOR_LOCATION_TYPE"][3] = EnumEntry("MAV_ODID_OPERATOR_LOCATION_TYPE_ENUM_END", """""")

# MAV_ODID_CLASSIFICATION_TYPE
enums["MAV_ODID_CLASSIFICATION_TYPE"] = Enum()
enums["MAV_ODID_CLASSIFICATION_TYPE"].bitmask = False
MAV_ODID_CLASSIFICATION_TYPE_UNDECLARED = 0
enums["MAV_ODID_CLASSIFICATION_TYPE"][0] = EnumEntry("MAV_ODID_CLASSIFICATION_TYPE_UNDECLARED", """The classification type for the UA is undeclared.""")
MAV_ODID_CLASSIFICATION_TYPE_EU = 1
enums["MAV_ODID_CLASSIFICATION_TYPE"][1] = EnumEntry("MAV_ODID_CLASSIFICATION_TYPE_EU", """The classification type for the UA follows EU (European Union) specifications.""")
MAV_ODID_CLASSIFICATION_TYPE_ENUM_END = 2
enums["MAV_ODID_CLASSIFICATION_TYPE"][2] = EnumEntry("MAV_ODID_CLASSIFICATION_TYPE_ENUM_END", """""")

# MAV_ODID_CATEGORY_EU
enums["MAV_ODID_CATEGORY_EU"] = Enum()
enums["MAV_ODID_CATEGORY_EU"].bitmask = False
MAV_ODID_CATEGORY_EU_UNDECLARED = 0
enums["MAV_ODID_CATEGORY_EU"][0] = EnumEntry("MAV_ODID_CATEGORY_EU_UNDECLARED", """The category for the UA, according to the EU specification, is undeclared.""")
MAV_ODID_CATEGORY_EU_OPEN = 1
enums["MAV_ODID_CATEGORY_EU"][1] = EnumEntry("MAV_ODID_CATEGORY_EU_OPEN", """The category for the UA, according to the EU specification, is the Open category.""")
MAV_ODID_CATEGORY_EU_SPECIFIC = 2
enums["MAV_ODID_CATEGORY_EU"][2] = EnumEntry("MAV_ODID_CATEGORY_EU_SPECIFIC", """The category for the UA, according to the EU specification, is the Specific category.""")
MAV_ODID_CATEGORY_EU_CERTIFIED = 3
enums["MAV_ODID_CATEGORY_EU"][3] = EnumEntry("MAV_ODID_CATEGORY_EU_CERTIFIED", """The category for the UA, according to the EU specification, is the Certified category.""")
MAV_ODID_CATEGORY_EU_ENUM_END = 4
enums["MAV_ODID_CATEGORY_EU"][4] = EnumEntry("MAV_ODID_CATEGORY_EU_ENUM_END", """""")

# MAV_ODID_CLASS_EU
enums["MAV_ODID_CLASS_EU"] = Enum()
enums["MAV_ODID_CLASS_EU"].bitmask = False
MAV_ODID_CLASS_EU_UNDECLARED = 0
enums["MAV_ODID_CLASS_EU"][0] = EnumEntry("MAV_ODID_CLASS_EU_UNDECLARED", """The class for the UA, according to the EU specification, is undeclared.""")
MAV_ODID_CLASS_EU_CLASS_0 = 1
enums["MAV_ODID_CLASS_EU"][1] = EnumEntry("MAV_ODID_CLASS_EU_CLASS_0", """The class for the UA, according to the EU specification, is Class 0.""")
MAV_ODID_CLASS_EU_CLASS_1 = 2
enums["MAV_ODID_CLASS_EU"][2] = EnumEntry("MAV_ODID_CLASS_EU_CLASS_1", """The class for the UA, according to the EU specification, is Class 1.""")
MAV_ODID_CLASS_EU_CLASS_2 = 3
enums["MAV_ODID_CLASS_EU"][3] = EnumEntry("MAV_ODID_CLASS_EU_CLASS_2", """The class for the UA, according to the EU specification, is Class 2.""")
MAV_ODID_CLASS_EU_CLASS_3 = 4
enums["MAV_ODID_CLASS_EU"][4] = EnumEntry("MAV_ODID_CLASS_EU_CLASS_3", """The class for the UA, according to the EU specification, is Class 3.""")
MAV_ODID_CLASS_EU_CLASS_4 = 5
enums["MAV_ODID_CLASS_EU"][5] = EnumEntry("MAV_ODID_CLASS_EU_CLASS_4", """The class for the UA, according to the EU specification, is Class 4.""")
MAV_ODID_CLASS_EU_CLASS_5 = 6
enums["MAV_ODID_CLASS_EU"][6] = EnumEntry("MAV_ODID_CLASS_EU_CLASS_5", """The class for the UA, according to the EU specification, is Class 5.""")
MAV_ODID_CLASS_EU_CLASS_6 = 7
enums["MAV_ODID_CLASS_EU"][7] = EnumEntry("MAV_ODID_CLASS_EU_CLASS_6", """The class for the UA, according to the EU specification, is Class 6.""")
MAV_ODID_CLASS_EU_ENUM_END = 8
enums["MAV_ODID_CLASS_EU"][8] = EnumEntry("MAV_ODID_CLASS_EU_ENUM_END", """""")

# MAV_ODID_OPERATOR_ID_TYPE
enums["MAV_ODID_OPERATOR_ID_TYPE"] = Enum()
enums["MAV_ODID_OPERATOR_ID_TYPE"].bitmask = False
MAV_ODID_OPERATOR_ID_TYPE_CAA = 0
enums["MAV_ODID_OPERATOR_ID_TYPE"][0] = EnumEntry("MAV_ODID_OPERATOR_ID_TYPE_CAA", """CAA (Civil Aviation Authority) registered operator ID.""")
MAV_ODID_OPERATOR_ID_TYPE_ENUM_END = 1
enums["MAV_ODID_OPERATOR_ID_TYPE"][1] = EnumEntry("MAV_ODID_OPERATOR_ID_TYPE_ENUM_END", """""")

# MAV_ODID_ARM_STATUS
enums["MAV_ODID_ARM_STATUS"] = Enum()
enums["MAV_ODID_ARM_STATUS"].bitmask = False
MAV_ODID_ARM_STATUS_GOOD_TO_ARM = 0
enums["MAV_ODID_ARM_STATUS"][0] = EnumEntry("MAV_ODID_ARM_STATUS_GOOD_TO_ARM", """Passing arming checks.""")
MAV_ODID_ARM_STATUS_PRE_ARM_FAIL_GENERIC = 1
enums["MAV_ODID_ARM_STATUS"][1] = EnumEntry("MAV_ODID_ARM_STATUS_PRE_ARM_FAIL_GENERIC", """Generic arming failure, see error string for details.""")
MAV_ODID_ARM_STATUS_ENUM_END = 2
enums["MAV_ODID_ARM_STATUS"][2] = EnumEntry("MAV_ODID_ARM_STATUS_ENUM_END", """""")

# AIS_TYPE
enums["AIS_TYPE"] = Enum()
enums["AIS_TYPE"].bitmask = False
AIS_TYPE_UNKNOWN = 0
enums["AIS_TYPE"][0] = EnumEntry("AIS_TYPE_UNKNOWN", """Not available (default).""")
AIS_TYPE_RESERVED_1 = 1
enums["AIS_TYPE"][1] = EnumEntry("AIS_TYPE_RESERVED_1", """""")
AIS_TYPE_RESERVED_2 = 2
enums["AIS_TYPE"][2] = EnumEntry("AIS_TYPE_RESERVED_2", """""")
AIS_TYPE_RESERVED_3 = 3
enums["AIS_TYPE"][3] = EnumEntry("AIS_TYPE_RESERVED_3", """""")
AIS_TYPE_RESERVED_4 = 4
enums["AIS_TYPE"][4] = EnumEntry("AIS_TYPE_RESERVED_4", """""")
AIS_TYPE_RESERVED_5 = 5
enums["AIS_TYPE"][5] = EnumEntry("AIS_TYPE_RESERVED_5", """""")
AIS_TYPE_RESERVED_6 = 6
enums["AIS_TYPE"][6] = EnumEntry("AIS_TYPE_RESERVED_6", """""")
AIS_TYPE_RESERVED_7 = 7
enums["AIS_TYPE"][7] = EnumEntry("AIS_TYPE_RESERVED_7", """""")
AIS_TYPE_RESERVED_8 = 8
enums["AIS_TYPE"][8] = EnumEntry("AIS_TYPE_RESERVED_8", """""")
AIS_TYPE_RESERVED_9 = 9
enums["AIS_TYPE"][9] = EnumEntry("AIS_TYPE_RESERVED_9", """""")
AIS_TYPE_RESERVED_10 = 10
enums["AIS_TYPE"][10] = EnumEntry("AIS_TYPE_RESERVED_10", """""")
AIS_TYPE_RESERVED_11 = 11
enums["AIS_TYPE"][11] = EnumEntry("AIS_TYPE_RESERVED_11", """""")
AIS_TYPE_RESERVED_12 = 12
enums["AIS_TYPE"][12] = EnumEntry("AIS_TYPE_RESERVED_12", """""")
AIS_TYPE_RESERVED_13 = 13
enums["AIS_TYPE"][13] = EnumEntry("AIS_TYPE_RESERVED_13", """""")
AIS_TYPE_RESERVED_14 = 14
enums["AIS_TYPE"][14] = EnumEntry("AIS_TYPE_RESERVED_14", """""")
AIS_TYPE_RESERVED_15 = 15
enums["AIS_TYPE"][15] = EnumEntry("AIS_TYPE_RESERVED_15", """""")
AIS_TYPE_RESERVED_16 = 16
enums["AIS_TYPE"][16] = EnumEntry("AIS_TYPE_RESERVED_16", """""")
AIS_TYPE_RESERVED_17 = 17
enums["AIS_TYPE"][17] = EnumEntry("AIS_TYPE_RESERVED_17", """""")
AIS_TYPE_RESERVED_18 = 18
enums["AIS_TYPE"][18] = EnumEntry("AIS_TYPE_RESERVED_18", """""")
AIS_TYPE_RESERVED_19 = 19
enums["AIS_TYPE"][19] = EnumEntry("AIS_TYPE_RESERVED_19", """""")
AIS_TYPE_WIG = 20
enums["AIS_TYPE"][20] = EnumEntry("AIS_TYPE_WIG", """Wing In Ground effect.""")
AIS_TYPE_WIG_HAZARDOUS_A = 21
enums["AIS_TYPE"][21] = EnumEntry("AIS_TYPE_WIG_HAZARDOUS_A", """""")
AIS_TYPE_WIG_HAZARDOUS_B = 22
enums["AIS_TYPE"][22] = EnumEntry("AIS_TYPE_WIG_HAZARDOUS_B", """""")
AIS_TYPE_WIG_HAZARDOUS_C = 23
enums["AIS_TYPE"][23] = EnumEntry("AIS_TYPE_WIG_HAZARDOUS_C", """""")
AIS_TYPE_WIG_HAZARDOUS_D = 24
enums["AIS_TYPE"][24] = EnumEntry("AIS_TYPE_WIG_HAZARDOUS_D", """""")
AIS_TYPE_WIG_RESERVED_1 = 25
enums["AIS_TYPE"][25] = EnumEntry("AIS_TYPE_WIG_RESERVED_1", """""")
AIS_TYPE_WIG_RESERVED_2 = 26
enums["AIS_TYPE"][26] = EnumEntry("AIS_TYPE_WIG_RESERVED_2", """""")
AIS_TYPE_WIG_RESERVED_3 = 27
enums["AIS_TYPE"][27] = EnumEntry("AIS_TYPE_WIG_RESERVED_3", """""")
AIS_TYPE_WIG_RESERVED_4 = 28
enums["AIS_TYPE"][28] = EnumEntry("AIS_TYPE_WIG_RESERVED_4", """""")
AIS_TYPE_WIG_RESERVED_5 = 29
enums["AIS_TYPE"][29] = EnumEntry("AIS_TYPE_WIG_RESERVED_5", """""")
AIS_TYPE_FISHING = 30
enums["AIS_TYPE"][30] = EnumEntry("AIS_TYPE_FISHING", """""")
AIS_TYPE_TOWING = 31
enums["AIS_TYPE"][31] = EnumEntry("AIS_TYPE_TOWING", """""")
AIS_TYPE_TOWING_LARGE = 32
enums["AIS_TYPE"][32] = EnumEntry("AIS_TYPE_TOWING_LARGE", """Towing: length exceeds 200m or breadth exceeds 25m.""")
AIS_TYPE_DREDGING = 33
enums["AIS_TYPE"][33] = EnumEntry("AIS_TYPE_DREDGING", """Dredging or other underwater ops.""")
AIS_TYPE_DIVING = 34
enums["AIS_TYPE"][34] = EnumEntry("AIS_TYPE_DIVING", """""")
AIS_TYPE_MILITARY = 35
enums["AIS_TYPE"][35] = EnumEntry("AIS_TYPE_MILITARY", """""")
AIS_TYPE_SAILING = 36
enums["AIS_TYPE"][36] = EnumEntry("AIS_TYPE_SAILING", """""")
AIS_TYPE_PLEASURE = 37
enums["AIS_TYPE"][37] = EnumEntry("AIS_TYPE_PLEASURE", """""")
AIS_TYPE_RESERVED_20 = 38
enums["AIS_TYPE"][38] = EnumEntry("AIS_TYPE_RESERVED_20", """""")
AIS_TYPE_RESERVED_21 = 39
enums["AIS_TYPE"][39] = EnumEntry("AIS_TYPE_RESERVED_21", """""")
AIS_TYPE_HSC = 40
enums["AIS_TYPE"][40] = EnumEntry("AIS_TYPE_HSC", """High Speed Craft.""")
AIS_TYPE_HSC_HAZARDOUS_A = 41
enums["AIS_TYPE"][41] = EnumEntry("AIS_TYPE_HSC_HAZARDOUS_A", """""")
AIS_TYPE_HSC_HAZARDOUS_B = 42
enums["AIS_TYPE"][42] = EnumEntry("AIS_TYPE_HSC_HAZARDOUS_B", """""")
AIS_TYPE_HSC_HAZARDOUS_C = 43
enums["AIS_TYPE"][43] = EnumEntry("AIS_TYPE_HSC_HAZARDOUS_C", """""")
AIS_TYPE_HSC_HAZARDOUS_D = 44
enums["AIS_TYPE"][44] = EnumEntry("AIS_TYPE_HSC_HAZARDOUS_D", """""")
AIS_TYPE_HSC_RESERVED_1 = 45
enums["AIS_TYPE"][45] = EnumEntry("AIS_TYPE_HSC_RESERVED_1", """""")
AIS_TYPE_HSC_RESERVED_2 = 46
enums["AIS_TYPE"][46] = EnumEntry("AIS_TYPE_HSC_RESERVED_2", """""")
AIS_TYPE_HSC_RESERVED_3 = 47
enums["AIS_TYPE"][47] = EnumEntry("AIS_TYPE_HSC_RESERVED_3", """""")
AIS_TYPE_HSC_RESERVED_4 = 48
enums["AIS_TYPE"][48] = EnumEntry("AIS_TYPE_HSC_RESERVED_4", """""")
AIS_TYPE_HSC_UNKNOWN = 49
enums["AIS_TYPE"][49] = EnumEntry("AIS_TYPE_HSC_UNKNOWN", """""")
AIS_TYPE_PILOT = 50
enums["AIS_TYPE"][50] = EnumEntry("AIS_TYPE_PILOT", """""")
AIS_TYPE_SAR = 51
enums["AIS_TYPE"][51] = EnumEntry("AIS_TYPE_SAR", """Search And Rescue vessel.""")
AIS_TYPE_TUG = 52
enums["AIS_TYPE"][52] = EnumEntry("AIS_TYPE_TUG", """""")
AIS_TYPE_PORT_TENDER = 53
enums["AIS_TYPE"][53] = EnumEntry("AIS_TYPE_PORT_TENDER", """""")
AIS_TYPE_ANTI_POLLUTION = 54
enums["AIS_TYPE"][54] = EnumEntry("AIS_TYPE_ANTI_POLLUTION", """Anti-pollution equipment.""")
AIS_TYPE_LAW_ENFORCEMENT = 55
enums["AIS_TYPE"][55] = EnumEntry("AIS_TYPE_LAW_ENFORCEMENT", """""")
AIS_TYPE_SPARE_LOCAL_1 = 56
enums["AIS_TYPE"][56] = EnumEntry("AIS_TYPE_SPARE_LOCAL_1", """""")
AIS_TYPE_SPARE_LOCAL_2 = 57
enums["AIS_TYPE"][57] = EnumEntry("AIS_TYPE_SPARE_LOCAL_2", """""")
AIS_TYPE_MEDICAL_TRANSPORT = 58
enums["AIS_TYPE"][58] = EnumEntry("AIS_TYPE_MEDICAL_TRANSPORT", """""")
AIS_TYPE_NONECOMBATANT = 59
enums["AIS_TYPE"][59] = EnumEntry("AIS_TYPE_NONECOMBATANT", """Noncombatant ship according to RR Resolution No. 18.""")
AIS_TYPE_PASSENGER = 60
enums["AIS_TYPE"][60] = EnumEntry("AIS_TYPE_PASSENGER", """""")
AIS_TYPE_PASSENGER_HAZARDOUS_A = 61
enums["AIS_TYPE"][61] = EnumEntry("AIS_TYPE_PASSENGER_HAZARDOUS_A", """""")
AIS_TYPE_PASSENGER_HAZARDOUS_B = 62
enums["AIS_TYPE"][62] = EnumEntry("AIS_TYPE_PASSENGER_HAZARDOUS_B", """""")
AIS_TYPE_AIS_TYPE_PASSENGER_HAZARDOUS_C = 63
enums["AIS_TYPE"][63] = EnumEntry("AIS_TYPE_AIS_TYPE_PASSENGER_HAZARDOUS_C", """""")
AIS_TYPE_PASSENGER_HAZARDOUS_D = 64
enums["AIS_TYPE"][64] = EnumEntry("AIS_TYPE_PASSENGER_HAZARDOUS_D", """""")
AIS_TYPE_PASSENGER_RESERVED_1 = 65
enums["AIS_TYPE"][65] = EnumEntry("AIS_TYPE_PASSENGER_RESERVED_1", """""")
AIS_TYPE_PASSENGER_RESERVED_2 = 66
enums["AIS_TYPE"][66] = EnumEntry("AIS_TYPE_PASSENGER_RESERVED_2", """""")
AIS_TYPE_PASSENGER_RESERVED_3 = 67
enums["AIS_TYPE"][67] = EnumEntry("AIS_TYPE_PASSENGER_RESERVED_3", """""")
AIS_TYPE_AIS_TYPE_PASSENGER_RESERVED_4 = 68
enums["AIS_TYPE"][68] = EnumEntry("AIS_TYPE_AIS_TYPE_PASSENGER_RESERVED_4", """""")
AIS_TYPE_PASSENGER_UNKNOWN = 69
enums["AIS_TYPE"][69] = EnumEntry("AIS_TYPE_PASSENGER_UNKNOWN", """""")
AIS_TYPE_CARGO = 70
enums["AIS_TYPE"][70] = EnumEntry("AIS_TYPE_CARGO", """""")
AIS_TYPE_CARGO_HAZARDOUS_A = 71
enums["AIS_TYPE"][71] = EnumEntry("AIS_TYPE_CARGO_HAZARDOUS_A", """""")
AIS_TYPE_CARGO_HAZARDOUS_B = 72
enums["AIS_TYPE"][72] = EnumEntry("AIS_TYPE_CARGO_HAZARDOUS_B", """""")
AIS_TYPE_CARGO_HAZARDOUS_C = 73
enums["AIS_TYPE"][73] = EnumEntry("AIS_TYPE_CARGO_HAZARDOUS_C", """""")
AIS_TYPE_CARGO_HAZARDOUS_D = 74
enums["AIS_TYPE"][74] = EnumEntry("AIS_TYPE_CARGO_HAZARDOUS_D", """""")
AIS_TYPE_CARGO_RESERVED_1 = 75
enums["AIS_TYPE"][75] = EnumEntry("AIS_TYPE_CARGO_RESERVED_1", """""")
AIS_TYPE_CARGO_RESERVED_2 = 76
enums["AIS_TYPE"][76] = EnumEntry("AIS_TYPE_CARGO_RESERVED_2", """""")
AIS_TYPE_CARGO_RESERVED_3 = 77
enums["AIS_TYPE"][77] = EnumEntry("AIS_TYPE_CARGO_RESERVED_3", """""")
AIS_TYPE_CARGO_RESERVED_4 = 78
enums["AIS_TYPE"][78] = EnumEntry("AIS_TYPE_CARGO_RESERVED_4", """""")
AIS_TYPE_CARGO_UNKNOWN = 79
enums["AIS_TYPE"][79] = EnumEntry("AIS_TYPE_CARGO_UNKNOWN", """""")
AIS_TYPE_TANKER = 80
enums["AIS_TYPE"][80] = EnumEntry("AIS_TYPE_TANKER", """""")
AIS_TYPE_TANKER_HAZARDOUS_A = 81
enums["AIS_TYPE"][81] = EnumEntry("AIS_TYPE_TANKER_HAZARDOUS_A", """""")
AIS_TYPE_TANKER_HAZARDOUS_B = 82
enums["AIS_TYPE"][82] = EnumEntry("AIS_TYPE_TANKER_HAZARDOUS_B", """""")
AIS_TYPE_TANKER_HAZARDOUS_C = 83
enums["AIS_TYPE"][83] = EnumEntry("AIS_TYPE_TANKER_HAZARDOUS_C", """""")
AIS_TYPE_TANKER_HAZARDOUS_D = 84
enums["AIS_TYPE"][84] = EnumEntry("AIS_TYPE_TANKER_HAZARDOUS_D", """""")
AIS_TYPE_TANKER_RESERVED_1 = 85
enums["AIS_TYPE"][85] = EnumEntry("AIS_TYPE_TANKER_RESERVED_1", """""")
AIS_TYPE_TANKER_RESERVED_2 = 86
enums["AIS_TYPE"][86] = EnumEntry("AIS_TYPE_TANKER_RESERVED_2", """""")
AIS_TYPE_TANKER_RESERVED_3 = 87
enums["AIS_TYPE"][87] = EnumEntry("AIS_TYPE_TANKER_RESERVED_3", """""")
AIS_TYPE_TANKER_RESERVED_4 = 88
enums["AIS_TYPE"][88] = EnumEntry("AIS_TYPE_TANKER_RESERVED_4", """""")
AIS_TYPE_TANKER_UNKNOWN = 89
enums["AIS_TYPE"][89] = EnumEntry("AIS_TYPE_TANKER_UNKNOWN", """""")
AIS_TYPE_OTHER = 90
enums["AIS_TYPE"][90] = EnumEntry("AIS_TYPE_OTHER", """""")
AIS_TYPE_OTHER_HAZARDOUS_A = 91
enums["AIS_TYPE"][91] = EnumEntry("AIS_TYPE_OTHER_HAZARDOUS_A", """""")
AIS_TYPE_OTHER_HAZARDOUS_B = 92
enums["AIS_TYPE"][92] = EnumEntry("AIS_TYPE_OTHER_HAZARDOUS_B", """""")
AIS_TYPE_OTHER_HAZARDOUS_C = 93
enums["AIS_TYPE"][93] = EnumEntry("AIS_TYPE_OTHER_HAZARDOUS_C", """""")
AIS_TYPE_OTHER_HAZARDOUS_D = 94
enums["AIS_TYPE"][94] = EnumEntry("AIS_TYPE_OTHER_HAZARDOUS_D", """""")
AIS_TYPE_OTHER_RESERVED_1 = 95
enums["AIS_TYPE"][95] = EnumEntry("AIS_TYPE_OTHER_RESERVED_1", """""")
AIS_TYPE_OTHER_RESERVED_2 = 96
enums["AIS_TYPE"][96] = EnumEntry("AIS_TYPE_OTHER_RESERVED_2", """""")
AIS_TYPE_OTHER_RESERVED_3 = 97
enums["AIS_TYPE"][97] = EnumEntry("AIS_TYPE_OTHER_RESERVED_3", """""")
AIS_TYPE_OTHER_RESERVED_4 = 98
enums["AIS_TYPE"][98] = EnumEntry("AIS_TYPE_OTHER_RESERVED_4", """""")
AIS_TYPE_OTHER_UNKNOWN = 99
enums["AIS_TYPE"][99] = EnumEntry("AIS_TYPE_OTHER_UNKNOWN", """""")
AIS_TYPE_ENUM_END = 100
enums["AIS_TYPE"][100] = EnumEntry("AIS_TYPE_ENUM_END", """""")

# AIS_NAV_STATUS
enums["AIS_NAV_STATUS"] = Enum()
enums["AIS_NAV_STATUS"].bitmask = False
UNDER_WAY = 0
enums["AIS_NAV_STATUS"][0] = EnumEntry("UNDER_WAY", """Under way using engine.""")
AIS_NAV_ANCHORED = 1
enums["AIS_NAV_STATUS"][1] = EnumEntry("AIS_NAV_ANCHORED", """""")
AIS_NAV_UN_COMMANDED = 2
enums["AIS_NAV_STATUS"][2] = EnumEntry("AIS_NAV_UN_COMMANDED", """""")
AIS_NAV_RESTRICTED_MANOEUVERABILITY = 3
enums["AIS_NAV_STATUS"][3] = EnumEntry("AIS_NAV_RESTRICTED_MANOEUVERABILITY", """""")
AIS_NAV_DRAUGHT_CONSTRAINED = 4
enums["AIS_NAV_STATUS"][4] = EnumEntry("AIS_NAV_DRAUGHT_CONSTRAINED", """""")
AIS_NAV_MOORED = 5
enums["AIS_NAV_STATUS"][5] = EnumEntry("AIS_NAV_MOORED", """""")
AIS_NAV_AGROUND = 6
enums["AIS_NAV_STATUS"][6] = EnumEntry("AIS_NAV_AGROUND", """""")
AIS_NAV_FISHING = 7
enums["AIS_NAV_STATUS"][7] = EnumEntry("AIS_NAV_FISHING", """""")
AIS_NAV_SAILING = 8
enums["AIS_NAV_STATUS"][8] = EnumEntry("AIS_NAV_SAILING", """""")
AIS_NAV_RESERVED_HSC = 9
enums["AIS_NAV_STATUS"][9] = EnumEntry("AIS_NAV_RESERVED_HSC", """""")
AIS_NAV_RESERVED_WIG = 10
enums["AIS_NAV_STATUS"][10] = EnumEntry("AIS_NAV_RESERVED_WIG", """""")
AIS_NAV_RESERVED_1 = 11
enums["AIS_NAV_STATUS"][11] = EnumEntry("AIS_NAV_RESERVED_1", """""")
AIS_NAV_RESERVED_2 = 12
enums["AIS_NAV_STATUS"][12] = EnumEntry("AIS_NAV_RESERVED_2", """""")
AIS_NAV_RESERVED_3 = 13
enums["AIS_NAV_STATUS"][13] = EnumEntry("AIS_NAV_RESERVED_3", """""")
AIS_NAV_AIS_SART = 14
enums["AIS_NAV_STATUS"][14] = EnumEntry("AIS_NAV_AIS_SART", """Search And Rescue Transponder.""")
AIS_NAV_UNKNOWN = 15
enums["AIS_NAV_STATUS"][15] = EnumEntry("AIS_NAV_UNKNOWN", """Not available (default).""")
AIS_NAV_STATUS_ENUM_END = 16
enums["AIS_NAV_STATUS"][16] = EnumEntry("AIS_NAV_STATUS_ENUM_END", """""")

# AIS_FLAGS
enums["AIS_FLAGS"] = Enum()
enums["AIS_FLAGS"].bitmask = True
AIS_FLAGS_POSITION_ACCURACY = 1
enums["AIS_FLAGS"][1] = EnumEntry("AIS_FLAGS_POSITION_ACCURACY", """1 = Position accuracy less than 10m, 0 = position accuracy greater than 10m.""")
AIS_FLAGS_VALID_COG = 2
enums["AIS_FLAGS"][2] = EnumEntry("AIS_FLAGS_VALID_COG", """""")
AIS_FLAGS_VALID_VELOCITY = 4
enums["AIS_FLAGS"][4] = EnumEntry("AIS_FLAGS_VALID_VELOCITY", """""")
AIS_FLAGS_HIGH_VELOCITY = 8
enums["AIS_FLAGS"][8] = EnumEntry("AIS_FLAGS_HIGH_VELOCITY", """1 = Velocity over 52.5765m/s (102.2 knots)""")
AIS_FLAGS_VALID_TURN_RATE = 16
enums["AIS_FLAGS"][16] = EnumEntry("AIS_FLAGS_VALID_TURN_RATE", """""")
AIS_FLAGS_TURN_RATE_SIGN_ONLY = 32
enums["AIS_FLAGS"][32] = EnumEntry("AIS_FLAGS_TURN_RATE_SIGN_ONLY", """Only the sign of the returned turn rate value is valid, either greater than 5deg/30s or less than -5deg/30s""")
AIS_FLAGS_VALID_DIMENSIONS = 64
enums["AIS_FLAGS"][64] = EnumEntry("AIS_FLAGS_VALID_DIMENSIONS", """""")
AIS_FLAGS_LARGE_BOW_DIMENSION = 128
enums["AIS_FLAGS"][128] = EnumEntry("AIS_FLAGS_LARGE_BOW_DIMENSION", """Distance to bow is larger than 511m""")
AIS_FLAGS_LARGE_STERN_DIMENSION = 256
enums["AIS_FLAGS"][256] = EnumEntry("AIS_FLAGS_LARGE_STERN_DIMENSION", """Distance to stern is larger than 511m""")
AIS_FLAGS_LARGE_PORT_DIMENSION = 512
enums["AIS_FLAGS"][512] = EnumEntry("AIS_FLAGS_LARGE_PORT_DIMENSION", """Distance to port side is larger than 63m""")
AIS_FLAGS_LARGE_STARBOARD_DIMENSION = 1024
enums["AIS_FLAGS"][1024] = EnumEntry("AIS_FLAGS_LARGE_STARBOARD_DIMENSION", """Distance to starboard side is larger than 63m""")
AIS_FLAGS_VALID_CALLSIGN = 2048
enums["AIS_FLAGS"][2048] = EnumEntry("AIS_FLAGS_VALID_CALLSIGN", """""")
AIS_FLAGS_VALID_NAME = 4096
enums["AIS_FLAGS"][4096] = EnumEntry("AIS_FLAGS_VALID_NAME", """""")
AIS_FLAGS_ENUM_END = 4097
enums["AIS_FLAGS"][4097] = EnumEntry("AIS_FLAGS_ENUM_END", """""")

# MAV_WINCH_STATUS_FLAG
enums["MAV_WINCH_STATUS_FLAG"] = Enum()
enums["MAV_WINCH_STATUS_FLAG"].bitmask = True
MAV_WINCH_STATUS_HEALTHY = 1
enums["MAV_WINCH_STATUS_FLAG"][1] = EnumEntry("MAV_WINCH_STATUS_HEALTHY", """Winch is healthy""")
MAV_WINCH_STATUS_FULLY_RETRACTED = 2
enums["MAV_WINCH_STATUS_FLAG"][2] = EnumEntry("MAV_WINCH_STATUS_FULLY_RETRACTED", """Winch thread is fully retracted""")
MAV_WINCH_STATUS_MOVING = 4
enums["MAV_WINCH_STATUS_FLAG"][4] = EnumEntry("MAV_WINCH_STATUS_MOVING", """Winch motor is moving""")
MAV_WINCH_STATUS_CLUTCH_ENGAGED = 8
enums["MAV_WINCH_STATUS_FLAG"][8] = EnumEntry("MAV_WINCH_STATUS_CLUTCH_ENGAGED", """Winch clutch is engaged allowing motor to move freely""")
MAV_WINCH_STATUS_FLAG_ENUM_END = 9
enums["MAV_WINCH_STATUS_FLAG"][9] = EnumEntry("MAV_WINCH_STATUS_FLAG_ENUM_END", """""")

# MAG_CAL_STATUS
enums["MAG_CAL_STATUS"] = Enum()
enums["MAG_CAL_STATUS"].bitmask = False
MAG_CAL_NOT_STARTED = 0
enums["MAG_CAL_STATUS"][0] = EnumEntry("MAG_CAL_NOT_STARTED", """""")
MAG_CAL_WAITING_TO_START = 1
enums["MAG_CAL_STATUS"][1] = EnumEntry("MAG_CAL_WAITING_TO_START", """""")
MAG_CAL_RUNNING_STEP_ONE = 2
enums["MAG_CAL_STATUS"][2] = EnumEntry("MAG_CAL_RUNNING_STEP_ONE", """""")
MAG_CAL_RUNNING_STEP_TWO = 3
enums["MAG_CAL_STATUS"][3] = EnumEntry("MAG_CAL_RUNNING_STEP_TWO", """""")
MAG_CAL_SUCCESS = 4
enums["MAG_CAL_STATUS"][4] = EnumEntry("MAG_CAL_SUCCESS", """""")
MAG_CAL_FAILED = 5
enums["MAG_CAL_STATUS"][5] = EnumEntry("MAG_CAL_FAILED", """""")
MAG_CAL_BAD_ORIENTATION = 6
enums["MAG_CAL_STATUS"][6] = EnumEntry("MAG_CAL_BAD_ORIENTATION", """""")
MAG_CAL_BAD_RADIUS = 7
enums["MAG_CAL_STATUS"][7] = EnumEntry("MAG_CAL_BAD_RADIUS", """""")
MAG_CAL_STATUS_ENUM_END = 8
enums["MAG_CAL_STATUS"][8] = EnumEntry("MAG_CAL_STATUS_ENUM_END", """""")

# CAN_FILTER_OP
enums["CAN_FILTER_OP"] = Enum()
enums["CAN_FILTER_OP"].bitmask = False
CAN_FILTER_REPLACE = 0
enums["CAN_FILTER_OP"][0] = EnumEntry("CAN_FILTER_REPLACE", """""")
CAN_FILTER_ADD = 1
enums["CAN_FILTER_OP"][1] = EnumEntry("CAN_FILTER_ADD", """""")
CAN_FILTER_REMOVE = 2
enums["CAN_FILTER_OP"][2] = EnumEntry("CAN_FILTER_REMOVE", """""")
CAN_FILTER_OP_ENUM_END = 3
enums["CAN_FILTER_OP"][3] = EnumEntry("CAN_FILTER_OP_ENUM_END", """""")

# NAV_VTOL_LAND_OPTIONS
enums["NAV_VTOL_LAND_OPTIONS"] = Enum()
enums["NAV_VTOL_LAND_OPTIONS"].bitmask = False
NAV_VTOL_LAND_OPTIONS_DEFAULT = 0
enums["NAV_VTOL_LAND_OPTIONS"][0] = EnumEntry("NAV_VTOL_LAND_OPTIONS_DEFAULT", """Default autopilot landing behaviour.""")
NAV_VTOL_LAND_OPTIONS_FW_SPIRAL_APPROACH = 1
enums["NAV_VTOL_LAND_OPTIONS"][1] = EnumEntry("NAV_VTOL_LAND_OPTIONS_FW_SPIRAL_APPROACH", """Use a fixed wing spiral desent approach before landing.""")
NAV_VTOL_LAND_OPTIONS_FW_APPROACH = 2
enums["NAV_VTOL_LAND_OPTIONS"][2] = EnumEntry("NAV_VTOL_LAND_OPTIONS_FW_APPROACH", """Use a fixed wing approach before detransitioning and landing vertically.""")
NAV_VTOL_LAND_OPTIONS_ENUM_END = 3
enums["NAV_VTOL_LAND_OPTIONS"][3] = EnumEntry("NAV_VTOL_LAND_OPTIONS_ENUM_END", """""")

# MISSION_STATE
enums["MISSION_STATE"] = Enum()
enums["MISSION_STATE"].bitmask = False
MISSION_STATE_UNKNOWN = 0
enums["MISSION_STATE"][0] = EnumEntry("MISSION_STATE_UNKNOWN", """The mission status reporting is not supported.""")
MISSION_STATE_NO_MISSION = 1
enums["MISSION_STATE"][1] = EnumEntry("MISSION_STATE_NO_MISSION", """No mission on the vehicle.""")
MISSION_STATE_NOT_STARTED = 2
enums["MISSION_STATE"][2] = EnumEntry("MISSION_STATE_NOT_STARTED", """Mission has not started. This is the case after a mission has uploaded but not yet started executing.""")
MISSION_STATE_ACTIVE = 3
enums["MISSION_STATE"][3] = EnumEntry("MISSION_STATE_ACTIVE", """Mission is active, and will execute mission items when in auto mode.""")
MISSION_STATE_PAUSED = 4
enums["MISSION_STATE"][4] = EnumEntry("MISSION_STATE_PAUSED", """Mission is paused when in auto mode.""")
MISSION_STATE_COMPLETE = 5
enums["MISSION_STATE"][5] = EnumEntry("MISSION_STATE_COMPLETE", """Mission has executed all mission items.""")
MISSION_STATE_ENUM_END = 6
enums["MISSION_STATE"][6] = EnumEntry("MISSION_STATE_ENUM_END", """""")

# SAFETY_SWITCH_STATE
enums["SAFETY_SWITCH_STATE"] = Enum()
enums["SAFETY_SWITCH_STATE"].bitmask = False
SAFETY_SWITCH_STATE_SAFE = 0
enums["SAFETY_SWITCH_STATE"][0] = EnumEntry("SAFETY_SWITCH_STATE_SAFE", """Safety switch is engaged and vehicle should be safe to approach.""")
SAFETY_SWITCH_STATE_DANGEROUS = 1
enums["SAFETY_SWITCH_STATE"][1] = EnumEntry("SAFETY_SWITCH_STATE_DANGEROUS", """Safety switch is NOT engaged and motors, propellers and other actuators should be considered active.""")
SAFETY_SWITCH_STATE_ENUM_END = 2
enums["SAFETY_SWITCH_STATE"][2] = EnumEntry("SAFETY_SWITCH_STATE_ENUM_END", """""")

# MAV_BOOL
enums["MAV_BOOL"] = Enum()
enums["MAV_BOOL"].bitmask = True
MAV_BOOL_FALSE = 0
enums["MAV_BOOL"][0] = EnumEntry("MAV_BOOL_FALSE", """False.""")
MAV_BOOL_TRUE = 1
enums["MAV_BOOL"][1] = EnumEntry("MAV_BOOL_TRUE", """True.""")
MAV_BOOL_ENUM_END = 2
enums["MAV_BOOL"][2] = EnumEntry("MAV_BOOL_ENUM_END", """""")

# MAV_AUTOPILOT
enums["MAV_AUTOPILOT"] = Enum()
enums["MAV_AUTOPILOT"].bitmask = False
MAV_AUTOPILOT_GENERIC = 0
enums["MAV_AUTOPILOT"][0] = EnumEntry("MAV_AUTOPILOT_GENERIC", """Generic autopilot, full support for everything""")
MAV_AUTOPILOT_RESERVED = 1
enums["MAV_AUTOPILOT"][1] = EnumEntry("MAV_AUTOPILOT_RESERVED", """Reserved for future use.""")
MAV_AUTOPILOT_SLUGS = 2
enums["MAV_AUTOPILOT"][2] = EnumEntry("MAV_AUTOPILOT_SLUGS", """SLUGS autopilot, http://slugsuav.soe.ucsc.edu""")
MAV_AUTOPILOT_ARDUPILOTMEGA = 3
enums["MAV_AUTOPILOT"][3] = EnumEntry("MAV_AUTOPILOT_ARDUPILOTMEGA", """ArduPilot - Plane/Copter/Rover/Sub/Tracker, https://ardupilot.org""")
MAV_AUTOPILOT_OPENPILOT = 4
enums["MAV_AUTOPILOT"][4] = EnumEntry("MAV_AUTOPILOT_OPENPILOT", """OpenPilot, http://openpilot.org""")
MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY = 5
enums["MAV_AUTOPILOT"][5] = EnumEntry("MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY", """Generic autopilot only supporting simple waypoints""")
MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY = 6
enums["MAV_AUTOPILOT"][6] = EnumEntry("MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY", """Generic autopilot supporting waypoints and other simple navigation commands""")
MAV_AUTOPILOT_GENERIC_MISSION_FULL = 7
enums["MAV_AUTOPILOT"][7] = EnumEntry("MAV_AUTOPILOT_GENERIC_MISSION_FULL", """Generic autopilot supporting the full mission command set""")
MAV_AUTOPILOT_INVALID = 8
enums["MAV_AUTOPILOT"][8] = EnumEntry("MAV_AUTOPILOT_INVALID", """No valid autopilot, e.g. a GCS or other MAVLink component""")
MAV_AUTOPILOT_PPZ = 9
enums["MAV_AUTOPILOT"][9] = EnumEntry("MAV_AUTOPILOT_PPZ", """PPZ UAV - http://nongnu.org/paparazzi""")
MAV_AUTOPILOT_UDB = 10
enums["MAV_AUTOPILOT"][10] = EnumEntry("MAV_AUTOPILOT_UDB", """UAV Dev Board""")
MAV_AUTOPILOT_FP = 11
enums["MAV_AUTOPILOT"][11] = EnumEntry("MAV_AUTOPILOT_FP", """FlexiPilot""")
MAV_AUTOPILOT_PX4 = 12
enums["MAV_AUTOPILOT"][12] = EnumEntry("MAV_AUTOPILOT_PX4", """PX4 Autopilot - http://px4.io/""")
MAV_AUTOPILOT_SMACCMPILOT = 13
enums["MAV_AUTOPILOT"][13] = EnumEntry("MAV_AUTOPILOT_SMACCMPILOT", """SMACCMPilot - http://smaccmpilot.org""")
MAV_AUTOPILOT_AUTOQUAD = 14
enums["MAV_AUTOPILOT"][14] = EnumEntry("MAV_AUTOPILOT_AUTOQUAD", """AutoQuad -- http://autoquad.org""")
MAV_AUTOPILOT_ARMAZILA = 15
enums["MAV_AUTOPILOT"][15] = EnumEntry("MAV_AUTOPILOT_ARMAZILA", """Armazila -- http://armazila.com""")
MAV_AUTOPILOT_AEROB = 16
enums["MAV_AUTOPILOT"][16] = EnumEntry("MAV_AUTOPILOT_AEROB", """Aerob -- http://aerob.ru""")
MAV_AUTOPILOT_ASLUAV = 17
enums["MAV_AUTOPILOT"][17] = EnumEntry("MAV_AUTOPILOT_ASLUAV", """ASLUAV autopilot -- http://www.asl.ethz.ch""")
MAV_AUTOPILOT_SMARTAP = 18
enums["MAV_AUTOPILOT"][18] = EnumEntry("MAV_AUTOPILOT_SMARTAP", """SmartAP Autopilot - http://sky-drones.com""")
MAV_AUTOPILOT_AIRRAILS = 19
enums["MAV_AUTOPILOT"][19] = EnumEntry("MAV_AUTOPILOT_AIRRAILS", """AirRails - http://uaventure.com""")
MAV_AUTOPILOT_REFLEX = 20
enums["MAV_AUTOPILOT"][20] = EnumEntry("MAV_AUTOPILOT_REFLEX", """Fusion Reflex - https://fusion.engineering""")
MAV_AUTOPILOT_ENUM_END = 21
enums["MAV_AUTOPILOT"][21] = EnumEntry("MAV_AUTOPILOT_ENUM_END", """""")

# MAV_TYPE
enums["MAV_TYPE"] = Enum()
enums["MAV_TYPE"].bitmask = False
MAV_TYPE_GENERIC = 0
enums["MAV_TYPE"][0] = EnumEntry("MAV_TYPE_GENERIC", """Generic micro air vehicle""")
MAV_TYPE_FIXED_WING = 1
enums["MAV_TYPE"][1] = EnumEntry("MAV_TYPE_FIXED_WING", """Fixed wing aircraft.""")
MAV_TYPE_QUADROTOR = 2
enums["MAV_TYPE"][2] = EnumEntry("MAV_TYPE_QUADROTOR", """Quadrotor""")
MAV_TYPE_COAXIAL = 3
enums["MAV_TYPE"][3] = EnumEntry("MAV_TYPE_COAXIAL", """Coaxial helicopter""")
MAV_TYPE_HELICOPTER = 4
enums["MAV_TYPE"][4] = EnumEntry("MAV_TYPE_HELICOPTER", """Normal helicopter with tail rotor.""")
MAV_TYPE_ANTENNA_TRACKER = 5
enums["MAV_TYPE"][5] = EnumEntry("MAV_TYPE_ANTENNA_TRACKER", """Ground installation""")
MAV_TYPE_GCS = 6
enums["MAV_TYPE"][6] = EnumEntry("MAV_TYPE_GCS", """Operator control unit / ground control station""")
MAV_TYPE_AIRSHIP = 7
enums["MAV_TYPE"][7] = EnumEntry("MAV_TYPE_AIRSHIP", """Airship, controlled""")
MAV_TYPE_FREE_BALLOON = 8
enums["MAV_TYPE"][8] = EnumEntry("MAV_TYPE_FREE_BALLOON", """Free balloon, uncontrolled""")
MAV_TYPE_ROCKET = 9
enums["MAV_TYPE"][9] = EnumEntry("MAV_TYPE_ROCKET", """Rocket""")
MAV_TYPE_GROUND_ROVER = 10
enums["MAV_TYPE"][10] = EnumEntry("MAV_TYPE_GROUND_ROVER", """Ground rover""")
MAV_TYPE_SURFACE_BOAT = 11
enums["MAV_TYPE"][11] = EnumEntry("MAV_TYPE_SURFACE_BOAT", """Surface vessel, boat, ship""")
MAV_TYPE_SUBMARINE = 12
enums["MAV_TYPE"][12] = EnumEntry("MAV_TYPE_SUBMARINE", """Submarine""")
MAV_TYPE_HEXAROTOR = 13
enums["MAV_TYPE"][13] = EnumEntry("MAV_TYPE_HEXAROTOR", """Hexarotor""")
MAV_TYPE_OCTOROTOR = 14
enums["MAV_TYPE"][14] = EnumEntry("MAV_TYPE_OCTOROTOR", """Octorotor""")
MAV_TYPE_TRICOPTER = 15
enums["MAV_TYPE"][15] = EnumEntry("MAV_TYPE_TRICOPTER", """Tricopter""")
MAV_TYPE_FLAPPING_WING = 16
enums["MAV_TYPE"][16] = EnumEntry("MAV_TYPE_FLAPPING_WING", """Flapping wing""")
MAV_TYPE_KITE = 17
enums["MAV_TYPE"][17] = EnumEntry("MAV_TYPE_KITE", """Kite""")
MAV_TYPE_ONBOARD_CONTROLLER = 18
enums["MAV_TYPE"][18] = EnumEntry("MAV_TYPE_ONBOARD_CONTROLLER", """Onboard companion controller""")
MAV_TYPE_VTOL_DUOROTOR = 19
enums["MAV_TYPE"][19] = EnumEntry("MAV_TYPE_VTOL_DUOROTOR", """Two-rotor VTOL using control surfaces in vertical operation in addition. Tailsitter.""")
MAV_TYPE_VTOL_QUADROTOR = 20
enums["MAV_TYPE"][20] = EnumEntry("MAV_TYPE_VTOL_QUADROTOR", """Quad-rotor VTOL using a V-shaped quad config in vertical operation. Tailsitter.""")
MAV_TYPE_VTOL_TILTROTOR = 21
enums["MAV_TYPE"][21] = EnumEntry("MAV_TYPE_VTOL_TILTROTOR", """Tiltrotor VTOL""")
MAV_TYPE_VTOL_RESERVED2 = 22
enums["MAV_TYPE"][22] = EnumEntry("MAV_TYPE_VTOL_RESERVED2", """VTOL reserved 2""")
MAV_TYPE_VTOL_RESERVED3 = 23
enums["MAV_TYPE"][23] = EnumEntry("MAV_TYPE_VTOL_RESERVED3", """VTOL reserved 3""")
MAV_TYPE_VTOL_RESERVED4 = 24
enums["MAV_TYPE"][24] = EnumEntry("MAV_TYPE_VTOL_RESERVED4", """VTOL reserved 4""")
MAV_TYPE_VTOL_RESERVED5 = 25
enums["MAV_TYPE"][25] = EnumEntry("MAV_TYPE_VTOL_RESERVED5", """VTOL reserved 5""")
MAV_TYPE_GIMBAL = 26
enums["MAV_TYPE"][26] = EnumEntry("MAV_TYPE_GIMBAL", """Gimbal""")
MAV_TYPE_ADSB = 27
enums["MAV_TYPE"][27] = EnumEntry("MAV_TYPE_ADSB", """ADSB system""")
MAV_TYPE_PARAFOIL = 28
enums["MAV_TYPE"][28] = EnumEntry("MAV_TYPE_PARAFOIL", """Steerable, nonrigid airfoil""")
MAV_TYPE_DODECAROTOR = 29
enums["MAV_TYPE"][29] = EnumEntry("MAV_TYPE_DODECAROTOR", """Dodecarotor""")
MAV_TYPE_CAMERA = 30
enums["MAV_TYPE"][30] = EnumEntry("MAV_TYPE_CAMERA", """Camera""")
MAV_TYPE_CHARGING_STATION = 31
enums["MAV_TYPE"][31] = EnumEntry("MAV_TYPE_CHARGING_STATION", """Charging station""")
MAV_TYPE_FLARM = 32
enums["MAV_TYPE"][32] = EnumEntry("MAV_TYPE_FLARM", """FLARM collision avoidance system""")
MAV_TYPE_SERVO = 33
enums["MAV_TYPE"][33] = EnumEntry("MAV_TYPE_SERVO", """Servo""")
MAV_TYPE_ODID = 34
enums["MAV_TYPE"][34] = EnumEntry("MAV_TYPE_ODID", """Open Drone ID. See https://mavlink.io/en/services/opendroneid.html.""")
MAV_TYPE_DECAROTOR = 35
enums["MAV_TYPE"][35] = EnumEntry("MAV_TYPE_DECAROTOR", """Decarotor""")
MAV_TYPE_BATTERY = 36
enums["MAV_TYPE"][36] = EnumEntry("MAV_TYPE_BATTERY", """Battery""")
MAV_TYPE_PARACHUTE = 37
enums["MAV_TYPE"][37] = EnumEntry("MAV_TYPE_PARACHUTE", """Parachute""")
MAV_TYPE_LOG = 38
enums["MAV_TYPE"][38] = EnumEntry("MAV_TYPE_LOG", """Log""")
MAV_TYPE_OSD = 39
enums["MAV_TYPE"][39] = EnumEntry("MAV_TYPE_OSD", """OSD""")
MAV_TYPE_IMU = 40
enums["MAV_TYPE"][40] = EnumEntry("MAV_TYPE_IMU", """IMU""")
MAV_TYPE_GPS = 41
enums["MAV_TYPE"][41] = EnumEntry("MAV_TYPE_GPS", """GPS""")
MAV_TYPE_WINCH = 42
enums["MAV_TYPE"][42] = EnumEntry("MAV_TYPE_WINCH", """Winch""")
MAV_TYPE_ENUM_END = 43
enums["MAV_TYPE"][43] = EnumEntry("MAV_TYPE_ENUM_END", """""")

# MAV_MODE_FLAG
enums["MAV_MODE_FLAG"] = Enum()
enums["MAV_MODE_FLAG"].bitmask = True
MAV_MODE_FLAG_CUSTOM_MODE_ENABLED = 1
enums["MAV_MODE_FLAG"][1] = EnumEntry("MAV_MODE_FLAG_CUSTOM_MODE_ENABLED", """0b00000001 Reserved for future use.""")
MAV_MODE_FLAG_TEST_ENABLED = 2
enums["MAV_MODE_FLAG"][2] = EnumEntry("MAV_MODE_FLAG_TEST_ENABLED", """0b00000010 system has a test mode enabled. This flag is intended for temporary system tests and should not be used for stable implementations.""")
MAV_MODE_FLAG_AUTO_ENABLED = 4
enums["MAV_MODE_FLAG"][4] = EnumEntry("MAV_MODE_FLAG_AUTO_ENABLED", """0b00000100 autonomous mode enabled, system finds its own goal positions. Guided flag can be set or not, depends on the actual implementation.""")
MAV_MODE_FLAG_GUIDED_ENABLED = 8
enums["MAV_MODE_FLAG"][8] = EnumEntry("MAV_MODE_FLAG_GUIDED_ENABLED", """0b00001000 guided mode enabled, system flies waypoints / mission items.""")
MAV_MODE_FLAG_STABILIZE_ENABLED = 16
enums["MAV_MODE_FLAG"][16] = EnumEntry("MAV_MODE_FLAG_STABILIZE_ENABLED", """0b00010000 system stabilizes electronically its attitude (and optionally position). It needs however further control inputs to move around.""")
MAV_MODE_FLAG_HIL_ENABLED = 32
enums["MAV_MODE_FLAG"][32] = EnumEntry("MAV_MODE_FLAG_HIL_ENABLED", """0b00100000 hardware in the loop simulation. All motors / actuators are blocked, but internal software is full operational.""")
MAV_MODE_FLAG_MANUAL_INPUT_ENABLED = 64
enums["MAV_MODE_FLAG"][64] = EnumEntry("MAV_MODE_FLAG_MANUAL_INPUT_ENABLED", """0b01000000 remote control input is enabled.""")
MAV_MODE_FLAG_SAFETY_ARMED = 128
enums["MAV_MODE_FLAG"][128] = EnumEntry("MAV_MODE_FLAG_SAFETY_ARMED", """0b10000000 MAV safety set to armed. Motors are enabled / running / can start. Ready to fly. Additional note: this flag is to be ignore when sent in the command MAV_CMD_DO_SET_MODE and MAV_CMD_COMPONENT_ARM_DISARM shall be used instead. The flag can still be used to report the armed state.""")
MAV_MODE_FLAG_ENUM_END = 129
enums["MAV_MODE_FLAG"][129] = EnumEntry("MAV_MODE_FLAG_ENUM_END", """""")

# MAV_MODE_FLAG_DECODE_POSITION
enums["MAV_MODE_FLAG_DECODE_POSITION"] = Enum()
enums["MAV_MODE_FLAG_DECODE_POSITION"].bitmask = True
MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE = 1
enums["MAV_MODE_FLAG_DECODE_POSITION"][1] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE", """Eighth bit: 00000001""")
MAV_MODE_FLAG_DECODE_POSITION_TEST = 2
enums["MAV_MODE_FLAG_DECODE_POSITION"][2] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_TEST", """Seventh bit: 00000010""")
MAV_MODE_FLAG_DECODE_POSITION_AUTO = 4
enums["MAV_MODE_FLAG_DECODE_POSITION"][4] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_AUTO", """Sixth bit:   00000100""")
MAV_MODE_FLAG_DECODE_POSITION_GUIDED = 8
enums["MAV_MODE_FLAG_DECODE_POSITION"][8] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_GUIDED", """Fifth bit:  00001000""")
MAV_MODE_FLAG_DECODE_POSITION_STABILIZE = 16
enums["MAV_MODE_FLAG_DECODE_POSITION"][16] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_STABILIZE", """Fourth bit: 00010000""")
MAV_MODE_FLAG_DECODE_POSITION_HIL = 32
enums["MAV_MODE_FLAG_DECODE_POSITION"][32] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_HIL", """Third bit:  00100000""")
MAV_MODE_FLAG_DECODE_POSITION_MANUAL = 64
enums["MAV_MODE_FLAG_DECODE_POSITION"][64] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_MANUAL", """Second bit: 01000000""")
MAV_MODE_FLAG_DECODE_POSITION_SAFETY = 128
enums["MAV_MODE_FLAG_DECODE_POSITION"][128] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_SAFETY", """First bit:  10000000""")
MAV_MODE_FLAG_DECODE_POSITION_ENUM_END = 129
enums["MAV_MODE_FLAG_DECODE_POSITION"][129] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_ENUM_END", """""")

# MAV_STATE
enums["MAV_STATE"] = Enum()
enums["MAV_STATE"].bitmask = False
MAV_STATE_UNINIT = 0
enums["MAV_STATE"][0] = EnumEntry("MAV_STATE_UNINIT", """Uninitialized system, state is unknown.""")
MAV_STATE_BOOT = 1
enums["MAV_STATE"][1] = EnumEntry("MAV_STATE_BOOT", """System is booting up.""")
MAV_STATE_CALIBRATING = 2
enums["MAV_STATE"][2] = EnumEntry("MAV_STATE_CALIBRATING", """System is calibrating and not flight-ready.""")
MAV_STATE_STANDBY = 3
enums["MAV_STATE"][3] = EnumEntry("MAV_STATE_STANDBY", """System is grounded and on standby. It can be launched any time.""")
MAV_STATE_ACTIVE = 4
enums["MAV_STATE"][4] = EnumEntry("MAV_STATE_ACTIVE", """System is active and might be already airborne. Motors are engaged.""")
MAV_STATE_CRITICAL = 5
enums["MAV_STATE"][5] = EnumEntry("MAV_STATE_CRITICAL", """System is in a non-normal flight mode. It can however still navigate.""")
MAV_STATE_EMERGENCY = 6
enums["MAV_STATE"][6] = EnumEntry("MAV_STATE_EMERGENCY", """System is in a non-normal flight mode. It lost control over parts or over the whole airframe. It is in mayday and going down.""")
MAV_STATE_POWEROFF = 7
enums["MAV_STATE"][7] = EnumEntry("MAV_STATE_POWEROFF", """System just initialized its power-down sequence, will shut down now.""")
MAV_STATE_FLIGHT_TERMINATION = 8
enums["MAV_STATE"][8] = EnumEntry("MAV_STATE_FLIGHT_TERMINATION", """System is terminating itself.""")
MAV_STATE_ENUM_END = 9
enums["MAV_STATE"][9] = EnumEntry("MAV_STATE_ENUM_END", """""")

# MAV_COMPONENT
enums["MAV_COMPONENT"] = Enum()
enums["MAV_COMPONENT"].bitmask = False
MAV_COMP_ID_ALL = 0
enums["MAV_COMPONENT"][0] = EnumEntry("MAV_COMP_ID_ALL", """Target id (target_component) used to broadcast messages to all components of the receiving system. Components should attempt to process messages with this component ID and forward to components on any other interfaces. Note: This is not a valid *source* component id for a message.""")
MAV_COMP_ID_AUTOPILOT1 = 1
enums["MAV_COMPONENT"][1] = EnumEntry("MAV_COMP_ID_AUTOPILOT1", """System flight controller component ("autopilot"). Only one autopilot is expected in a particular system.""")
MAV_COMP_ID_USER1 = 25
enums["MAV_COMPONENT"][25] = EnumEntry("MAV_COMP_ID_USER1", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER2 = 26
enums["MAV_COMPONENT"][26] = EnumEntry("MAV_COMP_ID_USER2", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER3 = 27
enums["MAV_COMPONENT"][27] = EnumEntry("MAV_COMP_ID_USER3", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER4 = 28
enums["MAV_COMPONENT"][28] = EnumEntry("MAV_COMP_ID_USER4", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER5 = 29
enums["MAV_COMPONENT"][29] = EnumEntry("MAV_COMP_ID_USER5", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER6 = 30
enums["MAV_COMPONENT"][30] = EnumEntry("MAV_COMP_ID_USER6", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER7 = 31
enums["MAV_COMPONENT"][31] = EnumEntry("MAV_COMP_ID_USER7", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER8 = 32
enums["MAV_COMPONENT"][32] = EnumEntry("MAV_COMP_ID_USER8", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER9 = 33
enums["MAV_COMPONENT"][33] = EnumEntry("MAV_COMP_ID_USER9", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER10 = 34
enums["MAV_COMPONENT"][34] = EnumEntry("MAV_COMP_ID_USER10", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER11 = 35
enums["MAV_COMPONENT"][35] = EnumEntry("MAV_COMP_ID_USER11", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER12 = 36
enums["MAV_COMPONENT"][36] = EnumEntry("MAV_COMP_ID_USER12", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER13 = 37
enums["MAV_COMPONENT"][37] = EnumEntry("MAV_COMP_ID_USER13", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER14 = 38
enums["MAV_COMPONENT"][38] = EnumEntry("MAV_COMP_ID_USER14", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER15 = 39
enums["MAV_COMPONENT"][39] = EnumEntry("MAV_COMP_ID_USER15", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER16 = 40
enums["MAV_COMPONENT"][40] = EnumEntry("MAV_COMP_ID_USER16", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER17 = 41
enums["MAV_COMPONENT"][41] = EnumEntry("MAV_COMP_ID_USER17", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER18 = 42
enums["MAV_COMPONENT"][42] = EnumEntry("MAV_COMP_ID_USER18", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER19 = 43
enums["MAV_COMPONENT"][43] = EnumEntry("MAV_COMP_ID_USER19", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER20 = 44
enums["MAV_COMPONENT"][44] = EnumEntry("MAV_COMP_ID_USER20", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER21 = 45
enums["MAV_COMPONENT"][45] = EnumEntry("MAV_COMP_ID_USER21", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER22 = 46
enums["MAV_COMPONENT"][46] = EnumEntry("MAV_COMP_ID_USER22", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER23 = 47
enums["MAV_COMPONENT"][47] = EnumEntry("MAV_COMP_ID_USER23", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER24 = 48
enums["MAV_COMPONENT"][48] = EnumEntry("MAV_COMP_ID_USER24", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER25 = 49
enums["MAV_COMPONENT"][49] = EnumEntry("MAV_COMP_ID_USER25", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER26 = 50
enums["MAV_COMPONENT"][50] = EnumEntry("MAV_COMP_ID_USER26", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER27 = 51
enums["MAV_COMPONENT"][51] = EnumEntry("MAV_COMP_ID_USER27", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER28 = 52
enums["MAV_COMPONENT"][52] = EnumEntry("MAV_COMP_ID_USER28", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER29 = 53
enums["MAV_COMPONENT"][53] = EnumEntry("MAV_COMP_ID_USER29", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER30 = 54
enums["MAV_COMPONENT"][54] = EnumEntry("MAV_COMP_ID_USER30", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER31 = 55
enums["MAV_COMPONENT"][55] = EnumEntry("MAV_COMP_ID_USER31", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER32 = 56
enums["MAV_COMPONENT"][56] = EnumEntry("MAV_COMP_ID_USER32", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER33 = 57
enums["MAV_COMPONENT"][57] = EnumEntry("MAV_COMP_ID_USER33", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER34 = 58
enums["MAV_COMPONENT"][58] = EnumEntry("MAV_COMP_ID_USER34", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER35 = 59
enums["MAV_COMPONENT"][59] = EnumEntry("MAV_COMP_ID_USER35", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER36 = 60
enums["MAV_COMPONENT"][60] = EnumEntry("MAV_COMP_ID_USER36", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER37 = 61
enums["MAV_COMPONENT"][61] = EnumEntry("MAV_COMP_ID_USER37", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER38 = 62
enums["MAV_COMPONENT"][62] = EnumEntry("MAV_COMP_ID_USER38", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER39 = 63
enums["MAV_COMPONENT"][63] = EnumEntry("MAV_COMP_ID_USER39", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER40 = 64
enums["MAV_COMPONENT"][64] = EnumEntry("MAV_COMP_ID_USER40", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER41 = 65
enums["MAV_COMPONENT"][65] = EnumEntry("MAV_COMP_ID_USER41", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER42 = 66
enums["MAV_COMPONENT"][66] = EnumEntry("MAV_COMP_ID_USER42", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER43 = 67
enums["MAV_COMPONENT"][67] = EnumEntry("MAV_COMP_ID_USER43", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_TELEMETRY_RADIO = 68
enums["MAV_COMPONENT"][68] = EnumEntry("MAV_COMP_ID_TELEMETRY_RADIO", """Telemetry radio (e.g. SiK radio, or other component that emits RADIO_STATUS messages).""")
MAV_COMP_ID_USER45 = 69
enums["MAV_COMPONENT"][69] = EnumEntry("MAV_COMP_ID_USER45", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER46 = 70
enums["MAV_COMPONENT"][70] = EnumEntry("MAV_COMP_ID_USER46", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER47 = 71
enums["MAV_COMPONENT"][71] = EnumEntry("MAV_COMP_ID_USER47", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER48 = 72
enums["MAV_COMPONENT"][72] = EnumEntry("MAV_COMP_ID_USER48", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER49 = 73
enums["MAV_COMPONENT"][73] = EnumEntry("MAV_COMP_ID_USER49", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER50 = 74
enums["MAV_COMPONENT"][74] = EnumEntry("MAV_COMP_ID_USER50", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER51 = 75
enums["MAV_COMPONENT"][75] = EnumEntry("MAV_COMP_ID_USER51", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER52 = 76
enums["MAV_COMPONENT"][76] = EnumEntry("MAV_COMP_ID_USER52", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER53 = 77
enums["MAV_COMPONENT"][77] = EnumEntry("MAV_COMP_ID_USER53", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER54 = 78
enums["MAV_COMPONENT"][78] = EnumEntry("MAV_COMP_ID_USER54", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER55 = 79
enums["MAV_COMPONENT"][79] = EnumEntry("MAV_COMP_ID_USER55", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER56 = 80
enums["MAV_COMPONENT"][80] = EnumEntry("MAV_COMP_ID_USER56", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER57 = 81
enums["MAV_COMPONENT"][81] = EnumEntry("MAV_COMP_ID_USER57", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER58 = 82
enums["MAV_COMPONENT"][82] = EnumEntry("MAV_COMP_ID_USER58", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER59 = 83
enums["MAV_COMPONENT"][83] = EnumEntry("MAV_COMP_ID_USER59", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER60 = 84
enums["MAV_COMPONENT"][84] = EnumEntry("MAV_COMP_ID_USER60", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER61 = 85
enums["MAV_COMPONENT"][85] = EnumEntry("MAV_COMP_ID_USER61", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER62 = 86
enums["MAV_COMPONENT"][86] = EnumEntry("MAV_COMP_ID_USER62", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER63 = 87
enums["MAV_COMPONENT"][87] = EnumEntry("MAV_COMP_ID_USER63", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER64 = 88
enums["MAV_COMPONENT"][88] = EnumEntry("MAV_COMP_ID_USER64", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER65 = 89
enums["MAV_COMPONENT"][89] = EnumEntry("MAV_COMP_ID_USER65", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER66 = 90
enums["MAV_COMPONENT"][90] = EnumEntry("MAV_COMP_ID_USER66", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER67 = 91
enums["MAV_COMPONENT"][91] = EnumEntry("MAV_COMP_ID_USER67", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER68 = 92
enums["MAV_COMPONENT"][92] = EnumEntry("MAV_COMP_ID_USER68", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER69 = 93
enums["MAV_COMPONENT"][93] = EnumEntry("MAV_COMP_ID_USER69", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER70 = 94
enums["MAV_COMPONENT"][94] = EnumEntry("MAV_COMP_ID_USER70", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER71 = 95
enums["MAV_COMPONENT"][95] = EnumEntry("MAV_COMP_ID_USER71", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER72 = 96
enums["MAV_COMPONENT"][96] = EnumEntry("MAV_COMP_ID_USER72", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER73 = 97
enums["MAV_COMPONENT"][97] = EnumEntry("MAV_COMP_ID_USER73", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER74 = 98
enums["MAV_COMPONENT"][98] = EnumEntry("MAV_COMP_ID_USER74", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_USER75 = 99
enums["MAV_COMPONENT"][99] = EnumEntry("MAV_COMP_ID_USER75", """Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.""")
MAV_COMP_ID_CAMERA = 100
enums["MAV_COMPONENT"][100] = EnumEntry("MAV_COMP_ID_CAMERA", """Camera #1.""")
MAV_COMP_ID_CAMERA2 = 101
enums["MAV_COMPONENT"][101] = EnumEntry("MAV_COMP_ID_CAMERA2", """Camera #2.""")
MAV_COMP_ID_CAMERA3 = 102
enums["MAV_COMPONENT"][102] = EnumEntry("MAV_COMP_ID_CAMERA3", """Camera #3.""")
MAV_COMP_ID_CAMERA4 = 103
enums["MAV_COMPONENT"][103] = EnumEntry("MAV_COMP_ID_CAMERA4", """Camera #4.""")
MAV_COMP_ID_CAMERA5 = 104
enums["MAV_COMPONENT"][104] = EnumEntry("MAV_COMP_ID_CAMERA5", """Camera #5.""")
MAV_COMP_ID_CAMERA6 = 105
enums["MAV_COMPONENT"][105] = EnumEntry("MAV_COMP_ID_CAMERA6", """Camera #6.""")
MAV_COMP_ID_SERVO1 = 140
enums["MAV_COMPONENT"][140] = EnumEntry("MAV_COMP_ID_SERVO1", """Servo #1.""")
MAV_COMP_ID_SERVO2 = 141
enums["MAV_COMPONENT"][141] = EnumEntry("MAV_COMP_ID_SERVO2", """Servo #2.""")
MAV_COMP_ID_SERVO3 = 142
enums["MAV_COMPONENT"][142] = EnumEntry("MAV_COMP_ID_SERVO3", """Servo #3.""")
MAV_COMP_ID_SERVO4 = 143
enums["MAV_COMPONENT"][143] = EnumEntry("MAV_COMP_ID_SERVO4", """Servo #4.""")
MAV_COMP_ID_SERVO5 = 144
enums["MAV_COMPONENT"][144] = EnumEntry("MAV_COMP_ID_SERVO5", """Servo #5.""")
MAV_COMP_ID_SERVO6 = 145
enums["MAV_COMPONENT"][145] = EnumEntry("MAV_COMP_ID_SERVO6", """Servo #6.""")
MAV_COMP_ID_SERVO7 = 146
enums["MAV_COMPONENT"][146] = EnumEntry("MAV_COMP_ID_SERVO7", """Servo #7.""")
MAV_COMP_ID_SERVO8 = 147
enums["MAV_COMPONENT"][147] = EnumEntry("MAV_COMP_ID_SERVO8", """Servo #8.""")
MAV_COMP_ID_SERVO9 = 148
enums["MAV_COMPONENT"][148] = EnumEntry("MAV_COMP_ID_SERVO9", """Servo #9.""")
MAV_COMP_ID_SERVO10 = 149
enums["MAV_COMPONENT"][149] = EnumEntry("MAV_COMP_ID_SERVO10", """Servo #10.""")
MAV_COMP_ID_SERVO11 = 150
enums["MAV_COMPONENT"][150] = EnumEntry("MAV_COMP_ID_SERVO11", """Servo #11.""")
MAV_COMP_ID_SERVO12 = 151
enums["MAV_COMPONENT"][151] = EnumEntry("MAV_COMP_ID_SERVO12", """Servo #12.""")
MAV_COMP_ID_SERVO13 = 152
enums["MAV_COMPONENT"][152] = EnumEntry("MAV_COMP_ID_SERVO13", """Servo #13.""")
MAV_COMP_ID_SERVO14 = 153
enums["MAV_COMPONENT"][153] = EnumEntry("MAV_COMP_ID_SERVO14", """Servo #14.""")
MAV_COMP_ID_GIMBAL = 154
enums["MAV_COMPONENT"][154] = EnumEntry("MAV_COMP_ID_GIMBAL", """Gimbal #1.""")
MAV_COMP_ID_LOG = 155
enums["MAV_COMPONENT"][155] = EnumEntry("MAV_COMP_ID_LOG", """Logging component.""")
MAV_COMP_ID_ADSB = 156
enums["MAV_COMPONENT"][156] = EnumEntry("MAV_COMP_ID_ADSB", """Automatic Dependent Surveillance-Broadcast (ADS-B) component.""")
MAV_COMP_ID_OSD = 157
enums["MAV_COMPONENT"][157] = EnumEntry("MAV_COMP_ID_OSD", """On Screen Display (OSD) devices for video links.""")
MAV_COMP_ID_PERIPHERAL = 158
enums["MAV_COMPONENT"][158] = EnumEntry("MAV_COMP_ID_PERIPHERAL", """Generic autopilot peripheral component ID. Meant for devices that do not implement the parameter microservice.""")
MAV_COMP_ID_QX1_GIMBAL = 159
enums["MAV_COMPONENT"][159] = EnumEntry("MAV_COMP_ID_QX1_GIMBAL", """Gimbal ID for QX1.""")
MAV_COMP_ID_FLARM = 160
enums["MAV_COMPONENT"][160] = EnumEntry("MAV_COMP_ID_FLARM", """FLARM collision alert component.""")
MAV_COMP_ID_PARACHUTE = 161
enums["MAV_COMPONENT"][161] = EnumEntry("MAV_COMP_ID_PARACHUTE", """Parachute component.""")
MAV_COMP_ID_GIMBAL2 = 171
enums["MAV_COMPONENT"][171] = EnumEntry("MAV_COMP_ID_GIMBAL2", """Gimbal #2.""")
MAV_COMP_ID_GIMBAL3 = 172
enums["MAV_COMPONENT"][172] = EnumEntry("MAV_COMP_ID_GIMBAL3", """Gimbal #3.""")
MAV_COMP_ID_GIMBAL4 = 173
enums["MAV_COMPONENT"][173] = EnumEntry("MAV_COMP_ID_GIMBAL4", """Gimbal #4""")
MAV_COMP_ID_GIMBAL5 = 174
enums["MAV_COMPONENT"][174] = EnumEntry("MAV_COMP_ID_GIMBAL5", """Gimbal #5.""")
MAV_COMP_ID_GIMBAL6 = 175
enums["MAV_COMPONENT"][175] = EnumEntry("MAV_COMP_ID_GIMBAL6", """Gimbal #6.""")
MAV_COMP_ID_BATTERY = 180
enums["MAV_COMPONENT"][180] = EnumEntry("MAV_COMP_ID_BATTERY", """Battery #1.""")
MAV_COMP_ID_BATTERY2 = 181
enums["MAV_COMPONENT"][181] = EnumEntry("MAV_COMP_ID_BATTERY2", """Battery #2.""")
MAV_COMP_ID_MAVCAN = 189
enums["MAV_COMPONENT"][189] = EnumEntry("MAV_COMP_ID_MAVCAN", """CAN over MAVLink client.""")
MAV_COMP_ID_MISSIONPLANNER = 190
enums["MAV_COMPONENT"][190] = EnumEntry("MAV_COMP_ID_MISSIONPLANNER", """Component that can generate/supply a mission flight plan (e.g. GCS or developer API).""")
MAV_COMP_ID_ONBOARD_COMPUTER = 191
enums["MAV_COMPONENT"][191] = EnumEntry("MAV_COMP_ID_ONBOARD_COMPUTER", """Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.""")
MAV_COMP_ID_ONBOARD_COMPUTER2 = 192
enums["MAV_COMPONENT"][192] = EnumEntry("MAV_COMP_ID_ONBOARD_COMPUTER2", """Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.""")
MAV_COMP_ID_ONBOARD_COMPUTER3 = 193
enums["MAV_COMPONENT"][193] = EnumEntry("MAV_COMP_ID_ONBOARD_COMPUTER3", """Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.""")
MAV_COMP_ID_ONBOARD_COMPUTER4 = 194
enums["MAV_COMPONENT"][194] = EnumEntry("MAV_COMP_ID_ONBOARD_COMPUTER4", """Component that lives on the onboard computer (companion computer) and has some generic functionalities, such as settings system parameters and monitoring the status of some processes that don't directly speak mavlink and so on.""")
MAV_COMP_ID_PATHPLANNER = 195
enums["MAV_COMPONENT"][195] = EnumEntry("MAV_COMP_ID_PATHPLANNER", """Component that finds an optimal path between points based on a certain constraint (e.g. minimum snap, shortest path, cost, etc.).""")
MAV_COMP_ID_OBSTACLE_AVOIDANCE = 196
enums["MAV_COMPONENT"][196] = EnumEntry("MAV_COMP_ID_OBSTACLE_AVOIDANCE", """Component that plans a collision free path between two points.""")
MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY = 197
enums["MAV_COMPONENT"][197] = EnumEntry("MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY", """Component that provides position estimates using VIO techniques.""")
MAV_COMP_ID_PAIRING_MANAGER = 198
enums["MAV_COMPONENT"][198] = EnumEntry("MAV_COMP_ID_PAIRING_MANAGER", """Component that manages pairing of vehicle and GCS.""")
MAV_COMP_ID_IMU = 200
enums["MAV_COMPONENT"][200] = EnumEntry("MAV_COMP_ID_IMU", """Inertial Measurement Unit (IMU) #1.""")
MAV_COMP_ID_IMU_2 = 201
enums["MAV_COMPONENT"][201] = EnumEntry("MAV_COMP_ID_IMU_2", """Inertial Measurement Unit (IMU) #2.""")
MAV_COMP_ID_IMU_3 = 202
enums["MAV_COMPONENT"][202] = EnumEntry("MAV_COMP_ID_IMU_3", """Inertial Measurement Unit (IMU) #3.""")
MAV_COMP_ID_GPS = 220
enums["MAV_COMPONENT"][220] = EnumEntry("MAV_COMP_ID_GPS", """GPS #1.""")
MAV_COMP_ID_GPS2 = 221
enums["MAV_COMPONENT"][221] = EnumEntry("MAV_COMP_ID_GPS2", """GPS #2.""")
MAV_COMP_ID_ODID_TXRX_1 = 236
enums["MAV_COMPONENT"][236] = EnumEntry("MAV_COMP_ID_ODID_TXRX_1", """Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).""")
MAV_COMP_ID_ODID_TXRX_2 = 237
enums["MAV_COMPONENT"][237] = EnumEntry("MAV_COMP_ID_ODID_TXRX_2", """Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).""")
MAV_COMP_ID_ODID_TXRX_3 = 238
enums["MAV_COMPONENT"][238] = EnumEntry("MAV_COMP_ID_ODID_TXRX_3", """Open Drone ID transmitter/receiver (Bluetooth/WiFi/Internet).""")
MAV_COMP_ID_UDP_BRIDGE = 240
enums["MAV_COMPONENT"][240] = EnumEntry("MAV_COMP_ID_UDP_BRIDGE", """Component to bridge MAVLink to UDP (i.e. from a UART).""")
MAV_COMP_ID_UART_BRIDGE = 241
enums["MAV_COMPONENT"][241] = EnumEntry("MAV_COMP_ID_UART_BRIDGE", """Component to bridge to UART (i.e. from UDP).""")
MAV_COMP_ID_TUNNEL_NODE = 242
enums["MAV_COMPONENT"][242] = EnumEntry("MAV_COMP_ID_TUNNEL_NODE", """Component handling TUNNEL messages (e.g. vendor specific GUI of a component).""")
MAV_COMP_ID_SYSTEM_CONTROL = 250
enums["MAV_COMPONENT"][250] = EnumEntry("MAV_COMP_ID_SYSTEM_CONTROL", """Component for handling system messages (e.g. to ARM, takeoff, etc.).""")
MAV_COMPONENT_ENUM_END = 251
enums["MAV_COMPONENT"][251] = EnumEntry("MAV_COMPONENT_ENUM_END", """""")

# message IDs
MAVLINK_MSG_ID_BAD_DATA = -1
MAVLINK_MSG_ID_UNKNOWN = -2
MAVLINK_MSG_ID_AVSS_PRS_SYS_STATUS = 60050
MAVLINK_MSG_ID_AVSS_DRONE_POSITION = 60051
MAVLINK_MSG_ID_AVSS_DRONE_IMU = 60052
MAVLINK_MSG_ID_AVSS_DRONE_OPERATION_MODE = 60053
MAVLINK_MSG_ID_SYS_STATUS = 1
MAVLINK_MSG_ID_SYSTEM_TIME = 2
MAVLINK_MSG_ID_PING = 4
MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL = 5
MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK = 6
MAVLINK_MSG_ID_AUTH_KEY = 7
MAVLINK_MSG_ID_SET_MODE = 11
MAVLINK_MSG_ID_PARAM_REQUEST_READ = 20
MAVLINK_MSG_ID_PARAM_REQUEST_LIST = 21
MAVLINK_MSG_ID_PARAM_VALUE = 22
MAVLINK_MSG_ID_PARAM_SET = 23
MAVLINK_MSG_ID_GPS_RAW_INT = 24
MAVLINK_MSG_ID_GPS_STATUS = 25
MAVLINK_MSG_ID_SCALED_IMU = 26
MAVLINK_MSG_ID_RAW_IMU = 27
MAVLINK_MSG_ID_RAW_PRESSURE = 28
MAVLINK_MSG_ID_SCALED_PRESSURE = 29
MAVLINK_MSG_ID_ATTITUDE = 30
MAVLINK_MSG_ID_ATTITUDE_QUATERNION = 31
MAVLINK_MSG_ID_LOCAL_POSITION_NED = 32
MAVLINK_MSG_ID_GLOBAL_POSITION_INT = 33
MAVLINK_MSG_ID_RC_CHANNELS_SCALED = 34
MAVLINK_MSG_ID_RC_CHANNELS_RAW = 35
MAVLINK_MSG_ID_SERVO_OUTPUT_RAW = 36
MAVLINK_MSG_ID_MISSION_REQUEST_PARTIAL_LIST = 37
MAVLINK_MSG_ID_MISSION_WRITE_PARTIAL_LIST = 38
MAVLINK_MSG_ID_MISSION_ITEM = 39
MAVLINK_MSG_ID_MISSION_REQUEST = 40
MAVLINK_MSG_ID_MISSION_SET_CURRENT = 41
MAVLINK_MSG_ID_MISSION_CURRENT = 42
MAVLINK_MSG_ID_MISSION_REQUEST_LIST = 43
MAVLINK_MSG_ID_MISSION_COUNT = 44
MAVLINK_MSG_ID_MISSION_CLEAR_ALL = 45
MAVLINK_MSG_ID_MISSION_ITEM_REACHED = 46
MAVLINK_MSG_ID_MISSION_ACK = 47
MAVLINK_MSG_ID_SET_GPS_GLOBAL_ORIGIN = 48
MAVLINK_MSG_ID_GPS_GLOBAL_ORIGIN = 49
MAVLINK_MSG_ID_PARAM_MAP_RC = 50
MAVLINK_MSG_ID_MISSION_REQUEST_INT = 51
MAVLINK_MSG_ID_SAFETY_SET_ALLOWED_AREA = 54
MAVLINK_MSG_ID_SAFETY_ALLOWED_AREA = 55
MAVLINK_MSG_ID_ATTITUDE_QUATERNION_COV = 61
MAVLINK_MSG_ID_NAV_CONTROLLER_OUTPUT = 62
MAVLINK_MSG_ID_GLOBAL_POSITION_INT_COV = 63
MAVLINK_MSG_ID_LOCAL_POSITION_NED_COV = 64
MAVLINK_MSG_ID_RC_CHANNELS = 65
MAVLINK_MSG_ID_REQUEST_DATA_STREAM = 66
MAVLINK_MSG_ID_DATA_STREAM = 67
MAVLINK_MSG_ID_MANUAL_CONTROL = 69
MAVLINK_MSG_ID_RC_CHANNELS_OVERRIDE = 70
MAVLINK_MSG_ID_MISSION_ITEM_INT = 73
MAVLINK_MSG_ID_VFR_HUD = 74
MAVLINK_MSG_ID_COMMAND_INT = 75
MAVLINK_MSG_ID_COMMAND_LONG = 76
MAVLINK_MSG_ID_COMMAND_ACK = 77
MAVLINK_MSG_ID_MANUAL_SETPOINT = 81
MAVLINK_MSG_ID_SET_ATTITUDE_TARGET = 82
MAVLINK_MSG_ID_ATTITUDE_TARGET = 83
MAVLINK_MSG_ID_SET_POSITION_TARGET_LOCAL_NED = 84
MAVLINK_MSG_ID_POSITION_TARGET_LOCAL_NED = 85
MAVLINK_MSG_ID_SET_POSITION_TARGET_GLOBAL_INT = 86
MAVLINK_MSG_ID_POSITION_TARGET_GLOBAL_INT = 87
MAVLINK_MSG_ID_LOCAL_POSITION_NED_SYSTEM_GLOBAL_OFFSET = 89
MAVLINK_MSG_ID_HIL_STATE = 90
MAVLINK_MSG_ID_HIL_CONTROLS = 91
MAVLINK_MSG_ID_HIL_RC_INPUTS_RAW = 92
MAVLINK_MSG_ID_HIL_ACTUATOR_CONTROLS = 93
MAVLINK_MSG_ID_OPTICAL_FLOW = 100
MAVLINK_MSG_ID_GLOBAL_VISION_POSITION_ESTIMATE = 101
MAVLINK_MSG_ID_VISION_POSITION_ESTIMATE = 102
MAVLINK_MSG_ID_VISION_SPEED_ESTIMATE = 103
MAVLINK_MSG_ID_VICON_POSITION_ESTIMATE = 104
MAVLINK_MSG_ID_HIGHRES_IMU = 105
MAVLINK_MSG_ID_OPTICAL_FLOW_RAD = 106
MAVLINK_MSG_ID_HIL_SENSOR = 107
MAVLINK_MSG_ID_SIM_STATE = 108
MAVLINK_MSG_ID_RADIO_STATUS = 109
MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL = 110
MAVLINK_MSG_ID_TIMESYNC = 111
MAVLINK_MSG_ID_CAMERA_TRIGGER = 112
MAVLINK_MSG_ID_HIL_GPS = 113
MAVLINK_MSG_ID_HIL_OPTICAL_FLOW = 114
MAVLINK_MSG_ID_HIL_STATE_QUATERNION = 115
MAVLINK_MSG_ID_SCALED_IMU2 = 116
MAVLINK_MSG_ID_LOG_REQUEST_LIST = 117
MAVLINK_MSG_ID_LOG_ENTRY = 118
MAVLINK_MSG_ID_LOG_REQUEST_DATA = 119
MAVLINK_MSG_ID_LOG_DATA = 120
MAVLINK_MSG_ID_LOG_ERASE = 121
MAVLINK_MSG_ID_LOG_REQUEST_END = 122
MAVLINK_MSG_ID_GPS_INJECT_DATA = 123
MAVLINK_MSG_ID_GPS2_RAW = 124
MAVLINK_MSG_ID_POWER_STATUS = 125
MAVLINK_MSG_ID_SERIAL_CONTROL = 126
MAVLINK_MSG_ID_GPS_RTK = 127
MAVLINK_MSG_ID_GPS2_RTK = 128
MAVLINK_MSG_ID_SCALED_IMU3 = 129
MAVLINK_MSG_ID_DATA_TRANSMISSION_HANDSHAKE = 130
MAVLINK_MSG_ID_ENCAPSULATED_DATA = 131
MAVLINK_MSG_ID_DISTANCE_SENSOR = 132
MAVLINK_MSG_ID_TERRAIN_REQUEST = 133
MAVLINK_MSG_ID_TERRAIN_DATA = 134
MAVLINK_MSG_ID_TERRAIN_CHECK = 135
MAVLINK_MSG_ID_TERRAIN_REPORT = 136
MAVLINK_MSG_ID_SCALED_PRESSURE2 = 137
MAVLINK_MSG_ID_ATT_POS_MOCAP = 138
MAVLINK_MSG_ID_SET_ACTUATOR_CONTROL_TARGET = 139
MAVLINK_MSG_ID_ACTUATOR_CONTROL_TARGET = 140
MAVLINK_MSG_ID_ALTITUDE = 141
MAVLINK_MSG_ID_RESOURCE_REQUEST = 142
MAVLINK_MSG_ID_SCALED_PRESSURE3 = 143
MAVLINK_MSG_ID_FOLLOW_TARGET = 144
MAVLINK_MSG_ID_CONTROL_SYSTEM_STATE = 146
MAVLINK_MSG_ID_BATTERY_STATUS = 147
MAVLINK_MSG_ID_AUTOPILOT_VERSION = 148
MAVLINK_MSG_ID_LANDING_TARGET = 149
MAVLINK_MSG_ID_FENCE_STATUS = 162
MAVLINK_MSG_ID_MAG_CAL_REPORT = 192
MAVLINK_MSG_ID_EFI_STATUS = 225
MAVLINK_MSG_ID_ESTIMATOR_STATUS = 230
MAVLINK_MSG_ID_WIND_COV = 231
MAVLINK_MSG_ID_GPS_INPUT = 232
MAVLINK_MSG_ID_GPS_RTCM_DATA = 233
MAVLINK_MSG_ID_HIGH_LATENCY = 234
MAVLINK_MSG_ID_HIGH_LATENCY2 = 235
MAVLINK_MSG_ID_VIBRATION = 241
MAVLINK_MSG_ID_HOME_POSITION = 242
MAVLINK_MSG_ID_SET_HOME_POSITION = 243
MAVLINK_MSG_ID_MESSAGE_INTERVAL = 244
MAVLINK_MSG_ID_EXTENDED_SYS_STATE = 245
MAVLINK_MSG_ID_ADSB_VEHICLE = 246
MAVLINK_MSG_ID_COLLISION = 247
MAVLINK_MSG_ID_V2_EXTENSION = 248
MAVLINK_MSG_ID_MEMORY_VECT = 249
MAVLINK_MSG_ID_DEBUG_VECT = 250
MAVLINK_MSG_ID_NAMED_VALUE_FLOAT = 251
MAVLINK_MSG_ID_NAMED_VALUE_INT = 252
MAVLINK_MSG_ID_STATUSTEXT = 253
MAVLINK_MSG_ID_DEBUG = 254
MAVLINK_MSG_ID_SETUP_SIGNING = 256
MAVLINK_MSG_ID_BUTTON_CHANGE = 257
MAVLINK_MSG_ID_PLAY_TUNE = 258
MAVLINK_MSG_ID_CAMERA_INFORMATION = 259
MAVLINK_MSG_ID_CAMERA_SETTINGS = 260
MAVLINK_MSG_ID_STORAGE_INFORMATION = 261
MAVLINK_MSG_ID_CAMERA_CAPTURE_STATUS = 262
MAVLINK_MSG_ID_CAMERA_IMAGE_CAPTURED = 263
MAVLINK_MSG_ID_FLIGHT_INFORMATION = 264
MAVLINK_MSG_ID_MOUNT_ORIENTATION = 265
MAVLINK_MSG_ID_LOGGING_DATA = 266
MAVLINK_MSG_ID_LOGGING_DATA_ACKED = 267
MAVLINK_MSG_ID_LOGGING_ACK = 268
MAVLINK_MSG_ID_VIDEO_STREAM_INFORMATION = 269
MAVLINK_MSG_ID_VIDEO_STREAM_STATUS = 270
MAVLINK_MSG_ID_CAMERA_FOV_STATUS = 271
MAVLINK_MSG_ID_CAMERA_TRACKING_IMAGE_STATUS = 275
MAVLINK_MSG_ID_CAMERA_TRACKING_GEO_STATUS = 276
MAVLINK_MSG_ID_CAMERA_THERMAL_RANGE = 277
MAVLINK_MSG_ID_GIMBAL_MANAGER_INFORMATION = 280
MAVLINK_MSG_ID_GIMBAL_MANAGER_STATUS = 281
MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_ATTITUDE = 282
MAVLINK_MSG_ID_GIMBAL_DEVICE_INFORMATION = 283
MAVLINK_MSG_ID_GIMBAL_DEVICE_SET_ATTITUDE = 284
MAVLINK_MSG_ID_GIMBAL_DEVICE_ATTITUDE_STATUS = 285
MAVLINK_MSG_ID_AUTOPILOT_STATE_FOR_GIMBAL_DEVICE = 286
MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_PITCHYAW = 287
MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_MANUAL_CONTROL = 288
MAVLINK_MSG_ID_WIFI_CONFIG_AP = 299
MAVLINK_MSG_ID_AIS_VESSEL = 301
MAVLINK_MSG_ID_UAVCAN_NODE_STATUS = 310
MAVLINK_MSG_ID_UAVCAN_NODE_INFO = 311
MAVLINK_MSG_ID_PARAM_EXT_REQUEST_READ = 320
MAVLINK_MSG_ID_PARAM_EXT_REQUEST_LIST = 321
MAVLINK_MSG_ID_PARAM_EXT_VALUE = 322
MAVLINK_MSG_ID_PARAM_EXT_SET = 323
MAVLINK_MSG_ID_PARAM_EXT_ACK = 324
MAVLINK_MSG_ID_OBSTACLE_DISTANCE = 330
MAVLINK_MSG_ID_ODOMETRY = 331
MAVLINK_MSG_ID_TRAJECTORY_REPRESENTATION_WAYPOINTS = 332
MAVLINK_MSG_ID_TRAJECTORY_REPRESENTATION_BEZIER = 333
MAVLINK_MSG_ID_ISBD_LINK_STATUS = 335
MAVLINK_MSG_ID_RAW_RPM = 339
MAVLINK_MSG_ID_UTM_GLOBAL_POSITION = 340
MAVLINK_MSG_ID_DEBUG_FLOAT_ARRAY = 350
MAVLINK_MSG_ID_SMART_BATTERY_INFO = 370
MAVLINK_MSG_ID_GENERATOR_STATUS = 373
MAVLINK_MSG_ID_ACTUATOR_OUTPUT_STATUS = 375
MAVLINK_MSG_ID_RELAY_STATUS = 376
MAVLINK_MSG_ID_TUNNEL = 385
MAVLINK_MSG_ID_CAN_FRAME = 386
MAVLINK_MSG_ID_CANFD_FRAME = 387
MAVLINK_MSG_ID_CAN_FILTER_MODIFY = 388
MAVLINK_MSG_ID_WHEEL_DISTANCE = 9000
MAVLINK_MSG_ID_WINCH_STATUS = 9005
MAVLINK_MSG_ID_OPEN_DRONE_ID_BASIC_ID = 12900
MAVLINK_MSG_ID_OPEN_DRONE_ID_LOCATION = 12901
MAVLINK_MSG_ID_OPEN_DRONE_ID_AUTHENTICATION = 12902
MAVLINK_MSG_ID_OPEN_DRONE_ID_SELF_ID = 12903
MAVLINK_MSG_ID_OPEN_DRONE_ID_SYSTEM = 12904
MAVLINK_MSG_ID_OPEN_DRONE_ID_OPERATOR_ID = 12905
MAVLINK_MSG_ID_OPEN_DRONE_ID_ARM_STATUS = 12918
MAVLINK_MSG_ID_OPEN_DRONE_ID_MESSAGE_PACK = 12915
MAVLINK_MSG_ID_OPEN_DRONE_ID_SYSTEM_UPDATE = 12919
MAVLINK_MSG_ID_HYGROMETER_SENSOR = 12920
MAVLINK_MSG_ID_HEARTBEAT = 0


class MAVLink_avss_prs_sys_status_message(MAVLink_message):
    """
    AVSS PRS system status.
    """

    id = MAVLINK_MSG_ID_AVSS_PRS_SYS_STATUS
    msgname = "AVSS_PRS_SYS_STATUS"
    fieldnames = ["time_boot_ms", "error_status", "battery_status", "arm_status", "charge_status"]
    ordered_fieldnames = ["time_boot_ms", "error_status", "battery_status", "arm_status", "charge_status"]
    fieldtypes = ["uint32_t", "uint32_t", "uint32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<IIIBB")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 220
    unpacker = struct.Struct("<IIIBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, error_status: int, battery_status: int, arm_status: int, charge_status: int):
        MAVLink_message.__init__(self, MAVLink_avss_prs_sys_status_message.id, MAVLink_avss_prs_sys_status_message.msgname)
        self._fieldnames = MAVLink_avss_prs_sys_status_message.fieldnames
        self._instance_field = MAVLink_avss_prs_sys_status_message.instance_field
        self._instance_offset = MAVLink_avss_prs_sys_status_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.error_status = error_status
        self.battery_status = battery_status
        self.arm_status = arm_status
        self.charge_status = charge_status

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.error_status, self.battery_status, self.arm_status, self.charge_status), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_avss_prs_sys_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_avss_drone_position_message(MAVLink_message):
    """
    Drone position.
    """

    id = MAVLINK_MSG_ID_AVSS_DRONE_POSITION
    msgname = "AVSS_DRONE_POSITION"
    fieldnames = ["time_boot_ms", "lat", "lon", "alt", "ground_alt", "barometer_alt"]
    ordered_fieldnames = ["time_boot_ms", "lat", "lon", "alt", "ground_alt", "barometer_alt"]
    fieldtypes = ["uint32_t", "int32_t", "int32_t", "int32_t", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "lat": "degE7", "lon": "degE7", "alt": "mm", "ground_alt": "m", "barometer_alt": "m"}
    native_format = bytearray(b"<Iiiiff")
    orders = [0, 1, 2, 3, 4, 5]
    lengths = [1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0]
    crc_extra = 245
    unpacker = struct.Struct("<Iiiiff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, lat: int, lon: int, alt: int, ground_alt: float, barometer_alt: float):
        MAVLink_message.__init__(self, MAVLink_avss_drone_position_message.id, MAVLink_avss_drone_position_message.msgname)
        self._fieldnames = MAVLink_avss_drone_position_message.fieldnames
        self._instance_field = MAVLink_avss_drone_position_message.instance_field
        self._instance_offset = MAVLink_avss_drone_position_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.ground_alt = ground_alt
        self.barometer_alt = barometer_alt

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.lat, self.lon, self.alt, self.ground_alt, self.barometer_alt), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_avss_drone_position_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_avss_drone_imu_message(MAVLink_message):
    """
    Drone IMU data. Quaternion order is w, x, y, z and a zero rotation
    would be expressed as (1 0 0 0).
    """

    id = MAVLINK_MSG_ID_AVSS_DRONE_IMU
    msgname = "AVSS_DRONE_IMU"
    fieldnames = ["time_boot_ms", "q1", "q2", "q3", "q4", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro"]
    ordered_fieldnames = ["time_boot_ms", "q1", "q2", "q3", "q4", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro"]
    fieldtypes = ["uint32_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "xacc": "m/s/s", "yacc": "m/s/s", "zacc": "m/s/s", "xgyro": "rad/s", "ygyro": "rad/s", "zgyro": "rad/s"}
    native_format = bytearray(b"<Iffffffffff")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 101
    unpacker = struct.Struct("<Iffffffffff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, q1: float, q2: float, q3: float, q4: float, xacc: float, yacc: float, zacc: float, xgyro: float, ygyro: float, zgyro: float):
        MAVLink_message.__init__(self, MAVLink_avss_drone_imu_message.id, MAVLink_avss_drone_imu_message.msgname)
        self._fieldnames = MAVLink_avss_drone_imu_message.fieldnames
        self._instance_field = MAVLink_avss_drone_imu_message.instance_field
        self._instance_offset = MAVLink_avss_drone_imu_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.q1 = q1
        self.q2 = q2
        self.q3 = q3
        self.q4 = q4
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc
        self.xgyro = xgyro
        self.ygyro = ygyro
        self.zgyro = zgyro

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.q1, self.q2, self.q3, self.q4, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_avss_drone_imu_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_avss_drone_operation_mode_message(MAVLink_message):
    """
    Drone operation mode.
    """

    id = MAVLINK_MSG_ID_AVSS_DRONE_OPERATION_MODE
    msgname = "AVSS_DRONE_OPERATION_MODE"
    fieldnames = ["time_boot_ms", "M300_operation_mode", "horsefly_operation_mode"]
    ordered_fieldnames = ["time_boot_ms", "M300_operation_mode", "horsefly_operation_mode"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<IBB")
    orders = [0, 1, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 45
    unpacker = struct.Struct("<IBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, M300_operation_mode: int, horsefly_operation_mode: int):
        MAVLink_message.__init__(self, MAVLink_avss_drone_operation_mode_message.id, MAVLink_avss_drone_operation_mode_message.msgname)
        self._fieldnames = MAVLink_avss_drone_operation_mode_message.fieldnames
        self._instance_field = MAVLink_avss_drone_operation_mode_message.instance_field
        self._instance_offset = MAVLink_avss_drone_operation_mode_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.M300_operation_mode = M300_operation_mode
        self.horsefly_operation_mode = horsefly_operation_mode

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.M300_operation_mode, self.horsefly_operation_mode), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_avss_drone_operation_mode_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_sys_status_message(MAVLink_message):
    """
    The general system state. If the system is following the MAVLink
    standard, the system state is mainly defined by three orthogonal
    states/modes: The system mode, which is either LOCKED (motors shut
    down and locked), MANUAL (system under RC control), GUIDED (system
    with autonomous position control, position setpoint controlled
    manually) or AUTO (system guided by path/waypoint planner). The
    NAV_MODE defined the current flight state: LIFTOFF (often an open-
    loop maneuver), LANDING, WAYPOINTS or VECTOR. This represents the
    internal navigation state machine. The system status shows whether
    the system is currently active or not and if an emergency
    occurred. During the CRITICAL and EMERGENCY states the MAV is
    still considered to be active, but should start emergency
    procedures autonomously. After a failure occurred it should first
    move from active to critical to allow manual intervention and then
    move to emergency after a certain timeout.
    """

    id = MAVLINK_MSG_ID_SYS_STATUS
    msgname = "SYS_STATUS"
    fieldnames = ["onboard_control_sensors_present", "onboard_control_sensors_enabled", "onboard_control_sensors_health", "load", "voltage_battery", "current_battery", "battery_remaining", "drop_rate_comm", "errors_comm", "errors_count1", "errors_count2", "errors_count3", "errors_count4"]
    ordered_fieldnames = ["onboard_control_sensors_present", "onboard_control_sensors_enabled", "onboard_control_sensors_health", "load", "voltage_battery", "current_battery", "drop_rate_comm", "errors_comm", "errors_count1", "errors_count2", "errors_count3", "errors_count4", "battery_remaining"]
    fieldtypes = ["uint32_t", "uint32_t", "uint32_t", "uint16_t", "uint16_t", "int16_t", "int8_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {"onboard_control_sensors_present": "bitmask", "onboard_control_sensors_enabled": "bitmask", "onboard_control_sensors_health": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"onboard_control_sensors_present": "MAV_SYS_STATUS_SENSOR", "onboard_control_sensors_enabled": "MAV_SYS_STATUS_SENSOR", "onboard_control_sensors_health": "MAV_SYS_STATUS_SENSOR"}
    fieldunits_by_name: Dict[str, str] = {"load": "d%", "voltage_battery": "mV", "current_battery": "cA", "battery_remaining": "%", "drop_rate_comm": "c%"}
    native_format = bytearray(b"<IIIHHhHHHHHHb")
    orders = [0, 1, 2, 3, 4, 5, 12, 6, 7, 8, 9, 10, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 124
    unpacker = struct.Struct("<IIIHHhHHHHHHb")
    instance_field = None
    instance_offset = -1

    def __init__(self, onboard_control_sensors_present: int, onboard_control_sensors_enabled: int, onboard_control_sensors_health: int, load: int, voltage_battery: int, current_battery: int, battery_remaining: int, drop_rate_comm: int, errors_comm: int, errors_count1: int, errors_count2: int, errors_count3: int, errors_count4: int):
        MAVLink_message.__init__(self, MAVLink_sys_status_message.id, MAVLink_sys_status_message.msgname)
        self._fieldnames = MAVLink_sys_status_message.fieldnames
        self._instance_field = MAVLink_sys_status_message.instance_field
        self._instance_offset = MAVLink_sys_status_message.instance_offset
        self.onboard_control_sensors_present = onboard_control_sensors_present
        self.onboard_control_sensors_enabled = onboard_control_sensors_enabled
        self.onboard_control_sensors_health = onboard_control_sensors_health
        self.load = load
        self.voltage_battery = voltage_battery
        self.current_battery = current_battery
        self.battery_remaining = battery_remaining
        self.drop_rate_comm = drop_rate_comm
        self.errors_comm = errors_comm
        self.errors_count1 = errors_count1
        self.errors_count2 = errors_count2
        self.errors_count3 = errors_count3
        self.errors_count4 = errors_count4

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.onboard_control_sensors_present, self.onboard_control_sensors_enabled, self.onboard_control_sensors_health, self.load, self.voltage_battery, self.current_battery, self.drop_rate_comm, self.errors_comm, self.errors_count1, self.errors_count2, self.errors_count3, self.errors_count4, self.battery_remaining), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_sys_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_system_time_message(MAVLink_message):
    """
    The system time is the time of the master clock, typically the
    computer clock of the main onboard computer.
    """

    id = MAVLINK_MSG_ID_SYSTEM_TIME
    msgname = "SYSTEM_TIME"
    fieldnames = ["time_unix_usec", "time_boot_ms"]
    ordered_fieldnames = ["time_unix_usec", "time_boot_ms"]
    fieldtypes = ["uint64_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_unix_usec": "us", "time_boot_ms": "ms"}
    native_format = bytearray(b"<QI")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 137
    unpacker = struct.Struct("<QI")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_unix_usec: int, time_boot_ms: int):
        MAVLink_message.__init__(self, MAVLink_system_time_message.id, MAVLink_system_time_message.msgname)
        self._fieldnames = MAVLink_system_time_message.fieldnames
        self._instance_field = MAVLink_system_time_message.instance_field
        self._instance_offset = MAVLink_system_time_message.instance_offset
        self.time_unix_usec = time_unix_usec
        self.time_boot_ms = time_boot_ms

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_unix_usec, self.time_boot_ms), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_system_time_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_ping_message(MAVLink_message):
    """
    A ping message either requesting or responding to a ping. This
    allows to measure the system latencies, including serial port,
    radio modem and UDP connections. The ping microservice is
    documented at https://mavlink.io/en/services/ping.html
    """

    id = MAVLINK_MSG_ID_PING
    msgname = "PING"
    fieldnames = ["time_usec", "seq", "target_system", "target_component"]
    ordered_fieldnames = ["time_usec", "seq", "target_system", "target_component"]
    fieldtypes = ["uint64_t", "uint32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QIBB")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 237
    unpacker = struct.Struct("<QIBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, seq: int, target_system: int, target_component: int):
        MAVLink_message.__init__(self, MAVLink_ping_message.id, MAVLink_ping_message.msgname)
        self._fieldnames = MAVLink_ping_message.fieldnames
        self._instance_field = MAVLink_ping_message.instance_field
        self._instance_offset = MAVLink_ping_message.instance_offset
        self.time_usec = time_usec
        self.seq = seq
        self.target_system = target_system
        self.target_component = target_component

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.seq, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_ping_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_change_operator_control_message(MAVLink_message):
    """
    Request to control this MAV
    """

    id = MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL
    msgname = "CHANGE_OPERATOR_CONTROL"
    fieldnames = ["target_system", "control_request", "version", "passkey"]
    ordered_fieldnames = ["target_system", "control_request", "version", "passkey"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"version": "rad"}
    native_format = bytearray(b"<BBBc")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 25]
    crc_extra = 217
    unpacker = struct.Struct("<BBB25s")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, control_request: int, version: int, passkey: bytes):
        MAVLink_message.__init__(self, MAVLink_change_operator_control_message.id, MAVLink_change_operator_control_message.msgname)
        self._fieldnames = MAVLink_change_operator_control_message.fieldnames
        self._instance_field = MAVLink_change_operator_control_message.instance_field
        self._instance_offset = MAVLink_change_operator_control_message.instance_offset
        self.target_system = target_system
        self.control_request = control_request
        self.version = version
        self._passkey_raw = passkey
        self.passkey = passkey.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.control_request, self.version, self._passkey_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_change_operator_control_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_change_operator_control_ack_message(MAVLink_message):
    """
    Accept / deny control of this MAV
    """

    id = MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK
    msgname = "CHANGE_OPERATOR_CONTROL_ACK"
    fieldnames = ["gcs_system_id", "control_request", "ack"]
    ordered_fieldnames = ["gcs_system_id", "control_request", "ack"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBB")
    orders = [0, 1, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 104
    unpacker = struct.Struct("<BBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, gcs_system_id: int, control_request: int, ack: int):
        MAVLink_message.__init__(self, MAVLink_change_operator_control_ack_message.id, MAVLink_change_operator_control_ack_message.msgname)
        self._fieldnames = MAVLink_change_operator_control_ack_message.fieldnames
        self._instance_field = MAVLink_change_operator_control_ack_message.instance_field
        self._instance_offset = MAVLink_change_operator_control_ack_message.instance_offset
        self.gcs_system_id = gcs_system_id
        self.control_request = control_request
        self.ack = ack

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.gcs_system_id, self.control_request, self.ack), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_change_operator_control_ack_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_auth_key_message(MAVLink_message):
    """
    Emit an encrypted signature / key identifying this system. PLEASE
    NOTE: This protocol has been kept simple, so transmitting the key
    requires an encrypted channel for true safety.
    """

    id = MAVLINK_MSG_ID_AUTH_KEY
    msgname = "AUTH_KEY"
    fieldnames = ["key"]
    ordered_fieldnames = ["key"]
    fieldtypes = ["char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<c")
    orders = [0]
    lengths = [1]
    array_lengths = [32]
    crc_extra = 119
    unpacker = struct.Struct("<32s")
    instance_field = None
    instance_offset = -1

    def __init__(self, key: bytes):
        MAVLink_message.__init__(self, MAVLink_auth_key_message.id, MAVLink_auth_key_message.msgname)
        self._fieldnames = MAVLink_auth_key_message.fieldnames
        self._instance_field = MAVLink_auth_key_message.instance_field
        self._instance_offset = MAVLink_auth_key_message.instance_offset
        self._key_raw = key
        self.key = key.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self._key_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_auth_key_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_set_mode_message(MAVLink_message):
    """
    Set the system mode, as defined by enum MAV_MODE. There is no
    target component id as the mode is by definition for the overall
    aircraft, not only for one component.
    """

    id = MAVLINK_MSG_ID_SET_MODE
    msgname = "SET_MODE"
    fieldnames = ["target_system", "base_mode", "custom_mode"]
    ordered_fieldnames = ["custom_mode", "target_system", "base_mode"]
    fieldtypes = ["uint8_t", "uint8_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"base_mode": "MAV_MODE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<IBB")
    orders = [1, 2, 0]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 89
    unpacker = struct.Struct("<IBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, base_mode: int, custom_mode: int):
        MAVLink_message.__init__(self, MAVLink_set_mode_message.id, MAVLink_set_mode_message.msgname)
        self._fieldnames = MAVLink_set_mode_message.fieldnames
        self._instance_field = MAVLink_set_mode_message.instance_field
        self._instance_offset = MAVLink_set_mode_message.instance_offset
        self.target_system = target_system
        self.base_mode = base_mode
        self.custom_mode = custom_mode

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.custom_mode, self.target_system, self.base_mode), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_set_mode_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_request_read_message(MAVLink_message):
    """
    Request to read the onboard parameter with the param_id string id.
    Onboard parameters are stored as key[const char*] -> value[float].
    This allows to send a parameter to any other component (such as
    the GCS) without the need of previous knowledge of possible
    parameter names. Thus the same GCS can store different parameters
    for different autopilots. See also
    https://mavlink.io/en/services/parameter.html for a full
    documentation of QGroundControl and IMU code.
    """

    id = MAVLINK_MSG_ID_PARAM_REQUEST_READ
    msgname = "PARAM_REQUEST_READ"
    fieldnames = ["target_system", "target_component", "param_id", "param_index"]
    ordered_fieldnames = ["param_index", "target_system", "target_component", "param_id"]
    fieldtypes = ["uint8_t", "uint8_t", "char", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<hBBc")
    orders = [1, 2, 3, 0]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 16]
    crc_extra = 214
    unpacker = struct.Struct("<hBB16s")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, param_id: bytes, param_index: int):
        MAVLink_message.__init__(self, MAVLink_param_request_read_message.id, MAVLink_param_request_read_message.msgname)
        self._fieldnames = MAVLink_param_request_read_message.fieldnames
        self._instance_field = MAVLink_param_request_read_message.instance_field
        self._instance_offset = MAVLink_param_request_read_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self._param_id_raw = param_id
        self.param_id = param_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.param_index = param_index

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param_index, self.target_system, self.target_component, self._param_id_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_request_read_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_request_list_message(MAVLink_message):
    """
    Request all parameters of this component. After this request, all
    parameters are emitted. The parameter microservice is documented
    at https://mavlink.io/en/services/parameter.html
    """

    id = MAVLINK_MSG_ID_PARAM_REQUEST_LIST
    msgname = "PARAM_REQUEST_LIST"
    fieldnames = ["target_system", "target_component"]
    ordered_fieldnames = ["target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BB")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 159
    unpacker = struct.Struct("<BB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int):
        MAVLink_message.__init__(self, MAVLink_param_request_list_message.id, MAVLink_param_request_list_message.msgname)
        self._fieldnames = MAVLink_param_request_list_message.fieldnames
        self._instance_field = MAVLink_param_request_list_message.instance_field
        self._instance_offset = MAVLink_param_request_list_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_request_list_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_value_message(MAVLink_message):
    """
    Emit the value of a onboard parameter. The inclusion of
    param_count and param_index in the message allows the recipient to
    keep track of received parameters and allows him to re-request
    missing parameters after a loss or timeout. The parameter
    microservice is documented at
    https://mavlink.io/en/services/parameter.html
    """

    id = MAVLINK_MSG_ID_PARAM_VALUE
    msgname = "PARAM_VALUE"
    fieldnames = ["param_id", "param_value", "param_type", "param_count", "param_index"]
    ordered_fieldnames = ["param_value", "param_count", "param_index", "param_id", "param_type"]
    fieldtypes = ["char", "float", "uint8_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"param_type": "MAV_PARAM_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<fHHcB")
    orders = [3, 0, 4, 1, 2]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 16, 0]
    crc_extra = 220
    unpacker = struct.Struct("<fHH16sB")
    instance_field = None
    instance_offset = -1

    def __init__(self, param_id: bytes, param_value: float, param_type: int, param_count: int, param_index: int):
        MAVLink_message.__init__(self, MAVLink_param_value_message.id, MAVLink_param_value_message.msgname)
        self._fieldnames = MAVLink_param_value_message.fieldnames
        self._instance_field = MAVLink_param_value_message.instance_field
        self._instance_offset = MAVLink_param_value_message.instance_offset
        self._param_id_raw = param_id
        self.param_id = param_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.param_value = param_value
        self.param_type = param_type
        self.param_count = param_count
        self.param_index = param_index

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param_value, self.param_count, self.param_index, self._param_id_raw, self.param_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_value_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_set_message(MAVLink_message):
    """
    Set a parameter value (write new value to permanent storage).
    The receiving component should acknowledge the new parameter value
    by broadcasting a PARAM_VALUE message (broadcasting ensures that
    multiple GCS all have an up-to-date list of all parameters). If
    the sending GCS did not receive a PARAM_VALUE within its timeout
    time, it should re-send the PARAM_SET message. The parameter
    microservice is documented at
    https://mavlink.io/en/services/parameter.html.
    """

    id = MAVLINK_MSG_ID_PARAM_SET
    msgname = "PARAM_SET"
    fieldnames = ["target_system", "target_component", "param_id", "param_value", "param_type"]
    ordered_fieldnames = ["param_value", "target_system", "target_component", "param_id", "param_type"]
    fieldtypes = ["uint8_t", "uint8_t", "char", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"param_type": "MAV_PARAM_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<fBBcB")
    orders = [1, 2, 3, 0, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 16, 0]
    crc_extra = 168
    unpacker = struct.Struct("<fBB16sB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, param_id: bytes, param_value: float, param_type: int):
        MAVLink_message.__init__(self, MAVLink_param_set_message.id, MAVLink_param_set_message.msgname)
        self._fieldnames = MAVLink_param_set_message.fieldnames
        self._instance_field = MAVLink_param_set_message.instance_field
        self._instance_offset = MAVLink_param_set_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self._param_id_raw = param_id
        self.param_id = param_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.param_value = param_value
        self.param_type = param_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param_value, self.target_system, self.target_component, self._param_id_raw, self.param_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_set_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps_raw_int_message(MAVLink_message):
    """
    The global position, as returned by the Global Positioning System
    (GPS). This is                 NOT the global position estimate of
    the system, but rather a RAW sensor value. See message
    GLOBAL_POSITION_INT for the global position estimate.
    """

    id = MAVLINK_MSG_ID_GPS_RAW_INT
    msgname = "GPS_RAW_INT"
    fieldnames = ["time_usec", "fix_type", "lat", "lon", "alt", "eph", "epv", "vel", "cog", "satellites_visible", "alt_ellipsoid", "h_acc", "v_acc", "vel_acc", "hdg_acc", "yaw"]
    ordered_fieldnames = ["time_usec", "lat", "lon", "alt", "eph", "epv", "vel", "cog", "fix_type", "satellites_visible", "alt_ellipsoid", "h_acc", "v_acc", "vel_acc", "hdg_acc", "yaw"]
    fieldtypes = ["uint64_t", "uint8_t", "int32_t", "int32_t", "int32_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t", "int32_t", "uint32_t", "uint32_t", "uint32_t", "uint32_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"fix_type": "GPS_FIX_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "vel": "cm/s", "cog": "cdeg", "alt_ellipsoid": "mm", "h_acc": "mm", "v_acc": "mm", "vel_acc": "mm/s", "hdg_acc": "degE5", "yaw": "cdeg"}
    native_format = bytearray(b"<QiiiHHHHBBiIIIIH")
    orders = [0, 8, 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 24
    unpacker = struct.Struct("<QiiiHHHHBBiIIIIH")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, fix_type: int, lat: int, lon: int, alt: int, eph: int, epv: int, vel: int, cog: int, satellites_visible: int, alt_ellipsoid: int = 0, h_acc: int = 0, v_acc: int = 0, vel_acc: int = 0, hdg_acc: int = 0, yaw: int = 0):
        MAVLink_message.__init__(self, MAVLink_gps_raw_int_message.id, MAVLink_gps_raw_int_message.msgname)
        self._fieldnames = MAVLink_gps_raw_int_message.fieldnames
        self._instance_field = MAVLink_gps_raw_int_message.instance_field
        self._instance_offset = MAVLink_gps_raw_int_message.instance_offset
        self.time_usec = time_usec
        self.fix_type = fix_type
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.eph = eph
        self.epv = epv
        self.vel = vel
        self.cog = cog
        self.satellites_visible = satellites_visible
        self.alt_ellipsoid = alt_ellipsoid
        self.h_acc = h_acc
        self.v_acc = v_acc
        self.vel_acc = vel_acc
        self.hdg_acc = hdg_acc
        self.yaw = yaw

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.lat, self.lon, self.alt, self.eph, self.epv, self.vel, self.cog, self.fix_type, self.satellites_visible, self.alt_ellipsoid, self.h_acc, self.v_acc, self.vel_acc, self.hdg_acc, self.yaw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps_raw_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps_status_message(MAVLink_message):
    """
    The positioning status, as reported by GPS. This message is
    intended to display status information about each satellite
    visible to the receiver. See message GLOBAL_POSITION_INT for the
    global position estimate. This message can contain information for
    up to 20 satellites.
    """

    id = MAVLINK_MSG_ID_GPS_STATUS
    msgname = "GPS_STATUS"
    fieldnames = ["satellites_visible", "satellite_prn", "satellite_used", "satellite_elevation", "satellite_azimuth", "satellite_snr"]
    ordered_fieldnames = ["satellites_visible", "satellite_prn", "satellite_used", "satellite_elevation", "satellite_azimuth", "satellite_snr"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"satellite_elevation": "deg", "satellite_azimuth": "deg", "satellite_snr": "dB"}
    native_format = bytearray(b"<BBBBBB")
    orders = [0, 1, 2, 3, 4, 5]
    lengths = [1, 20, 20, 20, 20, 20]
    array_lengths = [0, 20, 20, 20, 20, 20]
    crc_extra = 23
    unpacker = struct.Struct("<B20B20B20B20B20B")
    instance_field = None
    instance_offset = -1

    def __init__(self, satellites_visible: int, satellite_prn: Sequence[int], satellite_used: Sequence[int], satellite_elevation: Sequence[int], satellite_azimuth: Sequence[int], satellite_snr: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_gps_status_message.id, MAVLink_gps_status_message.msgname)
        self._fieldnames = MAVLink_gps_status_message.fieldnames
        self._instance_field = MAVLink_gps_status_message.instance_field
        self._instance_offset = MAVLink_gps_status_message.instance_offset
        self.satellites_visible = satellites_visible
        self.satellite_prn = satellite_prn
        self.satellite_used = satellite_used
        self.satellite_elevation = satellite_elevation
        self.satellite_azimuth = satellite_azimuth
        self.satellite_snr = satellite_snr

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.satellites_visible, self.satellite_prn[0], self.satellite_prn[1], self.satellite_prn[2], self.satellite_prn[3], self.satellite_prn[4], self.satellite_prn[5], self.satellite_prn[6], self.satellite_prn[7], self.satellite_prn[8], self.satellite_prn[9], self.satellite_prn[10], self.satellite_prn[11], self.satellite_prn[12], self.satellite_prn[13], self.satellite_prn[14], self.satellite_prn[15], self.satellite_prn[16], self.satellite_prn[17], self.satellite_prn[18], self.satellite_prn[19], self.satellite_used[0], self.satellite_used[1], self.satellite_used[2], self.satellite_used[3], self.satellite_used[4], self.satellite_used[5], self.satellite_used[6], self.satellite_used[7], self.satellite_used[8], self.satellite_used[9], self.satellite_used[10], self.satellite_used[11], self.satellite_used[12], self.satellite_used[13], self.satellite_used[14], self.satellite_used[15], self.satellite_used[16], self.satellite_used[17], self.satellite_used[18], self.satellite_used[19], self.satellite_elevation[0], self.satellite_elevation[1], self.satellite_elevation[2], self.satellite_elevation[3], self.satellite_elevation[4], self.satellite_elevation[5], self.satellite_elevation[6], self.satellite_elevation[7], self.satellite_elevation[8], self.satellite_elevation[9], self.satellite_elevation[10], self.satellite_elevation[11], self.satellite_elevation[12], self.satellite_elevation[13], self.satellite_elevation[14], self.satellite_elevation[15], self.satellite_elevation[16], self.satellite_elevation[17], self.satellite_elevation[18], self.satellite_elevation[19], self.satellite_azimuth[0], self.satellite_azimuth[1], self.satellite_azimuth[2], self.satellite_azimuth[3], self.satellite_azimuth[4], self.satellite_azimuth[5], self.satellite_azimuth[6], self.satellite_azimuth[7], self.satellite_azimuth[8], self.satellite_azimuth[9], self.satellite_azimuth[10], self.satellite_azimuth[11], self.satellite_azimuth[12], self.satellite_azimuth[13], self.satellite_azimuth[14], self.satellite_azimuth[15], self.satellite_azimuth[16], self.satellite_azimuth[17], self.satellite_azimuth[18], self.satellite_azimuth[19], self.satellite_snr[0], self.satellite_snr[1], self.satellite_snr[2], self.satellite_snr[3], self.satellite_snr[4], self.satellite_snr[5], self.satellite_snr[6], self.satellite_snr[7], self.satellite_snr[8], self.satellite_snr[9], self.satellite_snr[10], self.satellite_snr[11], self.satellite_snr[12], self.satellite_snr[13], self.satellite_snr[14], self.satellite_snr[15], self.satellite_snr[16], self.satellite_snr[17], self.satellite_snr[18], self.satellite_snr[19]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_scaled_imu_message(MAVLink_message):
    """
    The RAW IMU readings for the usual 9DOF sensor setup. This message
    should contain the scaled values to the described units
    """

    id = MAVLINK_MSG_ID_SCALED_IMU
    msgname = "SCALED_IMU"
    fieldnames = ["time_boot_ms", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "temperature"]
    ordered_fieldnames = ["time_boot_ms", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "temperature"]
    fieldtypes = ["uint32_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "xacc": "mG", "yacc": "mG", "zacc": "mG", "xgyro": "mrad/s", "ygyro": "mrad/s", "zgyro": "mrad/s", "xmag": "mgauss", "ymag": "mgauss", "zmag": "mgauss", "temperature": "cdegC"}
    native_format = bytearray(b"<Ihhhhhhhhhh")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 170
    unpacker = struct.Struct("<Ihhhhhhhhhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, xacc: int, yacc: int, zacc: int, xgyro: int, ygyro: int, zgyro: int, xmag: int, ymag: int, zmag: int, temperature: int = 0):
        MAVLink_message.__init__(self, MAVLink_scaled_imu_message.id, MAVLink_scaled_imu_message.msgname)
        self._fieldnames = MAVLink_scaled_imu_message.fieldnames
        self._instance_field = MAVLink_scaled_imu_message.instance_field
        self._instance_offset = MAVLink_scaled_imu_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc
        self.xgyro = xgyro
        self.ygyro = ygyro
        self.zgyro = zgyro
        self.xmag = xmag
        self.ymag = ymag
        self.zmag = zmag
        self.temperature = temperature

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag, self.temperature), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_scaled_imu_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_raw_imu_message(MAVLink_message):
    """
    The RAW IMU readings for a 9DOF sensor, which is identified by the
    id (default IMU1). This message should always contain the true raw
    values without any scaling to allow data capture and system
    debugging.
    """

    id = MAVLINK_MSG_ID_RAW_IMU
    msgname = "RAW_IMU"
    fieldnames = ["time_usec", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "id", "temperature"]
    ordered_fieldnames = ["time_usec", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "id", "temperature"]
    fieldtypes = ["uint64_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "uint8_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "temperature": "cdegC"}
    native_format = bytearray(b"<QhhhhhhhhhBh")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 144
    unpacker = struct.Struct("<QhhhhhhhhhBh")
    instance_field = "id"
    instance_offset = 26

    def __init__(self, time_usec: int, xacc: int, yacc: int, zacc: int, xgyro: int, ygyro: int, zgyro: int, xmag: int, ymag: int, zmag: int, id: int = 0, temperature: int = 0):
        MAVLink_message.__init__(self, MAVLink_raw_imu_message.id, MAVLink_raw_imu_message.msgname)
        self._fieldnames = MAVLink_raw_imu_message.fieldnames
        self._instance_field = MAVLink_raw_imu_message.instance_field
        self._instance_offset = MAVLink_raw_imu_message.instance_offset
        self.time_usec = time_usec
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc
        self.xgyro = xgyro
        self.ygyro = ygyro
        self.zgyro = zgyro
        self.xmag = xmag
        self.ymag = ymag
        self.zmag = zmag
        self.id = id
        self.temperature = temperature

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag, self.id, self.temperature), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_raw_imu_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_raw_pressure_message(MAVLink_message):
    """
    The RAW pressure readings for the typical setup of one absolute
    pressure and one differential pressure sensor. The sensor values
    should be the raw, UNSCALED ADC values.
    """

    id = MAVLINK_MSG_ID_RAW_PRESSURE
    msgname = "RAW_PRESSURE"
    fieldnames = ["time_usec", "press_abs", "press_diff1", "press_diff2", "temperature"]
    ordered_fieldnames = ["time_usec", "press_abs", "press_diff1", "press_diff2", "temperature"]
    fieldtypes = ["uint64_t", "int16_t", "int16_t", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<Qhhhh")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 67
    unpacker = struct.Struct("<Qhhhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, press_abs: int, press_diff1: int, press_diff2: int, temperature: int):
        MAVLink_message.__init__(self, MAVLink_raw_pressure_message.id, MAVLink_raw_pressure_message.msgname)
        self._fieldnames = MAVLink_raw_pressure_message.fieldnames
        self._instance_field = MAVLink_raw_pressure_message.instance_field
        self._instance_offset = MAVLink_raw_pressure_message.instance_offset
        self.time_usec = time_usec
        self.press_abs = press_abs
        self.press_diff1 = press_diff1
        self.press_diff2 = press_diff2
        self.temperature = temperature

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.press_abs, self.press_diff1, self.press_diff2, self.temperature), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_raw_pressure_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_scaled_pressure_message(MAVLink_message):
    """
    The pressure readings for the typical setup of one absolute and
    differential pressure sensor. The units are as specified in each
    field.
    """

    id = MAVLINK_MSG_ID_SCALED_PRESSURE
    msgname = "SCALED_PRESSURE"
    fieldnames = ["time_boot_ms", "press_abs", "press_diff", "temperature", "temperature_press_diff"]
    ordered_fieldnames = ["time_boot_ms", "press_abs", "press_diff", "temperature", "temperature_press_diff"]
    fieldtypes = ["uint32_t", "float", "float", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "press_abs": "hPa", "press_diff": "hPa", "temperature": "cdegC", "temperature_press_diff": "cdegC"}
    native_format = bytearray(b"<Iffhh")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 115
    unpacker = struct.Struct("<Iffhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, press_abs: float, press_diff: float, temperature: int, temperature_press_diff: int = 0):
        MAVLink_message.__init__(self, MAVLink_scaled_pressure_message.id, MAVLink_scaled_pressure_message.msgname)
        self._fieldnames = MAVLink_scaled_pressure_message.fieldnames
        self._instance_field = MAVLink_scaled_pressure_message.instance_field
        self._instance_offset = MAVLink_scaled_pressure_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.press_abs = press_abs
        self.press_diff = press_diff
        self.temperature = temperature
        self.temperature_press_diff = temperature_press_diff

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.press_abs, self.press_diff, self.temperature, self.temperature_press_diff), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_scaled_pressure_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_attitude_message(MAVLink_message):
    """
    The attitude in the aeronautical frame (right-handed, Z-down,
    X-front, Y-right).
    """

    id = MAVLINK_MSG_ID_ATTITUDE
    msgname = "ATTITUDE"
    fieldnames = ["time_boot_ms", "roll", "pitch", "yaw", "rollspeed", "pitchspeed", "yawspeed"]
    ordered_fieldnames = ["time_boot_ms", "roll", "pitch", "yaw", "rollspeed", "pitchspeed", "yawspeed"]
    fieldtypes = ["uint32_t", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "roll": "rad", "pitch": "rad", "yaw": "rad", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s"}
    native_format = bytearray(b"<Iffffff")
    orders = [0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 39
    unpacker = struct.Struct("<Iffffff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, roll: float, pitch: float, yaw: float, rollspeed: float, pitchspeed: float, yawspeed: float):
        MAVLink_message.__init__(self, MAVLink_attitude_message.id, MAVLink_attitude_message.msgname)
        self._fieldnames = MAVLink_attitude_message.fieldnames
        self._instance_field = MAVLink_attitude_message.instance_field
        self._instance_offset = MAVLink_attitude_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw
        self.rollspeed = rollspeed
        self.pitchspeed = pitchspeed
        self.yawspeed = yawspeed

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.roll, self.pitch, self.yaw, self.rollspeed, self.pitchspeed, self.yawspeed), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_attitude_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_attitude_quaternion_message(MAVLink_message):
    """
    The attitude in the aeronautical frame (right-handed, Z-down,
    X-front, Y-right), expressed as quaternion. Quaternion order is w,
    x, y, z and a zero rotation would be expressed as (1 0 0 0).
    """

    id = MAVLINK_MSG_ID_ATTITUDE_QUATERNION
    msgname = "ATTITUDE_QUATERNION"
    fieldnames = ["time_boot_ms", "q1", "q2", "q3", "q4", "rollspeed", "pitchspeed", "yawspeed", "repr_offset_q"]
    ordered_fieldnames = ["time_boot_ms", "q1", "q2", "q3", "q4", "rollspeed", "pitchspeed", "yawspeed", "repr_offset_q"]
    fieldtypes = ["uint32_t", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s"}
    native_format = bytearray(b"<Iffffffff")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 4]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 4]
    crc_extra = 246
    unpacker = struct.Struct("<Ifffffff4f")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, q1: float, q2: float, q3: float, q4: float, rollspeed: float, pitchspeed: float, yawspeed: float, repr_offset_q: Sequence[float] = (0, 0, 0, 0)):
        MAVLink_message.__init__(self, MAVLink_attitude_quaternion_message.id, MAVLink_attitude_quaternion_message.msgname)
        self._fieldnames = MAVLink_attitude_quaternion_message.fieldnames
        self._instance_field = MAVLink_attitude_quaternion_message.instance_field
        self._instance_offset = MAVLink_attitude_quaternion_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.q1 = q1
        self.q2 = q2
        self.q3 = q3
        self.q4 = q4
        self.rollspeed = rollspeed
        self.pitchspeed = pitchspeed
        self.yawspeed = yawspeed
        self.repr_offset_q = repr_offset_q

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.q1, self.q2, self.q3, self.q4, self.rollspeed, self.pitchspeed, self.yawspeed, self.repr_offset_q[0], self.repr_offset_q[1], self.repr_offset_q[2], self.repr_offset_q[3]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_attitude_quaternion_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_local_position_ned_message(MAVLink_message):
    """
    The filtered local position (e.g. fused computer vision and
    accelerometers). Coordinate frame is right-handed, Z-axis down
    (aeronautical frame, NED / north-east-down convention)
    """

    id = MAVLINK_MSG_ID_LOCAL_POSITION_NED
    msgname = "LOCAL_POSITION_NED"
    fieldnames = ["time_boot_ms", "x", "y", "z", "vx", "vy", "vz"]
    ordered_fieldnames = ["time_boot_ms", "x", "y", "z", "vx", "vy", "vz"]
    fieldtypes = ["uint32_t", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s"}
    native_format = bytearray(b"<Iffffff")
    orders = [0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 185
    unpacker = struct.Struct("<Iffffff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, x: float, y: float, z: float, vx: float, vy: float, vz: float):
        MAVLink_message.__init__(self, MAVLink_local_position_ned_message.id, MAVLink_local_position_ned_message.msgname)
        self._fieldnames = MAVLink_local_position_ned_message.fieldnames
        self._instance_field = MAVLink_local_position_ned_message.instance_field
        self._instance_offset = MAVLink_local_position_ned_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.x = x
        self.y = y
        self.z = z
        self.vx = vx
        self.vy = vy
        self.vz = vz

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.x, self.y, self.z, self.vx, self.vy, self.vz), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_local_position_ned_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_global_position_int_message(MAVLink_message):
    """
    The filtered global position (e.g. fused GPS and accelerometers).
    The position is in GPS-frame (right-handed, Z-up). It
    is designed as scaled integer message since the resolution of
    float is not sufficient.
    """

    id = MAVLINK_MSG_ID_GLOBAL_POSITION_INT
    msgname = "GLOBAL_POSITION_INT"
    fieldnames = ["time_boot_ms", "lat", "lon", "alt", "relative_alt", "vx", "vy", "vz", "hdg"]
    ordered_fieldnames = ["time_boot_ms", "lat", "lon", "alt", "relative_alt", "vx", "vy", "vz", "hdg"]
    fieldtypes = ["uint32_t", "int32_t", "int32_t", "int32_t", "int32_t", "int16_t", "int16_t", "int16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "lat": "degE7", "lon": "degE7", "alt": "mm", "relative_alt": "mm", "vx": "cm/s", "vy": "cm/s", "vz": "cm/s", "hdg": "cdeg"}
    native_format = bytearray(b"<IiiiihhhH")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 104
    unpacker = struct.Struct("<IiiiihhhH")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, lat: int, lon: int, alt: int, relative_alt: int, vx: int, vy: int, vz: int, hdg: int):
        MAVLink_message.__init__(self, MAVLink_global_position_int_message.id, MAVLink_global_position_int_message.msgname)
        self._fieldnames = MAVLink_global_position_int_message.fieldnames
        self._instance_field = MAVLink_global_position_int_message.instance_field
        self._instance_offset = MAVLink_global_position_int_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.relative_alt = relative_alt
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.hdg = hdg

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.lat, self.lon, self.alt, self.relative_alt, self.vx, self.vy, self.vz, self.hdg), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_global_position_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_rc_channels_scaled_message(MAVLink_message):
    """
    The scaled values of the RC channels received: (-100%) -10000,
    (0%) 0, (100%) 10000. Channels that are inactive should be set to
    UINT16_MAX.
    """

    id = MAVLINK_MSG_ID_RC_CHANNELS_SCALED
    msgname = "RC_CHANNELS_SCALED"
    fieldnames = ["time_boot_ms", "port", "chan1_scaled", "chan2_scaled", "chan3_scaled", "chan4_scaled", "chan5_scaled", "chan6_scaled", "chan7_scaled", "chan8_scaled", "rssi"]
    ordered_fieldnames = ["time_boot_ms", "chan1_scaled", "chan2_scaled", "chan3_scaled", "chan4_scaled", "chan5_scaled", "chan6_scaled", "chan7_scaled", "chan8_scaled", "port", "rssi"]
    fieldtypes = ["uint32_t", "uint8_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<IhhhhhhhhBB")
    orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 237
    unpacker = struct.Struct("<IhhhhhhhhBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, port: int, chan1_scaled: int, chan2_scaled: int, chan3_scaled: int, chan4_scaled: int, chan5_scaled: int, chan6_scaled: int, chan7_scaled: int, chan8_scaled: int, rssi: int):
        MAVLink_message.__init__(self, MAVLink_rc_channels_scaled_message.id, MAVLink_rc_channels_scaled_message.msgname)
        self._fieldnames = MAVLink_rc_channels_scaled_message.fieldnames
        self._instance_field = MAVLink_rc_channels_scaled_message.instance_field
        self._instance_offset = MAVLink_rc_channels_scaled_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.port = port
        self.chan1_scaled = chan1_scaled
        self.chan2_scaled = chan2_scaled
        self.chan3_scaled = chan3_scaled
        self.chan4_scaled = chan4_scaled
        self.chan5_scaled = chan5_scaled
        self.chan6_scaled = chan6_scaled
        self.chan7_scaled = chan7_scaled
        self.chan8_scaled = chan8_scaled
        self.rssi = rssi

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.chan1_scaled, self.chan2_scaled, self.chan3_scaled, self.chan4_scaled, self.chan5_scaled, self.chan6_scaled, self.chan7_scaled, self.chan8_scaled, self.port, self.rssi), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_rc_channels_scaled_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_rc_channels_raw_message(MAVLink_message):
    """
    The RAW values of the RC channels received. The standard PPM
    modulation is as follows: 1000 microseconds: 0%, 2000
    microseconds: 100%. A value of UINT16_MAX implies the channel is
    unused. Individual receivers/transmitters might violate this
    specification.
    """

    id = MAVLINK_MSG_ID_RC_CHANNELS_RAW
    msgname = "RC_CHANNELS_RAW"
    fieldnames = ["time_boot_ms", "port", "chan1_raw", "chan2_raw", "chan3_raw", "chan4_raw", "chan5_raw", "chan6_raw", "chan7_raw", "chan8_raw", "rssi"]
    ordered_fieldnames = ["time_boot_ms", "chan1_raw", "chan2_raw", "chan3_raw", "chan4_raw", "chan5_raw", "chan6_raw", "chan7_raw", "chan8_raw", "port", "rssi"]
    fieldtypes = ["uint32_t", "uint8_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "chan1_raw": "us", "chan2_raw": "us", "chan3_raw": "us", "chan4_raw": "us", "chan5_raw": "us", "chan6_raw": "us", "chan7_raw": "us", "chan8_raw": "us"}
    native_format = bytearray(b"<IHHHHHHHHBB")
    orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 244
    unpacker = struct.Struct("<IHHHHHHHHBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, port: int, chan1_raw: int, chan2_raw: int, chan3_raw: int, chan4_raw: int, chan5_raw: int, chan6_raw: int, chan7_raw: int, chan8_raw: int, rssi: int):
        MAVLink_message.__init__(self, MAVLink_rc_channels_raw_message.id, MAVLink_rc_channels_raw_message.msgname)
        self._fieldnames = MAVLink_rc_channels_raw_message.fieldnames
        self._instance_field = MAVLink_rc_channels_raw_message.instance_field
        self._instance_offset = MAVLink_rc_channels_raw_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.port = port
        self.chan1_raw = chan1_raw
        self.chan2_raw = chan2_raw
        self.chan3_raw = chan3_raw
        self.chan4_raw = chan4_raw
        self.chan5_raw = chan5_raw
        self.chan6_raw = chan6_raw
        self.chan7_raw = chan7_raw
        self.chan8_raw = chan8_raw
        self.rssi = rssi

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.chan1_raw, self.chan2_raw, self.chan3_raw, self.chan4_raw, self.chan5_raw, self.chan6_raw, self.chan7_raw, self.chan8_raw, self.port, self.rssi), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_rc_channels_raw_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_servo_output_raw_message(MAVLink_message):
    """
    Superseded by ACTUATOR_OUTPUT_STATUS. The RAW values of the servo
    outputs (for RC input from the remote, use the RC_CHANNELS
    messages). The standard PPM modulation is as follows: 1000
    microseconds: 0%, 2000 microseconds: 100%.
    """

    id = MAVLINK_MSG_ID_SERVO_OUTPUT_RAW
    msgname = "SERVO_OUTPUT_RAW"
    fieldnames = ["time_usec", "port", "servo1_raw", "servo2_raw", "servo3_raw", "servo4_raw", "servo5_raw", "servo6_raw", "servo7_raw", "servo8_raw", "servo9_raw", "servo10_raw", "servo11_raw", "servo12_raw", "servo13_raw", "servo14_raw", "servo15_raw", "servo16_raw"]
    ordered_fieldnames = ["time_usec", "servo1_raw", "servo2_raw", "servo3_raw", "servo4_raw", "servo5_raw", "servo6_raw", "servo7_raw", "servo8_raw", "port", "servo9_raw", "servo10_raw", "servo11_raw", "servo12_raw", "servo13_raw", "servo14_raw", "servo15_raw", "servo16_raw"]
    fieldtypes = ["uint32_t", "uint8_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "servo1_raw": "us", "servo2_raw": "us", "servo3_raw": "us", "servo4_raw": "us", "servo5_raw": "us", "servo6_raw": "us", "servo7_raw": "us", "servo8_raw": "us", "servo9_raw": "us", "servo10_raw": "us", "servo11_raw": "us", "servo12_raw": "us", "servo13_raw": "us", "servo14_raw": "us", "servo15_raw": "us", "servo16_raw": "us"}
    native_format = bytearray(b"<IHHHHHHHHBHHHHHHHH")
    orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 222
    unpacker = struct.Struct("<IHHHHHHHHBHHHHHHHH")
    instance_field = "port"
    instance_offset = 20

    def __init__(self, time_usec: int, port: int, servo1_raw: int, servo2_raw: int, servo3_raw: int, servo4_raw: int, servo5_raw: int, servo6_raw: int, servo7_raw: int, servo8_raw: int, servo9_raw: int = 0, servo10_raw: int = 0, servo11_raw: int = 0, servo12_raw: int = 0, servo13_raw: int = 0, servo14_raw: int = 0, servo15_raw: int = 0, servo16_raw: int = 0):
        MAVLink_message.__init__(self, MAVLink_servo_output_raw_message.id, MAVLink_servo_output_raw_message.msgname)
        self._fieldnames = MAVLink_servo_output_raw_message.fieldnames
        self._instance_field = MAVLink_servo_output_raw_message.instance_field
        self._instance_offset = MAVLink_servo_output_raw_message.instance_offset
        self.time_usec = time_usec
        self.port = port
        self.servo1_raw = servo1_raw
        self.servo2_raw = servo2_raw
        self.servo3_raw = servo3_raw
        self.servo4_raw = servo4_raw
        self.servo5_raw = servo5_raw
        self.servo6_raw = servo6_raw
        self.servo7_raw = servo7_raw
        self.servo8_raw = servo8_raw
        self.servo9_raw = servo9_raw
        self.servo10_raw = servo10_raw
        self.servo11_raw = servo11_raw
        self.servo12_raw = servo12_raw
        self.servo13_raw = servo13_raw
        self.servo14_raw = servo14_raw
        self.servo15_raw = servo15_raw
        self.servo16_raw = servo16_raw

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.servo1_raw, self.servo2_raw, self.servo3_raw, self.servo4_raw, self.servo5_raw, self.servo6_raw, self.servo7_raw, self.servo8_raw, self.port, self.servo9_raw, self.servo10_raw, self.servo11_raw, self.servo12_raw, self.servo13_raw, self.servo14_raw, self.servo15_raw, self.servo16_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_servo_output_raw_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_request_partial_list_message(MAVLink_message):
    """
    Request a partial list of mission items from the system/component.
    https://mavlink.io/en/services/mission.html. If start and end
    index are the same, just send one waypoint.
    """

    id = MAVLINK_MSG_ID_MISSION_REQUEST_PARTIAL_LIST
    msgname = "MISSION_REQUEST_PARTIAL_LIST"
    fieldnames = ["target_system", "target_component", "start_index", "end_index", "mission_type"]
    ordered_fieldnames = ["start_index", "end_index", "target_system", "target_component", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "int16_t", "int16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<hhBBB")
    orders = [2, 3, 0, 1, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 212
    unpacker = struct.Struct("<hhBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, start_index: int, end_index: int, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_request_partial_list_message.id, MAVLink_mission_request_partial_list_message.msgname)
        self._fieldnames = MAVLink_mission_request_partial_list_message.fieldnames
        self._instance_field = MAVLink_mission_request_partial_list_message.instance_field
        self._instance_offset = MAVLink_mission_request_partial_list_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.start_index = start_index
        self.end_index = end_index
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.start_index, self.end_index, self.target_system, self.target_component, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_request_partial_list_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_write_partial_list_message(MAVLink_message):
    """
    This message is sent to the MAV to write a partial list. If start
    index == end index, only one item will be transmitted / updated.
    If the start index is NOT 0 and above the current list size, this
    request should be REJECTED!
    """

    id = MAVLINK_MSG_ID_MISSION_WRITE_PARTIAL_LIST
    msgname = "MISSION_WRITE_PARTIAL_LIST"
    fieldnames = ["target_system", "target_component", "start_index", "end_index", "mission_type"]
    ordered_fieldnames = ["start_index", "end_index", "target_system", "target_component", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "int16_t", "int16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<hhBBB")
    orders = [2, 3, 0, 1, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 9
    unpacker = struct.Struct("<hhBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, start_index: int, end_index: int, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_write_partial_list_message.id, MAVLink_mission_write_partial_list_message.msgname)
        self._fieldnames = MAVLink_mission_write_partial_list_message.fieldnames
        self._instance_field = MAVLink_mission_write_partial_list_message.instance_field
        self._instance_offset = MAVLink_mission_write_partial_list_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.start_index = start_index
        self.end_index = end_index
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.start_index, self.end_index, self.target_system, self.target_component, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_write_partial_list_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_item_message(MAVLink_message):
    """
    Message encoding a mission item. This message is emitted to
    announce                 the presence of a mission item and to set
    a mission item on the system. The mission item can be either in x,
    y, z meters (type: LOCAL) or x:lat, y:lon, z:altitude. Local frame
    is Z-down, right handed (NED), global frame is Z-up, right handed
    (ENU). NaN may be used to indicate an optional/default value (e.g.
    to use the system's current latitude or yaw rather than a specific
    value). See also https://mavlink.io/en/services/mission.html.
    """

    id = MAVLINK_MSG_ID_MISSION_ITEM
    msgname = "MISSION_ITEM"
    fieldnames = ["target_system", "target_component", "seq", "frame", "command", "current", "autocontinue", "param1", "param2", "param3", "param4", "x", "y", "z", "mission_type"]
    ordered_fieldnames = ["param1", "param2", "param3", "param4", "x", "y", "z", "seq", "command", "target_system", "target_component", "frame", "current", "autocontinue", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"frame": "MAV_FRAME", "command": "MAV_CMD", "mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<fffffffHHBBBBBB")
    orders = [9, 10, 7, 11, 8, 12, 13, 0, 1, 2, 3, 4, 5, 6, 14]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 254
    unpacker = struct.Struct("<fffffffHHBBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, seq: int, frame: int, command: int, current: int, autocontinue: int, param1: float, param2: float, param3: float, param4: float, x: float, y: float, z: float, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_item_message.id, MAVLink_mission_item_message.msgname)
        self._fieldnames = MAVLink_mission_item_message.fieldnames
        self._instance_field = MAVLink_mission_item_message.instance_field
        self._instance_offset = MAVLink_mission_item_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.seq = seq
        self.frame = frame
        self.command = command
        self.current = current
        self.autocontinue = autocontinue
        self.param1 = param1
        self.param2 = param2
        self.param3 = param3
        self.param4 = param4
        self.x = x
        self.y = y
        self.z = z
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param1, self.param2, self.param3, self.param4, self.x, self.y, self.z, self.seq, self.command, self.target_system, self.target_component, self.frame, self.current, self.autocontinue, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_item_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_request_message(MAVLink_message):
    """
    Request the information of the mission item with the sequence
    number seq. The response of the system to this message should be a
    MISSION_ITEM message. https://mavlink.io/en/services/mission.html
    """

    id = MAVLINK_MSG_ID_MISSION_REQUEST
    msgname = "MISSION_REQUEST"
    fieldnames = ["target_system", "target_component", "seq", "mission_type"]
    ordered_fieldnames = ["seq", "target_system", "target_component", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBBB")
    orders = [1, 2, 0, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 230
    unpacker = struct.Struct("<HBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, seq: int, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_request_message.id, MAVLink_mission_request_message.msgname)
        self._fieldnames = MAVLink_mission_request_message.fieldnames
        self._instance_field = MAVLink_mission_request_message.instance_field
        self._instance_offset = MAVLink_mission_request_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.seq = seq
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.seq, self.target_system, self.target_component, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_request_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_set_current_message(MAVLink_message):
    """
    Set the mission item with sequence number seq as current item.
    This means that the MAV will continue to this mission item on the
    shortest path (not following the mission items in-between).
    """

    id = MAVLINK_MSG_ID_MISSION_SET_CURRENT
    msgname = "MISSION_SET_CURRENT"
    fieldnames = ["target_system", "target_component", "seq"]
    ordered_fieldnames = ["seq", "target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBB")
    orders = [1, 2, 0]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 28
    unpacker = struct.Struct("<HBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, seq: int):
        MAVLink_message.__init__(self, MAVLink_mission_set_current_message.id, MAVLink_mission_set_current_message.msgname)
        self._fieldnames = MAVLink_mission_set_current_message.fieldnames
        self._instance_field = MAVLink_mission_set_current_message.instance_field
        self._instance_offset = MAVLink_mission_set_current_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.seq = seq

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.seq, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_set_current_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_current_message(MAVLink_message):
    """
    Message that announces the sequence number of the current active
    mission item. The MAV will fly towards this mission item.
    """

    id = MAVLINK_MSG_ID_MISSION_CURRENT
    msgname = "MISSION_CURRENT"
    fieldnames = ["seq", "total", "mission_state", "mission_mode"]
    ordered_fieldnames = ["seq", "total", "mission_state", "mission_mode"]
    fieldtypes = ["uint16_t", "uint16_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mission_state": "MISSION_STATE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HHBB")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 28
    unpacker = struct.Struct("<HHBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, seq: int, total: int = 0, mission_state: int = 0, mission_mode: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_current_message.id, MAVLink_mission_current_message.msgname)
        self._fieldnames = MAVLink_mission_current_message.fieldnames
        self._instance_field = MAVLink_mission_current_message.instance_field
        self._instance_offset = MAVLink_mission_current_message.instance_offset
        self.seq = seq
        self.total = total
        self.mission_state = mission_state
        self.mission_mode = mission_mode

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.seq, self.total, self.mission_state, self.mission_mode), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_current_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_request_list_message(MAVLink_message):
    """
    Request the overall list of mission items from the
    system/component.
    """

    id = MAVLINK_MSG_ID_MISSION_REQUEST_LIST
    msgname = "MISSION_REQUEST_LIST"
    fieldnames = ["target_system", "target_component", "mission_type"]
    ordered_fieldnames = ["target_system", "target_component", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBB")
    orders = [0, 1, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 132
    unpacker = struct.Struct("<BBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_request_list_message.id, MAVLink_mission_request_list_message.msgname)
        self._fieldnames = MAVLink_mission_request_list_message.fieldnames
        self._instance_field = MAVLink_mission_request_list_message.instance_field
        self._instance_offset = MAVLink_mission_request_list_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_request_list_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_count_message(MAVLink_message):
    """
    This message is emitted as response to MISSION_REQUEST_LIST by the
    MAV and to initiate a write transaction. The GCS can then request
    the individual mission item based on the knowledge of the total
    number of waypoints.
    """

    id = MAVLINK_MSG_ID_MISSION_COUNT
    msgname = "MISSION_COUNT"
    fieldnames = ["target_system", "target_component", "count", "mission_type"]
    ordered_fieldnames = ["count", "target_system", "target_component", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBBB")
    orders = [1, 2, 0, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 221
    unpacker = struct.Struct("<HBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, count: int, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_count_message.id, MAVLink_mission_count_message.msgname)
        self._fieldnames = MAVLink_mission_count_message.fieldnames
        self._instance_field = MAVLink_mission_count_message.instance_field
        self._instance_offset = MAVLink_mission_count_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.count = count
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.count, self.target_system, self.target_component, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_count_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_clear_all_message(MAVLink_message):
    """
    Delete all mission items at once.
    """

    id = MAVLINK_MSG_ID_MISSION_CLEAR_ALL
    msgname = "MISSION_CLEAR_ALL"
    fieldnames = ["target_system", "target_component", "mission_type"]
    ordered_fieldnames = ["target_system", "target_component", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBB")
    orders = [0, 1, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 232
    unpacker = struct.Struct("<BBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_clear_all_message.id, MAVLink_mission_clear_all_message.msgname)
        self._fieldnames = MAVLink_mission_clear_all_message.fieldnames
        self._instance_field = MAVLink_mission_clear_all_message.instance_field
        self._instance_offset = MAVLink_mission_clear_all_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_clear_all_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_item_reached_message(MAVLink_message):
    """
    A certain mission item has been reached. The system will either
    hold this position (or circle on the orbit) or (if the
    autocontinue on the WP was set) continue to the next waypoint.
    """

    id = MAVLINK_MSG_ID_MISSION_ITEM_REACHED
    msgname = "MISSION_ITEM_REACHED"
    fieldnames = ["seq"]
    ordered_fieldnames = ["seq"]
    fieldtypes = ["uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<H")
    orders = [0]
    lengths = [1]
    array_lengths = [0]
    crc_extra = 11
    unpacker = struct.Struct("<H")
    instance_field = None
    instance_offset = -1

    def __init__(self, seq: int):
        MAVLink_message.__init__(self, MAVLink_mission_item_reached_message.id, MAVLink_mission_item_reached_message.msgname)
        self._fieldnames = MAVLink_mission_item_reached_message.fieldnames
        self._instance_field = MAVLink_mission_item_reached_message.instance_field
        self._instance_offset = MAVLink_mission_item_reached_message.instance_offset
        self.seq = seq

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.seq), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_item_reached_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_ack_message(MAVLink_message):
    """
    Acknowledgment message during waypoint handling. The type field
    states if this message is a positive ack (type=0) or if an error
    happened (type=non-zero).
    """

    id = MAVLINK_MSG_ID_MISSION_ACK
    msgname = "MISSION_ACK"
    fieldnames = ["target_system", "target_component", "type", "mission_type"]
    ordered_fieldnames = ["target_system", "target_component", "type", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"type": "MAV_MISSION_RESULT", "mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBBB")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 153
    unpacker = struct.Struct("<BBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, type: int, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_ack_message.id, MAVLink_mission_ack_message.msgname)
        self._fieldnames = MAVLink_mission_ack_message.fieldnames
        self._instance_field = MAVLink_mission_ack_message.instance_field
        self._instance_offset = MAVLink_mission_ack_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.type = type
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self.type, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_ack_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_set_gps_global_origin_message(MAVLink_message):
    """
    Sets the GPS coordinates of the vehicle local origin (0,0,0)
    position. Vehicle should emit GPS_GLOBAL_ORIGIN irrespective of
    whether the origin is changed. This enables transform between the
    local coordinate frame and the global (GPS) coordinate frame,
    which may be necessary when (for example) indoor and outdoor
    settings are connected and the MAV should move from in- to
    outdoor.
    """

    id = MAVLINK_MSG_ID_SET_GPS_GLOBAL_ORIGIN
    msgname = "SET_GPS_GLOBAL_ORIGIN"
    fieldnames = ["target_system", "latitude", "longitude", "altitude", "time_usec"]
    ordered_fieldnames = ["latitude", "longitude", "altitude", "target_system", "time_usec"]
    fieldtypes = ["uint8_t", "int32_t", "int32_t", "int32_t", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"latitude": "degE7", "longitude": "degE7", "altitude": "mm", "time_usec": "us"}
    native_format = bytearray(b"<iiiBQ")
    orders = [3, 0, 1, 2, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 41
    unpacker = struct.Struct("<iiiBQ")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, latitude: int, longitude: int, altitude: int, time_usec: int = 0):
        MAVLink_message.__init__(self, MAVLink_set_gps_global_origin_message.id, MAVLink_set_gps_global_origin_message.msgname)
        self._fieldnames = MAVLink_set_gps_global_origin_message.fieldnames
        self._instance_field = MAVLink_set_gps_global_origin_message.instance_field
        self._instance_offset = MAVLink_set_gps_global_origin_message.instance_offset
        self.target_system = target_system
        self.latitude = latitude
        self.longitude = longitude
        self.altitude = altitude
        self.time_usec = time_usec

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.latitude, self.longitude, self.altitude, self.target_system, self.time_usec), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_set_gps_global_origin_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps_global_origin_message(MAVLink_message):
    """
    Publishes the GPS coordinates of the vehicle local origin (0,0,0)
    position. Emitted whenever a new GPS-Local position mapping is
    requested or set - e.g. following SET_GPS_GLOBAL_ORIGIN message.
    """

    id = MAVLINK_MSG_ID_GPS_GLOBAL_ORIGIN
    msgname = "GPS_GLOBAL_ORIGIN"
    fieldnames = ["latitude", "longitude", "altitude", "time_usec"]
    ordered_fieldnames = ["latitude", "longitude", "altitude", "time_usec"]
    fieldtypes = ["int32_t", "int32_t", "int32_t", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"latitude": "degE7", "longitude": "degE7", "altitude": "mm", "time_usec": "us"}
    native_format = bytearray(b"<iiiQ")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 39
    unpacker = struct.Struct("<iiiQ")
    instance_field = None
    instance_offset = -1

    def __init__(self, latitude: int, longitude: int, altitude: int, time_usec: int = 0):
        MAVLink_message.__init__(self, MAVLink_gps_global_origin_message.id, MAVLink_gps_global_origin_message.msgname)
        self._fieldnames = MAVLink_gps_global_origin_message.fieldnames
        self._instance_field = MAVLink_gps_global_origin_message.instance_field
        self._instance_offset = MAVLink_gps_global_origin_message.instance_offset
        self.latitude = latitude
        self.longitude = longitude
        self.altitude = altitude
        self.time_usec = time_usec

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.latitude, self.longitude, self.altitude, self.time_usec), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps_global_origin_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_map_rc_message(MAVLink_message):
    """
    Bind a RC channel to a parameter. The parameter should change
    according to the RC channel value.
    """

    id = MAVLINK_MSG_ID_PARAM_MAP_RC
    msgname = "PARAM_MAP_RC"
    fieldnames = ["target_system", "target_component", "param_id", "param_index", "parameter_rc_channel_index", "param_value0", "scale", "param_value_min", "param_value_max"]
    ordered_fieldnames = ["param_value0", "scale", "param_value_min", "param_value_max", "param_index", "target_system", "target_component", "param_id", "parameter_rc_channel_index"]
    fieldtypes = ["uint8_t", "uint8_t", "char", "int16_t", "uint8_t", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<ffffhBBcB")
    orders = [5, 6, 7, 4, 8, 0, 1, 2, 3]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 16, 0]
    crc_extra = 78
    unpacker = struct.Struct("<ffffhBB16sB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, param_id: bytes, param_index: int, parameter_rc_channel_index: int, param_value0: float, scale: float, param_value_min: float, param_value_max: float):
        MAVLink_message.__init__(self, MAVLink_param_map_rc_message.id, MAVLink_param_map_rc_message.msgname)
        self._fieldnames = MAVLink_param_map_rc_message.fieldnames
        self._instance_field = MAVLink_param_map_rc_message.instance_field
        self._instance_offset = MAVLink_param_map_rc_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self._param_id_raw = param_id
        self.param_id = param_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.param_index = param_index
        self.parameter_rc_channel_index = parameter_rc_channel_index
        self.param_value0 = param_value0
        self.scale = scale
        self.param_value_min = param_value_min
        self.param_value_max = param_value_max

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param_value0, self.scale, self.param_value_min, self.param_value_max, self.param_index, self.target_system, self.target_component, self._param_id_raw, self.parameter_rc_channel_index), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_map_rc_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_request_int_message(MAVLink_message):
    """
    Request the information of the mission item with the sequence
    number seq. The response of the system to this message should be a
    MISSION_ITEM_INT message.
    https://mavlink.io/en/services/mission.html
    """

    id = MAVLINK_MSG_ID_MISSION_REQUEST_INT
    msgname = "MISSION_REQUEST_INT"
    fieldnames = ["target_system", "target_component", "seq", "mission_type"]
    ordered_fieldnames = ["seq", "target_system", "target_component", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBBB")
    orders = [1, 2, 0, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 196
    unpacker = struct.Struct("<HBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, seq: int, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_request_int_message.id, MAVLink_mission_request_int_message.msgname)
        self._fieldnames = MAVLink_mission_request_int_message.fieldnames
        self._instance_field = MAVLink_mission_request_int_message.instance_field
        self._instance_offset = MAVLink_mission_request_int_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.seq = seq
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.seq, self.target_system, self.target_component, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_request_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_safety_set_allowed_area_message(MAVLink_message):
    """
    Set a safety zone (volume), which is defined by two corners of a
    cube. This message can be used to tell the MAV which
    setpoints/waypoints to accept and which to reject. Safety areas
    are often enforced by national or competition regulations.
    """

    id = MAVLINK_MSG_ID_SAFETY_SET_ALLOWED_AREA
    msgname = "SAFETY_SET_ALLOWED_AREA"
    fieldnames = ["target_system", "target_component", "frame", "p1x", "p1y", "p1z", "p2x", "p2y", "p2z"]
    ordered_fieldnames = ["p1x", "p1y", "p1z", "p2x", "p2y", "p2z", "target_system", "target_component", "frame"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"frame": "MAV_FRAME"}
    fieldunits_by_name: Dict[str, str] = {"p1x": "m", "p1y": "m", "p1z": "m", "p2x": "m", "p2y": "m", "p2z": "m"}
    native_format = bytearray(b"<ffffffBBB")
    orders = [6, 7, 8, 0, 1, 2, 3, 4, 5]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 15
    unpacker = struct.Struct("<ffffffBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, frame: int, p1x: float, p1y: float, p1z: float, p2x: float, p2y: float, p2z: float):
        MAVLink_message.__init__(self, MAVLink_safety_set_allowed_area_message.id, MAVLink_safety_set_allowed_area_message.msgname)
        self._fieldnames = MAVLink_safety_set_allowed_area_message.fieldnames
        self._instance_field = MAVLink_safety_set_allowed_area_message.instance_field
        self._instance_offset = MAVLink_safety_set_allowed_area_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.frame = frame
        self.p1x = p1x
        self.p1y = p1y
        self.p1z = p1z
        self.p2x = p2x
        self.p2y = p2y
        self.p2z = p2z

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.p1x, self.p1y, self.p1z, self.p2x, self.p2y, self.p2z, self.target_system, self.target_component, self.frame), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_safety_set_allowed_area_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_safety_allowed_area_message(MAVLink_message):
    """
    Read out the safety zone the MAV currently assumes.
    """

    id = MAVLINK_MSG_ID_SAFETY_ALLOWED_AREA
    msgname = "SAFETY_ALLOWED_AREA"
    fieldnames = ["frame", "p1x", "p1y", "p1z", "p2x", "p2y", "p2z"]
    ordered_fieldnames = ["p1x", "p1y", "p1z", "p2x", "p2y", "p2z", "frame"]
    fieldtypes = ["uint8_t", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"frame": "MAV_FRAME"}
    fieldunits_by_name: Dict[str, str] = {"p1x": "m", "p1y": "m", "p1z": "m", "p2x": "m", "p2y": "m", "p2z": "m"}
    native_format = bytearray(b"<ffffffB")
    orders = [6, 0, 1, 2, 3, 4, 5]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 3
    unpacker = struct.Struct("<ffffffB")
    instance_field = None
    instance_offset = -1

    def __init__(self, frame: int, p1x: float, p1y: float, p1z: float, p2x: float, p2y: float, p2z: float):
        MAVLink_message.__init__(self, MAVLink_safety_allowed_area_message.id, MAVLink_safety_allowed_area_message.msgname)
        self._fieldnames = MAVLink_safety_allowed_area_message.fieldnames
        self._instance_field = MAVLink_safety_allowed_area_message.instance_field
        self._instance_offset = MAVLink_safety_allowed_area_message.instance_offset
        self.frame = frame
        self.p1x = p1x
        self.p1y = p1y
        self.p1z = p1z
        self.p2x = p2x
        self.p2y = p2y
        self.p2z = p2z

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.p1x, self.p1y, self.p1z, self.p2x, self.p2y, self.p2z, self.frame), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_safety_allowed_area_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_attitude_quaternion_cov_message(MAVLink_message):
    """
    The attitude in the aeronautical frame (right-handed, Z-down,
    X-front, Y-right), expressed as quaternion. Quaternion order is w,
    x, y, z and a zero rotation would be expressed as (1 0 0 0).
    """

    id = MAVLINK_MSG_ID_ATTITUDE_QUATERNION_COV
    msgname = "ATTITUDE_QUATERNION_COV"
    fieldnames = ["time_usec", "q", "rollspeed", "pitchspeed", "yawspeed", "covariance"]
    ordered_fieldnames = ["time_usec", "q", "rollspeed", "pitchspeed", "yawspeed", "covariance"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s"}
    native_format = bytearray(b"<Qfffff")
    orders = [0, 1, 2, 3, 4, 5]
    lengths = [1, 4, 1, 1, 1, 9]
    array_lengths = [0, 4, 0, 0, 0, 9]
    crc_extra = 167
    unpacker = struct.Struct("<Q4ffff9f")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, q: Sequence[float], rollspeed: float, pitchspeed: float, yawspeed: float, covariance: Sequence[float]):
        MAVLink_message.__init__(self, MAVLink_attitude_quaternion_cov_message.id, MAVLink_attitude_quaternion_cov_message.msgname)
        self._fieldnames = MAVLink_attitude_quaternion_cov_message.fieldnames
        self._instance_field = MAVLink_attitude_quaternion_cov_message.instance_field
        self._instance_offset = MAVLink_attitude_quaternion_cov_message.instance_offset
        self.time_usec = time_usec
        self.q = q
        self.rollspeed = rollspeed
        self.pitchspeed = pitchspeed
        self.yawspeed = yawspeed
        self.covariance = covariance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.q[0], self.q[1], self.q[2], self.q[3], self.rollspeed, self.pitchspeed, self.yawspeed, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_attitude_quaternion_cov_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_nav_controller_output_message(MAVLink_message):
    """
    The state of the navigation and position controller.
    """

    id = MAVLINK_MSG_ID_NAV_CONTROLLER_OUTPUT
    msgname = "NAV_CONTROLLER_OUTPUT"
    fieldnames = ["nav_roll", "nav_pitch", "nav_bearing", "target_bearing", "wp_dist", "alt_error", "aspd_error", "xtrack_error"]
    ordered_fieldnames = ["nav_roll", "nav_pitch", "alt_error", "aspd_error", "xtrack_error", "nav_bearing", "target_bearing", "wp_dist"]
    fieldtypes = ["float", "float", "int16_t", "int16_t", "uint16_t", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"nav_roll": "deg", "nav_pitch": "deg", "nav_bearing": "deg", "target_bearing": "deg", "wp_dist": "m", "alt_error": "m", "aspd_error": "m/s", "xtrack_error": "m"}
    native_format = bytearray(b"<fffffhhH")
    orders = [0, 1, 5, 6, 7, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 183
    unpacker = struct.Struct("<fffffhhH")
    instance_field = None
    instance_offset = -1

    def __init__(self, nav_roll: float, nav_pitch: float, nav_bearing: int, target_bearing: int, wp_dist: int, alt_error: float, aspd_error: float, xtrack_error: float):
        MAVLink_message.__init__(self, MAVLink_nav_controller_output_message.id, MAVLink_nav_controller_output_message.msgname)
        self._fieldnames = MAVLink_nav_controller_output_message.fieldnames
        self._instance_field = MAVLink_nav_controller_output_message.instance_field
        self._instance_offset = MAVLink_nav_controller_output_message.instance_offset
        self.nav_roll = nav_roll
        self.nav_pitch = nav_pitch
        self.nav_bearing = nav_bearing
        self.target_bearing = target_bearing
        self.wp_dist = wp_dist
        self.alt_error = alt_error
        self.aspd_error = aspd_error
        self.xtrack_error = xtrack_error

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.nav_roll, self.nav_pitch, self.alt_error, self.aspd_error, self.xtrack_error, self.nav_bearing, self.target_bearing, self.wp_dist), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_nav_controller_output_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_global_position_int_cov_message(MAVLink_message):
    """
    The filtered global position (e.g. fused GPS and accelerometers).
    The position is in GPS-frame (right-handed, Z-up). It  is designed
    as scaled integer message since the resolution of float is not
    sufficient. NOTE: This message is intended for onboard networks /
    companion computers and higher-bandwidth links and optimized for
    accuracy and completeness. Please use the GLOBAL_POSITION_INT
    message for a minimal subset.
    """

    id = MAVLINK_MSG_ID_GLOBAL_POSITION_INT_COV
    msgname = "GLOBAL_POSITION_INT_COV"
    fieldnames = ["time_usec", "estimator_type", "lat", "lon", "alt", "relative_alt", "vx", "vy", "vz", "covariance"]
    ordered_fieldnames = ["time_usec", "lat", "lon", "alt", "relative_alt", "vx", "vy", "vz", "covariance", "estimator_type"]
    fieldtypes = ["uint64_t", "uint8_t", "int32_t", "int32_t", "int32_t", "int32_t", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"estimator_type": "MAV_ESTIMATOR_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "relative_alt": "mm", "vx": "m/s", "vy": "m/s", "vz": "m/s"}
    native_format = bytearray(b"<QiiiiffffB")
    orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 36, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 36, 0]
    crc_extra = 119
    unpacker = struct.Struct("<Qiiiifff36fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, estimator_type: int, lat: int, lon: int, alt: int, relative_alt: int, vx: float, vy: float, vz: float, covariance: Sequence[float]):
        MAVLink_message.__init__(self, MAVLink_global_position_int_cov_message.id, MAVLink_global_position_int_cov_message.msgname)
        self._fieldnames = MAVLink_global_position_int_cov_message.fieldnames
        self._instance_field = MAVLink_global_position_int_cov_message.instance_field
        self._instance_offset = MAVLink_global_position_int_cov_message.instance_offset
        self.time_usec = time_usec
        self.estimator_type = estimator_type
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.relative_alt = relative_alt
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.covariance = covariance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.lat, self.lon, self.alt, self.relative_alt, self.vx, self.vy, self.vz, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.covariance[9], self.covariance[10], self.covariance[11], self.covariance[12], self.covariance[13], self.covariance[14], self.covariance[15], self.covariance[16], self.covariance[17], self.covariance[18], self.covariance[19], self.covariance[20], self.covariance[21], self.covariance[22], self.covariance[23], self.covariance[24], self.covariance[25], self.covariance[26], self.covariance[27], self.covariance[28], self.covariance[29], self.covariance[30], self.covariance[31], self.covariance[32], self.covariance[33], self.covariance[34], self.covariance[35], self.estimator_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_global_position_int_cov_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_local_position_ned_cov_message(MAVLink_message):
    """
    The filtered local position (e.g. fused computer vision and
    accelerometers). Coordinate frame is right-handed, Z-axis down
    (aeronautical frame, NED / north-east-down convention)
    """

    id = MAVLINK_MSG_ID_LOCAL_POSITION_NED_COV
    msgname = "LOCAL_POSITION_NED_COV"
    fieldnames = ["time_usec", "estimator_type", "x", "y", "z", "vx", "vy", "vz", "ax", "ay", "az", "covariance"]
    ordered_fieldnames = ["time_usec", "x", "y", "z", "vx", "vy", "vz", "ax", "ay", "az", "covariance", "estimator_type"]
    fieldtypes = ["uint64_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"estimator_type": "MAV_ESTIMATOR_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "ax": "m/s/s", "ay": "m/s/s", "az": "m/s/s"}
    native_format = bytearray(b"<QffffffffffB")
    orders = [0, 11, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 45, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0]
    crc_extra = 191
    unpacker = struct.Struct("<Qfffffffff45fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, estimator_type: int, x: float, y: float, z: float, vx: float, vy: float, vz: float, ax: float, ay: float, az: float, covariance: Sequence[float]):
        MAVLink_message.__init__(self, MAVLink_local_position_ned_cov_message.id, MAVLink_local_position_ned_cov_message.msgname)
        self._fieldnames = MAVLink_local_position_ned_cov_message.fieldnames
        self._instance_field = MAVLink_local_position_ned_cov_message.instance_field
        self._instance_offset = MAVLink_local_position_ned_cov_message.instance_offset
        self.time_usec = time_usec
        self.estimator_type = estimator_type
        self.x = x
        self.y = y
        self.z = z
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.ax = ax
        self.ay = ay
        self.az = az
        self.covariance = covariance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.x, self.y, self.z, self.vx, self.vy, self.vz, self.ax, self.ay, self.az, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.covariance[9], self.covariance[10], self.covariance[11], self.covariance[12], self.covariance[13], self.covariance[14], self.covariance[15], self.covariance[16], self.covariance[17], self.covariance[18], self.covariance[19], self.covariance[20], self.covariance[21], self.covariance[22], self.covariance[23], self.covariance[24], self.covariance[25], self.covariance[26], self.covariance[27], self.covariance[28], self.covariance[29], self.covariance[30], self.covariance[31], self.covariance[32], self.covariance[33], self.covariance[34], self.covariance[35], self.covariance[36], self.covariance[37], self.covariance[38], self.covariance[39], self.covariance[40], self.covariance[41], self.covariance[42], self.covariance[43], self.covariance[44], self.estimator_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_local_position_ned_cov_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_rc_channels_message(MAVLink_message):
    """
    The PPM values of the RC channels received. The standard PPM
    modulation is as follows: 1000 microseconds: 0%, 2000
    microseconds: 100%.  A value of UINT16_MAX implies the channel is
    unused. Individual receivers/transmitters might violate this
    specification.
    """

    id = MAVLINK_MSG_ID_RC_CHANNELS
    msgname = "RC_CHANNELS"
    fieldnames = ["time_boot_ms", "chancount", "chan1_raw", "chan2_raw", "chan3_raw", "chan4_raw", "chan5_raw", "chan6_raw", "chan7_raw", "chan8_raw", "chan9_raw", "chan10_raw", "chan11_raw", "chan12_raw", "chan13_raw", "chan14_raw", "chan15_raw", "chan16_raw", "chan17_raw", "chan18_raw", "rssi"]
    ordered_fieldnames = ["time_boot_ms", "chan1_raw", "chan2_raw", "chan3_raw", "chan4_raw", "chan5_raw", "chan6_raw", "chan7_raw", "chan8_raw", "chan9_raw", "chan10_raw", "chan11_raw", "chan12_raw", "chan13_raw", "chan14_raw", "chan15_raw", "chan16_raw", "chan17_raw", "chan18_raw", "chancount", "rssi"]
    fieldtypes = ["uint32_t", "uint8_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "chan1_raw": "us", "chan2_raw": "us", "chan3_raw": "us", "chan4_raw": "us", "chan5_raw": "us", "chan6_raw": "us", "chan7_raw": "us", "chan8_raw": "us", "chan9_raw": "us", "chan10_raw": "us", "chan11_raw": "us", "chan12_raw": "us", "chan13_raw": "us", "chan14_raw": "us", "chan15_raw": "us", "chan16_raw": "us", "chan17_raw": "us", "chan18_raw": "us"}
    native_format = bytearray(b"<IHHHHHHHHHHHHHHHHHHBB")
    orders = [0, 19, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 118
    unpacker = struct.Struct("<IHHHHHHHHHHHHHHHHHHBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, chancount: int, chan1_raw: int, chan2_raw: int, chan3_raw: int, chan4_raw: int, chan5_raw: int, chan6_raw: int, chan7_raw: int, chan8_raw: int, chan9_raw: int, chan10_raw: int, chan11_raw: int, chan12_raw: int, chan13_raw: int, chan14_raw: int, chan15_raw: int, chan16_raw: int, chan17_raw: int, chan18_raw: int, rssi: int):
        MAVLink_message.__init__(self, MAVLink_rc_channels_message.id, MAVLink_rc_channels_message.msgname)
        self._fieldnames = MAVLink_rc_channels_message.fieldnames
        self._instance_field = MAVLink_rc_channels_message.instance_field
        self._instance_offset = MAVLink_rc_channels_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.chancount = chancount
        self.chan1_raw = chan1_raw
        self.chan2_raw = chan2_raw
        self.chan3_raw = chan3_raw
        self.chan4_raw = chan4_raw
        self.chan5_raw = chan5_raw
        self.chan6_raw = chan6_raw
        self.chan7_raw = chan7_raw
        self.chan8_raw = chan8_raw
        self.chan9_raw = chan9_raw
        self.chan10_raw = chan10_raw
        self.chan11_raw = chan11_raw
        self.chan12_raw = chan12_raw
        self.chan13_raw = chan13_raw
        self.chan14_raw = chan14_raw
        self.chan15_raw = chan15_raw
        self.chan16_raw = chan16_raw
        self.chan17_raw = chan17_raw
        self.chan18_raw = chan18_raw
        self.rssi = rssi

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.chan1_raw, self.chan2_raw, self.chan3_raw, self.chan4_raw, self.chan5_raw, self.chan6_raw, self.chan7_raw, self.chan8_raw, self.chan9_raw, self.chan10_raw, self.chan11_raw, self.chan12_raw, self.chan13_raw, self.chan14_raw, self.chan15_raw, self.chan16_raw, self.chan17_raw, self.chan18_raw, self.chancount, self.rssi), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_rc_channels_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_request_data_stream_message(MAVLink_message):
    """
    Request a data stream.
    """

    id = MAVLINK_MSG_ID_REQUEST_DATA_STREAM
    msgname = "REQUEST_DATA_STREAM"
    fieldnames = ["target_system", "target_component", "req_stream_id", "req_message_rate", "start_stop"]
    ordered_fieldnames = ["req_message_rate", "target_system", "target_component", "req_stream_id", "start_stop"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"req_message_rate": "Hz"}
    native_format = bytearray(b"<HBBBB")
    orders = [1, 2, 3, 0, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 148
    unpacker = struct.Struct("<HBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, req_stream_id: int, req_message_rate: int, start_stop: int):
        MAVLink_message.__init__(self, MAVLink_request_data_stream_message.id, MAVLink_request_data_stream_message.msgname)
        self._fieldnames = MAVLink_request_data_stream_message.fieldnames
        self._instance_field = MAVLink_request_data_stream_message.instance_field
        self._instance_offset = MAVLink_request_data_stream_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.req_stream_id = req_stream_id
        self.req_message_rate = req_message_rate
        self.start_stop = start_stop

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.req_message_rate, self.target_system, self.target_component, self.req_stream_id, self.start_stop), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_request_data_stream_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_data_stream_message(MAVLink_message):
    """
    Data stream status information.
    """

    id = MAVLINK_MSG_ID_DATA_STREAM
    msgname = "DATA_STREAM"
    fieldnames = ["stream_id", "message_rate", "on_off"]
    ordered_fieldnames = ["message_rate", "stream_id", "on_off"]
    fieldtypes = ["uint8_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"message_rate": "Hz"}
    native_format = bytearray(b"<HBB")
    orders = [1, 0, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 21
    unpacker = struct.Struct("<HBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, stream_id: int, message_rate: int, on_off: int):
        MAVLink_message.__init__(self, MAVLink_data_stream_message.id, MAVLink_data_stream_message.msgname)
        self._fieldnames = MAVLink_data_stream_message.fieldnames
        self._instance_field = MAVLink_data_stream_message.instance_field
        self._instance_offset = MAVLink_data_stream_message.instance_offset
        self.stream_id = stream_id
        self.message_rate = message_rate
        self.on_off = on_off

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.message_rate, self.stream_id, self.on_off), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_data_stream_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_manual_control_message(MAVLink_message):
    """
    This message provides an API for manually controlling the vehicle
    using standard joystick axes nomenclature, along with a joystick-
    like input device. Unused axes can be disabled and buttons states
    are transmitted as individual on/off bits of a bitmask
    """

    id = MAVLINK_MSG_ID_MANUAL_CONTROL
    msgname = "MANUAL_CONTROL"
    fieldnames = ["target", "x", "y", "z", "r", "buttons", "buttons2", "enabled_extensions", "s", "t", "aux1", "aux2", "aux3", "aux4", "aux5", "aux6"]
    ordered_fieldnames = ["x", "y", "z", "r", "buttons", "target", "buttons2", "enabled_extensions", "s", "t", "aux1", "aux2", "aux3", "aux4", "aux5", "aux6"]
    fieldtypes = ["uint8_t", "int16_t", "int16_t", "int16_t", "int16_t", "uint16_t", "uint16_t", "uint8_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<hhhhHBHBhhhhhhhh")
    orders = [5, 0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 243
    unpacker = struct.Struct("<hhhhHBHBhhhhhhhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, target: int, x: int, y: int, z: int, r: int, buttons: int, buttons2: int = 0, enabled_extensions: int = 0, s: int = 0, t: int = 0, aux1: int = 0, aux2: int = 0, aux3: int = 0, aux4: int = 0, aux5: int = 0, aux6: int = 0):
        MAVLink_message.__init__(self, MAVLink_manual_control_message.id, MAVLink_manual_control_message.msgname)
        self._fieldnames = MAVLink_manual_control_message.fieldnames
        self._instance_field = MAVLink_manual_control_message.instance_field
        self._instance_offset = MAVLink_manual_control_message.instance_offset
        self.target = target
        self.x = x
        self.y = y
        self.z = z
        self.r = r
        self.buttons = buttons
        self.buttons2 = buttons2
        self.enabled_extensions = enabled_extensions
        self.s = s
        self.t = t
        self.aux1 = aux1
        self.aux2 = aux2
        self.aux3 = aux3
        self.aux4 = aux4
        self.aux5 = aux5
        self.aux6 = aux6

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.x, self.y, self.z, self.r, self.buttons, self.target, self.buttons2, self.enabled_extensions, self.s, self.t, self.aux1, self.aux2, self.aux3, self.aux4, self.aux5, self.aux6), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_manual_control_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_rc_channels_override_message(MAVLink_message):
    """
    The RAW values of the RC channels sent to the MAV to override info
    received from the RC radio. The standard PPM modulation is as
    follows: 1000 microseconds: 0%, 2000 microseconds: 100%.
    Individual receivers/transmitters might violate this
    specification.  Note carefully the semantic differences between
    the first 8 channels and the subsequent channels
    """

    id = MAVLINK_MSG_ID_RC_CHANNELS_OVERRIDE
    msgname = "RC_CHANNELS_OVERRIDE"
    fieldnames = ["target_system", "target_component", "chan1_raw", "chan2_raw", "chan3_raw", "chan4_raw", "chan5_raw", "chan6_raw", "chan7_raw", "chan8_raw", "chan9_raw", "chan10_raw", "chan11_raw", "chan12_raw", "chan13_raw", "chan14_raw", "chan15_raw", "chan16_raw", "chan17_raw", "chan18_raw"]
    ordered_fieldnames = ["chan1_raw", "chan2_raw", "chan3_raw", "chan4_raw", "chan5_raw", "chan6_raw", "chan7_raw", "chan8_raw", "target_system", "target_component", "chan9_raw", "chan10_raw", "chan11_raw", "chan12_raw", "chan13_raw", "chan14_raw", "chan15_raw", "chan16_raw", "chan17_raw", "chan18_raw"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"chan1_raw": "us", "chan2_raw": "us", "chan3_raw": "us", "chan4_raw": "us", "chan5_raw": "us", "chan6_raw": "us", "chan7_raw": "us", "chan8_raw": "us", "chan9_raw": "us", "chan10_raw": "us", "chan11_raw": "us", "chan12_raw": "us", "chan13_raw": "us", "chan14_raw": "us", "chan15_raw": "us", "chan16_raw": "us", "chan17_raw": "us", "chan18_raw": "us"}
    native_format = bytearray(b"<HHHHHHHHBBHHHHHHHHHH")
    orders = [8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 124
    unpacker = struct.Struct("<HHHHHHHHBBHHHHHHHHHH")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, chan1_raw: int, chan2_raw: int, chan3_raw: int, chan4_raw: int, chan5_raw: int, chan6_raw: int, chan7_raw: int, chan8_raw: int, chan9_raw: int = 0, chan10_raw: int = 0, chan11_raw: int = 0, chan12_raw: int = 0, chan13_raw: int = 0, chan14_raw: int = 0, chan15_raw: int = 0, chan16_raw: int = 0, chan17_raw: int = 0, chan18_raw: int = 0):
        MAVLink_message.__init__(self, MAVLink_rc_channels_override_message.id, MAVLink_rc_channels_override_message.msgname)
        self._fieldnames = MAVLink_rc_channels_override_message.fieldnames
        self._instance_field = MAVLink_rc_channels_override_message.instance_field
        self._instance_offset = MAVLink_rc_channels_override_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.chan1_raw = chan1_raw
        self.chan2_raw = chan2_raw
        self.chan3_raw = chan3_raw
        self.chan4_raw = chan4_raw
        self.chan5_raw = chan5_raw
        self.chan6_raw = chan6_raw
        self.chan7_raw = chan7_raw
        self.chan8_raw = chan8_raw
        self.chan9_raw = chan9_raw
        self.chan10_raw = chan10_raw
        self.chan11_raw = chan11_raw
        self.chan12_raw = chan12_raw
        self.chan13_raw = chan13_raw
        self.chan14_raw = chan14_raw
        self.chan15_raw = chan15_raw
        self.chan16_raw = chan16_raw
        self.chan17_raw = chan17_raw
        self.chan18_raw = chan18_raw

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.chan1_raw, self.chan2_raw, self.chan3_raw, self.chan4_raw, self.chan5_raw, self.chan6_raw, self.chan7_raw, self.chan8_raw, self.target_system, self.target_component, self.chan9_raw, self.chan10_raw, self.chan11_raw, self.chan12_raw, self.chan13_raw, self.chan14_raw, self.chan15_raw, self.chan16_raw, self.chan17_raw, self.chan18_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_rc_channels_override_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_item_int_message(MAVLink_message):
    """
    Message encoding a mission item. This message is emitted to
    announce                 the presence of a mission item and to set
    a mission item on the system. The mission item can be either in x,
    y, z meters (type: LOCAL) or x:lat, y:lon, z:altitude. Local frame
    is Z-down, right handed (NED), global frame is Z-up, right handed
    (ENU). NaN or INT32_MAX may be used in float/integer params
    (respectively) to indicate optional/default values (e.g. to use
    the component's current latitude, yaw rather than a specific
    value). See also https://mavlink.io/en/services/mission.html.
    """

    id = MAVLINK_MSG_ID_MISSION_ITEM_INT
    msgname = "MISSION_ITEM_INT"
    fieldnames = ["target_system", "target_component", "seq", "frame", "command", "current", "autocontinue", "param1", "param2", "param3", "param4", "x", "y", "z", "mission_type"]
    ordered_fieldnames = ["param1", "param2", "param3", "param4", "x", "y", "z", "seq", "command", "target_system", "target_component", "frame", "current", "autocontinue", "mission_type"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "int32_t", "int32_t", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"frame": "MAV_FRAME", "command": "MAV_CMD", "mission_type": "MAV_MISSION_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<ffffiifHHBBBBBB")
    orders = [9, 10, 7, 11, 8, 12, 13, 0, 1, 2, 3, 4, 5, 6, 14]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 38
    unpacker = struct.Struct("<ffffiifHHBBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, seq: int, frame: int, command: int, current: int, autocontinue: int, param1: float, param2: float, param3: float, param4: float, x: int, y: int, z: float, mission_type: int = 0):
        MAVLink_message.__init__(self, MAVLink_mission_item_int_message.id, MAVLink_mission_item_int_message.msgname)
        self._fieldnames = MAVLink_mission_item_int_message.fieldnames
        self._instance_field = MAVLink_mission_item_int_message.instance_field
        self._instance_offset = MAVLink_mission_item_int_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.seq = seq
        self.frame = frame
        self.command = command
        self.current = current
        self.autocontinue = autocontinue
        self.param1 = param1
        self.param2 = param2
        self.param3 = param3
        self.param4 = param4
        self.x = x
        self.y = y
        self.z = z
        self.mission_type = mission_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param1, self.param2, self.param3, self.param4, self.x, self.y, self.z, self.seq, self.command, self.target_system, self.target_component, self.frame, self.current, self.autocontinue, self.mission_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_item_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_vfr_hud_message(MAVLink_message):
    """
    Metrics typically displayed on a HUD for fixed wing aircraft.
    """

    id = MAVLINK_MSG_ID_VFR_HUD
    msgname = "VFR_HUD"
    fieldnames = ["airspeed", "groundspeed", "heading", "throttle", "alt", "climb"]
    ordered_fieldnames = ["airspeed", "groundspeed", "alt", "climb", "heading", "throttle"]
    fieldtypes = ["float", "float", "int16_t", "uint16_t", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"airspeed": "m/s", "groundspeed": "m/s", "heading": "deg", "throttle": "%", "alt": "m", "climb": "m/s"}
    native_format = bytearray(b"<ffffhH")
    orders = [0, 1, 4, 5, 2, 3]
    lengths = [1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0]
    crc_extra = 20
    unpacker = struct.Struct("<ffffhH")
    instance_field = None
    instance_offset = -1

    def __init__(self, airspeed: float, groundspeed: float, heading: int, throttle: int, alt: float, climb: float):
        MAVLink_message.__init__(self, MAVLink_vfr_hud_message.id, MAVLink_vfr_hud_message.msgname)
        self._fieldnames = MAVLink_vfr_hud_message.fieldnames
        self._instance_field = MAVLink_vfr_hud_message.instance_field
        self._instance_offset = MAVLink_vfr_hud_message.instance_offset
        self.airspeed = airspeed
        self.groundspeed = groundspeed
        self.heading = heading
        self.throttle = throttle
        self.alt = alt
        self.climb = climb

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.airspeed, self.groundspeed, self.alt, self.climb, self.heading, self.throttle), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_vfr_hud_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_command_int_message(MAVLink_message):
    """
    Message encoding a command with parameters as scaled integers.
    Scaling depends on the actual command value. The command
    microservice is documented at
    https://mavlink.io/en/services/command.html
    """

    id = MAVLINK_MSG_ID_COMMAND_INT
    msgname = "COMMAND_INT"
    fieldnames = ["target_system", "target_component", "frame", "command", "current", "autocontinue", "param1", "param2", "param3", "param4", "x", "y", "z"]
    ordered_fieldnames = ["param1", "param2", "param3", "param4", "x", "y", "z", "command", "target_system", "target_component", "frame", "current", "autocontinue"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "int32_t", "int32_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"frame": "MAV_FRAME", "command": "MAV_CMD"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<ffffiifHBBBBB")
    orders = [8, 9, 10, 7, 11, 12, 0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 158
    unpacker = struct.Struct("<ffffiifHBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, frame: int, command: int, current: int, autocontinue: int, param1: float, param2: float, param3: float, param4: float, x: int, y: int, z: float):
        MAVLink_message.__init__(self, MAVLink_command_int_message.id, MAVLink_command_int_message.msgname)
        self._fieldnames = MAVLink_command_int_message.fieldnames
        self._instance_field = MAVLink_command_int_message.instance_field
        self._instance_offset = MAVLink_command_int_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.frame = frame
        self.command = command
        self.current = current
        self.autocontinue = autocontinue
        self.param1 = param1
        self.param2 = param2
        self.param3 = param3
        self.param4 = param4
        self.x = x
        self.y = y
        self.z = z

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param1, self.param2, self.param3, self.param4, self.x, self.y, self.z, self.command, self.target_system, self.target_component, self.frame, self.current, self.autocontinue), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_command_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_command_long_message(MAVLink_message):
    """
    Send a command with up to seven parameters to the MAV. The command
    microservice is documented at
    https://mavlink.io/en/services/command.html
    """

    id = MAVLINK_MSG_ID_COMMAND_LONG
    msgname = "COMMAND_LONG"
    fieldnames = ["target_system", "target_component", "command", "confirmation", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]
    ordered_fieldnames = ["param1", "param2", "param3", "param4", "param5", "param6", "param7", "command", "target_system", "target_component", "confirmation"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"command": "MAV_CMD"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<fffffffHBBB")
    orders = [8, 9, 7, 10, 0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 152
    unpacker = struct.Struct("<fffffffHBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, command: int, confirmation: int, param1: float, param2: float, param3: float, param4: float, param5: float, param6: float, param7: float):
        MAVLink_message.__init__(self, MAVLink_command_long_message.id, MAVLink_command_long_message.msgname)
        self._fieldnames = MAVLink_command_long_message.fieldnames
        self._instance_field = MAVLink_command_long_message.instance_field
        self._instance_offset = MAVLink_command_long_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.command = command
        self.confirmation = confirmation
        self.param1 = param1
        self.param2 = param2
        self.param3 = param3
        self.param4 = param4
        self.param5 = param5
        self.param6 = param6
        self.param7 = param7

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param1, self.param2, self.param3, self.param4, self.param5, self.param6, self.param7, self.command, self.target_system, self.target_component, self.confirmation), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_command_long_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_command_ack_message(MAVLink_message):
    """
    Report status of a command. Includes feedback whether the command
    was executed. The command microservice is documented at
    https://mavlink.io/en/services/command.html
    """

    id = MAVLINK_MSG_ID_COMMAND_ACK
    msgname = "COMMAND_ACK"
    fieldnames = ["command", "result", "progress", "result_param2", "target_system", "target_component"]
    ordered_fieldnames = ["command", "result", "progress", "result_param2", "target_system", "target_component"]
    fieldtypes = ["uint16_t", "uint8_t", "uint8_t", "int32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"command": "MAV_CMD", "result": "MAV_RESULT"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBBiBB")
    orders = [0, 1, 2, 3, 4, 5]
    lengths = [1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0]
    crc_extra = 143
    unpacker = struct.Struct("<HBBiBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, command: int, result: int, progress: int = 0, result_param2: int = 0, target_system: int = 0, target_component: int = 0):
        MAVLink_message.__init__(self, MAVLink_command_ack_message.id, MAVLink_command_ack_message.msgname)
        self._fieldnames = MAVLink_command_ack_message.fieldnames
        self._instance_field = MAVLink_command_ack_message.instance_field
        self._instance_offset = MAVLink_command_ack_message.instance_offset
        self.command = command
        self.result = result
        self.progress = progress
        self.result_param2 = result_param2
        self.target_system = target_system
        self.target_component = target_component

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.command, self.result, self.progress, self.result_param2, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_command_ack_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_manual_setpoint_message(MAVLink_message):
    """
    Setpoint in roll, pitch, yaw and thrust from the operator
    """

    id = MAVLINK_MSG_ID_MANUAL_SETPOINT
    msgname = "MANUAL_SETPOINT"
    fieldnames = ["time_boot_ms", "roll", "pitch", "yaw", "thrust", "mode_switch", "manual_override_switch"]
    ordered_fieldnames = ["time_boot_ms", "roll", "pitch", "yaw", "thrust", "mode_switch", "manual_override_switch"]
    fieldtypes = ["uint32_t", "float", "float", "float", "float", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "roll": "rad/s", "pitch": "rad/s", "yaw": "rad/s"}
    native_format = bytearray(b"<IffffBB")
    orders = [0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 106
    unpacker = struct.Struct("<IffffBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, roll: float, pitch: float, yaw: float, thrust: float, mode_switch: int, manual_override_switch: int):
        MAVLink_message.__init__(self, MAVLink_manual_setpoint_message.id, MAVLink_manual_setpoint_message.msgname)
        self._fieldnames = MAVLink_manual_setpoint_message.fieldnames
        self._instance_field = MAVLink_manual_setpoint_message.instance_field
        self._instance_offset = MAVLink_manual_setpoint_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw
        self.thrust = thrust
        self.mode_switch = mode_switch
        self.manual_override_switch = manual_override_switch

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.roll, self.pitch, self.yaw, self.thrust, self.mode_switch, self.manual_override_switch), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_manual_setpoint_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_set_attitude_target_message(MAVLink_message):
    """
    Sets a desired vehicle attitude. Used by an external controller to
    command the vehicle (manual controller or other system).
    """

    id = MAVLINK_MSG_ID_SET_ATTITUDE_TARGET
    msgname = "SET_ATTITUDE_TARGET"
    fieldnames = ["time_boot_ms", "target_system", "target_component", "type_mask", "q", "body_roll_rate", "body_pitch_rate", "body_yaw_rate", "thrust"]
    ordered_fieldnames = ["time_boot_ms", "q", "body_roll_rate", "body_pitch_rate", "body_yaw_rate", "thrust", "target_system", "target_component", "type_mask"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"type_mask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"type_mask": "ATTITUDE_TARGET_TYPEMASK"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "body_roll_rate": "rad/s", "body_pitch_rate": "rad/s", "body_yaw_rate": "rad/s"}
    native_format = bytearray(b"<IfffffBBB")
    orders = [0, 6, 7, 8, 1, 2, 3, 4, 5]
    lengths = [1, 4, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 4, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 49
    unpacker = struct.Struct("<I4fffffBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, target_system: int, target_component: int, type_mask: int, q: Sequence[float], body_roll_rate: float, body_pitch_rate: float, body_yaw_rate: float, thrust: float):
        MAVLink_message.__init__(self, MAVLink_set_attitude_target_message.id, MAVLink_set_attitude_target_message.msgname)
        self._fieldnames = MAVLink_set_attitude_target_message.fieldnames
        self._instance_field = MAVLink_set_attitude_target_message.instance_field
        self._instance_offset = MAVLink_set_attitude_target_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.target_system = target_system
        self.target_component = target_component
        self.type_mask = type_mask
        self.q = q
        self.body_roll_rate = body_roll_rate
        self.body_pitch_rate = body_pitch_rate
        self.body_yaw_rate = body_yaw_rate
        self.thrust = thrust

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.q[0], self.q[1], self.q[2], self.q[3], self.body_roll_rate, self.body_pitch_rate, self.body_yaw_rate, self.thrust, self.target_system, self.target_component, self.type_mask), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_set_attitude_target_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_attitude_target_message(MAVLink_message):
    """
    Reports the current commanded attitude of the vehicle as specified
    by the autopilot. This should match the commands sent in a
    SET_ATTITUDE_TARGET message if the vehicle is being controlled
    this way.
    """

    id = MAVLINK_MSG_ID_ATTITUDE_TARGET
    msgname = "ATTITUDE_TARGET"
    fieldnames = ["time_boot_ms", "type_mask", "q", "body_roll_rate", "body_pitch_rate", "body_yaw_rate", "thrust"]
    ordered_fieldnames = ["time_boot_ms", "q", "body_roll_rate", "body_pitch_rate", "body_yaw_rate", "thrust", "type_mask"]
    fieldtypes = ["uint32_t", "uint8_t", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"type_mask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"type_mask": "ATTITUDE_TARGET_TYPEMASK"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "body_roll_rate": "rad/s", "body_pitch_rate": "rad/s", "body_yaw_rate": "rad/s"}
    native_format = bytearray(b"<IfffffB")
    orders = [0, 6, 1, 2, 3, 4, 5]
    lengths = [1, 4, 1, 1, 1, 1, 1]
    array_lengths = [0, 4, 0, 0, 0, 0, 0]
    crc_extra = 22
    unpacker = struct.Struct("<I4fffffB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, type_mask: int, q: Sequence[float], body_roll_rate: float, body_pitch_rate: float, body_yaw_rate: float, thrust: float):
        MAVLink_message.__init__(self, MAVLink_attitude_target_message.id, MAVLink_attitude_target_message.msgname)
        self._fieldnames = MAVLink_attitude_target_message.fieldnames
        self._instance_field = MAVLink_attitude_target_message.instance_field
        self._instance_offset = MAVLink_attitude_target_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.type_mask = type_mask
        self.q = q
        self.body_roll_rate = body_roll_rate
        self.body_pitch_rate = body_pitch_rate
        self.body_yaw_rate = body_yaw_rate
        self.thrust = thrust

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.q[0], self.q[1], self.q[2], self.q[3], self.body_roll_rate, self.body_pitch_rate, self.body_yaw_rate, self.thrust, self.type_mask), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_attitude_target_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_set_position_target_local_ned_message(MAVLink_message):
    """
    Sets a desired vehicle position in a local north-east-down
    coordinate frame. Used by an external controller to command the
    vehicle (manual controller or other system).
    """

    id = MAVLINK_MSG_ID_SET_POSITION_TARGET_LOCAL_NED
    msgname = "SET_POSITION_TARGET_LOCAL_NED"
    fieldnames = ["time_boot_ms", "target_system", "target_component", "coordinate_frame", "type_mask", "x", "y", "z", "vx", "vy", "vz", "afx", "afy", "afz", "yaw", "yaw_rate"]
    ordered_fieldnames = ["time_boot_ms", "x", "y", "z", "vx", "vy", "vz", "afx", "afy", "afz", "yaw", "yaw_rate", "type_mask", "target_system", "target_component", "coordinate_frame"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t", "uint8_t", "uint16_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"type_mask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"coordinate_frame": "MAV_FRAME", "type_mask": "POSITION_TARGET_TYPEMASK"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "afx": "m/s/s", "afy": "m/s/s", "afz": "m/s/s", "yaw": "rad", "yaw_rate": "rad/s"}
    native_format = bytearray(b"<IfffffffffffHBBB")
    orders = [0, 13, 14, 15, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 143
    unpacker = struct.Struct("<IfffffffffffHBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, target_system: int, target_component: int, coordinate_frame: int, type_mask: int, x: float, y: float, z: float, vx: float, vy: float, vz: float, afx: float, afy: float, afz: float, yaw: float, yaw_rate: float):
        MAVLink_message.__init__(self, MAVLink_set_position_target_local_ned_message.id, MAVLink_set_position_target_local_ned_message.msgname)
        self._fieldnames = MAVLink_set_position_target_local_ned_message.fieldnames
        self._instance_field = MAVLink_set_position_target_local_ned_message.instance_field
        self._instance_offset = MAVLink_set_position_target_local_ned_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.target_system = target_system
        self.target_component = target_component
        self.coordinate_frame = coordinate_frame
        self.type_mask = type_mask
        self.x = x
        self.y = y
        self.z = z
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.afx = afx
        self.afy = afy
        self.afz = afz
        self.yaw = yaw
        self.yaw_rate = yaw_rate

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.x, self.y, self.z, self.vx, self.vy, self.vz, self.afx, self.afy, self.afz, self.yaw, self.yaw_rate, self.type_mask, self.target_system, self.target_component, self.coordinate_frame), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_set_position_target_local_ned_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_position_target_local_ned_message(MAVLink_message):
    """
    Reports the current commanded vehicle position, velocity, and
    acceleration as specified by the autopilot. This should match the
    commands sent in SET_POSITION_TARGET_LOCAL_NED if the vehicle is
    being controlled this way.
    """

    id = MAVLINK_MSG_ID_POSITION_TARGET_LOCAL_NED
    msgname = "POSITION_TARGET_LOCAL_NED"
    fieldnames = ["time_boot_ms", "coordinate_frame", "type_mask", "x", "y", "z", "vx", "vy", "vz", "afx", "afy", "afz", "yaw", "yaw_rate"]
    ordered_fieldnames = ["time_boot_ms", "x", "y", "z", "vx", "vy", "vz", "afx", "afy", "afz", "yaw", "yaw_rate", "type_mask", "coordinate_frame"]
    fieldtypes = ["uint32_t", "uint8_t", "uint16_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"type_mask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"coordinate_frame": "MAV_FRAME", "type_mask": "POSITION_TARGET_TYPEMASK"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "afx": "m/s/s", "afy": "m/s/s", "afz": "m/s/s", "yaw": "rad", "yaw_rate": "rad/s"}
    native_format = bytearray(b"<IfffffffffffHB")
    orders = [0, 13, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 140
    unpacker = struct.Struct("<IfffffffffffHB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, coordinate_frame: int, type_mask: int, x: float, y: float, z: float, vx: float, vy: float, vz: float, afx: float, afy: float, afz: float, yaw: float, yaw_rate: float):
        MAVLink_message.__init__(self, MAVLink_position_target_local_ned_message.id, MAVLink_position_target_local_ned_message.msgname)
        self._fieldnames = MAVLink_position_target_local_ned_message.fieldnames
        self._instance_field = MAVLink_position_target_local_ned_message.instance_field
        self._instance_offset = MAVLink_position_target_local_ned_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.coordinate_frame = coordinate_frame
        self.type_mask = type_mask
        self.x = x
        self.y = y
        self.z = z
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.afx = afx
        self.afy = afy
        self.afz = afz
        self.yaw = yaw
        self.yaw_rate = yaw_rate

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.x, self.y, self.z, self.vx, self.vy, self.vz, self.afx, self.afy, self.afz, self.yaw, self.yaw_rate, self.type_mask, self.coordinate_frame), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_position_target_local_ned_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_set_position_target_global_int_message(MAVLink_message):
    """
    Sets a desired vehicle position, velocity, and/or acceleration in
    a global coordinate system (WGS84). Used by an external controller
    to command the vehicle (manual controller or other system).
    """

    id = MAVLINK_MSG_ID_SET_POSITION_TARGET_GLOBAL_INT
    msgname = "SET_POSITION_TARGET_GLOBAL_INT"
    fieldnames = ["time_boot_ms", "target_system", "target_component", "coordinate_frame", "type_mask", "lat_int", "lon_int", "alt", "vx", "vy", "vz", "afx", "afy", "afz", "yaw", "yaw_rate"]
    ordered_fieldnames = ["time_boot_ms", "lat_int", "lon_int", "alt", "vx", "vy", "vz", "afx", "afy", "afz", "yaw", "yaw_rate", "type_mask", "target_system", "target_component", "coordinate_frame"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t", "uint8_t", "uint16_t", "int32_t", "int32_t", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"type_mask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"coordinate_frame": "MAV_FRAME", "type_mask": "POSITION_TARGET_TYPEMASK"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "lat_int": "degE7", "lon_int": "degE7", "alt": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "afx": "m/s/s", "afy": "m/s/s", "afz": "m/s/s", "yaw": "rad", "yaw_rate": "rad/s"}
    native_format = bytearray(b"<IiifffffffffHBBB")
    orders = [0, 13, 14, 15, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 5
    unpacker = struct.Struct("<IiifffffffffHBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, target_system: int, target_component: int, coordinate_frame: int, type_mask: int, lat_int: int, lon_int: int, alt: float, vx: float, vy: float, vz: float, afx: float, afy: float, afz: float, yaw: float, yaw_rate: float):
        MAVLink_message.__init__(self, MAVLink_set_position_target_global_int_message.id, MAVLink_set_position_target_global_int_message.msgname)
        self._fieldnames = MAVLink_set_position_target_global_int_message.fieldnames
        self._instance_field = MAVLink_set_position_target_global_int_message.instance_field
        self._instance_offset = MAVLink_set_position_target_global_int_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.target_system = target_system
        self.target_component = target_component
        self.coordinate_frame = coordinate_frame
        self.type_mask = type_mask
        self.lat_int = lat_int
        self.lon_int = lon_int
        self.alt = alt
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.afx = afx
        self.afy = afy
        self.afz = afz
        self.yaw = yaw
        self.yaw_rate = yaw_rate

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.lat_int, self.lon_int, self.alt, self.vx, self.vy, self.vz, self.afx, self.afy, self.afz, self.yaw, self.yaw_rate, self.type_mask, self.target_system, self.target_component, self.coordinate_frame), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_set_position_target_global_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_position_target_global_int_message(MAVLink_message):
    """
    Reports the current commanded vehicle position, velocity, and
    acceleration as specified by the autopilot. This should match the
    commands sent in SET_POSITION_TARGET_GLOBAL_INT if the vehicle is
    being controlled this way.
    """

    id = MAVLINK_MSG_ID_POSITION_TARGET_GLOBAL_INT
    msgname = "POSITION_TARGET_GLOBAL_INT"
    fieldnames = ["time_boot_ms", "coordinate_frame", "type_mask", "lat_int", "lon_int", "alt", "vx", "vy", "vz", "afx", "afy", "afz", "yaw", "yaw_rate"]
    ordered_fieldnames = ["time_boot_ms", "lat_int", "lon_int", "alt", "vx", "vy", "vz", "afx", "afy", "afz", "yaw", "yaw_rate", "type_mask", "coordinate_frame"]
    fieldtypes = ["uint32_t", "uint8_t", "uint16_t", "int32_t", "int32_t", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"type_mask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"coordinate_frame": "MAV_FRAME", "type_mask": "POSITION_TARGET_TYPEMASK"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "lat_int": "degE7", "lon_int": "degE7", "alt": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "afx": "m/s/s", "afy": "m/s/s", "afz": "m/s/s", "yaw": "rad", "yaw_rate": "rad/s"}
    native_format = bytearray(b"<IiifffffffffHB")
    orders = [0, 13, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 150
    unpacker = struct.Struct("<IiifffffffffHB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, coordinate_frame: int, type_mask: int, lat_int: int, lon_int: int, alt: float, vx: float, vy: float, vz: float, afx: float, afy: float, afz: float, yaw: float, yaw_rate: float):
        MAVLink_message.__init__(self, MAVLink_position_target_global_int_message.id, MAVLink_position_target_global_int_message.msgname)
        self._fieldnames = MAVLink_position_target_global_int_message.fieldnames
        self._instance_field = MAVLink_position_target_global_int_message.instance_field
        self._instance_offset = MAVLink_position_target_global_int_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.coordinate_frame = coordinate_frame
        self.type_mask = type_mask
        self.lat_int = lat_int
        self.lon_int = lon_int
        self.alt = alt
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.afx = afx
        self.afy = afy
        self.afz = afz
        self.yaw = yaw
        self.yaw_rate = yaw_rate

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.lat_int, self.lon_int, self.alt, self.vx, self.vy, self.vz, self.afx, self.afy, self.afz, self.yaw, self.yaw_rate, self.type_mask, self.coordinate_frame), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_position_target_global_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_local_position_ned_system_global_offset_message(MAVLink_message):
    """
    The offset in X, Y, Z and yaw between the LOCAL_POSITION_NED
    messages of MAV X and the global coordinate frame in NED
    coordinates. Coordinate frame is right-handed, Z-axis down
    (aeronautical frame, NED / north-east-down convention)
    """

    id = MAVLINK_MSG_ID_LOCAL_POSITION_NED_SYSTEM_GLOBAL_OFFSET
    msgname = "LOCAL_POSITION_NED_SYSTEM_GLOBAL_OFFSET"
    fieldnames = ["time_boot_ms", "x", "y", "z", "roll", "pitch", "yaw"]
    ordered_fieldnames = ["time_boot_ms", "x", "y", "z", "roll", "pitch", "yaw"]
    fieldtypes = ["uint32_t", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "x": "m", "y": "m", "z": "m", "roll": "rad", "pitch": "rad", "yaw": "rad"}
    native_format = bytearray(b"<Iffffff")
    orders = [0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 231
    unpacker = struct.Struct("<Iffffff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, x: float, y: float, z: float, roll: float, pitch: float, yaw: float):
        MAVLink_message.__init__(self, MAVLink_local_position_ned_system_global_offset_message.id, MAVLink_local_position_ned_system_global_offset_message.msgname)
        self._fieldnames = MAVLink_local_position_ned_system_global_offset_message.fieldnames
        self._instance_field = MAVLink_local_position_ned_system_global_offset_message.instance_field
        self._instance_offset = MAVLink_local_position_ned_system_global_offset_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.x = x
        self.y = y
        self.z = z
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.x, self.y, self.z, self.roll, self.pitch, self.yaw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_local_position_ned_system_global_offset_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hil_state_message(MAVLink_message):
    """
    Sent from simulation to autopilot. This packet is useful for high
    throughput applications such as hardware in the loop simulations.
    """

    id = MAVLINK_MSG_ID_HIL_STATE
    msgname = "HIL_STATE"
    fieldnames = ["time_usec", "roll", "pitch", "yaw", "rollspeed", "pitchspeed", "yawspeed", "lat", "lon", "alt", "vx", "vy", "vz", "xacc", "yacc", "zacc"]
    ordered_fieldnames = ["time_usec", "roll", "pitch", "yaw", "rollspeed", "pitchspeed", "yawspeed", "lat", "lon", "alt", "vx", "vy", "vz", "xacc", "yacc", "zacc"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "int32_t", "int32_t", "int32_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "roll": "rad", "pitch": "rad", "yaw": "rad", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s", "lat": "degE7", "lon": "degE7", "alt": "mm", "vx": "cm/s", "vy": "cm/s", "vz": "cm/s", "xacc": "mG", "yacc": "mG", "zacc": "mG"}
    native_format = bytearray(b"<Qffffffiiihhhhhh")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 183
    unpacker = struct.Struct("<Qffffffiiihhhhhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, roll: float, pitch: float, yaw: float, rollspeed: float, pitchspeed: float, yawspeed: float, lat: int, lon: int, alt: int, vx: int, vy: int, vz: int, xacc: int, yacc: int, zacc: int):
        MAVLink_message.__init__(self, MAVLink_hil_state_message.id, MAVLink_hil_state_message.msgname)
        self._fieldnames = MAVLink_hil_state_message.fieldnames
        self._instance_field = MAVLink_hil_state_message.instance_field
        self._instance_offset = MAVLink_hil_state_message.instance_offset
        self.time_usec = time_usec
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw
        self.rollspeed = rollspeed
        self.pitchspeed = pitchspeed
        self.yawspeed = yawspeed
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.roll, self.pitch, self.yaw, self.rollspeed, self.pitchspeed, self.yawspeed, self.lat, self.lon, self.alt, self.vx, self.vy, self.vz, self.xacc, self.yacc, self.zacc), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hil_state_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hil_controls_message(MAVLink_message):
    """
    Sent from autopilot to simulation. Hardware in the loop control
    outputs
    """

    id = MAVLINK_MSG_ID_HIL_CONTROLS
    msgname = "HIL_CONTROLS"
    fieldnames = ["time_usec", "roll_ailerons", "pitch_elevator", "yaw_rudder", "throttle", "aux1", "aux2", "aux3", "aux4", "mode", "nav_mode"]
    ordered_fieldnames = ["time_usec", "roll_ailerons", "pitch_elevator", "yaw_rudder", "throttle", "aux1", "aux2", "aux3", "aux4", "mode", "nav_mode"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "float", "float", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mode": "MAV_MODE"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QffffffffBB")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 63
    unpacker = struct.Struct("<QffffffffBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, roll_ailerons: float, pitch_elevator: float, yaw_rudder: float, throttle: float, aux1: float, aux2: float, aux3: float, aux4: float, mode: int, nav_mode: int):
        MAVLink_message.__init__(self, MAVLink_hil_controls_message.id, MAVLink_hil_controls_message.msgname)
        self._fieldnames = MAVLink_hil_controls_message.fieldnames
        self._instance_field = MAVLink_hil_controls_message.instance_field
        self._instance_offset = MAVLink_hil_controls_message.instance_offset
        self.time_usec = time_usec
        self.roll_ailerons = roll_ailerons
        self.pitch_elevator = pitch_elevator
        self.yaw_rudder = yaw_rudder
        self.throttle = throttle
        self.aux1 = aux1
        self.aux2 = aux2
        self.aux3 = aux3
        self.aux4 = aux4
        self.mode = mode
        self.nav_mode = nav_mode

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.roll_ailerons, self.pitch_elevator, self.yaw_rudder, self.throttle, self.aux1, self.aux2, self.aux3, self.aux4, self.mode, self.nav_mode), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hil_controls_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hil_rc_inputs_raw_message(MAVLink_message):
    """
    Sent from simulation to autopilot. The RAW values of the RC
    channels received. The standard PPM modulation is as follows: 1000
    microseconds: 0%, 2000 microseconds: 100%. Individual
    receivers/transmitters might violate this specification.
    """

    id = MAVLINK_MSG_ID_HIL_RC_INPUTS_RAW
    msgname = "HIL_RC_INPUTS_RAW"
    fieldnames = ["time_usec", "chan1_raw", "chan2_raw", "chan3_raw", "chan4_raw", "chan5_raw", "chan6_raw", "chan7_raw", "chan8_raw", "chan9_raw", "chan10_raw", "chan11_raw", "chan12_raw", "rssi"]
    ordered_fieldnames = ["time_usec", "chan1_raw", "chan2_raw", "chan3_raw", "chan4_raw", "chan5_raw", "chan6_raw", "chan7_raw", "chan8_raw", "chan9_raw", "chan10_raw", "chan11_raw", "chan12_raw", "rssi"]
    fieldtypes = ["uint64_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "chan1_raw": "us", "chan2_raw": "us", "chan3_raw": "us", "chan4_raw": "us", "chan5_raw": "us", "chan6_raw": "us", "chan7_raw": "us", "chan8_raw": "us", "chan9_raw": "us", "chan10_raw": "us", "chan11_raw": "us", "chan12_raw": "us"}
    native_format = bytearray(b"<QHHHHHHHHHHHHB")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 54
    unpacker = struct.Struct("<QHHHHHHHHHHHHB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, chan1_raw: int, chan2_raw: int, chan3_raw: int, chan4_raw: int, chan5_raw: int, chan6_raw: int, chan7_raw: int, chan8_raw: int, chan9_raw: int, chan10_raw: int, chan11_raw: int, chan12_raw: int, rssi: int):
        MAVLink_message.__init__(self, MAVLink_hil_rc_inputs_raw_message.id, MAVLink_hil_rc_inputs_raw_message.msgname)
        self._fieldnames = MAVLink_hil_rc_inputs_raw_message.fieldnames
        self._instance_field = MAVLink_hil_rc_inputs_raw_message.instance_field
        self._instance_offset = MAVLink_hil_rc_inputs_raw_message.instance_offset
        self.time_usec = time_usec
        self.chan1_raw = chan1_raw
        self.chan2_raw = chan2_raw
        self.chan3_raw = chan3_raw
        self.chan4_raw = chan4_raw
        self.chan5_raw = chan5_raw
        self.chan6_raw = chan6_raw
        self.chan7_raw = chan7_raw
        self.chan8_raw = chan8_raw
        self.chan9_raw = chan9_raw
        self.chan10_raw = chan10_raw
        self.chan11_raw = chan11_raw
        self.chan12_raw = chan12_raw
        self.rssi = rssi

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.chan1_raw, self.chan2_raw, self.chan3_raw, self.chan4_raw, self.chan5_raw, self.chan6_raw, self.chan7_raw, self.chan8_raw, self.chan9_raw, self.chan10_raw, self.chan11_raw, self.chan12_raw, self.rssi), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hil_rc_inputs_raw_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hil_actuator_controls_message(MAVLink_message):
    """
    Sent from autopilot to simulation. Hardware in the loop control
    outputs (replacement for HIL_CONTROLS)
    """

    id = MAVLINK_MSG_ID_HIL_ACTUATOR_CONTROLS
    msgname = "HIL_ACTUATOR_CONTROLS"
    fieldnames = ["time_usec", "controls", "mode", "flags"]
    ordered_fieldnames = ["time_usec", "flags", "controls", "mode"]
    fieldtypes = ["uint64_t", "float", "uint8_t", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {"mode": "bitmask", "flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"mode": "MAV_MODE_FLAG"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QQfB")
    orders = [0, 2, 3, 1]
    lengths = [1, 1, 16, 1]
    array_lengths = [0, 0, 16, 0]
    crc_extra = 47
    unpacker = struct.Struct("<QQ16fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, controls: Sequence[float], mode: int, flags: int):
        MAVLink_message.__init__(self, MAVLink_hil_actuator_controls_message.id, MAVLink_hil_actuator_controls_message.msgname)
        self._fieldnames = MAVLink_hil_actuator_controls_message.fieldnames
        self._instance_field = MAVLink_hil_actuator_controls_message.instance_field
        self._instance_offset = MAVLink_hil_actuator_controls_message.instance_offset
        self.time_usec = time_usec
        self.controls = controls
        self.mode = mode
        self.flags = flags

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.flags, self.controls[0], self.controls[1], self.controls[2], self.controls[3], self.controls[4], self.controls[5], self.controls[6], self.controls[7], self.controls[8], self.controls[9], self.controls[10], self.controls[11], self.controls[12], self.controls[13], self.controls[14], self.controls[15], self.mode), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hil_actuator_controls_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_optical_flow_message(MAVLink_message):
    """
    Optical flow from a flow sensor (e.g. optical mouse sensor)
    """

    id = MAVLINK_MSG_ID_OPTICAL_FLOW
    msgname = "OPTICAL_FLOW"
    fieldnames = ["time_usec", "sensor_id", "flow_x", "flow_y", "flow_comp_m_x", "flow_comp_m_y", "quality", "ground_distance", "flow_rate_x", "flow_rate_y"]
    ordered_fieldnames = ["time_usec", "flow_comp_m_x", "flow_comp_m_y", "ground_distance", "flow_x", "flow_y", "sensor_id", "quality", "flow_rate_x", "flow_rate_y"]
    fieldtypes = ["uint64_t", "uint8_t", "int16_t", "int16_t", "float", "float", "uint8_t", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "flow_x": "rad/s", "flow_y": "rad/s", "flow_comp_m_x": "m/s", "flow_comp_m_y": "m/s", "ground_distance": "m", "flow_rate_x": "rad/s", "flow_rate_y": "rad/s"}
    native_format = bytearray(b"<QfffhhBBff")
    orders = [0, 6, 4, 5, 1, 2, 7, 3, 8, 9]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 175
    unpacker = struct.Struct("<QfffhhBBff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, sensor_id: int, flow_x: int, flow_y: int, flow_comp_m_x: float, flow_comp_m_y: float, quality: int, ground_distance: float, flow_rate_x: float = 0, flow_rate_y: float = 0):
        MAVLink_message.__init__(self, MAVLink_optical_flow_message.id, MAVLink_optical_flow_message.msgname)
        self._fieldnames = MAVLink_optical_flow_message.fieldnames
        self._instance_field = MAVLink_optical_flow_message.instance_field
        self._instance_offset = MAVLink_optical_flow_message.instance_offset
        self.time_usec = time_usec
        self.sensor_id = sensor_id
        self.flow_x = flow_x
        self.flow_y = flow_y
        self.flow_comp_m_x = flow_comp_m_x
        self.flow_comp_m_y = flow_comp_m_y
        self.quality = quality
        self.ground_distance = ground_distance
        self.flow_rate_x = flow_rate_x
        self.flow_rate_y = flow_rate_y

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.flow_comp_m_x, self.flow_comp_m_y, self.ground_distance, self.flow_x, self.flow_y, self.sensor_id, self.quality, self.flow_rate_x, self.flow_rate_y), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_optical_flow_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_global_vision_position_estimate_message(MAVLink_message):
    """
    Global position/attitude estimate from a vision source.
    """

    id = MAVLINK_MSG_ID_GLOBAL_VISION_POSITION_ESTIMATE
    msgname = "GLOBAL_VISION_POSITION_ESTIMATE"
    fieldnames = ["usec", "x", "y", "z", "roll", "pitch", "yaw", "covariance", "reset_counter"]
    ordered_fieldnames = ["usec", "x", "y", "z", "roll", "pitch", "yaw", "covariance", "reset_counter"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"usec": "us", "x": "m", "y": "m", "z": "m", "roll": "rad", "pitch": "rad", "yaw": "rad"}
    native_format = bytearray(b"<QfffffffB")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 21, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 21, 0]
    crc_extra = 102
    unpacker = struct.Struct("<Qffffff21fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, usec: int, x: float, y: float, z: float, roll: float, pitch: float, yaw: float, covariance: Sequence[float] = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), reset_counter: int = 0):
        MAVLink_message.__init__(self, MAVLink_global_vision_position_estimate_message.id, MAVLink_global_vision_position_estimate_message.msgname)
        self._fieldnames = MAVLink_global_vision_position_estimate_message.fieldnames
        self._instance_field = MAVLink_global_vision_position_estimate_message.instance_field
        self._instance_offset = MAVLink_global_vision_position_estimate_message.instance_offset
        self.usec = usec
        self.x = x
        self.y = y
        self.z = z
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw
        self.covariance = covariance
        self.reset_counter = reset_counter

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.usec, self.x, self.y, self.z, self.roll, self.pitch, self.yaw, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.covariance[9], self.covariance[10], self.covariance[11], self.covariance[12], self.covariance[13], self.covariance[14], self.covariance[15], self.covariance[16], self.covariance[17], self.covariance[18], self.covariance[19], self.covariance[20], self.reset_counter), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_global_vision_position_estimate_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_vision_position_estimate_message(MAVLink_message):
    """
    Local position/attitude estimate from a vision source.
    """

    id = MAVLINK_MSG_ID_VISION_POSITION_ESTIMATE
    msgname = "VISION_POSITION_ESTIMATE"
    fieldnames = ["usec", "x", "y", "z", "roll", "pitch", "yaw", "covariance", "reset_counter"]
    ordered_fieldnames = ["usec", "x", "y", "z", "roll", "pitch", "yaw", "covariance", "reset_counter"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"usec": "us", "x": "m", "y": "m", "z": "m", "roll": "rad", "pitch": "rad", "yaw": "rad"}
    native_format = bytearray(b"<QfffffffB")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 21, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 21, 0]
    crc_extra = 158
    unpacker = struct.Struct("<Qffffff21fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, usec: int, x: float, y: float, z: float, roll: float, pitch: float, yaw: float, covariance: Sequence[float] = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), reset_counter: int = 0):
        MAVLink_message.__init__(self, MAVLink_vision_position_estimate_message.id, MAVLink_vision_position_estimate_message.msgname)
        self._fieldnames = MAVLink_vision_position_estimate_message.fieldnames
        self._instance_field = MAVLink_vision_position_estimate_message.instance_field
        self._instance_offset = MAVLink_vision_position_estimate_message.instance_offset
        self.usec = usec
        self.x = x
        self.y = y
        self.z = z
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw
        self.covariance = covariance
        self.reset_counter = reset_counter

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.usec, self.x, self.y, self.z, self.roll, self.pitch, self.yaw, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.covariance[9], self.covariance[10], self.covariance[11], self.covariance[12], self.covariance[13], self.covariance[14], self.covariance[15], self.covariance[16], self.covariance[17], self.covariance[18], self.covariance[19], self.covariance[20], self.reset_counter), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_vision_position_estimate_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_vision_speed_estimate_message(MAVLink_message):
    """
    Speed estimate from a vision source.
    """

    id = MAVLINK_MSG_ID_VISION_SPEED_ESTIMATE
    msgname = "VISION_SPEED_ESTIMATE"
    fieldnames = ["usec", "x", "y", "z", "covariance", "reset_counter"]
    ordered_fieldnames = ["usec", "x", "y", "z", "covariance", "reset_counter"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"usec": "us", "x": "m/s", "y": "m/s", "z": "m/s"}
    native_format = bytearray(b"<QffffB")
    orders = [0, 1, 2, 3, 4, 5]
    lengths = [1, 1, 1, 1, 9, 1]
    array_lengths = [0, 0, 0, 0, 9, 0]
    crc_extra = 208
    unpacker = struct.Struct("<Qfff9fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, usec: int, x: float, y: float, z: float, covariance: Sequence[float] = (0, 0, 0, 0, 0, 0, 0, 0, 0), reset_counter: int = 0):
        MAVLink_message.__init__(self, MAVLink_vision_speed_estimate_message.id, MAVLink_vision_speed_estimate_message.msgname)
        self._fieldnames = MAVLink_vision_speed_estimate_message.fieldnames
        self._instance_field = MAVLink_vision_speed_estimate_message.instance_field
        self._instance_offset = MAVLink_vision_speed_estimate_message.instance_offset
        self.usec = usec
        self.x = x
        self.y = y
        self.z = z
        self.covariance = covariance
        self.reset_counter = reset_counter

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.usec, self.x, self.y, self.z, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.reset_counter), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_vision_speed_estimate_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_vicon_position_estimate_message(MAVLink_message):
    """
    Global position estimate from a Vicon motion system source.
    """

    id = MAVLINK_MSG_ID_VICON_POSITION_ESTIMATE
    msgname = "VICON_POSITION_ESTIMATE"
    fieldnames = ["usec", "x", "y", "z", "roll", "pitch", "yaw", "covariance"]
    ordered_fieldnames = ["usec", "x", "y", "z", "roll", "pitch", "yaw", "covariance"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"usec": "us", "x": "m", "y": "m", "z": "m", "roll": "rad", "pitch": "rad", "yaw": "rad"}
    native_format = bytearray(b"<Qfffffff")
    orders = [0, 1, 2, 3, 4, 5, 6, 7]
    lengths = [1, 1, 1, 1, 1, 1, 1, 21]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 21]
    crc_extra = 56
    unpacker = struct.Struct("<Qffffff21f")
    instance_field = None
    instance_offset = -1

    def __init__(self, usec: int, x: float, y: float, z: float, roll: float, pitch: float, yaw: float, covariance: Sequence[float] = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)):
        MAVLink_message.__init__(self, MAVLink_vicon_position_estimate_message.id, MAVLink_vicon_position_estimate_message.msgname)
        self._fieldnames = MAVLink_vicon_position_estimate_message.fieldnames
        self._instance_field = MAVLink_vicon_position_estimate_message.instance_field
        self._instance_offset = MAVLink_vicon_position_estimate_message.instance_offset
        self.usec = usec
        self.x = x
        self.y = y
        self.z = z
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw
        self.covariance = covariance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.usec, self.x, self.y, self.z, self.roll, self.pitch, self.yaw, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.covariance[9], self.covariance[10], self.covariance[11], self.covariance[12], self.covariance[13], self.covariance[14], self.covariance[15], self.covariance[16], self.covariance[17], self.covariance[18], self.covariance[19], self.covariance[20]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_vicon_position_estimate_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_highres_imu_message(MAVLink_message):
    """
    The IMU readings in SI units in NED body frame
    """

    id = MAVLINK_MSG_ID_HIGHRES_IMU
    msgname = "HIGHRES_IMU"
    fieldnames = ["time_usec", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "abs_pressure", "diff_pressure", "pressure_alt", "temperature", "fields_updated", "id"]
    ordered_fieldnames = ["time_usec", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "abs_pressure", "diff_pressure", "pressure_alt", "temperature", "fields_updated", "id"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"fields_updated": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "xacc": "m/s/s", "yacc": "m/s/s", "zacc": "m/s/s", "xgyro": "rad/s", "ygyro": "rad/s", "zgyro": "rad/s", "xmag": "gauss", "ymag": "gauss", "zmag": "gauss", "abs_pressure": "hPa", "diff_pressure": "hPa", "temperature": "degC"}
    native_format = bytearray(b"<QfffffffffffffHB")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 93
    unpacker = struct.Struct("<QfffffffffffffHB")
    instance_field = "id"
    instance_offset = 62

    def __init__(self, time_usec: int, xacc: float, yacc: float, zacc: float, xgyro: float, ygyro: float, zgyro: float, xmag: float, ymag: float, zmag: float, abs_pressure: float, diff_pressure: float, pressure_alt: float, temperature: float, fields_updated: int, id: int = 0):
        MAVLink_message.__init__(self, MAVLink_highres_imu_message.id, MAVLink_highres_imu_message.msgname)
        self._fieldnames = MAVLink_highres_imu_message.fieldnames
        self._instance_field = MAVLink_highres_imu_message.instance_field
        self._instance_offset = MAVLink_highres_imu_message.instance_offset
        self.time_usec = time_usec
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc
        self.xgyro = xgyro
        self.ygyro = ygyro
        self.zgyro = zgyro
        self.xmag = xmag
        self.ymag = ymag
        self.zmag = zmag
        self.abs_pressure = abs_pressure
        self.diff_pressure = diff_pressure
        self.pressure_alt = pressure_alt
        self.temperature = temperature
        self.fields_updated = fields_updated
        self.id = id

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag, self.abs_pressure, self.diff_pressure, self.pressure_alt, self.temperature, self.fields_updated, self.id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_highres_imu_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_optical_flow_rad_message(MAVLink_message):
    """
    Optical flow from an angular rate flow sensor (e.g. PX4FLOW or
    mouse sensor)
    """

    id = MAVLINK_MSG_ID_OPTICAL_FLOW_RAD
    msgname = "OPTICAL_FLOW_RAD"
    fieldnames = ["time_usec", "sensor_id", "integration_time_us", "integrated_x", "integrated_y", "integrated_xgyro", "integrated_ygyro", "integrated_zgyro", "temperature", "quality", "time_delta_distance_us", "distance"]
    ordered_fieldnames = ["time_usec", "integration_time_us", "integrated_x", "integrated_y", "integrated_xgyro", "integrated_ygyro", "integrated_zgyro", "time_delta_distance_us", "distance", "temperature", "sensor_id", "quality"]
    fieldtypes = ["uint64_t", "uint8_t", "uint32_t", "float", "float", "float", "float", "float", "int16_t", "uint8_t", "uint32_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "integration_time_us": "us", "integrated_x": "rad", "integrated_y": "rad", "integrated_xgyro": "rad", "integrated_ygyro": "rad", "integrated_zgyro": "rad", "temperature": "cdegC", "time_delta_distance_us": "us", "distance": "m"}
    native_format = bytearray(b"<QIfffffIfhBB")
    orders = [0, 10, 1, 2, 3, 4, 5, 6, 9, 11, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 138
    unpacker = struct.Struct("<QIfffffIfhBB")
    instance_field = "sensor_id"
    instance_offset = 42

    def __init__(self, time_usec: int, sensor_id: int, integration_time_us: int, integrated_x: float, integrated_y: float, integrated_xgyro: float, integrated_ygyro: float, integrated_zgyro: float, temperature: int, quality: int, time_delta_distance_us: int, distance: float):
        MAVLink_message.__init__(self, MAVLink_optical_flow_rad_message.id, MAVLink_optical_flow_rad_message.msgname)
        self._fieldnames = MAVLink_optical_flow_rad_message.fieldnames
        self._instance_field = MAVLink_optical_flow_rad_message.instance_field
        self._instance_offset = MAVLink_optical_flow_rad_message.instance_offset
        self.time_usec = time_usec
        self.sensor_id = sensor_id
        self.integration_time_us = integration_time_us
        self.integrated_x = integrated_x
        self.integrated_y = integrated_y
        self.integrated_xgyro = integrated_xgyro
        self.integrated_ygyro = integrated_ygyro
        self.integrated_zgyro = integrated_zgyro
        self.temperature = temperature
        self.quality = quality
        self.time_delta_distance_us = time_delta_distance_us
        self.distance = distance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.integration_time_us, self.integrated_x, self.integrated_y, self.integrated_xgyro, self.integrated_ygyro, self.integrated_zgyro, self.time_delta_distance_us, self.distance, self.temperature, self.sensor_id, self.quality), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_optical_flow_rad_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hil_sensor_message(MAVLink_message):
    """
    The IMU readings in SI units in NED body frame
    """

    id = MAVLINK_MSG_ID_HIL_SENSOR
    msgname = "HIL_SENSOR"
    fieldnames = ["time_usec", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "abs_pressure", "diff_pressure", "pressure_alt", "temperature", "fields_updated", "id"]
    ordered_fieldnames = ["time_usec", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "abs_pressure", "diff_pressure", "pressure_alt", "temperature", "fields_updated", "id"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "uint32_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"fields_updated": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "xacc": "m/s/s", "yacc": "m/s/s", "zacc": "m/s/s", "xgyro": "rad/s", "ygyro": "rad/s", "zgyro": "rad/s", "xmag": "gauss", "ymag": "gauss", "zmag": "gauss", "abs_pressure": "hPa", "diff_pressure": "hPa", "temperature": "degC"}
    native_format = bytearray(b"<QfffffffffffffIB")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 108
    unpacker = struct.Struct("<QfffffffffffffIB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, xacc: float, yacc: float, zacc: float, xgyro: float, ygyro: float, zgyro: float, xmag: float, ymag: float, zmag: float, abs_pressure: float, diff_pressure: float, pressure_alt: float, temperature: float, fields_updated: int, id: int = 0):
        MAVLink_message.__init__(self, MAVLink_hil_sensor_message.id, MAVLink_hil_sensor_message.msgname)
        self._fieldnames = MAVLink_hil_sensor_message.fieldnames
        self._instance_field = MAVLink_hil_sensor_message.instance_field
        self._instance_offset = MAVLink_hil_sensor_message.instance_offset
        self.time_usec = time_usec
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc
        self.xgyro = xgyro
        self.ygyro = ygyro
        self.zgyro = zgyro
        self.xmag = xmag
        self.ymag = ymag
        self.zmag = zmag
        self.abs_pressure = abs_pressure
        self.diff_pressure = diff_pressure
        self.pressure_alt = pressure_alt
        self.temperature = temperature
        self.fields_updated = fields_updated
        self.id = id

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag, self.abs_pressure, self.diff_pressure, self.pressure_alt, self.temperature, self.fields_updated, self.id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hil_sensor_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_sim_state_message(MAVLink_message):
    """
    Status of simulation environment, if used
    """

    id = MAVLINK_MSG_ID_SIM_STATE
    msgname = "SIM_STATE"
    fieldnames = ["q1", "q2", "q3", "q4", "roll", "pitch", "yaw", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "lat", "lon", "alt", "std_dev_horz", "std_dev_vert", "vn", "ve", "vd", "lat_int", "lon_int"]
    ordered_fieldnames = ["q1", "q2", "q3", "q4", "roll", "pitch", "yaw", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "lat", "lon", "alt", "std_dev_horz", "std_dev_vert", "vn", "ve", "vd", "lat_int", "lon_int"]
    fieldtypes = ["float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "int32_t", "int32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"xacc": "m/s/s", "yacc": "m/s/s", "zacc": "m/s/s", "xgyro": "rad/s", "ygyro": "rad/s", "zgyro": "rad/s", "lat": "deg", "lon": "deg", "alt": "m", "vn": "m/s", "ve": "m/s", "vd": "m/s", "lat_int": "degE7", "lon_int": "degE7"}
    native_format = bytearray(b"<fffffffffffffffffffffii")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 32
    unpacker = struct.Struct("<fffffffffffffffffffffii")
    instance_field = None
    instance_offset = -1

    def __init__(self, q1: float, q2: float, q3: float, q4: float, roll: float, pitch: float, yaw: float, xacc: float, yacc: float, zacc: float, xgyro: float, ygyro: float, zgyro: float, lat: float, lon: float, alt: float, std_dev_horz: float, std_dev_vert: float, vn: float, ve: float, vd: float, lat_int: int = 0, lon_int: int = 0):
        MAVLink_message.__init__(self, MAVLink_sim_state_message.id, MAVLink_sim_state_message.msgname)
        self._fieldnames = MAVLink_sim_state_message.fieldnames
        self._instance_field = MAVLink_sim_state_message.instance_field
        self._instance_offset = MAVLink_sim_state_message.instance_offset
        self.q1 = q1
        self.q2 = q2
        self.q3 = q3
        self.q4 = q4
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc
        self.xgyro = xgyro
        self.ygyro = ygyro
        self.zgyro = zgyro
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.std_dev_horz = std_dev_horz
        self.std_dev_vert = std_dev_vert
        self.vn = vn
        self.ve = ve
        self.vd = vd
        self.lat_int = lat_int
        self.lon_int = lon_int

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.q1, self.q2, self.q3, self.q4, self.roll, self.pitch, self.yaw, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.lat, self.lon, self.alt, self.std_dev_horz, self.std_dev_vert, self.vn, self.ve, self.vd, self.lat_int, self.lon_int), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_sim_state_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_radio_status_message(MAVLink_message):
    """
    Status generated by radio and injected into MAVLink stream.
    """

    id = MAVLINK_MSG_ID_RADIO_STATUS
    msgname = "RADIO_STATUS"
    fieldnames = ["rssi", "remrssi", "txbuf", "noise", "remnoise", "rxerrors", "fixed"]
    ordered_fieldnames = ["rxerrors", "fixed", "rssi", "remrssi", "txbuf", "noise", "remnoise"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"txbuf": "%"}
    native_format = bytearray(b"<HHBBBBB")
    orders = [2, 3, 4, 5, 6, 0, 1]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 185
    unpacker = struct.Struct("<HHBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, rssi: int, remrssi: int, txbuf: int, noise: int, remnoise: int, rxerrors: int, fixed: int):
        MAVLink_message.__init__(self, MAVLink_radio_status_message.id, MAVLink_radio_status_message.msgname)
        self._fieldnames = MAVLink_radio_status_message.fieldnames
        self._instance_field = MAVLink_radio_status_message.instance_field
        self._instance_offset = MAVLink_radio_status_message.instance_offset
        self.rssi = rssi
        self.remrssi = remrssi
        self.txbuf = txbuf
        self.noise = noise
        self.remnoise = remnoise
        self.rxerrors = rxerrors
        self.fixed = fixed

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.rxerrors, self.fixed, self.rssi, self.remrssi, self.txbuf, self.noise, self.remnoise), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_radio_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_file_transfer_protocol_message(MAVLink_message):
    """
    File transfer protocol message:
    https://mavlink.io/en/services/ftp.html.
    """

    id = MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL
    msgname = "FILE_TRANSFER_PROTOCOL"
    fieldnames = ["target_network", "target_system", "target_component", "payload"]
    ordered_fieldnames = ["target_network", "target_system", "target_component", "payload"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBBB")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 251]
    array_lengths = [0, 0, 0, 251]
    crc_extra = 84
    unpacker = struct.Struct("<BBB251B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_network: int, target_system: int, target_component: int, payload: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_file_transfer_protocol_message.id, MAVLink_file_transfer_protocol_message.msgname)
        self._fieldnames = MAVLink_file_transfer_protocol_message.fieldnames
        self._instance_field = MAVLink_file_transfer_protocol_message.instance_field
        self._instance_offset = MAVLink_file_transfer_protocol_message.instance_offset
        self.target_network = target_network
        self.target_system = target_system
        self.target_component = target_component
        self.payload = payload

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_network, self.target_system, self.target_component, self.payload[0], self.payload[1], self.payload[2], self.payload[3], self.payload[4], self.payload[5], self.payload[6], self.payload[7], self.payload[8], self.payload[9], self.payload[10], self.payload[11], self.payload[12], self.payload[13], self.payload[14], self.payload[15], self.payload[16], self.payload[17], self.payload[18], self.payload[19], self.payload[20], self.payload[21], self.payload[22], self.payload[23], self.payload[24], self.payload[25], self.payload[26], self.payload[27], self.payload[28], self.payload[29], self.payload[30], self.payload[31], self.payload[32], self.payload[33], self.payload[34], self.payload[35], self.payload[36], self.payload[37], self.payload[38], self.payload[39], self.payload[40], self.payload[41], self.payload[42], self.payload[43], self.payload[44], self.payload[45], self.payload[46], self.payload[47], self.payload[48], self.payload[49], self.payload[50], self.payload[51], self.payload[52], self.payload[53], self.payload[54], self.payload[55], self.payload[56], self.payload[57], self.payload[58], self.payload[59], self.payload[60], self.payload[61], self.payload[62], self.payload[63], self.payload[64], self.payload[65], self.payload[66], self.payload[67], self.payload[68], self.payload[69], self.payload[70], self.payload[71], self.payload[72], self.payload[73], self.payload[74], self.payload[75], self.payload[76], self.payload[77], self.payload[78], self.payload[79], self.payload[80], self.payload[81], self.payload[82], self.payload[83], self.payload[84], self.payload[85], self.payload[86], self.payload[87], self.payload[88], self.payload[89], self.payload[90], self.payload[91], self.payload[92], self.payload[93], self.payload[94], self.payload[95], self.payload[96], self.payload[97], self.payload[98], self.payload[99], self.payload[100], self.payload[101], self.payload[102], self.payload[103], self.payload[104], self.payload[105], self.payload[106], self.payload[107], self.payload[108], self.payload[109], self.payload[110], self.payload[111], self.payload[112], self.payload[113], self.payload[114], self.payload[115], self.payload[116], self.payload[117], self.payload[118], self.payload[119], self.payload[120], self.payload[121], self.payload[122], self.payload[123], self.payload[124], self.payload[125], self.payload[126], self.payload[127], self.payload[128], self.payload[129], self.payload[130], self.payload[131], self.payload[132], self.payload[133], self.payload[134], self.payload[135], self.payload[136], self.payload[137], self.payload[138], self.payload[139], self.payload[140], self.payload[141], self.payload[142], self.payload[143], self.payload[144], self.payload[145], self.payload[146], self.payload[147], self.payload[148], self.payload[149], self.payload[150], self.payload[151], self.payload[152], self.payload[153], self.payload[154], self.payload[155], self.payload[156], self.payload[157], self.payload[158], self.payload[159], self.payload[160], self.payload[161], self.payload[162], self.payload[163], self.payload[164], self.payload[165], self.payload[166], self.payload[167], self.payload[168], self.payload[169], self.payload[170], self.payload[171], self.payload[172], self.payload[173], self.payload[174], self.payload[175], self.payload[176], self.payload[177], self.payload[178], self.payload[179], self.payload[180], self.payload[181], self.payload[182], self.payload[183], self.payload[184], self.payload[185], self.payload[186], self.payload[187], self.payload[188], self.payload[189], self.payload[190], self.payload[191], self.payload[192], self.payload[193], self.payload[194], self.payload[195], self.payload[196], self.payload[197], self.payload[198], self.payload[199], self.payload[200], self.payload[201], self.payload[202], self.payload[203], self.payload[204], self.payload[205], self.payload[206], self.payload[207], self.payload[208], self.payload[209], self.payload[210], self.payload[211], self.payload[212], self.payload[213], self.payload[214], self.payload[215], self.payload[216], self.payload[217], self.payload[218], self.payload[219], self.payload[220], self.payload[221], self.payload[222], self.payload[223], self.payload[224], self.payload[225], self.payload[226], self.payload[227], self.payload[228], self.payload[229], self.payload[230], self.payload[231], self.payload[232], self.payload[233], self.payload[234], self.payload[235], self.payload[236], self.payload[237], self.payload[238], self.payload[239], self.payload[240], self.payload[241], self.payload[242], self.payload[243], self.payload[244], self.payload[245], self.payload[246], self.payload[247], self.payload[248], self.payload[249], self.payload[250]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_file_transfer_protocol_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_timesync_message(MAVLink_message):
    """
    Time synchronization message.
    """

    id = MAVLINK_MSG_ID_TIMESYNC
    msgname = "TIMESYNC"
    fieldnames = ["tc1", "ts1"]
    ordered_fieldnames = ["tc1", "ts1"]
    fieldtypes = ["int64_t", "int64_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<qq")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 34
    unpacker = struct.Struct("<qq")
    instance_field = None
    instance_offset = -1

    def __init__(self, tc1: int, ts1: int):
        MAVLink_message.__init__(self, MAVLink_timesync_message.id, MAVLink_timesync_message.msgname)
        self._fieldnames = MAVLink_timesync_message.fieldnames
        self._instance_field = MAVLink_timesync_message.instance_field
        self._instance_offset = MAVLink_timesync_message.instance_offset
        self.tc1 = tc1
        self.ts1 = ts1

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.tc1, self.ts1), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_timesync_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_trigger_message(MAVLink_message):
    """
    Camera-IMU triggering and synchronisation message.
    """

    id = MAVLINK_MSG_ID_CAMERA_TRIGGER
    msgname = "CAMERA_TRIGGER"
    fieldnames = ["time_usec", "seq"]
    ordered_fieldnames = ["time_usec", "seq"]
    fieldtypes = ["uint64_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QI")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 174
    unpacker = struct.Struct("<QI")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, seq: int):
        MAVLink_message.__init__(self, MAVLink_camera_trigger_message.id, MAVLink_camera_trigger_message.msgname)
        self._fieldnames = MAVLink_camera_trigger_message.fieldnames
        self._instance_field = MAVLink_camera_trigger_message.instance_field
        self._instance_offset = MAVLink_camera_trigger_message.instance_offset
        self.time_usec = time_usec
        self.seq = seq

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.seq), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_trigger_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hil_gps_message(MAVLink_message):
    """
    The global position, as returned by the Global Positioning System
    (GPS). This is                  NOT the global position estimate
    of the system, but rather a RAW sensor value. See message
    GLOBAL_POSITION_INT for the global position estimate.
    """

    id = MAVLINK_MSG_ID_HIL_GPS
    msgname = "HIL_GPS"
    fieldnames = ["time_usec", "fix_type", "lat", "lon", "alt", "eph", "epv", "vel", "vn", "ve", "vd", "cog", "satellites_visible", "id", "yaw"]
    ordered_fieldnames = ["time_usec", "lat", "lon", "alt", "eph", "epv", "vel", "vn", "ve", "vd", "cog", "fix_type", "satellites_visible", "id", "yaw"]
    fieldtypes = ["uint64_t", "uint8_t", "int32_t", "int32_t", "int32_t", "uint16_t", "uint16_t", "uint16_t", "int16_t", "int16_t", "int16_t", "uint16_t", "uint8_t", "uint8_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "vel": "cm/s", "vn": "cm/s", "ve": "cm/s", "vd": "cm/s", "cog": "cdeg", "yaw": "cdeg"}
    native_format = bytearray(b"<QiiiHHHhhhHBBBH")
    orders = [0, 11, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 124
    unpacker = struct.Struct("<QiiiHHHhhhHBBBH")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, fix_type: int, lat: int, lon: int, alt: int, eph: int, epv: int, vel: int, vn: int, ve: int, vd: int, cog: int, satellites_visible: int, id: int = 0, yaw: int = 0):
        MAVLink_message.__init__(self, MAVLink_hil_gps_message.id, MAVLink_hil_gps_message.msgname)
        self._fieldnames = MAVLink_hil_gps_message.fieldnames
        self._instance_field = MAVLink_hil_gps_message.instance_field
        self._instance_offset = MAVLink_hil_gps_message.instance_offset
        self.time_usec = time_usec
        self.fix_type = fix_type
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.eph = eph
        self.epv = epv
        self.vel = vel
        self.vn = vn
        self.ve = ve
        self.vd = vd
        self.cog = cog
        self.satellites_visible = satellites_visible
        self.id = id
        self.yaw = yaw

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.lat, self.lon, self.alt, self.eph, self.epv, self.vel, self.vn, self.ve, self.vd, self.cog, self.fix_type, self.satellites_visible, self.id, self.yaw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hil_gps_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hil_optical_flow_message(MAVLink_message):
    """
    Simulated optical flow from a flow sensor (e.g. PX4FLOW or optical
    mouse sensor)
    """

    id = MAVLINK_MSG_ID_HIL_OPTICAL_FLOW
    msgname = "HIL_OPTICAL_FLOW"
    fieldnames = ["time_usec", "sensor_id", "integration_time_us", "integrated_x", "integrated_y", "integrated_xgyro", "integrated_ygyro", "integrated_zgyro", "temperature", "quality", "time_delta_distance_us", "distance"]
    ordered_fieldnames = ["time_usec", "integration_time_us", "integrated_x", "integrated_y", "integrated_xgyro", "integrated_ygyro", "integrated_zgyro", "time_delta_distance_us", "distance", "temperature", "sensor_id", "quality"]
    fieldtypes = ["uint64_t", "uint8_t", "uint32_t", "float", "float", "float", "float", "float", "int16_t", "uint8_t", "uint32_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "integration_time_us": "us", "integrated_x": "rad", "integrated_y": "rad", "integrated_xgyro": "rad", "integrated_ygyro": "rad", "integrated_zgyro": "rad", "temperature": "cdegC", "time_delta_distance_us": "us", "distance": "m"}
    native_format = bytearray(b"<QIfffffIfhBB")
    orders = [0, 10, 1, 2, 3, 4, 5, 6, 9, 11, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 237
    unpacker = struct.Struct("<QIfffffIfhBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, sensor_id: int, integration_time_us: int, integrated_x: float, integrated_y: float, integrated_xgyro: float, integrated_ygyro: float, integrated_zgyro: float, temperature: int, quality: int, time_delta_distance_us: int, distance: float):
        MAVLink_message.__init__(self, MAVLink_hil_optical_flow_message.id, MAVLink_hil_optical_flow_message.msgname)
        self._fieldnames = MAVLink_hil_optical_flow_message.fieldnames
        self._instance_field = MAVLink_hil_optical_flow_message.instance_field
        self._instance_offset = MAVLink_hil_optical_flow_message.instance_offset
        self.time_usec = time_usec
        self.sensor_id = sensor_id
        self.integration_time_us = integration_time_us
        self.integrated_x = integrated_x
        self.integrated_y = integrated_y
        self.integrated_xgyro = integrated_xgyro
        self.integrated_ygyro = integrated_ygyro
        self.integrated_zgyro = integrated_zgyro
        self.temperature = temperature
        self.quality = quality
        self.time_delta_distance_us = time_delta_distance_us
        self.distance = distance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.integration_time_us, self.integrated_x, self.integrated_y, self.integrated_xgyro, self.integrated_ygyro, self.integrated_zgyro, self.time_delta_distance_us, self.distance, self.temperature, self.sensor_id, self.quality), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hil_optical_flow_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hil_state_quaternion_message(MAVLink_message):
    """
    Sent from simulation to autopilot, avoids in contrast to HIL_STATE
    singularities. This packet is useful for high throughput
    applications such as hardware in the loop simulations.
    """

    id = MAVLINK_MSG_ID_HIL_STATE_QUATERNION
    msgname = "HIL_STATE_QUATERNION"
    fieldnames = ["time_usec", "attitude_quaternion", "rollspeed", "pitchspeed", "yawspeed", "lat", "lon", "alt", "vx", "vy", "vz", "ind_airspeed", "true_airspeed", "xacc", "yacc", "zacc"]
    ordered_fieldnames = ["time_usec", "attitude_quaternion", "rollspeed", "pitchspeed", "yawspeed", "lat", "lon", "alt", "vx", "vy", "vz", "ind_airspeed", "true_airspeed", "xacc", "yacc", "zacc"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "int32_t", "int32_t", "int32_t", "int16_t", "int16_t", "int16_t", "uint16_t", "uint16_t", "int16_t", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s", "lat": "degE7", "lon": "degE7", "alt": "mm", "vx": "cm/s", "vy": "cm/s", "vz": "cm/s", "ind_airspeed": "cm/s", "true_airspeed": "cm/s", "xacc": "mG", "yacc": "mG", "zacc": "mG"}
    native_format = bytearray(b"<QffffiiihhhHHhhh")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
    lengths = [1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 4
    unpacker = struct.Struct("<Q4ffffiiihhhHHhhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, attitude_quaternion: Sequence[float], rollspeed: float, pitchspeed: float, yawspeed: float, lat: int, lon: int, alt: int, vx: int, vy: int, vz: int, ind_airspeed: int, true_airspeed: int, xacc: int, yacc: int, zacc: int):
        MAVLink_message.__init__(self, MAVLink_hil_state_quaternion_message.id, MAVLink_hil_state_quaternion_message.msgname)
        self._fieldnames = MAVLink_hil_state_quaternion_message.fieldnames
        self._instance_field = MAVLink_hil_state_quaternion_message.instance_field
        self._instance_offset = MAVLink_hil_state_quaternion_message.instance_offset
        self.time_usec = time_usec
        self.attitude_quaternion = attitude_quaternion
        self.rollspeed = rollspeed
        self.pitchspeed = pitchspeed
        self.yawspeed = yawspeed
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.ind_airspeed = ind_airspeed
        self.true_airspeed = true_airspeed
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.attitude_quaternion[0], self.attitude_quaternion[1], self.attitude_quaternion[2], self.attitude_quaternion[3], self.rollspeed, self.pitchspeed, self.yawspeed, self.lat, self.lon, self.alt, self.vx, self.vy, self.vz, self.ind_airspeed, self.true_airspeed, self.xacc, self.yacc, self.zacc), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hil_state_quaternion_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_scaled_imu2_message(MAVLink_message):
    """
    The RAW IMU readings for secondary 9DOF sensor setup. This message
    should contain the scaled values to the described units
    """

    id = MAVLINK_MSG_ID_SCALED_IMU2
    msgname = "SCALED_IMU2"
    fieldnames = ["time_boot_ms", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "temperature"]
    ordered_fieldnames = ["time_boot_ms", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "temperature"]
    fieldtypes = ["uint32_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "xacc": "mG", "yacc": "mG", "zacc": "mG", "xgyro": "mrad/s", "ygyro": "mrad/s", "zgyro": "mrad/s", "xmag": "mgauss", "ymag": "mgauss", "zmag": "mgauss", "temperature": "cdegC"}
    native_format = bytearray(b"<Ihhhhhhhhhh")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 76
    unpacker = struct.Struct("<Ihhhhhhhhhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, xacc: int, yacc: int, zacc: int, xgyro: int, ygyro: int, zgyro: int, xmag: int, ymag: int, zmag: int, temperature: int = 0):
        MAVLink_message.__init__(self, MAVLink_scaled_imu2_message.id, MAVLink_scaled_imu2_message.msgname)
        self._fieldnames = MAVLink_scaled_imu2_message.fieldnames
        self._instance_field = MAVLink_scaled_imu2_message.instance_field
        self._instance_offset = MAVLink_scaled_imu2_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc
        self.xgyro = xgyro
        self.ygyro = ygyro
        self.zgyro = zgyro
        self.xmag = xmag
        self.ymag = ymag
        self.zmag = zmag
        self.temperature = temperature

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag, self.temperature), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_scaled_imu2_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_log_request_list_message(MAVLink_message):
    """
    Request a list of available logs. On some systems calling this may
    stop on-board logging until LOG_REQUEST_END is called. If there
    are no log files available this request shall be answered with one
    LOG_ENTRY message with id = 0 and num_logs = 0.
    """

    id = MAVLINK_MSG_ID_LOG_REQUEST_LIST
    msgname = "LOG_REQUEST_LIST"
    fieldnames = ["target_system", "target_component", "start", "end"]
    ordered_fieldnames = ["start", "end", "target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HHBB")
    orders = [2, 3, 0, 1]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 128
    unpacker = struct.Struct("<HHBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, start: int, end: int):
        MAVLink_message.__init__(self, MAVLink_log_request_list_message.id, MAVLink_log_request_list_message.msgname)
        self._fieldnames = MAVLink_log_request_list_message.fieldnames
        self._instance_field = MAVLink_log_request_list_message.instance_field
        self._instance_offset = MAVLink_log_request_list_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.start = start
        self.end = end

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.start, self.end, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_log_request_list_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_log_entry_message(MAVLink_message):
    """
    Reply to LOG_REQUEST_LIST
    """

    id = MAVLINK_MSG_ID_LOG_ENTRY
    msgname = "LOG_ENTRY"
    fieldnames = ["id", "num_logs", "last_log_num", "time_utc", "size"]
    ordered_fieldnames = ["time_utc", "size", "id", "num_logs", "last_log_num"]
    fieldtypes = ["uint16_t", "uint16_t", "uint16_t", "uint32_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_utc": "s", "size": "bytes"}
    native_format = bytearray(b"<IIHHH")
    orders = [2, 3, 4, 0, 1]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 56
    unpacker = struct.Struct("<IIHHH")
    instance_field = None
    instance_offset = -1

    def __init__(self, id: int, num_logs: int, last_log_num: int, time_utc: int, size: int):
        MAVLink_message.__init__(self, MAVLink_log_entry_message.id, MAVLink_log_entry_message.msgname)
        self._fieldnames = MAVLink_log_entry_message.fieldnames
        self._instance_field = MAVLink_log_entry_message.instance_field
        self._instance_offset = MAVLink_log_entry_message.instance_offset
        self.id = id
        self.num_logs = num_logs
        self.last_log_num = last_log_num
        self.time_utc = time_utc
        self.size = size

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_utc, self.size, self.id, self.num_logs, self.last_log_num), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_log_entry_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_log_request_data_message(MAVLink_message):
    """
    Request a chunk of a log
    """

    id = MAVLINK_MSG_ID_LOG_REQUEST_DATA
    msgname = "LOG_REQUEST_DATA"
    fieldnames = ["target_system", "target_component", "id", "ofs", "count"]
    ordered_fieldnames = ["ofs", "count", "id", "target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint32_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"count": "bytes"}
    native_format = bytearray(b"<IIHBB")
    orders = [3, 4, 2, 0, 1]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 116
    unpacker = struct.Struct("<IIHBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, id: int, ofs: int, count: int):
        MAVLink_message.__init__(self, MAVLink_log_request_data_message.id, MAVLink_log_request_data_message.msgname)
        self._fieldnames = MAVLink_log_request_data_message.fieldnames
        self._instance_field = MAVLink_log_request_data_message.instance_field
        self._instance_offset = MAVLink_log_request_data_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.id = id
        self.ofs = ofs
        self.count = count

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.ofs, self.count, self.id, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_log_request_data_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_log_data_message(MAVLink_message):
    """
    Reply to LOG_REQUEST_DATA
    """

    id = MAVLINK_MSG_ID_LOG_DATA
    msgname = "LOG_DATA"
    fieldnames = ["id", "ofs", "count", "data"]
    ordered_fieldnames = ["ofs", "id", "count", "data"]
    fieldtypes = ["uint16_t", "uint32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"count": "bytes"}
    native_format = bytearray(b"<IHBB")
    orders = [1, 0, 2, 3]
    lengths = [1, 1, 1, 90]
    array_lengths = [0, 0, 0, 90]
    crc_extra = 134
    unpacker = struct.Struct("<IHB90B")
    instance_field = None
    instance_offset = -1

    def __init__(self, id: int, ofs: int, count: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_log_data_message.id, MAVLink_log_data_message.msgname)
        self._fieldnames = MAVLink_log_data_message.fieldnames
        self._instance_field = MAVLink_log_data_message.instance_field
        self._instance_offset = MAVLink_log_data_message.instance_offset
        self.id = id
        self.ofs = ofs
        self.count = count
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.ofs, self.id, self.count, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_log_data_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_log_erase_message(MAVLink_message):
    """
    Erase all logs
    """

    id = MAVLINK_MSG_ID_LOG_ERASE
    msgname = "LOG_ERASE"
    fieldnames = ["target_system", "target_component"]
    ordered_fieldnames = ["target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BB")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 237
    unpacker = struct.Struct("<BB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int):
        MAVLink_message.__init__(self, MAVLink_log_erase_message.id, MAVLink_log_erase_message.msgname)
        self._fieldnames = MAVLink_log_erase_message.fieldnames
        self._instance_field = MAVLink_log_erase_message.instance_field
        self._instance_offset = MAVLink_log_erase_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_log_erase_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_log_request_end_message(MAVLink_message):
    """
    Stop log transfer and resume normal logging
    """

    id = MAVLINK_MSG_ID_LOG_REQUEST_END
    msgname = "LOG_REQUEST_END"
    fieldnames = ["target_system", "target_component"]
    ordered_fieldnames = ["target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BB")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 203
    unpacker = struct.Struct("<BB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int):
        MAVLink_message.__init__(self, MAVLink_log_request_end_message.id, MAVLink_log_request_end_message.msgname)
        self._fieldnames = MAVLink_log_request_end_message.fieldnames
        self._instance_field = MAVLink_log_request_end_message.instance_field
        self._instance_offset = MAVLink_log_request_end_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_log_request_end_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps_inject_data_message(MAVLink_message):
    """
    Data for injecting into the onboard GPS (used for DGPS)
    """

    id = MAVLINK_MSG_ID_GPS_INJECT_DATA
    msgname = "GPS_INJECT_DATA"
    fieldnames = ["target_system", "target_component", "len", "data"]
    ordered_fieldnames = ["target_system", "target_component", "len", "data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"len": "bytes"}
    native_format = bytearray(b"<BBBB")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 110]
    array_lengths = [0, 0, 0, 110]
    crc_extra = 250
    unpacker = struct.Struct("<BBB110B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, len: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_gps_inject_data_message.id, MAVLink_gps_inject_data_message.msgname)
        self._fieldnames = MAVLink_gps_inject_data_message.fieldnames
        self._instance_field = MAVLink_gps_inject_data_message.instance_field
        self._instance_offset = MAVLink_gps_inject_data_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.len = len
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps_inject_data_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps2_raw_message(MAVLink_message):
    """
    Second GPS data.
    """

    id = MAVLINK_MSG_ID_GPS2_RAW
    msgname = "GPS2_RAW"
    fieldnames = ["time_usec", "fix_type", "lat", "lon", "alt", "eph", "epv", "vel", "cog", "satellites_visible", "dgps_numch", "dgps_age", "yaw", "alt_ellipsoid", "h_acc", "v_acc", "vel_acc", "hdg_acc"]
    ordered_fieldnames = ["time_usec", "lat", "lon", "alt", "dgps_age", "eph", "epv", "vel", "cog", "fix_type", "satellites_visible", "dgps_numch", "yaw", "alt_ellipsoid", "h_acc", "v_acc", "vel_acc", "hdg_acc"]
    fieldtypes = ["uint64_t", "uint8_t", "int32_t", "int32_t", "int32_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t", "uint8_t", "uint32_t", "uint16_t", "int32_t", "uint32_t", "uint32_t", "uint32_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"fix_type": "GPS_FIX_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "vel": "cm/s", "cog": "cdeg", "dgps_age": "ms", "yaw": "cdeg", "alt_ellipsoid": "mm", "h_acc": "mm", "v_acc": "mm", "vel_acc": "mm/s", "hdg_acc": "degE5"}
    native_format = bytearray(b"<QiiiIHHHHBBBHiIIII")
    orders = [0, 9, 1, 2, 3, 5, 6, 7, 8, 10, 11, 4, 12, 13, 14, 15, 16, 17]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 87
    unpacker = struct.Struct("<QiiiIHHHHBBBHiIIII")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, fix_type: int, lat: int, lon: int, alt: int, eph: int, epv: int, vel: int, cog: int, satellites_visible: int, dgps_numch: int, dgps_age: int, yaw: int = 0, alt_ellipsoid: int = 0, h_acc: int = 0, v_acc: int = 0, vel_acc: int = 0, hdg_acc: int = 0):
        MAVLink_message.__init__(self, MAVLink_gps2_raw_message.id, MAVLink_gps2_raw_message.msgname)
        self._fieldnames = MAVLink_gps2_raw_message.fieldnames
        self._instance_field = MAVLink_gps2_raw_message.instance_field
        self._instance_offset = MAVLink_gps2_raw_message.instance_offset
        self.time_usec = time_usec
        self.fix_type = fix_type
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.eph = eph
        self.epv = epv
        self.vel = vel
        self.cog = cog
        self.satellites_visible = satellites_visible
        self.dgps_numch = dgps_numch
        self.dgps_age = dgps_age
        self.yaw = yaw
        self.alt_ellipsoid = alt_ellipsoid
        self.h_acc = h_acc
        self.v_acc = v_acc
        self.vel_acc = vel_acc
        self.hdg_acc = hdg_acc

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.lat, self.lon, self.alt, self.dgps_age, self.eph, self.epv, self.vel, self.cog, self.fix_type, self.satellites_visible, self.dgps_numch, self.yaw, self.alt_ellipsoid, self.h_acc, self.v_acc, self.vel_acc, self.hdg_acc), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps2_raw_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_power_status_message(MAVLink_message):
    """
    Power supply status
    """

    id = MAVLINK_MSG_ID_POWER_STATUS
    msgname = "POWER_STATUS"
    fieldnames = ["Vcc", "Vservo", "flags"]
    ordered_fieldnames = ["Vcc", "Vservo", "flags"]
    fieldtypes = ["uint16_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "MAV_POWER_STATUS"}
    fieldunits_by_name: Dict[str, str] = {"Vcc": "mV", "Vservo": "mV"}
    native_format = bytearray(b"<HHH")
    orders = [0, 1, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 203
    unpacker = struct.Struct("<HHH")
    instance_field = None
    instance_offset = -1

    def __init__(self, Vcc: int, Vservo: int, flags: int):
        MAVLink_message.__init__(self, MAVLink_power_status_message.id, MAVLink_power_status_message.msgname)
        self._fieldnames = MAVLink_power_status_message.fieldnames
        self._instance_field = MAVLink_power_status_message.instance_field
        self._instance_offset = MAVLink_power_status_message.instance_offset
        self.Vcc = Vcc
        self.Vservo = Vservo
        self.flags = flags

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.Vcc, self.Vservo, self.flags), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_power_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_serial_control_message(MAVLink_message):
    """
    Control a serial port. This can be used for raw access to an
    onboard serial peripheral such as a GPS or telemetry radio. It is
    designed to make it possible to update the devices firmware via
    MAVLink messages or change the devices settings. A message with
    zero bytes can be used to change just the baudrate.
    """

    id = MAVLINK_MSG_ID_SERIAL_CONTROL
    msgname = "SERIAL_CONTROL"
    fieldnames = ["device", "flags", "timeout", "baudrate", "count", "data"]
    ordered_fieldnames = ["baudrate", "timeout", "device", "flags", "count", "data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"device": "SERIAL_CONTROL_DEV", "flags": "SERIAL_CONTROL_FLAG"}
    fieldunits_by_name: Dict[str, str] = {"timeout": "ms", "baudrate": "bits/s", "count": "bytes"}
    native_format = bytearray(b"<IHBBBB")
    orders = [2, 3, 1, 0, 4, 5]
    lengths = [1, 1, 1, 1, 1, 70]
    array_lengths = [0, 0, 0, 0, 0, 70]
    crc_extra = 220
    unpacker = struct.Struct("<IHBBB70B")
    instance_field = None
    instance_offset = -1

    def __init__(self, device: int, flags: int, timeout: int, baudrate: int, count: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_serial_control_message.id, MAVLink_serial_control_message.msgname)
        self._fieldnames = MAVLink_serial_control_message.fieldnames
        self._instance_field = MAVLink_serial_control_message.instance_field
        self._instance_offset = MAVLink_serial_control_message.instance_offset
        self.device = device
        self.flags = flags
        self.timeout = timeout
        self.baudrate = baudrate
        self.count = count
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.baudrate, self.timeout, self.device, self.flags, self.count, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_serial_control_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps_rtk_message(MAVLink_message):
    """
    RTK GPS data. Gives information on the relative baseline
    calculation the GPS is reporting
    """

    id = MAVLINK_MSG_ID_GPS_RTK
    msgname = "GPS_RTK"
    fieldnames = ["time_last_baseline_ms", "rtk_receiver_id", "wn", "tow", "rtk_health", "rtk_rate", "nsats", "baseline_coords_type", "baseline_a_mm", "baseline_b_mm", "baseline_c_mm", "accuracy", "iar_num_hypotheses"]
    ordered_fieldnames = ["time_last_baseline_ms", "tow", "baseline_a_mm", "baseline_b_mm", "baseline_c_mm", "accuracy", "iar_num_hypotheses", "wn", "rtk_receiver_id", "rtk_health", "rtk_rate", "nsats", "baseline_coords_type"]
    fieldtypes = ["uint32_t", "uint8_t", "uint16_t", "uint32_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "int32_t", "int32_t", "int32_t", "uint32_t", "int32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"baseline_coords_type": "RTK_BASELINE_COORDINATE_SYSTEM"}
    fieldunits_by_name: Dict[str, str] = {"time_last_baseline_ms": "ms", "tow": "ms", "rtk_rate": "Hz", "baseline_a_mm": "mm", "baseline_b_mm": "mm", "baseline_c_mm": "mm"}
    native_format = bytearray(b"<IIiiiIiHBBBBB")
    orders = [0, 8, 7, 1, 9, 10, 11, 12, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 25
    unpacker = struct.Struct("<IIiiiIiHBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_last_baseline_ms: int, rtk_receiver_id: int, wn: int, tow: int, rtk_health: int, rtk_rate: int, nsats: int, baseline_coords_type: int, baseline_a_mm: int, baseline_b_mm: int, baseline_c_mm: int, accuracy: int, iar_num_hypotheses: int):
        MAVLink_message.__init__(self, MAVLink_gps_rtk_message.id, MAVLink_gps_rtk_message.msgname)
        self._fieldnames = MAVLink_gps_rtk_message.fieldnames
        self._instance_field = MAVLink_gps_rtk_message.instance_field
        self._instance_offset = MAVLink_gps_rtk_message.instance_offset
        self.time_last_baseline_ms = time_last_baseline_ms
        self.rtk_receiver_id = rtk_receiver_id
        self.wn = wn
        self.tow = tow
        self.rtk_health = rtk_health
        self.rtk_rate = rtk_rate
        self.nsats = nsats
        self.baseline_coords_type = baseline_coords_type
        self.baseline_a_mm = baseline_a_mm
        self.baseline_b_mm = baseline_b_mm
        self.baseline_c_mm = baseline_c_mm
        self.accuracy = accuracy
        self.iar_num_hypotheses = iar_num_hypotheses

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_last_baseline_ms, self.tow, self.baseline_a_mm, self.baseline_b_mm, self.baseline_c_mm, self.accuracy, self.iar_num_hypotheses, self.wn, self.rtk_receiver_id, self.rtk_health, self.rtk_rate, self.nsats, self.baseline_coords_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps_rtk_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps2_rtk_message(MAVLink_message):
    """
    RTK GPS data. Gives information on the relative baseline
    calculation the GPS is reporting
    """

    id = MAVLINK_MSG_ID_GPS2_RTK
    msgname = "GPS2_RTK"
    fieldnames = ["time_last_baseline_ms", "rtk_receiver_id", "wn", "tow", "rtk_health", "rtk_rate", "nsats", "baseline_coords_type", "baseline_a_mm", "baseline_b_mm", "baseline_c_mm", "accuracy", "iar_num_hypotheses"]
    ordered_fieldnames = ["time_last_baseline_ms", "tow", "baseline_a_mm", "baseline_b_mm", "baseline_c_mm", "accuracy", "iar_num_hypotheses", "wn", "rtk_receiver_id", "rtk_health", "rtk_rate", "nsats", "baseline_coords_type"]
    fieldtypes = ["uint32_t", "uint8_t", "uint16_t", "uint32_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "int32_t", "int32_t", "int32_t", "uint32_t", "int32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"baseline_coords_type": "RTK_BASELINE_COORDINATE_SYSTEM"}
    fieldunits_by_name: Dict[str, str] = {"time_last_baseline_ms": "ms", "tow": "ms", "rtk_rate": "Hz", "baseline_a_mm": "mm", "baseline_b_mm": "mm", "baseline_c_mm": "mm"}
    native_format = bytearray(b"<IIiiiIiHBBBBB")
    orders = [0, 8, 7, 1, 9, 10, 11, 12, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 226
    unpacker = struct.Struct("<IIiiiIiHBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_last_baseline_ms: int, rtk_receiver_id: int, wn: int, tow: int, rtk_health: int, rtk_rate: int, nsats: int, baseline_coords_type: int, baseline_a_mm: int, baseline_b_mm: int, baseline_c_mm: int, accuracy: int, iar_num_hypotheses: int):
        MAVLink_message.__init__(self, MAVLink_gps2_rtk_message.id, MAVLink_gps2_rtk_message.msgname)
        self._fieldnames = MAVLink_gps2_rtk_message.fieldnames
        self._instance_field = MAVLink_gps2_rtk_message.instance_field
        self._instance_offset = MAVLink_gps2_rtk_message.instance_offset
        self.time_last_baseline_ms = time_last_baseline_ms
        self.rtk_receiver_id = rtk_receiver_id
        self.wn = wn
        self.tow = tow
        self.rtk_health = rtk_health
        self.rtk_rate = rtk_rate
        self.nsats = nsats
        self.baseline_coords_type = baseline_coords_type
        self.baseline_a_mm = baseline_a_mm
        self.baseline_b_mm = baseline_b_mm
        self.baseline_c_mm = baseline_c_mm
        self.accuracy = accuracy
        self.iar_num_hypotheses = iar_num_hypotheses

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_last_baseline_ms, self.tow, self.baseline_a_mm, self.baseline_b_mm, self.baseline_c_mm, self.accuracy, self.iar_num_hypotheses, self.wn, self.rtk_receiver_id, self.rtk_health, self.rtk_rate, self.nsats, self.baseline_coords_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps2_rtk_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_scaled_imu3_message(MAVLink_message):
    """
    The RAW IMU readings for 3rd 9DOF sensor setup. This message
    should contain the scaled values to the described units
    """

    id = MAVLINK_MSG_ID_SCALED_IMU3
    msgname = "SCALED_IMU3"
    fieldnames = ["time_boot_ms", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "temperature"]
    ordered_fieldnames = ["time_boot_ms", "xacc", "yacc", "zacc", "xgyro", "ygyro", "zgyro", "xmag", "ymag", "zmag", "temperature"]
    fieldtypes = ["uint32_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "xacc": "mG", "yacc": "mG", "zacc": "mG", "xgyro": "mrad/s", "ygyro": "mrad/s", "zgyro": "mrad/s", "xmag": "mgauss", "ymag": "mgauss", "zmag": "mgauss", "temperature": "cdegC"}
    native_format = bytearray(b"<Ihhhhhhhhhh")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 46
    unpacker = struct.Struct("<Ihhhhhhhhhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, xacc: int, yacc: int, zacc: int, xgyro: int, ygyro: int, zgyro: int, xmag: int, ymag: int, zmag: int, temperature: int = 0):
        MAVLink_message.__init__(self, MAVLink_scaled_imu3_message.id, MAVLink_scaled_imu3_message.msgname)
        self._fieldnames = MAVLink_scaled_imu3_message.fieldnames
        self._instance_field = MAVLink_scaled_imu3_message.instance_field
        self._instance_offset = MAVLink_scaled_imu3_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.xacc = xacc
        self.yacc = yacc
        self.zacc = zacc
        self.xgyro = xgyro
        self.ygyro = ygyro
        self.zgyro = zgyro
        self.xmag = xmag
        self.ymag = ymag
        self.zmag = zmag
        self.temperature = temperature

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.xacc, self.yacc, self.zacc, self.xgyro, self.ygyro, self.zgyro, self.xmag, self.ymag, self.zmag, self.temperature), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_scaled_imu3_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_data_transmission_handshake_message(MAVLink_message):
    """
    Handshake message to initiate, control and stop image streaming
    when using the Image Transmission Protocol:
    https://mavlink.io/en/services/image_transmission.html.
    """

    id = MAVLINK_MSG_ID_DATA_TRANSMISSION_HANDSHAKE
    msgname = "DATA_TRANSMISSION_HANDSHAKE"
    fieldnames = ["type", "size", "width", "height", "packets", "payload", "jpg_quality"]
    ordered_fieldnames = ["size", "width", "height", "packets", "type", "payload", "jpg_quality"]
    fieldtypes = ["uint8_t", "uint32_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"type": "MAVLINK_DATA_STREAM_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"size": "bytes", "payload": "bytes", "jpg_quality": "%"}
    native_format = bytearray(b"<IHHHBBB")
    orders = [4, 0, 1, 2, 3, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 29
    unpacker = struct.Struct("<IHHHBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, type: int, size: int, width: int, height: int, packets: int, payload: int, jpg_quality: int):
        MAVLink_message.__init__(self, MAVLink_data_transmission_handshake_message.id, MAVLink_data_transmission_handshake_message.msgname)
        self._fieldnames = MAVLink_data_transmission_handshake_message.fieldnames
        self._instance_field = MAVLink_data_transmission_handshake_message.instance_field
        self._instance_offset = MAVLink_data_transmission_handshake_message.instance_offset
        self.type = type
        self.size = size
        self.width = width
        self.height = height
        self.packets = packets
        self.payload = payload
        self.jpg_quality = jpg_quality

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.size, self.width, self.height, self.packets, self.type, self.payload, self.jpg_quality), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_data_transmission_handshake_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_encapsulated_data_message(MAVLink_message):
    """
    Data packet for images sent using the Image Transmission Protocol:
    https://mavlink.io/en/services/image_transmission.html.
    """

    id = MAVLINK_MSG_ID_ENCAPSULATED_DATA
    msgname = "ENCAPSULATED_DATA"
    fieldnames = ["seqnr", "data"]
    ordered_fieldnames = ["seqnr", "data"]
    fieldtypes = ["uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HB")
    orders = [0, 1]
    lengths = [1, 253]
    array_lengths = [0, 253]
    crc_extra = 223
    unpacker = struct.Struct("<H253B")
    instance_field = None
    instance_offset = -1

    def __init__(self, seqnr: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_encapsulated_data_message.id, MAVLink_encapsulated_data_message.msgname)
        self._fieldnames = MAVLink_encapsulated_data_message.fieldnames
        self._instance_field = MAVLink_encapsulated_data_message.instance_field
        self._instance_offset = MAVLink_encapsulated_data_message.instance_offset
        self.seqnr = seqnr
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.seqnr, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109], self.data[110], self.data[111], self.data[112], self.data[113], self.data[114], self.data[115], self.data[116], self.data[117], self.data[118], self.data[119], self.data[120], self.data[121], self.data[122], self.data[123], self.data[124], self.data[125], self.data[126], self.data[127], self.data[128], self.data[129], self.data[130], self.data[131], self.data[132], self.data[133], self.data[134], self.data[135], self.data[136], self.data[137], self.data[138], self.data[139], self.data[140], self.data[141], self.data[142], self.data[143], self.data[144], self.data[145], self.data[146], self.data[147], self.data[148], self.data[149], self.data[150], self.data[151], self.data[152], self.data[153], self.data[154], self.data[155], self.data[156], self.data[157], self.data[158], self.data[159], self.data[160], self.data[161], self.data[162], self.data[163], self.data[164], self.data[165], self.data[166], self.data[167], self.data[168], self.data[169], self.data[170], self.data[171], self.data[172], self.data[173], self.data[174], self.data[175], self.data[176], self.data[177], self.data[178], self.data[179], self.data[180], self.data[181], self.data[182], self.data[183], self.data[184], self.data[185], self.data[186], self.data[187], self.data[188], self.data[189], self.data[190], self.data[191], self.data[192], self.data[193], self.data[194], self.data[195], self.data[196], self.data[197], self.data[198], self.data[199], self.data[200], self.data[201], self.data[202], self.data[203], self.data[204], self.data[205], self.data[206], self.data[207], self.data[208], self.data[209], self.data[210], self.data[211], self.data[212], self.data[213], self.data[214], self.data[215], self.data[216], self.data[217], self.data[218], self.data[219], self.data[220], self.data[221], self.data[222], self.data[223], self.data[224], self.data[225], self.data[226], self.data[227], self.data[228], self.data[229], self.data[230], self.data[231], self.data[232], self.data[233], self.data[234], self.data[235], self.data[236], self.data[237], self.data[238], self.data[239], self.data[240], self.data[241], self.data[242], self.data[243], self.data[244], self.data[245], self.data[246], self.data[247], self.data[248], self.data[249], self.data[250], self.data[251], self.data[252]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_encapsulated_data_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_distance_sensor_message(MAVLink_message):
    """
    Distance sensor information for an onboard rangefinder.
    """

    id = MAVLINK_MSG_ID_DISTANCE_SENSOR
    msgname = "DISTANCE_SENSOR"
    fieldnames = ["time_boot_ms", "min_distance", "max_distance", "current_distance", "type", "id", "orientation", "covariance", "horizontal_fov", "vertical_fov", "quaternion", "signal_quality"]
    ordered_fieldnames = ["time_boot_ms", "min_distance", "max_distance", "current_distance", "type", "id", "orientation", "covariance", "horizontal_fov", "vertical_fov", "quaternion", "signal_quality"]
    fieldtypes = ["uint32_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "float", "float", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"type": "MAV_DISTANCE_SENSOR", "orientation": "MAV_SENSOR_ORIENTATION"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "min_distance": "cm", "max_distance": "cm", "current_distance": "cm", "covariance": "cm^2", "horizontal_fov": "rad", "vertical_fov": "rad", "signal_quality": "%"}
    native_format = bytearray(b"<IHHHBBBBfffB")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0]
    crc_extra = 85
    unpacker = struct.Struct("<IHHHBBBBff4fB")
    instance_field = "id"
    instance_offset = 11

    def __init__(self, time_boot_ms: int, min_distance: int, max_distance: int, current_distance: int, type: int, id: int, orientation: int, covariance: int, horizontal_fov: float = 0, vertical_fov: float = 0, quaternion: Sequence[float] = (0, 0, 0, 0), signal_quality: int = 0):
        MAVLink_message.__init__(self, MAVLink_distance_sensor_message.id, MAVLink_distance_sensor_message.msgname)
        self._fieldnames = MAVLink_distance_sensor_message.fieldnames
        self._instance_field = MAVLink_distance_sensor_message.instance_field
        self._instance_offset = MAVLink_distance_sensor_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.min_distance = min_distance
        self.max_distance = max_distance
        self.current_distance = current_distance
        self.type = type
        self.id = id
        self.orientation = orientation
        self.covariance = covariance
        self.horizontal_fov = horizontal_fov
        self.vertical_fov = vertical_fov
        self.quaternion = quaternion
        self.signal_quality = signal_quality

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.min_distance, self.max_distance, self.current_distance, self.type, self.id, self.orientation, self.covariance, self.horizontal_fov, self.vertical_fov, self.quaternion[0], self.quaternion[1], self.quaternion[2], self.quaternion[3], self.signal_quality), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_distance_sensor_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_terrain_request_message(MAVLink_message):
    """
    Request for terrain data and terrain status. See terrain protocol
    docs: https://mavlink.io/en/services/terrain.html
    """

    id = MAVLINK_MSG_ID_TERRAIN_REQUEST
    msgname = "TERRAIN_REQUEST"
    fieldnames = ["lat", "lon", "grid_spacing", "mask"]
    ordered_fieldnames = ["mask", "lat", "lon", "grid_spacing"]
    fieldtypes = ["int32_t", "int32_t", "uint16_t", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {"mask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"lat": "degE7", "lon": "degE7", "grid_spacing": "m"}
    native_format = bytearray(b"<QiiH")
    orders = [1, 2, 3, 0]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 6
    unpacker = struct.Struct("<QiiH")
    instance_field = None
    instance_offset = -1

    def __init__(self, lat: int, lon: int, grid_spacing: int, mask: int):
        MAVLink_message.__init__(self, MAVLink_terrain_request_message.id, MAVLink_terrain_request_message.msgname)
        self._fieldnames = MAVLink_terrain_request_message.fieldnames
        self._instance_field = MAVLink_terrain_request_message.instance_field
        self._instance_offset = MAVLink_terrain_request_message.instance_offset
        self.lat = lat
        self.lon = lon
        self.grid_spacing = grid_spacing
        self.mask = mask

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.mask, self.lat, self.lon, self.grid_spacing), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_terrain_request_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_terrain_data_message(MAVLink_message):
    """
    Terrain data sent from GCS. The lat/lon and grid_spacing must be
    the same as a lat/lon from a TERRAIN_REQUEST. See terrain protocol
    docs: https://mavlink.io/en/services/terrain.html
    """

    id = MAVLINK_MSG_ID_TERRAIN_DATA
    msgname = "TERRAIN_DATA"
    fieldnames = ["lat", "lon", "grid_spacing", "gridbit", "data"]
    ordered_fieldnames = ["lat", "lon", "grid_spacing", "data", "gridbit"]
    fieldtypes = ["int32_t", "int32_t", "uint16_t", "uint8_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"lat": "degE7", "lon": "degE7", "grid_spacing": "m", "data": "m"}
    native_format = bytearray(b"<iiHhB")
    orders = [0, 1, 2, 4, 3]
    lengths = [1, 1, 1, 16, 1]
    array_lengths = [0, 0, 0, 16, 0]
    crc_extra = 229
    unpacker = struct.Struct("<iiH16hB")
    instance_field = None
    instance_offset = -1

    def __init__(self, lat: int, lon: int, grid_spacing: int, gridbit: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_terrain_data_message.id, MAVLink_terrain_data_message.msgname)
        self._fieldnames = MAVLink_terrain_data_message.fieldnames
        self._instance_field = MAVLink_terrain_data_message.instance_field
        self._instance_offset = MAVLink_terrain_data_message.instance_offset
        self.lat = lat
        self.lon = lon
        self.grid_spacing = grid_spacing
        self.gridbit = gridbit
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.lat, self.lon, self.grid_spacing, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.gridbit), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_terrain_data_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_terrain_check_message(MAVLink_message):
    """
    Request that the vehicle report terrain height at the given
    location (expected response is a TERRAIN_REPORT). Used by GCS to
    check if vehicle has all terrain data needed for a mission.
    """

    id = MAVLINK_MSG_ID_TERRAIN_CHECK
    msgname = "TERRAIN_CHECK"
    fieldnames = ["lat", "lon"]
    ordered_fieldnames = ["lat", "lon"]
    fieldtypes = ["int32_t", "int32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"lat": "degE7", "lon": "degE7"}
    native_format = bytearray(b"<ii")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 203
    unpacker = struct.Struct("<ii")
    instance_field = None
    instance_offset = -1

    def __init__(self, lat: int, lon: int):
        MAVLink_message.__init__(self, MAVLink_terrain_check_message.id, MAVLink_terrain_check_message.msgname)
        self._fieldnames = MAVLink_terrain_check_message.fieldnames
        self._instance_field = MAVLink_terrain_check_message.instance_field
        self._instance_offset = MAVLink_terrain_check_message.instance_offset
        self.lat = lat
        self.lon = lon

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.lat, self.lon), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_terrain_check_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_terrain_report_message(MAVLink_message):
    """
    Streamed from drone to report progress of terrain map download
    (initiated by TERRAIN_REQUEST), or sent as a response to a
    TERRAIN_CHECK request. See terrain protocol docs:
    https://mavlink.io/en/services/terrain.html
    """

    id = MAVLINK_MSG_ID_TERRAIN_REPORT
    msgname = "TERRAIN_REPORT"
    fieldnames = ["lat", "lon", "spacing", "terrain_height", "current_height", "pending", "loaded"]
    ordered_fieldnames = ["lat", "lon", "terrain_height", "current_height", "spacing", "pending", "loaded"]
    fieldtypes = ["int32_t", "int32_t", "uint16_t", "float", "float", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"lat": "degE7", "lon": "degE7", "terrain_height": "m", "current_height": "m"}
    native_format = bytearray(b"<iiffHHH")
    orders = [0, 1, 4, 2, 3, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 1
    unpacker = struct.Struct("<iiffHHH")
    instance_field = None
    instance_offset = -1

    def __init__(self, lat: int, lon: int, spacing: int, terrain_height: float, current_height: float, pending: int, loaded: int):
        MAVLink_message.__init__(self, MAVLink_terrain_report_message.id, MAVLink_terrain_report_message.msgname)
        self._fieldnames = MAVLink_terrain_report_message.fieldnames
        self._instance_field = MAVLink_terrain_report_message.instance_field
        self._instance_offset = MAVLink_terrain_report_message.instance_offset
        self.lat = lat
        self.lon = lon
        self.spacing = spacing
        self.terrain_height = terrain_height
        self.current_height = current_height
        self.pending = pending
        self.loaded = loaded

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.lat, self.lon, self.terrain_height, self.current_height, self.spacing, self.pending, self.loaded), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_terrain_report_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_scaled_pressure2_message(MAVLink_message):
    """
    Barometer readings for 2nd barometer
    """

    id = MAVLINK_MSG_ID_SCALED_PRESSURE2
    msgname = "SCALED_PRESSURE2"
    fieldnames = ["time_boot_ms", "press_abs", "press_diff", "temperature", "temperature_press_diff"]
    ordered_fieldnames = ["time_boot_ms", "press_abs", "press_diff", "temperature", "temperature_press_diff"]
    fieldtypes = ["uint32_t", "float", "float", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "press_abs": "hPa", "press_diff": "hPa", "temperature": "cdegC", "temperature_press_diff": "cdegC"}
    native_format = bytearray(b"<Iffhh")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 195
    unpacker = struct.Struct("<Iffhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, press_abs: float, press_diff: float, temperature: int, temperature_press_diff: int = 0):
        MAVLink_message.__init__(self, MAVLink_scaled_pressure2_message.id, MAVLink_scaled_pressure2_message.msgname)
        self._fieldnames = MAVLink_scaled_pressure2_message.fieldnames
        self._instance_field = MAVLink_scaled_pressure2_message.instance_field
        self._instance_offset = MAVLink_scaled_pressure2_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.press_abs = press_abs
        self.press_diff = press_diff
        self.temperature = temperature
        self.temperature_press_diff = temperature_press_diff

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.press_abs, self.press_diff, self.temperature, self.temperature_press_diff), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_scaled_pressure2_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_att_pos_mocap_message(MAVLink_message):
    """
    Motion capture attitude and position
    """

    id = MAVLINK_MSG_ID_ATT_POS_MOCAP
    msgname = "ATT_POS_MOCAP"
    fieldnames = ["time_usec", "q", "x", "y", "z", "covariance"]
    ordered_fieldnames = ["time_usec", "q", "x", "y", "z", "covariance"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "x": "m", "y": "m", "z": "m"}
    native_format = bytearray(b"<Qfffff")
    orders = [0, 1, 2, 3, 4, 5]
    lengths = [1, 4, 1, 1, 1, 21]
    array_lengths = [0, 4, 0, 0, 0, 21]
    crc_extra = 109
    unpacker = struct.Struct("<Q4ffff21f")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, q: Sequence[float], x: float, y: float, z: float, covariance: Sequence[float] = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)):
        MAVLink_message.__init__(self, MAVLink_att_pos_mocap_message.id, MAVLink_att_pos_mocap_message.msgname)
        self._fieldnames = MAVLink_att_pos_mocap_message.fieldnames
        self._instance_field = MAVLink_att_pos_mocap_message.instance_field
        self._instance_offset = MAVLink_att_pos_mocap_message.instance_offset
        self.time_usec = time_usec
        self.q = q
        self.x = x
        self.y = y
        self.z = z
        self.covariance = covariance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.q[0], self.q[1], self.q[2], self.q[3], self.x, self.y, self.z, self.covariance[0], self.covariance[1], self.covariance[2], self.covariance[3], self.covariance[4], self.covariance[5], self.covariance[6], self.covariance[7], self.covariance[8], self.covariance[9], self.covariance[10], self.covariance[11], self.covariance[12], self.covariance[13], self.covariance[14], self.covariance[15], self.covariance[16], self.covariance[17], self.covariance[18], self.covariance[19], self.covariance[20]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_att_pos_mocap_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_set_actuator_control_target_message(MAVLink_message):
    """
    Set the vehicle attitude and body angular rates.
    """

    id = MAVLINK_MSG_ID_SET_ACTUATOR_CONTROL_TARGET
    msgname = "SET_ACTUATOR_CONTROL_TARGET"
    fieldnames = ["time_usec", "group_mlx", "target_system", "target_component", "controls"]
    ordered_fieldnames = ["time_usec", "controls", "group_mlx", "target_system", "target_component"]
    fieldtypes = ["uint64_t", "uint8_t", "uint8_t", "uint8_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QfBBB")
    orders = [0, 2, 3, 4, 1]
    lengths = [1, 8, 1, 1, 1]
    array_lengths = [0, 8, 0, 0, 0]
    crc_extra = 168
    unpacker = struct.Struct("<Q8fBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, group_mlx: int, target_system: int, target_component: int, controls: Sequence[float]):
        MAVLink_message.__init__(self, MAVLink_set_actuator_control_target_message.id, MAVLink_set_actuator_control_target_message.msgname)
        self._fieldnames = MAVLink_set_actuator_control_target_message.fieldnames
        self._instance_field = MAVLink_set_actuator_control_target_message.instance_field
        self._instance_offset = MAVLink_set_actuator_control_target_message.instance_offset
        self.time_usec = time_usec
        self.group_mlx = group_mlx
        self.target_system = target_system
        self.target_component = target_component
        self.controls = controls

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.controls[0], self.controls[1], self.controls[2], self.controls[3], self.controls[4], self.controls[5], self.controls[6], self.controls[7], self.group_mlx, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_set_actuator_control_target_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_actuator_control_target_message(MAVLink_message):
    """
    Set the vehicle attitude and body angular rates.
    """

    id = MAVLINK_MSG_ID_ACTUATOR_CONTROL_TARGET
    msgname = "ACTUATOR_CONTROL_TARGET"
    fieldnames = ["time_usec", "group_mlx", "controls"]
    ordered_fieldnames = ["time_usec", "controls", "group_mlx"]
    fieldtypes = ["uint64_t", "uint8_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QfB")
    orders = [0, 2, 1]
    lengths = [1, 8, 1]
    array_lengths = [0, 8, 0]
    crc_extra = 181
    unpacker = struct.Struct("<Q8fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, group_mlx: int, controls: Sequence[float]):
        MAVLink_message.__init__(self, MAVLink_actuator_control_target_message.id, MAVLink_actuator_control_target_message.msgname)
        self._fieldnames = MAVLink_actuator_control_target_message.fieldnames
        self._instance_field = MAVLink_actuator_control_target_message.instance_field
        self._instance_offset = MAVLink_actuator_control_target_message.instance_offset
        self.time_usec = time_usec
        self.group_mlx = group_mlx
        self.controls = controls

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.controls[0], self.controls[1], self.controls[2], self.controls[3], self.controls[4], self.controls[5], self.controls[6], self.controls[7], self.group_mlx), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_actuator_control_target_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_altitude_message(MAVLink_message):
    """
    The current system altitude.
    """

    id = MAVLINK_MSG_ID_ALTITUDE
    msgname = "ALTITUDE"
    fieldnames = ["time_usec", "altitude_monotonic", "altitude_amsl", "altitude_local", "altitude_relative", "altitude_terrain", "bottom_clearance"]
    ordered_fieldnames = ["time_usec", "altitude_monotonic", "altitude_amsl", "altitude_local", "altitude_relative", "altitude_terrain", "bottom_clearance"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "altitude_monotonic": "m", "altitude_amsl": "m", "altitude_local": "m", "altitude_relative": "m", "altitude_terrain": "m", "bottom_clearance": "m"}
    native_format = bytearray(b"<Qffffff")
    orders = [0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 47
    unpacker = struct.Struct("<Qffffff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, altitude_monotonic: float, altitude_amsl: float, altitude_local: float, altitude_relative: float, altitude_terrain: float, bottom_clearance: float):
        MAVLink_message.__init__(self, MAVLink_altitude_message.id, MAVLink_altitude_message.msgname)
        self._fieldnames = MAVLink_altitude_message.fieldnames
        self._instance_field = MAVLink_altitude_message.instance_field
        self._instance_offset = MAVLink_altitude_message.instance_offset
        self.time_usec = time_usec
        self.altitude_monotonic = altitude_monotonic
        self.altitude_amsl = altitude_amsl
        self.altitude_local = altitude_local
        self.altitude_relative = altitude_relative
        self.altitude_terrain = altitude_terrain
        self.bottom_clearance = bottom_clearance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.altitude_monotonic, self.altitude_amsl, self.altitude_local, self.altitude_relative, self.altitude_terrain, self.bottom_clearance), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_altitude_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_resource_request_message(MAVLink_message):
    """
    The autopilot is requesting a resource (file, binary, other type
    of data)
    """

    id = MAVLINK_MSG_ID_RESOURCE_REQUEST
    msgname = "RESOURCE_REQUEST"
    fieldnames = ["request_id", "uri_type", "uri", "transfer_type", "storage"]
    ordered_fieldnames = ["request_id", "uri_type", "uri", "transfer_type", "storage"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBBBB")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 120, 1, 120]
    array_lengths = [0, 0, 120, 0, 120]
    crc_extra = 72
    unpacker = struct.Struct("<BB120BB120B")
    instance_field = None
    instance_offset = -1

    def __init__(self, request_id: int, uri_type: int, uri: Sequence[int], transfer_type: int, storage: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_resource_request_message.id, MAVLink_resource_request_message.msgname)
        self._fieldnames = MAVLink_resource_request_message.fieldnames
        self._instance_field = MAVLink_resource_request_message.instance_field
        self._instance_offset = MAVLink_resource_request_message.instance_offset
        self.request_id = request_id
        self.uri_type = uri_type
        self.uri = uri
        self.transfer_type = transfer_type
        self.storage = storage

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.request_id, self.uri_type, self.uri[0], self.uri[1], self.uri[2], self.uri[3], self.uri[4], self.uri[5], self.uri[6], self.uri[7], self.uri[8], self.uri[9], self.uri[10], self.uri[11], self.uri[12], self.uri[13], self.uri[14], self.uri[15], self.uri[16], self.uri[17], self.uri[18], self.uri[19], self.uri[20], self.uri[21], self.uri[22], self.uri[23], self.uri[24], self.uri[25], self.uri[26], self.uri[27], self.uri[28], self.uri[29], self.uri[30], self.uri[31], self.uri[32], self.uri[33], self.uri[34], self.uri[35], self.uri[36], self.uri[37], self.uri[38], self.uri[39], self.uri[40], self.uri[41], self.uri[42], self.uri[43], self.uri[44], self.uri[45], self.uri[46], self.uri[47], self.uri[48], self.uri[49], self.uri[50], self.uri[51], self.uri[52], self.uri[53], self.uri[54], self.uri[55], self.uri[56], self.uri[57], self.uri[58], self.uri[59], self.uri[60], self.uri[61], self.uri[62], self.uri[63], self.uri[64], self.uri[65], self.uri[66], self.uri[67], self.uri[68], self.uri[69], self.uri[70], self.uri[71], self.uri[72], self.uri[73], self.uri[74], self.uri[75], self.uri[76], self.uri[77], self.uri[78], self.uri[79], self.uri[80], self.uri[81], self.uri[82], self.uri[83], self.uri[84], self.uri[85], self.uri[86], self.uri[87], self.uri[88], self.uri[89], self.uri[90], self.uri[91], self.uri[92], self.uri[93], self.uri[94], self.uri[95], self.uri[96], self.uri[97], self.uri[98], self.uri[99], self.uri[100], self.uri[101], self.uri[102], self.uri[103], self.uri[104], self.uri[105], self.uri[106], self.uri[107], self.uri[108], self.uri[109], self.uri[110], self.uri[111], self.uri[112], self.uri[113], self.uri[114], self.uri[115], self.uri[116], self.uri[117], self.uri[118], self.uri[119], self.transfer_type, self.storage[0], self.storage[1], self.storage[2], self.storage[3], self.storage[4], self.storage[5], self.storage[6], self.storage[7], self.storage[8], self.storage[9], self.storage[10], self.storage[11], self.storage[12], self.storage[13], self.storage[14], self.storage[15], self.storage[16], self.storage[17], self.storage[18], self.storage[19], self.storage[20], self.storage[21], self.storage[22], self.storage[23], self.storage[24], self.storage[25], self.storage[26], self.storage[27], self.storage[28], self.storage[29], self.storage[30], self.storage[31], self.storage[32], self.storage[33], self.storage[34], self.storage[35], self.storage[36], self.storage[37], self.storage[38], self.storage[39], self.storage[40], self.storage[41], self.storage[42], self.storage[43], self.storage[44], self.storage[45], self.storage[46], self.storage[47], self.storage[48], self.storage[49], self.storage[50], self.storage[51], self.storage[52], self.storage[53], self.storage[54], self.storage[55], self.storage[56], self.storage[57], self.storage[58], self.storage[59], self.storage[60], self.storage[61], self.storage[62], self.storage[63], self.storage[64], self.storage[65], self.storage[66], self.storage[67], self.storage[68], self.storage[69], self.storage[70], self.storage[71], self.storage[72], self.storage[73], self.storage[74], self.storage[75], self.storage[76], self.storage[77], self.storage[78], self.storage[79], self.storage[80], self.storage[81], self.storage[82], self.storage[83], self.storage[84], self.storage[85], self.storage[86], self.storage[87], self.storage[88], self.storage[89], self.storage[90], self.storage[91], self.storage[92], self.storage[93], self.storage[94], self.storage[95], self.storage[96], self.storage[97], self.storage[98], self.storage[99], self.storage[100], self.storage[101], self.storage[102], self.storage[103], self.storage[104], self.storage[105], self.storage[106], self.storage[107], self.storage[108], self.storage[109], self.storage[110], self.storage[111], self.storage[112], self.storage[113], self.storage[114], self.storage[115], self.storage[116], self.storage[117], self.storage[118], self.storage[119]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_resource_request_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_scaled_pressure3_message(MAVLink_message):
    """
    Barometer readings for 3rd barometer
    """

    id = MAVLINK_MSG_ID_SCALED_PRESSURE3
    msgname = "SCALED_PRESSURE3"
    fieldnames = ["time_boot_ms", "press_abs", "press_diff", "temperature", "temperature_press_diff"]
    ordered_fieldnames = ["time_boot_ms", "press_abs", "press_diff", "temperature", "temperature_press_diff"]
    fieldtypes = ["uint32_t", "float", "float", "int16_t", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "press_abs": "hPa", "press_diff": "hPa", "temperature": "cdegC", "temperature_press_diff": "cdegC"}
    native_format = bytearray(b"<Iffhh")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 131
    unpacker = struct.Struct("<Iffhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, press_abs: float, press_diff: float, temperature: int, temperature_press_diff: int = 0):
        MAVLink_message.__init__(self, MAVLink_scaled_pressure3_message.id, MAVLink_scaled_pressure3_message.msgname)
        self._fieldnames = MAVLink_scaled_pressure3_message.fieldnames
        self._instance_field = MAVLink_scaled_pressure3_message.instance_field
        self._instance_offset = MAVLink_scaled_pressure3_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.press_abs = press_abs
        self.press_diff = press_diff
        self.temperature = temperature
        self.temperature_press_diff = temperature_press_diff

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.press_abs, self.press_diff, self.temperature, self.temperature_press_diff), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_scaled_pressure3_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_follow_target_message(MAVLink_message):
    """
    Current motion information from a designated system
    """

    id = MAVLINK_MSG_ID_FOLLOW_TARGET
    msgname = "FOLLOW_TARGET"
    fieldnames = ["timestamp", "est_capabilities", "lat", "lon", "alt", "vel", "acc", "attitude_q", "rates", "position_cov", "custom_state"]
    ordered_fieldnames = ["timestamp", "custom_state", "lat", "lon", "alt", "vel", "acc", "attitude_q", "rates", "position_cov", "est_capabilities"]
    fieldtypes = ["uint64_t", "uint8_t", "int32_t", "int32_t", "float", "float", "float", "float", "float", "float", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"timestamp": "ms", "lat": "degE7", "lon": "degE7", "alt": "m", "vel": "m/s", "acc": "m/s/s"}
    native_format = bytearray(b"<QQiiffffffB")
    orders = [0, 10, 2, 3, 4, 5, 6, 7, 8, 9, 1]
    lengths = [1, 1, 1, 1, 1, 3, 3, 4, 3, 3, 1]
    array_lengths = [0, 0, 0, 0, 0, 3, 3, 4, 3, 3, 0]
    crc_extra = 127
    unpacker = struct.Struct("<QQiif3f3f4f3f3fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, timestamp: int, est_capabilities: int, lat: int, lon: int, alt: float, vel: Sequence[float], acc: Sequence[float], attitude_q: Sequence[float], rates: Sequence[float], position_cov: Sequence[float], custom_state: int):
        MAVLink_message.__init__(self, MAVLink_follow_target_message.id, MAVLink_follow_target_message.msgname)
        self._fieldnames = MAVLink_follow_target_message.fieldnames
        self._instance_field = MAVLink_follow_target_message.instance_field
        self._instance_offset = MAVLink_follow_target_message.instance_offset
        self.timestamp = timestamp
        self.est_capabilities = est_capabilities
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.vel = vel
        self.acc = acc
        self.attitude_q = attitude_q
        self.rates = rates
        self.position_cov = position_cov
        self.custom_state = custom_state

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.timestamp, self.custom_state, self.lat, self.lon, self.alt, self.vel[0], self.vel[1], self.vel[2], self.acc[0], self.acc[1], self.acc[2], self.attitude_q[0], self.attitude_q[1], self.attitude_q[2], self.attitude_q[3], self.rates[0], self.rates[1], self.rates[2], self.position_cov[0], self.position_cov[1], self.position_cov[2], self.est_capabilities), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_follow_target_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_control_system_state_message(MAVLink_message):
    """
    The smoothed, monotonic system state used to feed the control
    loops of the system.
    """

    id = MAVLINK_MSG_ID_CONTROL_SYSTEM_STATE
    msgname = "CONTROL_SYSTEM_STATE"
    fieldnames = ["time_usec", "x_acc", "y_acc", "z_acc", "x_vel", "y_vel", "z_vel", "x_pos", "y_pos", "z_pos", "airspeed", "vel_variance", "pos_variance", "q", "roll_rate", "pitch_rate", "yaw_rate"]
    ordered_fieldnames = ["time_usec", "x_acc", "y_acc", "z_acc", "x_vel", "y_vel", "z_vel", "x_pos", "y_pos", "z_pos", "airspeed", "vel_variance", "pos_variance", "q", "roll_rate", "pitch_rate", "yaw_rate"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "x_acc": "m/s/s", "y_acc": "m/s/s", "z_acc": "m/s/s", "x_vel": "m/s", "y_vel": "m/s", "z_vel": "m/s", "x_pos": "m", "y_pos": "m", "z_pos": "m", "airspeed": "m/s", "roll_rate": "rad/s", "pitch_rate": "rad/s", "yaw_rate": "rad/s"}
    native_format = bytearray(b"<Qffffffffffffffff")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 4, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 4, 0, 0, 0]
    crc_extra = 103
    unpacker = struct.Struct("<Qffffffffff3f3f4ffff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, x_acc: float, y_acc: float, z_acc: float, x_vel: float, y_vel: float, z_vel: float, x_pos: float, y_pos: float, z_pos: float, airspeed: float, vel_variance: Sequence[float], pos_variance: Sequence[float], q: Sequence[float], roll_rate: float, pitch_rate: float, yaw_rate: float):
        MAVLink_message.__init__(self, MAVLink_control_system_state_message.id, MAVLink_control_system_state_message.msgname)
        self._fieldnames = MAVLink_control_system_state_message.fieldnames
        self._instance_field = MAVLink_control_system_state_message.instance_field
        self._instance_offset = MAVLink_control_system_state_message.instance_offset
        self.time_usec = time_usec
        self.x_acc = x_acc
        self.y_acc = y_acc
        self.z_acc = z_acc
        self.x_vel = x_vel
        self.y_vel = y_vel
        self.z_vel = z_vel
        self.x_pos = x_pos
        self.y_pos = y_pos
        self.z_pos = z_pos
        self.airspeed = airspeed
        self.vel_variance = vel_variance
        self.pos_variance = pos_variance
        self.q = q
        self.roll_rate = roll_rate
        self.pitch_rate = pitch_rate
        self.yaw_rate = yaw_rate

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.x_acc, self.y_acc, self.z_acc, self.x_vel, self.y_vel, self.z_vel, self.x_pos, self.y_pos, self.z_pos, self.airspeed, self.vel_variance[0], self.vel_variance[1], self.vel_variance[2], self.pos_variance[0], self.pos_variance[1], self.pos_variance[2], self.q[0], self.q[1], self.q[2], self.q[3], self.roll_rate, self.pitch_rate, self.yaw_rate), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_control_system_state_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_battery_status_message(MAVLink_message):
    """
    Battery information
    """

    id = MAVLINK_MSG_ID_BATTERY_STATUS
    msgname = "BATTERY_STATUS"
    fieldnames = ["id", "battery_function", "type", "temperature", "voltages", "current_battery", "current_consumed", "energy_consumed", "battery_remaining", "time_remaining", "charge_state", "voltages_ext", "mode", "fault_bitmask"]
    ordered_fieldnames = ["current_consumed", "energy_consumed", "temperature", "voltages", "current_battery", "id", "battery_function", "type", "battery_remaining", "time_remaining", "charge_state", "voltages_ext", "mode", "fault_bitmask"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "int16_t", "uint16_t", "int16_t", "int32_t", "int32_t", "int8_t", "int32_t", "uint8_t", "uint16_t", "uint8_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {"fault_bitmask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"battery_function": "MAV_BATTERY_FUNCTION", "type": "MAV_BATTERY_TYPE", "charge_state": "MAV_BATTERY_CHARGE_STATE", "mode": "MAV_BATTERY_MODE", "fault_bitmask": "MAV_BATTERY_FAULT"}
    fieldunits_by_name: Dict[str, str] = {"temperature": "cdegC", "voltages": "mV", "current_battery": "cA", "current_consumed": "mAh", "energy_consumed": "hJ", "battery_remaining": "%", "time_remaining": "s", "voltages_ext": "mV"}
    native_format = bytearray(b"<iihHhBBBbiBHBI")
    orders = [5, 6, 7, 2, 3, 4, 0, 1, 8, 9, 10, 11, 12, 13]
    lengths = [1, 1, 1, 10, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1]
    array_lengths = [0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0]
    crc_extra = 154
    unpacker = struct.Struct("<iih10HhBBBbiB4HBI")
    instance_field = "id"
    instance_offset = 32

    def __init__(self, id: int, battery_function: int, type: int, temperature: int, voltages: Sequence[int], current_battery: int, current_consumed: int, energy_consumed: int, battery_remaining: int, time_remaining: int = 0, charge_state: int = 0, voltages_ext: Sequence[int] = (0, 0, 0, 0), mode: int = 0, fault_bitmask: int = 0):
        MAVLink_message.__init__(self, MAVLink_battery_status_message.id, MAVLink_battery_status_message.msgname)
        self._fieldnames = MAVLink_battery_status_message.fieldnames
        self._instance_field = MAVLink_battery_status_message.instance_field
        self._instance_offset = MAVLink_battery_status_message.instance_offset
        self.id = id
        self.battery_function = battery_function
        self.type = type
        self.temperature = temperature
        self.voltages = voltages
        self.current_battery = current_battery
        self.current_consumed = current_consumed
        self.energy_consumed = energy_consumed
        self.battery_remaining = battery_remaining
        self.time_remaining = time_remaining
        self.charge_state = charge_state
        self.voltages_ext = voltages_ext
        self.mode = mode
        self.fault_bitmask = fault_bitmask

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.current_consumed, self.energy_consumed, self.temperature, self.voltages[0], self.voltages[1], self.voltages[2], self.voltages[3], self.voltages[4], self.voltages[5], self.voltages[6], self.voltages[7], self.voltages[8], self.voltages[9], self.current_battery, self.id, self.battery_function, self.type, self.battery_remaining, self.time_remaining, self.charge_state, self.voltages_ext[0], self.voltages_ext[1], self.voltages_ext[2], self.voltages_ext[3], self.mode, self.fault_bitmask), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_battery_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_autopilot_version_message(MAVLink_message):
    """
    Version and capability of autopilot software. This should be
    emitted in response to a request with MAV_CMD_REQUEST_MESSAGE.
    """

    id = MAVLINK_MSG_ID_AUTOPILOT_VERSION
    msgname = "AUTOPILOT_VERSION"
    fieldnames = ["capabilities", "flight_sw_version", "middleware_sw_version", "os_sw_version", "board_version", "flight_custom_version", "middleware_custom_version", "os_custom_version", "vendor_id", "product_id", "uid", "uid2"]
    ordered_fieldnames = ["capabilities", "uid", "flight_sw_version", "middleware_sw_version", "os_sw_version", "board_version", "vendor_id", "product_id", "flight_custom_version", "middleware_custom_version", "os_custom_version", "uid2"]
    fieldtypes = ["uint64_t", "uint32_t", "uint32_t", "uint32_t", "uint32_t", "uint8_t", "uint8_t", "uint8_t", "uint16_t", "uint16_t", "uint64_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"capabilities": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"capabilities": "MAV_PROTOCOL_CAPABILITY"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<QQIIIIHHBBBB")
    orders = [0, 2, 3, 4, 5, 8, 9, 10, 6, 7, 1, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 8, 8, 8, 18]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 18]
    crc_extra = 178
    unpacker = struct.Struct("<QQIIIIHH8B8B8B18B")
    instance_field = None
    instance_offset = -1

    def __init__(self, capabilities: int, flight_sw_version: int, middleware_sw_version: int, os_sw_version: int, board_version: int, flight_custom_version: Sequence[int], middleware_custom_version: Sequence[int], os_custom_version: Sequence[int], vendor_id: int, product_id: int, uid: int, uid2: Sequence[int] = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)):
        MAVLink_message.__init__(self, MAVLink_autopilot_version_message.id, MAVLink_autopilot_version_message.msgname)
        self._fieldnames = MAVLink_autopilot_version_message.fieldnames
        self._instance_field = MAVLink_autopilot_version_message.instance_field
        self._instance_offset = MAVLink_autopilot_version_message.instance_offset
        self.capabilities = capabilities
        self.flight_sw_version = flight_sw_version
        self.middleware_sw_version = middleware_sw_version
        self.os_sw_version = os_sw_version
        self.board_version = board_version
        self.flight_custom_version = flight_custom_version
        self.middleware_custom_version = middleware_custom_version
        self.os_custom_version = os_custom_version
        self.vendor_id = vendor_id
        self.product_id = product_id
        self.uid = uid
        self.uid2 = uid2

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.capabilities, self.uid, self.flight_sw_version, self.middleware_sw_version, self.os_sw_version, self.board_version, self.vendor_id, self.product_id, self.flight_custom_version[0], self.flight_custom_version[1], self.flight_custom_version[2], self.flight_custom_version[3], self.flight_custom_version[4], self.flight_custom_version[5], self.flight_custom_version[6], self.flight_custom_version[7], self.middleware_custom_version[0], self.middleware_custom_version[1], self.middleware_custom_version[2], self.middleware_custom_version[3], self.middleware_custom_version[4], self.middleware_custom_version[5], self.middleware_custom_version[6], self.middleware_custom_version[7], self.os_custom_version[0], self.os_custom_version[1], self.os_custom_version[2], self.os_custom_version[3], self.os_custom_version[4], self.os_custom_version[5], self.os_custom_version[6], self.os_custom_version[7], self.uid2[0], self.uid2[1], self.uid2[2], self.uid2[3], self.uid2[4], self.uid2[5], self.uid2[6], self.uid2[7], self.uid2[8], self.uid2[9], self.uid2[10], self.uid2[11], self.uid2[12], self.uid2[13], self.uid2[14], self.uid2[15], self.uid2[16], self.uid2[17]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_autopilot_version_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_landing_target_message(MAVLink_message):
    """
    The location of a landing target. See:
    https://mavlink.io/en/services/landing_target.html
    """

    id = MAVLINK_MSG_ID_LANDING_TARGET
    msgname = "LANDING_TARGET"
    fieldnames = ["time_usec", "target_num", "frame", "angle_x", "angle_y", "distance", "size_x", "size_y", "x", "y", "z", "q", "type", "position_valid"]
    ordered_fieldnames = ["time_usec", "angle_x", "angle_y", "distance", "size_x", "size_y", "target_num", "frame", "x", "y", "z", "q", "type", "position_valid"]
    fieldtypes = ["uint64_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"position_valid": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"frame": "MAV_FRAME", "type": "LANDING_TARGET_TYPE", "position_valid": "MAV_BOOL"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "angle_x": "rad", "angle_y": "rad", "distance": "m", "size_x": "rad", "size_y": "rad", "x": "m", "y": "m", "z": "m"}
    native_format = bytearray(b"<QfffffBBffffBB")
    orders = [0, 6, 7, 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0]
    crc_extra = 200
    unpacker = struct.Struct("<QfffffBBfff4fBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, target_num: int, frame: int, angle_x: float, angle_y: float, distance: float, size_x: float, size_y: float, x: float = 0, y: float = 0, z: float = 0, q: Sequence[float] = (0, 0, 0, 0), type: int = 0, position_valid: int = 0):
        MAVLink_message.__init__(self, MAVLink_landing_target_message.id, MAVLink_landing_target_message.msgname)
        self._fieldnames = MAVLink_landing_target_message.fieldnames
        self._instance_field = MAVLink_landing_target_message.instance_field
        self._instance_offset = MAVLink_landing_target_message.instance_offset
        self.time_usec = time_usec
        self.target_num = target_num
        self.frame = frame
        self.angle_x = angle_x
        self.angle_y = angle_y
        self.distance = distance
        self.size_x = size_x
        self.size_y = size_y
        self.x = x
        self.y = y
        self.z = z
        self.q = q
        self.type = type
        self.position_valid = position_valid

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.angle_x, self.angle_y, self.distance, self.size_x, self.size_y, self.target_num, self.frame, self.x, self.y, self.z, self.q[0], self.q[1], self.q[2], self.q[3], self.type, self.position_valid), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_landing_target_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_fence_status_message(MAVLink_message):
    """
    Status of geo-fencing. Sent in extended status stream when fencing
    enabled.
    """

    id = MAVLINK_MSG_ID_FENCE_STATUS
    msgname = "FENCE_STATUS"
    fieldnames = ["breach_status", "breach_count", "breach_type", "breach_time", "breach_mitigation"]
    ordered_fieldnames = ["breach_time", "breach_count", "breach_status", "breach_type", "breach_mitigation"]
    fieldtypes = ["uint8_t", "uint16_t", "uint8_t", "uint32_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"breach_type": "FENCE_BREACH", "breach_mitigation": "FENCE_MITIGATE"}
    fieldunits_by_name: Dict[str, str] = {"breach_time": "ms"}
    native_format = bytearray(b"<IHBBB")
    orders = [2, 1, 3, 0, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 189
    unpacker = struct.Struct("<IHBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, breach_status: int, breach_count: int, breach_type: int, breach_time: int, breach_mitigation: int = 0):
        MAVLink_message.__init__(self, MAVLink_fence_status_message.id, MAVLink_fence_status_message.msgname)
        self._fieldnames = MAVLink_fence_status_message.fieldnames
        self._instance_field = MAVLink_fence_status_message.instance_field
        self._instance_offset = MAVLink_fence_status_message.instance_offset
        self.breach_status = breach_status
        self.breach_count = breach_count
        self.breach_type = breach_type
        self.breach_time = breach_time
        self.breach_mitigation = breach_mitigation

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.breach_time, self.breach_count, self.breach_status, self.breach_type, self.breach_mitigation), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_fence_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mag_cal_report_message(MAVLink_message):
    """
    Reports results of completed compass calibration. Sent until
    MAG_CAL_ACK received.
    """

    id = MAVLINK_MSG_ID_MAG_CAL_REPORT
    msgname = "MAG_CAL_REPORT"
    fieldnames = ["compass_id", "cal_mask", "cal_status", "autosaved", "fitness", "ofs_x", "ofs_y", "ofs_z", "diag_x", "diag_y", "diag_z", "offdiag_x", "offdiag_y", "offdiag_z", "orientation_confidence", "old_orientation", "new_orientation", "scale_factor"]
    ordered_fieldnames = ["fitness", "ofs_x", "ofs_y", "ofs_z", "diag_x", "diag_y", "diag_z", "offdiag_x", "offdiag_y", "offdiag_z", "compass_id", "cal_mask", "cal_status", "autosaved", "orientation_confidence", "old_orientation", "new_orientation", "scale_factor"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "uint8_t", "uint8_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {"cal_mask": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"cal_status": "MAG_CAL_STATUS", "old_orientation": "MAV_SENSOR_ORIENTATION", "new_orientation": "MAV_SENSOR_ORIENTATION"}
    fieldunits_by_name: Dict[str, str] = {"fitness": "mgauss"}
    native_format = bytearray(b"<ffffffffffBBBBfBBf")
    orders = [10, 11, 12, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 15, 16, 17]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 36
    unpacker = struct.Struct("<ffffffffffBBBBfBBf")
    instance_field = "compass_id"
    instance_offset = 40

    def __init__(self, compass_id: int, cal_mask: int, cal_status: int, autosaved: int, fitness: float, ofs_x: float, ofs_y: float, ofs_z: float, diag_x: float, diag_y: float, diag_z: float, offdiag_x: float, offdiag_y: float, offdiag_z: float, orientation_confidence: float = 0, old_orientation: int = 0, new_orientation: int = 0, scale_factor: float = 0):
        MAVLink_message.__init__(self, MAVLink_mag_cal_report_message.id, MAVLink_mag_cal_report_message.msgname)
        self._fieldnames = MAVLink_mag_cal_report_message.fieldnames
        self._instance_field = MAVLink_mag_cal_report_message.instance_field
        self._instance_offset = MAVLink_mag_cal_report_message.instance_offset
        self.compass_id = compass_id
        self.cal_mask = cal_mask
        self.cal_status = cal_status
        self.autosaved = autosaved
        self.fitness = fitness
        self.ofs_x = ofs_x
        self.ofs_y = ofs_y
        self.ofs_z = ofs_z
        self.diag_x = diag_x
        self.diag_y = diag_y
        self.diag_z = diag_z
        self.offdiag_x = offdiag_x
        self.offdiag_y = offdiag_y
        self.offdiag_z = offdiag_z
        self.orientation_confidence = orientation_confidence
        self.old_orientation = old_orientation
        self.new_orientation = new_orientation
        self.scale_factor = scale_factor

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.fitness, self.ofs_x, self.ofs_y, self.ofs_z, self.diag_x, self.diag_y, self.diag_z, self.offdiag_x, self.offdiag_y, self.offdiag_z, self.compass_id, self.cal_mask, self.cal_status, self.autosaved, self.orientation_confidence, self.old_orientation, self.new_orientation, self.scale_factor), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mag_cal_report_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_efi_status_message(MAVLink_message):
    """
    EFI status output
    """

    id = MAVLINK_MSG_ID_EFI_STATUS
    msgname = "EFI_STATUS"
    fieldnames = ["health", "ecu_index", "rpm", "fuel_consumed", "fuel_flow", "engine_load", "throttle_position", "spark_dwell_time", "barometric_pressure", "intake_manifold_pressure", "intake_manifold_temperature", "cylinder_head_temperature", "ignition_timing", "injection_time", "exhaust_gas_temperature", "throttle_out", "pt_compensation", "ignition_voltage", "fuel_pressure"]
    ordered_fieldnames = ["ecu_index", "rpm", "fuel_consumed", "fuel_flow", "engine_load", "throttle_position", "spark_dwell_time", "barometric_pressure", "intake_manifold_pressure", "intake_manifold_temperature", "cylinder_head_temperature", "ignition_timing", "injection_time", "exhaust_gas_temperature", "throttle_out", "pt_compensation", "health", "ignition_voltage", "fuel_pressure"]
    fieldtypes = ["uint8_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"fuel_consumed": "cm^3", "fuel_flow": "cm^3/min", "engine_load": "%", "throttle_position": "%", "spark_dwell_time": "ms", "barometric_pressure": "kPa", "intake_manifold_pressure": "kPa", "intake_manifold_temperature": "degC", "cylinder_head_temperature": "degC", "ignition_timing": "deg", "injection_time": "ms", "exhaust_gas_temperature": "degC", "throttle_out": "%", "ignition_voltage": "V", "fuel_pressure": "kPa"}
    native_format = bytearray(b"<ffffffffffffffffBff")
    orders = [16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 208
    unpacker = struct.Struct("<ffffffffffffffffBff")
    instance_field = None
    instance_offset = -1

    def __init__(self, health: int, ecu_index: float, rpm: float, fuel_consumed: float, fuel_flow: float, engine_load: float, throttle_position: float, spark_dwell_time: float, barometric_pressure: float, intake_manifold_pressure: float, intake_manifold_temperature: float, cylinder_head_temperature: float, ignition_timing: float, injection_time: float, exhaust_gas_temperature: float, throttle_out: float, pt_compensation: float, ignition_voltage: float = 0, fuel_pressure: float = 0):
        MAVLink_message.__init__(self, MAVLink_efi_status_message.id, MAVLink_efi_status_message.msgname)
        self._fieldnames = MAVLink_efi_status_message.fieldnames
        self._instance_field = MAVLink_efi_status_message.instance_field
        self._instance_offset = MAVLink_efi_status_message.instance_offset
        self.health = health
        self.ecu_index = ecu_index
        self.rpm = rpm
        self.fuel_consumed = fuel_consumed
        self.fuel_flow = fuel_flow
        self.engine_load = engine_load
        self.throttle_position = throttle_position
        self.spark_dwell_time = spark_dwell_time
        self.barometric_pressure = barometric_pressure
        self.intake_manifold_pressure = intake_manifold_pressure
        self.intake_manifold_temperature = intake_manifold_temperature
        self.cylinder_head_temperature = cylinder_head_temperature
        self.ignition_timing = ignition_timing
        self.injection_time = injection_time
        self.exhaust_gas_temperature = exhaust_gas_temperature
        self.throttle_out = throttle_out
        self.pt_compensation = pt_compensation
        self.ignition_voltage = ignition_voltage
        self.fuel_pressure = fuel_pressure

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.ecu_index, self.rpm, self.fuel_consumed, self.fuel_flow, self.engine_load, self.throttle_position, self.spark_dwell_time, self.barometric_pressure, self.intake_manifold_pressure, self.intake_manifold_temperature, self.cylinder_head_temperature, self.ignition_timing, self.injection_time, self.exhaust_gas_temperature, self.throttle_out, self.pt_compensation, self.health, self.ignition_voltage, self.fuel_pressure), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_efi_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_estimator_status_message(MAVLink_message):
    """
    Estimator status message including flags, innovation test ratios
    and estimated accuracies. The flags message is an integer bitmask
    containing information on which EKF outputs are valid. See the
    ESTIMATOR_STATUS_FLAGS enum definition for further information.
    The innovation test ratios show the magnitude of the sensor
    innovation divided by the innovation check threshold. Under normal
    operation the innovation test ratios should be below 0.5 with
    occasional values up to 1.0. Values greater than 1.0 should be
    rare under normal operation and indicate that a measurement has
    been rejected by the filter. The user should be notified if an
    innovation test ratio greater than 1.0 is recorded. Notifications
    for values in the range between 0.5 and 1.0 should be optional and
    controllable by the user.
    """

    id = MAVLINK_MSG_ID_ESTIMATOR_STATUS
    msgname = "ESTIMATOR_STATUS"
    fieldnames = ["time_usec", "flags", "vel_ratio", "pos_horiz_ratio", "pos_vert_ratio", "mag_ratio", "hagl_ratio", "tas_ratio", "pos_horiz_accuracy", "pos_vert_accuracy"]
    ordered_fieldnames = ["time_usec", "vel_ratio", "pos_horiz_ratio", "pos_vert_ratio", "mag_ratio", "hagl_ratio", "tas_ratio", "pos_horiz_accuracy", "pos_vert_accuracy", "flags"]
    fieldtypes = ["uint64_t", "uint16_t", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "ESTIMATOR_STATUS_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "pos_horiz_accuracy": "m", "pos_vert_accuracy": "m"}
    native_format = bytearray(b"<QffffffffH")
    orders = [0, 9, 1, 2, 3, 4, 5, 6, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 163
    unpacker = struct.Struct("<QffffffffH")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, flags: int, vel_ratio: float, pos_horiz_ratio: float, pos_vert_ratio: float, mag_ratio: float, hagl_ratio: float, tas_ratio: float, pos_horiz_accuracy: float, pos_vert_accuracy: float):
        MAVLink_message.__init__(self, MAVLink_estimator_status_message.id, MAVLink_estimator_status_message.msgname)
        self._fieldnames = MAVLink_estimator_status_message.fieldnames
        self._instance_field = MAVLink_estimator_status_message.instance_field
        self._instance_offset = MAVLink_estimator_status_message.instance_offset
        self.time_usec = time_usec
        self.flags = flags
        self.vel_ratio = vel_ratio
        self.pos_horiz_ratio = pos_horiz_ratio
        self.pos_vert_ratio = pos_vert_ratio
        self.mag_ratio = mag_ratio
        self.hagl_ratio = hagl_ratio
        self.tas_ratio = tas_ratio
        self.pos_horiz_accuracy = pos_horiz_accuracy
        self.pos_vert_accuracy = pos_vert_accuracy

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.vel_ratio, self.pos_horiz_ratio, self.pos_vert_ratio, self.mag_ratio, self.hagl_ratio, self.tas_ratio, self.pos_horiz_accuracy, self.pos_vert_accuracy, self.flags), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_estimator_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_wind_cov_message(MAVLink_message):
    """
    Wind covariance estimate from vehicle.
    """

    id = MAVLINK_MSG_ID_WIND_COV
    msgname = "WIND_COV"
    fieldnames = ["time_usec", "wind_x", "wind_y", "wind_z", "var_horiz", "var_vert", "wind_alt", "horiz_accuracy", "vert_accuracy"]
    ordered_fieldnames = ["time_usec", "wind_x", "wind_y", "wind_z", "var_horiz", "var_vert", "wind_alt", "horiz_accuracy", "vert_accuracy"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "wind_x": "m/s", "wind_y": "m/s", "wind_z": "m/s", "var_horiz": "m/s", "var_vert": "m/s", "wind_alt": "m", "horiz_accuracy": "m", "vert_accuracy": "m"}
    native_format = bytearray(b"<Qffffffff")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 105
    unpacker = struct.Struct("<Qffffffff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, wind_x: float, wind_y: float, wind_z: float, var_horiz: float, var_vert: float, wind_alt: float, horiz_accuracy: float, vert_accuracy: float):
        MAVLink_message.__init__(self, MAVLink_wind_cov_message.id, MAVLink_wind_cov_message.msgname)
        self._fieldnames = MAVLink_wind_cov_message.fieldnames
        self._instance_field = MAVLink_wind_cov_message.instance_field
        self._instance_offset = MAVLink_wind_cov_message.instance_offset
        self.time_usec = time_usec
        self.wind_x = wind_x
        self.wind_y = wind_y
        self.wind_z = wind_z
        self.var_horiz = var_horiz
        self.var_vert = var_vert
        self.wind_alt = wind_alt
        self.horiz_accuracy = horiz_accuracy
        self.vert_accuracy = vert_accuracy

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.wind_x, self.wind_y, self.wind_z, self.var_horiz, self.var_vert, self.wind_alt, self.horiz_accuracy, self.vert_accuracy), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_wind_cov_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps_input_message(MAVLink_message):
    """
    GPS sensor input message.  This is a raw sensor value sent by the
    GPS. This is NOT the global position estimate of the system.
    """

    id = MAVLINK_MSG_ID_GPS_INPUT
    msgname = "GPS_INPUT"
    fieldnames = ["time_usec", "gps_id", "ignore_flags", "time_week_ms", "time_week", "fix_type", "lat", "lon", "alt", "hdop", "vdop", "vn", "ve", "vd", "speed_accuracy", "horiz_accuracy", "vert_accuracy", "satellites_visible", "yaw"]
    ordered_fieldnames = ["time_usec", "time_week_ms", "lat", "lon", "alt", "hdop", "vdop", "vn", "ve", "vd", "speed_accuracy", "horiz_accuracy", "vert_accuracy", "ignore_flags", "time_week", "gps_id", "fix_type", "satellites_visible", "yaw"]
    fieldtypes = ["uint64_t", "uint8_t", "uint16_t", "uint32_t", "uint16_t", "uint8_t", "int32_t", "int32_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "uint8_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {"ignore_flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"ignore_flags": "GPS_INPUT_IGNORE_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "time_week_ms": "ms", "lat": "degE7", "lon": "degE7", "alt": "m", "vn": "m/s", "ve": "m/s", "vd": "m/s", "speed_accuracy": "m/s", "horiz_accuracy": "m", "vert_accuracy": "m", "yaw": "cdeg"}
    native_format = bytearray(b"<QIiifffffffffHHBBBH")
    orders = [0, 15, 13, 1, 14, 16, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 17, 18]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 151
    unpacker = struct.Struct("<QIiifffffffffHHBBBH")
    instance_field = "gps_id"
    instance_offset = 60

    def __init__(self, time_usec: int, gps_id: int, ignore_flags: int, time_week_ms: int, time_week: int, fix_type: int, lat: int, lon: int, alt: float, hdop: float, vdop: float, vn: float, ve: float, vd: float, speed_accuracy: float, horiz_accuracy: float, vert_accuracy: float, satellites_visible: int, yaw: int = 0):
        MAVLink_message.__init__(self, MAVLink_gps_input_message.id, MAVLink_gps_input_message.msgname)
        self._fieldnames = MAVLink_gps_input_message.fieldnames
        self._instance_field = MAVLink_gps_input_message.instance_field
        self._instance_offset = MAVLink_gps_input_message.instance_offset
        self.time_usec = time_usec
        self.gps_id = gps_id
        self.ignore_flags = ignore_flags
        self.time_week_ms = time_week_ms
        self.time_week = time_week
        self.fix_type = fix_type
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.hdop = hdop
        self.vdop = vdop
        self.vn = vn
        self.ve = ve
        self.vd = vd
        self.speed_accuracy = speed_accuracy
        self.horiz_accuracy = horiz_accuracy
        self.vert_accuracy = vert_accuracy
        self.satellites_visible = satellites_visible
        self.yaw = yaw

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.time_week_ms, self.lat, self.lon, self.alt, self.hdop, self.vdop, self.vn, self.ve, self.vd, self.speed_accuracy, self.horiz_accuracy, self.vert_accuracy, self.ignore_flags, self.time_week, self.gps_id, self.fix_type, self.satellites_visible, self.yaw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps_input_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps_rtcm_data_message(MAVLink_message):
    """
    RTCM message for injecting into the onboard GPS (used for DGPS)
    """

    id = MAVLINK_MSG_ID_GPS_RTCM_DATA
    msgname = "GPS_RTCM_DATA"
    fieldnames = ["flags", "len", "data"]
    ordered_fieldnames = ["flags", "len", "data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"len": "bytes"}
    native_format = bytearray(b"<BBB")
    orders = [0, 1, 2]
    lengths = [1, 1, 180]
    array_lengths = [0, 0, 180]
    crc_extra = 35
    unpacker = struct.Struct("<BB180B")
    instance_field = None
    instance_offset = -1

    def __init__(self, flags: int, len: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_gps_rtcm_data_message.id, MAVLink_gps_rtcm_data_message.msgname)
        self._fieldnames = MAVLink_gps_rtcm_data_message.fieldnames
        self._instance_field = MAVLink_gps_rtcm_data_message.instance_field
        self._instance_offset = MAVLink_gps_rtcm_data_message.instance_offset
        self.flags = flags
        self.len = len
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.flags, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109], self.data[110], self.data[111], self.data[112], self.data[113], self.data[114], self.data[115], self.data[116], self.data[117], self.data[118], self.data[119], self.data[120], self.data[121], self.data[122], self.data[123], self.data[124], self.data[125], self.data[126], self.data[127], self.data[128], self.data[129], self.data[130], self.data[131], self.data[132], self.data[133], self.data[134], self.data[135], self.data[136], self.data[137], self.data[138], self.data[139], self.data[140], self.data[141], self.data[142], self.data[143], self.data[144], self.data[145], self.data[146], self.data[147], self.data[148], self.data[149], self.data[150], self.data[151], self.data[152], self.data[153], self.data[154], self.data[155], self.data[156], self.data[157], self.data[158], self.data[159], self.data[160], self.data[161], self.data[162], self.data[163], self.data[164], self.data[165], self.data[166], self.data[167], self.data[168], self.data[169], self.data[170], self.data[171], self.data[172], self.data[173], self.data[174], self.data[175], self.data[176], self.data[177], self.data[178], self.data[179]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps_rtcm_data_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_high_latency_message(MAVLink_message):
    """
    Message appropriate for high latency connections like Iridium
    """

    id = MAVLINK_MSG_ID_HIGH_LATENCY
    msgname = "HIGH_LATENCY"
    fieldnames = ["base_mode", "custom_mode", "landed_state", "roll", "pitch", "heading", "throttle", "heading_sp", "latitude", "longitude", "altitude_amsl", "altitude_sp", "airspeed", "airspeed_sp", "groundspeed", "climb_rate", "gps_nsat", "gps_fix_type", "battery_remaining", "temperature", "temperature_air", "failsafe", "wp_num", "wp_distance"]
    ordered_fieldnames = ["custom_mode", "latitude", "longitude", "roll", "pitch", "heading", "heading_sp", "altitude_amsl", "altitude_sp", "wp_distance", "base_mode", "landed_state", "throttle", "airspeed", "airspeed_sp", "groundspeed", "climb_rate", "gps_nsat", "gps_fix_type", "battery_remaining", "temperature", "temperature_air", "failsafe", "wp_num"]
    fieldtypes = ["uint8_t", "uint32_t", "uint8_t", "int16_t", "int16_t", "uint16_t", "int8_t", "int16_t", "int32_t", "int32_t", "int16_t", "int16_t", "uint8_t", "uint8_t", "uint8_t", "int8_t", "uint8_t", "uint8_t", "uint8_t", "int8_t", "int8_t", "uint8_t", "uint8_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {"base_mode": "bitmask", "custom_mode": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"base_mode": "MAV_MODE_FLAG", "landed_state": "MAV_LANDED_STATE", "gps_fix_type": "GPS_FIX_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"roll": "cdeg", "pitch": "cdeg", "heading": "cdeg", "throttle": "%", "heading_sp": "cdeg", "latitude": "degE7", "longitude": "degE7", "altitude_amsl": "m", "altitude_sp": "m", "airspeed": "m/s", "airspeed_sp": "m/s", "groundspeed": "m/s", "climb_rate": "m/s", "battery_remaining": "%", "temperature": "degC", "temperature_air": "degC", "wp_distance": "m"}
    native_format = bytearray(b"<IiihhHhhhHBBbBBBbBBBbbBB")
    orders = [10, 0, 11, 3, 4, 5, 12, 6, 1, 2, 7, 8, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 9]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 150
    unpacker = struct.Struct("<IiihhHhhhHBBbBBBbBBBbbBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, base_mode: int, custom_mode: int, landed_state: int, roll: int, pitch: int, heading: int, throttle: int, heading_sp: int, latitude: int, longitude: int, altitude_amsl: int, altitude_sp: int, airspeed: int, airspeed_sp: int, groundspeed: int, climb_rate: int, gps_nsat: int, gps_fix_type: int, battery_remaining: int, temperature: int, temperature_air: int, failsafe: int, wp_num: int, wp_distance: int):
        MAVLink_message.__init__(self, MAVLink_high_latency_message.id, MAVLink_high_latency_message.msgname)
        self._fieldnames = MAVLink_high_latency_message.fieldnames
        self._instance_field = MAVLink_high_latency_message.instance_field
        self._instance_offset = MAVLink_high_latency_message.instance_offset
        self.base_mode = base_mode
        self.custom_mode = custom_mode
        self.landed_state = landed_state
        self.roll = roll
        self.pitch = pitch
        self.heading = heading
        self.throttle = throttle
        self.heading_sp = heading_sp
        self.latitude = latitude
        self.longitude = longitude
        self.altitude_amsl = altitude_amsl
        self.altitude_sp = altitude_sp
        self.airspeed = airspeed
        self.airspeed_sp = airspeed_sp
        self.groundspeed = groundspeed
        self.climb_rate = climb_rate
        self.gps_nsat = gps_nsat
        self.gps_fix_type = gps_fix_type
        self.battery_remaining = battery_remaining
        self.temperature = temperature
        self.temperature_air = temperature_air
        self.failsafe = failsafe
        self.wp_num = wp_num
        self.wp_distance = wp_distance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.custom_mode, self.latitude, self.longitude, self.roll, self.pitch, self.heading, self.heading_sp, self.altitude_amsl, self.altitude_sp, self.wp_distance, self.base_mode, self.landed_state, self.throttle, self.airspeed, self.airspeed_sp, self.groundspeed, self.climb_rate, self.gps_nsat, self.gps_fix_type, self.battery_remaining, self.temperature, self.temperature_air, self.failsafe, self.wp_num), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_high_latency_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_high_latency2_message(MAVLink_message):
    """
    Message appropriate for high latency connections like Iridium
    (version 2)
    """

    id = MAVLINK_MSG_ID_HIGH_LATENCY2
    msgname = "HIGH_LATENCY2"
    fieldnames = ["timestamp", "type", "autopilot", "custom_mode", "latitude", "longitude", "altitude", "target_altitude", "heading", "target_heading", "target_distance", "throttle", "airspeed", "airspeed_sp", "groundspeed", "windspeed", "wind_heading", "eph", "epv", "temperature_air", "climb_rate", "battery", "wp_num", "failure_flags", "custom0", "custom1", "custom2"]
    ordered_fieldnames = ["timestamp", "latitude", "longitude", "custom_mode", "altitude", "target_altitude", "target_distance", "wp_num", "failure_flags", "type", "autopilot", "heading", "target_heading", "throttle", "airspeed", "airspeed_sp", "groundspeed", "windspeed", "wind_heading", "eph", "epv", "temperature_air", "climb_rate", "battery", "custom0", "custom1", "custom2"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t", "uint16_t", "int32_t", "int32_t", "int16_t", "int16_t", "uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "int8_t", "int8_t", "int8_t", "uint16_t", "uint16_t", "int8_t", "int8_t", "int8_t"]
    fielddisplays_by_name: Dict[str, str] = {"custom_mode": "bitmask", "failure_flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"type": "MAV_TYPE", "autopilot": "MAV_AUTOPILOT", "failure_flags": "HL_FAILURE_FLAG"}
    fieldunits_by_name: Dict[str, str] = {"timestamp": "ms", "latitude": "degE7", "longitude": "degE7", "altitude": "m", "target_altitude": "m", "heading": "deg/2", "target_heading": "deg/2", "target_distance": "dam", "throttle": "%", "airspeed": "m/s*5", "airspeed_sp": "m/s*5", "groundspeed": "m/s*5", "windspeed": "m/s*5", "wind_heading": "deg/2", "eph": "dm", "epv": "dm", "temperature_air": "degC", "climb_rate": "dm/s", "battery": "%"}
    native_format = bytearray(b"<IiiHhhHHHBBBBBBBBBBBBbbbbbb")
    orders = [0, 9, 10, 3, 1, 2, 4, 5, 11, 12, 6, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 7, 8, 24, 25, 26]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 179
    unpacker = struct.Struct("<IiiHhhHHHBBBBBBBBBBBBbbbbbb")
    instance_field = None
    instance_offset = -1

    def __init__(self, timestamp: int, type: int, autopilot: int, custom_mode: int, latitude: int, longitude: int, altitude: int, target_altitude: int, heading: int, target_heading: int, target_distance: int, throttle: int, airspeed: int, airspeed_sp: int, groundspeed: int, windspeed: int, wind_heading: int, eph: int, epv: int, temperature_air: int, climb_rate: int, battery: int, wp_num: int, failure_flags: int, custom0: int, custom1: int, custom2: int):
        MAVLink_message.__init__(self, MAVLink_high_latency2_message.id, MAVLink_high_latency2_message.msgname)
        self._fieldnames = MAVLink_high_latency2_message.fieldnames
        self._instance_field = MAVLink_high_latency2_message.instance_field
        self._instance_offset = MAVLink_high_latency2_message.instance_offset
        self.timestamp = timestamp
        self.type = type
        self.autopilot = autopilot
        self.custom_mode = custom_mode
        self.latitude = latitude
        self.longitude = longitude
        self.altitude = altitude
        self.target_altitude = target_altitude
        self.heading = heading
        self.target_heading = target_heading
        self.target_distance = target_distance
        self.throttle = throttle
        self.airspeed = airspeed
        self.airspeed_sp = airspeed_sp
        self.groundspeed = groundspeed
        self.windspeed = windspeed
        self.wind_heading = wind_heading
        self.eph = eph
        self.epv = epv
        self.temperature_air = temperature_air
        self.climb_rate = climb_rate
        self.battery = battery
        self.wp_num = wp_num
        self.failure_flags = failure_flags
        self.custom0 = custom0
        self.custom1 = custom1
        self.custom2 = custom2

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.timestamp, self.latitude, self.longitude, self.custom_mode, self.altitude, self.target_altitude, self.target_distance, self.wp_num, self.failure_flags, self.type, self.autopilot, self.heading, self.target_heading, self.throttle, self.airspeed, self.airspeed_sp, self.groundspeed, self.windspeed, self.wind_heading, self.eph, self.epv, self.temperature_air, self.climb_rate, self.battery, self.custom0, self.custom1, self.custom2), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_high_latency2_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_vibration_message(MAVLink_message):
    """
    Vibration levels and accelerometer clipping
    """

    id = MAVLINK_MSG_ID_VIBRATION
    msgname = "VIBRATION"
    fieldnames = ["time_usec", "vibration_x", "vibration_y", "vibration_z", "clipping_0", "clipping_1", "clipping_2"]
    ordered_fieldnames = ["time_usec", "vibration_x", "vibration_y", "vibration_z", "clipping_0", "clipping_1", "clipping_2"]
    fieldtypes = ["uint64_t", "float", "float", "float", "uint32_t", "uint32_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QfffIII")
    orders = [0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 90
    unpacker = struct.Struct("<QfffIII")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, vibration_x: float, vibration_y: float, vibration_z: float, clipping_0: int, clipping_1: int, clipping_2: int):
        MAVLink_message.__init__(self, MAVLink_vibration_message.id, MAVLink_vibration_message.msgname)
        self._fieldnames = MAVLink_vibration_message.fieldnames
        self._instance_field = MAVLink_vibration_message.instance_field
        self._instance_offset = MAVLink_vibration_message.instance_offset
        self.time_usec = time_usec
        self.vibration_x = vibration_x
        self.vibration_y = vibration_y
        self.vibration_z = vibration_z
        self.clipping_0 = clipping_0
        self.clipping_1 = clipping_1
        self.clipping_2 = clipping_2

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.vibration_x, self.vibration_y, self.vibration_z, self.clipping_0, self.clipping_1, self.clipping_2), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_vibration_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_home_position_message(MAVLink_message):
    """
    This message can be requested by sending the
    MAV_CMD_GET_HOME_POSITION command. The position the system will
    return to and land on. The position is set automatically by the
    system during the takeoff in case it was not explicitly set by the
    operator before or after. The global and local positions encode
    the position in the respective coordinate frames, while the q
    parameter encodes the orientation of the surface. Under normal
    conditions it describes the heading and terrain slope, which can
    be used by the aircraft to adjust the approach. The approach 3D
    vector describes the point to which the system should fly in
    normal flight mode and then perform a landing sequence along the
    vector.
    """

    id = MAVLINK_MSG_ID_HOME_POSITION
    msgname = "HOME_POSITION"
    fieldnames = ["latitude", "longitude", "altitude", "x", "y", "z", "q", "approach_x", "approach_y", "approach_z", "time_usec"]
    ordered_fieldnames = ["latitude", "longitude", "altitude", "x", "y", "z", "q", "approach_x", "approach_y", "approach_z", "time_usec"]
    fieldtypes = ["int32_t", "int32_t", "int32_t", "float", "float", "float", "float", "float", "float", "float", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"latitude": "degE7", "longitude": "degE7", "altitude": "mm", "x": "m", "y": "m", "z": "m", "approach_x": "m", "approach_y": "m", "approach_z": "m", "time_usec": "us"}
    native_format = bytearray(b"<iiifffffffQ")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0]
    crc_extra = 104
    unpacker = struct.Struct("<iiifff4ffffQ")
    instance_field = None
    instance_offset = -1

    def __init__(self, latitude: int, longitude: int, altitude: int, x: float, y: float, z: float, q: Sequence[float], approach_x: float, approach_y: float, approach_z: float, time_usec: int = 0):
        MAVLink_message.__init__(self, MAVLink_home_position_message.id, MAVLink_home_position_message.msgname)
        self._fieldnames = MAVLink_home_position_message.fieldnames
        self._instance_field = MAVLink_home_position_message.instance_field
        self._instance_offset = MAVLink_home_position_message.instance_offset
        self.latitude = latitude
        self.longitude = longitude
        self.altitude = altitude
        self.x = x
        self.y = y
        self.z = z
        self.q = q
        self.approach_x = approach_x
        self.approach_y = approach_y
        self.approach_z = approach_z
        self.time_usec = time_usec

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.latitude, self.longitude, self.altitude, self.x, self.y, self.z, self.q[0], self.q[1], self.q[2], self.q[3], self.approach_x, self.approach_y, self.approach_z, self.time_usec), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_home_position_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_set_home_position_message(MAVLink_message):
    """
    The position the system will return to and land on. The position
    is set automatically by the system during the takeoff in case it
    was not explicitly set by the operator before or after. The global
    and local positions encode the position in the respective
    coordinate frames, while the q parameter encodes the orientation
    of the surface. Under normal conditions it describes the heading
    and terrain slope, which can be used by the aircraft to adjust the
    approach. The approach 3D vector describes the point to which the
    system should fly in normal flight mode and then perform a landing
    sequence along the vector.
    """

    id = MAVLINK_MSG_ID_SET_HOME_POSITION
    msgname = "SET_HOME_POSITION"
    fieldnames = ["target_system", "latitude", "longitude", "altitude", "x", "y", "z", "q", "approach_x", "approach_y", "approach_z", "time_usec"]
    ordered_fieldnames = ["latitude", "longitude", "altitude", "x", "y", "z", "q", "approach_x", "approach_y", "approach_z", "target_system", "time_usec"]
    fieldtypes = ["uint8_t", "int32_t", "int32_t", "int32_t", "float", "float", "float", "float", "float", "float", "float", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"latitude": "degE7", "longitude": "degE7", "altitude": "mm", "x": "m", "y": "m", "z": "m", "approach_x": "m", "approach_y": "m", "approach_z": "m", "time_usec": "us"}
    native_format = bytearray(b"<iiifffffffBQ")
    orders = [10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11]
    lengths = [1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0]
    crc_extra = 85
    unpacker = struct.Struct("<iiifff4ffffBQ")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, latitude: int, longitude: int, altitude: int, x: float, y: float, z: float, q: Sequence[float], approach_x: float, approach_y: float, approach_z: float, time_usec: int = 0):
        MAVLink_message.__init__(self, MAVLink_set_home_position_message.id, MAVLink_set_home_position_message.msgname)
        self._fieldnames = MAVLink_set_home_position_message.fieldnames
        self._instance_field = MAVLink_set_home_position_message.instance_field
        self._instance_offset = MAVLink_set_home_position_message.instance_offset
        self.target_system = target_system
        self.latitude = latitude
        self.longitude = longitude
        self.altitude = altitude
        self.x = x
        self.y = y
        self.z = z
        self.q = q
        self.approach_x = approach_x
        self.approach_y = approach_y
        self.approach_z = approach_z
        self.time_usec = time_usec

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.latitude, self.longitude, self.altitude, self.x, self.y, self.z, self.q[0], self.q[1], self.q[2], self.q[3], self.approach_x, self.approach_y, self.approach_z, self.target_system, self.time_usec), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_set_home_position_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_message_interval_message(MAVLink_message):
    """
    The interval between messages for a particular MAVLink message ID.
    This message is sent in response to the MAV_CMD_REQUEST_MESSAGE
    command with param1=244 (this message) and param2=message_id (the
    id of the message for which the interval is required).         It
    may also be sent in response to MAV_CMD_GET_MESSAGE_INTERVAL.
    This interface replaces DATA_STREAM.
    """

    id = MAVLINK_MSG_ID_MESSAGE_INTERVAL
    msgname = "MESSAGE_INTERVAL"
    fieldnames = ["message_id", "interval_us"]
    ordered_fieldnames = ["interval_us", "message_id"]
    fieldtypes = ["uint16_t", "int32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"interval_us": "us"}
    native_format = bytearray(b"<iH")
    orders = [1, 0]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 95
    unpacker = struct.Struct("<iH")
    instance_field = None
    instance_offset = -1

    def __init__(self, message_id: int, interval_us: int):
        MAVLink_message.__init__(self, MAVLink_message_interval_message.id, MAVLink_message_interval_message.msgname)
        self._fieldnames = MAVLink_message_interval_message.fieldnames
        self._instance_field = MAVLink_message_interval_message.instance_field
        self._instance_offset = MAVLink_message_interval_message.instance_offset
        self.message_id = message_id
        self.interval_us = interval_us

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.interval_us, self.message_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_message_interval_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_extended_sys_state_message(MAVLink_message):
    """
    Provides state for additional features
    """

    id = MAVLINK_MSG_ID_EXTENDED_SYS_STATE
    msgname = "EXTENDED_SYS_STATE"
    fieldnames = ["vtol_state", "landed_state"]
    ordered_fieldnames = ["vtol_state", "landed_state"]
    fieldtypes = ["uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"vtol_state": "MAV_VTOL_STATE", "landed_state": "MAV_LANDED_STATE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BB")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 130
    unpacker = struct.Struct("<BB")
    instance_field = None
    instance_offset = -1

    def __init__(self, vtol_state: int, landed_state: int):
        MAVLink_message.__init__(self, MAVLink_extended_sys_state_message.id, MAVLink_extended_sys_state_message.msgname)
        self._fieldnames = MAVLink_extended_sys_state_message.fieldnames
        self._instance_field = MAVLink_extended_sys_state_message.instance_field
        self._instance_offset = MAVLink_extended_sys_state_message.instance_offset
        self.vtol_state = vtol_state
        self.landed_state = landed_state

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.vtol_state, self.landed_state), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_extended_sys_state_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_adsb_vehicle_message(MAVLink_message):
    """
    The location and information of an ADSB vehicle
    """

    id = MAVLINK_MSG_ID_ADSB_VEHICLE
    msgname = "ADSB_VEHICLE"
    fieldnames = ["ICAO_address", "lat", "lon", "altitude_type", "altitude", "heading", "hor_velocity", "ver_velocity", "callsign", "emitter_type", "tslc", "flags", "squawk"]
    ordered_fieldnames = ["ICAO_address", "lat", "lon", "altitude", "heading", "hor_velocity", "ver_velocity", "flags", "squawk", "altitude_type", "callsign", "emitter_type", "tslc"]
    fieldtypes = ["uint32_t", "int32_t", "int32_t", "uint8_t", "int32_t", "uint16_t", "uint16_t", "int16_t", "char", "uint8_t", "uint8_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"altitude_type": "ADSB_ALTITUDE_TYPE", "emitter_type": "ADSB_EMITTER_TYPE", "flags": "ADSB_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"lat": "degE7", "lon": "degE7", "altitude": "mm", "heading": "cdeg", "hor_velocity": "cm/s", "ver_velocity": "cm/s", "tslc": "s"}
    native_format = bytearray(b"<IiiiHHhHHBcBB")
    orders = [0, 1, 2, 9, 3, 4, 5, 6, 10, 11, 12, 7, 8]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0]
    crc_extra = 184
    unpacker = struct.Struct("<IiiiHHhHHB9sBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, ICAO_address: int, lat: int, lon: int, altitude_type: int, altitude: int, heading: int, hor_velocity: int, ver_velocity: int, callsign: bytes, emitter_type: int, tslc: int, flags: int, squawk: int):
        MAVLink_message.__init__(self, MAVLink_adsb_vehicle_message.id, MAVLink_adsb_vehicle_message.msgname)
        self._fieldnames = MAVLink_adsb_vehicle_message.fieldnames
        self._instance_field = MAVLink_adsb_vehicle_message.instance_field
        self._instance_offset = MAVLink_adsb_vehicle_message.instance_offset
        self.ICAO_address = ICAO_address
        self.lat = lat
        self.lon = lon
        self.altitude_type = altitude_type
        self.altitude = altitude
        self.heading = heading
        self.hor_velocity = hor_velocity
        self.ver_velocity = ver_velocity
        self._callsign_raw = callsign
        self.callsign = callsign.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.emitter_type = emitter_type
        self.tslc = tslc
        self.flags = flags
        self.squawk = squawk

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.ICAO_address, self.lat, self.lon, self.altitude, self.heading, self.hor_velocity, self.ver_velocity, self.flags, self.squawk, self.altitude_type, self._callsign_raw, self.emitter_type, self.tslc), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_adsb_vehicle_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_collision_message(MAVLink_message):
    """
    Information about a potential collision
    """

    id = MAVLINK_MSG_ID_COLLISION
    msgname = "COLLISION"
    fieldnames = ["src", "id", "action", "threat_level", "time_to_minimum_delta", "altitude_minimum_delta", "horizontal_minimum_delta"]
    ordered_fieldnames = ["id", "time_to_minimum_delta", "altitude_minimum_delta", "horizontal_minimum_delta", "src", "action", "threat_level"]
    fieldtypes = ["uint8_t", "uint32_t", "uint8_t", "uint8_t", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"src": "MAV_COLLISION_SRC", "action": "MAV_COLLISION_ACTION", "threat_level": "MAV_COLLISION_THREAT_LEVEL"}
    fieldunits_by_name: Dict[str, str] = {"time_to_minimum_delta": "s", "altitude_minimum_delta": "m", "horizontal_minimum_delta": "m"}
    native_format = bytearray(b"<IfffBBB")
    orders = [4, 0, 5, 6, 1, 2, 3]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 81
    unpacker = struct.Struct("<IfffBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, src: int, id: int, action: int, threat_level: int, time_to_minimum_delta: float, altitude_minimum_delta: float, horizontal_minimum_delta: float):
        MAVLink_message.__init__(self, MAVLink_collision_message.id, MAVLink_collision_message.msgname)
        self._fieldnames = MAVLink_collision_message.fieldnames
        self._instance_field = MAVLink_collision_message.instance_field
        self._instance_offset = MAVLink_collision_message.instance_offset
        self.src = src
        self.id = id
        self.action = action
        self.threat_level = threat_level
        self.time_to_minimum_delta = time_to_minimum_delta
        self.altitude_minimum_delta = altitude_minimum_delta
        self.horizontal_minimum_delta = horizontal_minimum_delta

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.id, self.time_to_minimum_delta, self.altitude_minimum_delta, self.horizontal_minimum_delta, self.src, self.action, self.threat_level), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_collision_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_v2_extension_message(MAVLink_message):
    """
    Message implementing parts of the V2 payload specs in V1 frames
    for transitional support.
    """

    id = MAVLINK_MSG_ID_V2_EXTENSION
    msgname = "V2_EXTENSION"
    fieldnames = ["target_network", "target_system", "target_component", "message_type", "payload"]
    ordered_fieldnames = ["message_type", "target_network", "target_system", "target_component", "payload"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBBBB")
    orders = [1, 2, 3, 0, 4]
    lengths = [1, 1, 1, 1, 249]
    array_lengths = [0, 0, 0, 0, 249]
    crc_extra = 8
    unpacker = struct.Struct("<HBBB249B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_network: int, target_system: int, target_component: int, message_type: int, payload: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_v2_extension_message.id, MAVLink_v2_extension_message.msgname)
        self._fieldnames = MAVLink_v2_extension_message.fieldnames
        self._instance_field = MAVLink_v2_extension_message.instance_field
        self._instance_offset = MAVLink_v2_extension_message.instance_offset
        self.target_network = target_network
        self.target_system = target_system
        self.target_component = target_component
        self.message_type = message_type
        self.payload = payload

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.message_type, self.target_network, self.target_system, self.target_component, self.payload[0], self.payload[1], self.payload[2], self.payload[3], self.payload[4], self.payload[5], self.payload[6], self.payload[7], self.payload[8], self.payload[9], self.payload[10], self.payload[11], self.payload[12], self.payload[13], self.payload[14], self.payload[15], self.payload[16], self.payload[17], self.payload[18], self.payload[19], self.payload[20], self.payload[21], self.payload[22], self.payload[23], self.payload[24], self.payload[25], self.payload[26], self.payload[27], self.payload[28], self.payload[29], self.payload[30], self.payload[31], self.payload[32], self.payload[33], self.payload[34], self.payload[35], self.payload[36], self.payload[37], self.payload[38], self.payload[39], self.payload[40], self.payload[41], self.payload[42], self.payload[43], self.payload[44], self.payload[45], self.payload[46], self.payload[47], self.payload[48], self.payload[49], self.payload[50], self.payload[51], self.payload[52], self.payload[53], self.payload[54], self.payload[55], self.payload[56], self.payload[57], self.payload[58], self.payload[59], self.payload[60], self.payload[61], self.payload[62], self.payload[63], self.payload[64], self.payload[65], self.payload[66], self.payload[67], self.payload[68], self.payload[69], self.payload[70], self.payload[71], self.payload[72], self.payload[73], self.payload[74], self.payload[75], self.payload[76], self.payload[77], self.payload[78], self.payload[79], self.payload[80], self.payload[81], self.payload[82], self.payload[83], self.payload[84], self.payload[85], self.payload[86], self.payload[87], self.payload[88], self.payload[89], self.payload[90], self.payload[91], self.payload[92], self.payload[93], self.payload[94], self.payload[95], self.payload[96], self.payload[97], self.payload[98], self.payload[99], self.payload[100], self.payload[101], self.payload[102], self.payload[103], self.payload[104], self.payload[105], self.payload[106], self.payload[107], self.payload[108], self.payload[109], self.payload[110], self.payload[111], self.payload[112], self.payload[113], self.payload[114], self.payload[115], self.payload[116], self.payload[117], self.payload[118], self.payload[119], self.payload[120], self.payload[121], self.payload[122], self.payload[123], self.payload[124], self.payload[125], self.payload[126], self.payload[127], self.payload[128], self.payload[129], self.payload[130], self.payload[131], self.payload[132], self.payload[133], self.payload[134], self.payload[135], self.payload[136], self.payload[137], self.payload[138], self.payload[139], self.payload[140], self.payload[141], self.payload[142], self.payload[143], self.payload[144], self.payload[145], self.payload[146], self.payload[147], self.payload[148], self.payload[149], self.payload[150], self.payload[151], self.payload[152], self.payload[153], self.payload[154], self.payload[155], self.payload[156], self.payload[157], self.payload[158], self.payload[159], self.payload[160], self.payload[161], self.payload[162], self.payload[163], self.payload[164], self.payload[165], self.payload[166], self.payload[167], self.payload[168], self.payload[169], self.payload[170], self.payload[171], self.payload[172], self.payload[173], self.payload[174], self.payload[175], self.payload[176], self.payload[177], self.payload[178], self.payload[179], self.payload[180], self.payload[181], self.payload[182], self.payload[183], self.payload[184], self.payload[185], self.payload[186], self.payload[187], self.payload[188], self.payload[189], self.payload[190], self.payload[191], self.payload[192], self.payload[193], self.payload[194], self.payload[195], self.payload[196], self.payload[197], self.payload[198], self.payload[199], self.payload[200], self.payload[201], self.payload[202], self.payload[203], self.payload[204], self.payload[205], self.payload[206], self.payload[207], self.payload[208], self.payload[209], self.payload[210], self.payload[211], self.payload[212], self.payload[213], self.payload[214], self.payload[215], self.payload[216], self.payload[217], self.payload[218], self.payload[219], self.payload[220], self.payload[221], self.payload[222], self.payload[223], self.payload[224], self.payload[225], self.payload[226], self.payload[227], self.payload[228], self.payload[229], self.payload[230], self.payload[231], self.payload[232], self.payload[233], self.payload[234], self.payload[235], self.payload[236], self.payload[237], self.payload[238], self.payload[239], self.payload[240], self.payload[241], self.payload[242], self.payload[243], self.payload[244], self.payload[245], self.payload[246], self.payload[247], self.payload[248]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_v2_extension_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_memory_vect_message(MAVLink_message):
    """
    Send raw controller memory. The use of this message is discouraged
    for normal packets, but a quite efficient way for testing new
    messages and getting experimental debug output.
    """

    id = MAVLINK_MSG_ID_MEMORY_VECT
    msgname = "MEMORY_VECT"
    fieldnames = ["address", "ver", "type", "value"]
    ordered_fieldnames = ["address", "ver", "type", "value"]
    fieldtypes = ["uint16_t", "uint8_t", "uint8_t", "int8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBBb")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 32]
    array_lengths = [0, 0, 0, 32]
    crc_extra = 204
    unpacker = struct.Struct("<HBB32b")
    instance_field = None
    instance_offset = -1

    def __init__(self, address: int, ver: int, type: int, value: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_memory_vect_message.id, MAVLink_memory_vect_message.msgname)
        self._fieldnames = MAVLink_memory_vect_message.fieldnames
        self._instance_field = MAVLink_memory_vect_message.instance_field
        self._instance_offset = MAVLink_memory_vect_message.instance_offset
        self.address = address
        self.ver = ver
        self.type = type
        self.value = value

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.address, self.ver, self.type, self.value[0], self.value[1], self.value[2], self.value[3], self.value[4], self.value[5], self.value[6], self.value[7], self.value[8], self.value[9], self.value[10], self.value[11], self.value[12], self.value[13], self.value[14], self.value[15], self.value[16], self.value[17], self.value[18], self.value[19], self.value[20], self.value[21], self.value[22], self.value[23], self.value[24], self.value[25], self.value[26], self.value[27], self.value[28], self.value[29], self.value[30], self.value[31]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_memory_vect_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_debug_vect_message(MAVLink_message):
    """
    To debug something using a named 3D vector.
    """

    id = MAVLINK_MSG_ID_DEBUG_VECT
    msgname = "DEBUG_VECT"
    fieldnames = ["name", "time_usec", "x", "y", "z"]
    ordered_fieldnames = ["time_usec", "x", "y", "z", "name"]
    fieldtypes = ["char", "uint64_t", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<Qfffc")
    orders = [4, 0, 1, 2, 3]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 10]
    crc_extra = 49
    unpacker = struct.Struct("<Qfff10s")
    instance_field = "name"
    instance_offset = 20

    def __init__(self, name: bytes, time_usec: int, x: float, y: float, z: float):
        MAVLink_message.__init__(self, MAVLink_debug_vect_message.id, MAVLink_debug_vect_message.msgname)
        self._fieldnames = MAVLink_debug_vect_message.fieldnames
        self._instance_field = MAVLink_debug_vect_message.instance_field
        self._instance_offset = MAVLink_debug_vect_message.instance_offset
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.time_usec = time_usec
        self.x = x
        self.y = y
        self.z = z

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.x, self.y, self.z, self._name_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_debug_vect_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_named_value_float_message(MAVLink_message):
    """
    Send a key-value pair as float. The use of this message is
    discouraged for normal packets, but a quite efficient way for
    testing new messages and getting experimental debug output.
    """

    id = MAVLINK_MSG_ID_NAMED_VALUE_FLOAT
    msgname = "NAMED_VALUE_FLOAT"
    fieldnames = ["time_boot_ms", "name", "value"]
    ordered_fieldnames = ["time_boot_ms", "value", "name"]
    fieldtypes = ["uint32_t", "char", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<Ifc")
    orders = [0, 2, 1]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 10]
    crc_extra = 170
    unpacker = struct.Struct("<If10s")
    instance_field = "name"
    instance_offset = 8

    def __init__(self, time_boot_ms: int, name: bytes, value: float):
        MAVLink_message.__init__(self, MAVLink_named_value_float_message.id, MAVLink_named_value_float_message.msgname)
        self._fieldnames = MAVLink_named_value_float_message.fieldnames
        self._instance_field = MAVLink_named_value_float_message.instance_field
        self._instance_offset = MAVLink_named_value_float_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.value = value

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.value, self._name_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_named_value_float_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_named_value_int_message(MAVLink_message):
    """
    Send a key-value pair as integer. The use of this message is
    discouraged for normal packets, but a quite efficient way for
    testing new messages and getting experimental debug output.
    """

    id = MAVLINK_MSG_ID_NAMED_VALUE_INT
    msgname = "NAMED_VALUE_INT"
    fieldnames = ["time_boot_ms", "name", "value"]
    ordered_fieldnames = ["time_boot_ms", "value", "name"]
    fieldtypes = ["uint32_t", "char", "int32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<Iic")
    orders = [0, 2, 1]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 10]
    crc_extra = 44
    unpacker = struct.Struct("<Ii10s")
    instance_field = "name"
    instance_offset = 8

    def __init__(self, time_boot_ms: int, name: bytes, value: int):
        MAVLink_message.__init__(self, MAVLink_named_value_int_message.id, MAVLink_named_value_int_message.msgname)
        self._fieldnames = MAVLink_named_value_int_message.fieldnames
        self._instance_field = MAVLink_named_value_int_message.instance_field
        self._instance_offset = MAVLink_named_value_int_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.value = value

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.value, self._name_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_named_value_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_statustext_message(MAVLink_message):
    """
    Status text message. These messages are printed in yellow in the
    COMM console of QGroundControl. WARNING: They consume quite some
    bandwidth, so use only for important status and error messages. If
    implemented wisely, these messages are buffered on the MCU and
    sent only at a limited rate (e.g. 10 Hz).
    """

    id = MAVLINK_MSG_ID_STATUSTEXT
    msgname = "STATUSTEXT"
    fieldnames = ["severity", "text", "id", "chunk_seq"]
    ordered_fieldnames = ["severity", "text", "id", "chunk_seq"]
    fieldtypes = ["uint8_t", "char", "uint16_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"severity": "MAV_SEVERITY"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BcHB")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 50, 0, 0]
    crc_extra = 83
    unpacker = struct.Struct("<B50sHB")
    instance_field = None
    instance_offset = -1

    def __init__(self, severity: int, text: bytes, id: int = 0, chunk_seq: int = 0):
        MAVLink_message.__init__(self, MAVLink_statustext_message.id, MAVLink_statustext_message.msgname)
        self._fieldnames = MAVLink_statustext_message.fieldnames
        self._instance_field = MAVLink_statustext_message.instance_field
        self._instance_offset = MAVLink_statustext_message.instance_offset
        self.severity = severity
        self._text_raw = text
        self.text = text.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.id = id
        self.chunk_seq = chunk_seq

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.severity, self._text_raw, self.id, self.chunk_seq), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_statustext_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_debug_message(MAVLink_message):
    """
    Send a debug value. The index is used to discriminate between
    values. These values show up in the plot of QGroundControl as
    DEBUG N.
    """

    id = MAVLINK_MSG_ID_DEBUG
    msgname = "DEBUG"
    fieldnames = ["time_boot_ms", "ind", "value"]
    ordered_fieldnames = ["time_boot_ms", "value", "ind"]
    fieldtypes = ["uint32_t", "uint8_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<IfB")
    orders = [0, 2, 1]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 46
    unpacker = struct.Struct("<IfB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, ind: int, value: float):
        MAVLink_message.__init__(self, MAVLink_debug_message.id, MAVLink_debug_message.msgname)
        self._fieldnames = MAVLink_debug_message.fieldnames
        self._instance_field = MAVLink_debug_message.instance_field
        self._instance_offset = MAVLink_debug_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.ind = ind
        self.value = value

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.value, self.ind), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_debug_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_setup_signing_message(MAVLink_message):
    """
    Setup a MAVLink2 signing key. If called with secret_key of all
    zero and zero initial_timestamp will disable signing
    """

    id = MAVLINK_MSG_ID_SETUP_SIGNING
    msgname = "SETUP_SIGNING"
    fieldnames = ["target_system", "target_component", "secret_key", "initial_timestamp"]
    ordered_fieldnames = ["initial_timestamp", "target_system", "target_component", "secret_key"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<QBBB")
    orders = [1, 2, 3, 0]
    lengths = [1, 1, 1, 32]
    array_lengths = [0, 0, 0, 32]
    crc_extra = 71
    unpacker = struct.Struct("<QBB32B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, secret_key: Sequence[int], initial_timestamp: int):
        MAVLink_message.__init__(self, MAVLink_setup_signing_message.id, MAVLink_setup_signing_message.msgname)
        self._fieldnames = MAVLink_setup_signing_message.fieldnames
        self._instance_field = MAVLink_setup_signing_message.instance_field
        self._instance_offset = MAVLink_setup_signing_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.secret_key = secret_key
        self.initial_timestamp = initial_timestamp

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.initial_timestamp, self.target_system, self.target_component, self.secret_key[0], self.secret_key[1], self.secret_key[2], self.secret_key[3], self.secret_key[4], self.secret_key[5], self.secret_key[6], self.secret_key[7], self.secret_key[8], self.secret_key[9], self.secret_key[10], self.secret_key[11], self.secret_key[12], self.secret_key[13], self.secret_key[14], self.secret_key[15], self.secret_key[16], self.secret_key[17], self.secret_key[18], self.secret_key[19], self.secret_key[20], self.secret_key[21], self.secret_key[22], self.secret_key[23], self.secret_key[24], self.secret_key[25], self.secret_key[26], self.secret_key[27], self.secret_key[28], self.secret_key[29], self.secret_key[30], self.secret_key[31]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_setup_signing_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_button_change_message(MAVLink_message):
    """
    Report button state change.
    """

    id = MAVLINK_MSG_ID_BUTTON_CHANGE
    msgname = "BUTTON_CHANGE"
    fieldnames = ["time_boot_ms", "last_change_ms", "state"]
    ordered_fieldnames = ["time_boot_ms", "last_change_ms", "state"]
    fieldtypes = ["uint32_t", "uint32_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"state": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "last_change_ms": "ms"}
    native_format = bytearray(b"<IIB")
    orders = [0, 1, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 131
    unpacker = struct.Struct("<IIB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, last_change_ms: int, state: int):
        MAVLink_message.__init__(self, MAVLink_button_change_message.id, MAVLink_button_change_message.msgname)
        self._fieldnames = MAVLink_button_change_message.fieldnames
        self._instance_field = MAVLink_button_change_message.instance_field
        self._instance_offset = MAVLink_button_change_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.last_change_ms = last_change_ms
        self.state = state

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.last_change_ms, self.state), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_button_change_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_play_tune_message(MAVLink_message):
    """
    Control vehicle tone generation (buzzer).
    """

    id = MAVLINK_MSG_ID_PLAY_TUNE
    msgname = "PLAY_TUNE"
    fieldnames = ["target_system", "target_component", "tune", "tune2"]
    ordered_fieldnames = ["target_system", "target_component", "tune", "tune2"]
    fieldtypes = ["uint8_t", "uint8_t", "char", "char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBcc")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 30, 200]
    crc_extra = 187
    unpacker = struct.Struct("<BB30s200s")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, tune: bytes, tune2: bytes = b""):
        MAVLink_message.__init__(self, MAVLink_play_tune_message.id, MAVLink_play_tune_message.msgname)
        self._fieldnames = MAVLink_play_tune_message.fieldnames
        self._instance_field = MAVLink_play_tune_message.instance_field
        self._instance_offset = MAVLink_play_tune_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self._tune_raw = tune
        self.tune = tune.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._tune2_raw = tune2
        self.tune2 = tune2.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self._tune_raw, self._tune2_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_play_tune_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_information_message(MAVLink_message):
    """
    Information about a camera. Can be requested with a
    MAV_CMD_REQUEST_MESSAGE command.
    """

    id = MAVLINK_MSG_ID_CAMERA_INFORMATION
    msgname = "CAMERA_INFORMATION"
    fieldnames = ["time_boot_ms", "vendor_name", "model_name", "firmware_version", "focal_length", "sensor_size_h", "sensor_size_v", "resolution_h", "resolution_v", "lens_id", "flags", "cam_definition_version", "cam_definition_uri", "gimbal_device_id"]
    ordered_fieldnames = ["time_boot_ms", "firmware_version", "focal_length", "sensor_size_h", "sensor_size_v", "flags", "resolution_h", "resolution_v", "cam_definition_version", "vendor_name", "model_name", "lens_id", "cam_definition_uri", "gimbal_device_id"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t", "uint32_t", "float", "float", "float", "uint16_t", "uint16_t", "uint8_t", "uint32_t", "uint16_t", "char", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "CAMERA_CAP_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "focal_length": "mm", "sensor_size_h": "mm", "sensor_size_v": "mm", "resolution_h": "pix", "resolution_v": "pix"}
    native_format = bytearray(b"<IIfffIHHHBBBcB")
    orders = [0, 9, 10, 1, 2, 3, 4, 6, 7, 11, 5, 8, 12, 13]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 32, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0, 140, 0]
    crc_extra = 92
    unpacker = struct.Struct("<IIfffIHHH32B32BB140sB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, vendor_name: Sequence[int], model_name: Sequence[int], firmware_version: int, focal_length: float, sensor_size_h: float, sensor_size_v: float, resolution_h: int, resolution_v: int, lens_id: int, flags: int, cam_definition_version: int, cam_definition_uri: bytes, gimbal_device_id: int = 0):
        MAVLink_message.__init__(self, MAVLink_camera_information_message.id, MAVLink_camera_information_message.msgname)
        self._fieldnames = MAVLink_camera_information_message.fieldnames
        self._instance_field = MAVLink_camera_information_message.instance_field
        self._instance_offset = MAVLink_camera_information_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.vendor_name = vendor_name
        self.model_name = model_name
        self.firmware_version = firmware_version
        self.focal_length = focal_length
        self.sensor_size_h = sensor_size_h
        self.sensor_size_v = sensor_size_v
        self.resolution_h = resolution_h
        self.resolution_v = resolution_v
        self.lens_id = lens_id
        self.flags = flags
        self.cam_definition_version = cam_definition_version
        self._cam_definition_uri_raw = cam_definition_uri
        self.cam_definition_uri = cam_definition_uri.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.gimbal_device_id = gimbal_device_id

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.firmware_version, self.focal_length, self.sensor_size_h, self.sensor_size_v, self.flags, self.resolution_h, self.resolution_v, self.cam_definition_version, self.vendor_name[0], self.vendor_name[1], self.vendor_name[2], self.vendor_name[3], self.vendor_name[4], self.vendor_name[5], self.vendor_name[6], self.vendor_name[7], self.vendor_name[8], self.vendor_name[9], self.vendor_name[10], self.vendor_name[11], self.vendor_name[12], self.vendor_name[13], self.vendor_name[14], self.vendor_name[15], self.vendor_name[16], self.vendor_name[17], self.vendor_name[18], self.vendor_name[19], self.vendor_name[20], self.vendor_name[21], self.vendor_name[22], self.vendor_name[23], self.vendor_name[24], self.vendor_name[25], self.vendor_name[26], self.vendor_name[27], self.vendor_name[28], self.vendor_name[29], self.vendor_name[30], self.vendor_name[31], self.model_name[0], self.model_name[1], self.model_name[2], self.model_name[3], self.model_name[4], self.model_name[5], self.model_name[6], self.model_name[7], self.model_name[8], self.model_name[9], self.model_name[10], self.model_name[11], self.model_name[12], self.model_name[13], self.model_name[14], self.model_name[15], self.model_name[16], self.model_name[17], self.model_name[18], self.model_name[19], self.model_name[20], self.model_name[21], self.model_name[22], self.model_name[23], self.model_name[24], self.model_name[25], self.model_name[26], self.model_name[27], self.model_name[28], self.model_name[29], self.model_name[30], self.model_name[31], self.lens_id, self._cam_definition_uri_raw, self.gimbal_device_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_information_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_settings_message(MAVLink_message):
    """
    Settings of a camera. Can be requested with a
    MAV_CMD_REQUEST_MESSAGE command.
    """

    id = MAVLINK_MSG_ID_CAMERA_SETTINGS
    msgname = "CAMERA_SETTINGS"
    fieldnames = ["time_boot_ms", "mode_id", "zoomLevel", "focusLevel"]
    ordered_fieldnames = ["time_boot_ms", "mode_id", "zoomLevel", "focusLevel"]
    fieldtypes = ["uint32_t", "uint8_t", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"mode_id": "CAMERA_MODE"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<IBff")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 146
    unpacker = struct.Struct("<IBff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, mode_id: int, zoomLevel: float = 0, focusLevel: float = 0):
        MAVLink_message.__init__(self, MAVLink_camera_settings_message.id, MAVLink_camera_settings_message.msgname)
        self._fieldnames = MAVLink_camera_settings_message.fieldnames
        self._instance_field = MAVLink_camera_settings_message.instance_field
        self._instance_offset = MAVLink_camera_settings_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.mode_id = mode_id
        self.zoomLevel = zoomLevel
        self.focusLevel = focusLevel

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.mode_id, self.zoomLevel, self.focusLevel), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_settings_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_storage_information_message(MAVLink_message):
    """
    Information about a storage medium. This message is sent in
    response to a request with MAV_CMD_REQUEST_MESSAGE and whenever
    the status of the storage changes (STORAGE_STATUS). Use
    MAV_CMD_REQUEST_MESSAGE.param2 to indicate the index/id of
    requested storage: 0 for all, 1 for first, 2 for second, etc.
    """

    id = MAVLINK_MSG_ID_STORAGE_INFORMATION
    msgname = "STORAGE_INFORMATION"
    fieldnames = ["time_boot_ms", "storage_id", "storage_count", "status", "total_capacity", "used_capacity", "available_capacity", "read_speed", "write_speed", "type", "name"]
    ordered_fieldnames = ["time_boot_ms", "total_capacity", "used_capacity", "available_capacity", "read_speed", "write_speed", "storage_id", "storage_count", "status", "type", "name"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "uint8_t", "char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"status": "STORAGE_STATUS", "type": "STORAGE_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "total_capacity": "MiB", "used_capacity": "MiB", "available_capacity": "MiB", "read_speed": "MiB/s", "write_speed": "MiB/s"}
    native_format = bytearray(b"<IfffffBBBBc")
    orders = [0, 6, 7, 8, 1, 2, 3, 4, 5, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32]
    crc_extra = 179
    unpacker = struct.Struct("<IfffffBBBB32s")
    instance_field = "storage_id"
    instance_offset = 24

    def __init__(self, time_boot_ms: int, storage_id: int, storage_count: int, status: int, total_capacity: float, used_capacity: float, available_capacity: float, read_speed: float, write_speed: float, type: int = 0, name: bytes = b""):
        MAVLink_message.__init__(self, MAVLink_storage_information_message.id, MAVLink_storage_information_message.msgname)
        self._fieldnames = MAVLink_storage_information_message.fieldnames
        self._instance_field = MAVLink_storage_information_message.instance_field
        self._instance_offset = MAVLink_storage_information_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.storage_id = storage_id
        self.storage_count = storage_count
        self.status = status
        self.total_capacity = total_capacity
        self.used_capacity = used_capacity
        self.available_capacity = available_capacity
        self.read_speed = read_speed
        self.write_speed = write_speed
        self.type = type
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.total_capacity, self.used_capacity, self.available_capacity, self.read_speed, self.write_speed, self.storage_id, self.storage_count, self.status, self.type, self._name_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_storage_information_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_capture_status_message(MAVLink_message):
    """
    Information about the status of a capture. Can be requested with a
    MAV_CMD_REQUEST_MESSAGE command.
    """

    id = MAVLINK_MSG_ID_CAMERA_CAPTURE_STATUS
    msgname = "CAMERA_CAPTURE_STATUS"
    fieldnames = ["time_boot_ms", "image_status", "video_status", "image_interval", "recording_time_ms", "available_capacity", "image_count"]
    ordered_fieldnames = ["time_boot_ms", "image_interval", "recording_time_ms", "available_capacity", "image_status", "video_status", "image_count"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t", "float", "uint32_t", "float", "int32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "image_interval": "s", "recording_time_ms": "ms", "available_capacity": "MiB"}
    native_format = bytearray(b"<IfIfBBi")
    orders = [0, 4, 5, 1, 2, 3, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 12
    unpacker = struct.Struct("<IfIfBBi")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, image_status: int, video_status: int, image_interval: float, recording_time_ms: int, available_capacity: float, image_count: int = 0):
        MAVLink_message.__init__(self, MAVLink_camera_capture_status_message.id, MAVLink_camera_capture_status_message.msgname)
        self._fieldnames = MAVLink_camera_capture_status_message.fieldnames
        self._instance_field = MAVLink_camera_capture_status_message.instance_field
        self._instance_offset = MAVLink_camera_capture_status_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.image_status = image_status
        self.video_status = video_status
        self.image_interval = image_interval
        self.recording_time_ms = recording_time_ms
        self.available_capacity = available_capacity
        self.image_count = image_count

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.image_interval, self.recording_time_ms, self.available_capacity, self.image_status, self.video_status, self.image_count), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_capture_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_image_captured_message(MAVLink_message):
    """
    Information about a captured image. This is emitted every time a
    message is captured. It may be re-requested using
    MAV_CMD_REQUEST_MESSAGE, using param2 to indicate the sequence
    number for the missing image.
    """

    id = MAVLINK_MSG_ID_CAMERA_IMAGE_CAPTURED
    msgname = "CAMERA_IMAGE_CAPTURED"
    fieldnames = ["time_boot_ms", "time_utc", "camera_id", "lat", "lon", "alt", "relative_alt", "q", "image_index", "capture_result", "file_url"]
    ordered_fieldnames = ["time_utc", "time_boot_ms", "lat", "lon", "alt", "relative_alt", "q", "image_index", "camera_id", "capture_result", "file_url"]
    fieldtypes = ["uint32_t", "uint64_t", "uint8_t", "int32_t", "int32_t", "int32_t", "int32_t", "float", "int32_t", "int8_t", "char"]
    fielddisplays_by_name: Dict[str, str] = {"capture_result": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"capture_result": "MAV_BOOL"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "time_utc": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "relative_alt": "mm"}
    native_format = bytearray(b"<QIiiiifiBbc")
    orders = [1, 0, 8, 2, 3, 4, 5, 6, 7, 9, 10]
    lengths = [1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 205]
    crc_extra = 133
    unpacker = struct.Struct("<QIiiii4fiBb205s")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, time_utc: int, camera_id: int, lat: int, lon: int, alt: int, relative_alt: int, q: Sequence[float], image_index: int, capture_result: int, file_url: bytes):
        MAVLink_message.__init__(self, MAVLink_camera_image_captured_message.id, MAVLink_camera_image_captured_message.msgname)
        self._fieldnames = MAVLink_camera_image_captured_message.fieldnames
        self._instance_field = MAVLink_camera_image_captured_message.instance_field
        self._instance_offset = MAVLink_camera_image_captured_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.time_utc = time_utc
        self.camera_id = camera_id
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.relative_alt = relative_alt
        self.q = q
        self.image_index = image_index
        self.capture_result = capture_result
        self._file_url_raw = file_url
        self.file_url = file_url.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_utc, self.time_boot_ms, self.lat, self.lon, self.alt, self.relative_alt, self.q[0], self.q[1], self.q[2], self.q[3], self.image_index, self.camera_id, self.capture_result, self._file_url_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_image_captured_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_flight_information_message(MAVLink_message):
    """
    Information about flight since last arming.
    """

    id = MAVLINK_MSG_ID_FLIGHT_INFORMATION
    msgname = "FLIGHT_INFORMATION"
    fieldnames = ["time_boot_ms", "arming_time_utc", "takeoff_time_utc", "flight_uuid"]
    ordered_fieldnames = ["arming_time_utc", "takeoff_time_utc", "flight_uuid", "time_boot_ms"]
    fieldtypes = ["uint32_t", "uint64_t", "uint64_t", "uint64_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "arming_time_utc": "us", "takeoff_time_utc": "us"}
    native_format = bytearray(b"<QQQI")
    orders = [3, 0, 1, 2]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0]
    crc_extra = 49
    unpacker = struct.Struct("<QQQI")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, arming_time_utc: int, takeoff_time_utc: int, flight_uuid: int):
        MAVLink_message.__init__(self, MAVLink_flight_information_message.id, MAVLink_flight_information_message.msgname)
        self._fieldnames = MAVLink_flight_information_message.fieldnames
        self._instance_field = MAVLink_flight_information_message.instance_field
        self._instance_offset = MAVLink_flight_information_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.arming_time_utc = arming_time_utc
        self.takeoff_time_utc = takeoff_time_utc
        self.flight_uuid = flight_uuid

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.arming_time_utc, self.takeoff_time_utc, self.flight_uuid, self.time_boot_ms), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_flight_information_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mount_orientation_message(MAVLink_message):
    """
    Orientation of a mount
    """

    id = MAVLINK_MSG_ID_MOUNT_ORIENTATION
    msgname = "MOUNT_ORIENTATION"
    fieldnames = ["time_boot_ms", "roll", "pitch", "yaw", "yaw_absolute"]
    ordered_fieldnames = ["time_boot_ms", "roll", "pitch", "yaw", "yaw_absolute"]
    fieldtypes = ["uint32_t", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "roll": "deg", "pitch": "deg", "yaw": "deg", "yaw_absolute": "deg"}
    native_format = bytearray(b"<Iffff")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0]
    crc_extra = 26
    unpacker = struct.Struct("<Iffff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, roll: float, pitch: float, yaw: float, yaw_absolute: float = 0):
        MAVLink_message.__init__(self, MAVLink_mount_orientation_message.id, MAVLink_mount_orientation_message.msgname)
        self._fieldnames = MAVLink_mount_orientation_message.fieldnames
        self._instance_field = MAVLink_mount_orientation_message.instance_field
        self._instance_offset = MAVLink_mount_orientation_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.roll = roll
        self.pitch = pitch
        self.yaw = yaw
        self.yaw_absolute = yaw_absolute

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.roll, self.pitch, self.yaw, self.yaw_absolute), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mount_orientation_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_logging_data_message(MAVLink_message):
    """
    A message containing logged data (see also MAV_CMD_LOGGING_START)
    """

    id = MAVLINK_MSG_ID_LOGGING_DATA
    msgname = "LOGGING_DATA"
    fieldnames = ["target_system", "target_component", "sequence", "length", "first_message_offset", "data"]
    ordered_fieldnames = ["sequence", "target_system", "target_component", "length", "first_message_offset", "data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"length": "bytes", "first_message_offset": "bytes"}
    native_format = bytearray(b"<HBBBBB")
    orders = [1, 2, 0, 3, 4, 5]
    lengths = [1, 1, 1, 1, 1, 249]
    array_lengths = [0, 0, 0, 0, 0, 249]
    crc_extra = 193
    unpacker = struct.Struct("<HBBBB249B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, sequence: int, length: int, first_message_offset: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_logging_data_message.id, MAVLink_logging_data_message.msgname)
        self._fieldnames = MAVLink_logging_data_message.fieldnames
        self._instance_field = MAVLink_logging_data_message.instance_field
        self._instance_offset = MAVLink_logging_data_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.sequence = sequence
        self.length = length
        self.first_message_offset = first_message_offset
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.sequence, self.target_system, self.target_component, self.length, self.first_message_offset, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109], self.data[110], self.data[111], self.data[112], self.data[113], self.data[114], self.data[115], self.data[116], self.data[117], self.data[118], self.data[119], self.data[120], self.data[121], self.data[122], self.data[123], self.data[124], self.data[125], self.data[126], self.data[127], self.data[128], self.data[129], self.data[130], self.data[131], self.data[132], self.data[133], self.data[134], self.data[135], self.data[136], self.data[137], self.data[138], self.data[139], self.data[140], self.data[141], self.data[142], self.data[143], self.data[144], self.data[145], self.data[146], self.data[147], self.data[148], self.data[149], self.data[150], self.data[151], self.data[152], self.data[153], self.data[154], self.data[155], self.data[156], self.data[157], self.data[158], self.data[159], self.data[160], self.data[161], self.data[162], self.data[163], self.data[164], self.data[165], self.data[166], self.data[167], self.data[168], self.data[169], self.data[170], self.data[171], self.data[172], self.data[173], self.data[174], self.data[175], self.data[176], self.data[177], self.data[178], self.data[179], self.data[180], self.data[181], self.data[182], self.data[183], self.data[184], self.data[185], self.data[186], self.data[187], self.data[188], self.data[189], self.data[190], self.data[191], self.data[192], self.data[193], self.data[194], self.data[195], self.data[196], self.data[197], self.data[198], self.data[199], self.data[200], self.data[201], self.data[202], self.data[203], self.data[204], self.data[205], self.data[206], self.data[207], self.data[208], self.data[209], self.data[210], self.data[211], self.data[212], self.data[213], self.data[214], self.data[215], self.data[216], self.data[217], self.data[218], self.data[219], self.data[220], self.data[221], self.data[222], self.data[223], self.data[224], self.data[225], self.data[226], self.data[227], self.data[228], self.data[229], self.data[230], self.data[231], self.data[232], self.data[233], self.data[234], self.data[235], self.data[236], self.data[237], self.data[238], self.data[239], self.data[240], self.data[241], self.data[242], self.data[243], self.data[244], self.data[245], self.data[246], self.data[247], self.data[248]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_logging_data_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_logging_data_acked_message(MAVLink_message):
    """
    A message containing logged data which requires a LOGGING_ACK to
    be sent back
    """

    id = MAVLINK_MSG_ID_LOGGING_DATA_ACKED
    msgname = "LOGGING_DATA_ACKED"
    fieldnames = ["target_system", "target_component", "sequence", "length", "first_message_offset", "data"]
    ordered_fieldnames = ["sequence", "target_system", "target_component", "length", "first_message_offset", "data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"length": "bytes", "first_message_offset": "bytes"}
    native_format = bytearray(b"<HBBBBB")
    orders = [1, 2, 0, 3, 4, 5]
    lengths = [1, 1, 1, 1, 1, 249]
    array_lengths = [0, 0, 0, 0, 0, 249]
    crc_extra = 35
    unpacker = struct.Struct("<HBBBB249B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, sequence: int, length: int, first_message_offset: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_logging_data_acked_message.id, MAVLink_logging_data_acked_message.msgname)
        self._fieldnames = MAVLink_logging_data_acked_message.fieldnames
        self._instance_field = MAVLink_logging_data_acked_message.instance_field
        self._instance_offset = MAVLink_logging_data_acked_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.sequence = sequence
        self.length = length
        self.first_message_offset = first_message_offset
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.sequence, self.target_system, self.target_component, self.length, self.first_message_offset, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63], self.data[64], self.data[65], self.data[66], self.data[67], self.data[68], self.data[69], self.data[70], self.data[71], self.data[72], self.data[73], self.data[74], self.data[75], self.data[76], self.data[77], self.data[78], self.data[79], self.data[80], self.data[81], self.data[82], self.data[83], self.data[84], self.data[85], self.data[86], self.data[87], self.data[88], self.data[89], self.data[90], self.data[91], self.data[92], self.data[93], self.data[94], self.data[95], self.data[96], self.data[97], self.data[98], self.data[99], self.data[100], self.data[101], self.data[102], self.data[103], self.data[104], self.data[105], self.data[106], self.data[107], self.data[108], self.data[109], self.data[110], self.data[111], self.data[112], self.data[113], self.data[114], self.data[115], self.data[116], self.data[117], self.data[118], self.data[119], self.data[120], self.data[121], self.data[122], self.data[123], self.data[124], self.data[125], self.data[126], self.data[127], self.data[128], self.data[129], self.data[130], self.data[131], self.data[132], self.data[133], self.data[134], self.data[135], self.data[136], self.data[137], self.data[138], self.data[139], self.data[140], self.data[141], self.data[142], self.data[143], self.data[144], self.data[145], self.data[146], self.data[147], self.data[148], self.data[149], self.data[150], self.data[151], self.data[152], self.data[153], self.data[154], self.data[155], self.data[156], self.data[157], self.data[158], self.data[159], self.data[160], self.data[161], self.data[162], self.data[163], self.data[164], self.data[165], self.data[166], self.data[167], self.data[168], self.data[169], self.data[170], self.data[171], self.data[172], self.data[173], self.data[174], self.data[175], self.data[176], self.data[177], self.data[178], self.data[179], self.data[180], self.data[181], self.data[182], self.data[183], self.data[184], self.data[185], self.data[186], self.data[187], self.data[188], self.data[189], self.data[190], self.data[191], self.data[192], self.data[193], self.data[194], self.data[195], self.data[196], self.data[197], self.data[198], self.data[199], self.data[200], self.data[201], self.data[202], self.data[203], self.data[204], self.data[205], self.data[206], self.data[207], self.data[208], self.data[209], self.data[210], self.data[211], self.data[212], self.data[213], self.data[214], self.data[215], self.data[216], self.data[217], self.data[218], self.data[219], self.data[220], self.data[221], self.data[222], self.data[223], self.data[224], self.data[225], self.data[226], self.data[227], self.data[228], self.data[229], self.data[230], self.data[231], self.data[232], self.data[233], self.data[234], self.data[235], self.data[236], self.data[237], self.data[238], self.data[239], self.data[240], self.data[241], self.data[242], self.data[243], self.data[244], self.data[245], self.data[246], self.data[247], self.data[248]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_logging_data_acked_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_logging_ack_message(MAVLink_message):
    """
    An ack for a LOGGING_DATA_ACKED message
    """

    id = MAVLINK_MSG_ID_LOGGING_ACK
    msgname = "LOGGING_ACK"
    fieldnames = ["target_system", "target_component", "sequence"]
    ordered_fieldnames = ["sequence", "target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBB")
    orders = [1, 2, 0]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 14
    unpacker = struct.Struct("<HBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, sequence: int):
        MAVLink_message.__init__(self, MAVLink_logging_ack_message.id, MAVLink_logging_ack_message.msgname)
        self._fieldnames = MAVLink_logging_ack_message.fieldnames
        self._instance_field = MAVLink_logging_ack_message.instance_field
        self._instance_offset = MAVLink_logging_ack_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.sequence = sequence

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.sequence, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_logging_ack_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_video_stream_information_message(MAVLink_message):
    """
    Information about video stream. It may be requested using
    MAV_CMD_REQUEST_MESSAGE, where param2 indicates the video stream
    id: 0 for all streams, 1 for first, 2 for second, etc.
    """

    id = MAVLINK_MSG_ID_VIDEO_STREAM_INFORMATION
    msgname = "VIDEO_STREAM_INFORMATION"
    fieldnames = ["stream_id", "count", "type", "flags", "framerate", "resolution_h", "resolution_v", "bitrate", "rotation", "hfov", "name", "uri", "encoding"]
    ordered_fieldnames = ["framerate", "bitrate", "flags", "resolution_h", "resolution_v", "rotation", "hfov", "stream_id", "count", "type", "name", "uri", "encoding"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint16_t", "float", "uint16_t", "uint16_t", "uint32_t", "uint16_t", "uint16_t", "char", "char", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"type": "VIDEO_STREAM_TYPE", "flags": "VIDEO_STREAM_STATUS_FLAGS", "encoding": "VIDEO_STREAM_ENCODING"}
    fieldunits_by_name: Dict[str, str] = {"framerate": "Hz", "resolution_h": "pix", "resolution_v": "pix", "bitrate": "bits/s", "rotation": "deg", "hfov": "deg"}
    native_format = bytearray(b"<fIHHHHHBBBccB")
    orders = [7, 8, 9, 2, 0, 3, 4, 1, 5, 6, 10, 11, 12]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 160, 0]
    crc_extra = 109
    unpacker = struct.Struct("<fIHHHHHBBB32s160sB")
    instance_field = "stream_id"
    instance_offset = 18

    def __init__(self, stream_id: int, count: int, type: int, flags: int, framerate: float, resolution_h: int, resolution_v: int, bitrate: int, rotation: int, hfov: int, name: bytes, uri: bytes, encoding: int = 0):
        MAVLink_message.__init__(self, MAVLink_video_stream_information_message.id, MAVLink_video_stream_information_message.msgname)
        self._fieldnames = MAVLink_video_stream_information_message.fieldnames
        self._instance_field = MAVLink_video_stream_information_message.instance_field
        self._instance_offset = MAVLink_video_stream_information_message.instance_offset
        self.stream_id = stream_id
        self.count = count
        self.type = type
        self.flags = flags
        self.framerate = framerate
        self.resolution_h = resolution_h
        self.resolution_v = resolution_v
        self.bitrate = bitrate
        self.rotation = rotation
        self.hfov = hfov
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._uri_raw = uri
        self.uri = uri.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.encoding = encoding

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.framerate, self.bitrate, self.flags, self.resolution_h, self.resolution_v, self.rotation, self.hfov, self.stream_id, self.count, self.type, self._name_raw, self._uri_raw, self.encoding), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_video_stream_information_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_video_stream_status_message(MAVLink_message):
    """
    Information about the status of a video stream. It may be
    requested using MAV_CMD_REQUEST_MESSAGE.
    """

    id = MAVLINK_MSG_ID_VIDEO_STREAM_STATUS
    msgname = "VIDEO_STREAM_STATUS"
    fieldnames = ["stream_id", "flags", "framerate", "resolution_h", "resolution_v", "bitrate", "rotation", "hfov"]
    ordered_fieldnames = ["framerate", "bitrate", "flags", "resolution_h", "resolution_v", "rotation", "hfov", "stream_id"]
    fieldtypes = ["uint8_t", "uint16_t", "float", "uint16_t", "uint16_t", "uint32_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "VIDEO_STREAM_STATUS_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"framerate": "Hz", "resolution_h": "pix", "resolution_v": "pix", "bitrate": "bits/s", "rotation": "deg", "hfov": "deg"}
    native_format = bytearray(b"<fIHHHHHB")
    orders = [7, 2, 0, 3, 4, 1, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 59
    unpacker = struct.Struct("<fIHHHHHB")
    instance_field = "stream_id"
    instance_offset = 18

    def __init__(self, stream_id: int, flags: int, framerate: float, resolution_h: int, resolution_v: int, bitrate: int, rotation: int, hfov: int):
        MAVLink_message.__init__(self, MAVLink_video_stream_status_message.id, MAVLink_video_stream_status_message.msgname)
        self._fieldnames = MAVLink_video_stream_status_message.fieldnames
        self._instance_field = MAVLink_video_stream_status_message.instance_field
        self._instance_offset = MAVLink_video_stream_status_message.instance_offset
        self.stream_id = stream_id
        self.flags = flags
        self.framerate = framerate
        self.resolution_h = resolution_h
        self.resolution_v = resolution_v
        self.bitrate = bitrate
        self.rotation = rotation
        self.hfov = hfov

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.framerate, self.bitrate, self.flags, self.resolution_h, self.resolution_v, self.rotation, self.hfov, self.stream_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_video_stream_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_fov_status_message(MAVLink_message):
    """
    Information about the field of view of a camera. Can be requested
    with a MAV_CMD_REQUEST_MESSAGE command.
    """

    id = MAVLINK_MSG_ID_CAMERA_FOV_STATUS
    msgname = "CAMERA_FOV_STATUS"
    fieldnames = ["time_boot_ms", "lat_camera", "lon_camera", "alt_camera", "lat_image", "lon_image", "alt_image", "q", "hfov", "vfov"]
    ordered_fieldnames = ["time_boot_ms", "lat_camera", "lon_camera", "alt_camera", "lat_image", "lon_image", "alt_image", "q", "hfov", "vfov"]
    fieldtypes = ["uint32_t", "int32_t", "int32_t", "int32_t", "int32_t", "int32_t", "int32_t", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "lat_camera": "degE7", "lon_camera": "degE7", "alt_camera": "mm", "lat_image": "degE7", "lon_image": "degE7", "alt_image": "mm", "hfov": "deg", "vfov": "deg"}
    native_format = bytearray(b"<Iiiiiiifff")
    orders = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
    lengths = [1, 1, 1, 1, 1, 1, 1, 4, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 4, 0, 0]
    crc_extra = 22
    unpacker = struct.Struct("<Iiiiiii4fff")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, lat_camera: int, lon_camera: int, alt_camera: int, lat_image: int, lon_image: int, alt_image: int, q: Sequence[float], hfov: float, vfov: float):
        MAVLink_message.__init__(self, MAVLink_camera_fov_status_message.id, MAVLink_camera_fov_status_message.msgname)
        self._fieldnames = MAVLink_camera_fov_status_message.fieldnames
        self._instance_field = MAVLink_camera_fov_status_message.instance_field
        self._instance_offset = MAVLink_camera_fov_status_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.lat_camera = lat_camera
        self.lon_camera = lon_camera
        self.alt_camera = alt_camera
        self.lat_image = lat_image
        self.lon_image = lon_image
        self.alt_image = alt_image
        self.q = q
        self.hfov = hfov
        self.vfov = vfov

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.lat_camera, self.lon_camera, self.alt_camera, self.lat_image, self.lon_image, self.alt_image, self.q[0], self.q[1], self.q[2], self.q[3], self.hfov, self.vfov), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_fov_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_tracking_image_status_message(MAVLink_message):
    """
    Camera tracking status, sent while in active tracking. Use
    MAV_CMD_SET_MESSAGE_INTERVAL to define message interval.
    """

    id = MAVLINK_MSG_ID_CAMERA_TRACKING_IMAGE_STATUS
    msgname = "CAMERA_TRACKING_IMAGE_STATUS"
    fieldnames = ["tracking_status", "tracking_mode", "target_data", "point_x", "point_y", "radius", "rec_top_x", "rec_top_y", "rec_bottom_x", "rec_bottom_y"]
    ordered_fieldnames = ["point_x", "point_y", "radius", "rec_top_x", "rec_top_y", "rec_bottom_x", "rec_bottom_y", "tracking_status", "tracking_mode", "target_data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"target_data": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"tracking_status": "CAMERA_TRACKING_STATUS_FLAGS", "tracking_mode": "CAMERA_TRACKING_MODE", "target_data": "CAMERA_TRACKING_TARGET_DATA"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<fffffffBBB")
    orders = [7, 8, 9, 0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 126
    unpacker = struct.Struct("<fffffffBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, tracking_status: int, tracking_mode: int, target_data: int, point_x: float, point_y: float, radius: float, rec_top_x: float, rec_top_y: float, rec_bottom_x: float, rec_bottom_y: float):
        MAVLink_message.__init__(self, MAVLink_camera_tracking_image_status_message.id, MAVLink_camera_tracking_image_status_message.msgname)
        self._fieldnames = MAVLink_camera_tracking_image_status_message.fieldnames
        self._instance_field = MAVLink_camera_tracking_image_status_message.instance_field
        self._instance_offset = MAVLink_camera_tracking_image_status_message.instance_offset
        self.tracking_status = tracking_status
        self.tracking_mode = tracking_mode
        self.target_data = target_data
        self.point_x = point_x
        self.point_y = point_y
        self.radius = radius
        self.rec_top_x = rec_top_x
        self.rec_top_y = rec_top_y
        self.rec_bottom_x = rec_bottom_x
        self.rec_bottom_y = rec_bottom_y

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.point_x, self.point_y, self.radius, self.rec_top_x, self.rec_top_y, self.rec_bottom_x, self.rec_bottom_y, self.tracking_status, self.tracking_mode, self.target_data), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_tracking_image_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_tracking_geo_status_message(MAVLink_message):
    """
    Camera tracking status, sent while in active tracking. Use
    MAV_CMD_SET_MESSAGE_INTERVAL to define message interval.
    """

    id = MAVLINK_MSG_ID_CAMERA_TRACKING_GEO_STATUS
    msgname = "CAMERA_TRACKING_GEO_STATUS"
    fieldnames = ["tracking_status", "lat", "lon", "alt", "h_acc", "v_acc", "vel_n", "vel_e", "vel_d", "vel_acc", "dist", "hdg", "hdg_acc"]
    ordered_fieldnames = ["lat", "lon", "alt", "h_acc", "v_acc", "vel_n", "vel_e", "vel_d", "vel_acc", "dist", "hdg", "hdg_acc", "tracking_status"]
    fieldtypes = ["uint8_t", "int32_t", "int32_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"tracking_status": "CAMERA_TRACKING_STATUS_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"lat": "degE7", "lon": "degE7", "alt": "m", "h_acc": "m", "v_acc": "m", "vel_n": "m/s", "vel_e": "m/s", "vel_d": "m/s", "vel_acc": "m/s", "dist": "m", "hdg": "rad", "hdg_acc": "rad"}
    native_format = bytearray(b"<iiffffffffffB")
    orders = [12, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 18
    unpacker = struct.Struct("<iiffffffffffB")
    instance_field = None
    instance_offset = -1

    def __init__(self, tracking_status: int, lat: int, lon: int, alt: float, h_acc: float, v_acc: float, vel_n: float, vel_e: float, vel_d: float, vel_acc: float, dist: float, hdg: float, hdg_acc: float):
        MAVLink_message.__init__(self, MAVLink_camera_tracking_geo_status_message.id, MAVLink_camera_tracking_geo_status_message.msgname)
        self._fieldnames = MAVLink_camera_tracking_geo_status_message.fieldnames
        self._instance_field = MAVLink_camera_tracking_geo_status_message.instance_field
        self._instance_offset = MAVLink_camera_tracking_geo_status_message.instance_offset
        self.tracking_status = tracking_status
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.h_acc = h_acc
        self.v_acc = v_acc
        self.vel_n = vel_n
        self.vel_e = vel_e
        self.vel_d = vel_d
        self.vel_acc = vel_acc
        self.dist = dist
        self.hdg = hdg
        self.hdg_acc = hdg_acc

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.lat, self.lon, self.alt, self.h_acc, self.v_acc, self.vel_n, self.vel_e, self.vel_d, self.vel_acc, self.dist, self.hdg, self.hdg_acc, self.tracking_status), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_tracking_geo_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_camera_thermal_range_message(MAVLink_message):
    """
    Camera absolute thermal range. This can be streamed when the
    associated `VIDEO_STREAM_STATUS.flag` bit
    `VIDEO_STREAM_STATUS_FLAGS_THERMAL_RANGE_ENABLED` is set, but a
    GCS may choose to only request it for the current active stream.
    Use MAV_CMD_SET_MESSAGE_INTERVAL to define message interval
    (param3 indicates the stream id of the current camera, or 0 for
    all streams, param4 indicates the target camera_device_id for
    autopilot-attached cameras or 0 for MAVLink cameras).
    """

    id = MAVLINK_MSG_ID_CAMERA_THERMAL_RANGE
    msgname = "CAMERA_THERMAL_RANGE"
    fieldnames = ["time_boot_ms", "stream_id", "camera_device_id", "max", "max_point_x", "max_point_y", "min", "min_point_x", "min_point_y"]
    ordered_fieldnames = ["time_boot_ms", "max", "max_point_x", "max_point_y", "min", "min_point_x", "min_point_y", "stream_id", "camera_device_id"]
    fieldtypes = ["uint32_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "max": "degC", "min": "degC"}
    native_format = bytearray(b"<IffffffBB")
    orders = [0, 7, 8, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 62
    unpacker = struct.Struct("<IffffffBB")
    instance_field = "stream_id"
    instance_offset = 28

    def __init__(self, time_boot_ms: int, stream_id: int, camera_device_id: int, max: float, max_point_x: float, max_point_y: float, min: float, min_point_x: float, min_point_y: float):
        MAVLink_message.__init__(self, MAVLink_camera_thermal_range_message.id, MAVLink_camera_thermal_range_message.msgname)
        self._fieldnames = MAVLink_camera_thermal_range_message.fieldnames
        self._instance_field = MAVLink_camera_thermal_range_message.instance_field
        self._instance_offset = MAVLink_camera_thermal_range_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.stream_id = stream_id
        self.camera_device_id = camera_device_id
        self.max = max
        self.max_point_x = max_point_x
        self.max_point_y = max_point_y
        self.min = min
        self.min_point_x = min_point_x
        self.min_point_y = min_point_y

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.max, self.max_point_x, self.max_point_y, self.min, self.min_point_x, self.min_point_y, self.stream_id, self.camera_device_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_camera_thermal_range_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gimbal_manager_information_message(MAVLink_message):
    """
    Information about a high level gimbal manager. This message should
    be requested by a ground station using MAV_CMD_REQUEST_MESSAGE.
    """

    id = MAVLINK_MSG_ID_GIMBAL_MANAGER_INFORMATION
    msgname = "GIMBAL_MANAGER_INFORMATION"
    fieldnames = ["time_boot_ms", "cap_flags", "gimbal_device_id", "roll_min", "roll_max", "pitch_min", "pitch_max", "yaw_min", "yaw_max"]
    ordered_fieldnames = ["time_boot_ms", "cap_flags", "roll_min", "roll_max", "pitch_min", "pitch_max", "yaw_min", "yaw_max", "gimbal_device_id"]
    fieldtypes = ["uint32_t", "uint32_t", "uint8_t", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"cap_flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"cap_flags": "GIMBAL_MANAGER_CAP_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "roll_min": "rad", "roll_max": "rad", "pitch_min": "rad", "pitch_max": "rad", "yaw_min": "rad", "yaw_max": "rad"}
    native_format = bytearray(b"<IIffffffB")
    orders = [0, 1, 8, 2, 3, 4, 5, 6, 7]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 70
    unpacker = struct.Struct("<IIffffffB")
    instance_field = "gimbal_device_id"
    instance_offset = 32

    def __init__(self, time_boot_ms: int, cap_flags: int, gimbal_device_id: int, roll_min: float, roll_max: float, pitch_min: float, pitch_max: float, yaw_min: float, yaw_max: float):
        MAVLink_message.__init__(self, MAVLink_gimbal_manager_information_message.id, MAVLink_gimbal_manager_information_message.msgname)
        self._fieldnames = MAVLink_gimbal_manager_information_message.fieldnames
        self._instance_field = MAVLink_gimbal_manager_information_message.instance_field
        self._instance_offset = MAVLink_gimbal_manager_information_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.cap_flags = cap_flags
        self.gimbal_device_id = gimbal_device_id
        self.roll_min = roll_min
        self.roll_max = roll_max
        self.pitch_min = pitch_min
        self.pitch_max = pitch_max
        self.yaw_min = yaw_min
        self.yaw_max = yaw_max

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.cap_flags, self.roll_min, self.roll_max, self.pitch_min, self.pitch_max, self.yaw_min, self.yaw_max, self.gimbal_device_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gimbal_manager_information_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gimbal_manager_status_message(MAVLink_message):
    """
    Current status about a high level gimbal manager. This message
    should be broadcast at a low regular rate (e.g. 5Hz).
    """

    id = MAVLINK_MSG_ID_GIMBAL_MANAGER_STATUS
    msgname = "GIMBAL_MANAGER_STATUS"
    fieldnames = ["time_boot_ms", "flags", "gimbal_device_id", "primary_control_sysid", "primary_control_compid", "secondary_control_sysid", "secondary_control_compid"]
    ordered_fieldnames = ["time_boot_ms", "flags", "gimbal_device_id", "primary_control_sysid", "primary_control_compid", "secondary_control_sysid", "secondary_control_compid"]
    fieldtypes = ["uint32_t", "uint32_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "GIMBAL_MANAGER_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<IIBBBBB")
    orders = [0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0]
    crc_extra = 48
    unpacker = struct.Struct("<IIBBBBB")
    instance_field = "gimbal_device_id"
    instance_offset = 8

    def __init__(self, time_boot_ms: int, flags: int, gimbal_device_id: int, primary_control_sysid: int, primary_control_compid: int, secondary_control_sysid: int, secondary_control_compid: int):
        MAVLink_message.__init__(self, MAVLink_gimbal_manager_status_message.id, MAVLink_gimbal_manager_status_message.msgname)
        self._fieldnames = MAVLink_gimbal_manager_status_message.fieldnames
        self._instance_field = MAVLink_gimbal_manager_status_message.instance_field
        self._instance_offset = MAVLink_gimbal_manager_status_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.flags = flags
        self.gimbal_device_id = gimbal_device_id
        self.primary_control_sysid = primary_control_sysid
        self.primary_control_compid = primary_control_compid
        self.secondary_control_sysid = secondary_control_sysid
        self.secondary_control_compid = secondary_control_compid

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.flags, self.gimbal_device_id, self.primary_control_sysid, self.primary_control_compid, self.secondary_control_sysid, self.secondary_control_compid), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gimbal_manager_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gimbal_manager_set_attitude_message(MAVLink_message):
    """
    High level message to control a gimbal's attitude. This message is
    to be sent to the gimbal manager (e.g. from a ground station).
    Angles and rates can be set to NaN according to use case.
    """

    id = MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_ATTITUDE
    msgname = "GIMBAL_MANAGER_SET_ATTITUDE"
    fieldnames = ["target_system", "target_component", "flags", "gimbal_device_id", "q", "angular_velocity_x", "angular_velocity_y", "angular_velocity_z"]
    ordered_fieldnames = ["flags", "q", "angular_velocity_x", "angular_velocity_y", "angular_velocity_z", "target_system", "target_component", "gimbal_device_id"]
    fieldtypes = ["uint8_t", "uint8_t", "uint32_t", "uint8_t", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "GIMBAL_MANAGER_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"angular_velocity_x": "rad/s", "angular_velocity_y": "rad/s", "angular_velocity_z": "rad/s"}
    native_format = bytearray(b"<IffffBBB")
    orders = [5, 6, 0, 7, 1, 2, 3, 4]
    lengths = [1, 4, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 4, 0, 0, 0, 0, 0, 0]
    crc_extra = 123
    unpacker = struct.Struct("<I4ffffBBB")
    instance_field = "gimbal_device_id"
    instance_offset = 34

    def __init__(self, target_system: int, target_component: int, flags: int, gimbal_device_id: int, q: Sequence[float], angular_velocity_x: float, angular_velocity_y: float, angular_velocity_z: float):
        MAVLink_message.__init__(self, MAVLink_gimbal_manager_set_attitude_message.id, MAVLink_gimbal_manager_set_attitude_message.msgname)
        self._fieldnames = MAVLink_gimbal_manager_set_attitude_message.fieldnames
        self._instance_field = MAVLink_gimbal_manager_set_attitude_message.instance_field
        self._instance_offset = MAVLink_gimbal_manager_set_attitude_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.flags = flags
        self.gimbal_device_id = gimbal_device_id
        self.q = q
        self.angular_velocity_x = angular_velocity_x
        self.angular_velocity_y = angular_velocity_y
        self.angular_velocity_z = angular_velocity_z

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.flags, self.q[0], self.q[1], self.q[2], self.q[3], self.angular_velocity_x, self.angular_velocity_y, self.angular_velocity_z, self.target_system, self.target_component, self.gimbal_device_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gimbal_manager_set_attitude_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gimbal_device_information_message(MAVLink_message):
    """
    Information about a low level gimbal. This message should be
    requested by the gimbal manager or a ground station using
    MAV_CMD_REQUEST_MESSAGE. The maximum angles and rates are the
    limits by hardware. However, the limits by software used are
    likely different/smaller and dependent on mode/settings/etc..
    """

    id = MAVLINK_MSG_ID_GIMBAL_DEVICE_INFORMATION
    msgname = "GIMBAL_DEVICE_INFORMATION"
    fieldnames = ["time_boot_ms", "vendor_name", "model_name", "custom_name", "firmware_version", "hardware_version", "uid", "cap_flags", "custom_cap_flags", "roll_min", "roll_max", "pitch_min", "pitch_max", "yaw_min", "yaw_max", "gimbal_device_id"]
    ordered_fieldnames = ["uid", "time_boot_ms", "firmware_version", "hardware_version", "roll_min", "roll_max", "pitch_min", "pitch_max", "yaw_min", "yaw_max", "cap_flags", "custom_cap_flags", "vendor_name", "model_name", "custom_name", "gimbal_device_id"]
    fieldtypes = ["uint32_t", "char", "char", "char", "uint32_t", "uint32_t", "uint64_t", "uint16_t", "uint16_t", "float", "float", "float", "float", "float", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"cap_flags": "bitmask", "custom_cap_flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"cap_flags": "GIMBAL_DEVICE_CAP_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "roll_min": "rad", "roll_max": "rad", "pitch_min": "rad", "pitch_max": "rad", "yaw_min": "rad", "yaw_max": "rad"}
    native_format = bytearray(b"<QIIIffffffHHcccB")
    orders = [1, 12, 13, 14, 2, 3, 0, 10, 11, 4, 5, 6, 7, 8, 9, 15]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 0]
    crc_extra = 74
    unpacker = struct.Struct("<QIIIffffffHH32s32s32sB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, vendor_name: bytes, model_name: bytes, custom_name: bytes, firmware_version: int, hardware_version: int, uid: int, cap_flags: int, custom_cap_flags: int, roll_min: float, roll_max: float, pitch_min: float, pitch_max: float, yaw_min: float, yaw_max: float, gimbal_device_id: int = 0):
        MAVLink_message.__init__(self, MAVLink_gimbal_device_information_message.id, MAVLink_gimbal_device_information_message.msgname)
        self._fieldnames = MAVLink_gimbal_device_information_message.fieldnames
        self._instance_field = MAVLink_gimbal_device_information_message.instance_field
        self._instance_offset = MAVLink_gimbal_device_information_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self._vendor_name_raw = vendor_name
        self.vendor_name = vendor_name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._model_name_raw = model_name
        self.model_name = model_name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._custom_name_raw = custom_name
        self.custom_name = custom_name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.firmware_version = firmware_version
        self.hardware_version = hardware_version
        self.uid = uid
        self.cap_flags = cap_flags
        self.custom_cap_flags = custom_cap_flags
        self.roll_min = roll_min
        self.roll_max = roll_max
        self.pitch_min = pitch_min
        self.pitch_max = pitch_max
        self.yaw_min = yaw_min
        self.yaw_max = yaw_max
        self.gimbal_device_id = gimbal_device_id

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.uid, self.time_boot_ms, self.firmware_version, self.hardware_version, self.roll_min, self.roll_max, self.pitch_min, self.pitch_max, self.yaw_min, self.yaw_max, self.cap_flags, self.custom_cap_flags, self._vendor_name_raw, self._model_name_raw, self._custom_name_raw, self.gimbal_device_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gimbal_device_information_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gimbal_device_set_attitude_message(MAVLink_message):
    """
    Low level message to control a gimbal device's attitude.
    This message is to be sent from the gimbal manager to the gimbal
    device component.           The quaternion and angular velocities
    can be set to NaN according to use case.           For the angles
    encoded in the quaternion and the angular velocities holds:
    If the flag GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME is set, then
    they are relative to the vehicle heading (vehicle frame).
    If the flag GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME is set, then
    they are relative to absolute North (earth frame).           If
    neither of these flags are set, then (for backwards compatibility)
    it holds:           If the flag GIMBAL_DEVICE_FLAGS_YAW_LOCK is
    set, then they are relative to absolute North (earth frame),
    else they are relative to the vehicle heading (vehicle frame).
    Setting both GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME and
    GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME is not allowed.
    These rules are to ensure backwards compatibility.           New
    implementations should always set either
    GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME or
    GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME.
    """

    id = MAVLINK_MSG_ID_GIMBAL_DEVICE_SET_ATTITUDE
    msgname = "GIMBAL_DEVICE_SET_ATTITUDE"
    fieldnames = ["target_system", "target_component", "flags", "q", "angular_velocity_x", "angular_velocity_y", "angular_velocity_z"]
    ordered_fieldnames = ["q", "angular_velocity_x", "angular_velocity_y", "angular_velocity_z", "flags", "target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "GIMBAL_DEVICE_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"angular_velocity_x": "rad/s", "angular_velocity_y": "rad/s", "angular_velocity_z": "rad/s"}
    native_format = bytearray(b"<ffffHBB")
    orders = [5, 6, 4, 0, 1, 2, 3]
    lengths = [4, 1, 1, 1, 1, 1, 1]
    array_lengths = [4, 0, 0, 0, 0, 0, 0]
    crc_extra = 99
    unpacker = struct.Struct("<4ffffHBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, flags: int, q: Sequence[float], angular_velocity_x: float, angular_velocity_y: float, angular_velocity_z: float):
        MAVLink_message.__init__(self, MAVLink_gimbal_device_set_attitude_message.id, MAVLink_gimbal_device_set_attitude_message.msgname)
        self._fieldnames = MAVLink_gimbal_device_set_attitude_message.fieldnames
        self._instance_field = MAVLink_gimbal_device_set_attitude_message.instance_field
        self._instance_offset = MAVLink_gimbal_device_set_attitude_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.flags = flags
        self.q = q
        self.angular_velocity_x = angular_velocity_x
        self.angular_velocity_y = angular_velocity_y
        self.angular_velocity_z = angular_velocity_z

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.q[0], self.q[1], self.q[2], self.q[3], self.angular_velocity_x, self.angular_velocity_y, self.angular_velocity_z, self.flags, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gimbal_device_set_attitude_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gimbal_device_attitude_status_message(MAVLink_message):
    """
    Message reporting the status of a gimbal device.           This
    message should be broadcast by a gimbal device component at a low
    regular rate (e.g. 5 Hz).           For the angles encoded in the
    quaternion and the angular velocities holds:           If the flag
    GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME is set, then they are
    relative to the vehicle heading (vehicle frame).           If the
    flag GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME is set, then they are
    relative to absolute North (earth frame).           If neither of
    these flags are set, then (for backwards compatibility) it holds:
    If the flag GIMBAL_DEVICE_FLAGS_YAW_LOCK is set, then they are
    relative to absolute North (earth frame),           else they are
    relative to the vehicle heading (vehicle frame).           Other
    conditions of the flags are not allowed.           The quaternion
    and angular velocities in the other frame can be calculated from
    delta_yaw and delta_yaw_velocity as           q_earth =
    q_delta_yaw * q_vehicle and w_earth = w_delta_yaw_velocity +
    w_vehicle (if not NaN).           If neither the
    GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME nor the
    GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME flag is set,           then
    (for backwards compatibility) the data in the delta_yaw and
    delta_yaw_velocity fields are to be ignored.           New
    implementations should always set either
    GIMBAL_DEVICE_FLAGS_YAW_IN_VEHICLE_FRAME or
    GIMBAL_DEVICE_FLAGS_YAW_IN_EARTH_FRAME,           and always
    should set delta_yaw and delta_yaw_velocity either to the proper
    value or NaN.
    """

    id = MAVLINK_MSG_ID_GIMBAL_DEVICE_ATTITUDE_STATUS
    msgname = "GIMBAL_DEVICE_ATTITUDE_STATUS"
    fieldnames = ["target_system", "target_component", "time_boot_ms", "flags", "q", "angular_velocity_x", "angular_velocity_y", "angular_velocity_z", "failure_flags", "delta_yaw", "delta_yaw_velocity", "gimbal_device_id"]
    ordered_fieldnames = ["time_boot_ms", "q", "angular_velocity_x", "angular_velocity_y", "angular_velocity_z", "failure_flags", "flags", "target_system", "target_component", "delta_yaw", "delta_yaw_velocity", "gimbal_device_id"]
    fieldtypes = ["uint8_t", "uint8_t", "uint32_t", "uint16_t", "float", "float", "float", "float", "uint32_t", "float", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask", "failure_flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "GIMBAL_DEVICE_FLAGS", "failure_flags": "GIMBAL_DEVICE_ERROR_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms", "angular_velocity_x": "rad/s", "angular_velocity_y": "rad/s", "angular_velocity_z": "rad/s", "delta_yaw": "rad", "delta_yaw_velocity": "rad/s"}
    native_format = bytearray(b"<IffffIHBBffB")
    orders = [7, 8, 0, 6, 1, 2, 3, 4, 5, 9, 10, 11]
    lengths = [1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 137
    unpacker = struct.Struct("<I4ffffIHBBffB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, time_boot_ms: int, flags: int, q: Sequence[float], angular_velocity_x: float, angular_velocity_y: float, angular_velocity_z: float, failure_flags: int, delta_yaw: float = 0, delta_yaw_velocity: float = 0, gimbal_device_id: int = 0):
        MAVLink_message.__init__(self, MAVLink_gimbal_device_attitude_status_message.id, MAVLink_gimbal_device_attitude_status_message.msgname)
        self._fieldnames = MAVLink_gimbal_device_attitude_status_message.fieldnames
        self._instance_field = MAVLink_gimbal_device_attitude_status_message.instance_field
        self._instance_offset = MAVLink_gimbal_device_attitude_status_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.time_boot_ms = time_boot_ms
        self.flags = flags
        self.q = q
        self.angular_velocity_x = angular_velocity_x
        self.angular_velocity_y = angular_velocity_y
        self.angular_velocity_z = angular_velocity_z
        self.failure_flags = failure_flags
        self.delta_yaw = delta_yaw
        self.delta_yaw_velocity = delta_yaw_velocity
        self.gimbal_device_id = gimbal_device_id

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.q[0], self.q[1], self.q[2], self.q[3], self.angular_velocity_x, self.angular_velocity_y, self.angular_velocity_z, self.failure_flags, self.flags, self.target_system, self.target_component, self.delta_yaw, self.delta_yaw_velocity, self.gimbal_device_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gimbal_device_attitude_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_autopilot_state_for_gimbal_device_message(MAVLink_message):
    """
    Low level message containing autopilot state relevant for a gimbal
    device. This message is to be sent from the autopilot to the
    gimbal device component. The data of this message are for the
    gimbal device's estimator corrections, in particular horizon
    compensation, as well as indicates autopilot control intentions,
    e.g. feed forward angular control in the z-axis.
    """

    id = MAVLINK_MSG_ID_AUTOPILOT_STATE_FOR_GIMBAL_DEVICE
    msgname = "AUTOPILOT_STATE_FOR_GIMBAL_DEVICE"
    fieldnames = ["target_system", "target_component", "time_boot_us", "q", "q_estimated_delay_us", "vx", "vy", "vz", "v_estimated_delay_us", "feed_forward_angular_velocity_z", "estimator_status", "landed_state", "angular_velocity_z"]
    ordered_fieldnames = ["time_boot_us", "q", "q_estimated_delay_us", "vx", "vy", "vz", "v_estimated_delay_us", "feed_forward_angular_velocity_z", "estimator_status", "target_system", "target_component", "landed_state", "angular_velocity_z"]
    fieldtypes = ["uint8_t", "uint8_t", "uint64_t", "float", "uint32_t", "float", "float", "float", "uint32_t", "float", "uint16_t", "uint8_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {"estimator_status": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"estimator_status": "ESTIMATOR_STATUS_FLAGS", "landed_state": "MAV_LANDED_STATE"}
    fieldunits_by_name: Dict[str, str] = {"time_boot_us": "us", "q_estimated_delay_us": "us", "vx": "m/s", "vy": "m/s", "vz": "m/s", "v_estimated_delay_us": "us", "feed_forward_angular_velocity_z": "rad/s", "angular_velocity_z": "rad/s"}
    native_format = bytearray(b"<QfIfffIfHBBBf")
    orders = [9, 10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 11, 12]
    lengths = [1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 210
    unpacker = struct.Struct("<Q4fIfffIfHBBBf")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, time_boot_us: int, q: Sequence[float], q_estimated_delay_us: int, vx: float, vy: float, vz: float, v_estimated_delay_us: int, feed_forward_angular_velocity_z: float, estimator_status: int, landed_state: int, angular_velocity_z: float = 0):
        MAVLink_message.__init__(self, MAVLink_autopilot_state_for_gimbal_device_message.id, MAVLink_autopilot_state_for_gimbal_device_message.msgname)
        self._fieldnames = MAVLink_autopilot_state_for_gimbal_device_message.fieldnames
        self._instance_field = MAVLink_autopilot_state_for_gimbal_device_message.instance_field
        self._instance_offset = MAVLink_autopilot_state_for_gimbal_device_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.time_boot_us = time_boot_us
        self.q = q
        self.q_estimated_delay_us = q_estimated_delay_us
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.v_estimated_delay_us = v_estimated_delay_us
        self.feed_forward_angular_velocity_z = feed_forward_angular_velocity_z
        self.estimator_status = estimator_status
        self.landed_state = landed_state
        self.angular_velocity_z = angular_velocity_z

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_us, self.q[0], self.q[1], self.q[2], self.q[3], self.q_estimated_delay_us, self.vx, self.vy, self.vz, self.v_estimated_delay_us, self.feed_forward_angular_velocity_z, self.estimator_status, self.target_system, self.target_component, self.landed_state, self.angular_velocity_z), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_autopilot_state_for_gimbal_device_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gimbal_manager_set_pitchyaw_message(MAVLink_message):
    """
    Set gimbal manager pitch and yaw angles (high rate message). This
    message is to be sent to the gimbal manager (e.g. from a ground
    station) and will be ignored by gimbal devices. Angles and rates
    can be set to NaN according to use case. Use
    MAV_CMD_DO_GIMBAL_MANAGER_PITCHYAW for low-rate adjustments that
    require confirmation.
    """

    id = MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_PITCHYAW
    msgname = "GIMBAL_MANAGER_SET_PITCHYAW"
    fieldnames = ["target_system", "target_component", "flags", "gimbal_device_id", "pitch", "yaw", "pitch_rate", "yaw_rate"]
    ordered_fieldnames = ["flags", "pitch", "yaw", "pitch_rate", "yaw_rate", "target_system", "target_component", "gimbal_device_id"]
    fieldtypes = ["uint8_t", "uint8_t", "uint32_t", "uint8_t", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "GIMBAL_MANAGER_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"pitch": "rad", "yaw": "rad", "pitch_rate": "rad/s", "yaw_rate": "rad/s"}
    native_format = bytearray(b"<IffffBBB")
    orders = [5, 6, 0, 7, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 1
    unpacker = struct.Struct("<IffffBBB")
    instance_field = "gimbal_device_id"
    instance_offset = 22

    def __init__(self, target_system: int, target_component: int, flags: int, gimbal_device_id: int, pitch: float, yaw: float, pitch_rate: float, yaw_rate: float):
        MAVLink_message.__init__(self, MAVLink_gimbal_manager_set_pitchyaw_message.id, MAVLink_gimbal_manager_set_pitchyaw_message.msgname)
        self._fieldnames = MAVLink_gimbal_manager_set_pitchyaw_message.fieldnames
        self._instance_field = MAVLink_gimbal_manager_set_pitchyaw_message.instance_field
        self._instance_offset = MAVLink_gimbal_manager_set_pitchyaw_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.flags = flags
        self.gimbal_device_id = gimbal_device_id
        self.pitch = pitch
        self.yaw = yaw
        self.pitch_rate = pitch_rate
        self.yaw_rate = yaw_rate

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.flags, self.pitch, self.yaw, self.pitch_rate, self.yaw_rate, self.target_system, self.target_component, self.gimbal_device_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gimbal_manager_set_pitchyaw_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gimbal_manager_set_manual_control_message(MAVLink_message):
    """
    High level message to control a gimbal manually. The angles or
    angular rates are unitless; the actual rates will depend on
    internal gimbal manager settings/configuration (e.g. set by
    parameters). This message is to be sent to the gimbal manager
    (e.g. from a ground station). Angles and rates can be set to NaN
    according to use case.
    """

    id = MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_MANUAL_CONTROL
    msgname = "GIMBAL_MANAGER_SET_MANUAL_CONTROL"
    fieldnames = ["target_system", "target_component", "flags", "gimbal_device_id", "pitch", "yaw", "pitch_rate", "yaw_rate"]
    ordered_fieldnames = ["flags", "pitch", "yaw", "pitch_rate", "yaw_rate", "target_system", "target_component", "gimbal_device_id"]
    fieldtypes = ["uint8_t", "uint8_t", "uint32_t", "uint8_t", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flags": "GIMBAL_MANAGER_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<IffffBBB")
    orders = [5, 6, 0, 7, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 20
    unpacker = struct.Struct("<IffffBBB")
    instance_field = "gimbal_device_id"
    instance_offset = 22

    def __init__(self, target_system: int, target_component: int, flags: int, gimbal_device_id: int, pitch: float, yaw: float, pitch_rate: float, yaw_rate: float):
        MAVLink_message.__init__(self, MAVLink_gimbal_manager_set_manual_control_message.id, MAVLink_gimbal_manager_set_manual_control_message.msgname)
        self._fieldnames = MAVLink_gimbal_manager_set_manual_control_message.fieldnames
        self._instance_field = MAVLink_gimbal_manager_set_manual_control_message.instance_field
        self._instance_offset = MAVLink_gimbal_manager_set_manual_control_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.flags = flags
        self.gimbal_device_id = gimbal_device_id
        self.pitch = pitch
        self.yaw = yaw
        self.pitch_rate = pitch_rate
        self.yaw_rate = yaw_rate

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.flags, self.pitch, self.yaw, self.pitch_rate, self.yaw_rate, self.target_system, self.target_component, self.gimbal_device_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gimbal_manager_set_manual_control_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_wifi_config_ap_message(MAVLink_message):
    """
    Configure WiFi AP SSID, password, and mode. This message is re-
    emitted as an acknowledgement by the AP. The message may also be
    explicitly requested using MAV_CMD_REQUEST_MESSAGE
    """

    id = MAVLINK_MSG_ID_WIFI_CONFIG_AP
    msgname = "WIFI_CONFIG_AP"
    fieldnames = ["ssid", "password"]
    ordered_fieldnames = ["ssid", "password"]
    fieldtypes = ["char", "char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<cc")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [32, 64]
    crc_extra = 19
    unpacker = struct.Struct("<32s64s")
    instance_field = None
    instance_offset = -1

    def __init__(self, ssid: bytes, password: bytes):
        MAVLink_message.__init__(self, MAVLink_wifi_config_ap_message.id, MAVLink_wifi_config_ap_message.msgname)
        self._fieldnames = MAVLink_wifi_config_ap_message.fieldnames
        self._instance_field = MAVLink_wifi_config_ap_message.instance_field
        self._instance_offset = MAVLink_wifi_config_ap_message.instance_offset
        self._ssid_raw = ssid
        self.ssid = ssid.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._password_raw = password
        self.password = password.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self._ssid_raw, self._password_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_wifi_config_ap_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_ais_vessel_message(MAVLink_message):
    """
    The location and information of an AIS vessel
    """

    id = MAVLINK_MSG_ID_AIS_VESSEL
    msgname = "AIS_VESSEL"
    fieldnames = ["MMSI", "lat", "lon", "COG", "heading", "velocity", "turn_rate", "navigational_status", "type", "dimension_bow", "dimension_stern", "dimension_port", "dimension_starboard", "callsign", "name", "tslc", "flags"]
    ordered_fieldnames = ["MMSI", "lat", "lon", "COG", "heading", "velocity", "dimension_bow", "dimension_stern", "tslc", "flags", "turn_rate", "navigational_status", "type", "dimension_port", "dimension_starboard", "callsign", "name"]
    fieldtypes = ["uint32_t", "int32_t", "int32_t", "uint16_t", "uint16_t", "uint16_t", "int8_t", "uint8_t", "uint8_t", "uint16_t", "uint16_t", "uint8_t", "uint8_t", "char", "char", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"navigational_status": "AIS_NAV_STATUS", "type": "AIS_TYPE", "flags": "AIS_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"lat": "degE7", "lon": "degE7", "COG": "cdeg", "heading": "cdeg", "velocity": "cm/s", "turn_rate": "cdeg/s", "dimension_bow": "m", "dimension_stern": "m", "dimension_port": "m", "dimension_starboard": "m", "tslc": "s"}
    native_format = bytearray(b"<IiiHHHHHHHbBBBBcc")
    orders = [0, 1, 2, 3, 4, 5, 10, 11, 12, 6, 7, 13, 14, 15, 16, 8, 9]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 20]
    crc_extra = 243
    unpacker = struct.Struct("<IiiHHHHHHHbBBBB7s20s")
    instance_field = None
    instance_offset = -1

    def __init__(self, MMSI: int, lat: int, lon: int, COG: int, heading: int, velocity: int, turn_rate: int, navigational_status: int, type: int, dimension_bow: int, dimension_stern: int, dimension_port: int, dimension_starboard: int, callsign: bytes, name: bytes, tslc: int, flags: int):
        MAVLink_message.__init__(self, MAVLink_ais_vessel_message.id, MAVLink_ais_vessel_message.msgname)
        self._fieldnames = MAVLink_ais_vessel_message.fieldnames
        self._instance_field = MAVLink_ais_vessel_message.instance_field
        self._instance_offset = MAVLink_ais_vessel_message.instance_offset
        self.MMSI = MMSI
        self.lat = lat
        self.lon = lon
        self.COG = COG
        self.heading = heading
        self.velocity = velocity
        self.turn_rate = turn_rate
        self.navigational_status = navigational_status
        self.type = type
        self.dimension_bow = dimension_bow
        self.dimension_stern = dimension_stern
        self.dimension_port = dimension_port
        self.dimension_starboard = dimension_starboard
        self._callsign_raw = callsign
        self.callsign = callsign.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.tslc = tslc
        self.flags = flags

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.MMSI, self.lat, self.lon, self.COG, self.heading, self.velocity, self.dimension_bow, self.dimension_stern, self.tslc, self.flags, self.turn_rate, self.navigational_status, self.type, self.dimension_port, self.dimension_starboard, self._callsign_raw, self._name_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_ais_vessel_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_uavcan_node_status_message(MAVLink_message):
    """
    General status information of an UAVCAN node. Please refer to the
    definition of the UAVCAN message "uavcan.protocol.NodeStatus" for
    the background information. The UAVCAN specification is available
    at http://uavcan.org.
    """

    id = MAVLINK_MSG_ID_UAVCAN_NODE_STATUS
    msgname = "UAVCAN_NODE_STATUS"
    fieldnames = ["time_usec", "uptime_sec", "health", "mode", "sub_mode", "vendor_specific_status_code"]
    ordered_fieldnames = ["time_usec", "uptime_sec", "vendor_specific_status_code", "health", "mode", "sub_mode"]
    fieldtypes = ["uint64_t", "uint32_t", "uint8_t", "uint8_t", "uint8_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"health": "UAVCAN_NODE_HEALTH", "mode": "UAVCAN_NODE_MODE"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "uptime_sec": "s"}
    native_format = bytearray(b"<QIHBBB")
    orders = [0, 1, 3, 4, 5, 2]
    lengths = [1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0]
    crc_extra = 28
    unpacker = struct.Struct("<QIHBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, uptime_sec: int, health: int, mode: int, sub_mode: int, vendor_specific_status_code: int):
        MAVLink_message.__init__(self, MAVLink_uavcan_node_status_message.id, MAVLink_uavcan_node_status_message.msgname)
        self._fieldnames = MAVLink_uavcan_node_status_message.fieldnames
        self._instance_field = MAVLink_uavcan_node_status_message.instance_field
        self._instance_offset = MAVLink_uavcan_node_status_message.instance_offset
        self.time_usec = time_usec
        self.uptime_sec = uptime_sec
        self.health = health
        self.mode = mode
        self.sub_mode = sub_mode
        self.vendor_specific_status_code = vendor_specific_status_code

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.uptime_sec, self.vendor_specific_status_code, self.health, self.mode, self.sub_mode), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_uavcan_node_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_uavcan_node_info_message(MAVLink_message):
    """
    General information describing a particular UAVCAN node. Please
    refer to the definition of the UAVCAN service
    "uavcan.protocol.GetNodeInfo" for the background information. This
    message should be emitted by the system whenever a new node
    appears online, or an existing node reboots. Additionally, it can
    be emitted upon request from the other end of the MAVLink channel
    (see MAV_CMD_UAVCAN_GET_NODE_INFO). It is also not prohibited to
    emit this message unconditionally at a low frequency. The UAVCAN
    specification is available at http://uavcan.org.
    """

    id = MAVLINK_MSG_ID_UAVCAN_NODE_INFO
    msgname = "UAVCAN_NODE_INFO"
    fieldnames = ["time_usec", "uptime_sec", "name", "hw_version_major", "hw_version_minor", "hw_unique_id", "sw_version_major", "sw_version_minor", "sw_vcs_commit"]
    ordered_fieldnames = ["time_usec", "uptime_sec", "sw_vcs_commit", "name", "hw_version_major", "hw_version_minor", "hw_unique_id", "sw_version_major", "sw_version_minor"]
    fieldtypes = ["uint64_t", "uint32_t", "char", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "uptime_sec": "s"}
    native_format = bytearray(b"<QIIcBBBBB")
    orders = [0, 1, 3, 4, 5, 6, 7, 8, 2]
    lengths = [1, 1, 1, 1, 1, 1, 16, 1, 1]
    array_lengths = [0, 0, 0, 80, 0, 0, 16, 0, 0]
    crc_extra = 95
    unpacker = struct.Struct("<QII80sBB16BBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, uptime_sec: int, name: bytes, hw_version_major: int, hw_version_minor: int, hw_unique_id: Sequence[int], sw_version_major: int, sw_version_minor: int, sw_vcs_commit: int):
        MAVLink_message.__init__(self, MAVLink_uavcan_node_info_message.id, MAVLink_uavcan_node_info_message.msgname)
        self._fieldnames = MAVLink_uavcan_node_info_message.fieldnames
        self._instance_field = MAVLink_uavcan_node_info_message.instance_field
        self._instance_offset = MAVLink_uavcan_node_info_message.instance_offset
        self.time_usec = time_usec
        self.uptime_sec = uptime_sec
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.hw_version_major = hw_version_major
        self.hw_version_minor = hw_version_minor
        self.hw_unique_id = hw_unique_id
        self.sw_version_major = sw_version_major
        self.sw_version_minor = sw_version_minor
        self.sw_vcs_commit = sw_vcs_commit

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.uptime_sec, self.sw_vcs_commit, self._name_raw, self.hw_version_major, self.hw_version_minor, self.hw_unique_id[0], self.hw_unique_id[1], self.hw_unique_id[2], self.hw_unique_id[3], self.hw_unique_id[4], self.hw_unique_id[5], self.hw_unique_id[6], self.hw_unique_id[7], self.hw_unique_id[8], self.hw_unique_id[9], self.hw_unique_id[10], self.hw_unique_id[11], self.hw_unique_id[12], self.hw_unique_id[13], self.hw_unique_id[14], self.hw_unique_id[15], self.sw_version_major, self.sw_version_minor), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_uavcan_node_info_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_ext_request_read_message(MAVLink_message):
    """
    Request to read the value of a parameter with either the param_id
    string id or param_index. PARAM_EXT_VALUE should be emitted in
    response.
    """

    id = MAVLINK_MSG_ID_PARAM_EXT_REQUEST_READ
    msgname = "PARAM_EXT_REQUEST_READ"
    fieldnames = ["target_system", "target_component", "param_id", "param_index"]
    ordered_fieldnames = ["param_index", "target_system", "target_component", "param_id"]
    fieldtypes = ["uint8_t", "uint8_t", "char", "int16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<hBBc")
    orders = [1, 2, 3, 0]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 16]
    crc_extra = 243
    unpacker = struct.Struct("<hBB16s")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, param_id: bytes, param_index: int):
        MAVLink_message.__init__(self, MAVLink_param_ext_request_read_message.id, MAVLink_param_ext_request_read_message.msgname)
        self._fieldnames = MAVLink_param_ext_request_read_message.fieldnames
        self._instance_field = MAVLink_param_ext_request_read_message.instance_field
        self._instance_offset = MAVLink_param_ext_request_read_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self._param_id_raw = param_id
        self.param_id = param_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.param_index = param_index

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param_index, self.target_system, self.target_component, self._param_id_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_ext_request_read_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_ext_request_list_message(MAVLink_message):
    """
    Request all parameters of this component. All parameters should be
    emitted in response as PARAM_EXT_VALUE.
    """

    id = MAVLINK_MSG_ID_PARAM_EXT_REQUEST_LIST
    msgname = "PARAM_EXT_REQUEST_LIST"
    fieldnames = ["target_system", "target_component"]
    ordered_fieldnames = ["target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BB")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 88
    unpacker = struct.Struct("<BB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int):
        MAVLink_message.__init__(self, MAVLink_param_ext_request_list_message.id, MAVLink_param_ext_request_list_message.msgname)
        self._fieldnames = MAVLink_param_ext_request_list_message.fieldnames
        self._instance_field = MAVLink_param_ext_request_list_message.instance_field
        self._instance_offset = MAVLink_param_ext_request_list_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_ext_request_list_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_ext_value_message(MAVLink_message):
    """
    Emit the value of a parameter. The inclusion of param_count and
    param_index in the message allows the recipient to keep track of
    received parameters and allows them to re-request missing
    parameters after a loss or timeout.
    """

    id = MAVLINK_MSG_ID_PARAM_EXT_VALUE
    msgname = "PARAM_EXT_VALUE"
    fieldnames = ["param_id", "param_value", "param_type", "param_count", "param_index"]
    ordered_fieldnames = ["param_count", "param_index", "param_id", "param_value", "param_type"]
    fieldtypes = ["char", "char", "uint8_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"param_type": "MAV_PARAM_EXT_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HHccB")
    orders = [2, 3, 4, 0, 1]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 16, 128, 0]
    crc_extra = 243
    unpacker = struct.Struct("<HH16s128sB")
    instance_field = None
    instance_offset = -1

    def __init__(self, param_id: bytes, param_value: bytes, param_type: int, param_count: int, param_index: int):
        MAVLink_message.__init__(self, MAVLink_param_ext_value_message.id, MAVLink_param_ext_value_message.msgname)
        self._fieldnames = MAVLink_param_ext_value_message.fieldnames
        self._instance_field = MAVLink_param_ext_value_message.instance_field
        self._instance_offset = MAVLink_param_ext_value_message.instance_offset
        self._param_id_raw = param_id
        self.param_id = param_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._param_value_raw = param_value
        self.param_value = param_value.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.param_type = param_type
        self.param_count = param_count
        self.param_index = param_index

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param_count, self.param_index, self._param_id_raw, self._param_value_raw, self.param_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_ext_value_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_ext_set_message(MAVLink_message):
    """
    Set a parameter value. In order to deal with message loss (and
    retransmission of PARAM_EXT_SET), when setting a parameter value
    and the new value is the same as the current value, you will
    immediately get a PARAM_ACK_ACCEPTED response. If the current
    state is PARAM_ACK_IN_PROGRESS, you will accordingly receive a
    PARAM_ACK_IN_PROGRESS in response.
    """

    id = MAVLINK_MSG_ID_PARAM_EXT_SET
    msgname = "PARAM_EXT_SET"
    fieldnames = ["target_system", "target_component", "param_id", "param_value", "param_type"]
    ordered_fieldnames = ["target_system", "target_component", "param_id", "param_value", "param_type"]
    fieldtypes = ["uint8_t", "uint8_t", "char", "char", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"param_type": "MAV_PARAM_EXT_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBccB")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 1, 1, 1]
    array_lengths = [0, 0, 16, 128, 0]
    crc_extra = 78
    unpacker = struct.Struct("<BB16s128sB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, param_id: bytes, param_value: bytes, param_type: int):
        MAVLink_message.__init__(self, MAVLink_param_ext_set_message.id, MAVLink_param_ext_set_message.msgname)
        self._fieldnames = MAVLink_param_ext_set_message.fieldnames
        self._instance_field = MAVLink_param_ext_set_message.instance_field
        self._instance_offset = MAVLink_param_ext_set_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self._param_id_raw = param_id
        self.param_id = param_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._param_value_raw = param_value
        self.param_value = param_value.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.param_type = param_type

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self._param_id_raw, self._param_value_raw, self.param_type), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_ext_set_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_param_ext_ack_message(MAVLink_message):
    """
    Response from a PARAM_EXT_SET message.
    """

    id = MAVLINK_MSG_ID_PARAM_EXT_ACK
    msgname = "PARAM_EXT_ACK"
    fieldnames = ["param_id", "param_value", "param_type", "param_result"]
    ordered_fieldnames = ["param_id", "param_value", "param_type", "param_result"]
    fieldtypes = ["char", "char", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"param_type": "MAV_PARAM_EXT_TYPE", "param_result": "PARAM_ACK"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<ccBB")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [16, 128, 0, 0]
    crc_extra = 132
    unpacker = struct.Struct("<16s128sBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, param_id: bytes, param_value: bytes, param_type: int, param_result: int):
        MAVLink_message.__init__(self, MAVLink_param_ext_ack_message.id, MAVLink_param_ext_ack_message.msgname)
        self._fieldnames = MAVLink_param_ext_ack_message.fieldnames
        self._instance_field = MAVLink_param_ext_ack_message.instance_field
        self._instance_offset = MAVLink_param_ext_ack_message.instance_offset
        self._param_id_raw = param_id
        self.param_id = param_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._param_value_raw = param_value
        self.param_value = param_value.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.param_type = param_type
        self.param_result = param_result

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self._param_id_raw, self._param_value_raw, self.param_type, self.param_result), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_param_ext_ack_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_obstacle_distance_message(MAVLink_message):
    """
    Obstacle distances in front of the sensor, starting from the left
    in increment degrees to the right
    """

    id = MAVLINK_MSG_ID_OBSTACLE_DISTANCE
    msgname = "OBSTACLE_DISTANCE"
    fieldnames = ["time_usec", "sensor_type", "distances", "increment", "min_distance", "max_distance", "increment_f", "angle_offset", "frame"]
    ordered_fieldnames = ["time_usec", "distances", "min_distance", "max_distance", "sensor_type", "increment", "increment_f", "angle_offset", "frame"]
    fieldtypes = ["uint64_t", "uint8_t", "uint16_t", "uint8_t", "uint16_t", "uint16_t", "float", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"sensor_type": "MAV_DISTANCE_SENSOR", "frame": "MAV_FRAME"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "distances": "cm", "increment": "deg", "min_distance": "cm", "max_distance": "cm", "increment_f": "deg", "angle_offset": "deg"}
    native_format = bytearray(b"<QHHHBBffB")
    orders = [0, 4, 1, 5, 2, 3, 6, 7, 8]
    lengths = [1, 72, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 72, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 23
    unpacker = struct.Struct("<Q72HHHBBffB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, sensor_type: int, distances: Sequence[int], increment: int, min_distance: int, max_distance: int, increment_f: float = 0, angle_offset: float = 0, frame: int = 0):
        MAVLink_message.__init__(self, MAVLink_obstacle_distance_message.id, MAVLink_obstacle_distance_message.msgname)
        self._fieldnames = MAVLink_obstacle_distance_message.fieldnames
        self._instance_field = MAVLink_obstacle_distance_message.instance_field
        self._instance_offset = MAVLink_obstacle_distance_message.instance_offset
        self.time_usec = time_usec
        self.sensor_type = sensor_type
        self.distances = distances
        self.increment = increment
        self.min_distance = min_distance
        self.max_distance = max_distance
        self.increment_f = increment_f
        self.angle_offset = angle_offset
        self.frame = frame

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.distances[0], self.distances[1], self.distances[2], self.distances[3], self.distances[4], self.distances[5], self.distances[6], self.distances[7], self.distances[8], self.distances[9], self.distances[10], self.distances[11], self.distances[12], self.distances[13], self.distances[14], self.distances[15], self.distances[16], self.distances[17], self.distances[18], self.distances[19], self.distances[20], self.distances[21], self.distances[22], self.distances[23], self.distances[24], self.distances[25], self.distances[26], self.distances[27], self.distances[28], self.distances[29], self.distances[30], self.distances[31], self.distances[32], self.distances[33], self.distances[34], self.distances[35], self.distances[36], self.distances[37], self.distances[38], self.distances[39], self.distances[40], self.distances[41], self.distances[42], self.distances[43], self.distances[44], self.distances[45], self.distances[46], self.distances[47], self.distances[48], self.distances[49], self.distances[50], self.distances[51], self.distances[52], self.distances[53], self.distances[54], self.distances[55], self.distances[56], self.distances[57], self.distances[58], self.distances[59], self.distances[60], self.distances[61], self.distances[62], self.distances[63], self.distances[64], self.distances[65], self.distances[66], self.distances[67], self.distances[68], self.distances[69], self.distances[70], self.distances[71], self.min_distance, self.max_distance, self.sensor_type, self.increment, self.increment_f, self.angle_offset, self.frame), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_obstacle_distance_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_odometry_message(MAVLink_message):
    """
    Odometry message to communicate odometry information with an
    external interface. Fits ROS REP 147 standard for aerial vehicles
    (http://www.ros.org/reps/rep-0147.html).
    """

    id = MAVLINK_MSG_ID_ODOMETRY
    msgname = "ODOMETRY"
    fieldnames = ["time_usec", "frame_id", "child_frame_id", "x", "y", "z", "q", "vx", "vy", "vz", "rollspeed", "pitchspeed", "yawspeed", "pose_covariance", "velocity_covariance", "reset_counter", "estimator_type", "quality"]
    ordered_fieldnames = ["time_usec", "x", "y", "z", "q", "vx", "vy", "vz", "rollspeed", "pitchspeed", "yawspeed", "pose_covariance", "velocity_covariance", "frame_id", "child_frame_id", "reset_counter", "estimator_type", "quality"]
    fieldtypes = ["uint64_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "uint8_t", "uint8_t", "int8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"frame_id": "MAV_FRAME", "child_frame_id": "MAV_FRAME", "estimator_type": "MAV_ESTIMATOR_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "x": "m", "y": "m", "z": "m", "vx": "m/s", "vy": "m/s", "vz": "m/s", "rollspeed": "rad/s", "pitchspeed": "rad/s", "yawspeed": "rad/s", "quality": "%"}
    native_format = bytearray(b"<QffffffffffffBBBBb")
    orders = [0, 13, 14, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16, 17]
    lengths = [1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 21, 21, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 21, 21, 0, 0, 0, 0, 0]
    crc_extra = 91
    unpacker = struct.Struct("<Qfff4fffffff21f21fBBBBb")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, frame_id: int, child_frame_id: int, x: float, y: float, z: float, q: Sequence[float], vx: float, vy: float, vz: float, rollspeed: float, pitchspeed: float, yawspeed: float, pose_covariance: Sequence[float], velocity_covariance: Sequence[float], reset_counter: int = 0, estimator_type: int = 0, quality: int = 0):
        MAVLink_message.__init__(self, MAVLink_odometry_message.id, MAVLink_odometry_message.msgname)
        self._fieldnames = MAVLink_odometry_message.fieldnames
        self._instance_field = MAVLink_odometry_message.instance_field
        self._instance_offset = MAVLink_odometry_message.instance_offset
        self.time_usec = time_usec
        self.frame_id = frame_id
        self.child_frame_id = child_frame_id
        self.x = x
        self.y = y
        self.z = z
        self.q = q
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.rollspeed = rollspeed
        self.pitchspeed = pitchspeed
        self.yawspeed = yawspeed
        self.pose_covariance = pose_covariance
        self.velocity_covariance = velocity_covariance
        self.reset_counter = reset_counter
        self.estimator_type = estimator_type
        self.quality = quality

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.x, self.y, self.z, self.q[0], self.q[1], self.q[2], self.q[3], self.vx, self.vy, self.vz, self.rollspeed, self.pitchspeed, self.yawspeed, self.pose_covariance[0], self.pose_covariance[1], self.pose_covariance[2], self.pose_covariance[3], self.pose_covariance[4], self.pose_covariance[5], self.pose_covariance[6], self.pose_covariance[7], self.pose_covariance[8], self.pose_covariance[9], self.pose_covariance[10], self.pose_covariance[11], self.pose_covariance[12], self.pose_covariance[13], self.pose_covariance[14], self.pose_covariance[15], self.pose_covariance[16], self.pose_covariance[17], self.pose_covariance[18], self.pose_covariance[19], self.pose_covariance[20], self.velocity_covariance[0], self.velocity_covariance[1], self.velocity_covariance[2], self.velocity_covariance[3], self.velocity_covariance[4], self.velocity_covariance[5], self.velocity_covariance[6], self.velocity_covariance[7], self.velocity_covariance[8], self.velocity_covariance[9], self.velocity_covariance[10], self.velocity_covariance[11], self.velocity_covariance[12], self.velocity_covariance[13], self.velocity_covariance[14], self.velocity_covariance[15], self.velocity_covariance[16], self.velocity_covariance[17], self.velocity_covariance[18], self.velocity_covariance[19], self.velocity_covariance[20], self.frame_id, self.child_frame_id, self.reset_counter, self.estimator_type, self.quality), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_odometry_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_trajectory_representation_waypoints_message(MAVLink_message):
    """
    Describe a trajectory using an array of up-to 5 waypoints in the
    local frame (MAV_FRAME_LOCAL_NED).
    """

    id = MAVLINK_MSG_ID_TRAJECTORY_REPRESENTATION_WAYPOINTS
    msgname = "TRAJECTORY_REPRESENTATION_WAYPOINTS"
    fieldnames = ["time_usec", "valid_points", "pos_x", "pos_y", "pos_z", "vel_x", "vel_y", "vel_z", "acc_x", "acc_y", "acc_z", "pos_yaw", "vel_yaw", "command"]
    ordered_fieldnames = ["time_usec", "pos_x", "pos_y", "pos_z", "vel_x", "vel_y", "vel_z", "acc_x", "acc_y", "acc_z", "pos_yaw", "vel_yaw", "command", "valid_points"]
    fieldtypes = ["uint64_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "float", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"command": "MAV_CMD"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "pos_x": "m", "pos_y": "m", "pos_z": "m", "vel_x": "m/s", "vel_y": "m/s", "vel_z": "m/s", "acc_x": "m/s/s", "acc_y": "m/s/s", "acc_z": "m/s/s", "pos_yaw": "rad", "vel_yaw": "rad/s"}
    native_format = bytearray(b"<QfffffffffffHB")
    orders = [0, 13, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
    lengths = [1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1]
    array_lengths = [0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0]
    crc_extra = 236
    unpacker = struct.Struct("<Q5f5f5f5f5f5f5f5f5f5f5f5HB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, valid_points: int, pos_x: Sequence[float], pos_y: Sequence[float], pos_z: Sequence[float], vel_x: Sequence[float], vel_y: Sequence[float], vel_z: Sequence[float], acc_x: Sequence[float], acc_y: Sequence[float], acc_z: Sequence[float], pos_yaw: Sequence[float], vel_yaw: Sequence[float], command: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_trajectory_representation_waypoints_message.id, MAVLink_trajectory_representation_waypoints_message.msgname)
        self._fieldnames = MAVLink_trajectory_representation_waypoints_message.fieldnames
        self._instance_field = MAVLink_trajectory_representation_waypoints_message.instance_field
        self._instance_offset = MAVLink_trajectory_representation_waypoints_message.instance_offset
        self.time_usec = time_usec
        self.valid_points = valid_points
        self.pos_x = pos_x
        self.pos_y = pos_y
        self.pos_z = pos_z
        self.vel_x = vel_x
        self.vel_y = vel_y
        self.vel_z = vel_z
        self.acc_x = acc_x
        self.acc_y = acc_y
        self.acc_z = acc_z
        self.pos_yaw = pos_yaw
        self.vel_yaw = vel_yaw
        self.command = command

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.pos_x[0], self.pos_x[1], self.pos_x[2], self.pos_x[3], self.pos_x[4], self.pos_y[0], self.pos_y[1], self.pos_y[2], self.pos_y[3], self.pos_y[4], self.pos_z[0], self.pos_z[1], self.pos_z[2], self.pos_z[3], self.pos_z[4], self.vel_x[0], self.vel_x[1], self.vel_x[2], self.vel_x[3], self.vel_x[4], self.vel_y[0], self.vel_y[1], self.vel_y[2], self.vel_y[3], self.vel_y[4], self.vel_z[0], self.vel_z[1], self.vel_z[2], self.vel_z[3], self.vel_z[4], self.acc_x[0], self.acc_x[1], self.acc_x[2], self.acc_x[3], self.acc_x[4], self.acc_y[0], self.acc_y[1], self.acc_y[2], self.acc_y[3], self.acc_y[4], self.acc_z[0], self.acc_z[1], self.acc_z[2], self.acc_z[3], self.acc_z[4], self.pos_yaw[0], self.pos_yaw[1], self.pos_yaw[2], self.pos_yaw[3], self.pos_yaw[4], self.vel_yaw[0], self.vel_yaw[1], self.vel_yaw[2], self.vel_yaw[3], self.vel_yaw[4], self.command[0], self.command[1], self.command[2], self.command[3], self.command[4], self.valid_points), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_trajectory_representation_waypoints_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_trajectory_representation_bezier_message(MAVLink_message):
    """
    Describe a trajectory using an array of up-to 5 bezier control
    points in the local frame (MAV_FRAME_LOCAL_NED).
    """

    id = MAVLINK_MSG_ID_TRAJECTORY_REPRESENTATION_BEZIER
    msgname = "TRAJECTORY_REPRESENTATION_BEZIER"
    fieldnames = ["time_usec", "valid_points", "pos_x", "pos_y", "pos_z", "delta", "pos_yaw"]
    ordered_fieldnames = ["time_usec", "pos_x", "pos_y", "pos_z", "delta", "pos_yaw", "valid_points"]
    fieldtypes = ["uint64_t", "uint8_t", "float", "float", "float", "float", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "pos_x": "m", "pos_y": "m", "pos_z": "m", "delta": "s", "pos_yaw": "rad"}
    native_format = bytearray(b"<QfffffB")
    orders = [0, 6, 1, 2, 3, 4, 5]
    lengths = [1, 5, 5, 5, 5, 5, 1]
    array_lengths = [0, 5, 5, 5, 5, 5, 0]
    crc_extra = 231
    unpacker = struct.Struct("<Q5f5f5f5f5fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, valid_points: int, pos_x: Sequence[float], pos_y: Sequence[float], pos_z: Sequence[float], delta: Sequence[float], pos_yaw: Sequence[float]):
        MAVLink_message.__init__(self, MAVLink_trajectory_representation_bezier_message.id, MAVLink_trajectory_representation_bezier_message.msgname)
        self._fieldnames = MAVLink_trajectory_representation_bezier_message.fieldnames
        self._instance_field = MAVLink_trajectory_representation_bezier_message.instance_field
        self._instance_offset = MAVLink_trajectory_representation_bezier_message.instance_offset
        self.time_usec = time_usec
        self.valid_points = valid_points
        self.pos_x = pos_x
        self.pos_y = pos_y
        self.pos_z = pos_z
        self.delta = delta
        self.pos_yaw = pos_yaw

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.pos_x[0], self.pos_x[1], self.pos_x[2], self.pos_x[3], self.pos_x[4], self.pos_y[0], self.pos_y[1], self.pos_y[2], self.pos_y[3], self.pos_y[4], self.pos_z[0], self.pos_z[1], self.pos_z[2], self.pos_z[3], self.pos_z[4], self.delta[0], self.delta[1], self.delta[2], self.delta[3], self.delta[4], self.pos_yaw[0], self.pos_yaw[1], self.pos_yaw[2], self.pos_yaw[3], self.pos_yaw[4], self.valid_points), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_trajectory_representation_bezier_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_isbd_link_status_message(MAVLink_message):
    """
    Status of the Iridium SBD link.
    """

    id = MAVLINK_MSG_ID_ISBD_LINK_STATUS
    msgname = "ISBD_LINK_STATUS"
    fieldnames = ["timestamp", "last_heartbeat", "failed_sessions", "successful_sessions", "signal_quality", "ring_pending", "tx_session_pending", "rx_session_pending"]
    ordered_fieldnames = ["timestamp", "last_heartbeat", "failed_sessions", "successful_sessions", "signal_quality", "ring_pending", "tx_session_pending", "rx_session_pending"]
    fieldtypes = ["uint64_t", "uint64_t", "uint16_t", "uint16_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"timestamp": "us", "last_heartbeat": "us"}
    native_format = bytearray(b"<QQHHBBBB")
    orders = [0, 1, 2, 3, 4, 5, 6, 7]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 225
    unpacker = struct.Struct("<QQHHBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, timestamp: int, last_heartbeat: int, failed_sessions: int, successful_sessions: int, signal_quality: int, ring_pending: int, tx_session_pending: int, rx_session_pending: int):
        MAVLink_message.__init__(self, MAVLink_isbd_link_status_message.id, MAVLink_isbd_link_status_message.msgname)
        self._fieldnames = MAVLink_isbd_link_status_message.fieldnames
        self._instance_field = MAVLink_isbd_link_status_message.instance_field
        self._instance_offset = MAVLink_isbd_link_status_message.instance_offset
        self.timestamp = timestamp
        self.last_heartbeat = last_heartbeat
        self.failed_sessions = failed_sessions
        self.successful_sessions = successful_sessions
        self.signal_quality = signal_quality
        self.ring_pending = ring_pending
        self.tx_session_pending = tx_session_pending
        self.rx_session_pending = rx_session_pending

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.timestamp, self.last_heartbeat, self.failed_sessions, self.successful_sessions, self.signal_quality, self.ring_pending, self.tx_session_pending, self.rx_session_pending), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_isbd_link_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_raw_rpm_message(MAVLink_message):
    """
    RPM sensor data message.
    """

    id = MAVLINK_MSG_ID_RAW_RPM
    msgname = "RAW_RPM"
    fieldnames = ["index", "frequency"]
    ordered_fieldnames = ["frequency", "index"]
    fieldtypes = ["uint8_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"frequency": "rpm"}
    native_format = bytearray(b"<fB")
    orders = [1, 0]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 199
    unpacker = struct.Struct("<fB")
    instance_field = None
    instance_offset = -1

    def __init__(self, index: int, frequency: float):
        MAVLink_message.__init__(self, MAVLink_raw_rpm_message.id, MAVLink_raw_rpm_message.msgname)
        self._fieldnames = MAVLink_raw_rpm_message.fieldnames
        self._instance_field = MAVLink_raw_rpm_message.instance_field
        self._instance_offset = MAVLink_raw_rpm_message.instance_offset
        self.index = index
        self.frequency = frequency

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.frequency, self.index), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_raw_rpm_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_utm_global_position_message(MAVLink_message):
    """
    The global position resulting from GPS and sensor fusion.
    """

    id = MAVLINK_MSG_ID_UTM_GLOBAL_POSITION
    msgname = "UTM_GLOBAL_POSITION"
    fieldnames = ["time", "uas_id", "lat", "lon", "alt", "relative_alt", "vx", "vy", "vz", "h_acc", "v_acc", "vel_acc", "next_lat", "next_lon", "next_alt", "update_rate", "flight_state", "flags"]
    ordered_fieldnames = ["time", "lat", "lon", "alt", "relative_alt", "next_lat", "next_lon", "next_alt", "vx", "vy", "vz", "h_acc", "v_acc", "vel_acc", "update_rate", "uas_id", "flight_state", "flags"]
    fieldtypes = ["uint64_t", "uint8_t", "int32_t", "int32_t", "int32_t", "int32_t", "int16_t", "int16_t", "int16_t", "uint16_t", "uint16_t", "uint16_t", "int32_t", "int32_t", "int32_t", "uint16_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"flags": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"flight_state": "UTM_FLIGHT_STATE", "flags": "UTM_DATA_AVAIL_FLAGS"}
    fieldunits_by_name: Dict[str, str] = {"time": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "relative_alt": "mm", "vx": "cm/s", "vy": "cm/s", "vz": "cm/s", "h_acc": "mm", "v_acc": "mm", "vel_acc": "cm/s", "next_lat": "degE7", "next_lon": "degE7", "next_alt": "mm", "update_rate": "cs"}
    native_format = bytearray(b"<QiiiiiiihhhHHHHBBB")
    orders = [0, 15, 1, 2, 3, 4, 8, 9, 10, 11, 12, 13, 5, 6, 7, 14, 16, 17]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 18, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0]
    crc_extra = 99
    unpacker = struct.Struct("<QiiiiiiihhhHHHH18BBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time: int, uas_id: Sequence[int], lat: int, lon: int, alt: int, relative_alt: int, vx: int, vy: int, vz: int, h_acc: int, v_acc: int, vel_acc: int, next_lat: int, next_lon: int, next_alt: int, update_rate: int, flight_state: int, flags: int):
        MAVLink_message.__init__(self, MAVLink_utm_global_position_message.id, MAVLink_utm_global_position_message.msgname)
        self._fieldnames = MAVLink_utm_global_position_message.fieldnames
        self._instance_field = MAVLink_utm_global_position_message.instance_field
        self._instance_offset = MAVLink_utm_global_position_message.instance_offset
        self.time = time
        self.uas_id = uas_id
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.relative_alt = relative_alt
        self.vx = vx
        self.vy = vy
        self.vz = vz
        self.h_acc = h_acc
        self.v_acc = v_acc
        self.vel_acc = vel_acc
        self.next_lat = next_lat
        self.next_lon = next_lon
        self.next_alt = next_alt
        self.update_rate = update_rate
        self.flight_state = flight_state
        self.flags = flags

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time, self.lat, self.lon, self.alt, self.relative_alt, self.next_lat, self.next_lon, self.next_alt, self.vx, self.vy, self.vz, self.h_acc, self.v_acc, self.vel_acc, self.update_rate, self.uas_id[0], self.uas_id[1], self.uas_id[2], self.uas_id[3], self.uas_id[4], self.uas_id[5], self.uas_id[6], self.uas_id[7], self.uas_id[8], self.uas_id[9], self.uas_id[10], self.uas_id[11], self.uas_id[12], self.uas_id[13], self.uas_id[14], self.uas_id[15], self.uas_id[16], self.uas_id[17], self.flight_state, self.flags), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_utm_global_position_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_debug_float_array_message(MAVLink_message):
    """
    Large debug/prototyping array. The message uses the maximum
    available payload for data. The array_id and name fields are used
    to discriminate between messages in code and in user interfaces
    (respectively). Do not use in production code.
    """

    id = MAVLINK_MSG_ID_DEBUG_FLOAT_ARRAY
    msgname = "DEBUG_FLOAT_ARRAY"
    fieldnames = ["time_usec", "name", "array_id", "data"]
    ordered_fieldnames = ["time_usec", "array_id", "name", "data"]
    fieldtypes = ["uint64_t", "char", "uint16_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QHcf")
    orders = [0, 2, 1, 3]
    lengths = [1, 1, 1, 58]
    array_lengths = [0, 0, 10, 58]
    crc_extra = 232
    unpacker = struct.Struct("<QH10s58f")
    instance_field = "array_id"
    instance_offset = 8

    def __init__(self, time_usec: int, name: bytes, array_id: int, data: Sequence[float] = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)):
        MAVLink_message.__init__(self, MAVLink_debug_float_array_message.id, MAVLink_debug_float_array_message.msgname)
        self._fieldnames = MAVLink_debug_float_array_message.fieldnames
        self._instance_field = MAVLink_debug_float_array_message.instance_field
        self._instance_offset = MAVLink_debug_float_array_message.instance_offset
        self.time_usec = time_usec
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.array_id = array_id
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.array_id, self._name_raw, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_debug_float_array_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_smart_battery_info_message(MAVLink_message):
    """
    Smart Battery information (static/infrequent update). Use for
    updates from: smart battery to flight stack, flight stack to GCS.
    Use BATTERY_STATUS for smart battery frequent updates.
    """

    id = MAVLINK_MSG_ID_SMART_BATTERY_INFO
    msgname = "SMART_BATTERY_INFO"
    fieldnames = ["id", "battery_function", "type", "capacity_full_specification", "capacity_full", "cycle_count", "serial_number", "device_name", "weight", "discharge_minimum_voltage", "charging_minimum_voltage", "resting_minimum_voltage", "charging_maximum_voltage", "cells_in_series", "discharge_maximum_current", "discharge_maximum_burst_current", "manufacture_date"]
    ordered_fieldnames = ["capacity_full_specification", "capacity_full", "cycle_count", "weight", "discharge_minimum_voltage", "charging_minimum_voltage", "resting_minimum_voltage", "id", "battery_function", "type", "serial_number", "device_name", "charging_maximum_voltage", "cells_in_series", "discharge_maximum_current", "discharge_maximum_burst_current", "manufacture_date"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "int32_t", "int32_t", "uint16_t", "char", "char", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t", "uint32_t", "uint32_t", "char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"battery_function": "MAV_BATTERY_FUNCTION", "type": "MAV_BATTERY_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"capacity_full_specification": "mAh", "capacity_full": "mAh", "weight": "g", "discharge_minimum_voltage": "mV", "charging_minimum_voltage": "mV", "resting_minimum_voltage": "mV", "charging_maximum_voltage": "mV", "discharge_maximum_current": "mA", "discharge_maximum_burst_current": "mA"}
    native_format = bytearray(b"<iiHHHHHBBBccHBIIc")
    orders = [7, 8, 9, 0, 1, 2, 10, 11, 3, 4, 5, 6, 12, 13, 14, 15, 16]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 50, 0, 0, 0, 0, 11]
    crc_extra = 75
    unpacker = struct.Struct("<iiHHHHHBBB16s50sHBII11s")
    instance_field = "id"
    instance_offset = 18

    def __init__(self, id: int, battery_function: int, type: int, capacity_full_specification: int, capacity_full: int, cycle_count: int, serial_number: bytes, device_name: bytes, weight: int, discharge_minimum_voltage: int, charging_minimum_voltage: int, resting_minimum_voltage: int, charging_maximum_voltage: int = 0, cells_in_series: int = 0, discharge_maximum_current: int = 0, discharge_maximum_burst_current: int = 0, manufacture_date: bytes = b""):
        MAVLink_message.__init__(self, MAVLink_smart_battery_info_message.id, MAVLink_smart_battery_info_message.msgname)
        self._fieldnames = MAVLink_smart_battery_info_message.fieldnames
        self._instance_field = MAVLink_smart_battery_info_message.instance_field
        self._instance_offset = MAVLink_smart_battery_info_message.instance_offset
        self.id = id
        self.battery_function = battery_function
        self.type = type
        self.capacity_full_specification = capacity_full_specification
        self.capacity_full = capacity_full
        self.cycle_count = cycle_count
        self._serial_number_raw = serial_number
        self.serial_number = serial_number.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self._device_name_raw = device_name
        self.device_name = device_name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.weight = weight
        self.discharge_minimum_voltage = discharge_minimum_voltage
        self.charging_minimum_voltage = charging_minimum_voltage
        self.resting_minimum_voltage = resting_minimum_voltage
        self.charging_maximum_voltage = charging_maximum_voltage
        self.cells_in_series = cells_in_series
        self.discharge_maximum_current = discharge_maximum_current
        self.discharge_maximum_burst_current = discharge_maximum_burst_current
        self._manufacture_date_raw = manufacture_date
        self.manufacture_date = manufacture_date.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.capacity_full_specification, self.capacity_full, self.cycle_count, self.weight, self.discharge_minimum_voltage, self.charging_minimum_voltage, self.resting_minimum_voltage, self.id, self.battery_function, self.type, self._serial_number_raw, self._device_name_raw, self.charging_maximum_voltage, self.cells_in_series, self.discharge_maximum_current, self.discharge_maximum_burst_current, self._manufacture_date_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_smart_battery_info_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_generator_status_message(MAVLink_message):
    """
    Telemetry of power generation system. Alternator or mechanical
    generator.
    """

    id = MAVLINK_MSG_ID_GENERATOR_STATUS
    msgname = "GENERATOR_STATUS"
    fieldnames = ["status", "generator_speed", "battery_current", "load_current", "power_generated", "bus_voltage", "rectifier_temperature", "bat_current_setpoint", "generator_temperature", "runtime", "time_until_maintenance"]
    ordered_fieldnames = ["status", "battery_current", "load_current", "power_generated", "bus_voltage", "bat_current_setpoint", "runtime", "time_until_maintenance", "generator_speed", "rectifier_temperature", "generator_temperature"]
    fieldtypes = ["uint64_t", "uint16_t", "float", "float", "float", "float", "int16_t", "float", "int16_t", "uint32_t", "int32_t"]
    fielddisplays_by_name: Dict[str, str] = {"status": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"status": "MAV_GENERATOR_STATUS_FLAG"}
    fieldunits_by_name: Dict[str, str] = {"generator_speed": "rpm", "battery_current": "A", "load_current": "A", "power_generated": "W", "bus_voltage": "V", "rectifier_temperature": "degC", "bat_current_setpoint": "A", "generator_temperature": "degC", "runtime": "s", "time_until_maintenance": "s"}
    native_format = bytearray(b"<QfffffIiHhh")
    orders = [0, 8, 1, 2, 3, 4, 9, 5, 10, 6, 7]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 117
    unpacker = struct.Struct("<QfffffIiHhh")
    instance_field = None
    instance_offset = -1

    def __init__(self, status: int, generator_speed: int, battery_current: float, load_current: float, power_generated: float, bus_voltage: float, rectifier_temperature: int, bat_current_setpoint: float, generator_temperature: int, runtime: int, time_until_maintenance: int):
        MAVLink_message.__init__(self, MAVLink_generator_status_message.id, MAVLink_generator_status_message.msgname)
        self._fieldnames = MAVLink_generator_status_message.fieldnames
        self._instance_field = MAVLink_generator_status_message.instance_field
        self._instance_offset = MAVLink_generator_status_message.instance_offset
        self.status = status
        self.generator_speed = generator_speed
        self.battery_current = battery_current
        self.load_current = load_current
        self.power_generated = power_generated
        self.bus_voltage = bus_voltage
        self.rectifier_temperature = rectifier_temperature
        self.bat_current_setpoint = bat_current_setpoint
        self.generator_temperature = generator_temperature
        self.runtime = runtime
        self.time_until_maintenance = time_until_maintenance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.status, self.battery_current, self.load_current, self.power_generated, self.bus_voltage, self.bat_current_setpoint, self.runtime, self.time_until_maintenance, self.generator_speed, self.rectifier_temperature, self.generator_temperature), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_generator_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_actuator_output_status_message(MAVLink_message):
    """
    The raw values of the actuator outputs (e.g. on Pixhawk, from
    MAIN, AUX ports). This message supersedes SERVO_OUTPUT_RAW.
    """

    id = MAVLINK_MSG_ID_ACTUATOR_OUTPUT_STATUS
    msgname = "ACTUATOR_OUTPUT_STATUS"
    fieldnames = ["time_usec", "active", "actuator"]
    ordered_fieldnames = ["time_usec", "active", "actuator"]
    fieldtypes = ["uint64_t", "uint32_t", "float"]
    fielddisplays_by_name: Dict[str, str] = {"active": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us"}
    native_format = bytearray(b"<QIf")
    orders = [0, 1, 2]
    lengths = [1, 1, 32]
    array_lengths = [0, 0, 32]
    crc_extra = 251
    unpacker = struct.Struct("<QI32f")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, active: int, actuator: Sequence[float]):
        MAVLink_message.__init__(self, MAVLink_actuator_output_status_message.id, MAVLink_actuator_output_status_message.msgname)
        self._fieldnames = MAVLink_actuator_output_status_message.fieldnames
        self._instance_field = MAVLink_actuator_output_status_message.instance_field
        self._instance_offset = MAVLink_actuator_output_status_message.instance_offset
        self.time_usec = time_usec
        self.active = active
        self.actuator = actuator

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.active, self.actuator[0], self.actuator[1], self.actuator[2], self.actuator[3], self.actuator[4], self.actuator[5], self.actuator[6], self.actuator[7], self.actuator[8], self.actuator[9], self.actuator[10], self.actuator[11], self.actuator[12], self.actuator[13], self.actuator[14], self.actuator[15], self.actuator[16], self.actuator[17], self.actuator[18], self.actuator[19], self.actuator[20], self.actuator[21], self.actuator[22], self.actuator[23], self.actuator[24], self.actuator[25], self.actuator[26], self.actuator[27], self.actuator[28], self.actuator[29], self.actuator[30], self.actuator[31]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_actuator_output_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_relay_status_message(MAVLink_message):
    """
    Reports the on/off state of relays, as controlled by
    MAV_CMD_DO_SET_RELAY.
    """

    id = MAVLINK_MSG_ID_RELAY_STATUS
    msgname = "RELAY_STATUS"
    fieldnames = ["time_boot_ms", "on", "present"]
    ordered_fieldnames = ["time_boot_ms", "on", "present"]
    fieldtypes = ["uint32_t", "uint16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {"on": "bitmask", "present": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<IHH")
    orders = [0, 1, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 199
    unpacker = struct.Struct("<IHH")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_boot_ms: int, on: int, present: int):
        MAVLink_message.__init__(self, MAVLink_relay_status_message.id, MAVLink_relay_status_message.msgname)
        self._fieldnames = MAVLink_relay_status_message.fieldnames
        self._instance_field = MAVLink_relay_status_message.instance_field
        self._instance_offset = MAVLink_relay_status_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self.on = on
        self.present = present

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.on, self.present), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_relay_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_tunnel_message(MAVLink_message):
    """
    Message for transporting "arbitrary" variable-length data from one
    component to another (broadcast is not forbidden, but
    discouraged). The encoding of the data is usually extension
    specific, i.e. determined by the source, and is usually not
    documented as part of the MAVLink specification.
    """

    id = MAVLINK_MSG_ID_TUNNEL
    msgname = "TUNNEL"
    fieldnames = ["target_system", "target_component", "payload_type", "payload_length", "payload"]
    ordered_fieldnames = ["payload_type", "target_system", "target_component", "payload_length", "payload"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"payload_type": "MAV_TUNNEL_PAYLOAD_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBBBB")
    orders = [1, 2, 0, 3, 4]
    lengths = [1, 1, 1, 1, 128]
    array_lengths = [0, 0, 0, 0, 128]
    crc_extra = 147
    unpacker = struct.Struct("<HBBB128B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, payload_type: int, payload_length: int, payload: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_tunnel_message.id, MAVLink_tunnel_message.msgname)
        self._fieldnames = MAVLink_tunnel_message.fieldnames
        self._instance_field = MAVLink_tunnel_message.instance_field
        self._instance_offset = MAVLink_tunnel_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.payload_type = payload_type
        self.payload_length = payload_length
        self.payload = payload

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.payload_type, self.target_system, self.target_component, self.payload_length, self.payload[0], self.payload[1], self.payload[2], self.payload[3], self.payload[4], self.payload[5], self.payload[6], self.payload[7], self.payload[8], self.payload[9], self.payload[10], self.payload[11], self.payload[12], self.payload[13], self.payload[14], self.payload[15], self.payload[16], self.payload[17], self.payload[18], self.payload[19], self.payload[20], self.payload[21], self.payload[22], self.payload[23], self.payload[24], self.payload[25], self.payload[26], self.payload[27], self.payload[28], self.payload[29], self.payload[30], self.payload[31], self.payload[32], self.payload[33], self.payload[34], self.payload[35], self.payload[36], self.payload[37], self.payload[38], self.payload[39], self.payload[40], self.payload[41], self.payload[42], self.payload[43], self.payload[44], self.payload[45], self.payload[46], self.payload[47], self.payload[48], self.payload[49], self.payload[50], self.payload[51], self.payload[52], self.payload[53], self.payload[54], self.payload[55], self.payload[56], self.payload[57], self.payload[58], self.payload[59], self.payload[60], self.payload[61], self.payload[62], self.payload[63], self.payload[64], self.payload[65], self.payload[66], self.payload[67], self.payload[68], self.payload[69], self.payload[70], self.payload[71], self.payload[72], self.payload[73], self.payload[74], self.payload[75], self.payload[76], self.payload[77], self.payload[78], self.payload[79], self.payload[80], self.payload[81], self.payload[82], self.payload[83], self.payload[84], self.payload[85], self.payload[86], self.payload[87], self.payload[88], self.payload[89], self.payload[90], self.payload[91], self.payload[92], self.payload[93], self.payload[94], self.payload[95], self.payload[96], self.payload[97], self.payload[98], self.payload[99], self.payload[100], self.payload[101], self.payload[102], self.payload[103], self.payload[104], self.payload[105], self.payload[106], self.payload[107], self.payload[108], self.payload[109], self.payload[110], self.payload[111], self.payload[112], self.payload[113], self.payload[114], self.payload[115], self.payload[116], self.payload[117], self.payload[118], self.payload[119], self.payload[120], self.payload[121], self.payload[122], self.payload[123], self.payload[124], self.payload[125], self.payload[126], self.payload[127]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_tunnel_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_can_frame_message(MAVLink_message):
    """
    A forwarded CAN frame as requested by MAV_CMD_CAN_FORWARD.
    """

    id = MAVLINK_MSG_ID_CAN_FRAME
    msgname = "CAN_FRAME"
    fieldnames = ["target_system", "target_component", "bus", "len", "id", "data"]
    ordered_fieldnames = ["id", "target_system", "target_component", "bus", "len", "data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint32_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<IBBBBB")
    orders = [1, 2, 3, 4, 0, 5]
    lengths = [1, 1, 1, 1, 1, 8]
    array_lengths = [0, 0, 0, 0, 0, 8]
    crc_extra = 132
    unpacker = struct.Struct("<IBBBB8B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, bus: int, len: int, id: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_can_frame_message.id, MAVLink_can_frame_message.msgname)
        self._fieldnames = MAVLink_can_frame_message.fieldnames
        self._instance_field = MAVLink_can_frame_message.instance_field
        self._instance_offset = MAVLink_can_frame_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.bus = bus
        self.len = len
        self.id = id
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.id, self.target_system, self.target_component, self.bus, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_can_frame_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_canfd_frame_message(MAVLink_message):
    """
    A forwarded CANFD frame as requested by MAV_CMD_CAN_FORWARD. These
    are separated from CAN_FRAME as they need different handling (eg.
    TAO handling)
    """

    id = MAVLINK_MSG_ID_CANFD_FRAME
    msgname = "CANFD_FRAME"
    fieldnames = ["target_system", "target_component", "bus", "len", "id", "data"]
    ordered_fieldnames = ["id", "target_system", "target_component", "bus", "len", "data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint32_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<IBBBBB")
    orders = [1, 2, 3, 4, 0, 5]
    lengths = [1, 1, 1, 1, 1, 64]
    array_lengths = [0, 0, 0, 0, 0, 64]
    crc_extra = 4
    unpacker = struct.Struct("<IBBBB64B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, bus: int, len: int, id: int, data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_canfd_frame_message.id, MAVLink_canfd_frame_message.msgname)
        self._fieldnames = MAVLink_canfd_frame_message.fieldnames
        self._instance_field = MAVLink_canfd_frame_message.instance_field
        self._instance_offset = MAVLink_canfd_frame_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.bus = bus
        self.len = len
        self.id = id
        self.data = data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.id, self.target_system, self.target_component, self.bus, self.len, self.data[0], self.data[1], self.data[2], self.data[3], self.data[4], self.data[5], self.data[6], self.data[7], self.data[8], self.data[9], self.data[10], self.data[11], self.data[12], self.data[13], self.data[14], self.data[15], self.data[16], self.data[17], self.data[18], self.data[19], self.data[20], self.data[21], self.data[22], self.data[23], self.data[24], self.data[25], self.data[26], self.data[27], self.data[28], self.data[29], self.data[30], self.data[31], self.data[32], self.data[33], self.data[34], self.data[35], self.data[36], self.data[37], self.data[38], self.data[39], self.data[40], self.data[41], self.data[42], self.data[43], self.data[44], self.data[45], self.data[46], self.data[47], self.data[48], self.data[49], self.data[50], self.data[51], self.data[52], self.data[53], self.data[54], self.data[55], self.data[56], self.data[57], self.data[58], self.data[59], self.data[60], self.data[61], self.data[62], self.data[63]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_canfd_frame_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_can_filter_modify_message(MAVLink_message):
    """
    Modify the filter of what CAN messages to forward over the
    mavlink. This can be used to make CAN forwarding work well on low
    bandwidth links. The filtering is applied on bits 8 to 24 of the
    CAN id (2nd and 3rd bytes) which corresponds to the DroneCAN
    message ID for DroneCAN. Filters with more than 16 IDs can be
    constructed by sending multiple CAN_FILTER_MODIFY messages.
    """

    id = MAVLINK_MSG_ID_CAN_FILTER_MODIFY
    msgname = "CAN_FILTER_MODIFY"
    fieldnames = ["target_system", "target_component", "bus", "operation", "num_ids", "ids"]
    ordered_fieldnames = ["ids", "target_system", "target_component", "bus", "operation", "num_ids"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"operation": "CAN_FILTER_OP"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<HBBBBB")
    orders = [1, 2, 3, 4, 5, 0]
    lengths = [16, 1, 1, 1, 1, 1]
    array_lengths = [16, 0, 0, 0, 0, 0]
    crc_extra = 8
    unpacker = struct.Struct("<16HBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, bus: int, operation: int, num_ids: int, ids: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_can_filter_modify_message.id, MAVLink_can_filter_modify_message.msgname)
        self._fieldnames = MAVLink_can_filter_modify_message.fieldnames
        self._instance_field = MAVLink_can_filter_modify_message.instance_field
        self._instance_offset = MAVLink_can_filter_modify_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.bus = bus
        self.operation = operation
        self.num_ids = num_ids
        self.ids = ids

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.ids[0], self.ids[1], self.ids[2], self.ids[3], self.ids[4], self.ids[5], self.ids[6], self.ids[7], self.ids[8], self.ids[9], self.ids[10], self.ids[11], self.ids[12], self.ids[13], self.ids[14], self.ids[15], self.target_system, self.target_component, self.bus, self.operation, self.num_ids), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_can_filter_modify_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_wheel_distance_message(MAVLink_message):
    """
    Cumulative distance traveled for each reported wheel.
    """

    id = MAVLINK_MSG_ID_WHEEL_DISTANCE
    msgname = "WHEEL_DISTANCE"
    fieldnames = ["time_usec", "count", "distance"]
    ordered_fieldnames = ["time_usec", "distance", "count"]
    fieldtypes = ["uint64_t", "uint8_t", "double"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "distance": "m"}
    native_format = bytearray(b"<QdB")
    orders = [0, 2, 1]
    lengths = [1, 16, 1]
    array_lengths = [0, 16, 0]
    crc_extra = 113
    unpacker = struct.Struct("<Q16dB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, count: int, distance: Sequence[float]):
        MAVLink_message.__init__(self, MAVLink_wheel_distance_message.id, MAVLink_wheel_distance_message.msgname)
        self._fieldnames = MAVLink_wheel_distance_message.fieldnames
        self._instance_field = MAVLink_wheel_distance_message.instance_field
        self._instance_offset = MAVLink_wheel_distance_message.instance_offset
        self.time_usec = time_usec
        self.count = count
        self.distance = distance

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.distance[0], self.distance[1], self.distance[2], self.distance[3], self.distance[4], self.distance[5], self.distance[6], self.distance[7], self.distance[8], self.distance[9], self.distance[10], self.distance[11], self.distance[12], self.distance[13], self.distance[14], self.distance[15], self.count), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_wheel_distance_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_winch_status_message(MAVLink_message):
    """
    Winch status.
    """

    id = MAVLINK_MSG_ID_WINCH_STATUS
    msgname = "WINCH_STATUS"
    fieldnames = ["time_usec", "line_length", "speed", "tension", "voltage", "current", "temperature", "status"]
    ordered_fieldnames = ["time_usec", "line_length", "speed", "tension", "voltage", "current", "status", "temperature"]
    fieldtypes = ["uint64_t", "float", "float", "float", "float", "float", "int16_t", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {"status": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"status": "MAV_WINCH_STATUS_FLAG"}
    fieldunits_by_name: Dict[str, str] = {"time_usec": "us", "line_length": "m", "speed": "m/s", "tension": "kg", "voltage": "V", "current": "A", "temperature": "degC"}
    native_format = bytearray(b"<QfffffIh")
    orders = [0, 1, 2, 3, 4, 5, 7, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 117
    unpacker = struct.Struct("<QfffffIh")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec: int, line_length: float, speed: float, tension: float, voltage: float, current: float, temperature: int, status: int):
        MAVLink_message.__init__(self, MAVLink_winch_status_message.id, MAVLink_winch_status_message.msgname)
        self._fieldnames = MAVLink_winch_status_message.fieldnames
        self._instance_field = MAVLink_winch_status_message.instance_field
        self._instance_offset = MAVLink_winch_status_message.instance_offset
        self.time_usec = time_usec
        self.line_length = line_length
        self.speed = speed
        self.tension = tension
        self.voltage = voltage
        self.current = current
        self.temperature = temperature
        self.status = status

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.line_length, self.speed, self.tension, self.voltage, self.current, self.status, self.temperature), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_winch_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_basic_id_message(MAVLink_message):
    """
    Data for filling the OpenDroneID Basic ID message. This and the
    below messages are primarily meant for feeding data to/from an
    OpenDroneID implementation. E.g.
    https://github.com/opendroneid/opendroneid-core-c. These messages
    are compatible with the ASTM F3411 Remote ID standard and the ASD-
    STAN prEN 4709-002 Direct Remote ID standard. Additional
    information and usage of these messages is documented at
    https://mavlink.io/en/services/opendroneid.html.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_BASIC_ID
    msgname = "OPEN_DRONE_ID_BASIC_ID"
    fieldnames = ["target_system", "target_component", "id_or_mac", "id_type", "ua_type", "uas_id"]
    ordered_fieldnames = ["target_system", "target_component", "id_or_mac", "id_type", "ua_type", "uas_id"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"id_type": "MAV_ODID_ID_TYPE", "ua_type": "MAV_ODID_UA_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBBBBB")
    orders = [0, 1, 2, 3, 4, 5]
    lengths = [1, 1, 20, 1, 1, 20]
    array_lengths = [0, 0, 20, 0, 0, 20]
    crc_extra = 114
    unpacker = struct.Struct("<BB20BBB20B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, id_or_mac: Sequence[int], id_type: int, ua_type: int, uas_id: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_basic_id_message.id, MAVLink_open_drone_id_basic_id_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_basic_id_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_basic_id_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_basic_id_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.id_or_mac = id_or_mac
        self.id_type = id_type
        self.ua_type = ua_type
        self.uas_id = uas_id

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self.id_or_mac[0], self.id_or_mac[1], self.id_or_mac[2], self.id_or_mac[3], self.id_or_mac[4], self.id_or_mac[5], self.id_or_mac[6], self.id_or_mac[7], self.id_or_mac[8], self.id_or_mac[9], self.id_or_mac[10], self.id_or_mac[11], self.id_or_mac[12], self.id_or_mac[13], self.id_or_mac[14], self.id_or_mac[15], self.id_or_mac[16], self.id_or_mac[17], self.id_or_mac[18], self.id_or_mac[19], self.id_type, self.ua_type, self.uas_id[0], self.uas_id[1], self.uas_id[2], self.uas_id[3], self.uas_id[4], self.uas_id[5], self.uas_id[6], self.uas_id[7], self.uas_id[8], self.uas_id[9], self.uas_id[10], self.uas_id[11], self.uas_id[12], self.uas_id[13], self.uas_id[14], self.uas_id[15], self.uas_id[16], self.uas_id[17], self.uas_id[18], self.uas_id[19]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_basic_id_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_location_message(MAVLink_message):
    """
    Data for filling the OpenDroneID Location message. The float data
    types are 32-bit IEEE 754. The Location message provides the
    location, altitude, direction and speed of the aircraft.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_LOCATION
    msgname = "OPEN_DRONE_ID_LOCATION"
    fieldnames = ["target_system", "target_component", "id_or_mac", "status", "direction", "speed_horizontal", "speed_vertical", "latitude", "longitude", "altitude_barometric", "altitude_geodetic", "height_reference", "height", "horizontal_accuracy", "vertical_accuracy", "barometer_accuracy", "speed_accuracy", "timestamp", "timestamp_accuracy"]
    ordered_fieldnames = ["latitude", "longitude", "altitude_barometric", "altitude_geodetic", "height", "timestamp", "direction", "speed_horizontal", "speed_vertical", "target_system", "target_component", "id_or_mac", "status", "height_reference", "horizontal_accuracy", "vertical_accuracy", "barometer_accuracy", "speed_accuracy", "timestamp_accuracy"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint16_t", "uint16_t", "int16_t", "int32_t", "int32_t", "float", "float", "uint8_t", "float", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "float", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"status": "MAV_ODID_STATUS", "height_reference": "MAV_ODID_HEIGHT_REF", "horizontal_accuracy": "MAV_ODID_HOR_ACC", "vertical_accuracy": "MAV_ODID_VER_ACC", "barometer_accuracy": "MAV_ODID_VER_ACC", "speed_accuracy": "MAV_ODID_SPEED_ACC", "timestamp_accuracy": "MAV_ODID_TIME_ACC"}
    fieldunits_by_name: Dict[str, str] = {"direction": "cdeg", "speed_horizontal": "cm/s", "speed_vertical": "cm/s", "latitude": "degE7", "longitude": "degE7", "altitude_barometric": "m", "altitude_geodetic": "m", "height": "m", "timestamp": "s"}
    native_format = bytearray(b"<iiffffHHhBBBBBBBBBB")
    orders = [9, 10, 11, 12, 6, 7, 8, 0, 1, 2, 3, 13, 4, 14, 15, 16, 17, 5, 18]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 254
    unpacker = struct.Struct("<iiffffHHhBB20BBBBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, id_or_mac: Sequence[int], status: int, direction: int, speed_horizontal: int, speed_vertical: int, latitude: int, longitude: int, altitude_barometric: float, altitude_geodetic: float, height_reference: int, height: float, horizontal_accuracy: int, vertical_accuracy: int, barometer_accuracy: int, speed_accuracy: int, timestamp: float, timestamp_accuracy: int):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_location_message.id, MAVLink_open_drone_id_location_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_location_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_location_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_location_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.id_or_mac = id_or_mac
        self.status = status
        self.direction = direction
        self.speed_horizontal = speed_horizontal
        self.speed_vertical = speed_vertical
        self.latitude = latitude
        self.longitude = longitude
        self.altitude_barometric = altitude_barometric
        self.altitude_geodetic = altitude_geodetic
        self.height_reference = height_reference
        self.height = height
        self.horizontal_accuracy = horizontal_accuracy
        self.vertical_accuracy = vertical_accuracy
        self.barometer_accuracy = barometer_accuracy
        self.speed_accuracy = speed_accuracy
        self.timestamp = timestamp
        self.timestamp_accuracy = timestamp_accuracy

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.latitude, self.longitude, self.altitude_barometric, self.altitude_geodetic, self.height, self.timestamp, self.direction, self.speed_horizontal, self.speed_vertical, self.target_system, self.target_component, self.id_or_mac[0], self.id_or_mac[1], self.id_or_mac[2], self.id_or_mac[3], self.id_or_mac[4], self.id_or_mac[5], self.id_or_mac[6], self.id_or_mac[7], self.id_or_mac[8], self.id_or_mac[9], self.id_or_mac[10], self.id_or_mac[11], self.id_or_mac[12], self.id_or_mac[13], self.id_or_mac[14], self.id_or_mac[15], self.id_or_mac[16], self.id_or_mac[17], self.id_or_mac[18], self.id_or_mac[19], self.status, self.height_reference, self.horizontal_accuracy, self.vertical_accuracy, self.barometer_accuracy, self.speed_accuracy, self.timestamp_accuracy), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_location_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_authentication_message(MAVLink_message):
    """
    Data for filling the OpenDroneID Authentication message. The
    Authentication Message defines a field that can provide a means of
    authenticity for the identity of the UAS (Unmanned Aircraft
    System). The Authentication message can have two different
    formats. For data page 0, the fields PageCount, Length and
    TimeStamp are present and AuthData is only 17 bytes. For data page
    1 through 15, PageCount, Length and TimeStamp are not present and
    the size of AuthData is 23 bytes.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_AUTHENTICATION
    msgname = "OPEN_DRONE_ID_AUTHENTICATION"
    fieldnames = ["target_system", "target_component", "id_or_mac", "authentication_type", "data_page", "last_page_index", "length", "timestamp", "authentication_data"]
    ordered_fieldnames = ["timestamp", "target_system", "target_component", "id_or_mac", "authentication_type", "data_page", "last_page_index", "length", "authentication_data"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint32_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"authentication_type": "MAV_ODID_AUTH_TYPE"}
    fieldunits_by_name: Dict[str, str] = {"length": "bytes", "timestamp": "s"}
    native_format = bytearray(b"<IBBBBBBBB")
    orders = [1, 2, 3, 4, 5, 6, 7, 0, 8]
    lengths = [1, 1, 1, 20, 1, 1, 1, 1, 23]
    array_lengths = [0, 0, 0, 20, 0, 0, 0, 0, 23]
    crc_extra = 140
    unpacker = struct.Struct("<IBB20BBBBB23B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, id_or_mac: Sequence[int], authentication_type: int, data_page: int, last_page_index: int, length: int, timestamp: int, authentication_data: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_authentication_message.id, MAVLink_open_drone_id_authentication_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_authentication_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_authentication_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_authentication_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.id_or_mac = id_or_mac
        self.authentication_type = authentication_type
        self.data_page = data_page
        self.last_page_index = last_page_index
        self.length = length
        self.timestamp = timestamp
        self.authentication_data = authentication_data

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.timestamp, self.target_system, self.target_component, self.id_or_mac[0], self.id_or_mac[1], self.id_or_mac[2], self.id_or_mac[3], self.id_or_mac[4], self.id_or_mac[5], self.id_or_mac[6], self.id_or_mac[7], self.id_or_mac[8], self.id_or_mac[9], self.id_or_mac[10], self.id_or_mac[11], self.id_or_mac[12], self.id_or_mac[13], self.id_or_mac[14], self.id_or_mac[15], self.id_or_mac[16], self.id_or_mac[17], self.id_or_mac[18], self.id_or_mac[19], self.authentication_type, self.data_page, self.last_page_index, self.length, self.authentication_data[0], self.authentication_data[1], self.authentication_data[2], self.authentication_data[3], self.authentication_data[4], self.authentication_data[5], self.authentication_data[6], self.authentication_data[7], self.authentication_data[8], self.authentication_data[9], self.authentication_data[10], self.authentication_data[11], self.authentication_data[12], self.authentication_data[13], self.authentication_data[14], self.authentication_data[15], self.authentication_data[16], self.authentication_data[17], self.authentication_data[18], self.authentication_data[19], self.authentication_data[20], self.authentication_data[21], self.authentication_data[22]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_authentication_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_self_id_message(MAVLink_message):
    """
    Data for filling the OpenDroneID Self ID message. The Self ID
    Message is an opportunity for the operator to (optionally) declare
    their identity and purpose of the flight. This message can provide
    additional information that could reduce the threat profile of a
    UA (Unmanned Aircraft) flying in a particular area or manner. This
    message can also be used to provide optional additional
    clarification in an emergency/remote ID system failure situation.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_SELF_ID
    msgname = "OPEN_DRONE_ID_SELF_ID"
    fieldnames = ["target_system", "target_component", "id_or_mac", "description_type", "description"]
    ordered_fieldnames = ["target_system", "target_component", "id_or_mac", "description_type", "description"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"description_type": "MAV_ODID_DESC_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBBBc")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 20, 1, 1]
    array_lengths = [0, 0, 20, 0, 23]
    crc_extra = 249
    unpacker = struct.Struct("<BB20BB23s")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, id_or_mac: Sequence[int], description_type: int, description: bytes):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_self_id_message.id, MAVLink_open_drone_id_self_id_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_self_id_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_self_id_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_self_id_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.id_or_mac = id_or_mac
        self.description_type = description_type
        self._description_raw = description
        self.description = description.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self.id_or_mac[0], self.id_or_mac[1], self.id_or_mac[2], self.id_or_mac[3], self.id_or_mac[4], self.id_or_mac[5], self.id_or_mac[6], self.id_or_mac[7], self.id_or_mac[8], self.id_or_mac[9], self.id_or_mac[10], self.id_or_mac[11], self.id_or_mac[12], self.id_or_mac[13], self.id_or_mac[14], self.id_or_mac[15], self.id_or_mac[16], self.id_or_mac[17], self.id_or_mac[18], self.id_or_mac[19], self.description_type, self._description_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_self_id_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_system_message(MAVLink_message):
    """
    Data for filling the OpenDroneID System message. The System
    Message contains general system information including the operator
    location/altitude and possible aircraft group and/or
    category/class information.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_SYSTEM
    msgname = "OPEN_DRONE_ID_SYSTEM"
    fieldnames = ["target_system", "target_component", "id_or_mac", "operator_location_type", "classification_type", "operator_latitude", "operator_longitude", "area_count", "area_radius", "area_ceiling", "area_floor", "category_eu", "class_eu", "operator_altitude_geo", "timestamp"]
    ordered_fieldnames = ["operator_latitude", "operator_longitude", "area_ceiling", "area_floor", "operator_altitude_geo", "timestamp", "area_count", "area_radius", "target_system", "target_component", "id_or_mac", "operator_location_type", "classification_type", "category_eu", "class_eu"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "int32_t", "int32_t", "uint16_t", "uint16_t", "float", "float", "uint8_t", "uint8_t", "float", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"operator_location_type": "MAV_ODID_OPERATOR_LOCATION_TYPE", "classification_type": "MAV_ODID_CLASSIFICATION_TYPE", "category_eu": "MAV_ODID_CATEGORY_EU", "class_eu": "MAV_ODID_CLASS_EU"}
    fieldunits_by_name: Dict[str, str] = {"operator_latitude": "degE7", "operator_longitude": "degE7", "area_radius": "m", "area_ceiling": "m", "area_floor": "m", "operator_altitude_geo": "m", "timestamp": "s"}
    native_format = bytearray(b"<iifffIHHBBBBBBB")
    orders = [8, 9, 10, 11, 12, 0, 1, 6, 7, 2, 3, 13, 14, 4, 5]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0]
    crc_extra = 77
    unpacker = struct.Struct("<iifffIHHBB20BBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, id_or_mac: Sequence[int], operator_location_type: int, classification_type: int, operator_latitude: int, operator_longitude: int, area_count: int, area_radius: int, area_ceiling: float, area_floor: float, category_eu: int, class_eu: int, operator_altitude_geo: float, timestamp: int):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_system_message.id, MAVLink_open_drone_id_system_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_system_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_system_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_system_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.id_or_mac = id_or_mac
        self.operator_location_type = operator_location_type
        self.classification_type = classification_type
        self.operator_latitude = operator_latitude
        self.operator_longitude = operator_longitude
        self.area_count = area_count
        self.area_radius = area_radius
        self.area_ceiling = area_ceiling
        self.area_floor = area_floor
        self.category_eu = category_eu
        self.class_eu = class_eu
        self.operator_altitude_geo = operator_altitude_geo
        self.timestamp = timestamp

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.operator_latitude, self.operator_longitude, self.area_ceiling, self.area_floor, self.operator_altitude_geo, self.timestamp, self.area_count, self.area_radius, self.target_system, self.target_component, self.id_or_mac[0], self.id_or_mac[1], self.id_or_mac[2], self.id_or_mac[3], self.id_or_mac[4], self.id_or_mac[5], self.id_or_mac[6], self.id_or_mac[7], self.id_or_mac[8], self.id_or_mac[9], self.id_or_mac[10], self.id_or_mac[11], self.id_or_mac[12], self.id_or_mac[13], self.id_or_mac[14], self.id_or_mac[15], self.id_or_mac[16], self.id_or_mac[17], self.id_or_mac[18], self.id_or_mac[19], self.operator_location_type, self.classification_type, self.category_eu, self.class_eu), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_system_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_operator_id_message(MAVLink_message):
    """
    Data for filling the OpenDroneID Operator ID message, which
    contains the CAA (Civil Aviation Authority) issued operator ID.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_OPERATOR_ID
    msgname = "OPEN_DRONE_ID_OPERATOR_ID"
    fieldnames = ["target_system", "target_component", "id_or_mac", "operator_id_type", "operator_id"]
    ordered_fieldnames = ["target_system", "target_component", "id_or_mac", "operator_id_type", "operator_id"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"operator_id_type": "MAV_ODID_OPERATOR_ID_TYPE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<BBBBc")
    orders = [0, 1, 2, 3, 4]
    lengths = [1, 1, 20, 1, 1]
    array_lengths = [0, 0, 20, 0, 20]
    crc_extra = 49
    unpacker = struct.Struct("<BB20BB20s")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, id_or_mac: Sequence[int], operator_id_type: int, operator_id: bytes):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_operator_id_message.id, MAVLink_open_drone_id_operator_id_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_operator_id_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_operator_id_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_operator_id_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.id_or_mac = id_or_mac
        self.operator_id_type = operator_id_type
        self._operator_id_raw = operator_id
        self.operator_id = operator_id.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self.id_or_mac[0], self.id_or_mac[1], self.id_or_mac[2], self.id_or_mac[3], self.id_or_mac[4], self.id_or_mac[5], self.id_or_mac[6], self.id_or_mac[7], self.id_or_mac[8], self.id_or_mac[9], self.id_or_mac[10], self.id_or_mac[11], self.id_or_mac[12], self.id_or_mac[13], self.id_or_mac[14], self.id_or_mac[15], self.id_or_mac[16], self.id_or_mac[17], self.id_or_mac[18], self.id_or_mac[19], self.operator_id_type, self._operator_id_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_operator_id_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_arm_status_message(MAVLink_message):
    """
    Status from the transmitter telling the flight controller if the
    remote ID system is ready for arming.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_ARM_STATUS
    msgname = "OPEN_DRONE_ID_ARM_STATUS"
    fieldnames = ["status", "error"]
    ordered_fieldnames = ["status", "error"]
    fieldtypes = ["uint8_t", "char"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {"status": "MAV_ODID_ARM_STATUS"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<Bc")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 50]
    crc_extra = 139
    unpacker = struct.Struct("<B50s")
    instance_field = None
    instance_offset = -1

    def __init__(self, status: int, error: bytes):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_arm_status_message.id, MAVLink_open_drone_id_arm_status_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_arm_status_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_arm_status_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_arm_status_message.instance_offset
        self.status = status
        self._error_raw = error
        self.error = error.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.status, self._error_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_arm_status_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_message_pack_message(MAVLink_message):
    """
    An OpenDroneID message pack is a container for multiple encoded
    OpenDroneID messages (i.e. not in the format given for the above
    message descriptions but after encoding into the compressed
    OpenDroneID byte format). Used e.g. when transmitting on Bluetooth
    5.0 Long Range/Extended Advertising or on WiFi Neighbor Aware
    Networking or on WiFi Beacon.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_MESSAGE_PACK
    msgname = "OPEN_DRONE_ID_MESSAGE_PACK"
    fieldnames = ["target_system", "target_component", "id_or_mac", "single_message_size", "msg_pack_size", "messages"]
    ordered_fieldnames = ["target_system", "target_component", "id_or_mac", "single_message_size", "msg_pack_size", "messages"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"single_message_size": "bytes"}
    native_format = bytearray(b"<BBBBBB")
    orders = [0, 1, 2, 3, 4, 5]
    lengths = [1, 1, 20, 1, 1, 225]
    array_lengths = [0, 0, 20, 0, 0, 225]
    crc_extra = 94
    unpacker = struct.Struct("<BB20BBB225B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, id_or_mac: Sequence[int], single_message_size: int, msg_pack_size: int, messages: Sequence[int]):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_message_pack_message.id, MAVLink_open_drone_id_message_pack_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_message_pack_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_message_pack_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_message_pack_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.id_or_mac = id_or_mac
        self.single_message_size = single_message_size
        self.msg_pack_size = msg_pack_size
        self.messages = messages

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.target_component, self.id_or_mac[0], self.id_or_mac[1], self.id_or_mac[2], self.id_or_mac[3], self.id_or_mac[4], self.id_or_mac[5], self.id_or_mac[6], self.id_or_mac[7], self.id_or_mac[8], self.id_or_mac[9], self.id_or_mac[10], self.id_or_mac[11], self.id_or_mac[12], self.id_or_mac[13], self.id_or_mac[14], self.id_or_mac[15], self.id_or_mac[16], self.id_or_mac[17], self.id_or_mac[18], self.id_or_mac[19], self.single_message_size, self.msg_pack_size, self.messages[0], self.messages[1], self.messages[2], self.messages[3], self.messages[4], self.messages[5], self.messages[6], self.messages[7], self.messages[8], self.messages[9], self.messages[10], self.messages[11], self.messages[12], self.messages[13], self.messages[14], self.messages[15], self.messages[16], self.messages[17], self.messages[18], self.messages[19], self.messages[20], self.messages[21], self.messages[22], self.messages[23], self.messages[24], self.messages[25], self.messages[26], self.messages[27], self.messages[28], self.messages[29], self.messages[30], self.messages[31], self.messages[32], self.messages[33], self.messages[34], self.messages[35], self.messages[36], self.messages[37], self.messages[38], self.messages[39], self.messages[40], self.messages[41], self.messages[42], self.messages[43], self.messages[44], self.messages[45], self.messages[46], self.messages[47], self.messages[48], self.messages[49], self.messages[50], self.messages[51], self.messages[52], self.messages[53], self.messages[54], self.messages[55], self.messages[56], self.messages[57], self.messages[58], self.messages[59], self.messages[60], self.messages[61], self.messages[62], self.messages[63], self.messages[64], self.messages[65], self.messages[66], self.messages[67], self.messages[68], self.messages[69], self.messages[70], self.messages[71], self.messages[72], self.messages[73], self.messages[74], self.messages[75], self.messages[76], self.messages[77], self.messages[78], self.messages[79], self.messages[80], self.messages[81], self.messages[82], self.messages[83], self.messages[84], self.messages[85], self.messages[86], self.messages[87], self.messages[88], self.messages[89], self.messages[90], self.messages[91], self.messages[92], self.messages[93], self.messages[94], self.messages[95], self.messages[96], self.messages[97], self.messages[98], self.messages[99], self.messages[100], self.messages[101], self.messages[102], self.messages[103], self.messages[104], self.messages[105], self.messages[106], self.messages[107], self.messages[108], self.messages[109], self.messages[110], self.messages[111], self.messages[112], self.messages[113], self.messages[114], self.messages[115], self.messages[116], self.messages[117], self.messages[118], self.messages[119], self.messages[120], self.messages[121], self.messages[122], self.messages[123], self.messages[124], self.messages[125], self.messages[126], self.messages[127], self.messages[128], self.messages[129], self.messages[130], self.messages[131], self.messages[132], self.messages[133], self.messages[134], self.messages[135], self.messages[136], self.messages[137], self.messages[138], self.messages[139], self.messages[140], self.messages[141], self.messages[142], self.messages[143], self.messages[144], self.messages[145], self.messages[146], self.messages[147], self.messages[148], self.messages[149], self.messages[150], self.messages[151], self.messages[152], self.messages[153], self.messages[154], self.messages[155], self.messages[156], self.messages[157], self.messages[158], self.messages[159], self.messages[160], self.messages[161], self.messages[162], self.messages[163], self.messages[164], self.messages[165], self.messages[166], self.messages[167], self.messages[168], self.messages[169], self.messages[170], self.messages[171], self.messages[172], self.messages[173], self.messages[174], self.messages[175], self.messages[176], self.messages[177], self.messages[178], self.messages[179], self.messages[180], self.messages[181], self.messages[182], self.messages[183], self.messages[184], self.messages[185], self.messages[186], self.messages[187], self.messages[188], self.messages[189], self.messages[190], self.messages[191], self.messages[192], self.messages[193], self.messages[194], self.messages[195], self.messages[196], self.messages[197], self.messages[198], self.messages[199], self.messages[200], self.messages[201], self.messages[202], self.messages[203], self.messages[204], self.messages[205], self.messages[206], self.messages[207], self.messages[208], self.messages[209], self.messages[210], self.messages[211], self.messages[212], self.messages[213], self.messages[214], self.messages[215], self.messages[216], self.messages[217], self.messages[218], self.messages[219], self.messages[220], self.messages[221], self.messages[222], self.messages[223], self.messages[224]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_message_pack_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_open_drone_id_system_update_message(MAVLink_message):
    """
    Update the data in the OPEN_DRONE_ID_SYSTEM message with new
    location information. This can be sent to update the location
    information for the operator when no other information in the
    SYSTEM message has changed. This message allows for efficient
    operation on radio links which have limited uplink bandwidth while
    meeting requirements for update frequency of the operator
    location.
    """

    id = MAVLINK_MSG_ID_OPEN_DRONE_ID_SYSTEM_UPDATE
    msgname = "OPEN_DRONE_ID_SYSTEM_UPDATE"
    fieldnames = ["target_system", "target_component", "operator_latitude", "operator_longitude", "operator_altitude_geo", "timestamp"]
    ordered_fieldnames = ["operator_latitude", "operator_longitude", "operator_altitude_geo", "timestamp", "target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t", "int32_t", "int32_t", "float", "uint32_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"operator_latitude": "degE7", "operator_longitude": "degE7", "operator_altitude_geo": "m", "timestamp": "s"}
    native_format = bytearray(b"<iifIBB")
    orders = [4, 5, 0, 1, 2, 3]
    lengths = [1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0]
    crc_extra = 7
    unpacker = struct.Struct("<iifIBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system: int, target_component: int, operator_latitude: int, operator_longitude: int, operator_altitude_geo: float, timestamp: int):
        MAVLink_message.__init__(self, MAVLink_open_drone_id_system_update_message.id, MAVLink_open_drone_id_system_update_message.msgname)
        self._fieldnames = MAVLink_open_drone_id_system_update_message.fieldnames
        self._instance_field = MAVLink_open_drone_id_system_update_message.instance_field
        self._instance_offset = MAVLink_open_drone_id_system_update_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.operator_latitude = operator_latitude
        self.operator_longitude = operator_longitude
        self.operator_altitude_geo = operator_altitude_geo
        self.timestamp = timestamp

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.operator_latitude, self.operator_longitude, self.operator_altitude_geo, self.timestamp, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_open_drone_id_system_update_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_hygrometer_sensor_message(MAVLink_message):
    """
    Temperature and humidity from hygrometer.
    """

    id = MAVLINK_MSG_ID_HYGROMETER_SENSOR
    msgname = "HYGROMETER_SENSOR"
    fieldnames = ["id", "temperature", "humidity"]
    ordered_fieldnames = ["temperature", "humidity", "id"]
    fieldtypes = ["uint8_t", "int16_t", "uint16_t"]
    fielddisplays_by_name: Dict[str, str] = {}
    fieldenums_by_name: Dict[str, str] = {}
    fieldunits_by_name: Dict[str, str] = {"temperature": "cdegC", "humidity": "c%"}
    native_format = bytearray(b"<hHB")
    orders = [2, 0, 1]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 20
    unpacker = struct.Struct("<hHB")
    instance_field = "id"
    instance_offset = 4

    def __init__(self, id: int, temperature: int, humidity: int):
        MAVLink_message.__init__(self, MAVLink_hygrometer_sensor_message.id, MAVLink_hygrometer_sensor_message.msgname)
        self._fieldnames = MAVLink_hygrometer_sensor_message.fieldnames
        self._instance_field = MAVLink_hygrometer_sensor_message.instance_field
        self._instance_offset = MAVLink_hygrometer_sensor_message.instance_offset
        self.id = id
        self.temperature = temperature
        self.humidity = humidity

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.temperature, self.humidity, self.id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_hygrometer_sensor_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_heartbeat_message(MAVLink_message):
    """
    The heartbeat message shows that a system or component is present
    and responding. The type and autopilot fields (along with the
    message component id), allow the receiving system to treat further
    messages from this system appropriately (e.g. by laying out the
    user interface based on the autopilot). This microservice is
    documented at https://mavlink.io/en/services/heartbeat.html
    """

    id = MAVLINK_MSG_ID_HEARTBEAT
    msgname = "HEARTBEAT"
    fieldnames = ["type", "autopilot", "base_mode", "custom_mode", "system_status", "mavlink_version"]
    ordered_fieldnames = ["custom_mode", "type", "autopilot", "base_mode", "system_status", "mavlink_version"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name: Dict[str, str] = {"base_mode": "bitmask"}
    fieldenums_by_name: Dict[str, str] = {"type": "MAV_TYPE", "autopilot": "MAV_AUTOPILOT", "base_mode": "MAV_MODE_FLAG", "system_status": "MAV_STATE"}
    fieldunits_by_name: Dict[str, str] = {}
    native_format = bytearray(b"<IBBBBB")
    orders = [1, 2, 3, 0, 4, 5]
    lengths = [1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0]
    crc_extra = 50
    unpacker = struct.Struct("<IBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, type: int, autopilot: int, base_mode: int, custom_mode: int, system_status: int, mavlink_version: int):
        MAVLink_message.__init__(self, MAVLink_heartbeat_message.id, MAVLink_heartbeat_message.msgname)
        self._fieldnames = MAVLink_heartbeat_message.fieldnames
        self._instance_field = MAVLink_heartbeat_message.instance_field
        self._instance_offset = MAVLink_heartbeat_message.instance_offset
        self.type = type
        self.autopilot = autopilot
        self.base_mode = base_mode
        self.custom_mode = custom_mode
        self.system_status = system_status
        self.mavlink_version = mavlink_version

    def pack(self, mav: "MAVLink", force_mavlink1: bool = False) -> bytes:
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.custom_mode, self.type, self.autopilot, self.base_mode, self.system_status, self.mavlink_version), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_heartbeat_message, "name", mavlink_msg_deprecated_name_property())


mavlink_map: Dict[int, Type[MAVLink_message]] = {
    MAVLINK_MSG_ID_AVSS_PRS_SYS_STATUS: MAVLink_avss_prs_sys_status_message,
    MAVLINK_MSG_ID_AVSS_DRONE_POSITION: MAVLink_avss_drone_position_message,
    MAVLINK_MSG_ID_AVSS_DRONE_IMU: MAVLink_avss_drone_imu_message,
    MAVLINK_MSG_ID_AVSS_DRONE_OPERATION_MODE: MAVLink_avss_drone_operation_mode_message,
    MAVLINK_MSG_ID_SYS_STATUS: MAVLink_sys_status_message,
    MAVLINK_MSG_ID_SYSTEM_TIME: MAVLink_system_time_message,
    MAVLINK_MSG_ID_PING: MAVLink_ping_message,
    MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL: MAVLink_change_operator_control_message,
    MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK: MAVLink_change_operator_control_ack_message,
    MAVLINK_MSG_ID_AUTH_KEY: MAVLink_auth_key_message,
    MAVLINK_MSG_ID_SET_MODE: MAVLink_set_mode_message,
    MAVLINK_MSG_ID_PARAM_REQUEST_READ: MAVLink_param_request_read_message,
    MAVLINK_MSG_ID_PARAM_REQUEST_LIST: MAVLink_param_request_list_message,
    MAVLINK_MSG_ID_PARAM_VALUE: MAVLink_param_value_message,
    MAVLINK_MSG_ID_PARAM_SET: MAVLink_param_set_message,
    MAVLINK_MSG_ID_GPS_RAW_INT: MAVLink_gps_raw_int_message,
    MAVLINK_MSG_ID_GPS_STATUS: MAVLink_gps_status_message,
    MAVLINK_MSG_ID_SCALED_IMU: MAVLink_scaled_imu_message,
    MAVLINK_MSG_ID_RAW_IMU: MAVLink_raw_imu_message,
    MAVLINK_MSG_ID_RAW_PRESSURE: MAVLink_raw_pressure_message,
    MAVLINK_MSG_ID_SCALED_PRESSURE: MAVLink_scaled_pressure_message,
    MAVLINK_MSG_ID_ATTITUDE: MAVLink_attitude_message,
    MAVLINK_MSG_ID_ATTITUDE_QUATERNION: MAVLink_attitude_quaternion_message,
    MAVLINK_MSG_ID_LOCAL_POSITION_NED: MAVLink_local_position_ned_message,
    MAVLINK_MSG_ID_GLOBAL_POSITION_INT: MAVLink_global_position_int_message,
    MAVLINK_MSG_ID_RC_CHANNELS_SCALED: MAVLink_rc_channels_scaled_message,
    MAVLINK_MSG_ID_RC_CHANNELS_RAW: MAVLink_rc_channels_raw_message,
    MAVLINK_MSG_ID_SERVO_OUTPUT_RAW: MAVLink_servo_output_raw_message,
    MAVLINK_MSG_ID_MISSION_REQUEST_PARTIAL_LIST: MAVLink_mission_request_partial_list_message,
    MAVLINK_MSG_ID_MISSION_WRITE_PARTIAL_LIST: MAVLink_mission_write_partial_list_message,
    MAVLINK_MSG_ID_MISSION_ITEM: MAVLink_mission_item_message,
    MAVLINK_MSG_ID_MISSION_REQUEST: MAVLink_mission_request_message,
    MAVLINK_MSG_ID_MISSION_SET_CURRENT: MAVLink_mission_set_current_message,
    MAVLINK_MSG_ID_MISSION_CURRENT: MAVLink_mission_current_message,
    MAVLINK_MSG_ID_MISSION_REQUEST_LIST: MAVLink_mission_request_list_message,
    MAVLINK_MSG_ID_MISSION_COUNT: MAVLink_mission_count_message,
    MAVLINK_MSG_ID_MISSION_CLEAR_ALL: MAVLink_mission_clear_all_message,
    MAVLINK_MSG_ID_MISSION_ITEM_REACHED: MAVLink_mission_item_reached_message,
    MAVLINK_MSG_ID_MISSION_ACK: MAVLink_mission_ack_message,
    MAVLINK_MSG_ID_SET_GPS_GLOBAL_ORIGIN: MAVLink_set_gps_global_origin_message,
    MAVLINK_MSG_ID_GPS_GLOBAL_ORIGIN: MAVLink_gps_global_origin_message,
    MAVLINK_MSG_ID_PARAM_MAP_RC: MAVLink_param_map_rc_message,
    MAVLINK_MSG_ID_MISSION_REQUEST_INT: MAVLink_mission_request_int_message,
    MAVLINK_MSG_ID_SAFETY_SET_ALLOWED_AREA: MAVLink_safety_set_allowed_area_message,
    MAVLINK_MSG_ID_SAFETY_ALLOWED_AREA: MAVLink_safety_allowed_area_message,
    MAVLINK_MSG_ID_ATTITUDE_QUATERNION_COV: MAVLink_attitude_quaternion_cov_message,
    MAVLINK_MSG_ID_NAV_CONTROLLER_OUTPUT: MAVLink_nav_controller_output_message,
    MAVLINK_MSG_ID_GLOBAL_POSITION_INT_COV: MAVLink_global_position_int_cov_message,
    MAVLINK_MSG_ID_LOCAL_POSITION_NED_COV: MAVLink_local_position_ned_cov_message,
    MAVLINK_MSG_ID_RC_CHANNELS: MAVLink_rc_channels_message,
    MAVLINK_MSG_ID_REQUEST_DATA_STREAM: MAVLink_request_data_stream_message,
    MAVLINK_MSG_ID_DATA_STREAM: MAVLink_data_stream_message,
    MAVLINK_MSG_ID_MANUAL_CONTROL: MAVLink_manual_control_message,
    MAVLINK_MSG_ID_RC_CHANNELS_OVERRIDE: MAVLink_rc_channels_override_message,
    MAVLINK_MSG_ID_MISSION_ITEM_INT: MAVLink_mission_item_int_message,
    MAVLINK_MSG_ID_VFR_HUD: MAVLink_vfr_hud_message,
    MAVLINK_MSG_ID_COMMAND_INT: MAVLink_command_int_message,
    MAVLINK_MSG_ID_COMMAND_LONG: MAVLink_command_long_message,
    MAVLINK_MSG_ID_COMMAND_ACK: MAVLink_command_ack_message,
    MAVLINK_MSG_ID_MANUAL_SETPOINT: MAVLink_manual_setpoint_message,
    MAVLINK_MSG_ID_SET_ATTITUDE_TARGET: MAVLink_set_attitude_target_message,
    MAVLINK_MSG_ID_ATTITUDE_TARGET: MAVLink_attitude_target_message,
    MAVLINK_MSG_ID_SET_POSITION_TARGET_LOCAL_NED: MAVLink_set_position_target_local_ned_message,
    MAVLINK_MSG_ID_POSITION_TARGET_LOCAL_NED: MAVLink_position_target_local_ned_message,
    MAVLINK_MSG_ID_SET_POSITION_TARGET_GLOBAL_INT: MAVLink_set_position_target_global_int_message,
    MAVLINK_MSG_ID_POSITION_TARGET_GLOBAL_INT: MAVLink_position_target_global_int_message,
    MAVLINK_MSG_ID_LOCAL_POSITION_NED_SYSTEM_GLOBAL_OFFSET: MAVLink_local_position_ned_system_global_offset_message,
    MAVLINK_MSG_ID_HIL_STATE: MAVLink_hil_state_message,
    MAVLINK_MSG_ID_HIL_CONTROLS: MAVLink_hil_controls_message,
    MAVLINK_MSG_ID_HIL_RC_INPUTS_RAW: MAVLink_hil_rc_inputs_raw_message,
    MAVLINK_MSG_ID_HIL_ACTUATOR_CONTROLS: MAVLink_hil_actuator_controls_message,
    MAVLINK_MSG_ID_OPTICAL_FLOW: MAVLink_optical_flow_message,
    MAVLINK_MSG_ID_GLOBAL_VISION_POSITION_ESTIMATE: MAVLink_global_vision_position_estimate_message,
    MAVLINK_MSG_ID_VISION_POSITION_ESTIMATE: MAVLink_vision_position_estimate_message,
    MAVLINK_MSG_ID_VISION_SPEED_ESTIMATE: MAVLink_vision_speed_estimate_message,
    MAVLINK_MSG_ID_VICON_POSITION_ESTIMATE: MAVLink_vicon_position_estimate_message,
    MAVLINK_MSG_ID_HIGHRES_IMU: MAVLink_highres_imu_message,
    MAVLINK_MSG_ID_OPTICAL_FLOW_RAD: MAVLink_optical_flow_rad_message,
    MAVLINK_MSG_ID_HIL_SENSOR: MAVLink_hil_sensor_message,
    MAVLINK_MSG_ID_SIM_STATE: MAVLink_sim_state_message,
    MAVLINK_MSG_ID_RADIO_STATUS: MAVLink_radio_status_message,
    MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL: MAVLink_file_transfer_protocol_message,
    MAVLINK_MSG_ID_TIMESYNC: MAVLink_timesync_message,
    MAVLINK_MSG_ID_CAMERA_TRIGGER: MAVLink_camera_trigger_message,
    MAVLINK_MSG_ID_HIL_GPS: MAVLink_hil_gps_message,
    MAVLINK_MSG_ID_HIL_OPTICAL_FLOW: MAVLink_hil_optical_flow_message,
    MAVLINK_MSG_ID_HIL_STATE_QUATERNION: MAVLink_hil_state_quaternion_message,
    MAVLINK_MSG_ID_SCALED_IMU2: MAVLink_scaled_imu2_message,
    MAVLINK_MSG_ID_LOG_REQUEST_LIST: MAVLink_log_request_list_message,
    MAVLINK_MSG_ID_LOG_ENTRY: MAVLink_log_entry_message,
    MAVLINK_MSG_ID_LOG_REQUEST_DATA: MAVLink_log_request_data_message,
    MAVLINK_MSG_ID_LOG_DATA: MAVLink_log_data_message,
    MAVLINK_MSG_ID_LOG_ERASE: MAVLink_log_erase_message,
    MAVLINK_MSG_ID_LOG_REQUEST_END: MAVLink_log_request_end_message,
    MAVLINK_MSG_ID_GPS_INJECT_DATA: MAVLink_gps_inject_data_message,
    MAVLINK_MSG_ID_GPS2_RAW: MAVLink_gps2_raw_message,
    MAVLINK_MSG_ID_POWER_STATUS: MAVLink_power_status_message,
    MAVLINK_MSG_ID_SERIAL_CONTROL: MAVLink_serial_control_message,
    MAVLINK_MSG_ID_GPS_RTK: MAVLink_gps_rtk_message,
    MAVLINK_MSG_ID_GPS2_RTK: MAVLink_gps2_rtk_message,
    MAVLINK_MSG_ID_SCALED_IMU3: MAVLink_scaled_imu3_message,
    MAVLINK_MSG_ID_DATA_TRANSMISSION_HANDSHAKE: MAVLink_data_transmission_handshake_message,
    MAVLINK_MSG_ID_ENCAPSULATED_DATA: MAVLink_encapsulated_data_message,
    MAVLINK_MSG_ID_DISTANCE_SENSOR: MAVLink_distance_sensor_message,
    MAVLINK_MSG_ID_TERRAIN_REQUEST: MAVLink_terrain_request_message,
    MAVLINK_MSG_ID_TERRAIN_DATA: MAVLink_terrain_data_message,
    MAVLINK_MSG_ID_TERRAIN_CHECK: MAVLink_terrain_check_message,
    MAVLINK_MSG_ID_TERRAIN_REPORT: MAVLink_terrain_report_message,
    MAVLINK_MSG_ID_SCALED_PRESSURE2: MAVLink_scaled_pressure2_message,
    MAVLINK_MSG_ID_ATT_POS_MOCAP: MAVLink_att_pos_mocap_message,
    MAVLINK_MSG_ID_SET_ACTUATOR_CONTROL_TARGET: MAVLink_set_actuator_control_target_message,
    MAVLINK_MSG_ID_ACTUATOR_CONTROL_TARGET: MAVLink_actuator_control_target_message,
    MAVLINK_MSG_ID_ALTITUDE: MAVLink_altitude_message,
    MAVLINK_MSG_ID_RESOURCE_REQUEST: MAVLink_resource_request_message,
    MAVLINK_MSG_ID_SCALED_PRESSURE3: MAVLink_scaled_pressure3_message,
    MAVLINK_MSG_ID_FOLLOW_TARGET: MAVLink_follow_target_message,
    MAVLINK_MSG_ID_CONTROL_SYSTEM_STATE: MAVLink_control_system_state_message,
    MAVLINK_MSG_ID_BATTERY_STATUS: MAVLink_battery_status_message,
    MAVLINK_MSG_ID_AUTOPILOT_VERSION: MAVLink_autopilot_version_message,
    MAVLINK_MSG_ID_LANDING_TARGET: MAVLink_landing_target_message,
    MAVLINK_MSG_ID_FENCE_STATUS: MAVLink_fence_status_message,
    MAVLINK_MSG_ID_MAG_CAL_REPORT: MAVLink_mag_cal_report_message,
    MAVLINK_MSG_ID_EFI_STATUS: MAVLink_efi_status_message,
    MAVLINK_MSG_ID_ESTIMATOR_STATUS: MAVLink_estimator_status_message,
    MAVLINK_MSG_ID_WIND_COV: MAVLink_wind_cov_message,
    MAVLINK_MSG_ID_GPS_INPUT: MAVLink_gps_input_message,
    MAVLINK_MSG_ID_GPS_RTCM_DATA: MAVLink_gps_rtcm_data_message,
    MAVLINK_MSG_ID_HIGH_LATENCY: MAVLink_high_latency_message,
    MAVLINK_MSG_ID_HIGH_LATENCY2: MAVLink_high_latency2_message,
    MAVLINK_MSG_ID_VIBRATION: MAVLink_vibration_message,
    MAVLINK_MSG_ID_HOME_POSITION: MAVLink_home_position_message,
    MAVLINK_MSG_ID_SET_HOME_POSITION: MAVLink_set_home_position_message,
    MAVLINK_MSG_ID_MESSAGE_INTERVAL: MAVLink_message_interval_message,
    MAVLINK_MSG_ID_EXTENDED_SYS_STATE: MAVLink_extended_sys_state_message,
    MAVLINK_MSG_ID_ADSB_VEHICLE: MAVLink_adsb_vehicle_message,
    MAVLINK_MSG_ID_COLLISION: MAVLink_collision_message,
    MAVLINK_MSG_ID_V2_EXTENSION: MAVLink_v2_extension_message,
    MAVLINK_MSG_ID_MEMORY_VECT: MAVLink_memory_vect_message,
    MAVLINK_MSG_ID_DEBUG_VECT: MAVLink_debug_vect_message,
    MAVLINK_MSG_ID_NAMED_VALUE_FLOAT: MAVLink_named_value_float_message,
    MAVLINK_MSG_ID_NAMED_VALUE_INT: MAVLink_named_value_int_message,
    MAVLINK_MSG_ID_STATUSTEXT: MAVLink_statustext_message,
    MAVLINK_MSG_ID_DEBUG: MAVLink_debug_message,
    MAVLINK_MSG_ID_SETUP_SIGNING: MAVLink_setup_signing_message,
    MAVLINK_MSG_ID_BUTTON_CHANGE: MAVLink_button_change_message,
    MAVLINK_MSG_ID_PLAY_TUNE: MAVLink_play_tune_message,
    MAVLINK_MSG_ID_CAMERA_INFORMATION: MAVLink_camera_information_message,
    MAVLINK_MSG_ID_CAMERA_SETTINGS: MAVLink_camera_settings_message,
    MAVLINK_MSG_ID_STORAGE_INFORMATION: MAVLink_storage_information_message,
    MAVLINK_MSG_ID_CAMERA_CAPTURE_STATUS: MAVLink_camera_capture_status_message,
    MAVLINK_MSG_ID_CAMERA_IMAGE_CAPTURED: MAVLink_camera_image_captured_message,
    MAVLINK_MSG_ID_FLIGHT_INFORMATION: MAVLink_flight_information_message,
    MAVLINK_MSG_ID_MOUNT_ORIENTATION: MAVLink_mount_orientation_message,
    MAVLINK_MSG_ID_LOGGING_DATA: MAVLink_logging_data_message,
    MAVLINK_MSG_ID_LOGGING_DATA_ACKED: MAVLink_logging_data_acked_message,
    MAVLINK_MSG_ID_LOGGING_ACK: MAVLink_logging_ack_message,
    MAVLINK_MSG_ID_VIDEO_STREAM_INFORMATION: MAVLink_video_stream_information_message,
    MAVLINK_MSG_ID_VIDEO_STREAM_STATUS: MAVLink_video_stream_status_message,
    MAVLINK_MSG_ID_CAMERA_FOV_STATUS: MAVLink_camera_fov_status_message,
    MAVLINK_MSG_ID_CAMERA_TRACKING_IMAGE_STATUS: MAVLink_camera_tracking_image_status_message,
    MAVLINK_MSG_ID_CAMERA_TRACKING_GEO_STATUS: MAVLink_camera_tracking_geo_status_message,
    MAVLINK_MSG_ID_CAMERA_THERMAL_RANGE: MAVLink_camera_thermal_range_message,
    MAVLINK_MSG_ID_GIMBAL_MANAGER_INFORMATION: MAVLink_gimbal_manager_information_message,
    MAVLINK_MSG_ID_GIMBAL_MANAGER_STATUS: MAVLink_gimbal_manager_status_message,
    MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_ATTITUDE: MAVLink_gimbal_manager_set_attitude_message,
    MAVLINK_MSG_ID_GIMBAL_DEVICE_INFORMATION: MAVLink_gimbal_device_information_message,
    MAVLINK_MSG_ID_GIMBAL_DEVICE_SET_ATTITUDE: MAVLink_gimbal_device_set_attitude_message,
    MAVLINK_MSG_ID_GIMBAL_DEVICE_ATTITUDE_STATUS: MAVLink_gimbal_device_attitude_status_message,
    MAVLINK_MSG_ID_AUTOPILOT_STATE_FOR_GIMBAL_DEVICE: MAVLink_autopilot_state_for_gimbal_device_message,
    MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_PITCHYAW: MAVLink_gimbal_manager_set_pitchyaw_message,
    MAVLINK_MSG_ID_GIMBAL_MANAGER_SET_MANUAL_CONTROL: MAVLink_gimbal_manager_set_manual_control_message,
    MAVLINK_MSG_ID_WIFI_CONFIG_AP: MAVLink_wifi_config_ap_message,
    MAVLINK_MSG_ID_AIS_VESSEL: MAVLink_ais_vessel_message,
    MAVLINK_MSG_ID_UAVCAN_NODE_STATUS: MAVLink_uavcan_node_status_message,
    MAVLINK_MSG_ID_UAVCAN_NODE_INFO: MAVLink_uavcan_node_info_message,
    MAVLINK_MSG_ID_PARAM_EXT_REQUEST_READ: MAVLink_param_ext_request_read_message,
    MAVLINK_MSG_ID_PARAM_EXT_REQUEST_LIST: MAVLink_param_ext_request_list_message,
    MAVLINK_MSG_ID_PARAM_EXT_VALUE: MAVLink_param_ext_value_message,
    MAVLINK_MSG_ID_PARAM_EXT_SET: MAVLink_param_ext_set_message,
    MAVLINK_MSG_ID_PARAM_EXT_ACK: MAVLink_param_ext_ack_message,
    MAVLINK_MSG_ID_OBSTACLE_DISTANCE: MAVLink_obstacle_distance_message,
    MAVLINK_MSG_ID_ODOMETRY: MAVLink_odometry_message,
    MAVLINK_MSG_ID_TRAJECTORY_REPRESENTATION_WAYPOINTS: MAVLink_trajectory_representation_waypoints_message,
    MAVLINK_MSG_ID_TRAJECTORY_REPRESENTATION_BEZIER: MAVLink_trajectory_representation_bezier_message,
    MAVLINK_MSG_ID_ISBD_LINK_STATUS: MAVLink_isbd_link_status_message,
    MAVLINK_MSG_ID_RAW_RPM: MAVLink_raw_rpm_message,
    MAVLINK_MSG_ID_UTM_GLOBAL_POSITION: MAVLink_utm_global_position_message,
    MAVLINK_MSG_ID_DEBUG_FLOAT_ARRAY: MAVLink_debug_float_array_message,
    MAVLINK_MSG_ID_SMART_BATTERY_INFO: MAVLink_smart_battery_info_message,
    MAVLINK_MSG_ID_GENERATOR_STATUS: MAVLink_generator_status_message,
    MAVLINK_MSG_ID_ACTUATOR_OUTPUT_STATUS: MAVLink_actuator_output_status_message,
    MAVLINK_MSG_ID_RELAY_STATUS: MAVLink_relay_status_message,
    MAVLINK_MSG_ID_TUNNEL: MAVLink_tunnel_message,
    MAVLINK_MSG_ID_CAN_FRAME: MAVLink_can_frame_message,
    MAVLINK_MSG_ID_CANFD_FRAME: MAVLink_canfd_frame_message,
    MAVLINK_MSG_ID_CAN_FILTER_MODIFY: MAVLink_can_filter_modify_message,
    MAVLINK_MSG_ID_WHEEL_DISTANCE: MAVLink_wheel_distance_message,
    MAVLINK_MSG_ID_WINCH_STATUS: MAVLink_winch_status_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_BASIC_ID: MAVLink_open_drone_id_basic_id_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_LOCATION: MAVLink_open_drone_id_location_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_AUTHENTICATION: MAVLink_open_drone_id_authentication_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_SELF_ID: MAVLink_open_drone_id_self_id_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_SYSTEM: MAVLink_open_drone_id_system_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_OPERATOR_ID: MAVLink_open_drone_id_operator_id_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_ARM_STATUS: MAVLink_open_drone_id_arm_status_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_MESSAGE_PACK: MAVLink_open_drone_id_message_pack_message,
    MAVLINK_MSG_ID_OPEN_DRONE_ID_SYSTEM_UPDATE: MAVLink_open_drone_id_system_update_message,
    MAVLINK_MSG_ID_HYGROMETER_SENSOR: MAVLink_hygrometer_sensor_message,
    MAVLINK_MSG_ID_HEARTBEAT: MAVLink_heartbeat_message,
}


class MAVError(Exception):
    """MAVLink error class"""

    def __init__(self, msg: str) -> None:
        Exception.__init__(self, msg)
        self.message = msg


class MAVLink_bad_data(MAVLink_message):
    """
    a piece of bad data in a mavlink stream
    """

    def __init__(self, data: bytes, reason: str) -> None:
        MAVLink_message.__init__(self, MAVLINK_MSG_ID_BAD_DATA, "BAD_DATA")
        self._fieldnames = ["data", "reason"]
        self.data = data
        self.reason = reason
        self._msgbuf = bytearray(data)
        self._instance_field = None

    def __str__(self) -> str:
        """Override the __str__ function from MAVLink_messages because non-printable characters are common in to be the reason for this message to exist."""
        hexstr = ["{:x}".format(i) for i in self.data]
        return "%s {%s, data:%s}" % (self._type, self.reason, hexstr)


class MAVLink_unknown(MAVLink_message):
    """
    a message that we don't have in the XML used when built
    """

    def __init__(self, msgid: int, data: bytes) -> None:
        MAVLink_message.__init__(self, MAVLINK_MSG_ID_UNKNOWN, "UNKNOWN_%u" % msgid)
        self._fieldnames = ["data"]
        self.data = data
        self._msgbuf = bytearray(data)
        self._instance_field = None

    def __str__(self) -> str:
        """Override the __str__ function from MAVLink_messages because non-printable characters are common."""
        hexstr = ["{:x}".format(i) for i in self.data]
        return "%s {data:%s}" % (self._type, hexstr)


class MAVLinkSigning(object):
    """MAVLink signing state class"""

    def __init__(self) -> None:
        self.secret_key: Optional[bytes] = None
        self.timestamp = 0
        self.link_id = 0
        self.sign_outgoing = False
        self.allow_unsigned_callback: Optional[Callable[["MAVLink", int], bool]] = None
        self.stream_timestamps: Dict[Tuple[int, int, int], int] = {}
        self.sig_count = 0
        self.badsig_count = 0
        self.goodsig_count = 0
        self.unsigned_count = 0
        self.reject_count = 0


MAVLinkV1Header = Tuple[bytes, int, int, int, int, int]
MAVLinkV2Header = Tuple[bytes, int, int, int, int, int, int, int, int]

class MAVLink(object):
    """MAVLink protocol handling class"""

    def __init__(self, file: Any, srcSystem: int = 0, srcComponent: int = 0, use_native: bool = False) -> None:
        self.seq = 0
        self.file = file
        self.srcSystem = srcSystem
        self.srcComponent = srcComponent
        self.callback: Optional[Callable[..., None]] = None
        self.callback_args: Optional[Iterable[Any]] = None
        self.callback_kwargs: Optional[Mapping[str, Any]] = None
        self.send_callback: Optional[Callable[..., None]] = None
        self.send_callback_args: Optional[Iterable[Any]] = None
        self.send_callback_kwargs: Optional[Mapping[str, Any]] = None
        self.buf = bytearray()
        self.buf_index = 0
        self.expected_length = HEADER_LEN_V1 + 2
        self.have_prefix_error = False
        self.robust_parsing = False
        self.protocol_marker = 253
        self.little_endian = True
        self.crc_extra = True
        self.sort_fields = True
        self.total_packets_sent = 0
        self.total_bytes_sent = 0
        self.total_packets_received = 0
        self.total_bytes_received = 0
        self.total_receive_errors = 0
        self.startup_time = time.time()
        self.signing = MAVLinkSigning()
        self.mav20_unpacker = struct.Struct("<cBBBBBBHB")
        self.mav10_unpacker = struct.Struct("<cBBBBB")
        self.mav20_h3_unpacker = struct.Struct("BBB")
        self.mav_csum_unpacker = struct.Struct("<H")
        self.mav_sign_unpacker = struct.Struct("<IH")

    def set_callback(self, callback: Callable[..., None], *args: Any, **kwargs: Any) -> None:
        self.callback = callback
        self.callback_args = args
        self.callback_kwargs = kwargs

    def set_send_callback(self, callback: Callable[..., None], *args: Any, **kwargs: Any) -> None:
        self.send_callback = callback
        self.send_callback_args = args
        self.send_callback_kwargs = kwargs

    def send(self, mavmsg: MAVLink_message, force_mavlink1: bool = False) -> None:
        """send a MAVLink message"""
        buf = mavmsg.pack(self, force_mavlink1=force_mavlink1)
        self.file.write(buf)
        self.seq = (self.seq + 1) % 256
        self.total_packets_sent += 1
        self.total_bytes_sent += len(buf)
        if self.send_callback is not None and self.send_callback_args is not None and self.send_callback_kwargs is not None:
            self.send_callback(mavmsg, *self.send_callback_args, **self.send_callback_kwargs)

    def buf_len(self) -> int:
        return len(self.buf) - self.buf_index

    def bytes_needed(self) -> int:
        """return number of bytes needed for next parsing stage"""
        ret = self.expected_length - self.buf_len()

        if ret <= 0:
            return 1
        return ret

    def __callbacks(self, msg: MAVLink_message) -> None:
        """this method exists only to make profiling results easier to read"""
        if self.callback is not None and self.callback_args is not None and self.callback_kwargs is not None:
            self.callback(msg, *self.callback_args, **self.callback_kwargs)

    def parse_char(self, c: Sequence[int]) -> Optional[MAVLink_message]:
        """input some data bytes, possibly returning a new message"""
        self.buf.extend(c)

        self.total_bytes_received += len(c)

        m = self.__parse_char_legacy()

        if m is not None:
            self.total_packets_received += 1
            self.__callbacks(m)
        else:
            # XXX The idea here is if we've read something and there's nothing left in
            # the buffer, reset it to 0 which frees the memory
            if self.buf_len() == 0 and self.buf_index != 0:
                self.buf = bytearray()
                self.buf_index = 0

        return m

    def __parse_char_legacy(self) -> Optional[MAVLink_message]:
        """input some data bytes, possibly returning a new message"""
        header_len = HEADER_LEN_V1
        if self.buf_len() >= 1 and self.buf[self.buf_index] == PROTOCOL_MARKER_V2:
            header_len = HEADER_LEN_V2

        m: Optional[MAVLink_message] = None
        if self.buf_len() >= 1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V2:
            magic = self.buf[self.buf_index]
            self.buf_index += 1
            if self.robust_parsing:
                invalid_prefix_start = self.buf_index - 1
                while self.buf_len() >= 1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V2:
                    self.buf_index += 1
                m = MAVLink_bad_data(self.buf[invalid_prefix_start : self.buf_index], "Bad prefix")
                self.expected_length = header_len + 2
                self.total_receive_errors += 1
                return m
            if self.have_prefix_error:
                return None
            self.have_prefix_error = True
            self.total_receive_errors += 1
            raise MAVError("invalid MAVLink prefix '%s'" % magic)
        self.have_prefix_error = False
        if self.buf_len() >= 3:
            sbuf = self.buf[self.buf_index : 3 + self.buf_index]
            unpacked_h3: Tuple[int, int, int] = self.mav20_h3_unpacker.unpack(sbuf)
            magic, self.expected_length, incompat_flags = unpacked_h3
            if magic == PROTOCOL_MARKER_V2 and (incompat_flags & MAVLINK_IFLAG_SIGNED):
                self.expected_length += MAVLINK_SIGNATURE_BLOCK_LEN
            self.expected_length += header_len + 2
        if self.expected_length >= (header_len + 2) and self.buf_len() >= self.expected_length:
            mbuf = self.buf[self.buf_index : self.buf_index + self.expected_length]
            self.buf_index += self.expected_length
            self.expected_length = header_len + 2
            if self.robust_parsing:
                try:
                    if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                        raise MAVError("invalid incompat_flags 0x%x 0x%x %u" % (incompat_flags, magic, self.expected_length))
                    m = self.decode(mbuf)
                except MAVError as reason:
                    m = MAVLink_bad_data(mbuf, reason.message)
                    self.total_receive_errors += 1
            else:
                if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                    raise MAVError("invalid incompat_flags 0x%x 0x%x %u" % (incompat_flags, magic, self.expected_length))
                m = self.decode(mbuf)
            return m
        return None

    def parse_buffer(self, s: Sequence[int]) -> Optional[List[MAVLink_message]]:
        """input some data bytes, possibly returning a list of new messages"""
        m = self.parse_char(s)
        if m is None:
            return None
        ret = [m]
        while True:
            m = self.parse_char(b"")
            if m is None:
                return ret
            ret.append(m)

    def check_signature(self, msgbuf: bytearray, srcSystem: int, srcComponent: int) -> bool:
        """check signature on incoming message"""
        assert self.signing.secret_key is not None

        timestamp_buf = msgbuf[-12:-6]
        link_id = msgbuf[-13]
        tbytes: Tuple[int, int] = self.mav_sign_unpacker.unpack(timestamp_buf)
        tlow, thigh = tbytes
        timestamp = tlow + (thigh << 32)

        # see if the timestamp is acceptable
        stream_key = (link_id, srcSystem, srcComponent)
        if stream_key in self.signing.stream_timestamps:
            if timestamp <= self.signing.stream_timestamps[stream_key]:
                # reject old timestamp
                logger.info("old timestamp")
                return False
        else:
            # a new stream has appeared. Accept the timestamp if it is at most
            # one minute behind our current timestamp
            if timestamp + 6000 * 1000 < self.signing.timestamp:
                logger.info("bad new stream %s %s", timestamp / (100.0 * 1000 * 60 * 60 * 24 * 365), self.signing.timestamp / (100.0 * 1000 * 60 * 60 * 24 * 365))
                return False
            logger.info("new stream")

        # set the streams timestamp so we reject timestamps that go backwards
        self.signing.stream_timestamps[stream_key] = timestamp

        h = hashlib.new("sha256")
        h.update(self.signing.secret_key)
        h.update(msgbuf[:-6])
        sig1 = h.digest()[:6]
        sig2 = msgbuf[-6:]
        if sig1 != sig2:
            logger.info("sig mismatch")
            return False

        # the timestamp we next send with is the max of the received timestamp and
        # our current timestamp
        self.signing.timestamp = max(self.signing.timestamp, timestamp)
        return True

    def decode(self, msgbuf: bytearray) -> MAVLink_message:
        """decode a buffer as a MAVLink message"""
        # decode the header
        if msgbuf[0] != PROTOCOL_MARKER_V1:
            headerlen = 10
            try:
                header_v2: MAVLinkV2Header = self.mav20_unpacker.unpack(msgbuf[:headerlen])
            except struct.error as emsg:
                raise MAVError("Unable to unpack MAVLink header: %s" % emsg)
            magic, mlen, incompat_flags, compat_flags, seq, srcSystem, srcComponent, msgIdlow, msgIdhigh = header_v2
            msgId = msgIdlow | (msgIdhigh << 16)
        else:
            headerlen = 6
            try:
                header_v1: MAVLinkV1Header = self.mav10_unpacker.unpack(msgbuf[:headerlen])
            except struct.error as emsg:
                raise MAVError("Unable to unpack MAVLink header: %s" % emsg)
            magic, mlen, seq, srcSystem, srcComponent, msgId = header_v1
            incompat_flags = 0
            compat_flags = 0
        mapkey = msgId
        if (incompat_flags & MAVLINK_IFLAG_SIGNED) != 0:
            signature_len = MAVLINK_SIGNATURE_BLOCK_LEN
        else:
            signature_len = 0

        if ord(magic) != PROTOCOL_MARKER_V1 and ord(magic) != PROTOCOL_MARKER_V2:
            raise MAVError("invalid MAVLink prefix '{}'".format(hex(ord(magic))))
        if mlen != len(msgbuf) - (headerlen + 2 + signature_len):
            raise MAVError("invalid MAVLink message length. Got %u expected %u, msgId=%u headerlen=%u" % (len(msgbuf) - (headerlen + 2 + signature_len), mlen, msgId, headerlen))

        if mapkey not in mavlink_map:
            return MAVLink_unknown(msgId, msgbuf)

        # decode the payload
        msgtype = mavlink_map[mapkey]
        order_map = msgtype.orders
        len_map = msgtype.lengths
        crc_extra = msgtype.crc_extra

        # decode the checksum
        try:
            crc: int = self.mav_csum_unpacker.unpack(msgbuf[-(2 + signature_len) :][:2])[0]
        except struct.error as emsg:
            raise MAVError("Unable to unpack MAVLink CRC: %s" % emsg)
        crcbuf = msgbuf[1 : -(2 + signature_len)]
        if True:
            # using CRC extra
            crcbuf.append(crc_extra)
        crc2 = x25crc(crcbuf)
        if crc != crc2.crc and not MAVLINK_IGNORE_CRC:
            raise MAVError("invalid MAVLink CRC in msgID %u 0x%04x should be 0x%04x" % (msgId, crc, crc2.crc))

        sig_ok = False
        if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
            self.signing.sig_count += 1
        if self.signing.secret_key is not None:
            accept_signature = False
            if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
                sig_ok = self.check_signature(msgbuf, srcSystem, srcComponent)
                accept_signature = sig_ok
                if sig_ok:
                    self.signing.goodsig_count += 1
                else:
                    self.signing.badsig_count += 1
                if not accept_signature and self.signing.allow_unsigned_callback is not None:
                    accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                    if accept_signature:
                        self.signing.unsigned_count += 1
                    else:
                        self.signing.reject_count += 1
            elif self.signing.allow_unsigned_callback is not None:
                accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                if accept_signature:
                    self.signing.unsigned_count += 1
                else:
                    self.signing.reject_count += 1
            if not accept_signature:
                raise MAVError("Invalid signature")

        csize = msgtype.unpacker.size
        mbuf = msgbuf[headerlen : -(2 + signature_len)]
        if len(mbuf) < csize:
            # zero pad to give right size
            mbuf.extend([0] * (csize - len(mbuf)))
        if len(mbuf) < csize:
            raise MAVError("Bad message of type %s length %u needs %s" % (msgtype, len(mbuf), csize))
        mbuf = mbuf[:csize]
        try:
            t: Tuple[Union[bytes, int, float], ...] = msgtype.unpacker.unpack(mbuf)
        except struct.error as emsg:
            raise MAVError("Unable to unpack MAVLink payload type=%s payloadLength=%u: %s" % (msgtype, len(mbuf), emsg))

        tlist: List[Union[bytes, float, int, Sequence[Union[bytes, float, int]]]] = list(t)
        # handle sorted fields
        if True:
            if sum(len_map) == len(len_map):
                # message has no arrays in it
                for i in range(0, len(tlist)):
                    tlist[i] = t[order_map[i]]
            else:
                # message has some arrays
                tlist = []
                for i in range(0, len(order_map)):
                    order = order_map[i]
                    L = len_map[order]
                    tip = sum(len_map[:order])
                    field = t[tip]
                    if L == 1 or isinstance(field, bytes):
                        tlist.append(field)
                    else:
                        tlist.append(list(t[tip : (tip + L)]))

        # terminate any strings
        for i, elem in enumerate(tlist):
            if isinstance(elem, bytes):
                tlist[i] = elem.rstrip(b"\x00")

        # construct the message object
        try:
            # Note that initializers don't follow the Liskov Substitution Principle
            # therefore it can't be typechecked
            m = msgtype(*tlist)  # type: ignore
        except Exception as emsg:
            raise MAVError("Unable to instantiate MAVLink message of type %s : %s" % (msgtype, emsg))
        m._signed = sig_ok
        if m._signed:
            m._link_id = msgbuf[-13]
        m._msgbuf = msgbuf
        m._payload = msgbuf[6 : -(2 + signature_len)]
        m._crc = crc
        m._header = MAVLink_header(msgId, incompat_flags, compat_flags, mlen, seq, srcSystem, srcComponent)
        return m

    def avss_prs_sys_status_encode(self, time_boot_ms: int, error_status: int, battery_status: int, arm_status: int, charge_status: int) -> MAVLink_avss_prs_sys_status_message:
        """
        AVSS PRS system status.

        time_boot_ms              : Timestamp (time since PRS boot). [ms] (type:uint32_t)
        error_status              : PRS error statuses (type:uint32_t)
        battery_status            : Estimated battery run-time without a remote connection and PRS battery voltage (type:uint32_t)
        arm_status                : PRS arm statuses (type:uint8_t)
        charge_status             : PRS battery charge statuses (type:uint8_t)

        """
        return MAVLink_avss_prs_sys_status_message(time_boot_ms, error_status, battery_status, arm_status, charge_status)

    def avss_prs_sys_status_send(self, time_boot_ms: int, error_status: int, battery_status: int, arm_status: int, charge_status: int, force_mavlink1: bool = False) -> None:
        """
        AVSS PRS system status.

        time_boot_ms              : Timestamp (time since PRS boot). [ms] (type:uint32_t)
        error_status              : PRS error statuses (type:uint32_t)
        battery_status            : Estimated battery run-time without a remote connection and PRS battery voltage (type:uint32_t)
        arm_status                : PRS arm statuses (type:uint8_t)
        charge_status             : PRS battery charge statuses (type:uint8_t)

        """
        self.send(self.avss_prs_sys_status_encode(time_boot_ms, error_status, battery_status, arm_status, charge_status), force_mavlink1=force_mavlink1)

    def avss_drone_position_encode(self, time_boot_ms: int, lat: int, lon: int, alt: int, ground_alt: float, barometer_alt: float) -> MAVLink_avss_drone_position_message:
        """
        Drone position.

        time_boot_ms              : Timestamp (time since FC boot). [ms] (type:uint32_t)
        lat                       : Latitude, expressed [degE7] (type:int32_t)
        lon                       : Longitude, expressed [degE7] (type:int32_t)
        alt                       : Altitude (MSL). Note that virtually all GPS modules provide both WGS84 and MSL. [mm] (type:int32_t)
        ground_alt                : Altitude above ground, This altitude is measured by a ultrasound, Laser rangefinder or millimeter-wave radar [m] (type:float)
        barometer_alt             : This altitude is measured by a barometer [m] (type:float)

        """
        return MAVLink_avss_drone_position_message(time_boot_ms, lat, lon, alt, ground_alt, barometer_alt)

    def avss_drone_position_send(self, time_boot_ms: int, lat: int, lon: int, alt: int, ground_alt: float, barometer_alt: float, force_mavlink1: bool = False) -> None:
        """
        Drone position.

        time_boot_ms              : Timestamp (time since FC boot). [ms] (type:uint32_t)
        lat                       : Latitude, expressed [degE7] (type:int32_t)
        lon                       : Longitude, expressed [degE7] (type:int32_t)
        alt                       : Altitude (MSL). Note that virtually all GPS modules provide both WGS84 and MSL. [mm] (type:int32_t)
        ground_alt                : Altitude above ground, This altitude is measured by a ultrasound, Laser rangefinder or millimeter-wave radar [m] (type:float)
        barometer_alt             : This altitude is measured by a barometer [m] (type:float)

        """
        self.send(self.avss_drone_position_encode(time_boot_ms, lat, lon, alt, ground_alt, barometer_alt), force_mavlink1=force_mavlink1)

    def avss_drone_imu_encode(self, time_boot_ms: int, q1: float, q2: float, q3: float, q4: float, xacc: float, yacc: float, zacc: float, xgyro: float, ygyro: float, zgyro: float) -> MAVLink_avss_drone_imu_message:
        """
        Drone IMU data. Quaternion order is w, x, y, z and a zero rotation
        would be expressed as (1 0 0 0).

        time_boot_ms              : Timestamp (time since FC boot). [ms] (type:uint32_t)
        q1                        : Quaternion component 1, w (1 in null-rotation) (type:float)
        q2                        : Quaternion component 2, x (0 in null-rotation) (type:float)
        q3                        : Quaternion component 3, y (0 in null-rotation) (type:float)
        q4                        : Quaternion component 4, z (0 in null-rotation) (type:float)
        xacc                      : X acceleration [m/s/s] (type:float)
        yacc                      : Y acceleration [m/s/s] (type:float)
        zacc                      : Z acceleration [m/s/s] (type:float)
        xgyro                     : Angular speed around X axis [rad/s] (type:float)
        ygyro                     : Angular speed around Y axis [rad/s] (type:float)
        zgyro                     : Angular speed around Z axis [rad/s] (type:float)

        """
        return MAVLink_avss_drone_imu_message(time_boot_ms, q1, q2, q3, q4, xacc, yacc, zacc, xgyro, ygyro, zgyro)

    def avss_drone_imu_send(self, time_boot_ms: int, q1: float, q2: float, q3: float, q4: float, xacc: float, yacc: float, zacc: float, xgyro: float, ygyro: float, zgyro: float, force_mavlink1: bool = False) -> None:
        """
        Drone IMU data. Quaternion order is w, x, y, z and a zero rotation
        would be expressed as (1 0 0 0).

        time_boot_ms              : Timestamp (time since FC boot). [ms] (type:uint32_t)
        q1                        : Quaternion component 1, w (1 in null-rotation) (type:float)
        q2                        : Quaternion component 2, x (0 in null-rotation) (type:float)
        q3                        : Quaternion component 3, y (0 in null-rotation) (type:float)
        q4                        : Quaternion component 4, z (0 in null-rotation) (type:float)
        xacc                      : X acceleration [m/s/s] (type:float)
        yacc                      : Y acceleration [m/s/s] (type:float)
        zacc                      : Z acceleration [m/s/s] (type:float)
        xgyro                     : Angular speed around X axis [rad/s] (type:float)
        ygyro                     : Angular speed around Y axis [rad/s] (type:float)
        zgyro                     : Angular speed around Z axis [rad/s] (type:float)

        """
        self.send(self.avss_drone_imu_encode(time_boot_ms, q1, q2, q3, q4, xacc, yacc, zacc, xgyro, ygyro, zgyro), force_mavlink1=force_mavlink1)

    def avss_drone_operation_mode_encode(self, time_boot_ms: int, M300_operation_mode: int, horsefly_operation_mode: int) -> MAVLink_avss_drone_operation_mode_message:
        """
        Drone operation mode.

        time_boot_ms              : Timestamp (time since FC boot). [ms] (type:uint32_t)
        M300_operation_mode        : DJI M300 operation mode (type:uint8_t)
        horsefly_operation_mode        : horsefly operation mode (type:uint8_t)

        """
        return MAVLink_avss_drone_operation_mode_message(time_boot_ms, M300_operation_mode, horsefly_operation_mode)

    def avss_drone_operation_mode_send(self, time_boot_ms: int, M300_operation_mode: int, horsefly_operation_mode: int, force_mavlink1: bool = False) -> None:
        """
        Drone operation mode.

        time_boot_ms              : Timestamp (time since FC boot). [ms] (type:uint32_t)
        M300_operation_mode        : DJI M300 operation mode (type:uint8_t)
        horsefly_operation_mode        : horsefly operation mode (type:uint8_t)

        """
        self.send(self.avss_drone_operation_mode_encode(time_boot_ms, M300_operation_mode, horsefly_operation_mode), force_mavlink1=force_mavlink1)

    def sys_status_encode(self, onboard_control_sensors_present: int, onboard_control_sensors_enabled: int, onboard_control_sensors_health: int, load: int, voltage_battery: int, current_battery: int, battery_remaining: int, drop_rate_comm: int, errors_comm: int, errors_count1: int, errors_count2: int, errors_count3: int, errors_count4: int) -> MAVLink_sys_status_message:
        """
        The general system state. If the system is following the MAVLink
        standard, the system state is mainly defined by three
        orthogonal states/modes: The system mode, which is either
        LOCKED (motors shut down and locked), MANUAL (system under RC
        control), GUIDED (system with autonomous position control,
        position setpoint controlled manually) or AUTO (system guided
        by path/waypoint planner). The NAV_MODE defined the current
        flight state: LIFTOFF (often an open-loop maneuver), LANDING,
        WAYPOINTS or VECTOR. This represents the internal navigation
        state machine. The system status shows whether the system is
        currently active or not and if an emergency occurred. During
        the CRITICAL and EMERGENCY states the MAV is still considered
        to be active, but should start emergency procedures
        autonomously. After a failure occurred it should first move
        from active to critical to allow manual intervention and then
        move to emergency after a certain timeout.

        onboard_control_sensors_present        : Bitmap showing which onboard controllers and sensors are present. Value of 0: not present. Value of 1: present. (type:uint32_t, values:MAV_SYS_STATUS_SENSOR)
        onboard_control_sensors_enabled        : Bitmap showing which onboard controllers and sensors are enabled:  Value of 0: not enabled. Value of 1: enabled. (type:uint32_t, values:MAV_SYS_STATUS_SENSOR)
        onboard_control_sensors_health        : Bitmap showing which onboard controllers and sensors have an error (or are operational). Value of 0: error. Value of 1: healthy. (type:uint32_t, values:MAV_SYS_STATUS_SENSOR)
        load                      : Maximum usage in percent of the mainloop time. Values: [0-1000] - should always be below 1000 [d%] (type:uint16_t)
        voltage_battery           : Battery voltage, UINT16_MAX: Voltage not sent by autopilot [mV] (type:uint16_t)
        current_battery           : Battery current, -1: Current not sent by autopilot [cA] (type:int16_t)
        battery_remaining         : Battery energy remaining, -1: Battery remaining energy not sent by autopilot [%] (type:int8_t)
        drop_rate_comm            : Communication drop rate, (UART, I2C, SPI, CAN), dropped packets on all links (packets that were corrupted on reception on the MAV) [c%] (type:uint16_t)
        errors_comm               : Communication errors (UART, I2C, SPI, CAN), dropped packets on all links (packets that were corrupted on reception on the MAV) (type:uint16_t)
        errors_count1             : Autopilot-specific errors (type:uint16_t)
        errors_count2             : Autopilot-specific errors (type:uint16_t)
        errors_count3             : Autopilot-specific errors (type:uint16_t)
        errors_count4             : Autopilot-specific errors (type:uint16_t)

        """
        return MAVLink_sys_status_message(onboard_control_sensors_present, onboard_control_sensors_enabled, onboard_control_sensors_health, load, voltage_battery, current_battery, battery_remaining, drop_rate_comm, errors_comm, errors_count1, errors_count2, errors_count3, errors_count4)

    def sys_status_send(self, onboard_control_sensors_present: int, onboard_control_sensors_enabled: int, onboard_control_sensors_health: int, load: int, voltage_battery: int, current_battery: int, battery_remaining: int, drop_rate_comm: int, errors_comm: int, errors_count1: int, errors_count2: int, errors_count3: int, errors_count4: int, force_mavlink1: bool = False) -> None:
        """
        The general system state. If the system is following the MAVLink
        standard, the system state is mainly define