import numpy as np
import matplotlib.pyplot as plt
from matplotlib.ticker import ScalarFormatter
import astropy.units as u

from dust_extinction.shapes import FM90

fig, ax = plt.subplots()

# generate the curves and plot them
x = np.arange(3.8,11.0,0.1)/u.micron

ext_model = FM90()
ax.plot(1./x,ext_model(x),label='total')

ext_model = FM90(C3=0.0, C4=0.0)
ax.plot(1./x,ext_model(x),label='linear term')

ext_model = FM90(C1=0.0, C2=0.0, C4=0.0)
ax.plot(1./x,ext_model(x),label='bump term')

ext_model = FM90(C1=0.0, C2=0.0, C3=0.0)
ax.plot(1./x,ext_model(x),label='FUV rise term')

ax.set_xscale('log')
ax.xaxis.set_major_formatter(ScalarFormatter())
ax.xaxis.set_minor_formatter(ScalarFormatter())
ax.set_xlabel(r'$\lambda$ [$\mu$m]')
ax.set_ylabel('$E(\lambda - V)/E(B - V)$')

ax.set_title('FM90')

ax.legend(loc='best')
plt.tight_layout()
plt.show()