import numpy as np
import matplotlib.pyplot as plt
from matplotlib.ticker import ScalarFormatter
import astropy.units as u

from dust_extinction.averages import (GCC09_MWAvg,
                                      B92_MWAvg,
                                      G03_SMCBar,
                                      G03_LMCAvg,
                                                               G03_LMC2,
                                      G24_SMCAvg,
                                      G24_SMCBumps,
                                      C25_M31Avg,
                                      G25_M33Avg)

fig, ax = plt.subplots()

# generate the curves and plot them
x = np.arange(0.3,11.0,0.1)/u.micron

models = [GCC09_MWAvg, B92_MWAvg, G03_SMCBar, G03_LMCAvg, G03_LMC2,
          G24_SMCAvg, G24_SMCBumps, C25_M31Avg, G25_M33Avg]

for cmodel in models:
   ext_model = cmodel()
   indxs, = np.where(np.logical_and(
      x.value >= ext_model.x_range[0],
      x.value <= ext_model.x_range[1]))
   yvals = ext_model(x[indxs])
   ax.plot(1./x[indxs], yvals, label=ext_model.__class__.__name__)

ax.set_xscale('log')
ax.xaxis.set_major_formatter(ScalarFormatter())

ax.set_xlabel(r'$\lambda$ [$\mu$m]')
ax.set_ylabel(r'$A(\lambda)/A(V)$')
ax.set_title('Ultraviolet to Near-Infrared Models')

ax.legend(loc='best')
plt.tight_layout()
plt.show()