import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { UpdateAutomatedReasoningPolicyAnnotationsRequestFilterSensitiveLog, } from "../models/models_0";
import { de_UpdateAutomatedReasoningPolicyAnnotationsCommand, se_UpdateAutomatedReasoningPolicyAnnotationsCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class UpdateAutomatedReasoningPolicyAnnotationsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonBedrockControlPlaneService", "UpdateAutomatedReasoningPolicyAnnotations", {})
    .n("BedrockClient", "UpdateAutomatedReasoningPolicyAnnotationsCommand")
    .f(UpdateAutomatedReasoningPolicyAnnotationsRequestFilterSensitiveLog, void 0)
    .ser(se_UpdateAutomatedReasoningPolicyAnnotationsCommand)
    .de(de_UpdateAutomatedReasoningPolicyAnnotationsCommand)
    .build() {
}
