/*
 * Decompiled with CFR 0.152.
 */
package plplot.examples;

import plplot.core.PLStream;
import plplot.core.plplotjavacConstants;
import plplot.examples.Transform;

class x22 {
    PLStream pls = new PLStream();
    double[][] u = null;
    double[][] v = null;
    double[][] xg = null;
    double[][] yg = null;
    int nx;
    int ny;
    int nc;
    int nseg;

    double MIN(double d, double d2) {
        return d < d2 ? d : d2;
    }

    double MAX(double d, double d2) {
        return d > d2 ? d : d2;
    }

    void circulation() {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = (double)(-this.nx / 2) * d;
        double d4 = (double)(this.nx / 2) * d;
        double d5 = (double)(-this.ny / 2) * d2;
        double d6 = (double)(this.ny / 2) * d2;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                double d7 = ((double)(i - this.nx / 2) + 0.5) * d;
                double d8 = ((double)(j - this.ny / 2) + 0.5) * d2;
                this.xg[i][j] = d7;
                this.yg[i][j] = d8;
                this.u[i][j] = d8;
                this.v[i][j] = -d7;
            }
        }
        this.pls.env(d3, d4, d5, d6, 0, 0);
        this.pls.lab("(x)", "(y)", "#frPLplot Example 22 - circulation");
        this.pls.col0(2);
        this.pls.vect(this.u, this.v, 0.0, this.xg, this.yg);
        this.pls.col0(1);
    }

    void constriction(int n) {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = (double)(-this.nx / 2) * d;
        double d4 = (double)(this.nx / 2) * d;
        double d5 = (double)(-this.ny / 2) * d2;
        double d6 = (double)(this.ny / 2) * d2;
        double d7 = 2.0;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                double d8 = ((double)(i - this.nx / 2) + 0.5) * d;
                double d9 = ((double)(j - this.ny / 2) + 0.5) * d2;
                this.xg[i][j] = d8;
                this.yg[i][j] = d9;
                double d10 = d6 / 4.0 * (3.0 - Math.cos(Math.PI * d8 / d4));
                if (Math.abs(d9) < d10) {
                    double d11 = d6 / 4.0 * Math.sin(Math.PI * d8 / d4) * Math.PI / d4 * d9 / d10;
                    this.u[i][j] = d7 * d6 / d10;
                    this.v[i][j] = d11 * this.u[i][j];
                    continue;
                }
                this.u[i][j] = 0.0;
                this.v[i][j] = 0.0;
            }
        }
        this.pls.env(d3, d4, d5, d6, 0, 0);
        this.pls.lab("(x)", "(y)", "#frPLplot Example 22 - constriction (arrow style " + n + ")");
        this.pls.col0(2);
        this.pls.vect(this.u, this.v, -1.0, this.xg, this.yg);
        this.pls.col0(1);
    }

    void constriction2() {
        int n;
        double[] dArray = new double[this.nc];
        Transform transform = new Transform();
        double d = 1.0;
        double d2 = 1.0;
        double d3 = (double)(-this.nx / 2) * d;
        double d4 = (double)(this.nx / 2) * d;
        double d5 = (double)(-this.ny / 2) * d2;
        double d6 = (double)(this.ny / 2) * d2;
        this.pls.stransform(transform, d4);
        double d7 = 2.0;
        for (n = 0; n < this.nx; ++n) {
            double d8 = ((double)(n - this.nx / 2) + 0.5) * d;
            for (int i = 0; i < this.ny; ++i) {
                double d9 = ((double)(i - this.ny / 2) + 0.5) * d2;
                this.xg[n][i] = d8;
                this.yg[n][i] = d9;
                double d10 = d6 / 4.0 * (3.0 - Math.cos(Math.PI * d8 / d4));
                this.u[n][i] = d7 * d6 / d10;
                this.v[n][i] = 0.0;
            }
        }
        for (n = 0; n < this.nc; ++n) {
            dArray[n] = d7 + (double)n * d7 / (double)(this.nc - 1);
        }
        this.pls.env(d3, d4, d5, d6, 0, 0);
        this.pls.lab("(x)", "(y)", "#frPLplot Example 22 - constriction with plstransform");
        this.pls.col0(2);
        this.pls.shades(this.u, d3 + d / 2.0, d4 - d / 2.0, d5 + d2 / 2.0, d6 - d2 / 2.0, dArray, 0.0, 1, 1.0, 0, this.xg, this.yg);
        this.pls.vect(this.u, this.v, -1.0, this.xg, this.yg);
        this.pls.path(this.nseg, d3, d6, d4, d6);
        this.pls.path(this.nseg, d3, d5, d4, d5);
        this.pls.col0(1);
        this.pls.stransform(null, null);
    }

    void potential() {
        double d;
        int n;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[100];
        double[] dArray5 = new double[100];
        double[] dArray6 = new double[10];
        int n2 = this.nx;
        int n3 = this.ny;
        double[][] dArray7 = new double[n2][n3];
        double d2 = n2;
        double d3 = 2.0;
        double d4 = 1.0;
        double d5 = d2 / 4.0;
        double d6 = -d4 * d2 / d5;
        double d7 = Math.pow(d2, 2.0) / d5;
        double d8 = -1.0;
        double d9 = d2 / 4.0;
        double d10 = -d8 * d2 / d9;
        double d11 = Math.pow(d2, 2.0) / d9;
        for (n = 0; n < n2; ++n) {
            double d12 = 0.5 + (double)n;
            for (int i = 0; i < n3; ++i) {
                d = Math.PI * 2 / (double)(n3 - 1) * (0.5 + (double)i);
                double d13 = d12 * Math.cos(d);
                double d14 = d12 * Math.sin(d);
                this.xg[n][i] = d13;
                this.yg[n][i] = d14;
                double d15 = Math.sqrt(Math.pow(d13 - d5, 2.0) + Math.pow(d14 - d5, 2.0) + Math.pow(d3, 2.0));
                double d16 = Math.sqrt(Math.pow(d13 - d7, 2.0) + Math.pow(d14 - d7, 2.0) + Math.pow(d3, 2.0));
                double d17 = Math.sqrt(Math.pow(d13 - d9, 2.0) + Math.pow(d14 + d9, 2.0) + Math.pow(d3, 2.0));
                double d18 = Math.sqrt(Math.pow(d13 - d11, 2.0) + Math.pow(d14 + d11, 2.0) + Math.pow(d3, 2.0));
                dArray7[n][i] = d4 / d15 + d6 / d16 + d8 / d17 + d10 / d18;
                this.u[n][i] = -d4 * (d13 - d5) / Math.pow(d15, 3.0) - d6 * (d13 - d7) / Math.pow(d16, 3.0) - d8 * (d13 - d9) / Math.pow(d17, 3.0) - d10 * (d13 - d11) / Math.pow(d18, 3.0);
                this.v[n][i] = -d4 * (d14 - d5) / Math.pow(d15, 3.0) - d6 * (d14 - d7) / Math.pow(d16, 3.0) - d8 * (d14 + d9) / Math.pow(d17, 3.0) - d10 * (d14 + d11) / Math.pow(d18, 3.0);
            }
        }
        this.f2mnmx(this.xg, n2, n3, dArray);
        this.f2mnmx(this.yg, n2, n3, dArray2);
        this.f2mnmx(dArray7, n2, n3, dArray3);
        this.pls.env(dArray[1], dArray[0], dArray2[1], dArray2[0], 0, 0);
        this.pls.lab("(x)", "(y)", "#frPLplot Example 22 - potential gradient vector plot");
        double d19 = (dArray3[0] - dArray3[1]) / 10.0;
        for (n = 0; n < 10; ++n) {
            dArray6[n] = dArray3[1] + ((double)n + 0.5) * d19;
        }
        this.pls.col0(3);
        this.pls.lsty(2);
        this.pls.cont(dArray7, 1, n2, 1, n3, dArray6, this.xg, this.yg);
        this.pls.lsty(1);
        this.pls.col0(1);
        this.pls.col0(2);
        this.pls.vect(this.u, this.v, 25.0, this.xg, this.yg);
        this.pls.col0(1);
        for (n = 0; n < 100; ++n) {
            d = 0.06346651825433926 * (double)n;
            dArray4[n] = d2 * Math.cos(d);
            dArray5[n] = d2 * Math.sin(d);
        }
        this.pls.line(dArray4, dArray5);
    }

    void f2mnmx(double[][] dArray, int n, int n2, double[] dArray2) {
        dArray2[0] = dArray[0][0];
        dArray2[1] = dArray2[0];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[0] = this.MAX(dArray2[0], dArray[i][j]);
                dArray2[1] = this.MIN(dArray2[1], dArray[i][j]);
            }
        }
    }

    public x22(String[] stringArray) {
        double[] dArray = new double[]{-0.5, 0.5, 0.3, 0.5, 0.3, 0.5};
        double[] dArray2 = new double[]{0.0, 0.0, 0.2, 0.0, -0.2, 0.0};
        double[] dArray3 = new double[]{-0.5, 0.3, 0.3, 0.5, 0.3, 0.3};
        double[] dArray4 = new double[]{0.0, 0.0, 0.2, 0.0, -0.2, 0.0};
        this.pls.parseopts(stringArray, plplotjavacConstants.PL_PARSE_FULL | plplotjavacConstants.PL_PARSE_NOPROGRAM);
        this.pls.init();
        this.nx = 20;
        this.ny = 20;
        this.nc = 11;
        this.nseg = 20;
        this.u = new double[this.nx][this.ny];
        this.v = new double[this.nx][this.ny];
        this.xg = new double[this.nx][this.ny];
        this.yg = new double[this.nx][this.ny];
        this.circulation();
        boolean bl = false;
        this.pls.svect(dArray, dArray2, bl);
        this.constriction(1);
        bl = true;
        this.pls.svect(dArray3, dArray4, bl);
        this.constriction(2);
        this.constriction2();
        this.pls.svect(null, null, false);
        this.potential();
        this.pls.end();
    }

    public static void main(String[] stringArray) {
        new x22(stringArray);
    }
}

