#if !defined(INCLUDED_PETSCPKG_VERSION_H)
#define INCLUDED_PETSCPKG_VERSION_H

#define PETSC_PKG_MPI_VERSION_MAJOR 3
#define PETSC_PKG_MPI_VERSION_MINOR 0
#define PETSC_PKG_MPI_VERSION_SUBMINOR 0
#define PETSC_PKG_MPI_VERSION_ PETSC_PKG_MPI_VERSION_EQ

#define PETSC_PKG_MPI_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_MPI_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_MPI_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_MPI_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_MPI_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_MPI_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_MPI_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_MPI_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_MPI_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_MPI_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_MPI_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_MPI_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_MPI_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_MPI_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_MPI_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_MPI_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_MPI_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_OPENMPI_VERSION_MAJOR 5
#define PETSC_PKG_OPENMPI_VERSION_MINOR 0
#define PETSC_PKG_OPENMPI_VERSION_SUBMINOR 8
#define PETSC_PKG_OPENMPI_VERSION_ PETSC_PKG_OPENMPI_VERSION_EQ

#define PETSC_PKG_OPENMPI_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_OPENMPI_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_OPENMPI_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_OPENMPI_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_OPENMPI_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_OPENMPI_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_OPENMPI_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_OPENMPI_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_OPENMPI_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_OPENMPI_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_OPENMPI_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_OPENMPI_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_OPENMPI_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_OPENMPI_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_OPENMPI_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_OPENMPI_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_OPENMPI_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_ZLIB_VERSION_MAJOR 1
#define PETSC_PKG_ZLIB_VERSION_MINOR 3
#define PETSC_PKG_ZLIB_VERSION_SUBMINOR 1
#define PETSC_PKG_ZLIB_VERSION_ PETSC_PKG_ZLIB_VERSION_EQ

#define PETSC_PKG_ZLIB_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_ZLIB_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_ZLIB_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_ZLIB_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_ZLIB_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_ZLIB_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_ZLIB_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_ZLIB_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_ZLIB_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_ZLIB_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_ZLIB_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_ZLIB_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_ZLIB_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_ZLIB_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_ZLIB_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_ZLIB_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_ZLIB_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_HDF5_VERSION_MAJOR 1
#define PETSC_PKG_HDF5_VERSION_MINOR 14
#define PETSC_PKG_HDF5_VERSION_SUBMINOR 6
#define PETSC_PKG_HDF5_VERSION_ PETSC_PKG_HDF5_VERSION_EQ

#define PETSC_PKG_HDF5_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_HDF5_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_HDF5_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_HDF5_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_HDF5_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_HDF5_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_HDF5_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_HDF5_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_HDF5_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_HDF5_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_HDF5_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_HDF5_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_HDF5_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_HDF5_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_HDF5_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_HDF5_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_HDF5_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_NETCDF_VERSION_MAJOR 4
#define PETSC_PKG_NETCDF_VERSION_MINOR 9
#define PETSC_PKG_NETCDF_VERSION_SUBMINOR 3
#define PETSC_PKG_NETCDF_VERSION_ PETSC_PKG_NETCDF_VERSION_EQ

#define PETSC_PKG_NETCDF_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_NETCDF_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_NETCDF_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_NETCDF_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_NETCDF_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_NETCDF_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_NETCDF_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_NETCDF_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_NETCDF_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_NETCDF_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_NETCDF_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_NETCDF_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_NETCDF_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_NETCDF_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_NETCDF_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_NETCDF_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_NETCDF_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_METIS_VERSION_MAJOR 5
#define PETSC_PKG_METIS_VERSION_MINOR 2
#define PETSC_PKG_METIS_VERSION_SUBMINOR 1
#define PETSC_PKG_METIS_VERSION_ PETSC_PKG_METIS_VERSION_EQ

#define PETSC_PKG_METIS_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_METIS_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_METIS_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_METIS_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_METIS_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_METIS_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_METIS_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_METIS_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_METIS_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_METIS_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_METIS_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_METIS_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_METIS_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_METIS_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_METIS_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_METIS_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_METIS_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_SUITESPARSE_VERSION_MAJOR 7
#define PETSC_PKG_SUITESPARSE_VERSION_MINOR 11
#define PETSC_PKG_SUITESPARSE_VERSION_SUBMINOR 0
#define PETSC_PKG_SUITESPARSE_VERSION_ PETSC_PKG_SUITESPARSE_VERSION_EQ

#define PETSC_PKG_SUITESPARSE_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_SUITESPARSE_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_SUITESPARSE_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_SUITESPARSE_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_SUITESPARSE_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_SUITESPARSE_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_SUITESPARSE_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_SUITESPARSE_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_SUITESPARSE_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_SUITESPARSE_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_SUITESPARSE_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_SUITESPARSE_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_SUITESPARSE_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_SUITESPARSE_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_SUITESPARSE_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_SUITESPARSE_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_SUITESPARSE_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_PARMETIS_VERSION_MAJOR 4
#define PETSC_PKG_PARMETIS_VERSION_MINOR 0
#define PETSC_PKG_PARMETIS_VERSION_SUBMINOR 3
#define PETSC_PKG_PARMETIS_VERSION_ PETSC_PKG_PARMETIS_VERSION_EQ

#define PETSC_PKG_PARMETIS_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_PARMETIS_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_PARMETIS_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_PARMETIS_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_PARMETIS_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_PARMETIS_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_PARMETIS_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_PARMETIS_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_PARMETIS_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_PARMETIS_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_PARMETIS_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_PARMETIS_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_PARMETIS_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_PARMETIS_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_PARMETIS_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_PARMETIS_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_PARMETIS_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_PTSCOTCH_VERSION_MAJOR 7
#define PETSC_PKG_PTSCOTCH_VERSION_MINOR 0
#define PETSC_PKG_PTSCOTCH_VERSION_SUBMINOR 8
#define PETSC_PKG_PTSCOTCH_VERSION_ PETSC_PKG_PTSCOTCH_VERSION_EQ

#define PETSC_PKG_PTSCOTCH_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_PTSCOTCH_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_PTSCOTCH_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_PTSCOTCH_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_PTSCOTCH_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_PTSCOTCH_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_PTSCOTCH_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_PTSCOTCH_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_PTSCOTCH_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_PTSCOTCH_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_PTSCOTCH_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_PTSCOTCH_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_PTSCOTCH_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_PTSCOTCH_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_PTSCOTCH_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_PTSCOTCH_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_PTSCOTCH_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_MUMPS_VERSION_MAJOR 5
#define PETSC_PKG_MUMPS_VERSION_MINOR 8
#define PETSC_PKG_MUMPS_VERSION_SUBMINOR 0
#define PETSC_PKG_MUMPS_VERSION_ PETSC_PKG_MUMPS_VERSION_EQ

#define PETSC_PKG_MUMPS_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_MUMPS_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_MUMPS_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_MUMPS_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_MUMPS_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_MUMPS_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_MUMPS_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_MUMPS_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_MUMPS_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_MUMPS_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_MUMPS_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_MUMPS_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_MUMPS_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_MUMPS_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_MUMPS_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_MUMPS_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_MUMPS_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_SUPERLU_VERSION_MAJOR 7
#define PETSC_PKG_SUPERLU_VERSION_MINOR 0
#define PETSC_PKG_SUPERLU_VERSION_SUBMINOR 0
#define PETSC_PKG_SUPERLU_VERSION_ PETSC_PKG_SUPERLU_VERSION_EQ

#define PETSC_PKG_SUPERLU_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_SUPERLU_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_SUPERLU_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_SUPERLU_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_SUPERLU_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_SUPERLU_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_SUPERLU_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_SUPERLU_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_SUPERLU_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_SUPERLU_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_SUPERLU_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_SUPERLU_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_SUPERLU_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_SUPERLU_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_SUPERLU_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_SUPERLU_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_SUPERLU_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_GSL_VERSION_MAJOR 2
#define PETSC_PKG_GSL_VERSION_MINOR 8
#define PETSC_PKG_GSL_VERSION_SUBMINOR 0
#define PETSC_PKG_GSL_VERSION_ PETSC_PKG_GSL_VERSION_EQ

#define PETSC_PKG_GSL_VERSION_EQ(MAJOR,MINOR,SUBMINOR)         \
      ((PETSC_PKG_GSL_VERSION_MAJOR    == (MAJOR)) &&          \
       (PETSC_PKG_GSL_VERSION_MINOR    == (MINOR)) &&          \
       (PETSC_PKG_GSL_VERSION_SUBMINOR == (SUBMINOR)))

#define PETSC_PKG_GSL_VERSION_LT(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_GSL_VERSION_MAJOR  < (MAJOR) ||              \
        (PETSC_PKG_GSL_VERSION_MAJOR == (MAJOR) &&             \
         (PETSC_PKG_GSL_VERSION_MINOR  < (MINOR) ||            \
          (PETSC_PKG_GSL_VERSION_MINOR == (MINOR) &&           \
           (PETSC_PKG_GSL_VERSION_SUBMINOR  < (SUBMINOR))))))

#define PETSC_PKG_GSL_VERSION_LE(MAJOR,MINOR,SUBMINOR)         \
       (PETSC_PKG_GSL_VERSION_LT(MAJOR,MINOR,SUBMINOR) ||      \
        PETSC_PKG_GSL_VERSION_EQ(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_GSL_VERSION_GT(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_GSL_VERSION_LE(MAJOR,MINOR,SUBMINOR))

#define PETSC_PKG_GSL_VERSION_GE(MAJOR,MINOR,SUBMINOR)         \
       ( 0 == PETSC_PKG_GSL_VERSION_LT(MAJOR,MINOR,SUBMINOR))

#endif
