/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class GilbertTwoWorld
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Gilbert Two-World";
    public static final int PROPERTIES = 0x200100;
    private double rhoBorder_;
    private double cosPhiCP_;
    private double sinPhiCP_;
    private GilbertTwoWorld dummyProj_;
    private boolean isDummy_;

    public GilbertTwoWorld(int width, int height) {
        this(width, height, 0, 0);
    }

    public GilbertTwoWorld(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200100, width, height, xmargin, ymargin, 1.0, 1.0);
        this.dummyProj_ = new GilbertTwoWorld(width, height, xmargin, ymargin, true);
        this.finishConstruction();
    }

    private GilbertTwoWorld(int width, int height, int xmargin, int ymargin, boolean isDummy) {
        super(PROJECTION_NAME, 0x200100, width, height, xmargin, ymargin, 1.0, 1.0);
        this.isDummy_ = isDummy;
        this.finishConstruction();
    }

    @Override
    public void setSizeAndMargins(int w, int h, int xm, int ym) {
        super.setSizeAndMargins(w, h, xm, ym);
        if (this.dummyProj_ != null) {
            this.dummyProj_.setSizeAndMargins(w, h, xm, ym);
        }
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        double phiCPRad = Math.asin(Math.tan(0.5 * this.phiCRad_));
        this.cosPhiCP_ = Math.cos(phiCPRad);
        this.sinPhiCP_ = Math.sin(phiCPRad);
        if (this.dummyProj_ != null) {
            this.dummyProj_.setCenter(lon, lat);
        }
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        if (this.isDummy_) {
            lambdaRad += Math.PI * 2;
        }
        double phiRad = Math.toRadians(lat);
        double lambdaPRad = 0.5 * lambdaRad;
        double phiPRad = Math.asin(Math.tan(0.5 * phiRad));
        double cosLambdaP = Math.cos(lambdaPRad);
        double cosPhiP = Math.cos(phiPRad);
        double sinPhiP = Math.sin(phiPRad);
        double cosZ = this.sinPhiCP_ * sinPhiP + this.cosPhiCP_ * cosPhiP * cosLambdaP;
        if (cosZ < 0.0) {
            return null;
        }
        if (cosZ == 1.0) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double x = cosPhiP * Math.sin(lambdaPRad);
        double y = this.cosPhiCP_ * sinPhiP - this.sinPhiCP_ * cosPhiP * cosLambdaP;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rS_ * this.rS_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double sinZ = rho * this.invRS_;
        double cosZ = Math.sqrt(1.0 - sinZ * sinZ);
        double phiPRad = Math.asin(cosZ * this.sinPhiCP_ + y * sinZ * this.cosPhiCP_ / rho);
        double lambdaPRad = Math.atan2(x * sinZ, rho * this.cosPhiCP_ * cosZ - y * this.sinPhiCP_ * sinZ);
        double phiRad = 2.0 * Math.atan(Math.sin(phiPRad));
        double lambdaRad = 2.0 * lambdaPRad;
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GilbertTwoWorld gilbertTwoWorld = this;
        synchronized (gilbertTwoWorld) {
            double r2s2 = this.rS_ * this.rS_;
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double y2 = y * y;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double rho2 = x * x + y2;
                    if (rho2 > r2s2) continue;
                    double rho = Math.sqrt(rho2);
                    double sinZ = rho * this.invRS_;
                    double cosZ = Math.sqrt(1.0 - sinZ * sinZ);
                    double phiPRad = Math.asin(cosZ * this.sinPhiCP_ + y * sinZ * this.cosPhiCP_ / rho);
                    double lambdaPRad = Math.atan2(x * sinZ, rho * this.cosPhiCP_ * cosZ - y * this.sinPhiCP_ * sinZ);
                    double phiRad = 2.0 * Math.atan(Math.sin(phiPRad));
                    double lambdaRad = 2.0 * lambdaPRad;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (this.phiC_ > 89.99999 || this.phiC_ < -89.99999) {
            if (lat == 0.0 || this.phiC_ > 0.0 && lat < 0.0 || this.phiC_ < 0.0 && lat > 0.0) {
                return;
            }
            Point2D.Double p2d = this.transformLL2XY(this.lambdaC_, lat);
            if (p2d == null) {
                return;
            }
            double dx = p2d.x - (double)this.outCenterX_;
            double dy = p2d.y - (double)this.outCenterY_;
            double radius = Math.hypot(dx, dy);
            ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, radius, radius);
        } else if (Math.abs(this.phiC_) < 1.0E-5) {
            Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 179.99999, lat);
            Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 179.99999, lat);
            GraphicUtils.drawLine(g2d, dot1, dot2);
        } else {
            super.drawParallel(g2d, lat, label);
            if (this.dummyProj_ != null) {
                this.dummyProj_.drawParallel(g2d, lat, null);
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        if (this.phiC_ > 89.99999 || this.phiC_ < -89.99999) {
            if (this.dummyProj_ == null) {
                return;
            }
            double small = this.phiC_ > 0.0 ? 1.0E-5 : -1.0E-5;
            Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon, small);
            Point2D.Double dot2 = this.dummyProj_.transformLL2XYIgnoreMargins(lon, small);
            GraphicUtils.drawLine(g2d, dot1, dot2);
        } else {
            super.drawMeridian(g2d, lon, maxLat, label);
            if (this.dummyProj_ != null) {
                this.dummyProj_.drawMeridian(g2d, lon, maxLat, label);
            }
        }
    }

    @Override
    protected void drawPathSection(Graphics2D g2d, PointLL[] llPoints, String ltext, Font lfont) {
        super.drawPathSection(g2d, llPoints, ltext, lfont);
        if (this.dummyProj_ != null) {
            this.dummyProj_.setPathStroke(this.getPathStroke());
            this.dummyProj_.setPathColor(this.getPathColor());
            this.dummyProj_.drawPathSection(g2d, llPoints, ltext, lfont);
        }
    }

    @Override
    public void markPoint(Graphics2D g2d, PointLL llPoint, BasicStroke stroke, Color edgeColor, Color fillColor) {
        super.markPoint(g2d, llPoint, stroke, edgeColor, fillColor);
    }

    @Override
    public void markPoints(Graphics2D g2d, PointLL[] llPoints, BasicStroke stroke, Color edgeColor, Color fillColor) {
        super.markPoints(g2d, llPoints, stroke, edgeColor, fillColor);
        if (this.dummyProj_ != null) {
            this.dummyProj_.markPoints(g2d, llPoints, stroke, edgeColor, fillColor);
        }
    }
}

