/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleCordiform
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Double Cordiform";
    public static final int PROPERTIES = 0x2002200;
    private static final double MAX_X_OVER_RS;
    private static final double MAX_Y_OVER_RS;
    private static final double YR_SHIFT = 1.5707963267948966;

    public DoubleCordiform(int width, int height) {
        this(width, height, 0, 0);
    }

    public DoubleCordiform(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2002200, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(Math.abs(lat));
        double alphaRad = 1.5707963267948966 - phiRad;
        if (Math.abs(alphaRad) < 1.0E-5) {
            if (lat < 0.0) {
                return new Point2D.Double((double)this.outCenterX_ + 1.5707963267948966 * this.rS_, this.outCenterY_);
            }
            return new Point2D.Double((double)this.outCenterX_ - 1.5707963267948966 * this.rS_, this.outCenterY_);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double betaRad = lambdaRad * Math.cos(phiRad) / alphaRad;
        double xr = alphaRad * Math.sin(betaRad);
        double yr = 1.5707963267948966 - alphaRad * Math.cos(betaRad);
        if (lat < 0.0) {
            yr = -yr;
        }
        double x = (double)this.outCenterX_ - yr * this.rS_;
        double y = (double)this.outCenterY_ - xr * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xr = y;
        double xrOverRS = xr * this.invRS_;
        double yr = -x;
        double yrOverRS = Math.abs(yr) * this.invRS_ - 1.5707963267948966;
        double yr1 = 0.0 - yrOverRS;
        double alphaRad = Math.hypot(xrOverRS, yr1);
        double phiRad = 1.5707963267948966 - alphaRad;
        if (phiRad > 1.5707963267948966 || phiRad < 0.0) {
            return null;
        }
        double betaRad = Math.atan2(xrOverRS, yr1);
        double lambdaRad = betaRad * alphaRad / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.signum(yr) * Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        DoubleCordiform doubleCordiform = this;
        synchronized (doubleCordiform) {
            for (int ix = 0; ix < this.dxMax_; ++ix) {
                double xr;
                double xrOverRS;
                double alphaRad;
                double phiRad;
                double yr = -((double)ix) + 0.5;
                double yrOverRS = Math.abs(yr) * this.invRS_ - 1.5707963267948966;
                double yr1 = 0.0 - yrOverRS;
                for (int iy = 0; iy < this.dyMax_ && !((phiRad = 1.5707963267948966 - (alphaRad = Math.hypot(xrOverRS = (xr = (double)iy + 0.5) * this.invRS_, yr1))) < 0.0); ++iy) {
                    double betaRad;
                    double lambdaRad;
                    if (phiRad > 1.5707963267948966 || Math.abs(lambdaRad = (betaRad = Math.atan2(xrOverRS, yr1)) * alphaRad / Math.cos(phiRad)) > Math.PI) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), -Math.toDegrees(phiRad));
                }
            }
        }
    }

    private void setInvPoints(int ix, int iy, double dlambda, double phi) {
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - ix - 1;
        int row = this.outCenterY_ - iy - 1;
        int rowF = this.outCenterY_ + iy;
        this.setInverseArrayLocation(col, row, this.lambdaC_ + dlambda, phi);
        this.setInverseArrayLocation(colF, row, this.lambdaC_ + dlambda, -phi);
        this.setInverseArrayLocation(colF, rowF, this.lambdaC_ - dlambda, -phi);
        this.setInverseArrayLocation(col, rowF, this.lambdaC_ - dlambda, phi);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double lon1 = this.lambdaC_ - 179.99999;
        double lon2 = this.lambdaC_;
        double lon3 = this.lambdaC_ + 179.99999;
        Bezier bcurve = this.makeMeridianBezier(lon1, 90.0, true);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(lon3, 90.0, true)) != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(lon1, 90.0, false)) != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(lon3, 90.0, false)) != null) {
            bcurve.draw(g2d);
        }
        Point2D.Double dot1 = this.transformLL2XY(lon1, 0.0);
        Point2D.Double dot2 = this.transformLL2XY(lon2, 0.0);
        Point2D.Double dot3 = this.transformLL2XY(lon3, 0.0);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        dot1 = this.transformLL2XY(lon1, -1.0E-10);
        dot2 = this.transformLL2XY(lon2, -1.0E-10);
        dot3 = this.transformLL2XY(lon3, -1.0E-10);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double lon1 = this.lambdaC_ - 179.99999;
        double lon2 = this.lambdaC_;
        double lon3 = this.lambdaC_ + 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(lon1, lat);
        Point2D.Double dot2 = this.transformLL2XY(lon2, lat);
        Point2D.Double dot3 = this.transformLL2XY(lon3, lat);
        if (dot1 == null || dot2 == null || dot3 == null) {
            return;
        }
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Bezier bcurve = this.makeMeridianBezier(lon, maxLat, true);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(lon, maxLat, false)) != null) {
            bcurve.draw(g2d);
        }
    }

    private Bezier makeMeridianBezier(double lon, double maxLat, boolean north) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        double lat = 0.0;
        if (!north) {
            lat = 1.0E-10;
        }
        while (lat < maxLat) {
            double absLat;
            Point2D.Double double_ = dot = north ? this.transformLL2XY(lon, lat) : this.transformLL2XY(lon, -lat);
            if (dot != null) {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
            }
            if ((absLat = Math.abs(lat)) >= maxLat - 1.0) {
                lat += 0.1;
                continue;
            }
            if (absLat >= 85.0) {
                lat += 0.25;
                continue;
            }
            lat += 0.5;
        }
        dot = north ? this.transformLL2XY(lon, maxLat) : this.transformLL2XY(lon, -maxLat);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        return new Bezier(false, ptlist);
    }

    private static double latitudeOfLobeMaxYr() {
        double phiRad = 0.7853981633974483;
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double alphaRad = 1.5707963267948966 - phiRad;
            double alphaRad2 = alphaRad * alphaRad;
            double betaRad = Math.PI * cosPhi / alphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = (-Math.PI * sinPhi + betaRad) / alphaRad;
            double d2betaRad = -Math.PI * cosPhi / alphaRad - Math.PI * sinPhi / alphaRad2 + dbetaRad / alphaRad + betaRad / alphaRad2;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double d2cosBeta = -(dsinBeta * dbetaRad + sinBeta * d2betaRad);
            double func = cosBeta - alphaRad * dcosBeta;
            double dfunc = dcosBeta + dcosBeta - alphaRad * d2cosBeta;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }

    static {
        MAX_Y_OVER_RS = 1.5707963267948966;
        double latYMax = DoubleCordiform.latitudeOfLobeMaxYr();
        double phiRad = Math.toRadians(latYMax);
        double alphaRad = 1.5707963267948966 - phiRad;
        double betaRad = Math.PI * Math.cos(phiRad) / alphaRad;
        double yr = 0.0 - alphaRad * Math.cos(betaRad);
        MAX_X_OVER_RS = yr + 1.5707963267948966;
        LOGGER.trace("latYMax {}", (Object)latYMax);
    }
}

