/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.imageio;

import io.sf.carte.echosvg.ext.awt.image.codec.imageio.ImageIOImageWriter;
import io.sf.carte.echosvg.ext.awt.image.codec.impl.CodecUtil;
import io.sf.carte.echosvg.ext.awt.image.codec.impl.ColorUtil;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.PNGImageWriterParams;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.Deflater;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;

public class ImageIOPNGImageWriter
extends ImageIOImageWriter {
    private static final String PNG_NATIVE_FORMAT = "javax_imageio_png_1.0";

    public ImageIOPNGImageWriter() {
        super("image/png");
    }

    @Override
    protected void updateColorMetadata(IIOMetadata meta, ImageWriterParams params, ColorSpace colorSpace) {
        if (!ColorUtil.isBuiltInColorSpace(colorSpace) && colorSpace instanceof ICC_ColorSpace && meta.isStandardMetadataFormatSupported()) {
            IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(PNG_NATIVE_FORMAT);
            IIOMetadataNode iCCP = ImageIOPNGImageWriter.getChildNode(root, "iCCP");
            if (iCCP == null) {
                iCCP = new IIOMetadataNode("iCCP");
                root.appendChild(iCCP);
            }
            ICC_Profile profile = ((ICC_ColorSpace)colorSpace).getProfile();
            iCCP.setAttribute("profileName", ImageIOPNGImageWriter.profileName(profile));
            iCCP.setAttribute("compressionMethod", "deflate");
            iCCP.setUserObject(ImageIOPNGImageWriter.compressProfile(profile.getData(), params));
            try {
                meta.mergeTree(PNG_NATIVE_FORMAT, root);
            }
            catch (IIOInvalidTreeException e) {
                throw new RuntimeException("Cannot update image metadata.", e);
            }
        }
    }

    private static String profileName(ICC_Profile profile) {
        int numrec;
        byte[] bdesc = profile.getData(1684370275);
        byte[] mluc = new byte[]{109, 108, 117, 99};
        if (bdesc != null && CodecUtil.arrayStartsWith(mluc, bdesc, 0) && (numrec = ImageIOPNGImageWriter.uInt32Number(bdesc, 8)) > 0) {
            int len = ImageIOPNGImageWriter.uInt32Number(bdesc, 20);
            int offset = ImageIOPNGImageWriter.uInt32Number(bdesc, 24);
            int maxlen = bdesc.length - offset;
            if (maxlen > 0) {
                len = Math.min(len, maxlen);
                return new String(bdesc, offset, len, StandardCharsets.UTF_16BE).trim();
            }
        }
        return profile.getClass().getSimpleName();
    }

    private static int uInt32Number(byte[] bytes, int offset) {
        long value = (long)(bytes[offset + 3] & 0xFF | (bytes[offset + 2] & 0xFF) << 8 | (bytes[offset + 1] & 0xFF) << 16) | (long)(bytes[offset] & 0xFF) << 24;
        return (int)value;
    }

    private static byte[] compressProfile(byte[] data, ImageWriterParams params) {
        Integer level;
        int lvl = -1;
        if (params != null && (level = params.getCompressionLevel()) != null) {
            lvl = level;
            if (lvl < -1) {
                lvl = -1;
            } else if (lvl > 9) {
                lvl = 9;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 16);
        byte[] buffer = new byte[Math.min(data.length + 5, 1024)];
        Deflater defl = new Deflater(lvl);
        defl.setInput(data);
        defl.finish();
        do {
            int cmprLen = defl.deflate(buffer);
            out.write(buffer, 0, cmprLen);
        } while (!defl.finished());
        defl.end();
        return out.toByteArray();
    }

    @Override
    protected ImageWriteParam getDefaultWriteParam(ImageWriter iiowriter, RenderedImage image, ImageWriterParams params) {
        ImageWriteParam param = iiowriter.getDefaultWriteParam();
        if (params != null) {
            int lvl;
            String comprMethod = params.getCompressionMethod();
            Integer level = params.getCompressionLevel();
            if (level != null && (lvl = level.intValue()) >= 0 && lvl < 10) {
                try {
                    param.setCompressionMode(2);
                    param.setCompressionType(comprMethod != null ? comprMethod : "Deflate");
                    float quality = 1.0f - (float)lvl / 9.0f;
                    param.setCompressionQuality(quality);
                }
                catch (UnsupportedOperationException e) {
                    e.printStackTrace();
                }
            } else if (comprMethod != null) {
                param.setCompressionMode(2);
                param.setCompressionType(comprMethod);
            }
        }
        return param;
    }

    @Override
    protected IIOMetadata updateMetadata(IIOMetadata meta, ImageWriterParams params) {
        if ((meta = super.updateMetadata(meta, params)).isStandardMetadataFormatSupported() && params instanceof PNGImageWriterParams) {
            IIOMetadataNode entry;
            int i;
            String[] text;
            IIOMetadataNode root = null;
            PNGImageWriterParams pngParams = (PNGImageWriterParams)params;
            boolean needsMerge = false;
            if (pngParams.isTextSet()) {
                text = pngParams.getText();
                if (text.length % 2 > 0) {
                    throw new RuntimeException("Wrong tEXt data: array must have length multiple of 2.");
                }
                root = (IIOMetadataNode)meta.getAsTree(PNG_NATIVE_FORMAT);
                IIOMetadataNode tEXt = ImageIOPNGImageWriter.getChildNode(root, "tEXt");
                if (tEXt == null) {
                    tEXt = new IIOMetadataNode("tEXt");
                    root.appendChild(tEXt);
                }
                for (i = 0; i < text.length; i += 2) {
                    IIOMetadataNode tEXtEntry = new IIOMetadataNode("tEXtEntry");
                    tEXt.appendChild(tEXtEntry);
                    tEXtEntry.setAttribute("keyword", text[i]);
                    tEXtEntry.setAttribute("value", text[i + 1]);
                }
                needsMerge = true;
            }
            if (pngParams.isInternationalTextSet()) {
                IIOMetadataNode iTXt;
                text = pngParams.getInternationalText();
                if (text.length % 4 > 0) {
                    throw new RuntimeException("Wrong iTXt data: array must have length multiple of 4.");
                }
                if (root == null) {
                    root = (IIOMetadataNode)meta.getAsTree(PNG_NATIVE_FORMAT);
                }
                if ((iTXt = ImageIOPNGImageWriter.getChildNode(root, "iTXt")) == null) {
                    iTXt = new IIOMetadataNode("iTXt");
                    root.appendChild(iTXt);
                }
                for (i = 0; i < text.length; i += 4) {
                    entry = new IIOMetadataNode("iTXtEntry");
                    iTXt.appendChild(entry);
                    entry.setAttribute("keyword", text[i]);
                    entry.setAttribute("compressionFlag", "TRUE");
                    entry.setAttribute("compressionMethod", "1");
                    entry.setAttribute("languageTag", text[i + 1]);
                    entry.setAttribute("translatedKeyword", text[i + 2]);
                    entry.setAttribute("text", text[i + 3]);
                }
                needsMerge = true;
            }
            if (pngParams.isCompressedTextSet()) {
                IIOMetadataNode zTXt;
                text = pngParams.getCompressedText();
                if (text.length % 2 > 0) {
                    throw new RuntimeException("Wrong zTXt data: array must have length multiple of 2.");
                }
                if (root == null) {
                    root = (IIOMetadataNode)meta.getAsTree(PNG_NATIVE_FORMAT);
                }
                if ((zTXt = ImageIOPNGImageWriter.getChildNode(root, "zTXt")) == null) {
                    zTXt = new IIOMetadataNode("zTXt");
                    root.appendChild(zTXt);
                }
                for (i = 0; i < text.length; i += 2) {
                    entry = new IIOMetadataNode("zTXtEntry");
                    zTXt.appendChild(entry);
                    entry.setAttribute("keyword", text[i]);
                    entry.setAttribute("compressionMethod", "deflate");
                    entry.setAttribute("text", text[i + 1]);
                }
                needsMerge = true;
            }
            if (needsMerge) {
                try {
                    meta.mergeTree(PNG_NATIVE_FORMAT, root);
                }
                catch (IIOInvalidTreeException e) {
                    throw new RuntimeException("Cannot update image metadata.", e);
                }
            }
        }
        return meta;
    }
}

