/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.plaf;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.img.ImageUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class GissToolBarButtonUI
extends BasicButtonUI {
    private static final Color FOCUSED_TEXT_COLOR = Color.BLACK;
    private static final Color UNFOCUSED_TEXT_COLOR = new Color(58, 58, 58);
    private static final Color TEXT_EMPHASIS_COLOR = new Color(255, 255, 255, 110);

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setIconTextGap(0);
        b.setOpaque(false);
        b.setFocusable(false);
        b.setFont(UIManager.getFont("Button.font").deriveFont(11.0f));
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new GissToolBarButtonUI();
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        BufferedImage bimage = ImageUtils.toBufferedImage(icon);
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        if (!model.isEnabled()) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        } else if (model.isArmed()) {
            Graphics2D ig2d = (Graphics2D)bimage.getGraphics();
            ig2d.setComposite(AlphaComposite.SrcAtop);
            ig2d.setColor(new Color(0, 0, 0, 128));
            ig2d.fillRect(0, 0, iconRect.width, iconRect.height);
            ig2d.dispose();
        } else if (!GuiUtils.isParentWindowFocused(c)) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.65f));
        }
        g2d.drawImage((Image)bimage, iconRect.x, iconRect.y, null);
        g2d.dispose();
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        boolean focused = GuiUtils.isParentWindowFocused(c);
        if (focused && !model.isArmed()) {
            g2d.setColor(TEXT_EMPHASIS_COLOR);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, text, -1, textRect.x, textRect.y + 1 + fm.getAscent());
        }
        if (focused && model.isEnabled()) {
            g2d.setColor(FOCUSED_TEXT_COLOR);
        } else {
            g2d.setColor(UNFOCUSED_TEXT_COLOR);
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, text, -1, textRect.x, textRect.y + fm.getAscent());
        g2d.dispose();
    }
}

