/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataLonLatTrajectory;
import gov.nasa.giss.panoply.util.PanExportGridOption;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.SlowMessage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.write.NetcdfFormatWriter;

public final class PanDataWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static boolean write1D(PanData1D data, File file, Hashtable<PanExportGridOption, String> opts) {
        NetcdfFormatWriter.Builder builder = NetcdfFormatWriter.createNewNetcdf3(file.getPath());
        PanDataWriter.appendGlobalAttributes(builder, data);
        String xname = PanDataWriter.cleanDimName(data.getAxisShortName().toLowerCase());
        String xunits = data.getAxisUnits();
        int xlength = data.getAxisLength(0);
        Dimension xdim = builder.addDimension(xname, xlength);
        LOGGER.trace("xname {}, xdim {}", (Object)xname, (Object)xdim);
        try {
            Variable.Builder builder2 = PanDataWriter.createCoordinateVariable(builder, xname, xunits);
        }
        catch (Exception exc) {
            SlowMessage.show(null, "Illegal Argument", exc.getMessage());
            return false;
        }
        ArrayDouble.D1 xarray = new ArrayDouble.D1(xlength);
        Index idx = xarray.getIndex();
        for (int i = 0; i < xlength; ++i) {
            xarray.setDouble(idx.set(i), data.axisValueAt(0, i));
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(xdim);
        String varname = opts.containsKey((Object)PanExportGridOption.VARNAME) ? opts.get((Object)PanExportGridOption.VARNAME) : "some_data";
        Variable.Builder varbuilder = builder.addVariable(varname, DataType.DOUBLE, dims);
        PanDataWriter.appendVarAttributes(varbuilder, opts);
        ArrayDouble.D1 darray = new ArrayDouble.D1(xlength);
        Index idx2 = xarray.getIndex();
        for (int i = 0; i < xlength; ++i) {
            xarray.setDouble(idx2.set(i), data.valueAt(0, i));
        }
        try (NetcdfFormatWriter writer = builder.build();){
            writer.write(xname, (Array)xarray);
            writer.write(varname, (Array)darray);
        }
        catch (InvalidRangeException ire) {
            LOGGER.warn("InvalidRangeException, {}", (Object)ire.getMessage());
            SlowMessage.show(null, "Export Error", new StringBuilder("Could not export data due to an invalid range exception: ").append(ire.getMessage()).append("."));
            return false;
        }
        catch (IOException ioe) {
            LOGGER.warn("IOException, {}", (Object)ioe.getMessage());
            SlowMessage.show(null, "Export Error", new StringBuilder("Could not export data due to an IO exception: ").append(ioe.getMessage()).append("."));
            return false;
        }
        catch (Exception exc) {
            LOGGER.warn("Exception, {}", (Object)exc.getMessage());
            SlowMessage.show(null, "Export Error", new StringBuilder("Could not export data due to an exception: ").append(exc.getMessage()).append("."));
            return false;
        }
        return false;
    }

    public static boolean write2D(PanData2D data, File file, Hashtable<PanExportGridOption, String> opts) {
        NetcdfFormatWriter.Builder builder = NetcdfFormatWriter.createNewNetcdf3(file.getPath());
        PanDataWriter.appendGlobalAttributes(builder, data);
        String xname = PanDataWriter.cleanDimName(data.getXAxisName().toLowerCase());
        String yname = PanDataWriter.cleanDimName(data.getYAxisName().toLowerCase());
        String xunits = data.getXAxisUnits();
        String yunits = data.getYAxisUnits();
        int xlength = data.getWidth();
        int ylength = data.getHeight();
        Dimension xdim = builder.addDimension(xname, xlength);
        Dimension ydim = builder.addDimension(yname, ylength);
        LOGGER.trace("xname {}, xdim {}", (Object)xname, (Object)xdim);
        LOGGER.trace("yname {}, ydim {}", (Object)yname, (Object)ydim);
        try {
            Variable.Builder builder2 = PanDataWriter.createCoordinateVariable(builder, xname, xunits);
        }
        catch (Exception exc) {
            SlowMessage.show(null, "Illegal Argument", exc.getMessage());
            return false;
        }
        try {
            Variable.Builder exc = PanDataWriter.createCoordinateVariable(builder, yname, yunits);
        }
        catch (Exception exc) {
            SlowMessage.show(null, "Illegal Argument", exc.getMessage());
            return false;
        }
        ArrayDouble.D1 xarray = new ArrayDouble.D1(xlength);
        ArrayDouble.D1 yarray = new ArrayDouble.D1(ylength);
        Index idx = xarray.getIndex();
        for (int i = 0; i < xlength; ++i) {
            xarray.setDouble(idx.set(i), data.getColX(i));
        }
        idx = yarray.getIndex();
        for (int j = 0; j < ylength; ++j) {
            yarray.setDouble(idx.set(j), data.getRowY(j));
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(xdim);
        dims.add(ydim);
        String varname = opts.containsKey((Object)PanExportGridOption.VARNAME) ? opts.get((Object)PanExportGridOption.VARNAME) : "some_data";
        Variable.Builder varbuilder = builder.addVariable(varname, DataType.DOUBLE, dims);
        PanDataWriter.appendVarAttributes(varbuilder, opts);
        ArrayDouble.D2 darray = new ArrayDouble.D2(xlength, ylength);
        Index idx2 = darray.getIndex();
        for (int i = 0; i < xlength; ++i) {
            for (int j = 0; j < ylength; ++j) {
                darray.setDouble(idx2.set(i, j), data.valueAt(i, j));
            }
        }
        try (NetcdfFormatWriter writer = builder.build();){
            writer.write(xname, (Array)xarray);
            writer.write(yname, (Array)yarray);
            writer.write(varname, (Array)darray);
        }
        catch (InvalidRangeException ire) {
            LOGGER.warn("InvalidRangeException, {}", (Object)ire.getMessage());
            SlowMessage.show(null, "Export Error", new StringBuilder("Could not export data due to an invalid range exception: ").append(ire.getMessage()).append("."));
            return false;
        }
        catch (IOException ioe) {
            LOGGER.warn("IOException, {}", (Object)ioe.getMessage());
            SlowMessage.show(null, "Export Error", new StringBuilder("Could not export data due to an IO exception: ").append(ioe.getMessage()).append("."));
            return false;
        }
        catch (Exception exc) {
            LOGGER.warn("Exception, {}", (Object)exc.getMessage());
            SlowMessage.show(null, "Export Error", new StringBuilder("Could not export data due to an exception: ").append(exc.getMessage()).append("."));
            return false;
        }
        return true;
    }

    public static boolean writeTrajectory(PanDataLonLatTrajectory data, File file, Hashtable<PanExportGridOption, String> opts) {
        SlowMessage.show(null, "Export Error", new StringBuilder("Exporting of trajectory data is not yet implemented."));
        return false;
    }

    private static String cleanDimName(String dname) {
        String cleaned = dname.toLowerCase().replaceFirst("^\\s*", "").replaceFirst("\\s*$", "").replaceAll("\\s+", "_").replaceAll("[^\\w_]", "");
        if (cleaned.length() > 16) {
            return cleaned.substring(0, 16);
        }
        return cleaned;
    }

    private static void appendGlobalAttributes(NetcdfFormatWriter.Builder builder, PanData data) {
        OffsetDateTime now = OffsetDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        StringBuilder histsb = new StringBuilder(256).append("Exported ").append(now.toString()).append(" by ").append(PanUtils.getSoftwareID());
        builder.addAttribute(new Attribute("Conventions", "CF-1.6"));
        builder.addAttribute(new Attribute("history", histsb.toString()));
        builder.addAttribute(new Attribute("comment", data.getDescription()));
    }

    private static Variable.Builder createCoordinateVariable(NetcdfFormatWriter.Builder builder, String cvarname, String cvarunits) {
        try {
            Variable.Builder xbuilder = builder.addVariable(cvarname, DataType.DOUBLE, cvarname);
            if (cvarunits != null && !"1".equals(cvarunits)) {
                xbuilder.addAttribute(new Attribute("units", cvarunits));
            }
            return xbuilder;
        }
        catch (IllegalArgumentException exc) {
            throw new RuntimeException(String.format("Dimension name '%s' contains unacceptable characters.", cvarname));
        }
    }

    private static void appendVarAttributes(Variable.Builder varbuilder, Hashtable<PanExportGridOption, String> opts) {
        if (opts.containsKey((Object)PanExportGridOption.STANDARD_NAME)) {
            varbuilder.addAttribute(new Attribute(PanExportGridOption.STANDARD_NAME.getCdlString(), opts.get((Object)PanExportGridOption.STANDARD_NAME)));
        }
        if (opts.containsKey((Object)PanExportGridOption.LONG_NAME)) {
            varbuilder.addAttribute(new Attribute(PanExportGridOption.LONG_NAME.getCdlString(), opts.get((Object)PanExportGridOption.LONG_NAME)));
        }
        if (opts.containsKey((Object)PanExportGridOption.UNITS)) {
            varbuilder.addAttribute(new Attribute(PanExportGridOption.UNITS.getCdlString(), opts.get((Object)PanExportGridOption.UNITS)));
        }
    }

    private PanDataWriter() {
    }
}

