/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzimuthalProjection
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 0x200040;
    private static final double MIN_RADIUS = 0.002;
    protected double rhoBorder_;
    protected double rhoBorder2_;
    protected double cosPhiC_;
    protected double sinPhiC_;
    protected ProjDoubleParameter edgeParam_;
    protected ProjBooleanParameter fillParam_;
    protected double edgeAngle_ = 15.0;
    protected double edgeAngleRad_;
    protected boolean fillCorners_;

    public AzimuthalProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
        this.setCenter(this.lambdaC_, this.phiC_);
    }

    protected void addEdgeAngleParameter(double value, double maxAngle, boolean maxAllowed) {
        String unitsStr = this.getEdgeAngleUnitsStr(maxAngle, maxAllowed);
        this.edgeParam_ = new ProjDoubleParameter("Angle between center and nearest map margin", "Edge Angle", unitsStr, value, 0.002, maxAngle, true, maxAllowed);
        this.addParameter(this.edgeParam_);
    }

    protected String getEdgeAngleUnitsStr(double maxAngle, boolean maxAllowed) {
        PrintfFormat pformat = new PrintfFormat("%.5g");
        StringBuilder sb = new StringBuilder("\u00b0 (");
        if (maxAllowed) {
            sb.append('\u2264');
        } else {
            sb.append('<');
        }
        sb.append(pformat.sprintfx(maxAngle)).append("\u00b0)  ");
        return sb.toString();
    }

    public ProjDoubleParameter getEdgeAngleParameter() {
        return this.edgeParam_;
    }

    protected void addAzimuthalFillParameter() {
        this.fillParam_ = new ProjBooleanParameter("Map is not limited to purely circular area", "Fill corners", true);
        this.addParameter(this.fillParam_);
    }

    public ProjBooleanParameter getAzimuthalFillParameter() {
        return this.fillParam_;
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            if (this.edgeParam_ != null) {
                this.setEdgeAngle(this.edgeParam_.getValue());
            }
            if (this.fillParam_ != null) {
                this.setAzimuthalFill(this.fillParam_.isSelected());
            }
        } else if (p.equals(this.edgeParam_)) {
            this.setEdgeAngle(this.edgeParam_.getValue());
        } else if (p.equals(this.fillParam_)) {
            this.setAzimuthalFill(this.fillParam_.isSelected());
        } else {
            LOGGER.trace("Param not handled by AzimuthalProjection. Perhaps a subclass does so.");
        }
    }

    protected void setEdgeAngle(double angle) {
        this.edgeAngle_ = angle;
        this.edgeAngleRad_ = Math.toRadians(angle);
        this.autoscale();
    }

    protected void setAzimuthalFill(boolean fill) {
        this.fillCorners_ = fill;
        this.autoscale();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ == -1.0) {
            return null;
        }
        if (cosZ == 1.0) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double k = this.getKForCosZ(cosZ);
        if (k < 0.0) {
            return null;
        }
        double x = k * cosPhi * Math.sin(lambdaRad);
        double rho2 = x * x + (y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda)) * y;
        if (rho2 * this.r2s2_ > this.rhoBorder2_) {
            return null;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    protected abstract double getKForCosZ(double var1);

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        if (!this.isWithinMargins(xx, yy)) {
            return null;
        }
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double[] lambdaPhi = this.getLambdaPhiForXY(x, y);
        if (lambdaPhi == null) {
            return null;
        }
        double lambda = lambdaPhi[0];
        double phi = lambdaPhi[1];
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AzimuthalProjection azimuthalProjection = this;
        synchronized (azimuthalProjection) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double[] lambdaPhi = this.getLambdaPhiForXY(x, y);
                    if (lambdaPhi == null) continue;
                    double lambda = lambdaPhi[0];
                    double phi = lambdaPhi[1];
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    protected abstract double getZRadForRho(double var1);

    protected double[] getLambdaPhiForXY(double x, double y) {
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double zRad = this.getZRadForRho(rho);
        if (Double.isNaN(zRad)) {
            return null;
        }
        double sinZ = Math.sin(zRad);
        double cosZ = Math.cos(zRad);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new double[]{lambda, phi};
    }

    @Override
    public LonLatEdges getBounds() {
        double dlon2;
        double lat;
        PointLL ll;
        int j;
        int ww = this.getWidth();
        int hh = this.getHeight();
        double wOver2 = 0.5 * (double)ww;
        double hOver2 = 0.5 * (double)hh;
        double dlon = 0.0;
        double tLat = -9999.0;
        double bLat = 9999.0;
        if (this.transformLL2XY(0.0, 90.0) != null) {
            tLat = 90.0;
            dlon = 180.0;
        }
        if (this.transformLL2XY(0.0, -90.0) != null) {
            bLat = -90.0;
            dlon = 180.0;
        }
        int j1 = 0;
        int j2 = hh - 1;
        for (j = 0; j < hh; ++j) {
            ll = this.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll == null) continue;
            lat = ll.getLat();
            tLat = Math.max(tLat, lat);
            bLat = Math.min(bLat, lat);
            j1 = j;
            break;
        }
        for (j = hh - 1; j > j1 && j > 0; --j) {
            ll = this.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll == null) continue;
            lat = ll.getLat();
            tLat = Math.max(tLat, lat);
            bLat = Math.min(bLat, lat);
            j2 = j;
            break;
        }
        if (dlon < 180.0 && tLat < 90.0 && bLat > -90.0) {
            double r = Math.abs((double)j1 - hOver2);
            for (int i = 5; i < 90; i += 5) {
                double rCos = r * Math.cos(Math.toRadians(i));
                double rSin = r * Math.sin(Math.toRadians(i));
                PointLL ll1 = this.transformXY2LL(wOver2 + rCos - 1.0, hOver2 + rSin - 1.0);
                PointLL ll2 = this.transformXY2LL(wOver2 - rCos + 1.0, hOver2 - rSin + 1.0);
                double dlon1 = ll1 == null ? 0.0 : (this.lambdaC_ > ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() + 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (this.lambdaC_ < ll2.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            }
        }
        int i = 0;
        while ((double)i < wOver2) {
            double lat2;
            double dlon1;
            PointLL ll1 = this.transformXY2LL(wOver2 + (double)i, (double)j1 + 0.5);
            PointLL ll2 = this.transformXY2LL(wOver2 + (double)i, (double)j2 + 0.5);
            if (ll1 == null && ll2 == null) break;
            if (ll1 == null) {
                dlon1 = 0.0;
            } else {
                lat2 = ll1.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon1 = this.lambdaC_ > ll1.getLon() ? 1.01 * Math.abs(this.lambdaC_ - (ll1.getLon() + 360.0)) : 1.01 * Math.abs(this.lambdaC_ - ll1.getLon());
            }
            if (ll2 == null) {
                dlon2 = 0.0;
            } else {
                lat2 = ll2.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon2 = this.lambdaC_ > ll2.getLon() ? 1.01 * Math.abs(this.lambdaC_ - (ll2.getLon() + 360.0)) : 1.01 * Math.abs(this.lambdaC_ - ll2.getLon());
            }
            dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            ++i;
        }
        double dlat = Math.max(Math.abs(this.phiC_ - tLat), Math.abs(this.phiC_ - bLat));
        double llTop = Math.min(90.0, tLat);
        double llBottom = Math.max(-90.0, bLat);
        if (tLat > 89.5 || bLat < -89.5 || dlon > 180.0) {
            dlon = 180.0;
        } else {
            PointLL ll1;
            dlon = Math.max(dlon, dlat);
            int i1 = 0;
            int i2 = 0;
            while ((double)i2 < wOver2) {
                ll1 = this.transformXY2LL(i2, hOver2);
                if (ll1 != null) {
                    double dlon1 = this.lambdaC_ < ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon());
                    dlon = Math.max(dlon, dlon1);
                    i1 = i2;
                    break;
                }
                ++i2;
            }
            int j3 = 0;
            while ((double)j3 < hOver2) {
                ll1 = this.transformXY2LL(i1, hOver2 - (double)j3 + 0.5);
                PointLL ll2 = this.transformXY2LL(i1, hOver2 + (double)j3 + 0.5);
                if (ll1 == null && ll2 == null) break;
                double dlon1 = ll1 == null ? 0.0 : (this.lambdaC_ < ll1.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (this.lambdaC_ < ll2.getLon() ? 1.1 * Math.abs(this.lambdaC_ - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(this.lambdaC_ - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
                ++j3;
            }
        }
        double llLeft = this.lambdaC_ - dlon;
        double llRight = this.lambdaC_ + dlon;
        if (llRight - llLeft > 300.0) {
            llLeft = -180.0;
            llRight = 180.0;
        } else if (llLeft < -180.0) {
            llLeft += 360.0;
            llRight += 360.0;
        }
        if (Math.abs(llTop) > 9000.0 || Math.abs(llBottom) > 9000.0) {
            llTop = 90.0;
            llBottom = -90.0;
        } else if (llTop < llBottom) {
            double temp = llTop;
            llTop = llBottom;
            llBottom = temp;
        }
        LonLatEdges result = new LonLatEdges(llLeft, llTop, llRight, llBottom);
        LOGGER.trace("bounds {}", (Object)result);
        return result;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        this.drawCircle(g2d, this.rhoBorder_, true);
    }

    private void drawCircle(Graphics2D g2d, double radius, boolean link) {
        double r2 = radius * radius;
        double w2 = this.dxMax_ * this.dxMax_;
        double h2 = this.dyMax_ * this.dyMax_;
        double rhoCorner = Math.sqrt(w2 + h2);
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.translate(this.outCenterX_, this.outCenterY_);
        Arc2D.Double arc = new Arc2D.Double();
        if (radius <= (double)this.dxMax_ && radius <= (double)this.dyMax_) {
            ProjGraphicUtils.drawEllipse(g2x, 0.0, 0.0, radius, radius);
        } else if (radius > rhoCorner) {
            if (link) {
                ProjGraphicUtils.drawRect(g2x, -this.dxMax_, -this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
            }
        } else if (radius > (double)this.dxMax_ && radius > (double)this.dyMax_) {
            double dxx = Math.sqrt(r2 - h2);
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-dxx, -this.dyMax_);
                path.lineTo(dxx, -this.dyMax_);
                path.moveTo(this.dxMax_, -dyy);
                path.lineTo(this.dxMax_, dyy);
                path.moveTo(dxx, this.dyMax_);
                path.lineTo(-dxx, this.dyMax_);
                path.moveTo(-this.dxMax_, dyy);
                path.lineTo(-this.dxMax_, -dyy);
                g2x.draw(path);
            }
            double angle1 = -Math.toDegrees(Math.acos(dxx / radius));
            double angle2 = 90.0 - Math.toDegrees(Math.acos(dyy / radius));
            double extent = Math.abs(angle1 + angle2);
            arc.setArcByCenter(0.0, 0.0, radius, angle1, extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, -angle1, -extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, 180.0 + angle1, extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, 180.0 - angle1, -extent, 0);
            g2x.draw(arc);
        } else if (radius > (double)this.dyMax_) {
            double dxx = Math.sqrt(r2 - h2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-dxx, -this.dyMax_);
                path.lineTo(dxx, -this.dyMax_);
                path.moveTo(dxx, this.dyMax_);
                path.lineTo(-dxx, this.dyMax_);
                g2x.draw(path);
            }
            double angle = -Math.toDegrees(Math.acos(dxx / radius));
            double extent = -2.0 * angle;
            arc.setArcByCenter(0.0, 0.0, radius, angle, extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, extent, 0);
            g2x.draw(arc);
        } else if (radius > (double)this.dxMax_) {
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-this.dxMax_, -dyy);
                path.lineTo(-this.dxMax_, dyy);
                path.moveTo(this.dxMax_, dyy);
                path.lineTo(this.dxMax_, -dyy);
                g2x.draw(path);
            }
            double angle = 90.0 - Math.toDegrees(Math.acos(dyy / radius));
            double extent = 180.0 - 2.0 * angle;
            arc.setArcByCenter(0.0, 0.0, radius, angle, extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, extent, 0);
            g2x.draw(arc);
        }
        g2x.dispose();
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(this.phiC_) > 89.99999) {
            boolean skip;
            double dlat = Math.abs(this.phiC_ - lat);
            boolean bl = skip = !this.fillCorners_ && dlat >= this.edgeAngle_;
            if (skip) {
                return;
            }
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_, lat);
            if (dot == null) {
                return;
            }
            double r = Math.abs((double)this.outCenterY_ - dot.y);
            this.drawCircle(g2d, r, false);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        if (Math.abs(this.phiC_) > 89.99999) {
            Point2D.Double dotMax;
            Point2D.Double double_ = dotMax = this.phiC_ > 0.0 ? this.transformLL2XY(lon, maxLat) : this.transformLL2XY(lon, -maxLat);
            if (dotMax == null) {
                return;
            }
            Point2D.Double dotElse = this.phiC_ > 0.0 ? this.transformLL2XYIgnoreMargins(lon, 75.0) : this.transformLL2XYIgnoreMargins(lon, -75.0);
            double dx = dotElse.x - (double)this.outCenterX_;
            double dy = dotElse.y - (double)this.outCenterY_;
            double r = Math.hypot(dx, dy);
            double ratio = this.rhoBorder_ / r;
            dx *= ratio;
            dy *= ratio;
            if (Math.abs(dx) > (double)this.dxMax_) {
                ratio = Math.abs((double)this.dxMax_ / dx);
                dx *= ratio;
                dy *= ratio;
            }
            if (Math.abs(dy) > (double)this.dyMax_) {
                ratio = Math.abs((double)this.dyMax_ / dy);
                dx *= ratio;
                dy *= ratio;
            }
            GraphicUtils.drawLine(g2d, dotMax.x, dotMax.y, (double)this.outCenterX_ + dx, (double)this.outCenterY_ + dy);
            return;
        }
        super.drawMeridian(g2d, lon, maxLat, label);
    }
}

