/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.map.ProjNameComparator;
import gov.nasa.giss.map.ProjectionInfo;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.AdamsHemisphereInASquare;
import gov.nasa.giss.map.proj.AdamsHemisphereOblique;
import gov.nasa.giss.map.proj.AdamsWorldInASquare1;
import gov.nasa.giss.map.proj.AdamsWorldInASquare2;
import gov.nasa.giss.map.proj.Airy;
import gov.nasa.giss.map.proj.Airy2H;
import gov.nasa.giss.map.proj.Aitoff;
import gov.nasa.giss.map.proj.AitoffOblique;
import gov.nasa.giss.map.proj.AlbersEqualAreaConic;
import gov.nasa.giss.map.proj.AmericanPolyconic;
import gov.nasa.giss.map.proj.AmericanPolyconicGlobal;
import gov.nasa.giss.map.proj.Apian1;
import gov.nasa.giss.map.proj.Apian2;
import gov.nasa.giss.map.proj.Apian2TwoH;
import gov.nasa.giss.map.proj.ArdenClose;
import gov.nasa.giss.map.proj.AugustEpicycloidal;
import gov.nasa.giss.map.proj.AzimuthalEqualArea;
import gov.nasa.giss.map.proj.AzimuthalEqualArea2H;
import gov.nasa.giss.map.proj.AzimuthalEquidistant;
import gov.nasa.giss.map.proj.AzimuthalEquidistant2H;
import gov.nasa.giss.map.proj.AzimuthalFarSidePerspective;
import gov.nasa.giss.map.proj.BSAMCylindrical;
import gov.nasa.giss.map.proj.BaarSineSeries;
import gov.nasa.giss.map.proj.BaconGlobular;
import gov.nasa.giss.map.proj.BaconGlobular2H;
import gov.nasa.giss.map.proj.BakerDinomic;
import gov.nasa.giss.map.proj.Baranyi1;
import gov.nasa.giss.map.proj.Baranyi2;
import gov.nasa.giss.map.proj.Baranyi3;
import gov.nasa.giss.map.proj.Baranyi4;
import gov.nasa.giss.map.proj.Baranyi4z;
import gov.nasa.giss.map.proj.Baranyi5;
import gov.nasa.giss.map.proj.Baranyi6;
import gov.nasa.giss.map.proj.Baranyi7;
import gov.nasa.giss.map.proj.BartholomewTetrahedral;
import gov.nasa.giss.map.proj.BerghausStar;
import gov.nasa.giss.map.proj.BertinRiviere;
import gov.nasa.giss.map.proj.BoggsEumorphic;
import gov.nasa.giss.map.proj.Bonne;
import gov.nasa.giss.map.proj.BonneRegional;
import gov.nasa.giss.map.proj.Bottomley;
import gov.nasa.giss.map.proj.BraunPerspective;
import gov.nasa.giss.map.proj.BraunStereographic;
import gov.nasa.giss.map.proj.BreusingGeometric;
import gov.nasa.giss.map.proj.BreusingGeometric2H;
import gov.nasa.giss.map.proj.BreusingHarmonic;
import gov.nasa.giss.map.proj.BreusingHarmonic2H;
import gov.nasa.giss.map.proj.CEAOblique;
import gov.nasa.giss.map.proj.Cabot;
import gov.nasa.giss.map.proj.CantersPolyconicW12;
import gov.nasa.giss.map.proj.CantersPolyconicW13;
import gov.nasa.giss.map.proj.CantersPolyconicW14;
import gov.nasa.giss.map.proj.CantersPolyconicW20;
import gov.nasa.giss.map.proj.CantersPolyconicW21;
import gov.nasa.giss.map.proj.CantersPolyconicW31;
import gov.nasa.giss.map.proj.CantersPolyconicW32;
import gov.nasa.giss.map.proj.CantersPseudocylindricW15;
import gov.nasa.giss.map.proj.CantersPseudocylindricW16;
import gov.nasa.giss.map.proj.CantersPseudocylindricW17;
import gov.nasa.giss.map.proj.CantersPseudocylindricW19;
import gov.nasa.giss.map.proj.CantersPseudocylindricW33;
import gov.nasa.giss.map.proj.CantersPseudocylindricW34;
import gov.nasa.giss.map.proj.Cassini;
import gov.nasa.giss.map.proj.CentralCylindrical;
import gov.nasa.giss.map.proj.ClarkeTwilight;
import gov.nasa.giss.map.proj.CompactMiller;
import gov.nasa.giss.map.proj.CylindricalEqualArea;
import gov.nasa.giss.map.proj.CylindricalStereographic;
import gov.nasa.giss.map.proj.DeakinMinimumError;
import gov.nasa.giss.map.proj.Denoyer;
import gov.nasa.giss.map.proj.DoubleCordiform;
import gov.nasa.giss.map.proj.Eckert1;
import gov.nasa.giss.map.proj.Eckert2;
import gov.nasa.giss.map.proj.Eckert3;
import gov.nasa.giss.map.proj.Eckert4;
import gov.nasa.giss.map.proj.Eckert5;
import gov.nasa.giss.map.proj.Eckert6;
import gov.nasa.giss.map.proj.EckertGreifendorff;
import gov.nasa.giss.map.proj.Eisenlohr;
import gov.nasa.giss.map.proj.EqualEarth;
import gov.nasa.giss.map.proj.EquidistantConic;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularOblique;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.ErdiKrausz;
import gov.nasa.giss.map.proj.Euler;
import gov.nasa.giss.map.proj.Fahey;
import gov.nasa.giss.map.proj.FoucautSinusoidal;
import gov.nasa.giss.map.proj.FoucautStereographic;
import gov.nasa.giss.map.proj.Fournier1;
import gov.nasa.giss.map.proj.Fournier1TwoH;
import gov.nasa.giss.map.proj.Fournier2;
import gov.nasa.giss.map.proj.GallBomfordPseudocylindrical;
import gov.nasa.giss.map.proj.GallStereographic;
import gov.nasa.giss.map.proj.GilbertTwoWorld;
import gov.nasa.giss.map.proj.Ginzburg1;
import gov.nasa.giss.map.proj.Ginzburg1TwoH;
import gov.nasa.giss.map.proj.Ginzburg2;
import gov.nasa.giss.map.proj.Ginzburg2TwoH;
import gov.nasa.giss.map.proj.Ginzburg4;
import gov.nasa.giss.map.proj.Ginzburg5;
import gov.nasa.giss.map.proj.Ginzburg6;
import gov.nasa.giss.map.proj.Ginzburg8;
import gov.nasa.giss.map.proj.Ginzburg9;
import gov.nasa.giss.map.proj.Gnomonic;
import gov.nasa.giss.map.proj.GnomonicCSOblique;
import gov.nasa.giss.map.proj.GnomonicCubedSphere;
import gov.nasa.giss.map.proj.GnomonicIcosahedron;
import gov.nasa.giss.map.proj.GoodeHomolosine;
import gov.nasa.giss.map.proj.GottEqualArea;
import gov.nasa.giss.map.proj.GottMugnoloAzimuthal;
import gov.nasa.giss.map.proj.GottMugnoloAzimuthal2H;
import gov.nasa.giss.map.proj.Gringorten;
import gov.nasa.giss.map.proj.Guyou;
import gov.nasa.giss.map.proj.GyorffyA;
import gov.nasa.giss.map.proj.GyorffyB;
import gov.nasa.giss.map.proj.GyorffyD;
import gov.nasa.giss.map.proj.GyorffyE;
import gov.nasa.giss.map.proj.GyorffyF;
import gov.nasa.giss.map.proj.GyorffyG;
import gov.nasa.giss.map.proj.Hammer;
import gov.nasa.giss.map.proj.HammerAzimuthal;
import gov.nasa.giss.map.proj.HammerOblique;
import gov.nasa.giss.map.proj.Hatano;
import gov.nasa.giss.map.proj.Healpix;
import gov.nasa.giss.map.proj.HexafoliateEqualArea;
import gov.nasa.giss.map.proj.HexafoliateEquidistant;
import gov.nasa.giss.map.proj.HillEucyclic;
import gov.nasa.giss.map.proj.Hoelzel;
import gov.nasa.giss.map.proj.Hufnagel;
import gov.nasa.giss.map.proj.JamesAzimuthal;
import gov.nasa.giss.map.proj.Kamenetskiy;
import gov.nasa.giss.map.proj.Kavraisky2;
import gov.nasa.giss.map.proj.Kavraisky5;
import gov.nasa.giss.map.proj.Kavraisky7;
import gov.nasa.giss.map.proj.KharchenkoShabanova;
import gov.nasa.giss.map.proj.LambertConformalConic;
import gov.nasa.giss.map.proj.LambertLagrange;
import gov.nasa.giss.map.proj.Larrivee;
import gov.nasa.giss.map.proj.Littrow;
import gov.nasa.giss.map.proj.LogarithmicAzimuthal;
import gov.nasa.giss.map.proj.Loximuthal;
import gov.nasa.giss.map.proj.MaurerS159;
import gov.nasa.giss.map.proj.MaurerS160;
import gov.nasa.giss.map.proj.MaurerS187;
import gov.nasa.giss.map.proj.MaurerS231;
import gov.nasa.giss.map.proj.Mayr;
import gov.nasa.giss.map.proj.McBrydeP3;
import gov.nasa.giss.map.proj.McBrydeQ3;
import gov.nasa.giss.map.proj.McBrydeS2;
import gov.nasa.giss.map.proj.McBrydeS3;
import gov.nasa.giss.map.proj.McBrydeThomas1;
import gov.nasa.giss.map.proj.McBrydeThomas2;
import gov.nasa.giss.map.proj.McBrydeThomas3;
import gov.nasa.giss.map.proj.McBrydeThomas4;
import gov.nasa.giss.map.proj.McBrydeThomas5;
import gov.nasa.giss.map.proj.Mercator;
import gov.nasa.giss.map.proj.MercatorRegional;
import gov.nasa.giss.map.proj.MillerCylindrical1;
import gov.nasa.giss.map.proj.MillerCylindrical2;
import gov.nasa.giss.map.proj.MillerOblatedStereographic;
import gov.nasa.giss.map.proj.MillerPerspectiveCompromise;
import gov.nasa.giss.map.proj.Mollweide;
import gov.nasa.giss.map.proj.MollweideOblique;
import gov.nasa.giss.map.proj.Murdoch1;
import gov.nasa.giss.map.proj.Murdoch3;
import gov.nasa.giss.map.proj.NaturalEarth1;
import gov.nasa.giss.map.proj.NaturalEarth2;
import gov.nasa.giss.map.proj.Nell;
import gov.nasa.giss.map.proj.NellHammer;
import gov.nasa.giss.map.proj.NicolosiGlobular;
import gov.nasa.giss.map.proj.NicolosiGlobular2H;
import gov.nasa.giss.map.proj.OrteliusOval;
import gov.nasa.giss.map.proj.Orthographic;
import gov.nasa.giss.map.proj.Orthographic2H;
import gov.nasa.giss.map.proj.Parabolic;
import gov.nasa.giss.map.proj.PattersonCylindrical;
import gov.nasa.giss.map.proj.Pavlov;
import gov.nasa.giss.map.proj.PeirceQuincuncial;
import gov.nasa.giss.map.proj.PetermannStar;
import gov.nasa.giss.map.proj.Philbrick;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjIntegerParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.PseudoOrthographic;
import gov.nasa.giss.map.proj.PseudoStereographic;
import gov.nasa.giss.map.proj.PutninsP1;
import gov.nasa.giss.map.proj.PutninsP2;
import gov.nasa.giss.map.proj.PutninsP3;
import gov.nasa.giss.map.proj.PutninsP3p;
import gov.nasa.giss.map.proj.PutninsP4p;
import gov.nasa.giss.map.proj.PutninsP5;
import gov.nasa.giss.map.proj.PutninsP5p;
import gov.nasa.giss.map.proj.PutninsP6;
import gov.nasa.giss.map.proj.PutninsP6p;
import gov.nasa.giss.map.proj.QuarticAuthalic;
import gov.nasa.giss.map.proj.RaiszArmadillo;
import gov.nasa.giss.map.proj.RaiszHalfEllipsoidal;
import gov.nasa.giss.map.proj.RectangularPolyconic;
import gov.nasa.giss.map.proj.RennerApian;
import gov.nasa.giss.map.proj.Robinson;
import gov.nasa.giss.map.proj.Siemon4;
import gov.nasa.giss.map.proj.Sinucyli;
import gov.nasa.giss.map.proj.Sinusoidal;
import gov.nasa.giss.map.proj.SnyderGS50;
import gov.nasa.giss.map.proj.SnyderMEFlatPole;
import gov.nasa.giss.map.proj.SnyderMEPointedPole;
import gov.nasa.giss.map.proj.SolovevModifiedBonne;
import gov.nasa.giss.map.proj.SolovevPerspectiveCylindrical;
import gov.nasa.giss.map.proj.SpilhausOceanicConformal;
import gov.nasa.giss.map.proj.StabiusWerner1;
import gov.nasa.giss.map.proj.StabiusWerner3;
import gov.nasa.giss.map.proj.Stereographic;
import gov.nasa.giss.map.proj.Stereographic2H;
import gov.nasa.giss.map.proj.StrebeEqualArea;
import gov.nasa.giss.map.proj.TiltedPerspective;
import gov.nasa.giss.map.proj.TimesAtlas;
import gov.nasa.giss.map.proj.ToblerCylindrical1;
import gov.nasa.giss.map.proj.ToblerCylindrical2;
import gov.nasa.giss.map.proj.ToblerG1;
import gov.nasa.giss.map.proj.ToblerHyperelliptical;
import gov.nasa.giss.map.proj.ToblerHyperellipticalX;
import gov.nasa.giss.map.proj.TransverseMercator;
import gov.nasa.giss.map.proj.USGSDaisy;
import gov.nasa.giss.map.proj.UrmayevCylindrical2;
import gov.nasa.giss.map.proj.UrmayevCylindrical3;
import gov.nasa.giss.map.proj.UrmayevSinusoidal;
import gov.nasa.giss.map.proj.VanDerGrinten1;
import gov.nasa.giss.map.proj.VanDerGrinten2;
import gov.nasa.giss.map.proj.VanDerGrinten3;
import gov.nasa.giss.map.proj.VanDerGrinten4;
import gov.nasa.giss.map.proj.VerticalPerspective;
import gov.nasa.giss.map.proj.Vitkovsky1;
import gov.nasa.giss.map.proj.Wagner1;
import gov.nasa.giss.map.proj.Wagner2;
import gov.nasa.giss.map.proj.Wagner3;
import gov.nasa.giss.map.proj.Wagner4;
import gov.nasa.giss.map.proj.Wagner5;
import gov.nasa.giss.map.proj.Wagner6;
import gov.nasa.giss.map.proj.Wagner7;
import gov.nasa.giss.map.proj.Wagner7RC;
import gov.nasa.giss.map.proj.Wagner8;
import gov.nasa.giss.map.proj.Wagner9;
import gov.nasa.giss.map.proj.Wiechel;
import gov.nasa.giss.map.proj.WilliamOlsson;
import gov.nasa.giss.map.proj.Winkel1;
import gov.nasa.giss.map.proj.Winkel2;
import gov.nasa.giss.map.proj.WinkelSnyder;
import gov.nasa.giss.map.proj.WinkelTripel;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProjectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String INDENT_3 = "   ";
    private static final String INDENT_6 = "      ";
    private static boolean devoEnabled_;
    private static ArrayList<ProjectionInfo> infoArray_;

    public static void setDevoEnabled() {
        if (devoEnabled_) {
            return;
        }
        AbstractProjection.setDevoEnabled();
        ProjectionFactory.registerProjection(Baranyi4z.class);
        ProjectionFactory.registerProjection(GyorffyG.class);
        ProjectionFactory.registerProjection(ToblerHyperellipticalX.class);
        ProjectionFactory.registerProjection(Eisenlohr.class);
        ProjectionFactory.registerProjection(GnomonicCSOblique.class);
        ProjectionFactory.registerProjection(AdamsHemisphereOblique.class);
        devoEnabled_ = true;
    }

    public static boolean registerProjection(Class<? extends AbstractProjection> pclass) {
        try {
            infoArray_.add(new ProjectionInfo(pclass));
            LOGGER.trace("Registered {}, {}", (Object)pclass.getSimpleName(), (Object)infoArray_.size());
            return true;
        }
        catch (Exception exc) {
            LOGGER.error("Could not register projection {}", (Object)pclass.getSimpleName());
            LOGGER.error("Error was {}", (Object)exc.getMessage());
            return false;
        }
    }

    public static AbstractProjection create(String name) {
        return ProjectionFactory.create(name, 200, 100);
    }

    public static AbstractProjection create(String name, int w, int h) {
        return ProjectionFactory.create(name, w, h, 0, 0);
    }

    public static AbstractProjection create(String name, int w, int h, int xm, int ym) {
        ProjectionInfo pinfo = ProjectionFactory.getInfoForName(name);
        if (pinfo == null) {
            throw new IllegalArgumentException("Unknown projection '" + name + "'");
        }
        if (xm < 0 || ym < 0) {
            throw new IllegalArgumentException("Invalid margin(s).");
        }
        if (w < 2 * xm + 2) {
            throw new IllegalArgumentException("Invalid map width.");
        }
        if (h < 2 * ym + 1) {
            throw new IllegalArgumentException("Invalid map height.");
        }
        try {
            Class<? extends AbstractProjection> aClass = pinfo.getPClass();
            Class[] types = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{w, h, xm, ym};
            Constructor<? extends AbstractProjection> c = aClass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (InvocationTargetException exc) {
            LOGGER.warn("Unable to create {} projection: {}", (Object)name, (Object)exc.getCause().toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new IllegalArgumentException("Projection construction error! " + exc.getMessage());
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to create {} projection: {}", (Object)name, (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new IllegalArgumentException("Projection construction error! " + exc.getMessage());
        }
    }

    public static boolean hasProperty(String name, int propint) {
        ProjectionInfo pinfo = ProjectionFactory.getInfoForName(name);
        if (pinfo == null) {
            throw new IllegalArgumentException("Unknown projection '" + name + "'");
        }
        return pinfo.hasProperty(propint);
    }

    public static String describeProjection(String name) {
        AbstractProjection proj = ProjectionFactory.create(name, 20, 10, 0, 0);
        if (proj == null) {
            LOGGER.warn("Somehow got null projection object.");
            return null;
        }
        String pname = proj.getName();
        String sname = proj.getNormalizedName();
        String cname = proj.getClass().getCanonicalName();
        StringBuilder sb = new StringBuilder(512);
        sb.append("Projection: ").append(pname).append('\n');
        if (!sname.equals(pname)) {
            sb.append("Normalized Name: ").append(sname).append('\n');
        }
        if (!cname.equals(pname)) {
            sb.append("Canonical Name: ").append(cname).append('\n');
        }
        sb.append("Properties:\n");
        if (proj.hasProperty(2)) {
            sb.append(INDENT_3).append("Fusion of other projections\n");
        }
        if (proj.hasProperty(4)) {
            sb.append(INDENT_3).append("Cylindric\n");
        }
        if (proj.hasProperty(8)) {
            sb.append(INDENT_3).append("Pseudocylindric\n");
        }
        if (proj.hasProperty(16)) {
            sb.append(INDENT_3).append("Conic\n");
        }
        if (proj.hasProperty(32)) {
            sb.append(INDENT_3).append("Polyconic\n");
        }
        if (proj.hasProperty(512)) {
            sb.append(INDENT_3).append("Pseudoconic\n");
        }
        if (proj.hasProperty(64)) {
            sb.append(INDENT_3).append("Azimuthal\n");
        }
        if (proj.hasProperty(128)) {
            sb.append(INDENT_3).append("Pseudozimuthal\n");
        }
        if (proj.hasProperty(2048)) {
            sb.append(INDENT_3).append("Retrozimuthal\n");
        }
        if (proj.hasProperty(256)) {
            sb.append(INDENT_3).append("Orthoapsidal\n");
        }
        if (proj.hasProperty(65536)) {
            sb.append(INDENT_3).append("Quincuncial\n");
        }
        if (proj.hasProperty(4096)) {
            sb.append(INDENT_3).append("Conformal\n");
        }
        if (proj.hasProperty(8192)) {
            sb.append(INDENT_3).append("Equal-Area\n");
        }
        if (proj.hasProperty(1024)) {
            sb.append(INDENT_3).append("Modified Stereographic\n");
        }
        if (proj.hasProperty(0x4000000)) {
            sb.append(INDENT_3).append("Globular\n");
        }
        if (proj.hasProperty(0x8000000)) {
            sb.append(INDENT_3).append("Polyhedral\n");
        }
        if (proj.hasProperty(0x400000)) {
            sb.append(INDENT_3).append("Shown with transverse aspect\n");
        }
        if (proj.hasProperty(0x200000)) {
            sb.append(INDENT_3).append("May be shown with oblique aspect\n");
        }
        if (proj.hasProperty(0x800000)) {
            sb.append(INDENT_3).append("Azimuthal (plagal) rotation may be applied\n");
        }
        if (proj.hasProperty(0x2000000)) {
            sb.append(INDENT_3).append("Displays side-by-side hemispheres\n");
        }
        if (proj.hasProperty(0x1000000)) {
            sb.append(INDENT_3).append("May be shown interrupted\n");
        }
        sb.append("Parameters:\n");
        if (proj.isRecenterableLon()) {
            sb.append(INDENT_3).append("0. Longitude at center of projection\n").append(INDENT_6).append("Type: float\n").append(INDENT_6).append("Range: ").append(-360).append(" \u2264 x \u2264 ").append(360).append('\n');
        }
        if (proj.isRecenterableLat()) {
            sb.append(INDENT_3).append("0. Latitude at center of projection\n").append(INDENT_6).append("Type: float\n").append(INDENT_6).append("Range: ").append(-90).append(" \u2264 x \u2264 ").append(90).append('\n');
        }
        int isize = proj.getExtraParamCount();
        for (int i = 0; i < isize; ++i) {
            ProjExtraParameter xparam = proj.getParameter(i);
            sb.append(INDENT_3).append(i + 1).append(". ").append(xparam.getDescription()).append('\n');
            if (xparam.getUnits() != null) {
                sb.append(INDENT_6).append("Units: ").append(xparam.getUnits()).append('\n');
            }
            if (xparam instanceof ProjBooleanParameter) {
                sb.append(INDENT_6).append("Type: boolean\n").append(INDENT_6).append("Default: ").append(xparam.getDefaultObject()).append('\n');
                continue;
            }
            if (xparam instanceof ProjDoubleParameter) {
                ProjDoubleParameter dparam = (ProjDoubleParameter)xparam;
                sb.append(INDENT_6).append("Type: float\n").append(INDENT_6).append("Range: ").append(dparam.getMinimum()).append(' ');
                if (dparam.isMinimumInclusive()) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(" x ");
                if (dparam.isMaximumInclusive()) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ').append(dparam.getMaximum()).append('\n');
                sb.append(INDENT_6).append("Default: ").append(xparam.getDefaultObject()).append('\n');
                continue;
            }
            if (xparam instanceof ProjIntegerParameter) {
                ProjIntegerParameter iparam = (ProjIntegerParameter)xparam;
                sb.append(INDENT_6).append("Type: integer\n").append(INDENT_6).append("Range: ").append(iparam.getMinimum()).append(" \u2264 x \u2264 ").append(iparam.getMaximum()).append('\n');
                sb.append(INDENT_6).append("Default: ").append(xparam.getDefaultObject()).append('\n');
                continue;
            }
            if (!(xparam instanceof ProjListParameter)) continue;
            sb.append(INDENT_6).append("Type: enum\n");
            Object[] oo = ((ProjListParameter)xparam).getChoices();
            for (int j = 0; j < oo.length; ++j) {
                ProjListEnum ple = (ProjListEnum)oo[j];
                sb.append(INDENT_6).append(INDENT_3).append(ple.name()).append(" = \"").append(ple.toString()).append("\"\n");
            }
            Object o = ((ProjListParameter)xparam).getDefaultObject();
            ProjListEnum dple = (ProjListEnum)o;
            sb.append(INDENT_6).append("Default: ").append(dple.name()).append(" = \"").append(dple.toString()).append("\"\n");
        }
        return sb.toString();
    }

    public static String[] getNames() {
        return ProjectionFactory.getNames(0, false);
    }

    public static String[] getNormalizedNames() {
        return ProjectionFactory.getNames(0, true);
    }

    public static String[] getNames(int property, boolean normalized) {
        int isize = infoArray_.size();
        ArrayList<String> names = new ArrayList<String>(isize);
        for (ProjectionInfo pi : infoArray_) {
            if (property != 0 && !pi.hasProperty(property)) continue;
            String name = normalized ? pi.getNormalizedName() : pi.getName();
            names.add(name);
        }
        Collections.sort(names, new ProjNameComparator());
        String[] sortedNames = new String[isize];
        for (int i = 0; i < isize; ++i) {
            sortedNames[i] = (String)names.get(i);
        }
        return sortedNames;
    }

    private static ProjectionInfo getInfoForName(String name) {
        Objects.requireNonNull(name, "Projection name cannot be null.");
        for (ProjectionInfo pi : infoArray_) {
            if (!pi.getName().equalsIgnoreCase(name) && !pi.getClassName().equalsIgnoreCase(name) && !pi.getNormalizedName().equalsIgnoreCase(name)) continue;
            return pi;
        }
        return null;
    }

    private ProjectionFactory() {
    }

    static {
        infoArray_ = new ArrayList(250);
        ProjectionFactory.registerProjection(Equirectangular.class);
        ProjectionFactory.registerProjection(Orthographic.class);
        ProjectionFactory.registerProjection(Mollweide.class);
        ProjectionFactory.registerProjection(Stereographic.class);
        ProjectionFactory.registerProjection(Aitoff.class);
        ProjectionFactory.registerProjection(AzimuthalEquidistant.class);
        ProjectionFactory.registerProjection(AzimuthalEqualArea.class);
        ProjectionFactory.registerProjection(Hammer.class);
        ProjectionFactory.registerProjection(Sinusoidal.class);
        ProjectionFactory.registerProjection(Parabolic.class);
        ProjectionFactory.registerProjection(Eckert4.class);
        ProjectionFactory.registerProjection(Eckert6.class);
        ProjectionFactory.registerProjection(Eckert5.class);
        ProjectionFactory.registerProjection(EckertGreifendorff.class);
        ProjectionFactory.registerProjection(QuarticAuthalic.class);
        ProjectionFactory.registerProjection(McBrydeThomas4.class);
        ProjectionFactory.registerProjection(McBrydeThomas3.class);
        ProjectionFactory.registerProjection(McBrydeThomas5.class);
        ProjectionFactory.registerProjection(Eckert3.class);
        ProjectionFactory.registerProjection(Wagner4.class);
        ProjectionFactory.registerProjection(Kavraisky7.class);
        ProjectionFactory.registerProjection(PutninsP3.class);
        ProjectionFactory.registerProjection(PutninsP3p.class);
        ProjectionFactory.registerProjection(PutninsP5.class);
        ProjectionFactory.registerProjection(PutninsP5p.class);
        ProjectionFactory.registerProjection(NellHammer.class);
        ProjectionFactory.registerProjection(Wagner1.class);
        ProjectionFactory.registerProjection(PutninsP4p.class);
        ProjectionFactory.registerProjection(Winkel1.class);
        ProjectionFactory.registerProjection(Wagner2.class);
        ProjectionFactory.registerProjection(Wagner5.class);
        ProjectionFactory.registerProjection(WinkelTripel.class);
        ProjectionFactory.registerProjection(Mercator.class);
        ProjectionFactory.registerProjection(MillerCylindrical1.class);
        ProjectionFactory.registerProjection(GallStereographic.class);
        ProjectionFactory.registerProjection(OrteliusOval.class);
        ProjectionFactory.registerProjection(VanDerGrinten1.class);
        ProjectionFactory.registerProjection(VerticalPerspective.class);
        ProjectionFactory.registerProjection(Wagner7.class);
        ProjectionFactory.registerProjection(Wagner8.class);
        ProjectionFactory.registerProjection(Apian2.class);
        ProjectionFactory.registerProjection(PutninsP1.class);
        ProjectionFactory.registerProjection(Wagner6.class);
        ProjectionFactory.registerProjection(Hoelzel.class);
        ProjectionFactory.registerProjection(McBrydeP3.class);
        ProjectionFactory.registerProjection(McBrydeQ3.class);
        ProjectionFactory.registerProjection(McBrydeS2.class);
        ProjectionFactory.registerProjection(GoodeHomolosine.class);
        ProjectionFactory.registerProjection(McBrydeS3.class);
        ProjectionFactory.registerProjection(CantersPseudocylindricW19.class);
        ProjectionFactory.registerProjection(CantersPseudocylindricW15.class);
        ProjectionFactory.registerProjection(CantersPseudocylindricW17.class);
        ProjectionFactory.registerProjection(CantersPseudocylindricW16.class);
        ProjectionFactory.registerProjection(FoucautStereographic.class);
        ProjectionFactory.registerProjection(McBrydeThomas1.class);
        ProjectionFactory.registerProjection(Kavraisky5.class);
        ProjectionFactory.registerProjection(Denoyer.class);
        ProjectionFactory.registerProjection(Winkel2.class);
        ProjectionFactory.registerProjection(ErdiKrausz.class);
        ProjectionFactory.registerProjection(Wagner9.class);
        ProjectionFactory.registerProjection(RaiszArmadillo.class);
        ProjectionFactory.registerProjection(Wagner3.class);
        ProjectionFactory.registerProjection(CantersPolyconicW14.class);
        ProjectionFactory.registerProjection(RaiszHalfEllipsoidal.class);
        ProjectionFactory.registerProjection(Robinson.class);
        ProjectionFactory.registerProjection(PutninsP2.class);
        ProjectionFactory.registerProjection(PutninsP6.class);
        ProjectionFactory.registerProjection(PutninsP6p.class);
        ProjectionFactory.registerProjection(TimesAtlas.class);
        ProjectionFactory.registerProjection(GallBomfordPseudocylindrical.class);
        ProjectionFactory.registerProjection(Pavlov.class);
        ProjectionFactory.registerProjection(CylindricalEqualArea.class);
        ProjectionFactory.registerProjection(Ginzburg8.class);
        ProjectionFactory.registerProjection(Larrivee.class);
        ProjectionFactory.registerProjection(BakerDinomic.class);
        ProjectionFactory.registerProjection(EquidistantConic.class);
        ProjectionFactory.registerProjection(AlbersEqualAreaConic.class);
        ProjectionFactory.registerProjection(LambertConformalConic.class);
        ProjectionFactory.registerProjection(UrmayevSinusoidal.class);
        ProjectionFactory.registerProjection(BoggsEumorphic.class);
        ProjectionFactory.registerProjection(Nell.class);
        ProjectionFactory.registerProjection(Fahey.class);
        ProjectionFactory.registerProjection(Bonne.class);
        ProjectionFactory.registerProjection(BraunStereographic.class);
        ProjectionFactory.registerProjection(BraunPerspective.class);
        ProjectionFactory.registerProjection(HillEucyclic.class);
        ProjectionFactory.registerProjection(Fournier1.class);
        ProjectionFactory.registerProjection(BaconGlobular.class);
        ProjectionFactory.registerProjection(GottEqualArea.class);
        ProjectionFactory.registerProjection(Mayr.class);
        ProjectionFactory.registerProjection(ToblerG1.class);
        ProjectionFactory.registerProjection(Gringorten.class);
        ProjectionFactory.registerProjection(Gnomonic.class);
        ProjectionFactory.registerProjection(GnomonicCubedSphere.class);
        ProjectionFactory.registerProjection(GottMugnoloAzimuthal.class);
        ProjectionFactory.registerProjection(EquirectangularOblique.class);
        ProjectionFactory.registerProjection(Airy.class);
        ProjectionFactory.registerProjection(BreusingGeometric.class);
        ProjectionFactory.registerProjection(BreusingHarmonic.class);
        ProjectionFactory.registerProjection(Ginzburg4.class);
        ProjectionFactory.registerProjection(Ginzburg5.class);
        ProjectionFactory.registerProjection(Ginzburg6.class);
        ProjectionFactory.registerProjection(Ginzburg9.class);
        ProjectionFactory.registerProjection(TransverseMercator.class);
        ProjectionFactory.registerProjection(NaturalEarth1.class);
        ProjectionFactory.registerProjection(MillerOblatedStereographic.class);
        ProjectionFactory.registerProjection(SnyderGS50.class);
        ProjectionFactory.registerProjection(Cassini.class);
        ProjectionFactory.registerProjection(HammerOblique.class);
        ProjectionFactory.registerProjection(MollweideOblique.class);
        ProjectionFactory.registerProjection(StrebeEqualArea.class);
        ProjectionFactory.registerProjection(AmericanPolyconicGlobal.class);
        ProjectionFactory.registerProjection(AmericanPolyconic.class);
        ProjectionFactory.registerProjection(Orthographic2H.class);
        ProjectionFactory.registerProjection(AzimuthalEqualArea2H.class);
        ProjectionFactory.registerProjection(AzimuthalEquidistant2H.class);
        ProjectionFactory.registerProjection(Stereographic2H.class);
        ProjectionFactory.registerProjection(GottMugnoloAzimuthal2H.class);
        ProjectionFactory.registerProjection(BreusingGeometric2H.class);
        ProjectionFactory.registerProjection(BreusingHarmonic2H.class);
        ProjectionFactory.registerProjection(CantersPolyconicW12.class);
        ProjectionFactory.registerProjection(CantersPolyconicW13.class);
        ProjectionFactory.registerProjection(RectangularPolyconic.class);
        ProjectionFactory.registerProjection(CompactMiller.class);
        ProjectionFactory.registerProjection(PattersonCylindrical.class);
        ProjectionFactory.registerProjection(Wiechel.class);
        ProjectionFactory.registerProjection(ArdenClose.class);
        ProjectionFactory.registerProjection(KharchenkoShabanova.class);
        ProjectionFactory.registerProjection(UrmayevCylindrical2.class);
        ProjectionFactory.registerProjection(UrmayevCylindrical3.class);
        ProjectionFactory.registerProjection(BSAMCylindrical.class);
        ProjectionFactory.registerProjection(MillerPerspectiveCompromise.class);
        ProjectionFactory.registerProjection(ToblerCylindrical1.class);
        ProjectionFactory.registerProjection(ToblerCylindrical2.class);
        ProjectionFactory.registerProjection(NicolosiGlobular.class);
        ProjectionFactory.registerProjection(NicolosiGlobular2H.class);
        ProjectionFactory.registerProjection(Fournier1TwoH.class);
        ProjectionFactory.registerProjection(Apian2TwoH.class);
        ProjectionFactory.registerProjection(BaconGlobular2H.class);
        ProjectionFactory.registerProjection(Kamenetskiy.class);
        ProjectionFactory.registerProjection(CylindricalStereographic.class);
        ProjectionFactory.registerProjection(Hufnagel.class);
        ProjectionFactory.registerProjection(CentralCylindrical.class);
        ProjectionFactory.registerProjection(EquirectangularRegional.class);
        ProjectionFactory.registerProjection(PeirceQuincuncial.class);
        ProjectionFactory.registerProjection(Ginzburg1.class);
        ProjectionFactory.registerProjection(Ginzburg2.class);
        ProjectionFactory.registerProjection(LogarithmicAzimuthal.class);
        ProjectionFactory.registerProjection(Healpix.class);
        ProjectionFactory.registerProjection(Littrow.class);
        ProjectionFactory.registerProjection(Siemon4.class);
        ProjectionFactory.registerProjection(FoucautSinusoidal.class);
        ProjectionFactory.registerProjection(Loximuthal.class);
        ProjectionFactory.registerProjection(Hatano.class);
        ProjectionFactory.registerProjection(Bottomley.class);
        ProjectionFactory.registerProjection(StabiusWerner3.class);
        ProjectionFactory.registerProjection(StabiusWerner1.class);
        ProjectionFactory.registerProjection(GilbertTwoWorld.class);
        ProjectionFactory.registerProjection(WinkelSnyder.class);
        ProjectionFactory.registerProjection(McBrydeThomas2.class);
        ProjectionFactory.registerProjection(Philbrick.class);
        ProjectionFactory.registerProjection(NaturalEarth2.class);
        ProjectionFactory.registerProjection(CantersPolyconicW21.class);
        ProjectionFactory.registerProjection(CantersPseudocylindricW33.class);
        ProjectionFactory.registerProjection(CantersPseudocylindricW34.class);
        ProjectionFactory.registerProjection(CantersPolyconicW20.class);
        ProjectionFactory.registerProjection(Guyou.class);
        ProjectionFactory.registerProjection(AdamsWorldInASquare1.class);
        ProjectionFactory.registerProjection(AdamsWorldInASquare2.class);
        ProjectionFactory.registerProjection(AdamsHemisphereInASquare.class);
        ProjectionFactory.registerProjection(VanDerGrinten3.class);
        ProjectionFactory.registerProjection(VanDerGrinten2.class);
        ProjectionFactory.registerProjection(WilliamOlsson.class);
        ProjectionFactory.registerProjection(BerghausStar.class);
        ProjectionFactory.registerProjection(BartholomewTetrahedral.class);
        ProjectionFactory.registerProjection(HexafoliateEqualArea.class);
        ProjectionFactory.registerProjection(MaurerS231.class);
        ProjectionFactory.registerProjection(PetermannStar.class);
        ProjectionFactory.registerProjection(HexafoliateEquidistant.class);
        ProjectionFactory.registerProjection(AugustEpicycloidal.class);
        ProjectionFactory.registerProjection(LambertLagrange.class);
        ProjectionFactory.registerProjection(MillerCylindrical2.class);
        ProjectionFactory.registerProjection(MaurerS187.class);
        ProjectionFactory.registerProjection(MaurerS159.class);
        ProjectionFactory.registerProjection(AzimuthalFarSidePerspective.class);
        ProjectionFactory.registerProjection(MaurerS160.class);
        ProjectionFactory.registerProjection(ClarkeTwilight.class);
        ProjectionFactory.registerProjection(JamesAzimuthal.class);
        ProjectionFactory.registerProjection(AitoffOblique.class);
        ProjectionFactory.registerProjection(Baranyi4.class);
        ProjectionFactory.registerProjection(SpilhausOceanicConformal.class);
        ProjectionFactory.registerProjection(BaarSineSeries.class);
        ProjectionFactory.registerProjection(DeakinMinimumError.class);
        ProjectionFactory.registerProjection(EqualEarth.class);
        ProjectionFactory.registerProjection(HammerAzimuthal.class);
        ProjectionFactory.registerProjection(ToblerHyperelliptical.class);
        ProjectionFactory.registerProjection(SolovevModifiedBonne.class);
        ProjectionFactory.registerProjection(SolovevPerspectiveCylindrical.class);
        ProjectionFactory.registerProjection(CEAOblique.class);
        ProjectionFactory.registerProjection(BertinRiviere.class);
        ProjectionFactory.registerProjection(VanDerGrinten4.class);
        ProjectionFactory.registerProjection(GnomonicIcosahedron.class);
        ProjectionFactory.registerProjection(GyorffyE.class);
        ProjectionFactory.registerProjection(GyorffyB.class);
        ProjectionFactory.registerProjection(GyorffyA.class);
        ProjectionFactory.registerProjection(GyorffyD.class);
        ProjectionFactory.registerProjection(GyorffyF.class);
        ProjectionFactory.registerProjection(Fournier2.class);
        ProjectionFactory.registerProjection(SnyderMEPointedPole.class);
        ProjectionFactory.registerProjection(SnyderMEFlatPole.class);
        ProjectionFactory.registerProjection(Baranyi1.class);
        ProjectionFactory.registerProjection(Baranyi2.class);
        ProjectionFactory.registerProjection(Baranyi3.class);
        ProjectionFactory.registerProjection(Cabot.class);
        ProjectionFactory.registerProjection(Baranyi6.class);
        ProjectionFactory.registerProjection(Baranyi7.class);
        ProjectionFactory.registerProjection(Baranyi5.class);
        ProjectionFactory.registerProjection(Sinucyli.class);
        ProjectionFactory.registerProjection(Apian1.class);
        ProjectionFactory.registerProjection(Airy2H.class);
        ProjectionFactory.registerProjection(Ginzburg1TwoH.class);
        ProjectionFactory.registerProjection(Ginzburg2TwoH.class);
        ProjectionFactory.registerProjection(Murdoch1.class);
        ProjectionFactory.registerProjection(Murdoch3.class);
        ProjectionFactory.registerProjection(Euler.class);
        ProjectionFactory.registerProjection(Vitkovsky1.class);
        ProjectionFactory.registerProjection(Kavraisky2.class);
        ProjectionFactory.registerProjection(Eckert1.class);
        ProjectionFactory.registerProjection(Eckert2.class);
        ProjectionFactory.registerProjection(DoubleCordiform.class);
        ProjectionFactory.registerProjection(BonneRegional.class);
        ProjectionFactory.registerProjection(CantersPolyconicW31.class);
        ProjectionFactory.registerProjection(CantersPolyconicW32.class);
        ProjectionFactory.registerProjection(USGSDaisy.class);
        ProjectionFactory.registerProjection(PseudoStereographic.class);
        ProjectionFactory.registerProjection(PseudoOrthographic.class);
        ProjectionFactory.registerProjection(RennerApian.class);
        ProjectionFactory.registerProjection(Wagner7RC.class);
        ProjectionFactory.registerProjection(TiltedPerspective.class);
        ProjectionFactory.registerProjection(MercatorRegional.class);
    }
}

