/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderXY;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;

public class NcArrayXY
extends NcArray2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object xAxisInfo_;
    private final Object yAxisInfo_;

    public NcArrayXY(NcVariable ncvar, Object xAxisInfo, Object yAxisInfo) throws NcException {
        super(ncvar);
        this.xAxisInfo_ = xAxisInfo;
        this.yAxisInfo_ = yAxisInfo;
        this.createAxes();
        this.measureAxes();
    }

    @Override
    protected void createAxes() {
        int lonindex;
        LOGGER.trace("xAxisInfo_ {}, yAxisInfo_ {}", this.xAxisInfo_, this.yAxisInfo_);
        this.createAxis(Axis.X, this.xAxisInfo_);
        this.createAxis(Axis.Y, this.yAxisInfo_);
        CoordinateAxis lonaxis = NcUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.LON);
        if (lonaxis instanceof CoordinateAxis1D && lonaxis.getRank() == 1 && lonaxis.getShape()[0] > 0 && (lonindex = this.findDimensionIndex(lonaxis)) != this.xDimIndex_ && lonindex != this.yDimIndex_) {
            this.setAveDimIndex(lonindex);
        }
    }

    private void createAxis(Axis axdir, Object axisInfo) {
        Dimension d;
        int i;
        LOGGER.trace("{}, {}", (Object)axdir, (Object)axisInfo.getClass().getSimpleName());
        int dimIndex = -1;
        Dimension axDim = null;
        VariableDS axCV = null;
        boolean usesIndirectTimeAxis = false;
        if (axisInfo instanceof NcDimension) {
            Dimension dd = ((NcDimension)axisInfo).getNjDimension();
            for (i = 0; i < this.rank_; ++i) {
                d = this.njvarDS_.getDimension(i);
                if (!d.equals(dd)) continue;
                dimIndex = i;
                break;
            }
        } else if (axisInfo instanceof Integer) {
            dimIndex = (Integer)axisInfo;
            if (dimIndex < 0 || dimIndex > this.rank_) {
                throw new IndexOutOfBoundsException(axdir + " axisInfo is out-of-range integer.");
            }
        } else if (axisInfo instanceof NcVariable || axisInfo instanceof VariableDS) {
            VariableDS axvarDS = null;
            if (axisInfo instanceof NcVariable) {
                NcVariable ncvar = (NcVariable)axisInfo;
                axvarDS = (VariableDS)ncvar.getObject();
            } else {
                axvarDS = (VariableDS)axisInfo;
            }
            int axrank = axvarDS.getRank();
            if (axrank == 1 && NcUtils.isUnixTime(axvarDS)) {
                Dimension dd = axvarDS.getDimension(0);
                for (int i2 = 0; i2 < this.rank_; ++i2) {
                    Dimension d2 = this.njvarDS_.getDimension(i2);
                    if (!d2.equals(dd)) continue;
                    usesIndirectTimeAxis = true;
                    axCV = axvarDS;
                    axDim = d2;
                    dimIndex = i2;
                    break;
                }
            } else {
                LOGGER.trace("{} axisInfo is apparently not 1D time", (Object)axdir);
            }
        } else if (axisInfo instanceof String) {
            String dname = (String)axisInfo;
            for (i = 0; i < this.rank_; ++i) {
                d = this.njvarDS_.getDimension(i);
                String sname = d.getShortName();
                String fname = d.getFullName();
                if (sname == null || fname == null || !sname.equals(dname) && !fname.equals(dname)) continue;
                dimIndex = i;
                break;
            }
        } else {
            LOGGER.trace("{} axisInfo is unknown class", (Object)axdir);
            throw new IllegalArgumentException("Invalid axis info type");
        }
        LOGGER.trace("{}, dimIndex {}", (Object)axdir, (Object)dimIndex);
        if (dimIndex < 0) {
            throw new NcException("No matching " + axdir + " axis dimension found");
        }
        if (dimIndex > this.rank_) {
            throw new IndexOutOfBoundsException(axdir + " axis index out of range");
        }
        if (this.shape_[dimIndex] < 2) {
            throw new NcException(axdir + " axis dimension is too short for use");
        }
        if (axDim == null) {
            axDim = this.njvarDS_.getDimension(dimIndex);
        }
        if (axCV == null) {
            axCV = this.dataset_.getCoordinateVariable(axDim);
        }
        NcAxis axis = null;
        if (axCV == null) {
            LOGGER.trace("Could not find coord var {}", (Object)axDim.getShortName());
            String sname = axDim.getShortName();
            int length = axDim.getLength();
            if (axdir == Axis.X) {
                axis = new NcAxis(NcAxisType.GEOX, sname, length);
            } else if (axdir == Axis.Y) {
                axis = new NcAxis(NcAxisType.GEOY, sname, length);
            }
        } else if (usesIndirectTimeAxis) {
            LOGGER.trace("Axis CV looks like secondary time.");
            try {
                axis = new NcTimeAxis(this.dataset_, axCV);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception creating secondary NcTimeAxis: ", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
            }
        } else if (NcUtils.isUnixTime(axCV)) {
            axis = new NcTimeAxis(this.dataset_, axCV);
        } else if (NcUtils.isPressure(axCV) || NcUtils.isHeight(axCV) || NcUtils.isDepth(axCV)) {
            LOGGER.debug("Switching axis type to VERT");
            axis = new NcAxis(NcAxisType.VERT, this.dataset_, axCV);
        } else if (axdir == Axis.X) {
            axis = new NcAxis(NcAxisType.GEOX, this.dataset_, axCV);
        } else if (axdir == Axis.Y) {
            axis = new NcAxis(NcAxisType.GEOY, this.dataset_, axCV);
        }
        if (axdir == Axis.X) {
            this.xDimIndex_ = dimIndex;
            this.xAxis_ = axis;
        } else {
            this.yDimIndex_ = dimIndex;
            this.yAxis_ = axis;
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderXY();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double x = this.xAxis_.valueAt(col);
        double y = this.yAxis_.valueAt(row);
        PrintfFormat pformat10g = new PrintfFormat("%.10g");
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [").append(pformat10g.sprintfx(x));
        if (this.xAxis_.getUnitsStr() != null) {
            sb.append(' ').append(this.xAxis_.getUnitsStr());
        }
        sb.append(", ").append(pformat10g.sprintfx(y));
        if (this.yAxis_.getUnitsStr() != null) {
            sb.append(' ').append(this.yAxis_.getUnitsStr());
        }
        sb.append("], value = ");
        double gv = this.valueAt(col, row);
        sb.append(valFormat.sprintfx(gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            sb.append(' ').append(unitsStr);
        }
    }

    private static enum Axis {
        X,
        Y;

    }
}

