/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2025 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::zoneGenerators::clear

Description
    A zoneGenerator which clears all existing zones from the mesh

Usage
    \table
        Property     | Description             | Required | Default value
        type         | Type: clear             | yes      |
    \endtable

    Example:
    \verbatim
        clearAllZones
        {
            type        clear;
        }
    \endverbatim
    When called from the top-level of the createZonesDict or zonesGenerator
    files which is the most likely use the simpler syntax to clear all the zones
    can be used:
    \verbatim
        clear;
    \endverbatim

See also
    zoneGenerators::remove

SourceFiles
    clear.C

\*---------------------------------------------------------------------------*/

#ifndef clear_zoneGenerator_H
#define clear_zoneGenerator_H

#include "zoneGeneratorList.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace zoneGenerators
{

/*---------------------------------------------------------------------------*\
                              Class clear Declaration
\*---------------------------------------------------------------------------*/

class clear
:
    public zoneGenerator
{

public:

    //- Runtime type information
    TypeName("clear");


    // Constructors

        //- Construct from dictionary
        clear
        (
            const word& name,
            const polyMesh& mesh,
            const dictionary& dict
        );


    //- Destructor
    virtual ~clear();


    // Member Functions

        virtual zoneSet generate() const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace zoneGenerators
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
