/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2016-2025 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "phaseFraction.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
namespace wallBoilingModels
{
namespace partitioningModels
{
    defineTypeNameAndDebug(phaseFraction, 0);
    addToRunTimeSelectionTable
    (
        partitioningModel,
        phaseFraction,
        dictionary
    );
}
}
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::wallBoilingModels::partitioningModels::phaseFraction::phaseFraction
(
    const dictionary& dict
)
:
    partitioningModel()
{}


Foam::wallBoilingModels::partitioningModels::phaseFraction::phaseFraction
(
    const phaseFraction& model
)
:
    partitioningModel(model)
{}


// * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * * //

Foam::wallBoilingModels::partitioningModels::phaseFraction::~phaseFraction()
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::tmp<Foam::scalarField>
Foam::wallBoilingModels::partitioningModels::phaseFraction::wetFraction
(
    const scalarField& alphaLiquid
) const
{
    return tmp<scalarField>(alphaLiquid);
}


Foam::tmp<Foam::volScalarField::Internal>
Foam::wallBoilingModels::partitioningModels::phaseFraction::wetFraction
(
    const volScalarField::Internal& alphaLiquid
) const
{
    return tmp<volScalarField::Internal>(alphaLiquid);
}


Foam::tmp<Foam::volScalarField>
Foam::wallBoilingModels::partitioningModels::phaseFraction::wetFraction
(
    const volScalarField& alphaLiquid
) const
{
    return tmp<volScalarField>(alphaLiquid);
}


// ************************************************************************* //
