/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2021-2022 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "calculatedPointPatchField.H"

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::calculatedPointPatchField<Type>::calculatedPointPatchField
(
    const pointPatch& p,
    const DimensionedField<Type, pointMesh>& iF
)
:
    pointPatchField<Type>(p, iF)
{}


template<class Type>
Foam::calculatedPointPatchField<Type>::calculatedPointPatchField
(
    const pointPatch& p,
    const DimensionedField<Type, pointMesh>& iF,
    const dictionary& dict
)
:
    pointPatchField<Type>(p, iF, dict)
{}


template<class Type>
Foam::calculatedPointPatchField<Type>::calculatedPointPatchField
(
    const calculatedPointPatchField<Type>& ptf,
    const pointPatch& p,
    const DimensionedField<Type, pointMesh>& iF,
    const pointPatchFieldMapper& mapper
)
:
    pointPatchField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::calculatedPointPatchField<Type>::calculatedPointPatchField
(
    const calculatedPointPatchField<Type>& ptf,
    const DimensionedField<Type, pointMesh>& iF
)
:
    pointPatchField<Type>(ptf, iF)
{}


template<class Type>
Foam::autoPtr<Foam::pointPatchField<Type>>
Foam::pointPatchField<Type>::NewCalculatedType
(
    const pointPatch& p
)
{
    auto* patchTypeCtor = patchConstructorTable(p.type());

    if (patchTypeCtor)
    {
        return autoPtr<pointPatchField<Type>>
        (
            patchTypeCtor
            (
                p,
                DimensionedField<Type, pointMesh>::null()
            )
        );
    }
    else
    {
        return autoPtr<pointPatchField<Type>>
        (
            new calculatedPointPatchField<Type>
            (
                p,
                DimensionedField<Type, pointMesh>::null()
            )
        );
    }
}


template<class Type>
template<class AnyType>
Foam::autoPtr<Foam::pointPatchField<Type>>
Foam::pointPatchField<Type>::NewCalculatedType
(
    const pointPatchField<AnyType>& pf
)
{
    return NewCalculatedType(pf.patch());
}


// ************************************************************************* //
