#!/bin/sh

if [ -x "/bin/echo" ];
then
  ECHOCOMMAND="/bin/echo"
elif [ -x "/usr/bin/echo" ];
then
  ECHOCOMMAND="/usr/bin/echo"
else
  ECHOCOMMAND="echo"
fi

if [ -x "/bin/head" ];
then
  HEADCOMMAND="/bin/head"
elif [ -x "/usr/bin/head" ];
then
  HEADCOMMAND="/usr/bin/head"
else
  HEADCOMMAND="head"
fi

if [ -x "/usr/bin/awk" ];
then
  AWKCOMMAND="/usr/bin/awk"
else
  AWKCOMMAND="awk"
fi

if [ -x "/usr/bin/grep" ]
then
  GREPCOMMAND="/usr/bin/grep"
elif [ -x "/bin/grep" ]
then
  GREPCOMMAND="/bin/grep"
else
  GREPCOMMAND="grep"
fi

NX_SYSTEM="/usr/NX"
CONFIG_FILE="${NX_SYSTEM}/etc/node.cfg"

if [ -z "$LD_PRELOAD" ]; then
  LD_PRELOAD=$NX_SYSTEM/lib/libnxegl.so
else
  LD_PRELOAD=$NX_SYSTEM/lib/libnxegl.so:$LD_PRELOAD
fi

getValueFromCfgFile ()
{
  #Config File Format:  Variable = Value or Variable = "Value"

  #Parameters:
  # $1 - Variable
  # $2 - File name
  #Function returns:
  # 0 : no such variable or no such file
  # 1 : variable is commented (default value)
  # 2 : variable exists, value returned in cfg_val

  ret_getValueFromCfgFile=0

  variable=$1
  file_name=$2
  cfg_val=""

  if [ ! -f "${file_name}" ] || [ "x${variable}" = "x" ];
  then
    return 0
  fi

  grep_out=$(${GREPCOMMAND} -E "^([[:space:]]){0,}${variable}([[:space:]]){1,}" "${file_name}" 2>/dev/null)
  if [ "x${grep_out}" = "x" ];
    then
    grep_out=$(${GREPCOMMAND} -E "^([[:space:]]){0,}[#]{0,1}([[:space:]]){0,}${variable}([[:space:]]){1,}" "${file_name}" 2>/dev/null)
  fi

  if [ "x${grep_out}" != "x" ];
  then
    grep_commented=$(${GREPCOMMAND} -e "${grep_out}" "${file_name}" | ${HEADCOMMAND} -n 1 | ${AWKCOMMAND} '{ if (index($1,"#")==1) print "0"; else print "1" }' 2>/dev/null)
    if [ "x${grep_commented}" = "x0" ];
    then
      cfg_val=$(${ECHOCOMMAND} "${grep_out}" | ${AWKCOMMAND} -F '\"' '{print $2}')
      if [ "x${cfg_val}" = "x" ];
      then
        cfg_val=$(${ECHOCOMMAND} "${grep_out}" | ${AWKCOMMAND} -v FS="${variable}"'[ \t]+' '{print $NF}')
      fi
      ret_getValueFromCfgFile=1
      return 0
    else
      cfg_val=$(${ECHOCOMMAND} "${grep_out}" | ${AWKCOMMAND} -F '\"' '{print $2}')
      if [ "x${cfg_val}" = "x" ];
      then
        cfg_val=$(${ECHOCOMMAND} "${grep_out}" | ${AWKCOMMAND} -v FS="${variable}"'[ \t]+' '{print $NF}')
      fi
      ret_getValueFromCfgFile=2
      return 0
    fi
  else
    return 0
  fi
}

getValueFromCfgFile "UsersDirectoryPath" "${CONFIG_FILE}"

if [ $ret_getValueFromCfgFile = 2 ];
then
  NX_ROOT="$cfg_val"
  export NX_ROOT
fi

export LD_PRELOAD
exec "$@"
# End of script
