#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxsshhostcertset.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

if test -x "/usr/bin/date"; then
  COMMAND_DATE="/usr/bin/date"
elif test -x "/usr/sbin/date"; then
  COMMAND_DATE="/usr/sbin/date"
elif test -x "/bin/date"; then
  COMMAND_DATE="/bin/date"
elif test -x "/sbin/date"; then
  COMMAND_DATE="/sbin/date"
elif test -x "/usr/local/bin/date"; then
  COMMAND_DATE="/usr/local/bin/date"
elif test -x "/usr/local/sbin/date"; then
  COMMAND_DATE="/usr/local/sbin/date"
else
  errorCommandNotFound "date" "1"
fi

if test -x "/usr/bin/touch"; then
  COMMAND_TOUCH="/usr/bin/touch"
elif test -x "/usr/sbin/touch"; then
  COMMAND_TOUCH="/usr/sbin/touch"
elif test -x "/bin/touch"; then
  COMMAND_TOUCH="/bin/touch"
elif test -x "/sbin/touch"; then
  COMMAND_TOUCH="/sbin/touch"
elif test -x "/usr/local/bin/touch"; then
  COMMAND_TOUCH="/usr/local/bin/touch"
elif test -x "/usr/local/sbin/touch"; then
  COMMAND_TOUCH="/usr/local/sbin/touch"
else
  errorCommandNotFound "touch" "1"
fi

PARAMS_COUNT=4

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

ALGORITHM=$3
TYPE=$4

SSH_HOST_DSA_KEY="/etc/ssh/ssh_host_dsa_key"
SSH_HOST_RSA_KEY="/etc/ssh/ssh_host_rsa_key"
SSH_HOST_ECDSA_KEY="/etc/ssh/ssh_host_ecdsa_key"
SSH_HOST_ED25519_KEY="/etc/ssh/ssh_host_ed25519_key"

if [[ "$ALGORITHM" == "DSA" ]]; then
  FILE=$SSH_HOST_DSA_KEY
elif [[ "$ALGORITHM" == "RSA" ]]; then
  FILE=$SSH_HOST_RSA_KEY
elif [[ "$ALGORITHM" == "ECDSA" ]]; then
  FILE=$SSH_HOST_ECDSA_KEY
elif [[ "$ALGORITHM" == "ED25519" ]]; then
  FILE=$SSH_HOST_ED25519_KEY
else
  errorMsg "Unknow ssh host key." "1"
fi

SOURCE="${NX_ROOT}/var/run/sshhostcert"

if [ ! -f "${SOURCE}" ]; then
  errorMsg "File ${SOURCE} doesn't exist." "1"
fi

MODE="600"

if [[ "$TYPE" == "public" ]]; then
  MODE="644"
  FILE="${FILE}.pub"
fi

if [ ! -f "$FILE" ]; then
  FILE_EMPTY="$FILE.empty"
  ${COMMAND_TOUCH} "$FILE_EMPTY"

  if [ $? -eq 0 ]; then
    ${COMMAND_ECHO} "File $FILE_EMPTY created."
  else
    errorMsg "Failed to create the empty file $FILE_EMPTY." "1"
  fi
else
  FILE_BACKUP="$FILE.backup"

  if [ -f "$FILE_BACKUP" ]; then
    TIMESTAMP=`$COMMAND_DATE +%s%3N`
    FILE_BACKUP="$FILE_BACKUP-$TIMESTAMP"
  fi

  ${COMMAND_CP} "$FILE" "$FILE_BACKUP"

  if [ $? -eq 0 ]; then
    ${COMMAND_ECHO} "Backup $FILE_BACKUP created."
  else
    errorMsg "Failed to create the backup file $FILE_BACKUP." "1"
  fi
fi

${COMMAND_MV} "$SOURCE" "$FILE"

if [ $? -eq 0 ]; then
  ${COMMAND_ECHO} "File $FILE created with the provided content."
else
  errorMsg "Failed to create the file $FILE." "1"
fi

${COMMAND_CHMOD} "$MODE" "$FILE"

if [ $? -eq 0 ]; then
  ${COMMAND_ECHO} "File $FILE permissions changed successfully."
else
  errorMsg "Failed to change the file permissions $FILE." "1"
fi

exit 0