/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.threed.AbstractConvexPolygon3D;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;

final class SimpleTriangle3D
extends AbstractConvexPolygon3D
implements Triangle3D {
    private final Vector3D p1;
    private final Vector3D p2;
    private final Vector3D p3;

    SimpleTriangle3D(Plane plane, Vector3D p1, Vector3D p2, Vector3D p3) {
        super(plane);
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    @Override
    public Vector3D getPoint1() {
        return this.p1;
    }

    @Override
    public Vector3D getPoint2() {
        return this.p2;
    }

    @Override
    public Vector3D getPoint3() {
        return this.p3;
    }

    @Override
    public List<Vector3D> getVertices() {
        return Arrays.asList(this.p1, this.p2, this.p3);
    }

    @Override
    public double getSize() {
        Vector3D v1 = this.p1.vectorTo(this.p2);
        Vector3D v2 = this.p1.vectorTo(this.p3);
        return 0.5 * v1.cross(v2).norm();
    }

    @Override
    public Vector3D getCentroid() {
        return Vector3D.centroid(this.p1, this.p2, this.p3);
    }

    @Override
    public SimpleTriangle3D reverse() {
        Plane rPlane = this.getPlane().reverse();
        return new SimpleTriangle3D(rPlane, this.p1, this.p3, this.p2);
    }

    @Override
    public SimpleTriangle3D transform(Transform<Vector3D> transform) {
        Plane tPlane = this.getPlane().transform(transform);
        Vector3D t1 = (Vector3D)transform.apply((Object)this.p1);
        Vector3D t2 = (Vector3D)transform.apply((Object)this.p2);
        Vector3D t3 = (Vector3D)transform.apply((Object)this.p3);
        return new SimpleTriangle3D(tPlane, t1, t2, t3);
    }
}

