/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.integrate.lsoda.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class Data {
    private String filePath;
    private BufferedWriter bufferedWriter;
    private int n;

    public Data(String filepath, String fileName, int neq) throws IOException {
        this.n = neq;
        this.filePath = filepath + "/" + fileName;
        this.bufferedWriter = new BufferedWriter(new FileWriter(this.filePath));
        this.bufferedWriter.write("t,");
        for (int i = 1; i < neq; ++i) {
            this.bufferedWriter.write("y_" + i + ",");
        }
        this.bufferedWriter.write("y_" + neq);
        this.bufferedWriter.flush();
    }

    public void write(double t, double[] y) {
        try {
            this.bufferedWriter.newLine();
            this.bufferedWriter.write(t + ",");
            for (int i = 1; i < this.n; ++i) {
                this.bufferedWriter.write(y[i] + ",");
            }
            this.bufferedWriter.write(Double.toString(y[this.n]));
            this.bufferedWriter.flush();
        }
        catch (IOException e) {
            System.out.println("Error occurred in file writing.");
        }
    }

    public void closeWriter() throws IOException {
        this.bufferedWriter.close();
    }
}

