/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.OffHeapArray;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.NativeMemory;

final class OffHeapZ008
extends OffHeapArray {
    private final long myPointer;

    OffHeapZ008(long count) {
        super(OffHeapArray.Z008, count);
        this.myPointer = NativeMemory.allocateByteArray(this, count);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        this.add(index, Scalar.byteValue(addend));
    }

    @Override
    public byte byteValue(long index) {
        return NativeMemory.getByte(this.myPointer, index);
    }

    @Override
    public double doubleValue(long index) {
        return NativeMemory.getByte(this.myPointer, index);
    }

    @Override
    public void reset() {
        NativeMemory.initialiseByteArray(this.myPointer, this.count());
    }

    @Override
    public void set(long index, byte value) {
        NativeMemory.setByte(this.myPointer, index, value);
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.set(index, Scalar.byteValue(value));
    }

    @Override
    public void set(long index, double value) {
        NativeMemory.setByte(this.myPointer, index, (byte)Math.toIntExact(Math.round(value)));
    }

    @Override
    public void set(long index, float value) {
        NativeMemory.setByte(this.myPointer, index, (byte)Math.round(value));
    }
}

