/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.DenseCapacityStrategy;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.array.StrategyBuildingFactory;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Iterator1D;
import org.ojalgo.structure.Mutate1D;

public final class NumberList<N extends Comparable<N>>
implements List<N>,
RandomAccess,
Access1D<N>,
Access1D.Visitable<N>,
Mutate1D,
Mutate1D.Mixable<N> {
    private long myActualCount;
    private BasicArray<N> myStorage;
    private final DenseCapacityStrategy<N> myStrategy;

    public static <N extends Comparable<N>> Collector<N, NumberList<N>, NumberList<N>> collector(DenseArray.Factory<N> arrayFactory) {
        Supplier<NumberList> tmpSupplier = () -> NumberList.factory(arrayFactory).make();
        BiConsumer<NumberList, Comparable> tmpAccumulator = NumberList::add;
        BinaryOperator tmpCombiner = (part1, part2) -> {
            part1.addAll((Collection)part2);
            return part1;
        };
        Function tmpIdentity = Function.identity();
        return Collector.of(tmpSupplier, tmpAccumulator, tmpCombiner, tmpIdentity, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <N extends Comparable<N>> ListFactory<N> factory(DenseArray.Factory<N> arrayFactory) {
        return new ListFactory<N>(arrayFactory);
    }

    NumberList(BasicArray<N> storage, DenseCapacityStrategy<N> strategy, long actualCount) {
        this.myStrategy = strategy;
        this.myStorage = storage;
        this.myActualCount = actualCount;
    }

    NumberList(DenseCapacityStrategy<N> strategy) {
        this.myStrategy = strategy;
        this.myStorage = strategy.makeInitial();
        this.myActualCount = 0L;
    }

    @Override
    public boolean add(double element) {
        this.ensureCapacity();
        this.myStorage.set(this.myActualCount++, element);
        return true;
    }

    @Override
    public void add(int index, N element) {
        this.ensureCapacity();
        for (long i = this.myActualCount - 1L; i >= (long)index; --i) {
            this.myStorage.set(i + 1L, (Comparable<?>)this.myStorage.get(i));
        }
        this.myStorage.set((long)index, (Comparable<?>)element);
        ++this.myActualCount;
    }

    @Override
    public boolean add(N element) {
        this.ensureCapacity();
        this.myStorage.set(this.myActualCount++, (Comparable<?>)element);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends N> elements) {
        for (Comparable tmpElement : elements) {
            this.add((N)tmpElement);
        }
        return true;
    }

    public boolean addAll(double[] elements) {
        for (double tmpElement : elements) {
            this.add(tmpElement);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends N> elements) {
        int counter = 0;
        for (Comparable value : elements) {
            this.add(index + counter++, (N)value);
        }
        return elements.size() > 0;
    }

    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myStorage.factory().aggregator());
        this.visitRange(first, limit, visitor);
        return (N)((Comparable)visitor.get());
    }

    public long capacity() {
        return this.myStorage.count();
    }

    @Override
    public void clear() {
        this.myActualCount = 0L;
        this.myStorage.reset();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Comparable) {
            return this.indexOf(object) >= 0;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object tmpObject : c) {
            if (this.contains(tmpObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long count() {
        return this.myActualCount;
    }

    @Override
    public double doubleValue(long index) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.myStorage.doubleValue(index);
    }

    @Override
    public N get(int index) {
        if ((long)index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.myStorage.get(index);
    }

    @Override
    public N get(long index) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.myStorage.get(index);
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<N> tmpIterator = this.listIterator();
        if (object == null) {
            while (tmpIterator.hasNext()) {
                if (tmpIterator.next() != null) continue;
                return tmpIterator.previousIndex();
            }
        } else {
            while (tmpIterator.hasNext()) {
                if (!object.equals(tmpIterator.next())) continue;
                return tmpIterator.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.myActualCount == 0L;
    }

    @Override
    public Iterator<N> iterator() {
        return new Iterator1D(this);
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<N> tmpIterator = this.listIterator(this.size());
        if (object == null) {
            while (tmpIterator.hasPrevious()) {
                if (tmpIterator.previous() != null) continue;
                return tmpIterator.nextIndex();
            }
        } else {
            while (tmpIterator.hasPrevious()) {
                if (!object.equals(tmpIterator.previous())) continue;
                return tmpIterator.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public ListIterator<N> listIterator() {
        return new Iterator1D(this);
    }

    @Override
    public ListIterator<N> listIterator(int index) {
        return new Iterator1D(this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mix(long index, BinaryFunction<N> mixer, double addend) {
        ProgrammingError.throwIfNull(mixer);
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        BasicArray<N> basicArray = this.myStorage;
        synchronized (basicArray) {
            double oldValue = this.myStorage.doubleValue(index);
            double newValue = mixer.invoke(oldValue, addend);
            this.myStorage.set(index, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mix(long index, BinaryFunction<N> mixer, N addend) {
        ProgrammingError.throwIfNull(mixer);
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        BasicArray<N> basicArray = this.myStorage;
        synchronized (basicArray) {
            Object oldValue = this.myStorage.get(index);
            N newValue = mixer.invoke(oldValue, addend);
            this.myStorage.set(index, (Comparable<?>)newValue);
            return newValue;
        }
    }

    @Override
    public N remove(int index) {
        Object oldValue = this.myStorage.get(index);
        --this.myActualCount;
        for (long i = (long)index; i < this.myActualCount; ++i) {
            this.myStorage.set(i, (Comparable<?>)this.myStorage.get(i + 1L));
        }
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retVal = false;
        for (Object o : c) {
            retVal &= this.remove(o);
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> onlyKeep) {
        Object[] values;
        boolean retVal = false;
        for (Object v : values = this.toArray()) {
            if (onlyKeep.contains(v)) continue;
            retVal &= this.remove(v);
        }
        return retVal;
    }

    @Override
    public N set(int index, N element) {
        if ((long)index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object previous = this.myStorage.get(index);
        this.myStorage.set((long)index, (Comparable<?>)element);
        return previous;
    }

    @Override
    public void set(long index, Comparable<?> value) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.set(index, value);
    }

    @Override
    public void set(long index, double value) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.set(index, value);
    }

    @Override
    public void set(long index, float value) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.set(index, value);
    }

    @Override
    public int size() {
        return (int)this.myActualCount;
    }

    @Override
    public NumberList<N> subList(int fromIndex, int toIndex) {
        NumberList<Object> retVal = new NumberList<Object>(this.myStrategy);
        if (this.myStorage instanceof ArrayR064) {
            for (int i = 0; i < toIndex; ++i) {
                retVal.add(this.doubleValue(i));
            }
        } else {
            for (int i = 0; i < toIndex; ++i) {
                retVal.add(this.get(i));
            }
        }
        return retVal;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.myStorage.get(i);
        }
        return array;
    }

    public String toString() {
        return Access1D.toString(this);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.visitOne(index, visitor);
    }

    private void ensureCapacity() {
        if (this.myStorage.count() <= this.myActualCount) {
            if (this.myStrategy.isSegmented(this.myActualCount + 1L)) {
                this.myStorage = this.myStorage instanceof SegmentedArray ? ((SegmentedArray)this.myStorage).grow() : this.myStrategy.makeSegmented(this.myStorage);
            } else {
                long tmoNewTotalCount = this.myStrategy.grow(this.myActualCount);
                DenseArray<N> tmpStorage = this.myStrategy.make(tmoNewTotalCount);
                tmpStorage.fillMatching(this.myStorage);
                this.myStorage = tmpStorage;
            }
        }
    }

    public static final class ListFactory<N extends Comparable<N>>
    extends StrategyBuildingFactory<N, NumberList<N>, ListFactory<N>> {
        ListFactory(DenseArray.Factory<N> denseFactory) {
            super(denseFactory);
        }

        @Override
        public NumberList<N> make() {
            return new NumberList(this.getStrategy());
        }
    }
}

