/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Sinks;
import us.hebi.matlab.mat.util.ByteConverter;
import us.hebi.matlab.mat.util.ByteConverters;
import us.hebi.matlab.mat.util.Bytes;
import us.hebi.matlab.mat.util.Preconditions;

public abstract class AbstractSink
implements Sink {
    private OutputStream streamWrapper = new Sinks.SinkOutputStream(this);
    private ByteOrder byteOrder = ByteOrder.nativeOrder();
    private final byte[] bytes;
    private static final ByteConverter byteConverter = ByteConverters.getFastest();

    @Override
    public AbstractSink nativeOrder() {
        return this.order(ByteOrder.nativeOrder());
    }

    @Override
    public AbstractSink order(ByteOrder byteOrder) {
        this.byteOrder = Preconditions.checkNotNull(byteOrder);
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.byteOrder;
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.bytes[0] = value;
        this.writeBytes(this.bytes, 0, 1);
    }

    @Override
    public void writeShort(short value) throws IOException {
        byteConverter.putShort(value, this.order(), this.bytes, 0);
        this.writeBytes(this.bytes, 0, 2);
    }

    @Override
    public void writeInt(int value) throws IOException {
        byteConverter.putInt(value, this.order(), this.bytes, 0);
        this.writeBytes(this.bytes, 0, 4);
    }

    @Override
    public void writeLong(long value) throws IOException {
        byteConverter.putLong(value, this.order(), this.bytes, 0);
        this.writeBytes(this.bytes, 0, 8);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        byteConverter.putFloat(value, this.order(), this.bytes, 0);
        this.writeBytes(this.bytes, 0, 4);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        byteConverter.putDouble(value, this.order(), this.bytes, 0);
        this.writeBytes(this.bytes, 0, 8);
    }

    @Override
    public void writeByteBuffer(ByteBuffer buffer) throws IOException {
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            int length = buffer.remaining();
            this.writeBytes(buffer.array(), offset, length);
            buffer.position(buffer.limit());
        } else {
            while (buffer.hasRemaining()) {
                int length = Math.min(buffer.remaining(), this.bytes.length);
                buffer.get(this.bytes, 0, length);
                this.writeBytes(this.bytes, 0, length);
            }
        }
    }

    @Override
    public void writeInputStream(InputStream input, long length) throws IOException {
        int n;
        for (long i = 0L; i < length; i += (long)n) {
            int maxN = (int)Math.min(length - i, (long)this.bytes.length);
            n = input.read(this.bytes, 0, maxN);
            if (n < 0) {
                throw new EOFException();
            }
            this.writeBytes(this.bytes, 0, n);
        }
    }

    @Override
    public void writeDataInput(DataInput input, long length) throws IOException {
        int n;
        for (long i = 0L; i < length; i += (long)n) {
            n = (int)Math.min(length - i, (long)this.bytes.length);
            input.readFully(this.bytes, 0, n);
            this.writeBytes(this.bytes, 0, n);
        }
    }

    @Override
    public void writeShorts(short[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 2, this.bytes.length);
            int j = 0;
            while (j < n) {
                byteConverter.putShort(buffer[offset + i], this.order(), this.bytes, j);
                j += 2;
                ++i;
            }
            this.writeBytes(this.bytes, 0, n);
        }
    }

    @Override
    public void writeInts(int[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 4, this.bytes.length);
            int j = 0;
            while (j < n) {
                byteConverter.putInt(buffer[offset + i], this.order(), this.bytes, j);
                j += 4;
                ++i;
            }
            this.writeBytes(this.bytes, 0, n);
        }
    }

    @Override
    public void writeLongs(long[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 8, this.bytes.length);
            int j = 0;
            while (j < n) {
                byteConverter.putLong(buffer[offset + i], this.order(), this.bytes, j);
                j += 8;
                ++i;
            }
            this.writeBytes(this.bytes, 0, n);
        }
    }

    @Override
    public void writeFloats(float[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 4, this.bytes.length);
            int j = 0;
            while (j < n) {
                byteConverter.putFloat(buffer[offset + i], this.order(), this.bytes, j);
                j += 4;
                ++i;
            }
            this.writeBytes(this.bytes, 0, n);
        }
    }

    @Override
    public void writeDoubles(double[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 8, this.bytes.length);
            int j = 0;
            while (j < n) {
                byteConverter.putDouble(buffer[offset + i], this.order(), this.bytes, j);
                j += 8;
                ++i;
            }
            this.writeBytes(this.bytes, 0, n);
        }
    }

    @Override
    public Sink writeDeflated(Deflater deflater) {
        DeflaterOutputStream deflateStream = new DeflaterOutputStream(this.streamWrapper, deflater, this.bytes.length);
        int deflateBufferSize = Math.max(1024, this.bytes.length);
        return Sinks.wrapNonSeeking(deflateStream, deflateBufferSize).order(this.order());
    }

    protected AbstractSink(int copyBufferSize) {
        int size = Math.max(Bytes.nextPowerOfTwo(copyBufferSize), 256);
        this.bytes = new byte[size];
    }
}

