/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.util.ArrayList;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.axis.ProjLonLatAxis;
import org.meteoinfo.chart.geo.MapGridLine;
import org.meteoinfo.common.DataConvert;

public class LonLatAxis
extends Axis
implements Cloneable {
    protected boolean drawDegreeSymbol = true;
    protected boolean degreeSpace = false;
    protected boolean longitude = true;

    public LonLatAxis(String label, boolean xAxis) {
        this(label, xAxis, xAxis);
    }

    public LonLatAxis(String label, boolean xAxis, boolean longitude) {
        super(label, xAxis);
        this.longitude = longitude;
    }

    public LonLatAxis(Axis axis) {
        this(axis.getLabel().getText(), axis.isXAxis());
        this.autoTick = axis.autoTick;
        this.drawLabel = axis.drawLabel;
        this.drawTickLabel = axis.drawTickLabel;
        this.drawTickLine = axis.drawTickLine;
        this.insideTick = axis.insideTick;
        this.inverse = axis.inverse;
        this.setLabelColor(axis.getLabelColor());
        this.lineWidth = axis.lineWidth;
        this.lineStyle = axis.lineStyle;
        this.location = axis.location;
        this.setMinMaxValue(axis.minValue, axis.maxValue);
        this.minorTickNum = axis.minorTickNum;
        this.minorTickVisible = axis.minorTickVisible;
        this.tickColor = axis.tickColor;
        this.tickDeltaValue = axis.tickDeltaValue;
        this.tickLabelColor = axis.tickLabelColor;
        this.tickLabelFont = axis.tickLabelFont;
        this.tickLength = axis.tickLength;
        this.tickWidth = axis.tickWidth;
        this.visible = axis.visible;
        this.positionType = axis.positionType;
        this.position = axis.position;
    }

    public static LonLatAxis factory(Axis axis) {
        return new LonLatAxis(axis);
    }

    public static LonLatAxis factory(String label, boolean xAxis) {
        return new LonLatAxis(label, xAxis);
    }

    public static LonLatAxis factory(String label, boolean xAxis, MapGridLine mapGridLine) {
        return new ProjLonLatAxis(label, xAxis, mapGridLine);
    }

    public boolean isDrawDegreeSymbol() {
        return this.drawDegreeSymbol;
    }

    public void setDrawDegreeSymbol(boolean value) {
        this.drawDegreeSymbol = value;
    }

    public boolean isLongitude() {
        return this.longitude;
    }

    public void setLongitude(boolean value) {
        this.longitude = value;
    }

    public boolean isDegreeSpace() {
        return this.degreeSpace;
    }

    public void setDegreeSpace(boolean value) {
        this.degreeSpace = value;
    }

    @Override
    public void updateTickLabels() {
        ArrayList<ChartText> tls = new ArrayList<ChartText>();
        for (double v : this.getTickValues()) {
            double value = v;
            if (value > 180.0) {
                value -= 360.0;
            }
            String lab = String.valueOf(value);
            lab = DataConvert.removeTailingZeros((String)lab);
            if (this.isLongitude()) {
                if (value == -180.0) {
                    lab = "180";
                } else if (value != 0.0 && value != 180.0) {
                    lab = lab.substring(0, 1).equals("-") ? lab.substring(1) + "W" : lab + "E";
                }
            } else if (value != 0.0) {
                lab = lab.substring(0, 1).equals("-") ? lab.substring(1) + "S" : lab + "N";
            }
            if (this.drawDegreeSymbol) {
                lab = lab.endsWith("E") || lab.endsWith("W") || lab.endsWith("N") || lab.endsWith("S") ? (this.degreeSpace ? lab.substring(0, lab.length() - 1) + String.valueOf('\u00ba') + " " + lab.substring(lab.length() - 1) : lab.substring(0, lab.length() - 1) + String.valueOf('\u00ba') + lab.substring(lab.length() - 1)) : lab + String.valueOf('\u00ba');
            }
            tls.add(new ChartText(lab));
        }
        this.setTickLabels(tls);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (LonLatAxis)super.clone();
    }
}

