/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.random;

import java.util.List;
import java.util.Random;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;
import org.apache.commons.statistics.distribution.DiscreteDistribution;
import org.apache.commons.statistics.distribution.PoissonDistribution;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class RandomUtil {
    public static long seed = 1L;
    public static boolean useSeed = false;

    public static double rand() {
        Random r = new Random();
        if (useSeed) {
            r.setSeed(seed);
        }
        return r.nextDouble();
    }

    public static Array rand(int n) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        Random rd = new Random();
        if (useSeed) {
            rd.setSeed(seed);
        }
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, rd.nextDouble());
            ++i;
        }
        return r;
    }

    public static Array rand(List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)DataType.DOUBLE, (int[])ashape);
        Random rd = new Random();
        if (useSeed) {
            rd.setSeed(seed);
        }
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, rd.nextDouble());
            ++i;
        }
        return a;
    }

    public static double randn() {
        Random r = new Random();
        if (useSeed) {
            r.setSeed(seed);
        }
        return r.nextGaussian();
    }

    public static Array randn(int n) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        Random rd = new Random();
        if (useSeed) {
            rd.setSeed(seed);
        }
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, rd.nextGaussian());
            ++i;
        }
        return r;
    }

    public static Array randn(List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)DataType.DOUBLE, (int[])ashape);
        Random rd = new Random();
        if (useSeed) {
            rd.setSeed(seed);
        }
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, rd.nextGaussian());
            ++i;
        }
        return a;
    }

    public static int randint(int bound) {
        Random r = new Random();
        if (useSeed) {
            r.setSeed(seed);
        }
        return r.nextInt(bound);
    }

    public static Array randint(int bound, int n) {
        Array a = Array.factory((DataType)DataType.INT, (int[])new int[]{n});
        Random rd = new Random();
        if (useSeed) {
            rd.setSeed(seed);
        }
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, (double)rd.nextInt(bound));
            ++i;
        }
        return a;
    }

    public static Array randint(int bound, List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)DataType.INT, (int[])ashape);
        Random rd = new Random();
        if (useSeed) {
            rd.setSeed(seed);
        }
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, (double)rd.nextInt(bound));
            ++i;
        }
        return a;
    }

    public static double poisson(double mean) {
        PoissonDistribution distribution = PoissonDistribution.of((double)mean);
        DiscreteDistribution.Sampler sampler = useSeed ? distribution.createSampler((UniformRandomProvider)RandomSource.ISAAC.create((Object)seed, new Object[0])) : distribution.createSampler((UniformRandomProvider)RandomSource.MT.create());
        return sampler.sample();
    }

    public static Array poisson(double mean, int n) {
        Array a = Array.factory((DataType)DataType.INT, (int[])new int[]{n});
        PoissonDistribution distribution = PoissonDistribution.of((double)mean);
        DiscreteDistribution.Sampler sampler = useSeed ? distribution.createSampler((UniformRandomProvider)RandomSource.ISAAC.create((Object)seed, new Object[0])) : distribution.createSampler((UniformRandomProvider)RandomSource.MT.create());
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, (double)sampler.sample());
            ++i;
        }
        return a;
    }

    public static Array poisson(double mean, List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)DataType.INT, (int[])ashape);
        PoissonDistribution distribution = PoissonDistribution.of((double)mean);
        DiscreteDistribution.Sampler sampler = useSeed ? distribution.createSampler((UniformRandomProvider)RandomSource.ISAAC.create((Object)seed, new Object[0])) : distribution.createSampler((UniformRandomProvider)RandomSource.MT.create());
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, (double)sampler.sample());
            ++i;
        }
        return a;
    }
}

