/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.astor;

import org.meteoinfo.math.astor.Sun2000;

public class AstroUtil {
    public static double MJD(int year, int month, int day, double noon) {
        double A = 10000.0 * (double)year + 100.0 * (double)month + 1.0 * (double)day;
        if (month <= 2) {
            month += 12;
            --year;
        }
        double B = A <= 1.58210041E7 ? (double)(-2 + (year + 4716) / 4 - 1179) : (double)(year / 400 - year / 100 + year / 4);
        A = 365.0 * (double)year - 679004.0;
        double mjd = A + B + (double)((int)(30.6001 * (double)(month + 1))) + (double)day + noon / 24.0;
        return mjd;
    }

    public static Object[] CALDAT(double mjd) {
        double c;
        double jd = mjd + 2400000.5;
        double jd0 = (int)(jd + 0.5);
        if (jd0 < 2299161.0) {
            boolean b = false;
            c = jd0 + 1524.0;
        } else {
            int b = (int)((jd0 - 1867216.25) / 36524.25);
            c = jd0 + (double)(b - b / 4) + 1525.0;
        }
        int d = (int)((c - 122.1) / 365.25);
        double e = 365.0 * (double)d + (double)(d / 4);
        int f = (int)((c - e) / 30.6001);
        int day = (int)(c - e + 0.5 - (double)((int)(30.6001 * (double)f)));
        int mon = f - 1 - 12 * (f / 14);
        int yr = d - 4715 - (7 + mon) / 10;
        double hr = 24.0 * (jd + 0.5 - jd0);
        return new Object[]{yr, mon, day, hr};
    }

    public static double LMST(double mjd, double lon) {
        double mjd0 = (int)mjd;
        double ut = (mjd - mjd0) * 24.0;
        double t = (mjd0 - 51544.5) / 36525.0;
        double gmst = 6.697374558 + 1.0027379093 * ut + (8640184.812866 + (-6.106896 - 6.0 * t) * t) * t / 3600.0;
        if ((t = 24.0 * AstroUtil.dfrac(gmst - lon / 15.0 / 24.0)) < 0.0) {
            t += 24.0;
        }
        return t;
    }

    private static double dfrac(double x) {
        double df = x % 1.0;
        return df;
    }

    public static double GMST2UT(double mjd, double gmst) {
        double MJD0 = (int)mjd;
        double T = (mjd - 51544.5) / 36525.0;
        double T0 = (MJD0 - 51544.5) / 36525.0;
        double UT = gmst - 6.697374558 - (8640184.812866 * T0 + (0.093104 - 6.2E-6 * T) * T) / 3600.0;
        if ((UT = 24.0 * (UT / 24.0 % 1.0)) < 0.0) {
            UT += 24.0;
        }
        double r = UT / 1.0027379093;
        return r;
    }

    public static double[] sun2000(double t2000) {
        Sun2000 sun2 = new Sun2000();
        return sun2.run(t2000);
    }

    public static double[] sunEqu(double T) {
        double dt = 1.5818693436763253E-7;
        double[] rr = AstroUtil.sun2000(T - dt);
        double l = rr[0];
        double b = rr[1];
        double rad = rr[2];
        rr = AstroUtil.cart(rad, b, l);
        double x = rr[0];
        double y = rr[1];
        double z = rr[2];
        rr = AstroUtil.eclEqu(T, x, y, z);
        x = rr[0];
        y = rr[1];
        z = rr[2];
        rr = AstroUtil.nutEqu(T, x, y, z);
        x = rr[0];
        y = rr[1];
        z = rr[2];
        rr = AstroUtil.polar(x, y, z);
        rad = rr[0];
        double dec = rr[1];
        double ra = rr[2];
        return new double[]{ra, dec, rad};
    }

    private static double cs(double x) {
        return Math.cos(x * 0.01745329252);
    }

    private static double sn(double x) {
        return Math.sin(x * 0.01745329252);
    }

    private static double[] cart(double r, double theta, double phi) {
        double rcst = r * AstroUtil.cs(theta);
        double x = rcst * AstroUtil.cs(phi);
        double y = rcst * AstroUtil.sn(phi);
        double z = r * AstroUtil.sn(theta);
        return new double[]{x, y, z};
    }

    private static double[] eclEqu(double T, double x, double y, double z) {
        double eps = 23.43929111 - (46.815 + (5.9E-4 - 0.001813 * T) * T) * T / 3600.0;
        double c = AstroUtil.cs(eps);
        double s = AstroUtil.sn(eps);
        double v = c * y - s * z;
        z = s * y + c * z;
        y = v;
        return new double[]{x, y, z};
    }

    private static double[] nutEqu(double T, double x, double y, double z) {
        double arc = 162000.0 / Math.atan(1.0);
        double P2 = 8.0 * Math.atan(1.0);
        double LS = P2 * AstroUtil.dfrac(0.993133 + 99.997306 * T);
        double D = P2 * AstroUtil.dfrac(0.827362 + 1236.853087 * T);
        double F = P2 * AstroUtil.dfrac(0.259089 + 1342.227826 * T);
        double N = P2 * AstroUtil.dfrac(0.347346 - 5.372447 * T);
        double eps = 0.4090928 - 2.2696E-4 * T;
        double dpsi = -17.2 * Math.sin(N) - 1.319 * Math.sin(2.0 * (F - D + N)) - 0.227 * Math.sin(2.0 * (F + N)) + 0.206 * Math.sin(2.0 * N) + 0.143 * Math.sin(LS);
        double deps = (9.203 * Math.cos(N) + 0.574 * Math.cos(2.0 * (F - D + N)) + 0.098 * Math.cos(2.0 * (F + N)) - 0.09 * Math.cos(2.0 * N)) / arc;
        double c = (dpsi /= arc) * Math.cos(eps);
        double s = dpsi * Math.sin(eps);
        double dx = -(c * y + s * z);
        double dy = c * x - deps * z;
        double dz = s * x + deps * y;
        return new double[]{x += dx, y += dy, z += dz};
    }

    private static double[] polar(double x, double y, double z) {
        double r2d = 57.29577951;
        double rho = Math.pow(x, 2.0) + Math.pow(y, 2.0);
        double r = Math.sqrt(rho + Math.pow(z, 2.0));
        double phi = Math.atan2(y, x) * r2d;
        if (phi < 0.0) {
            phi += 360.0;
        }
        rho = Math.sqrt(rho);
        double theta = Math.atan2(z, rho) * r2d;
        return new double[]{r, theta, phi};
    }

    public static double TOMSozone(int month, double latitude) {
        double[] latcntr = new double[]{-87.5, -82.5, -77.5, -72.5, -67.5, -62.5, -57.5, -52.5, -47.5, -42.5, -37.5, -32.5, -27.5, -22.5, -17.5, -12.5, -7.5, -2.5, 2.5, 7.5, 12.5, 17.5, 22.5, 27.5, 32.5, 37.5, 42.5, 47.5, 52.5, 57.5, 62.5, 67.5, 72.5, 77.5, 82.5, 87.5};
        double[][] TOMS = new double[][]{{291.0, 278.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 153.3, 218.4, 289.9}, {294.3, 284.0, 288.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 163.9, 228.0, 294.0}, {298.4, 288.0, 288.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 183.3, 244.4, 298.7}, {304.7, 295.5, 293.3, 0.0, 0.0, 0.0, 0.0, 0.0, 202.2, 216.7, 272.2, 306.5}, {313.0, 305.4, 298.4, 295.6, 0.0, 0.0, 0.0, 258.0, 238.9, 263.8, 305.7, 316.0}, {319.8, 309.8, 300.6, 299.9, 302.1, 0.0, 0.0, 292.0, 289.6, 313.7, 332.7, 322.9}, {320.6, 308.6, 299.2, 300.8, 306.5, 315.6, 319.5, 323.2, 332.5, 347.5, 345.5, 326.0}, {314.6, 302.5, 293.2, 297.0, 306.5, 316.0, 322.4, 339.9, 351.2, 358.5, 346.3, 323.4}, {304.2, 293.7, 285.8, 289.3, 302.0, 313.1, 322.7, 343.1, 354.2, 355.4, 339.4, 315.4}, {293.2, 285.6, 280.9, 281.3, 293.5, 306.9, 320.0, 338.4, 348.1, 345.7, 328.5, 305.3}, {284.6, 279.2, 277.0, 275.0, 283.4, 296.2, 310.5, 325.7, 335.3, 333.1, 316.9, 296.5}, {276.8, 272.9, 272.3, 270.7, 273.5, 283.2, 295.6, 307.3, 317.3, 318.0, 304.9, 289.1}, {270.6, 267.0, 266.4, 265.8, 265.6, 270.4, 279.5, 288.5, 299.4, 302.5, 293.8, 281.7}, {266.5, 263.3, 262.1, 260.9, 259.6, 260.9, 267.5, 274.9, 285.5, 290.0, 284.2, 274.7}, {264.1, 262.0, 261.1, 258.3, 255.8, 255.0, 259.8, 265.7, 274.2, 280.0, 275.7, 269.3}, {262.1, 261.5, 261.8, 259.8, 256.0, 253.6, 257.1, 260.7, 268.0, 272.6, 269.9, 265.5}, {259.4, 260.1, 262.5, 262.4, 259.5, 257.6, 260.2, 262.0, 268.0, 269.9, 265.9, 262.0}, {256.0, 258.0, 262.5, 264.6, 263.2, 263.5, 266.7, 267.4, 271.2, 269.3, 262.9, 258.6}, {252.0, 254.7, 260.9, 265.2, 265.9, 268.0, 271.9, 272.3, 273.4, 268.4, 260.1, 255.1}, {246.4, 249.4, 257.1, 264.9, 269.6, 273.0, 277.3, 277.7, 276.2, 268.9, 258.5, 250.8}, {243.2, 246.3, 256.3, 266.8, 273.8, 277.0, 280.5, 280.3, 277.2, 268.5, 256.3, 247.2}, {244.5, 248.9, 260.6, 273.1, 280.9, 282.3, 283.4, 280.8, 276.3, 267.6, 255.5, 246.9}, {251.0, 257.8, 270.3, 284.0, 291.8, 289.7, 288.3, 283.4, 277.2, 268.9, 258.3, 251.0}, {263.8, 272.4, 285.2, 297.8, 304.2, 297.2, 293.2, 287.5, 280.4, 272.5, 263.2, 260.0}, {284.8, 295.7, 306.9, 315.3, 318.0, 306.4, 298.6, 292.2, 284.5, 276.6, 270.5, 275.1}, {313.0, 325.3, 333.1, 337.9, 335.1, 320.5, 306.8, 297.5, 289.6, 282.3, 281.6, 295.9}, {338.9, 351.6, 358.1, 359.5, 352.5, 338.5, 319.3, 305.3, 297.0, 290.4, 295.4, 316.3}, {358.4, 374.1, 380.7, 376.5, 365.9, 353.0, 331.9, 314.2, 304.9, 298.8, 307.8, 332.0}, {370.7, 390.1, 397.7, 388.7, 375.4, 360.7, 340.2, 320.6, 309.8, 305.1, 316.2, 342.1}, {374.1, 399.1, 408.5, 397.4, 383.1, 361.5, 340.6, 322.2, 309.8, 307.8, 319.4, 342.6}, {0.0, 401.4, 414.9, 405.4, 389.0, 356.8, 334.2, 318.0, 305.4, 306.4, 318.2, 0.0}, {0.0, 422.2, 417.4, 413.1, 395.4, 354.6, 327.1, 310.9, 300.0, 301.7, 0.0, 0.0}, {0.0, 0.0, 411.4, 416.2, 401.7, 358.9, 325.3, 304.3, 294.2, 297.9, 0.0, 0.0}, {0.0, 0.0, 404.5, 415.9, 403.0, 363.0, 326.2, 299.8, 287.2, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 415.5, 402.7, 364.9, 328.0, 295.9, 284.2, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 411.1, 399.2, 361.7, 327.2, 291.2, 0.0, 0.0, 0.0, 0.0}};
        double ozone = 0.0;
        if (Math.abs(latitude) < 90.0 && month >= 1 && month <= 12) {
            int lindex = (int)((latitude + 90.0) / 5.0);
            ozone = TOMS[lindex][month - 1];
        }
        return ozone;
    }
}

