fn = os.path.join(migl.get_sample_folder(), 'GrADS', 'model.ctl')
f = addfile(fn)
u = f['U'][:,:,'40','100']
v = f['V'][:,:,'40','100']
u = u.T
v = v.T
pres = u.dimvalue(0)
heights = meteo.pressure_to_height_std(pres)
tt = u.dimvalue(1)
x,y = meshgrid(tt, heights)
speed = sqrt(u*u+v*v)
layer = barbs(x, y, u, v, speed, 10, size=8)
xaxis(axistype='time')
xlim(tt[0] - 20, tt[-1] + 20)
ylim(0, 18000)
yticks(heights, [str(p) for p in pres])
title('Wind field')
colorbar(layer)