fn = os.path.join(migl.get_sample_folder(), 'GrADS', 'model.ctl')
f = addfile(fn)
psv = f['PS']
ps = psv[0,'10:60','60:140']

axesm()
geoshow('country', edgecolor=(0,0,255))
layer = contourf(ps, 20)
cl = contour(ps, 20, colors='gray', size=1.2, linestyle='--')
clabel(cl, dynamic=False, drawshadow=True, color='b', fontsize=12)
title('Pressure')
yticks(arange(20, 61, 20))
grid()
vertical = False
if vertical:
    colorbar(layer, extendrect=False, shrink=0.8, aspect=30, label='hPa',
        ticks=arange(500, 1001, 500), ticklabels=['low','high'], tickin=False,
        tickrotation=20)
else:
    colorbar(layer, orientation='horizontal', extendrect=False, shrink=0.8,
        aspect=30, label='hPa', ticks=arange(500, 1001, 100), tickin=False,
        tickrotation=90)
