/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.event.DockFrontendListener;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public abstract class FrontendSettingsList
extends BaseMenuPiece {
    private DockFrontend frontend;
    private Listener listener = new Listener();
    private Map<String, JRadioButtonMenuItem> items = new HashMap<String, JRadioButtonMenuItem>();
    private Collator order = Collator.getInstance();

    public FrontendSettingsList(DockFrontend frontend) {
        this.setFrontend(frontend);
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public void setFrontend(DockFrontend frontend) {
        if (this.frontend != frontend) {
            if (this.isBound()) {
                this.uninstall();
            }
            this.frontend = frontend;
            if (this.isBound()) {
                this.install();
            }
        }
    }

    @Override
    public void bind() {
        if (!this.isBound()) {
            super.bind();
            this.install();
        }
    }

    @Override
    public void unbind() {
        if (this.isBound()) {
            super.unbind();
            this.uninstall();
        }
    }

    private void install() {
        if (this.frontend != null) {
            this.frontend.addFrontendListener((DockFrontendListener)this.listener);
            for (String name : this.frontend.getSettings()) {
                this.add(name);
            }
        }
    }

    private void uninstall() {
        if (this.frontend != null) {
            int count = this.getItemCount();
            while (count > 0) {
                this.remove(--count);
            }
            this.items.clear();
            this.frontend.removeFrontendListener((DockFrontendListener)this.listener);
        }
    }

    protected abstract void action(String var1);

    private void add(final String name) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrontendSettingsList.this.action(name);
                FrontendSettingsList.this.updateSelection();
            }
        });
        this.insert(this.preferredIndex(name), item);
        this.items.put(name, item);
        this.updateSelection();
    }

    protected int preferredIndex(String name) {
        int index = 0;
        for (String item : this.items.keySet()) {
            if (this.order.compare(item, name) >= 0) continue;
            ++index;
        }
        return index;
    }

    private void remove(String name) {
        JMenuItem item = this.items.remove(name);
        if (item != null) {
            this.remove(item);
            this.updateSelection();
        }
    }

    public void updateSelection() {
        String name = this.frontend.getCurrentSetting();
        for (Map.Entry<String, JRadioButtonMenuItem> entry : this.items.entrySet()) {
            entry.getValue().setSelected(entry.getKey().equals(name));
        }
    }

    private class Listener
    extends DockFrontendAdapter {
        private Listener() {
        }

        public void deleted(DockFrontend frontend, String name) {
            FrontendSettingsList.this.remove(name);
        }

        public void saved(DockFrontend frontend, String name) {
            if (!FrontendSettingsList.this.items.containsKey(name)) {
                FrontendSettingsList.this.add(name);
            } else {
                FrontendSettingsList.this.updateSelection();
            }
        }

        public void read(DockFrontend frontend, String name) {
            if (!FrontendSettingsList.this.items.containsKey(name)) {
                FrontendSettingsList.this.add(name);
            } else {
                FrontendSettingsList.this.updateSelection();
            }
        }

        public void loaded(DockFrontend frontend, String name) {
            FrontendSettingsList.this.updateSelection();
        }
    }
}

