/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.util;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.meteoinfo.chart.Chart;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.plot.ChartPlotMethod;
import org.meteoinfo.chart.plot.XY1DPlot;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.XYArrayDataset;
import org.meteoinfo.data.XYDataset;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.PointBreak;

public class PlotUtil {
    public static XYDataset getXYDataset(StationData xdata, StationData ydata, String seriesKey) {
        ArrayList<Double> xvs = new ArrayList<Double>();
        ArrayList<Double> yvs = new ArrayList<Double>();
        int n = xdata.getStNum();
        for (int i = 0; i < n; ++i) {
            double y;
            double x = xdata.data[i][2];
            if (MIMath.doubleEquals((double)x, (double)xdata.missingValue) || MIMath.doubleEquals((double)(y = ydata.data[i][2]), (double)ydata.missingValue)) continue;
            xvs.add(x);
            yvs.add(y);
        }
        return new XYArrayDataset(xvs, yvs, seriesKey);
    }

    public static Chart createScatterPlot(String title, String xAxisLabel, String yAxisLabel, XYDataset dataset) {
        XY1DPlot plot = new XY1DPlot(dataset);
        plot.setTitle(title);
        plot.setChartPlotMethod(ChartPlotMethod.POINT);
        PointBreak pb = new PointBreak();
        plot.setLegendBreak(0, (ColorBreak)pb);
        plot.getXAxis().setLabel(xAxisLabel);
        plot.getYAxis().setLabel(yAxisLabel);
        Chart chart = new Chart(plot, null);
        return chart;
    }

    public static void exportToPicture(String fileName, Chart chart, int width, int height) throws FileNotFoundException, InterruptedException {
        ChartPanel cp = new ChartPanel(chart);
        cp.setSize(width, height);
        cp.paintGraphics();
        cp.saveImage(fileName);
    }
}

