/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.meteoinfo.chart.Margin;
import org.meteoinfo.chart.plot.AxesUnits;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.common.Extent;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.geometry.graphic.Artist;

public abstract class Plot
extends Artist {
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(0.5f, 1, 1);
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final float DEFAULT_FOREGROUND_ALPHA = 1.0f;
    public static final float DEFAULT_BACKGROUND_ALPHA = 1.0f;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final int MINIMUM_WIDTH_TO_DRAW = 10;
    public static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    public static final Shape DEFAULT_LEGEND_ITEM_BOX = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
    public static final Shape DEFAULT_LEGEND_ITEM_CIRCLE = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    protected Rectangle2D position = new Rectangle2D.Double(0.13, 0.11, 0.775, 0.815);
    protected Rectangle2D outerPosition = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    protected Rectangle2D outerPositionArea;
    private Margin tightInset = new Margin();
    public boolean isSubPlot = false;
    public int columnIndex = 0;
    public int rowIndex = 0;
    private boolean outerPosActive = true;
    private boolean sameShrink = false;
    protected AxesUnits units = AxesUnits.NORMALIZED;
    protected boolean symbolAntiAlias = true;
    protected Rectangle2D positionArea = new Rectangle2D.Double();
    private Rectangle2D graphArea = new Rectangle2D.Double();
    private double positionAreaZoom = 1.0;

    public AxesUnits getUnits() {
        return this.units;
    }

    public void setUnits(AxesUnits value) {
        this.units = value;
    }

    public void setUnits(String value) {
        this.units = AxesUnits.valueOf(value.toUpperCase());
    }

    public boolean isOuterPosActive() {
        return this.outerPosActive;
    }

    public void setOuterPosActive(boolean value) {
        this.outerPosActive = value;
    }

    public boolean isSameShrink() {
        return this.sameShrink;
    }

    public void setSameShrink(boolean value) {
        this.sameShrink = value;
    }

    public Rectangle2D getPosition() {
        return this.position;
    }

    public void setPosition(Rectangle2D value) {
        this.position = value;
    }

    public void setPosition(double xmin, double ymin, double width, double height) {
        this.position = new Rectangle2D.Double(xmin, ymin, width, height);
    }

    public void setPosition(List<Number> pos) {
        this.position = new Rectangle2D.Double(pos.get(0).doubleValue(), pos.get(1).doubleValue(), pos.get(2).doubleValue(), pos.get(3).doubleValue());
    }

    public void updatePosition(Rectangle2D figureArea, Rectangle2D outerArea) {
        double x = outerArea.getX() / figureArea.getWidth();
        double y = 1.0 - (outerArea.getY() - figureArea.getY() + outerArea.getHeight()) / figureArea.getHeight();
        double w = outerArea.getWidth() / figureArea.getWidth();
        double h = outerArea.getHeight() / figureArea.getHeight();
        this.setPosition(x, y, w, h);
    }

    public void updatePosition(Rectangle2D figureArea) {
        double x = this.positionArea.getX() / figureArea.getWidth();
        double y = 1.0 - (this.positionArea.getY() + this.positionArea.getHeight()) / figureArea.getHeight();
        double w = this.positionArea.getWidth() / figureArea.getWidth();
        double h = this.positionArea.getHeight() / figureArea.getHeight();
        this.setPosition(x, y, w, h);
    }

    public Margin getTightInset() {
        return this.tightInset;
    }

    public void setTightInset(Margin value) {
        this.tightInset = value;
    }

    public Rectangle2D getOuterPosition() {
        return this.outerPosition;
    }

    public void setOuterPosition(Rectangle2D value) {
        this.outerPosition = value;
    }

    public void setOuterPosition(double xmin, double ymin, double width, double height) {
        this.outerPosition = new Rectangle2D.Double(xmin, ymin, width, height);
    }

    public void setOuterPosition(List<Number> pos) {
        this.position = new Rectangle2D.Double(pos.get(0).doubleValue(), pos.get(1).doubleValue(), pos.get(2).doubleValue(), pos.get(3).doubleValue());
    }

    public Rectangle2D getOuterPositionArea() {
        return this.outerPositionArea;
    }

    public abstract Rectangle2D getOuterPositionArea(Rectangle2D var1);

    public void setOuterPositionArea(Rectangle2D value) {
        this.outerPositionArea = value;
    }

    public abstract Dataset getDataset();

    public abstract void setDataset(Dataset var1);

    public abstract PlotType getPlotType();

    public boolean isSymbolAntiAlias() {
        return this.symbolAntiAlias;
    }

    public void setSymbolAntiAlias(boolean value) {
        this.symbolAntiAlias = value;
    }

    public abstract Extent getExtent();

    public abstract void setDrawExtent(Extent var1);

    public abstract void draw(Graphics2D var1, Rectangle2D var2);

    public Rectangle2D getPositionArea() {
        return this.positionArea;
    }

    public Rectangle2D getPositionArea(double zoom) {
        double w = this.positionArea.getWidth() * zoom;
        double h = this.positionArea.getHeight() * zoom;
        double xshift = (this.positionArea.getWidth() - w) / 2.0;
        double yshift = (this.positionArea.getHeight() - h) / 2.0;
        double x = this.positionArea.getX() + xshift;
        double y = this.positionArea.getY() + yshift;
        return new Rectangle2D.Double(x, y, w, h);
    }

    public void setPositionArea(Rectangle2D value) {
        this.positionArea = value;
    }

    public Rectangle2D getGraphArea() {
        return this.graphArea;
    }

    public void setGraphArea(Rectangle2D value) {
        this.graphArea = value;
    }

    public Rectangle2D getPositionArea(Rectangle2D area) {
        if (this.units == AxesUnits.NORMALIZED) {
            double x = area.getWidth() * this.getPosition().getX() + area.getX();
            double y = area.getHeight() * (1.0 - this.getPosition().getHeight() - this.getPosition().getY()) + area.getY();
            double w = area.getWidth() * this.getPosition().getWidth();
            double h = area.getHeight() * this.getPosition().getHeight();
            return new Rectangle2D.Double(x, y, w, h);
        }
        double x = this.position.getX() + area.getX();
        double y = area.getHeight() - this.position.getY() - this.position.getHeight();
        double w = this.position.getWidth();
        double h = this.position.getHeight();
        return new Rectangle2D.Double(x, y, w, h);
    }

    public abstract Margin getTightInset(Graphics2D var1, Rectangle2D var2);

    public double getPositionAreaZoom() {
        return this.positionAreaZoom;
    }

    public void setPositionAreaZoom(double value) {
        this.positionAreaZoom = value;
    }

    public Margin getPlotShrink() {
        Margin shrink = new Margin();
        if (this.tightInset.getLeft() + this.outerPositionArea.getX() > this.positionArea.getX()) {
            shrink.setLeft(this.tightInset.getLeft() + this.outerPositionArea.getX() - this.positionArea.getX());
        }
        if (this.tightInset.getRight() + this.positionArea.getX() + this.positionArea.getWidth() > this.outerPositionArea.getX() + this.outerPositionArea.getWidth()) {
            shrink.setRight(this.tightInset.getRight() + this.positionArea.getX() + this.positionArea.getWidth() - (this.outerPositionArea.getX() + this.outerPositionArea.getWidth()));
        }
        if (this.tightInset.getTop() + this.outerPositionArea.getY() > this.positionArea.getY()) {
            shrink.setTop(this.tightInset.getTop() + this.outerPositionArea.getY() - this.positionArea.getY());
        }
        if (this.tightInset.getBottom() + this.positionArea.getY() + this.positionArea.getHeight() > this.outerPositionArea.getY() + this.outerPositionArea.getHeight()) {
            shrink.setBottom(this.tightInset.getBottom() + this.positionArea.getY() + this.positionArea.getHeight() - (this.outerPositionArea.getY() + this.outerPositionArea.getHeight()));
        }
        return shrink;
    }

    public void setPlotShrink(Margin shrink) {
        if (this.positionArea == null) {
            return;
        }
        double x = this.positionArea.getX() + shrink.getLeft();
        double y = this.positionArea.getY() + shrink.getTop();
        double w = this.positionArea.getWidth() - (shrink.getLeft() + shrink.getRight());
        double h = this.positionArea.getHeight() - (shrink.getTop() + shrink.getBottom());
        this.positionArea = new Rectangle2D.Double(x, y, w, h);
    }

    public double updatePositionAreaZoom() {
        Rectangle2D tightInsetArea = this.tightInset.getArea(this.positionArea);
        double left = tightInsetArea.getX() - this.outerPositionArea.getX();
        double right = this.outerPositionArea.getX() + this.outerPositionArea.getWidth() - (tightInsetArea.getX() + tightInsetArea.getWidth());
        double top = tightInsetArea.getY() - this.outerPositionArea.getY();
        double bottom = this.outerPositionArea.getY() + this.outerPositionArea.getHeight() - (tightInsetArea.getY() + tightInsetArea.getHeight());
        double minh = Math.min(left, right);
        double minv = Math.min(top, bottom);
        double min = Math.min(minh, minv);
        double zoom = 1.0;
        double factor = 2.0;
        if (min < 0.0) {
            double zoomh = 1.0;
            if (minh < 0.0) {
                zoomh = (this.positionArea.getWidth() - Math.abs(minh) * factor) / this.positionArea.getWidth();
            }
            double zoomv = 1.0;
            if (minv < 0.0) {
                zoomv = (this.positionArea.getHeight() - Math.abs(minv) * factor) / this.positionArea.getHeight();
            }
            if ((zoom = Math.min(zoomh, zoomv)) < 0.0) {
                zoom = 0.2;
            }
        }
        return zoom;
    }

    public void updatePositionArea() {
        double w = this.outerPositionArea.getWidth() - this.tightInset.getLeft() - this.tightInset.getRight();
        double h = this.outerPositionArea.getHeight() - this.tightInset.getTop() - this.tightInset.getBottom();
        double x = this.outerPositionArea.getX() + this.tightInset.getLeft();
        double y = this.outerPositionArea.getY() + this.tightInset.getTop();
        this.positionArea = new Rectangle2D.Double(x, y, w, h);
    }
}

