/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.awt.Color;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LabelBreak;
import org.meteoinfo.geometry.legend.LegendManage;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.table.AttributeTable;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;
import org.meteoinfo.table.Field;

public class GeoGraphicCollection
extends GraphicCollection {
    protected AttributeTable attributeTable = new AttributeTable();
    protected ProjectionInfo projInfo = ProjectionInfo.LONG_LAT;

    public static GeoGraphicCollection factory(GraphicCollection graphics) {
        GeoGraphicCollection geoGraphics = new GeoGraphicCollection();
        geoGraphics.graphics = graphics.getGraphics();
        geoGraphics.extent = graphics.getExtent();
        geoGraphics.setSingleLegend(graphics.isSingleLegend());
        geoGraphics.setLabelSet(graphics.getLabelSet());
        geoGraphics.setLabelPoints(graphics.getLabelPoints());
        geoGraphics.setLegendScheme(graphics.getLegendScheme());
        geoGraphics.setLegendBreak(graphics.getLegendBreak());
        geoGraphics.setAntiAlias(graphics.isAntiAlias());
        AttributeTable attrTable = new AttributeTable();
        ShapeTypes shapeType = graphics.getShapeType();
        switch (shapeType) {
            case POLYGON: 
            case POLYGON_Z: {
                attrTable.addField(new Field("data_Low", DataType.DOUBLE));
                attrTable.addField(new Field("data_High", DataType.DOUBLE));
                break;
            }
            default: {
                attrTable.addField(new Field("data", DataType.DOUBLE));
            }
        }
        DataTable dataTable = attrTable.getTable();
        for (Graphic graphic : geoGraphics.graphics) {
            try {
                DataRow dataRow = dataTable.addRow();
                switch (shapeType) {
                    case POLYGON: 
                    case POLYGON_Z: {
                        dataRow.setValue("data_Low", (Object)((PolygonShape)graphic.getShape()).lowValue);
                        dataRow.setValue("data_High", (Object)((PolygonShape)graphic.getShape()).highValue);
                        break;
                    }
                    default: {
                        dataRow.setValue("data", (Object)graphic.getShape().getValue());
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        geoGraphics.setAttributeTable(attrTable);
        return geoGraphics;
    }

    public AttributeTable getAttributeTable() {
        return this.attributeTable;
    }

    public void setAttributeTable(AttributeTable value) {
        this.attributeTable = value;
    }

    public ProjectionInfo getProjInfo() {
        return this.projInfo;
    }

    public void setProjInfo(ProjectionInfo value) {
        this.projInfo = value;
    }

    public Object getCellValue(String fieldName, int shapeIndex) {
        return this.attributeTable.getTable().getValue(shapeIndex, fieldName);
    }

    public double getMinValue(String fieldName) {
        if (((Field)this.attributeTable.getTable().getColumns().get(fieldName)).isNumeric()) {
            double min = 0.0;
            int dNum = 0;
            for (int i = 0; i < this.getNumGraphics(); ++i) {
                double aValue = Double.parseDouble(this.getCellValue(fieldName, i).toString());
                if (Math.abs(aValue / this.getLegendScheme().getUndefValue() - 1.0) < 0.01) continue;
                if (dNum == 0) {
                    min = aValue;
                } else if (min > aValue) {
                    min = aValue;
                }
                ++dNum;
            }
            return min;
        }
        return 0.0;
    }

    protected void addLabelsByColor() {
        int shapeIdx = -1;
        String dFormat = "%1$.1f";
        boolean isData = false;
        if (((Field)this.attributeTable.getTable().getColumns().get(this.labelSet.getFieldName())).isNumeric()) {
            if (this.labelSet.isAutoDecimal()) {
                double min = this.getMinValue(this.labelSet.getFieldName());
                this.labelSet.setDecimalDigits(MIMath.getDecimalNum((double)min));
            }
            dFormat = "%1$." + String.valueOf(this.labelSet.getDecimalDigits()) + "f";
            isData = true;
        }
        for (Graphic graphic : this.graphics) {
            Shape shape = graphic.getShape();
            ++shapeIdx;
            ColorBreak aCB = graphic.getLegend();
            if (!aCB.isDrawShape()) continue;
            PointShape aPS = new PointShape();
            switch (this.getShapeType()) {
                case POINT: 
                case POINT_M: 
                case POINT_Z: {
                    aPS.setPoint((PointD)((PointShape)shape).getPoint().clone());
                    break;
                }
                case POLYLINE: 
                case POLYLINE_M: 
                case POLYLINE_Z: {
                    int pIdx = ((PolylineShape)shape).getPoints().size() / 2;
                    aPS.setPoint((PointD)((PointD)((PolylineShape)shape).getPoints().get(pIdx - 1)).clone());
                    break;
                }
                case POLYGON: 
                case POLYGON_Z: 
                case POLYGON_M: {
                    Extent aExtent = shape.getExtent();
                    PointD aPoint = new PointD();
                    aPoint.X = (aExtent.minX + aExtent.maxX) / 2.0;
                    aPoint.Y = (aExtent.minY + aExtent.maxY) / 2.0;
                    aPS.setPoint(aPoint);
                }
            }
            LabelBreak aLP = new LabelBreak();
            if (isData) {
                if (this.labelSet.isAutoDecimal()) {
                    aLP.setText(DataConvert.removeTailingZeros((String)this.getCellValue(this.labelSet.getFieldName(), shapeIdx).toString()));
                } else {
                    aLP.setText(String.format(dFormat, Double.parseDouble(this.getCellValue(this.labelSet.getFieldName(), shapeIdx).toString())));
                }
            } else {
                aLP.setText(this.getCellValue(this.labelSet.getFieldName(), shapeIdx).toString());
            }
            if (this.labelSet.isColorByLegend()) {
                aLP.setColor(aCB.getColor());
            } else {
                aLP.setColor(this.labelSet.getLabelColor());
            }
            aLP.setFont(this.labelSet.getLabelFont());
            aLP.setAlignType(this.labelSet.getLabelAlignType());
            aLP.setYShift((float)this.labelSet.getYOffset());
            aLP.setXShift((float)this.labelSet.getXOffset());
            Graphic aGraphic = new Graphic((Shape)aPS, (ColorBreak)aLP);
            this.addLabel(aGraphic);
        }
    }

    public LegendScheme createLegendScheme(LegendType aLT, String fieldName) {
        ShapeTypes aST = this.getShapeType();
        LegendScheme aLS = new LegendScheme(this.getShapeType());
        double min = aLS.getMinValue();
        double max = aLS.getMaxValue();
        switch (aLT) {
            case SINGLE_SYMBOL: {
                Color aColor = Color.black;
                float size = 1.0f;
                switch (aST) {
                    case POINT: 
                    case POINT_M: 
                    case POINT_Z: {
                        aColor = Color.black;
                        size = 5.0f;
                        break;
                    }
                    case POLYLINE: 
                    case POLYLINE_M: 
                    case POLYLINE_Z: {
                        aColor = Color.black;
                        break;
                    }
                    case POLYGON: 
                    case POLYGON_Z: 
                    case POLYGON_M: 
                    case IMAGE: {
                        aColor = new Color(255, 251, 195);
                    }
                }
                aLS = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)aST, (Color)aColor, (float)size);
                break;
            }
            case UNIQUE_VALUE: {
                ArrayList<String> valueList = new ArrayList<String>();
                boolean isDateField = false;
                DataType colType = this.getAttributeTable().getTable().getColumns().get(fieldName).getDataType();
                if (colType == DataType.DATE) {
                    isDateField = true;
                }
                ArrayList<String> captions = new ArrayList<String>();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy/M/d");
                for (int i = 0; i < this.getAttributeTable().getTable().getRows().size(); ++i) {
                    Object value = ((DataRow)this.getAttributeTable().getTable().getRows().get(i)).getValue(fieldName);
                    if (valueList.contains(value.toString())) continue;
                    valueList.add(value.toString());
                    if (!isDateField) continue;
                    captions.add(format.format((LocalDateTime)value));
                }
                Color[] colors = valueList.size() <= 13 ? LegendManage.createRainBowColors((int)valueList.size()) : LegendManage.createRandomColors((int)valueList.size());
                Color[] newcolors = new Color[colors.length + 1];
                newcolors[0] = Color.white;
                for (int i = 1; i < newcolors.length; ++i) {
                    newcolors[i] = colors[i - 1];
                }
                aLS = isDateField ? LegendManage.createUniqValueLegendScheme(valueList, captions, (Color[])newcolors, (ShapeTypes)aST, (double)min, (double)max, (boolean)aLS.getHasNoData(), (double)aLS.getUndefValue()) : LegendManage.createUniqValueLegendScheme(valueList, (Color[])newcolors, (ShapeTypes)aST, (double)min, (double)max, (boolean)aLS.getHasNoData(), (double)aLS.getUndefValue());
                aLS.setFieldName(fieldName);
                break;
            }
            case GRADUATED_COLOR: {
                double[] S = new double[this.getAttributeTable().getTable().getRows().size()];
                for (int i = 0; i < S.length; ++i) {
                    S[i] = Double.parseDouble(((DataRow)this.getAttributeTable().getTable().getRows().get(i)).getValue(fieldName).toString());
                }
                double[] minmax = MIMath.getMinMaxValue((double[])S, (double)aLS.getUndefValue());
                min = minmax[0];
                if (min == (max = minmax[1])) {
                    JOptionPane.showMessageDialog(null, "The values of all shapes are same!");
                    break;
                }
                double[] CValues = MIMath.getIntervalValues((double)min, (double)max);
                Color[] colors = LegendManage.createRainBowColors((int)(CValues.length + 1));
                aLS = LegendManage.createGraduatedLegendScheme((double[])CValues, (Color[])colors, (ShapeTypes)aST, (double)min, (double)max, (Boolean)aLS.getHasNoData(), (double)aLS.getUndefValue());
                aLS.setFieldName(fieldName);
            }
        }
        return aLS;
    }

    public void updateLegendScheme(LegendType aLT, String fieldName) {
        this.setLegendScheme(this.createLegendScheme(aLT, fieldName));
    }
}

