/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.nio.ByteOrder;

public enum NpyByteOrder {
    HARDWARE_NATIVE('='),
    LITTLE_ENDIAN('<'),
    BIG_ENDIAN('>'),
    NOT_APPLICABLE('|');

    private final char symbol;

    private NpyByteOrder(char symbol) {
        this.symbol = symbol;
    }

    public char symbol() {
        return this.symbol;
    }

    public static NpyByteOrder of(String description) {
        if (description == null) {
            return HARDWARE_NATIVE;
        }
        String s = description.trim();
        if (s.length() == 0) {
            return HARDWARE_NATIVE;
        }
        char c = s.charAt(0);
        for (NpyByteOrder v : NpyByteOrder.values()) {
            if (c != v.symbol) continue;
            return v;
        }
        return HARDWARE_NATIVE;
    }

    public ByteOrder toJava() {
        switch (this) {
            case BIG_ENDIAN: {
                return ByteOrder.BIG_ENDIAN;
            }
            case LITTLE_ENDIAN: {
                return ByteOrder.LITTLE_ENDIAN;
            }
        }
        return ByteOrder.nativeOrder();
    }

    public String toString() {
        return String.valueOf(this.symbol);
    }
}

