/*
 * This file is part of libbluray
 * Copyright (C) 2010  William Hahne
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package jail.org.dvb.lang;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.jar.Manifest;
import impl.org.dvb.lang.DVBClassLoaderImpl;

import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class DVBClassLoader extends java.security.SecureClassLoader {
    public static DVBClassLoader newInstance(final URL[] urls) {
        return (DVBClassLoader)AccessController.doPrivileged(
            new PrivilegedAction() {
                   public Object run() {
                       return new DVBClassLoaderImpl(urls);
                   }
            });
    }

    public static DVBClassLoader newInstance(final URL[] urls, final ClassLoader parent) {
        return (DVBClassLoader)AccessController.doPrivileged(
            new PrivilegedAction() {
                public Object run() {
                    return new DVBClassLoaderImpl(urls, parent);
                }
            });
    }

    public DVBClassLoader(final URL[] urls) {
        SecurityManager sm = glue.java.lang.System.getSecurityManager();
        if (sm != null)
            sm.checkCreateClassLoader();
        loader = (DVBURLClassLoader)AccessController.doPrivileged(
            new PrivilegedAction() {
                public Object run() {
                    return new DVBURLClassLoader(urls);
                }
            });
    }

    public DVBClassLoader(final URL[] urls, final ClassLoader parent) {
        super(parent);
        SecurityManager sm = glue.java.lang.System.getSecurityManager();
        if (sm != null)
            sm.checkCreateClassLoader();
        loader = (DVBURLClassLoader)AccessController.doPrivileged(
            new PrivilegedAction() {
                public Object run() {
                    return new DVBURLClassLoader(urls, parent);
                }
            });
    }

    public Class findClass(String name) throws ClassNotFoundException {
        return loader.findClass(name);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        return loader.definePackage(name, man, url);
    }

    protected URL findResource(String name) {
        return loader.findResource(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        return loader.findResources(name);
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        return loader.getPermissions(codesource);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return loader.loadClass(name, resolve);
    }

    protected static class DVBURLClassLoader extends URLClassLoader {
        public DVBURLClassLoader(URL[] urls) {
            super(urls);
        }

        public DVBURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
            return super.definePackage(name, man, url);
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            return super.getPermissions(codesource);
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }

    protected DVBURLClassLoader loader;
}
