/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.data.Direction;
import com.cburch.logisim.gui.menu.Menu;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorKeyStroke;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.MacCompatibility;
import com.cburch.logisim.util.Strings;
import com.cburch.logisim.util.WindowClosable;
import com.cburch.logisim.util.WindowMenuItem;
import com.cburch.logisim.util.WindowMenuItemManager;
import com.cburch.logisim.util.WindowMenuManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class WindowMenu
extends Menu {
    private static final long serialVersionUID = 1L;
    private final JFrame owner;
    private final MyListener myListener = new MyListener();
    private final JMenuItem minimize = new JMenuItem();
    private final JMenuItem zoom = new JMenuItem();
    private final JCheckBoxMenuItem toolbar = new JCheckBoxMenuItem();
    private final JMenuItem close = new JMenuItem();
    private final JRadioButtonMenuItem nullItem = new JRadioButtonMenuItem();
    private final ArrayList<WindowMenuItem> persistentItems = new ArrayList();
    private final ArrayList<WindowMenuItem> transientItems = new ArrayList();

    public WindowMenu(JFrame owner) {
        this.owner = owner;
        WindowMenuManager.addMenu(this);
        int menuMask = this.getToolkit().getMenuShortcutKeyMaskEx();
        this.minimize.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_WINDOW_MINIMIZE).getWithMask(0));
        this.close.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_WINDOW_CLOSE).getWithMask(0));
        AppPreferences.gui_sync_objects.add(this);
        if (owner == null) {
            this.minimize.setEnabled(false);
            this.zoom.setEnabled(false);
            this.close.setEnabled(false);
        } else {
            this.minimize.addActionListener(this.myListener);
            this.zoom.addActionListener(this.myListener);
            this.close.addActionListener(this.myListener);
        }
        this.toolbar.setEnabled(true);
        this.toolbar.setState(WindowMenu.isToolbarVisible());
        this.toolbar.addActionListener(this.myListener);
        AppPreferences.TOOLBAR_PLACEMENT.addPropertyChangeListener(this.myListener);
        this.computeEnabled();
        this.computeContents();
        LocaleManager.addLocaleListener(this.myListener);
        this.myListener.localeChanged();
    }

    @Override
    public void hotkeyUpdate() {
        this.minimize.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_WINDOW_MINIMIZE).getWithMask(0));
        this.close.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_WINDOW_CLOSE).getWithMask(0));
    }

    void addMenuItem(Object source, WindowMenuItem item, boolean isPersistent) {
        if (isPersistent) {
            this.persistentItems.add(item);
        } else {
            this.transientItems.add(item);
        }
        item.addActionListener(this.myListener);
        this.computeContents();
    }

    private void computeContents() {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        WindowMenuItemManager currentManager;
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.nullItem);
        this.removeAll();
        this.add(this.minimize);
        this.add(this.zoom);
        this.add(this.close);
        this.addSeparator();
        this.add(this.toolbar);
        if (!this.persistentItems.isEmpty()) {
            this.addSeparator();
            for (JRadioButtonMenuItem jRadioButtonMenuItem2 : this.persistentItems) {
                bgroup.add(jRadioButtonMenuItem2);
                this.add(jRadioButtonMenuItem2);
            }
        }
        if (!this.transientItems.isEmpty()) {
            this.addSeparator();
            for (JRadioButtonMenuItem jRadioButtonMenuItem3 : this.transientItems) {
                bgroup.add(jRadioButtonMenuItem3);
                this.add(jRadioButtonMenuItem3);
            }
        }
        if ((currentManager = WindowMenuManager.getCurrentManager()) != null && (jRadioButtonMenuItem = currentManager.getMenuItem(this)) != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    @Override
    protected void computeEnabled() {
        WindowMenuItemManager currentManager = WindowMenuManager.getCurrentManager();
        this.minimize.setEnabled(currentManager != null);
        this.zoom.setEnabled(currentManager != null);
        this.close.setEnabled(currentManager != null);
    }

    void doClose() {
        JFrame jFrame = this.owner;
        if (jFrame instanceof WindowClosable) {
            WindowClosable windowClosable = (WindowClosable)((Object)jFrame);
            windowClosable.requestClose();
        } else if (this.owner != null) {
            int action = this.owner.getDefaultCloseOperation();
            if (action == 3) {
                System.exit(0);
            } else if (action == 1) {
                this.owner.setVisible(false);
            } else if (action == 2) {
                this.owner.dispose();
            }
        }
    }

    void doMinimize() {
        if (this.owner != null) {
            this.owner.setExtendedState(1);
        }
    }

    void doZoom() {
        if (this.owner == null) {
            return;
        }
        this.owner.pack();
        Dimension screenSize = this.owner.getToolkit().getScreenSize();
        Dimension windowSize = this.owner.getPreferredSize();
        Point windowLoc = this.owner.getLocation();
        boolean locChanged = false;
        boolean sizeChanged = false;
        if (windowLoc.x + windowSize.width > screenSize.width) {
            windowLoc.x = Math.max(0, screenSize.width - windowSize.width);
            locChanged = true;
            if (windowLoc.x + windowSize.width > screenSize.width) {
                windowSize.width = screenSize.width - windowLoc.x;
                sizeChanged = true;
            }
        }
        if (windowLoc.y + windowSize.height > screenSize.height) {
            windowLoc.y = Math.max(0, screenSize.height - windowSize.height);
            locChanged = true;
            if (windowLoc.y + windowSize.height > screenSize.height) {
                windowSize.height = screenSize.height - windowLoc.y;
                sizeChanged = true;
            }
        }
        if (locChanged) {
            this.owner.setLocation(windowLoc);
        }
        if (sizeChanged) {
            this.owner.setSize(windowSize);
        }
    }

    void removeMenuItem(Object source, JRadioButtonMenuItem item) {
        if (this.transientItems.remove(item)) {
            item.removeActionListener(this.myListener);
        }
        this.computeContents();
    }

    void setNullItemSelected(boolean value) {
        this.nullItem.setSelected(value);
    }

    static boolean isToolbarVisible() {
        String loc = AppPreferences.TOOLBAR_PLACEMENT.get();
        return loc == null || !loc.equals("hidden");
    }

    static void setToolbarVisibility(boolean show) {
        if (show) {
            AppPreferences.TOOLBAR_PLACEMENT.set(Direction.NORTH.toString());
        } else {
            AppPreferences.TOOLBAR_PLACEMENT.set("hidden");
        }
    }

    void doToolbar() {
        WindowMenu.setToolbarVisibility(this.toolbar.getState());
    }

    private class MyListener
    implements LocaleListener,
    ActionListener,
    PropertyChangeListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowMenuItem choice;
            Object src = e.getSource();
            if (src == WindowMenu.this.minimize) {
                WindowMenu.this.doMinimize();
            } else if (src == WindowMenu.this.zoom) {
                WindowMenu.this.doZoom();
            } else if (src == WindowMenu.this.close) {
                WindowMenu.this.doClose();
            } else if (src == WindowMenu.this.toolbar) {
                WindowMenu.this.doToolbar();
            } else if (src instanceof WindowMenuItem && (choice = (WindowMenuItem)src).isSelected()) {
                WindowMenuItem item = this.findOwnerItem();
                if (item != null) {
                    item.setSelected(true);
                }
                choice.actionPerformed(e);
            }
        }

        private WindowMenuItem findOwnerItem() {
            for (WindowMenuItem i : WindowMenu.this.persistentItems) {
                if (i.getJFrame() != WindowMenu.this.owner) continue;
                return i;
            }
            for (WindowMenuItem i : WindowMenu.this.transientItems) {
                if (i.getJFrame() != WindowMenu.this.owner) continue;
                return i;
            }
            return null;
        }

        @Override
        public void localeChanged() {
            WindowMenu.this.setText(Strings.S.get("windowMenu"));
            WindowMenu.this.minimize.setText(Strings.S.get("windowMinimizeItem"));
            WindowMenu.this.close.setText(Strings.S.get("windowCloseItem"));
            WindowMenu.this.zoom.setText(MacCompatibility.isQuitAutomaticallyPresent() ? Strings.S.get("windowZoomItemMac") : Strings.S.get("windowZoomItem"));
            WindowMenu.this.toolbar.setText(Strings.S.get("windowShowToolbarItem"));
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (AppPreferences.TOOLBAR_PLACEMENT.isSource(event)) {
                WindowMenu.this.toolbar.setState(WindowMenu.isToolbarVisible());
            }
        }
    }
}

