/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.prefs.AppPreferences;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;

public final class JFileChoosers {
    private static final String[] PROP_NAMES = new String[]{null, "user.home", "user.dir", "java.home", "java.io.tmpdir"};
    private static String currentDirectory = "";

    private JFileChoosers() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static JFileChooser create() {
        RuntimeException first = null;
        for (String prop : PROP_NAMES) {
            try {
                String dirname;
                if (prop == null) {
                    dirname = currentDirectory;
                    if ("".equals(dirname)) {
                        dirname = AppPreferences.DIALOG_DIRECTORY.get();
                    }
                } else {
                    dirname = System.getProperty(prop);
                }
                if ("".equals(dirname)) {
                    return new LogisimFileChooser();
                }
                File dir = new File(dirname);
                if (!dir.canRead()) continue;
                return new LogisimFileChooser(dir);
            }
            catch (RuntimeException t) {
                Throwable u;
                if (first == null) {
                    first = t;
                }
                if ((u = t.getCause()) instanceof IOException) continue;
                throw t;
            }
        }
        throw first;
    }

    public static JFileChooser createAt(File openDirectory) {
        if (openDirectory == null) {
            return JFileChoosers.create();
        }
        try {
            return new LogisimFileChooser(openDirectory);
        }
        catch (RuntimeException t) {
            if (t.getCause() instanceof IOException) {
                try {
                    return JFileChoosers.create();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            throw t;
        }
    }

    public static JFileChooser createSelected(File selected) {
        if (selected == null) {
            return JFileChoosers.create();
        }
        if (selected.isDirectory()) {
            return JFileChoosers.createAt(selected);
        }
        JFileChooser ret = JFileChoosers.createAt(selected.getParentFile());
        ret.setSelectedFile(selected);
        return ret;
    }

    public static String getCurrentDirectory() {
        return currentDirectory;
    }

    private static class LogisimFileChooser
    extends JFileChooser {
        private static final long serialVersionUID = 1L;

        LogisimFileChooser() {
        }

        LogisimFileChooser(File initSelected) {
            super(initSelected);
        }

        @Override
        public File getSelectedFile() {
            File dir = this.getCurrentDirectory();
            if (dir != null) {
                currentDirectory = dir.toString();
            }
            return super.getSelectedFile();
        }
    }
}

