/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class InputEventUtil {
    public static final String CTRL = "Ctrl";
    public static final String SHIFT = "Shift";
    public static final String ALT = "Alt";
    public static final String BUTTON1 = "Button1";
    public static final String BUTTON2 = "Button2";
    public static final String BUTTON3 = "Button3";

    private InputEventUtil() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static int fromDisplayString(String str) {
        int ret = 0;
        StringTokenizer toks = new StringTokenizer(str);
        while (toks.hasMoreTokens()) {
            String s = toks.nextToken();
            if (s.equals(Strings.S.get("ctrlMod"))) {
                ret |= 0x80;
                continue;
            }
            if (s.equals(Strings.S.get("altMod"))) {
                ret |= 0x200;
                continue;
            }
            if (s.equals(Strings.S.get("shiftMod"))) {
                ret |= 0x40;
                continue;
            }
            if (s.equals(Strings.S.get("button1Mod"))) {
                ret |= 0x400;
                continue;
            }
            if (s.equals(Strings.S.get("button2Mod"))) {
                ret |= 0x800;
                continue;
            }
            if (s.equals(Strings.S.get("button3Mod"))) {
                ret |= 0x1000;
                continue;
            }
            throw new NumberFormatException("InputEventUtil");
        }
        return ret;
    }

    private static int parseInput(String s) {
        return switch (s) {
            case CTRL -> 128;
            case SHIFT -> 64;
            case ALT -> 512;
            case BUTTON1 -> 1024;
            case BUTTON2 -> 2048;
            case BUTTON3 -> 4096;
            default -> throw new NumberFormatException("InputEventUtil");
        };
    }

    public static int fromString(String str) {
        int ret = 0;
        StringTokenizer toks = new StringTokenizer(str);
        while (toks.hasMoreTokens()) {
            String s = toks.nextToken();
            ret |= InputEventUtil.parseInput(s);
        }
        return ret;
    }

    public static String toDisplayString(int mods) {
        ArrayList<String> arr = new ArrayList<String>();
        if ((mods & 0x80) != 0) {
            arr.add(Strings.S.get("ctrlMod"));
        }
        if ((mods & 0x200) != 0) {
            arr.add(Strings.S.get("altMod"));
        }
        if ((mods & 0x40) != 0) {
            arr.add(Strings.S.get("shiftMod"));
        }
        if ((mods & 0x400) != 0) {
            arr.add(Strings.S.get("button1Mod"));
        }
        if ((mods & 0x800) != 0) {
            arr.add(Strings.S.get("button2Mod"));
        }
        if ((mods & 0x1000) != 0) {
            arr.add(Strings.S.get("button3Mod"));
        }
        if (arr.isEmpty()) {
            return "";
        }
        Iterator it = arr.iterator();
        if (it.hasNext()) {
            StringBuilder ret = new StringBuilder();
            ret.append((String)it.next());
            while (it.hasNext()) {
                ret.append(" ");
                ret.append((String)it.next());
            }
            return ret.toString();
        }
        return "";
    }

    public static String toKeyDisplayString(int mods) {
        Iterator it;
        ArrayList<String> arr = new ArrayList<String>();
        if ((mods & 0x100) != 0) {
            arr.add(Strings.S.get("metaMod"));
        }
        if ((mods & 0x80) != 0) {
            arr.add(Strings.S.get("ctrlMod"));
        }
        if ((mods & 0x200) != 0) {
            arr.add(Strings.S.get("altMod"));
        }
        if ((mods & 0x40) != 0) {
            arr.add(Strings.S.get("shiftMod"));
        }
        if ((it = arr.iterator()).hasNext()) {
            StringBuilder ret = new StringBuilder();
            ret.append((String)it.next());
            while (it.hasNext()) {
                ret.append(" ");
                ret.append((String)it.next());
            }
            return ret.toString();
        }
        return "";
    }

    public static String toString(int mods) {
        Iterator it;
        ArrayList<String> arr = new ArrayList<String>();
        if ((mods & 0x80) != 0) {
            arr.add(CTRL);
        }
        if ((mods & 0x200) != 0) {
            arr.add(ALT);
        }
        if ((mods & 0x40) != 0) {
            arr.add(SHIFT);
        }
        if ((mods & 0x400) != 0) {
            arr.add(BUTTON1);
        }
        if ((mods & 0x800) != 0) {
            arr.add(BUTTON2);
        }
        if ((mods & 0x1000) != 0) {
            arr.add(BUTTON3);
        }
        if ((it = arr.iterator()).hasNext()) {
            StringBuilder ret = new StringBuilder();
            ret.append((String)it.next());
            while (it.hasNext()) {
                ret.append(" ");
                ret.append((String)it.next());
            }
            return ret.toString();
        }
        return "";
    }
}

