/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import java.awt.Color;

public final class ColorUtil {
    private ColorUtil() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static Color getComplementaryColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static Color getComplementaryBlackWhite(Color color) {
        int Y = ColorUtil.getLuminance(color) > 128 ? 0 : 255;
        return new Color(Y, Y, Y);
    }

    public static int getLuminance(Color color) {
        return (int)(0.2126 * (double)color.getRed() + 0.7152 * (double)color.getGreen() + 0.0722 * (double)color.getBlue());
    }

    public static Color toGrayscale(Color color) {
        int Y = ColorUtil.getLuminance(color);
        return new Color(Y, Y, Y);
    }
}

