/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools.move;

import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.tools.move.Connector;
import com.cburch.logisim.tools.move.MoveGesture;
import com.cburch.logisim.tools.move.MoveRequest;
import com.cburch.logisim.tools.move.MoveResult;
import com.cburch.logisim.util.UniquelyNamedThread;

public final class ConnectorThread
extends UniquelyNamedThread {
    private static final ConnectorThread INSTANCE = new ConnectorThread();
    private final Object lock = new Object();
    private transient boolean overrideRequest = false;
    private MoveRequest nextRequest = null;
    private MoveRequest processingRequest;

    private ConnectorThread() {
        super("tools-move-ConnectorThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueueRequest(MoveRequest req, boolean priority) {
        Object object = ConnectorThread.INSTANCE.lock;
        synchronized (object) {
            if (!req.equals(ConnectorThread.INSTANCE.processingRequest)) {
                ConnectorThread.INSTANCE.nextRequest = req;
                ConnectorThread.INSTANCE.overrideRequest = priority;
                ConnectorThread.INSTANCE.lock.notifyAll();
            }
        }
    }

    public static boolean isOverrideRequested() {
        return ConnectorThread.INSTANCE.overrideRequest;
    }

    public boolean isAbortRequested() {
        return this.overrideRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            boolean wasOverride;
            MoveRequest req;
            Object object = this.lock;
            synchronized (object) {
                this.processingRequest = null;
                while (this.nextRequest == null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                req = this.nextRequest;
                wasOverride = this.overrideRequest;
                this.nextRequest = null;
                this.overrideRequest = false;
                this.processingRequest = req;
            }
            try {
                MoveResult result = Connector.computeWires(req);
                if (result == null) continue;
                MoveGesture gesture = req.getMoveGesture();
                gesture.notifyResult(req, result);
                continue;
            }
            catch (Exception t) {
                t.printStackTrace();
                if (!wasOverride) continue;
                MoveResult result = new MoveResult(req, new ReplacementMap(), req.getMoveGesture().getConnections(), 0);
                req.getMoveGesture().notifyResult(req, result);
                continue;
            }
            break;
        }
    }

    static {
        INSTANCE.start();
    }
}

