/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools.key;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.tools.key.KeyConfigurationEvent;
import com.cburch.logisim.tools.key.KeyConfigurationResult;
import com.cburch.logisim.tools.key.KeyConfigurator;
import java.awt.event.KeyEvent;

public abstract class NumericConfigurator<V>
implements KeyConfigurator,
Cloneable {
    private static final int maxTimeKeyLasts = 800;
    private final Attribute<V> attr;
    private final long minValue;
    private final long maxValue;
    private long curValue;
    private final int radix;
    private final int modsEx;
    private long whenTyped;

    public NumericConfigurator(Attribute<V> attr, long min, long max, int modifiersEx) {
        this(attr, min, max, modifiersEx, 10);
    }

    public NumericConfigurator(Attribute<V> attr, long min, long max, int modifiersEx, int radix) {
        this.attr = attr;
        this.minValue = min;
        this.maxValue = max;
        this.radix = radix;
        this.modsEx = modifiersEx;
        this.curValue = 0L;
        this.whenTyped = 0L;
    }

    @Override
    public NumericConfigurator<V> clone() {
        try {
            NumericConfigurator ret = (NumericConfigurator)super.clone();
            ret.whenTyped = 0L;
            ret.curValue = 0L;
            return ret;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract V createValue(long var1);

    protected long getMaximumValue(AttributeSet attrs) {
        return this.maxValue;
    }

    protected long getMinimumValue(AttributeSet attrs) {
        return this.minValue;
    }

    @Override
    public KeyConfigurationResult keyEventReceived(KeyConfigurationEvent event) {
        KeyEvent e;
        int digit;
        if (event.getType() == 2 && (digit = Character.digit((e = event.getKeyEvent()).getKeyChar(), this.radix)) >= 0 && e.getModifiersEx() == this.modsEx) {
            long now = System.currentTimeMillis();
            long sinceLast = now - this.whenTyped;
            AttributeSet attrs = event.getAttributeSet();
            long min = this.getMinimumValue(attrs);
            long max = this.getMaximumValue(attrs);
            long val = 0L;
            if (sinceLast < 800L && (val = (long)this.radix * this.curValue) > max) {
                val = 0L;
            }
            if ((val += (long)digit) > max && (val = (long)digit) > max) {
                return null;
            }
            event.consume();
            this.whenTyped = now;
            this.curValue = val;
            if (val >= min) {
                V valObj = this.createValue(val);
                return new KeyConfigurationResult(event, this.attr, valObj);
            }
        }
        return null;
    }
}

