/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.IconsUtil;
import com.cburch.logisim.util.LibraryUtil;
import com.cburch.logisim.util.StringGetter;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryDescription {
    static final Logger logger = LoggerFactory.getLogger(FactoryDescription.class);
    private final StringGetter displayName;
    private String iconName;
    private boolean iconLoadAttempted;
    private Icon icon;
    private final Class factoryClass;
    private boolean factoryLoadAttempted;
    private ComponentFactory factory;
    private StringGetter toolTip;

    public FactoryDescription(Class<? extends ComponentFactory> factoryClass, StringGetter displayName, Icon icon) {
        this(factoryClass, displayName);
    }

    public FactoryDescription(Class<? extends ComponentFactory> factoryClass, StringGetter displayName, String iconName) {
        this(factoryClass, displayName);
        this.iconName = iconName;
        this.iconLoadAttempted = false;
        this.icon = null;
    }

    public FactoryDescription(Class<? extends ComponentFactory> factoryClass, StringGetter displayName) {
        this.displayName = displayName;
        this.iconName = "???";
        this.iconLoadAttempted = true;
        this.icon = null;
        this.factoryClass = factoryClass;
        this.factoryLoadAttempted = false;
        this.factory = null;
        this.toolTip = null;
    }

    public static List<Tool> getTools(Class<? extends Library> base, FactoryDescription[] descriptions) {
        Tool[] tools = new Tool[descriptions.length];
        for (int i = 0; i < tools.length; ++i) {
            tools[i] = new AddTool(base, descriptions[i]);
        }
        return Arrays.asList(tools);
    }

    public String getDisplayName() {
        return this.displayName.toString();
    }

    public ComponentFactory getFactory(Class<? extends Library> libraryClass) {
        ComponentFactory ret = this.factory;
        if (this.factory != null || this.factoryLoadAttempted) {
            return ret;
        }
        Object errorMsg = "";
        try {
            errorMsg = "Getting class loader";
            ClassLoader loader = this.factoryClass.getClassLoader();
            errorMsg = "Loading class";
            Class<?> factoryCls = loader.loadClass(this.factoryClass.getCanonicalName());
            errorMsg = "Creating instance";
            Object factoryValue = factoryCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            errorMsg = "Converting to ComponentFactory";
            this.factory = (ComponentFactory)factoryValue;
            this.factoryLoadAttempted = true;
            return this.factory;
        }
        catch (Exception t) {
            String name = t.getClass().getName();
            String m = t.getMessage();
            errorMsg = (String)errorMsg + ": " + name;
            if (m != null) {
                errorMsg = (String)errorMsg + ": " + m;
            }
            logger.error("Error while {}", errorMsg);
            this.factory = null;
            this.factoryLoadAttempted = true;
            return null;
        }
    }

    public Icon getIcon() {
        Icon ret = this.icon;
        if (ret == null && !this.iconLoadAttempted) {
            this.icon = ret = IconsUtil.getIcon(this.iconName);
            this.iconLoadAttempted = true;
        }
        return ret;
    }

    public String getName() {
        return LibraryUtil.getName(this.factoryClass);
    }

    public String getToolTip() {
        StringGetter getter = this.toolTip;
        return getter == null ? null : getter.toString();
    }

    public boolean isFactoryLoaded() {
        return this.factoryLoadAttempted;
    }

    public FactoryDescription setToolTip(StringGetter getter) {
        this.toolTip = getter;
        return this;
    }
}

