/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractGateHdlGenerator;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics;

public class Ttl7432
extends AbstractTtlGate {
    public static final String _ID = "7432";

    public Ttl7432() {
        super(_ID, (byte)14, new byte[]{3, 6, 8, 11}, true, (HdlGeneratorFactory)new OrGateHdlGeneratorFactory());
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics g = painter.getGraphics();
        int portwidth = 14;
        int portheight = 15;
        int youtput = y + (up ? 20 : 40);
        Drawgates.paintOr(g, x + 40, youtput, 14, 15, false, false);
        Drawgates.paintOutputgate(g, x + 50, y, x + 40, youtput, up, height);
        Drawgates.paintDoubleInputgate(g, x + 30, y, x + 40 - 14, youtput, 15, up, false, height);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        int i;
        for (i = 2; i < 6; i += 3) {
            state.setPort(i, state.getPortValue(i - 1).or(state.getPortValue(i - 2)), 1);
        }
        for (i = 6; i < 12; i += 3) {
            state.setPort(i, state.getPortValue(i + 1).or(state.getPortValue(i + 2)), 1);
        }
    }

    private static class OrGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private OrGateHdlGeneratorFactory() {
        }

        @Override
        public LineBuffer getLogicFunction(int index) {
            return LineBuffer.getHdlBuffer().add("{{assign}}gateO{{1}}{{=}}gateA{{1}}{{or}}gateB{{1}};", index);
        }
    }
}

