/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class Ttl74175HdlGenerator
extends AbstractHdlGeneratorFactory {
    public Ttl74175HdlGenerator() {
        this.myWires.addWire("curState", 4).addWire("nextState", 4);
        this.myPorts.add("clock", "clock", 1, 7).add("input", "nCLR", 1, 0).add("input", "D1", 1, 3).add("input", "D2", 1, 4).add("input", "D3", 1, 10).add("input", "D4", 1, 11).add("output", "nQ1", 1, 2).add("output", "Q1", 1, 1).add("output", "nQ2", 1, 5).add("output", "Q2", 1, 6).add("output", "nQ3", 1, 9).add("output", "Q3", 1, 8).add("output", "nQ4", 1, 12).add("output", "Q4", 1, 13);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("CLK", "clock").pair("tick", "tick");
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("nextState <= curState {{when}} {{tick}} = '0' {{else}}\n             D4&D3&D2&D1;\n\ndffs : {{process}}({{CLK}}, nCLR) {{is}}\n   {{begin}}\n      {{if}} (nCLR = '0') {{then}} curState <= \"0000\";\n      {{elsif}} (rising_edge({{CLK}})) {{then}}\n         curState <= nextState;\n      {{end}} {{if}};\n   {{end}} {{process}} dffs;\n\nnQ1 <= {{not}}(curState(0));\nQ1  <= curState(0);\nnQ2 <= {{not}}(curState(1));\nQ2  <= curState(1);\nnQ3 <= {{not}}(curState(2));\nQ3  <= curState(2);\nnQ4 <= {{not}}(curState(3));\nQ4  <= curState(3);\")\n");
        } else {
            contents.add("assign nextState = tick == 0 ? curState : {D4, D3, D2, D1};\nassign nQ1       = ~curState[0];\nassign Q1        = curState[0];\nassign nQ2       = ~curState[1];\nassign Q2        = curState[1];\nassign nQ3       = ~curState[2];\nassign Q3        = curState[2];\nassign nQ4       = ~curState[3];\nassign Q4        = curState[3];\n\nalways @(posedge {{CLK}} or negedge nCLR)\nbegin\n   if (~nCLR) curState <= 0;\n   else curState <= nextState;\nend\n");
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

