/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class Ttl74165HdlGenerator
extends AbstractHdlGeneratorFactory {
    public Ttl74165HdlGenerator() {
        this.myWires.addWire("curState", 8).addWire("nextState", 8).addWire("parData", 8).addWire("enable", 1);
        this.myPorts.add("clock", "clock", 1, 1).add("input", "SHnLD", 1, 0).add("input", "CKIh", 1, 13).add("input", "SER", 1, 8).add("input", "P0", 1, 9).add("input", "P1", 1, 10).add("input", "P2", 1, 11).add("input", "P3", 1, 12).add("input", "P4", 1, 2).add("input", "P5", 1, 3).add("input", "P6", 1, 4).add("input", "P7", 1, 5).add("output", "Q7", 1, 6).add("output", "Q7n", 1, 7);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("CK", "clock").pair("Tick", "tick");
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("Q7  <= curState(0);\nQ7n <= {{not}}(curState(0));\n\nenable  <= {{not}}(CKIh) {{and}} {{Tick}};\nparData <= P0&P1&P2&P3&P4&P5&P6&P7;\n\nnextState <= curState {{when}} enable = '0' {{else}}\n             parData {{when}} SHnLD = '0' {{else}}\n             SER&curState(7 DOWNTO 1);\n\ndffs : {{process}}({{CK}}) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{CK}})) {{then}} curState <= nextState;\n   {{end}} {{if}};\n{{end}} {{process}} dffs;\n");
        } else {
            contents.add("assign Q7        = curState[0];\nassign Q7n       = ~curState[0];\nassign enable    = ~CKIh & {{tick}};\nassign parData   = {P0, P1, P2, P3, P4, P5, P6, P7};\nassign nextState = SHnLD == 0 ? parData :\n                   enable == 0 ? curState : {SER, curState[7:1]};\nalways @(posedge {{CLK}})\nbegin\n   curState = nextState;\nend\n");
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

